/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.Set;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.CryptoPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    public static final String PROPERTY_TLS_LEGACY_ALGS = "jdk.tls.legacyAlgorithms";
    private final String[] legacyAlgorithms;

    public LegacyAlgorithmConstraints(String string, AlgorithmDecomposer algorithmDecomposer) {
        super(algorithmDecomposer);
        this.legacyAlgorithms = LegacyAlgorithmConstraints.getAlgorithms(string);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        return LegacyAlgorithmConstraints.checkAlgorithm(this.legacyAlgorithms, string, this.decomposer);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, Key key) {
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        return LegacyAlgorithmConstraints.checkAlgorithm(this.legacyAlgorithms, string, this.decomposer);
    }
}

