/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.X500Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AVAKeyword {
    private static final Map<ObjectIdentifier, AVAKeyword> oidMap = new HashMap<ObjectIdentifier, AVAKeyword>();
    private static final Map<String, AVAKeyword> keywordMap = new HashMap<String, AVAKeyword>();
    private String keyword;
    private ObjectIdentifier oid;
    private boolean rfc1779Compliant;
    private boolean rfc2253Compliant;

    private AVAKeyword(String string, ObjectIdentifier objectIdentifier, boolean bl, boolean bl2) {
        this.keyword = string;
        this.oid = objectIdentifier;
        this.rfc1779Compliant = bl;
        this.rfc2253Compliant = bl2;
        oidMap.put(objectIdentifier, this);
        keywordMap.put(string, this);
    }

    private boolean isCompliant(int n) {
        switch (n) {
            case 2: {
                return this.rfc1779Compliant;
            }
            case 3: {
                return this.rfc2253Compliant;
            }
            case 1: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid standard " + n);
    }

    static ObjectIdentifier getOID(String string, int n) throws IOException {
        return AVAKeyword.getOID(string, n, Collections.<String, String>emptyMap());
    }

    static ObjectIdentifier getOID(String string, int n, Map<String, String> map) throws IOException {
        char c;
        String string2;
        string = string.toUpperCase(Locale.ENGLISH);
        if (n == 3) {
            if (string.startsWith(" ") || string.endsWith(" ")) {
                throw new IOException("Invalid leading or trailing space in keyword \"" + string + "\"");
            }
        } else {
            string = string.trim();
        }
        if ((string2 = map.get(string)) == null) {
            AVAKeyword aVAKeyword = keywordMap.get(string);
            if (aVAKeyword != null && aVAKeyword.isCompliant(n)) {
                return aVAKeyword.oid;
            }
        } else {
            return new ObjectIdentifier(string2);
        }
        if (n == 2) {
            if (!string.startsWith("OID.")) {
                throw new IOException("Invalid RFC1779 keyword: " + string);
            }
            string = string.substring(4);
        } else if (n == 1 && string.startsWith("OID.")) {
            string = string.substring(4);
        }
        boolean bl = false;
        if (string.length() != 0 && (c = string.charAt(0)) >= '0' && c <= '9') {
            bl = true;
        }
        if (!bl) {
            throw new IOException("Invalid keyword \"" + string + "\"");
        }
        return new ObjectIdentifier(string);
    }

    static String getKeyword(ObjectIdentifier objectIdentifier, int n) {
        return AVAKeyword.getKeyword(objectIdentifier, n, Collections.<String, String>emptyMap());
    }

    static String getKeyword(ObjectIdentifier objectIdentifier, int n, Map<String, String> map) {
        String string = objectIdentifier.toString();
        String string2 = map.get(string);
        if (string2 == null) {
            AVAKeyword aVAKeyword = oidMap.get(objectIdentifier);
            if (aVAKeyword != null && aVAKeyword.isCompliant(n)) {
                return aVAKeyword.keyword;
            }
        } else {
            if (string2.length() == 0) {
                throw new IllegalArgumentException("keyword cannot be empty");
            }
            char c = (string2 = string2.trim()).charAt(0);
            if (c < 'A' || c > 'z' || c > 'Z' && c < 'a') {
                throw new IllegalArgumentException("keyword does not start with letter");
            }
            for (int i = 1; i < string2.length(); ++i) {
                c = string2.charAt(i);
                if (c >= 'A' && c <= 'z' && (c <= 'Z' || c >= 'a') || c >= '0' && c <= '9' || c == '_') continue;
                throw new IllegalArgumentException("keyword character is not a letter, digit, or underscore");
            }
            return string2;
        }
        if (n == 3) {
            return string;
        }
        return "OID." + string;
    }

    static boolean hasKeyword(ObjectIdentifier objectIdentifier, int n) {
        AVAKeyword aVAKeyword = oidMap.get(objectIdentifier);
        if (aVAKeyword == null) {
            return false;
        }
        return aVAKeyword.isCompliant(n);
    }

    static {
        new AVAKeyword("CN", X500Name.commonName_oid, true, true);
        new AVAKeyword("C", X500Name.countryName_oid, true, true);
        new AVAKeyword("L", X500Name.localityName_oid, true, true);
        new AVAKeyword("S", X500Name.stateName_oid, false, false);
        new AVAKeyword("ST", X500Name.stateName_oid, true, true);
        new AVAKeyword("O", X500Name.orgName_oid, true, true);
        new AVAKeyword("OU", X500Name.orgUnitName_oid, true, true);
        new AVAKeyword("T", X500Name.title_oid, false, false);
        new AVAKeyword("IP", X500Name.ipAddress_oid, false, false);
        new AVAKeyword("STREET", X500Name.streetAddress_oid, true, true);
        new AVAKeyword("DC", X500Name.DOMAIN_COMPONENT_OID, false, true);
        new AVAKeyword("DNQUALIFIER", X500Name.DNQUALIFIER_OID, false, false);
        new AVAKeyword("DNQ", X500Name.DNQUALIFIER_OID, false, false);
        new AVAKeyword("SURNAME", X500Name.SURNAME_OID, false, false);
        new AVAKeyword("GIVENNAME", X500Name.GIVENNAME_OID, false, false);
        new AVAKeyword("INITIALS", X500Name.INITIALS_OID, false, false);
        new AVAKeyword("GENERATION", X500Name.GENERATIONQUALIFIER_OID, false, false);
        new AVAKeyword("EMAIL", PKCS9Attribute.EMAIL_ADDRESS_OID, false, false);
        new AVAKeyword("EMAILADDRESS", PKCS9Attribute.EMAIL_ADDRESS_OID, false, false);
        new AVAKeyword("UID", X500Name.userid_oid, false, true);
        new AVAKeyword("SERIALNUMBER", X500Name.SERIALNUMBER_OID, false, false);
    }
}

