/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificatePoliciesExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.CertificatePolicies";
    public static final String NAME = "CertificatePolicies";
    public static final String POLICIES = "policies";
    private List<PolicyInformation> certPolicies;

    private void encodeThis() throws IOException {
        if (this.certPolicies == null || this.certPolicies.isEmpty()) {
            this.extensionValue = null;
        } else {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            for (PolicyInformation policyInformation : this.certPolicies) {
                policyInformation.encode(derOutputStream2);
            }
            derOutputStream.write((byte)48, derOutputStream2);
            this.extensionValue = derOutputStream.toByteArray();
        }
    }

    public CertificatePoliciesExtension(List<PolicyInformation> list) throws IOException {
        this(Boolean.FALSE, list);
    }

    public CertificatePoliciesExtension(Boolean bl, List<PolicyInformation> list) throws IOException {
        this.certPolicies = list;
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = bl;
        this.encodeThis();
    }

    public CertificatePoliciesExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.CertificatePolicies_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for CertificatePoliciesExtension.");
        }
        this.certPolicies = new ArrayList<PolicyInformation>();
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            PolicyInformation policyInformation = new PolicyInformation(derValue2);
            this.certPolicies.add(policyInformation);
        }
    }

    @Override
    public String toString() {
        if (this.certPolicies == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("CertificatePolicies [\n");
        for (PolicyInformation policyInformation : this.certPolicies) {
            stringBuilder.append(policyInformation.toString());
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CertificatePolicies_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    @Override
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(POLICIES)) {
            if (!(object instanceof List)) {
                throw new IOException("Attribute value should be of type List.");
            }
        } else {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CertificatePoliciesExtension.");
        }
        this.certPolicies = (List)object;
        this.encodeThis();
    }

    @Override
    public List<PolicyInformation> get(String string) throws IOException {
        if (string.equalsIgnoreCase(POLICIES)) {
            return this.certPolicies;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CertificatePoliciesExtension.");
    }

    @Override
    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(POLICIES)) {
            throw new IOException("Attribute name [" + string + "] not recognized by " + "CertAttrSet:CertificatePoliciesExtension.");
        }
        this.certPolicies = null;
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(POLICIES);
        return attributeNameEnumeration.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

