/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.print.PrinterGraphics;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.font.FontDesignMetrics;
import sun.font.FontManager;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.ProxyPrintGraphics;
import sun.swing.ImageIconUIResource;
import sun.swing.PrintColorUIResource;
import sun.swing.StringUIClientPropertyKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtilities2 {
    public static final Object LAF_STATE_KEY = new Object();
    private static final int STRONG_BEARING_CACHE_SIZE = 10;
    private static BearingCacheEntry[] strongBearingCache = new BearingCacheEntry[10];
    private static int strongBearingCacheNextIndex = 0;
    private static Set<SoftReference<BearingCacheEntry>> softBearingCache = new HashSet<SoftReference<BearingCacheEntry>>();
    public static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);
    public static final Object AA_TEXT_PROPERTY_KEY = new Object();
    private static final Object SKIP_CLICK_COUNT = new Object();
    public static final Object COMPONENT_UI_PROPERTY_KEY = new Object();
    public static final StringUIClientPropertyKey BASICMENUITEMUI_MAX_TEXT_OFFSET = new StringUIClientPropertyKey("maxTextOffset");
    private static Field inputEvent_CanAccessSystemClipboard_Field = null;
    private static final String UntrustedClipboardAccess = "UNTRUSTED_CLIPBOARD_ACCESS_KEY";
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock = new Object();
    private static char[] charsBuffer = new char[100];

    public static final boolean isComplexLayout(char[] cArray, int n, int n2) {
        return FontManager.isComplexText(cArray, n, n2);
    }

    public static AATextInfo drawTextAntialiased(JComponent jComponent) {
        if (jComponent != null) {
            return (AATextInfo)jComponent.getClientProperty(AA_TEXT_PROPERTY_KEY);
        }
        return null;
    }

    public static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return SwingUtilities2.getLeftSideBearing(jComponent, fontMetrics, string.charAt(0));
    }

    public static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, char c) {
        return SwingUtilities2.getBearing(jComponent, fontMetrics, c, true);
    }

    public static int getRightSideBearing(JComponent jComponent, FontMetrics fontMetrics, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return SwingUtilities2.getRightSideBearing(jComponent, fontMetrics, string.charAt(string.length() - 1));
    }

    public static int getRightSideBearing(JComponent jComponent, FontMetrics fontMetrics, char c) {
        return SwingUtilities2.getBearing(jComponent, fontMetrics, c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getBearing(JComponent jComponent, FontMetrics fontMetrics, char c, boolean bl) {
        if (fontMetrics == null) {
            if (jComponent == null) {
                return 0;
            }
            fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        }
        Class<SwingUtilities2> clazz = SwingUtilities2.class;
        synchronized (SwingUtilities2.class) {
            BearingCacheEntry bearingCacheEntry = null;
            BearingCacheEntry bearingCacheEntry2 = new BearingCacheEntry(fontMetrics);
            for (BearingCacheEntry bearingCacheEntry3 : strongBearingCache) {
                if (!bearingCacheEntry2.equals(bearingCacheEntry3)) continue;
                bearingCacheEntry = bearingCacheEntry3;
                break;
            }
            if (bearingCacheEntry == null) {
                Iterator<SoftReference<BearingCacheEntry>> iterator = softBearingCache.iterator();
                while (iterator.hasNext()) {
                    BearingCacheEntry bearingCacheEntry4 = (BearingCacheEntry)((SoftReference)iterator.next()).get();
                    if (bearingCacheEntry4 == null) {
                        iterator.remove();
                        continue;
                    }
                    if (!bearingCacheEntry2.equals(bearingCacheEntry4)) continue;
                    bearingCacheEntry = bearingCacheEntry4;
                    SwingUtilities2.putEntryInStrongCache(bearingCacheEntry);
                    break;
                }
            }
            if (bearingCacheEntry == null) {
                bearingCacheEntry = bearingCacheEntry2;
                SwingUtilities2.cacheEntry(bearingCacheEntry);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return bl ? bearingCacheEntry.getLeftSideBearing(c) : bearingCacheEntry.getRightSideBearing(c);
        }
    }

    private static synchronized void cacheEntry(BearingCacheEntry bearingCacheEntry) {
        BearingCacheEntry bearingCacheEntry2 = strongBearingCache[strongBearingCacheNextIndex];
        if (bearingCacheEntry2 != null) {
            softBearingCache.add(new SoftReference<BearingCacheEntry>(bearingCacheEntry2));
        }
        SwingUtilities2.putEntryInStrongCache(bearingCacheEntry);
    }

    private static synchronized void putEntryInStrongCache(BearingCacheEntry bearingCacheEntry) {
        SwingUtilities2.strongBearingCache[SwingUtilities2.strongBearingCacheNextIndex] = bearingCacheEntry;
        strongBearingCacheNextIndex = (strongBearingCacheNextIndex + 1) % 10;
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics) {
        return SwingUtilities2.getFontMetrics(jComponent, graphics, graphics.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics, Font font) {
        if (jComponent != null) {
            return jComponent.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int stringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        return fontMetrics.stringWidth(string);
    }

    public static String clipStringIfNecessary(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = SwingUtilities2.stringWidth(jComponent, fontMetrics, string);
        if (n2 > n) {
            return SwingUtilities2.clipString(jComponent, fontMetrics, string, n);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clipString(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        boolean bl;
        String string2 = "...";
        int n2 = string.length();
        if ((n -= SwingUtilities2.stringWidth(jComponent, fontMetrics, string2)) <= 0) {
            return string2;
        }
        Object object = charsBufferLock;
        synchronized (object) {
            if (charsBuffer == null || charsBuffer.length < n2) {
                charsBuffer = string.toCharArray();
            } else {
                string.getChars(0, n2, charsBuffer, 0);
            }
            bl = SwingUtilities2.isComplexLayout(charsBuffer, 0, n2);
            if (!bl) {
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    if ((n3 += fontMetrics.charWidth(charsBuffer[i])) <= n) continue;
                    string = string.substring(0, i);
                    break;
                }
            }
        }
        if (bl) {
            object = SwingUtilities2.getFontRenderContext(jComponent, fontMetrics);
            AttributedString attributedString = new AttributedString(string);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), (FontRenderContext)object);
            int n4 = lineBreakMeasurer.nextOffset(n);
            string = string.substring(0, n4);
        }
        return string + string2;
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) {
        Object object;
        if (string == null || string.length() <= 0) {
            return;
        }
        if (SwingUtilities2.isPrinting(graphics) && (object = SwingUtilities2.getGraphics2D(graphics)) != null) {
            float f = (float)((Graphics)object).getFont().getStringBounds(string, DEFAULT_FRC).getWidth();
            TextLayout textLayout = new TextLayout(string, ((Graphics)object).getFont(), ((Graphics2D)object).getFontRenderContext());
            textLayout = textLayout.getJustifiedLayout(f);
            Color color = ((Graphics)object).getColor();
            if (color instanceof PrintColorUIResource) {
                ((Graphics)object).setColor(((PrintColorUIResource)color).getPrintColor());
            }
            textLayout.draw((Graphics2D)object, n, n2);
            ((Graphics)object).setColor(color);
            return;
        }
        object = SwingUtilities2.drawTextAntialiased(jComponent);
        if (object != null && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object2 = null;
            Object object3 = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (((AATextInfo)object).aaHint != object3) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, ((AATextInfo)object).aaHint);
            } else {
                object3 = null;
            }
            if (((AATextInfo)object).lcdContrastHint != null) {
                object2 = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                if (((AATextInfo)object).lcdContrastHint.equals(object2)) {
                    object2 = null;
                } else {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, ((AATextInfo)object).lcdContrastHint);
                }
            }
            graphics.drawString(string, n, n2);
            if (object3 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object3);
            }
            if (object2 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, object2);
            }
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        if (string == null || string.length() <= 0) {
            return;
        }
        SwingUtilities2.drawString(jComponent, graphics, string, n2, n3);
        int n4 = string.length();
        if (n >= 0 && n < n4) {
            Object object;
            int n5 = n3;
            int n6 = 1;
            int n7 = 0;
            int n8 = 0;
            boolean bl = SwingUtilities2.isPrinting(graphics);
            boolean bl2 = bl;
            if (!bl2) {
                object = charsBufferLock;
                synchronized (object) {
                    if (charsBuffer == null || charsBuffer.length < n4) {
                        charsBuffer = string.toCharArray();
                    } else {
                        string.getChars(0, n4, charsBuffer, 0);
                    }
                    bl2 = SwingUtilities2.isComplexLayout(charsBuffer, 0, n4);
                }
            }
            if (!bl2) {
                object = graphics.getFontMetrics();
                n7 = n2 + SwingUtilities2.stringWidth(jComponent, (FontMetrics)object, string.substring(0, n));
                n8 = ((FontMetrics)object).charWidth(string.charAt(n));
            } else {
                object = SwingUtilities2.getGraphics2D(graphics);
                if (object != null) {
                    TextLayout textLayout = new TextLayout(string, ((Graphics)object).getFont(), ((Graphics2D)object).getFontRenderContext());
                    if (bl) {
                        float f = (float)((Graphics)object).getFont().getStringBounds(string, DEFAULT_FRC).getWidth();
                        textLayout = textLayout.getJustifiedLayout(f);
                    }
                    TextHitInfo textHitInfo = TextHitInfo.leading(n);
                    TextHitInfo textHitInfo2 = TextHitInfo.trailing(n);
                    Shape shape = textLayout.getVisualHighlightShape(textHitInfo, textHitInfo2);
                    Rectangle rectangle = shape.getBounds();
                    n7 = n2 + rectangle.x;
                    n8 = rectangle.width;
                }
            }
            graphics.fillRect(n7, n5 + 1, n8, n6);
        }
    }

    public static int loc2IndexFileList(JList jList, Point point) {
        Object object;
        int n = jList.locationToIndex(point);
        if (n != -1 && (object = jList.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)object).booleanValue() && !SwingUtilities2.pointIsInActualBounds(jList, n, point)) {
            n = -1;
        }
        return n;
    }

    private static boolean pointIsInActualBounds(JList jList, int n, Point point) {
        ListCellRenderer listCellRenderer = jList.getCellRenderer();
        ListModel listModel = jList.getModel();
        Object object = listModel.getElementAt(n);
        Component component = listCellRenderer.getListCellRendererComponent(jList, object, n, false, false);
        Dimension dimension = component.getPreferredSize();
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (!component.getComponentOrientation().isLeftToRight()) {
            rectangle.x += rectangle.width - dimension.width;
        }
        rectangle.width = dimension.width;
        return rectangle.contains(point);
    }

    public static boolean pointOutsidePrefSize(JTable jTable, int n, int n2, Point point) {
        if (jTable.convertColumnIndexToModel(n2) != 0 || n == -1) {
            return true;
        }
        TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
        Object object = jTable.getValueAt(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, n, n2);
        Dimension dimension = component.getPreferredSize();
        Rectangle rectangle = jTable.getCellRect(n, n2, false);
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        assert (point.x >= rectangle.x && point.y >= rectangle.y);
        return point.x > rectangle.x + rectangle.width || point.y > rectangle.y + rectangle.height;
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel listSelectionModel, int n, int n2) {
        if (n2 == -1) {
            n2 = n;
        }
        if (n == -1) {
            listSelectionModel.setAnchorSelectionIndex(-1);
            listSelectionModel.setLeadSelectionIndex(-1);
        } else {
            if (listSelectionModel.isSelectedIndex(n)) {
                listSelectionModel.addSelectionInterval(n, n);
            } else {
                listSelectionModel.removeSelectionInterval(n, n);
            }
            listSelectionModel.setAnchorSelectionIndex(n2);
        }
    }

    public static boolean shouldIgnore(MouseEvent mouseEvent, JComponent jComponent) {
        return jComponent == null || !jComponent.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed();
    }

    public static void adjustFocus(JComponent jComponent) {
        if (!jComponent.hasFocus() && jComponent.isRequestFocusEnabled()) {
            jComponent.requestFocus();
        }
    }

    public static int drawChars(JComponent jComponent, Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        Object object3;
        if (n2 <= 0) {
            return n3;
        }
        int n5 = n3 + SwingUtilities2.getFontMetrics(jComponent, graphics).charsWidth(cArray, n, n2);
        if (SwingUtilities2.isPrinting(graphics) && (object3 = SwingUtilities2.getGraphics2D(graphics)) != null) {
            object2 = ((Graphics2D)object3).getFontRenderContext();
            object = SwingUtilities2.getFontRenderContext(jComponent);
            if (object != null && !SwingUtilities2.isFontRenderContextPrintCompatible((FontRenderContext)object2, (FontRenderContext)object)) {
                TextLayout textLayout = new TextLayout(new String(cArray, n, n2), ((Graphics)object3).getFont(), (FontRenderContext)object2);
                float f = (float)((Graphics)object3).getFont().getStringBounds(cArray, n, n + n2, (FontRenderContext)object).getWidth();
                textLayout = textLayout.getJustifiedLayout(f);
                Color color = ((Graphics)object3).getColor();
                if (color instanceof PrintColorUIResource) {
                    ((Graphics)object3).setColor(((PrintColorUIResource)color).getPrintColor());
                }
                textLayout.draw((Graphics2D)object3, n3, n4);
                ((Graphics)object3).setColor(color);
                return n5;
            }
        }
        if ((object3 = SwingUtilities2.drawTextAntialiased(jComponent)) != null && graphics instanceof Graphics2D) {
            object2 = (Graphics2D)graphics;
            object = null;
            Object object4 = ((Graphics2D)object2).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (((AATextInfo)object3).aaHint != null && ((AATextInfo)object3).aaHint != object4) {
                ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, ((AATextInfo)object3).aaHint);
            } else {
                object4 = null;
            }
            if (((AATextInfo)object3).lcdContrastHint != null) {
                object = ((Graphics2D)object2).getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                if (((AATextInfo)object3).lcdContrastHint.equals(object)) {
                    object = null;
                } else {
                    ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, ((AATextInfo)object3).lcdContrastHint);
                }
            }
            graphics.drawChars(cArray, n, n2, n3, n4);
            if (object4 != null) {
                ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object4);
            }
            if (object != null) {
                ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, object);
            }
        } else {
            graphics.drawChars(cArray, n, n2, n3, n4);
        }
        return n5;
    }

    public static float drawString(JComponent jComponent, Graphics graphics, AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        float f;
        Graphics2D graphics2D;
        boolean bl = SwingUtilities2.isPrinting(graphics);
        Color color = graphics.getColor();
        if (bl && color instanceof PrintColorUIResource) {
            graphics.setColor(((PrintColorUIResource)color).getPrintColor());
        }
        if ((graphics2D = SwingUtilities2.getGraphics2D(graphics)) == null) {
            graphics.drawString(attributedCharacterIterator, n, n2);
            f = n;
        } else {
            FontRenderContext fontRenderContext;
            FontRenderContext fontRenderContext2;
            if (bl) {
                fontRenderContext2 = SwingUtilities2.getFontRenderContext(jComponent);
                if (fontRenderContext2.isAntiAliased() || fontRenderContext2.usesFractionalMetrics()) {
                    fontRenderContext2 = new FontRenderContext(fontRenderContext2.getTransform(), false, false);
                }
            } else {
                fontRenderContext2 = SwingUtilities2.getFRCProperty(jComponent);
                if (fontRenderContext2 == null) {
                    fontRenderContext2 = graphics2D.getFontRenderContext();
                }
            }
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext2);
            if (bl && !SwingUtilities2.isFontRenderContextPrintCompatible(fontRenderContext2, fontRenderContext = graphics2D.getFontRenderContext())) {
                float f2 = textLayout.getAdvance();
                textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
                textLayout = textLayout.getJustifiedLayout(f2);
            }
            textLayout.draw(graphics2D, n, n2);
            f = textLayout.getAdvance();
        }
        if (bl) {
            graphics.setColor(color);
        }
        return f;
    }

    private static boolean isFontRenderContextPrintCompatible(FontRenderContext fontRenderContext, FontRenderContext fontRenderContext2) {
        if (fontRenderContext == fontRenderContext2) {
            return true;
        }
        if (fontRenderContext == null || fontRenderContext2 == null) {
            return false;
        }
        if (fontRenderContext.getFractionalMetricsHint() != fontRenderContext2.getFractionalMetricsHint()) {
            return false;
        }
        if (!fontRenderContext.isTransformed() && !fontRenderContext2.isTransformed()) {
            return true;
        }
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        fontRenderContext.getTransform().getMatrix(dArray);
        fontRenderContext2.getTransform().getMatrix(dArray2);
        return dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2] && dArray[3] == dArray2[3];
    }

    public static Graphics2D getGraphics2D(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return (Graphics2D)graphics;
        }
        if (graphics instanceof ProxyPrintGraphics) {
            return (Graphics2D)((ProxyPrintGraphics)graphics).getGraphics();
        }
        return null;
    }

    public static FontRenderContext getFontRenderContext(Component component) {
        assert (component != null);
        if (component == null) {
            return DEFAULT_FRC;
        }
        return component.getFontMetrics(component.getFont()).getFontRenderContext();
    }

    private static FontRenderContext getFontRenderContext(Component component, FontMetrics fontMetrics) {
        assert (fontMetrics != null || component != null);
        return fontMetrics != null ? fontMetrics.getFontRenderContext() : SwingUtilities2.getFontRenderContext(component);
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Font font) {
        FontRenderContext fontRenderContext = SwingUtilities2.getFRCProperty(jComponent);
        if (fontRenderContext == null) {
            fontRenderContext = DEFAULT_FRC;
        }
        return FontDesignMetrics.getMetrics(font, fontRenderContext);
    }

    private static FontRenderContext getFRCProperty(JComponent jComponent) {
        AATextInfo aATextInfo;
        if (jComponent != null && (aATextInfo = (AATextInfo)jComponent.getClientProperty(AA_TEXT_PROPERTY_KEY)) != null) {
            return aATextInfo.frc;
        }
        return null;
    }

    static boolean isPrinting(Graphics graphics) {
        return graphics instanceof PrinterGraphics || graphics instanceof PrintGraphics;
    }

    public static boolean useSelectedTextColor(Highlighter.Highlight highlight, JTextComponent jTextComponent) {
        Highlighter.HighlightPainter highlightPainter = highlight.getPainter();
        String string = highlightPainter.getClass().getName();
        if (string.indexOf("javax.swing.text.DefaultHighlighter") != 0 && string.indexOf("com.sun.java.swing.plaf.windows.WindowsTextUI") != 0) {
            return false;
        }
        try {
            DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = (DefaultHighlighter.DefaultHighlightPainter)highlightPainter;
            if (defaultHighlightPainter.getColor() != null && !defaultHighlightPainter.getColor().equals(jTextComponent.getSelectionColor())) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    public static boolean canAccessSystemClipboard() {
        boolean bl = false;
        if (!GraphicsEnvironment.isHeadless()) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                bl = true;
            } else {
                try {
                    securityManager.checkSystemClipboardAccess();
                    bl = true;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (bl && !SwingUtilities2.isTrustedContext()) {
                    bl = SwingUtilities2.canCurrentEventAccessSystemClipboard(true);
                }
            }
        }
        return bl;
    }

    public static boolean canCurrentEventAccessSystemClipboard() {
        return SwingUtilities2.isTrustedContext() || SwingUtilities2.canCurrentEventAccessSystemClipboard(false);
    }

    public static boolean canEventAccessSystemClipboard(AWTEvent aWTEvent) {
        return SwingUtilities2.isTrustedContext() || SwingUtilities2.canEventAccessSystemClipboard(aWTEvent, false);
    }

    private static synchronized boolean inputEvent_canAccessSystemClipboard(InputEvent inputEvent) {
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            inputEvent_CanAccessSystemClipboard_Field = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    try {
                        Field field = InputEvent.class.getDeclaredField("canAccessSystemClipboard");
                        field.setAccessible(true);
                        return field;
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = inputEvent_CanAccessSystemClipboard_Field.getBoolean(inputEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return bl;
    }

    private static boolean isAccessClipboardGesture(InputEvent inputEvent) {
        boolean bl = false;
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            int n = keyEvent.getKeyCode();
            int n2 = keyEvent.getModifiers();
            switch (n) {
                case 67: 
                case 86: 
                case 88: {
                    bl = n2 == 2;
                    break;
                }
                case 155: {
                    bl = n2 == 2 || n2 == 1;
                    break;
                }
                case 65485: 
                case 65487: 
                case 65489: {
                    bl = true;
                    break;
                }
                case 127: {
                    bl = n2 == 1;
                }
            }
        }
        return bl;
    }

    private static boolean canEventAccessSystemClipboard(AWTEvent aWTEvent, boolean bl) {
        if (EventQueue.isDispatchThread()) {
            if (aWTEvent instanceof InputEvent && (!bl || SwingUtilities2.isAccessClipboardGesture((InputEvent)aWTEvent))) {
                return SwingUtilities2.inputEvent_canAccessSystemClipboard((InputEvent)aWTEvent);
            }
            return false;
        }
        return true;
    }

    public static void checkAccess(int n) {
        if (System.getSecurityManager() != null && !Modifier.isPublic(n)) {
            throw new SecurityException("Resource is not accessible");
        }
    }

    private static boolean canCurrentEventAccessSystemClipboard(boolean bl) {
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        return SwingUtilities2.canEventAccessSystemClipboard(aWTEvent, bl);
    }

    private static boolean isTrustedContext() {
        return System.getSecurityManager() == null || AppContext.getAppContext().get(UntrustedClipboardAccess) == null;
    }

    public static String displayPropertiesToCSS(Font font, Color color) {
        StringBuffer stringBuffer = new StringBuffer("body {");
        if (font != null) {
            stringBuffer.append(" font-family: ");
            stringBuffer.append(font.getFamily());
            stringBuffer.append(" ; ");
            stringBuffer.append(" font-size: ");
            stringBuffer.append(font.getSize());
            stringBuffer.append("pt ;");
            if (font.isBold()) {
                stringBuffer.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                stringBuffer.append(" font-style: italic ; ");
            }
        }
        if (color != null) {
            stringBuffer.append(" color: #");
            if (color.getRed() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getRed()));
            if (color.getGreen() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getGreen()));
            if (color.getBlue() < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(color.getBlue()));
            stringBuffer.append(" ; ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static Object makeIcon(final Class<?> clazz, final Class<?> clazz2, final String string) {
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                byte[] byArray = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                    @Override
                    public byte[] run() {
                        try {
                            int n;
                            InputStream inputStream = null;
                            for (Class clazz = clazz; clazz != null && (inputStream = clazz.getResourceAsStream(string)) == null && clazz != clazz2; clazz = clazz.getSuperclass()) {
                            }
                            if (inputStream == null) {
                                return null;
                            }
                            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                            byte[] byArray = new byte[1024];
                            while ((n = bufferedInputStream.read(byArray)) > 0) {
                                byteArrayOutputStream.write(byArray, 0, n);
                            }
                            bufferedInputStream.close();
                            byteArrayOutputStream.flush();
                            return byteArrayOutputStream.toByteArray();
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException.toString());
                            return null;
                        }
                    }
                });
                if (byArray == null) {
                    return null;
                }
                if (byArray.length == 0) {
                    System.err.println("warning: " + string + " is zero-length");
                    return null;
                }
                return new ImageIconUIResource(byArray);
            }
        };
    }

    public static boolean isLocalDisplay() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        boolean bl = graphicsEnvironment instanceof SunGraphicsEnvironment ? ((SunGraphicsEnvironment)graphicsEnvironment).isDisplayLocal() : true;
        return bl;
    }

    public static int getUIDefaultsInt(Object object) {
        return SwingUtilities2.getUIDefaultsInt(object, 0);
    }

    public static int getUIDefaultsInt(Object object, Locale locale) {
        return SwingUtilities2.getUIDefaultsInt(object, locale, 0);
    }

    public static int getUIDefaultsInt(Object object, int n) {
        return SwingUtilities2.getUIDefaultsInt(object, null, n);
    }

    public static int getUIDefaultsInt(Object object, Locale locale, int n) {
        Object object2 = UIManager.get(object, locale);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            Component component2;
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                ((Component)object2).requestFocus();
                return object2;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null && (component2 = ((FocusTraversalPolicy)(object2 = ((Container)object).getFocusTraversalPolicy())).getComponentAfter((Container)object, container)) != null && SwingUtilities.isDescendingFrom(component2, container)) {
                component2.requestFocus();
                return component2;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    public static boolean tabbedPaneChangeFocusTo(Component component) {
        if (component != null) {
            if (component.isFocusTraversable()) {
                SwingUtilities2.compositeRequestFocus(component);
                return true;
            }
            if (component instanceof JComponent && ((JComponent)component).requestDefaultFocus()) {
                return true;
            }
        }
        return false;
    }

    public static <V> Future<V> submit(Callable<V> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        SwingUtilities2.execute(futureTask);
        return futureTask;
    }

    public static <V> Future<V> submit(Runnable runnable, V v) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        FutureTask<V> futureTask = new FutureTask<V>(runnable, v);
        SwingUtilities2.execute(futureTask);
        return futureTask;
    }

    private static void execute(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public static void setSkipClickCount(Component component, int n) {
        if (component instanceof JTextComponent && ((JTextComponent)component).getCaret() instanceof DefaultCaret) {
            ((JTextComponent)component).putClientProperty(SKIP_CLICK_COUNT, n);
        }
    }

    public static int getAdjustedClickCount(JTextComponent jTextComponent, MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        if (n == 1) {
            jTextComponent.putClientProperty(SKIP_CLICK_COUNT, null);
        } else {
            Integer n2 = (Integer)jTextComponent.getClientProperty(SKIP_CLICK_COUNT);
            if (n2 != null) {
                return n - n2;
            }
        }
        return n;
    }

    private static Section liesIn(Rectangle rectangle, Point point, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        int n;
        int n2;
        int n3;
        if (bl) {
            n3 = rectangle.x;
            n2 = point.x;
            n = rectangle.width;
            bl4 = bl2;
        } else {
            n3 = rectangle.y;
            n2 = point.y;
            n = rectangle.height;
            bl4 = true;
        }
        if (bl3) {
            int n4;
            int n5 = n4 = n >= 30 ? 10 : n / 3;
            if (n2 < n3 + n4) {
                return bl4 ? Section.LEADING : Section.TRAILING;
            }
            if (n2 >= n3 + n - n4) {
                return bl4 ? Section.TRAILING : Section.LEADING;
            }
            return Section.MIDDLE;
        }
        int n6 = n3 + n / 2;
        if (bl4) {
            return n2 >= n6 ? Section.TRAILING : Section.LEADING;
        }
        return n2 < n6 ? Section.TRAILING : Section.LEADING;
    }

    public static Section liesInHorizontal(Rectangle rectangle, Point point, boolean bl, boolean bl2) {
        return SwingUtilities2.liesIn(rectangle, point, true, bl, bl2);
    }

    public static Section liesInVertical(Rectangle rectangle, Point point, boolean bl) {
        return SwingUtilities2.liesIn(rectangle, point, false, false, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Section {
        LEADING,
        MIDDLE,
        TRAILING;

    }

    private static class BearingCacheEntry {
        private FontMetrics fontMetrics;
        private Font font;
        private FontRenderContext frc;
        private Map<Character, Short> cache;
        private static final char[] oneChar = new char[1];

        public BearingCacheEntry(FontMetrics fontMetrics) {
            this.fontMetrics = fontMetrics;
            this.font = fontMetrics.getFont();
            this.frc = fontMetrics.getFontRenderContext();
            this.cache = new HashMap<Character, Short>();
            assert (this.font != null && this.frc != null);
        }

        public int getLeftSideBearing(char c) {
            Short s = this.cache.get(Character.valueOf(c));
            if (s == null) {
                s = this.calcBearing(c);
                this.cache.put(Character.valueOf(c), s);
            }
            return ((0xFF00 & s) >>> 8) - 127;
        }

        public int getRightSideBearing(char c) {
            Short s = this.cache.get(Character.valueOf(c));
            if (s == null) {
                s = this.calcBearing(c);
                this.cache.put(Character.valueOf(c), s);
            }
            return (0xFF & s) - 127;
        }

        private short calcBearing(char c) {
            Object object;
            BearingCacheEntry.oneChar[0] = c;
            GlyphVector glyphVector = this.font.createGlyphVector(this.frc, oneChar);
            Rectangle rectangle = glyphVector.getGlyphPixelBounds(0, this.frc, 0.0f, 0.0f);
            int n = rectangle.x;
            int n2 = rectangle.width - this.fontMetrics.charWidth(c);
            if (n < 0 && ((object = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || object == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                ++n;
            }
            if (n2 > 0 && ((object = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || object == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                --n2;
            }
            if (n < -127 || n > 127) {
                n = 0;
            }
            if (n2 < -127 || n2 > 127) {
                n2 = 0;
            }
            int n3 = (n + 127 << 8) + (n2 + 127);
            return (short)n3;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof BearingCacheEntry)) {
                return false;
            }
            BearingCacheEntry bearingCacheEntry = (BearingCacheEntry)object;
            return this.font.equals(bearingCacheEntry.font) && this.frc.equals(bearingCacheEntry.frc);
        }

        public int hashCode() {
            int n = 17;
            if (this.font != null) {
                n = 37 * n + this.font.hashCode();
            }
            if (this.frc != null) {
                n = 37 * n + this.frc.hashCode();
            }
            return n;
        }
    }

    public static class AATextInfo {
        Object aaHint;
        Integer lcdContrastHint;
        FontRenderContext frc;

        private static AATextInfo getAATextInfoFromMap(Map map) {
            Object v = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object v2 = map.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
            if (v == null || v == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || v == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                return null;
            }
            return new AATextInfo(v, (Integer)v2);
        }

        public static AATextInfo getAATextInfo(boolean bl) {
            SunToolkit.setAAFontSettingsCondition(bl);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Object object = toolkit.getDesktopProperty("awt.font.desktophints");
            if (object instanceof Map) {
                return AATextInfo.getAATextInfoFromMap((Map)object);
            }
            return null;
        }

        public AATextInfo(Object object, Integer n) {
            if (object == null) {
                throw new InternalError("null not allowed here");
            }
            if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || object == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                throw new InternalError("AA must be on");
            }
            this.aaHint = object;
            this.lcdContrastHint = n;
            this.frc = new FontRenderContext(null, object, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        }
    }
}

