/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.synth.SynthContext;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthFileChooserUI;

public class SynthFileChooserUIImpl
extends SynthFileChooserUI {
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private FilePane filePane;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private boolean useShellFolder;
    private boolean readOnly;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static Dimension LIST_PREF_SIZE = new Dimension(405, 135);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int folderNameLabelMnemonic = 0;
    private String folderNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private AlignedLabel fileNameLabel;
    private final PropertyChangeListener modeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SynthFileChooserUIImpl.this.fileNameLabel != null) {
                SynthFileChooserUIImpl.this.populateFileNameLabel();
            }
        }
    };
    static final int space = 10;

    private void populateFileNameLabel() {
        if (this.getFileChooser().getFileSelectionMode() == 1) {
            this.fileNameLabel.setText(this.folderNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.folderNameLabelMnemonic);
        } else {
            this.fileNameLabel.setText(this.fileNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        }
    }

    public SynthFileChooserUIImpl(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    protected void installDefaults(JFileChooser jFileChooser) {
        super.installDefaults(jFileChooser);
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        super.installComponents(jFileChooser);
        SynthContext synthContext = this.getContext(jFileChooser, 1);
        this.updateUseShellFolder();
        jFileChooser.setLayout(new BorderLayout(0, 11));
        JPanel jPanel = new JPanel(new BorderLayout(11, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel.add((Component)jPanel2, "After");
        jFileChooser.add((Component)jPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        jPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel.add((Component)this.directoryComboBox, "Center");
        this.filePane = new FilePane(new SynthFileChooserUIAccessor());
        jFileChooser.addPropertyChangeListener(this.filePane);
        JPopupMenu jPopupMenu = this.filePane.getComponentPopupMenu();
        if (jPopupMenu != null) {
            jPopupMenu.insert(this.getChangeToParentDirectoryAction(), 0);
            if (File.separatorChar == '/') {
                jPopupMenu.insert(this.getGoHomeAction(), 1);
            }
        }
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        JButton jButton = new JButton(this.getChangeToParentDirectoryAction());
        jButton.setText(null);
        jButton.setIcon(this.upFolderIcon);
        jButton.setToolTipText(this.upFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(hstrut5));
        File file = fileSystemView.getHomeDirectory();
        String string = this.homeFolderToolTipText;
        if (fileSystemView.isRoot(file)) {
            string = this.getFileView(jFileChooser).getName(file);
        }
        JButton jButton2 = new JButton(this.homeFolderIcon);
        jButton2.setToolTipText(string);
        jButton2.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.addActionListener(this.getGoHomeAction());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(hstrut5));
        if (!this.readOnly) {
            jButton2 = new JButton(this.filePane.getNewFolderAction());
            jButton2.setText(null);
            jButton2.setIcon(this.newFolderIcon);
            jButton2.setToolTipText(this.newFolderToolTipText);
            jButton2.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
            jButton2.setAlignmentX(0.0f);
            jButton2.setAlignmentY(0.5f);
            jButton2.setMargin(shrinkwrap);
            jPanel2.add(jButton2);
            jPanel2.add(Box.createRigidArea(hstrut5));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(this.filePane.getViewTypeAction(0));
        jPanel2.add(this.listViewButton);
        buttonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(this.filePane.getViewTypeAction(1));
        jPanel2.add(this.detailsViewButton);
        buttonGroup.add(this.detailsViewButton);
        this.filePane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("viewType".equals(propertyChangeEvent.getPropertyName())) {
                    int n = SynthFileChooserUIImpl.this.filePane.getViewType();
                    switch (n) {
                        case 0: {
                            SynthFileChooserUIImpl.this.listViewButton.setSelected(true);
                            break;
                        }
                        case 1: {
                            SynthFileChooserUIImpl.this.detailsViewButton.setSelected(true);
                        }
                    }
                }
            }
        });
        jFileChooser.add((Component)this.getAccessoryPanel(), "After");
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        jFileChooser.add((Component)this.filePane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        jFileChooser.add((Component)this.bottomPanel, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        this.bottomPanel.add(jPanel3);
        this.bottomPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        this.fileNameLabel = new AlignedLabel();
        this.populateFileNameLabel();
        jPanel3.add(this.fileNameLabel);
        this.fileNameTextField = new JTextField(35){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        jPanel3.add(this.fileNameTextField);
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!SynthFileChooserUIImpl.this.getFileChooser().isMultiSelectionEnabled()) {
                    SynthFileChooserUIImpl.this.filePane.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        this.bottomPanel.add(jPanel4);
        AlignedLabel alignedLabel = new AlignedLabel(this.filesOfTypeLabelText);
        alignedLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel4.add(alignedLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        alignedLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel4.add(this.filterComboBox);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new ButtonAreaLayout());
        this.buttonPanel.add(this.getApproveButton(jFileChooser));
        this.buttonPanel.add(this.getCancelButton(jFileChooser));
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        SynthFileChooserUIImpl.groupLabels(new AlignedLabel[]{this.fileNameLabel, alignedLabel});
    }

    @Override
    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        jFileChooser.addPropertyChangeListener("fileSelectionChanged", this.modeListener);
    }

    @Override
    protected void uninstallListeners(JFileChooser jFileChooser) {
        jFileChooser.removePropertyChangeListener("fileSelectionChanged", this.modeListener);
        super.uninstallListeners(jFileChooser);
    }

    private void updateUseShellFolder() {
        JFileChooser jFileChooser = this.getFileChooser();
        Boolean bl = (Boolean)jFileChooser.getClientProperty("FileChooser.useShellFolder");
        this.useShellFolder = bl != null ? bl.booleanValue() : jFileChooser.getFileSystemView().equals(FileSystemView.getFileSystemView());
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[i]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        jComponent.removePropertyChangeListener(this.filePane);
        if (this.filePane != null) {
            this.filePane.uninstallUI();
            this.filePane = null;
        }
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = this.getMnemonic("FileChooser.lookInLabelMnemonic", locale);
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = this.getMnemonic("FileChooser.fileNameLabelMnemonic", locale);
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.folderNameLabelMnemonic = this.getMnemonic("FileChooser.folderNameLabelMnemonic", locale);
        this.folderNameLabelText = UIManager.getString((Object)"FileChooser.folderNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = this.getMnemonic("FileChooser.filesOfTypeLabelMnemonic", locale);
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", locale);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", locale);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", locale);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", locale);
    }

    private int getMnemonic(String string, Locale locale) {
        return SwingUtilities2.getUIDefaultsInt((Object)string, locale);
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String string) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(string);
        }
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.filePane.rescanCurrentDirectory();
    }

    @Override
    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doSelectedFileChanged(propertyChangeEvent);
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
        }
    }

    @Override
    protected void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doSelectedFilesChanged(propertyChangeEvent);
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
        }
    }

    @Override
    protected void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doDirectoryChanged(propertyChangeEvent);
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        File file = jFileChooser.getCurrentDirectory();
        if (!this.readOnly && file != null) {
            this.getNewFolderAction().setEnabled(this.filePane.canWrite(file));
        }
        if (file != null) {
            ComboBoxModel comboBoxModel;
            JComponent jComponent = this.getDirectoryComboBox();
            if (jComponent instanceof JComboBox && (comboBoxModel = ((JComboBox)jComponent).getModel()) instanceof DirectoryComboBoxModel) {
                ((DirectoryComboBoxModel)comboBoxModel).addItem(file);
            }
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(file.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    @Override
    protected void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doFileSelectionModeChanged(propertyChangeEvent);
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    @Override
    protected void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    @Override
    protected void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doControlButtonsChanged(propertyChangeEvent);
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    protected void addControlButtons() {
        if (this.bottomPanel != null) {
            this.bottomPanel.add(this.buttonPanel);
        }
    }

    protected void removeControlButtons() {
        if (this.bottomPanel != null) {
            this.bottomPanel.remove(this.buttonPanel);
        }
    }

    @Override
    protected ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        FilePane.addActionsToMap(actionMapUIResource, this.filePane.getActions());
        actionMapUIResource.put("fileNameCompletion", this.getFileNameCompletionAction());
        return actionMapUIResource;
    }

    protected JComponent getDirectoryComboBox() {
        return this.directoryComboBox;
    }

    protected Action getDirectoryComboBoxAction() {
        return this.directoryComboBoxAction;
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer(this.directoryComboBox.getRenderer());
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer(this.filterComboBox.getRenderer());
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    private static void groupLabels(AlignedLabel[] alignedLabelArray) {
        for (int i = 0; i < alignedLabelArray.length; ++i) {
            AlignedLabel.access$1502(alignedLabelArray[i], alignedLabelArray);
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel() {
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        AlignedLabel(String string) {
            super(string);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, dimension.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int n;
                int n2 = 0;
                for (n = 0; n < this.group.length; ++n) {
                    n2 = Math.max(this.group[n].getSuperPreferredWidth(), n2);
                }
                for (n = 0; n < this.group.length; ++n) {
                    this.group[n].maxWidth = n2;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$1502(AlignedLabel alignedLabel, AlignedLabel[] alignedLabelArray) {
            alignedLabel.group = alignedLabelArray;
            return alignedLabelArray;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n;
                int n2;
                int n3 = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n3];
                Insets insets = container.getInsets();
                int n4 = insets.top + this.topMargin;
                int n5 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    dimensionArray[n2] = componentArray[n2].getPreferredSize();
                    n5 = Math.max(n5, dimensionArray[n2].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    n2 = container.getSize().width - insets.left - n5;
                    n = this.hGap + n5;
                } else {
                    n2 = insets.left;
                    n = -(this.hGap + n5);
                }
                for (int i = n3 - 1; i >= 0; --i) {
                    componentArray[i].setBounds(n2, n4, n5, dimensionArray[i].height);
                    n2 -= n;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n = componentArray.length;
                int n2 = 0;
                Insets insets = container.getInsets();
                int n3 = this.topMargin + insets.top + insets.bottom;
                int n4 = insets.left + insets.right;
                int n5 = 0;
                for (int i = 0; i < n; ++i) {
                    Dimension dimension = componentArray[i].getPreferredSize();
                    n2 = Math.max(n2, dimension.height);
                    n5 = Math.max(n5, dimension.width);
                }
                return new Dimension(n4 + n * n5 + (n - 1) * this.hGap, n3 + n2);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = SynthFileChooserUIImpl.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object != null) {
                SynthFileChooserUIImpl.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter fileFilter = SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                for (FileFilter fileFilter2 : this.filters) {
                    if (fileFilter2 != fileFilter) continue;
                    bl = true;
                }
                if (!bl) {
                    SynthFileChooserUIImpl.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return SynthFileChooserUIImpl.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;

        private FilterComboBoxRenderer(ListCellRenderer listCellRenderer) {
            this.delegate = listCellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
            String string = null;
            if (object != null && object instanceof FileFilter) {
                string = ((FileFilter)object).getDescription();
            }
            assert (component instanceof JLabel);
            if (string != null) {
                ((JLabel)component).setText(string);
            }
            return component;
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SynthFileChooserUIImpl.this.directoryComboBox.hidePopup();
            JComponent jComponent = SynthFileChooserUIImpl.this.getDirectoryComboBox();
            if (jComponent instanceof JComboBox) {
                File file = (File)((JComboBox)jComponent).getSelectedItem();
                SynthFileChooserUIImpl.this.getFileChooser().setCurrentDirectory(file);
            }
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = SynthFileChooserUIImpl.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = SynthFileChooserUIImpl.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        public void addItem(File file) {
            File file2;
            if (file == null) {
                return;
            }
            int n = this.directories.size();
            this.directories.clear();
            if (n > 0) {
                this.fireIntervalRemoved(this, 0, n);
            }
            File[] fileArray = SynthFileChooserUIImpl.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(fileArray));
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                File file3;
                File file4 = file3 = SynthFileChooserUIImpl.this.useShellFolder ? ShellFolder.getShellFolder(file2) : file2;
                Vector<File> vector = new Vector<File>(10);
                do {
                    vector.addElement(file4);
                } while ((file4 = file4.getParentFile()) != null);
                int n2 = vector.size();
                for (int i = 0; i < n2; ++i) {
                    file4 = (File)vector.get(i);
                    if (!this.directories.contains(file4)) continue;
                    int n3 = this.directories.indexOf(file4);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((File)vector.get(j), n3 + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(file3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File file = this.directories.get(i);
                File file2 = file.getParentFile();
                this.depths[i] = 0;
                if (file2 == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!file2.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int n) {
            return this.depths != null && n >= 0 && n < this.depths.length ? this.depths[n] : 0;
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.icon != null) {
                if (component.getComponentOrientation().isLeftToRight()) {
                    this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
                } else {
                    this.icon.paintIcon(component, graphics, n, n2);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return (this.icon != null ? this.icon.getIconWidth() : 0) + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon != null ? this.icon.getIconHeight() : 0;
        }
    }

    private class DirectoryComboBoxRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate;
        IndentIcon ii;

        private DirectoryComboBoxRenderer(ListCellRenderer listCellRenderer) {
            this.ii = new IndentIcon();
            this.delegate = listCellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            Component component = this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
            assert (component instanceof JLabel);
            JLabel jLabel = (JLabel)component;
            if (object == null) {
                jLabel.setText("");
                return jLabel;
            }
            File file = (File)object;
            jLabel.setText(SynthFileChooserUIImpl.this.getFileChooser().getName(file));
            this.ii.icon = icon = SynthFileChooserUIImpl.this.getFileChooser().getIcon(file);
            this.ii.depth = SynthFileChooserUIImpl.this.directoryComboBoxModel.getDepth(n);
            jLabel.setIcon(this.ii);
            return jLabel;
        }
    }

    private class SynthFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private SynthFileChooserUIAccessor() {
        }

        @Override
        public JFileChooser getFileChooser() {
            return SynthFileChooserUIImpl.this.getFileChooser();
        }

        @Override
        public BasicDirectoryModel getModel() {
            return SynthFileChooserUIImpl.this.getModel();
        }

        @Override
        public JPanel createList() {
            return null;
        }

        @Override
        public JPanel createDetailsView() {
            return null;
        }

        @Override
        public boolean isDirectorySelected() {
            return SynthFileChooserUIImpl.this.isDirectorySelected();
        }

        @Override
        public File getDirectory() {
            return SynthFileChooserUIImpl.this.getDirectory();
        }

        @Override
        public Action getChangeToParentDirectoryAction() {
            return SynthFileChooserUIImpl.this.getChangeToParentDirectoryAction();
        }

        @Override
        public Action getApproveSelectionAction() {
            return SynthFileChooserUIImpl.this.getApproveSelectionAction();
        }

        @Override
        public Action getNewFolderAction() {
            return SynthFileChooserUIImpl.this.getNewFolderAction();
        }

        @Override
        public MouseListener createDoubleClickListener(JList jList) {
            return SynthFileChooserUIImpl.this.createDoubleClickListener(this.getFileChooser(), jList);
        }

        @Override
        public ListSelectionListener createListSelectionListener() {
            return SynthFileChooserUIImpl.this.createListSelectionListener(this.getFileChooser());
        }

        @Override
        public boolean usesShellFolder() {
            return SynthFileChooserUIImpl.this.useShellFolder;
        }
    }
}

