/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AESCipher;
import com.sun.crypto.provider.AESCrypt;
import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.ConstructKeys;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

abstract class AESWrapCipher
extends CipherSpi {
    private static final byte[] IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    private static final int blksize = 16;
    private AESCrypt cipher = new AESCrypt();
    private boolean decrypting = false;
    private final int fixedKeySize;

    public AESWrapCipher(int n) {
        this.fixedKeySize = n;
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException(string + " cannot be used");
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException(string + " cannot be used");
        }
    }

    protected int engineGetBlockSize() {
        return 16;
    }

    protected int engineGetOutputSize(int n) {
        int n2 = 0;
        n2 = this.decrypting ? n - 8 : CipherCore.addExact(n, 8);
        return n2 < 0 ? 0 : n2;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n == 3) {
            this.decrypting = false;
        } else if (n == 4) {
            this.decrypting = true;
        } else {
            throw new UnsupportedOperationException("This cipher can only be used for key wrapping and unwrapping");
        }
        AESCipher.checkKeySize(key, this.fixedKeySize);
        this.cipher.init(this.decrypting, key.getAlgorithm(), key.getEncoded());
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("This cipher does not accept any parameters");
        }
        this.engineInit(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("This cipher does not accept any parameters");
        }
        this.engineInit(n, key, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        throw new IllegalStateException("Cipher has not been initialized");
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (!AESCrypt.isKeySizeValid(byArray.length)) {
            throw new InvalidKeyException("Invalid key length: " + byArray.length + " bytes");
        }
        return CipherCore.multiplyExact(byArray.length, 8);
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
        }
        byte[] byArray2 = new byte[CipherCore.addExact(byArray.length, 8)];
        if (byArray.length == 8) {
            System.arraycopy(IV, 0, byArray2, 0, IV.length);
            System.arraycopy(byArray, 0, byArray2, IV.length, 8);
            this.cipher.encryptBlock(byArray2, 0, byArray2, 0);
        } else {
            if (byArray.length % 8 != 0) {
                throw new IllegalBlockSizeException("length of the to be wrapped key should be multiples of 8 bytes");
            }
            System.arraycopy(IV, 0, byArray2, 0, IV.length);
            System.arraycopy(byArray, 0, byArray2, IV.length, byArray.length);
            int n = byArray.length / 8;
            byte[] byArray3 = new byte[16];
            for (int i = 0; i < 6; ++i) {
                for (int j = 1; j <= n; ++j) {
                    int n2 = j + i * n;
                    System.arraycopy(byArray2, 0, byArray3, 0, IV.length);
                    System.arraycopy(byArray2, j * 8, byArray3, IV.length, 8);
                    this.cipher.encryptBlock(byArray3, 0, byArray3, 0);
                    int n3 = 1;
                    while (n2 != 0) {
                        byte by = (byte)n2;
                        int n4 = IV.length - n3;
                        byArray3[n4] = (byte)(byArray3[n4] ^ by);
                        n2 >>>= 8;
                        ++n3;
                    }
                    System.arraycopy(byArray3, 0, byArray2, 0, IV.length);
                    System.arraycopy(byArray3, 8, byArray2, 8 * j, 8);
                }
            }
        }
        return byArray2;
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        int n2 = byArray.length;
        if (n2 == 0) {
            throw new InvalidKeyException("The wrapped key is empty");
        }
        if (n2 % 8 != 0) {
            throw new InvalidKeyException("The wrapped key has invalid key length");
        }
        byte[] byArray2 = new byte[n2 - 8];
        byte[] byArray3 = new byte[16];
        if (n2 == 16) {
            this.cipher.decryptBlock(byArray, 0, byArray3, 0);
            for (int i = 0; i < IV.length; ++i) {
                if (IV[i] == byArray3[i]) continue;
                throw new InvalidKeyException("Integrity check failed");
            }
            System.arraycopy(byArray3, IV.length, byArray2, 0, byArray2.length);
        } else {
            int n3;
            System.arraycopy(byArray, 0, byArray3, 0, IV.length);
            System.arraycopy(byArray, IV.length, byArray2, 0, byArray2.length);
            int n4 = byArray2.length / 8;
            for (n3 = 5; n3 >= 0; --n3) {
                for (int i = n4; i > 0; --i) {
                    int n5 = i + n3 * n4;
                    System.arraycopy(byArray2, 8 * (i - 1), byArray3, IV.length, 8);
                    int n6 = 1;
                    while (n5 != 0) {
                        byte by = (byte)n5;
                        int n7 = IV.length - n6;
                        byArray3[n7] = (byte)(byArray3[n7] ^ by);
                        n5 >>>= 8;
                        ++n6;
                    }
                    this.cipher.decryptBlock(byArray3, 0, byArray3, 0);
                    System.arraycopy(byArray3, IV.length, byArray2, 8 * (i - 1), 8);
                }
            }
            for (n3 = 0; n3 < IV.length; ++n3) {
                if (IV[n3] == byArray3[n3]) continue;
                throw new InvalidKeyException("Integrity check failed");
            }
        }
        return ConstructKeys.constructKey(byArray2, string, n);
    }

    public static final class AES256
    extends AESWrapCipher {
        public AES256() {
            super(32);
        }
    }

    public static final class AES192
    extends AESWrapCipher {
        public AES192() {
            super(24);
        }
    }

    public static final class AES128
    extends AESWrapCipher {
        public AES128() {
            super(16);
        }
    }

    public static final class General
    extends AESWrapCipher {
        public General() {
            super(-1);
        }
    }
}

