/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.ConstructKeys;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class ARCFOURCipher
extends CipherSpi {
    private final int[] S = new int[256];
    private int is;
    private int js;
    private byte[] lastKey;

    private void init(byte[] byArray) {
        int n;
        for (n = 0; n < 256; ++n) {
            this.S[n] = n;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            int n4 = this.S[n];
            n2 = n2 + n4 + byArray[n3] & 0xFF;
            this.S[n] = this.S[n2];
            this.S[n2] = n4;
            if (++n3 != byArray.length) continue;
            n3 = 0;
        }
        this.is = 0;
        this.js = 0;
    }

    private void crypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.is < 0) {
            this.init(this.lastKey);
        }
        while (n2-- > 0) {
            int n4;
            this.is = this.is + 1 & 0xFF;
            int n5 = this.S[this.is];
            this.js = this.js + n5 & 0xFF;
            this.S[this.is] = n4 = this.S[this.js];
            this.S[this.js] = n5;
            byArray2[n3++] = (byte)(byArray[n++] ^ this.S[n5 + n4 & 0xFF]);
        }
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding must be NoPadding");
        }
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetOutputSize(int n) {
        return n;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.init(n, key);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(n, key);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(n, key);
    }

    private void init(int n, Key key) throws InvalidKeyException {
        if (n < 1 || n > 4) {
            throw new InvalidKeyException("Unknown opmode: " + n);
        }
        this.lastKey = ARCFOURCipher.getEncodedKey(key);
        this.init(this.lastKey);
    }

    private static byte[] getEncodedKey(Key key) throws InvalidKeyException {
        String string = key.getAlgorithm();
        if (!string.equals("RC4") && !string.equals("ARCFOUR")) {
            throw new InvalidKeyException("Not an ARCFOUR key: " + string);
        }
        if (!"RAW".equals(key.getFormat())) {
            throw new InvalidKeyException("Key encoding format must be RAW");
        }
        byte[] byArray = key.getEncoded();
        if (byArray.length < 5 || byArray.length > 128) {
            throw new InvalidKeyException("Key length must be between 40 and 1024 bit");
        }
        return byArray;
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        this.crypt(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (byArray2.length - n3 < n2) {
            throw new ShortBufferException("Output buffer too small");
        }
        this.crypt(byArray, n, n2, byArray2, n3);
        return n2;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.engineUpdate(byArray, n, n2);
        this.is = -1;
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = this.engineUpdate(byArray, n, n2, byArray2, n3);
        this.is = -1;
        return n4;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        return this.engineDoFinal(byArray, 0, byArray.length);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        return ConstructKeys.constructKey(byArray2, string, n);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] byArray = ARCFOURCipher.getEncodedKey(key);
        return CipherCore.multiplyExact(byArray.length, 8);
    }
}

