/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherBlockChaining;
import com.sun.crypto.provider.CipherFeedback;
import com.sun.crypto.provider.CipherTextStealing;
import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.CounterMode;
import com.sun.crypto.provider.ElectronicCodeBook;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.ISO10126Padding;
import com.sun.crypto.provider.OutputFeedback;
import com.sun.crypto.provider.PCBC;
import com.sun.crypto.provider.PKCS5Padding;
import com.sun.crypto.provider.Padding;
import com.sun.crypto.provider.RC2Crypt;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

final class CipherCore {
    private byte[] buffer = null;
    private int blockSize = 0;
    private int unitBytes = 0;
    private int buffered = 0;
    private int minBytes = 0;
    private int diffBlocksize = 0;
    private Padding padding = null;
    private FeedbackCipher cipher = null;
    private int cipherMode = 0;
    private boolean decrypting = false;
    private static final int ECB_MODE = 0;
    private static final int CBC_MODE = 1;
    private static final int CFB_MODE = 2;
    private static final int OFB_MODE = 3;
    private static final int PCBC_MODE = 4;
    private static final int CTR_MODE = 5;
    private static final int CTS_MODE = 6;

    CipherCore(SymmetricCipher symmetricCipher, int n) {
        this.blockSize = n;
        this.unitBytes = n;
        this.diffBlocksize = n;
        this.buffer = new byte[this.blockSize * 2];
        this.cipher = new ElectronicCodeBook(symmetricCipher);
        this.padding = new PKCS5Padding(this.blockSize);
    }

    void setMode(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NoSuchAlgorithmException("null mode");
        }
        String string2 = string.toUpperCase(Locale.ENGLISH);
        if (string2.equals("ECB")) {
            return;
        }
        SymmetricCipher symmetricCipher = this.cipher.getEmbeddedCipher();
        if (string2.equals("CBC")) {
            this.cipherMode = 1;
            this.cipher = new CipherBlockChaining(symmetricCipher);
        } else if (string2.equals("CTS")) {
            this.cipherMode = 6;
            this.cipher = new CipherTextStealing(symmetricCipher);
            this.minBytes = this.blockSize + 1;
            this.padding = null;
        } else if (string2.equals("CTR")) {
            this.cipherMode = 5;
            this.cipher = new CounterMode(symmetricCipher);
            this.unitBytes = 1;
            this.padding = null;
        } else if (string2.startsWith("CFB")) {
            this.cipherMode = 2;
            this.unitBytes = CipherCore.getNumOfUnit(string, "CFB".length(), this.blockSize);
            this.cipher = new CipherFeedback(symmetricCipher, this.unitBytes);
        } else if (string2.startsWith("OFB")) {
            this.cipherMode = 3;
            this.unitBytes = CipherCore.getNumOfUnit(string, "OFB".length(), this.blockSize);
            this.cipher = new OutputFeedback(symmetricCipher, this.unitBytes);
        } else if (string2.equals("PCBC")) {
            this.cipherMode = 4;
            this.cipher = new PCBC(symmetricCipher);
        } else {
            throw new NoSuchAlgorithmException("Cipher mode: " + string + " not found");
        }
    }

    private static int getNumOfUnit(String string, int n, int n2) throws NoSuchAlgorithmException {
        int n3 = n2;
        if (string.length() > n) {
            int n4;
            try {
                Integer n5 = Integer.valueOf(string.substring(n));
                n4 = n5;
                n3 = n4 >> 3;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NoSuchAlgorithmException("Algorithm mode: " + string + " not implemented");
            }
            if (n4 % 8 != 0 || n3 > n2) {
                throw new NoSuchAlgorithmException("Invalid algorithm mode: " + string);
            }
        }
        return n3;
    }

    void setPadding(String string) throws NoSuchPaddingException {
        if (string == null) {
            throw new NoSuchPaddingException("null padding");
        }
        if (string.equalsIgnoreCase("NoPadding")) {
            this.padding = null;
        } else if (string.equalsIgnoreCase("ISO10126Padding")) {
            this.padding = new ISO10126Padding(this.blockSize);
        } else if (!string.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Padding: " + string + " not implemented");
        }
        if (this.padding != null && (this.cipherMode == 5 || this.cipherMode == 6)) {
            this.padding = null;
            throw new NoSuchPaddingException((this.cipherMode == 5 ? "CTR" : "CTS") + " mode must be used with NoPadding");
        }
    }

    int getOutputSize(int n) {
        int n2 = CipherCore.addExact(this.buffered, n);
        if (this.padding == null) {
            return n2;
        }
        if (this.decrypting) {
            return n2;
        }
        if (this.unitBytes != this.blockSize) {
            if (n2 < this.diffBlocksize) {
                return this.diffBlocksize;
            }
            int n3 = (n2 - this.diffBlocksize) % this.blockSize;
            return CipherCore.addExact(n2, this.blockSize - n3);
        }
        return CipherCore.addExact(n2, this.padding.padLength(n2));
    }

    byte[] getIV() {
        byte[] byArray = this.cipher.getIV();
        return byArray == null ? null : (byte[])byArray.clone();
    }

    AlgorithmParameters getParameters(String string) {
        AlgorithmParameters algorithmParameters = null;
        if (this.cipherMode == 0) {
            return null;
        }
        byte[] byArray = this.getIV();
        if (byArray != null) {
            AlgorithmParameterSpec algorithmParameterSpec;
            if (string.equals("RC2")) {
                RC2Crypt rC2Crypt = (RC2Crypt)this.cipher.getEmbeddedCipher();
                algorithmParameterSpec = new RC2ParameterSpec(rC2Crypt.getEffectiveKeyBits(), byArray);
            } else {
                algorithmParameterSpec = new IvParameterSpec(byArray);
            }
            try {
                algorithmParameters = AlgorithmParameters.getInstance(string, "SunJCE");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Cannot find " + string + " AlgorithmParameters implementation in SunJCE provider");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException("Cannot find SunJCE provider");
            }
            try {
                algorithmParameters.init(algorithmParameterSpec);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException("IvParameterSpec not supported");
            }
        }
        return algorithmParameters;
    }

    void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.init(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray;
        this.decrypting = n == 2 || n == 4;
        byte[] byArray2 = CipherCore.getKeyBytes(key);
        if (algorithmParameterSpec == null) {
            byArray = null;
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            byArray = ((IvParameterSpec)algorithmParameterSpec).getIV();
            if (byArray == null || byArray.length != this.blockSize) {
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
            }
        } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            byArray = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
            if (byArray != null && byArray.length != this.blockSize) {
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
        }
        if (this.cipherMode == 0) {
            if (byArray != null) {
                throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
            }
        } else if (byArray == null) {
            if (this.decrypting) {
                throw new InvalidAlgorithmParameterException("Parameters missing");
            }
            if (secureRandom == null) {
                secureRandom = SunJCE.RANDOM;
            }
            byArray = new byte[this.blockSize];
            secureRandom.nextBytes(byArray);
        }
        this.buffered = 0;
        this.diffBlocksize = this.blockSize;
        String string = key.getAlgorithm();
        this.cipher.init(this.decrypting, string, byArray2, byArray);
    }

    void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                ivParameterSpec = algorithmParameters.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.init(n, key, ivParameterSpec, secureRandom);
    }

    static byte[] getKeyBytes(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("RAW key bytes missing");
        }
        return byArray;
    }

    byte[] update(byte[] byArray, int n, int n2) {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            byArray2 = new byte[this.getOutputSize(n2)];
            int n3 = this.update(byArray, n, n2, byArray2, 0);
            if (n3 == byArray2.length) {
                byArray3 = byArray2;
            } else {
                byArray3 = new byte[n3];
                System.arraycopy(byArray2, 0, byArray3, 0, n3);
            }
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        return byArray3;
    }

    int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        int n4 = CipherCore.addExact(this.buffered, n2);
        n4 -= this.minBytes;
        if (this.padding != null && this.decrypting) {
            n4 -= this.blockSize;
        }
        int n5 = n4 = n4 > 0 ? n4 - n4 % this.unitBytes : 0;
        if (byArray2 == null || byArray2.length - n3 < n4) {
            throw new ShortBufferException("Output buffer must be (at least) " + n4 + " bytes long");
        }
        if (n4 != 0) {
            byte[] byArray3 = new byte[n4];
            int n6 = n4 - this.buffered;
            int n7 = this.buffered;
            if (n6 < 0) {
                n6 = 0;
                n7 = n4;
            }
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, byArray3, 0, n7);
            }
            if (n6 > 0) {
                System.arraycopy(byArray, n, byArray3, n7, n6);
            }
            if (this.decrypting) {
                this.cipher.decrypt(byArray3, 0, n4, byArray2, n3);
            } else {
                this.cipher.encrypt(byArray3, 0, n4, byArray2, n3);
            }
            if (this.unitBytes != this.blockSize) {
                this.diffBlocksize = n4 < this.diffBlocksize ? (this.diffBlocksize -= n4) : this.blockSize - (n4 - this.diffBlocksize) % this.blockSize;
            }
            n2 -= n6;
            n = CipherCore.addExact(n, n6);
            n3 = CipherCore.addExact(n3, n4);
            this.buffered -= n7;
            if (this.buffered > 0) {
                System.arraycopy(this.buffer, n7, this.buffer, 0, this.buffered);
            }
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.buffered, n2);
        }
        this.buffered = CipherCore.addExact(this.buffered, n2);
        return n4;
    }

    byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            byArray2 = new byte[this.getOutputSize(n2)];
            int n3 = this.doFinal(byArray, n, n2, byArray2, 0);
            if (n3 < byArray2.length) {
                byArray3 = new byte[n3];
                if (n3 != 0) {
                    System.arraycopy(byArray2, 0, byArray3, 0, n3);
                }
            } else {
                byArray3 = byArray2;
            }
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
        return byArray3;
    }

    int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int n4;
        int n5 = n4 = CipherCore.addExact(this.buffered, n2);
        int n6 = 0;
        if (this.unitBytes != this.blockSize) {
            n6 = n4 < this.diffBlocksize ? this.diffBlocksize - n4 : this.blockSize - (n4 - this.diffBlocksize) % this.blockSize;
        } else if (this.padding != null) {
            n6 = this.padding.padLength(n4);
        }
        if (n6 > 0 && n6 != this.blockSize && this.padding != null && this.decrypting) {
            throw new IllegalBlockSizeException("Input length must be multiple of " + this.blockSize + " when decrypting with padded cipher");
        }
        if (!this.decrypting && this.padding != null) {
            n5 = CipherCore.addExact(n5, n6);
        }
        if (byArray2 == null) {
            throw new ShortBufferException("Output buffer is null");
        }
        int n7 = byArray2.length - n3;
        if ((!this.decrypting || this.padding == null) && n7 < n5 || this.decrypting && n7 < n5 - this.blockSize) {
            throw new ShortBufferException("Output buffer too short: " + n7 + " bytes given, " + n5 + " bytes needed");
        }
        byte[] byArray3 = byArray;
        int n8 = n;
        if (this.buffered != 0 || !this.decrypting && this.padding != null) {
            n8 = 0;
            byArray3 = new byte[n5];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, byArray3, 0, this.buffered);
            }
            if (n2 != 0) {
                System.arraycopy(byArray, n, byArray3, this.buffered, n2);
            }
            if (!this.decrypting && this.padding != null) {
                this.padding.padWithLen(byArray3, n4, n6);
            }
        }
        if (this.decrypting) {
            int n9;
            if (n7 < n5) {
                this.cipher.save();
            }
            byte[] byArray4 = new byte[n4];
            n4 = this.finalNoPadding(byArray3, n8, byArray4, 0, n4);
            if (this.padding != null) {
                n9 = this.padding.unpad(byArray4, 0, n4);
                if (n9 < 0) {
                    throw new BadPaddingException("Given final block not properly padded");
                }
                n4 = n9;
            }
            if (byArray2.length - n3 < n4) {
                this.cipher.restore();
                throw new ShortBufferException("Output buffer too short: " + (byArray2.length - n3) + " bytes given, " + n4 + " bytes needed");
            }
            for (n9 = 0; n9 < n4; ++n9) {
                byArray2[n3 + n9] = byArray4[n9];
            }
        } else {
            n4 = this.finalNoPadding(byArray3, n8, byArray2, n3, n5);
        }
        this.buffered = 0;
        this.diffBlocksize = this.blockSize;
        if (this.cipherMode != 0) {
            this.cipher.reset();
        }
        return n4;
    }

    private int finalNoPadding(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws IllegalBlockSizeException {
        if (byArray == null || n3 == 0) {
            return 0;
        }
        if (this.cipherMode != 2 && this.cipherMode != 3 && n3 % this.unitBytes != 0 && this.cipherMode != 6) {
            if (this.padding != null) {
                throw new IllegalBlockSizeException("Input length (with padding) not multiple of " + this.unitBytes + " bytes");
            }
            throw new IllegalBlockSizeException("Input length not multiple of " + this.unitBytes + " bytes");
        }
        if (this.decrypting) {
            this.cipher.decryptFinal(byArray, n, n3, byArray2, n2);
        } else {
            this.cipher.encryptFinal(byArray, n, n3, byArray2, n2);
        }
        return n3;
    }

    byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray2 == null || byArray2.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            byArray = this.doFinal(byArray2, 0, byArray2.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return byArray;
    }

    Key unwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.doFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("The wrapped key is not padded correctly");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("The wrapped key does not have the correct length");
        }
        return ConstructKeys.constructKey(byArray2, string, n);
    }

    public static int addExact(int n, int n2) {
        int n3 = n + n2;
        if (((n ^ n3) & (n2 ^ n3)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return n3;
    }

    public static int multiplyExact(int n, int n2) {
        long l = (long)n * (long)n2;
        if ((long)((int)l) != l) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)l;
    }
}

