/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.SecurityProviderConstants;

public final class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int primeSize = SecurityProviderConstants.DEF_DH_KEY_SIZE;
    private int exponentSize = 0;
    private SecureRandom random = null;

    private static void checkKeySize(int n) throws InvalidParameterException {
        boolean bl;
        boolean bl2 = bl = n == 2048 || n == 3072 || n >= 512 && n <= 1024 && (n & 0x3F) == 0;
        if (!bl) {
            throw new InvalidParameterException("DH key size must be multiple of 64 and range from 512 to 1024 (inclusive), or 2048, 3072. The specific key size " + n + " is not supported");
        }
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        DHParameterGenerator.checkKeySize(n);
        this.primeSize = n;
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
        this.primeSize = dHGenParameterSpec.getPrimeSize();
        this.exponentSize = dHGenParameterSpec.getExponentSize();
        if (this.exponentSize <= 0 || this.exponentSize >= this.primeSize) {
            throw new InvalidAlgorithmParameterException("Exponent size (" + this.exponentSize + ") must be positive and less than modulus size (" + this.primeSize + ")");
        }
        try {
            DHParameterGenerator.checkKeySize(this.primeSize);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new InvalidAlgorithmParameterException(invalidParameterException.getMessage());
        }
        this.random = secureRandom;
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.exponentSize == 0) {
            this.exponentSize = this.primeSize - 1;
        }
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        Object var1_1 = null;
        Object var2_2 = null;
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA");
            algorithmParameterGenerator.init(this.primeSize, this.random);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            DHParameterSpec dHParameterSpec = this.exponentSize > 0 ? new DHParameterSpec(dSAParameterSpec.getP(), dSAParameterSpec.getG(), this.exponentSize) : new DHParameterSpec(dSAParameterSpec.getP(), dSAParameterSpec.getG());
            AlgorithmParameters algorithmParameters2 = AlgorithmParameters.getInstance("DH", "SunJCE");
            algorithmParameters2.init(dHParameterSpec);
            return algorithmParameters2;
        }
        catch (Exception exception) {
            throw new ProviderException("Unexpected exception", exception);
        }
    }
}

