/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.Padding;
import java.util.Arrays;
import javax.crypto.ShortBufferException;

final class PKCS5Padding
implements Padding {
    private int blockSize;

    PKCS5Padding(int n) {
        this.blockSize = n;
    }

    public void padWithLen(byte[] byArray, int n, int n2) throws ShortBufferException {
        if (byArray == null) {
            return;
        }
        int n3 = CipherCore.addExact(n, n2);
        if (n3 > byArray.length) {
            throw new ShortBufferException("Buffer too small to hold padding");
        }
        byte by = (byte)(n2 & 0xFF);
        Arrays.fill(byArray, n, n3, by);
    }

    public int unpad(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return 0;
        }
        int n3 = CipherCore.addExact(n, n2);
        byte by = byArray[n3 - 1];
        int n4 = by & 0xFF;
        if (n4 < 1 || n4 > this.blockSize) {
            return -1;
        }
        int n5 = n3 - n4;
        if (n5 < n) {
            return -1;
        }
        for (int i = n5; i < n3; ++i) {
            if (byArray[i] == by) continue;
            return -1;
        }
        return n5;
    }

    public int padLength(int n) {
        int n2 = this.blockSize - n % this.blockSize;
        return n2;
    }
}

