namespace Scintilla.Lexers
{
    using System;
    using System.Collections;
    using System.Windows.Forms;
    using System.Runtime.InteropServices;
    
    public enum Python
    {
        Default = 0,
        CommentLine = 1,
        Number = 2,
        String = 3,
        Character = 4,
        Word = 5,
        Triple = 6,
        TripleDouble = 7,
        ClassName = 8,
        DefName = 9,
        Operator = 10,
        Identifier = 11,
        CommentBlock = 12,
        StringEol = 13,
        Word2 = 14,
        Decorator = 15,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Cpp
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        CommentDoc = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Character = 7,
        Uuid = 8,
        Preprocessor = 9,
        Operator = 10,
        Identifier = 11,
        StringEol = 12,
        Verbatim = 13,
        Regex = 14,
        CommentLineDoc = 15,
        Word2 = 16,
        CommentDocKeyword = 17,
        CommentDocKeywordError = 18,
        GlobalClass = 19,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Pascal
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        CommentDoc = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Character = 7,
        Uuid = 8,
        Preprocessor = 9,
        Operator = 10,
        Identifier = 11,
        StringEol = 12,
        Verbatim = 13,
        Regex = 14,
        CommentLineDoc = 15,
        Word2 = 16,
        CommentDocKeyword = 17,
        CommentDocKeywordError = 18,
        GlobalClass = 19,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Bullant
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        CommentDoc = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Character = 7,
        Uuid = 8,
        Preprocessor = 9,
        Operator = 10,
        Identifier = 11,
        StringEol = 12,
        Verbatim = 13,
        Regex = 14,
        CommentLineDoc = 15,
        Word2 = 16,
        CommentDocKeyword = 17,
        CommentDocKeywordError = 18,
        GlobalClass = 19,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Tcl
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        Number = 3,
        WordInQuote = 4,
        InQuote = 5,
        Operator = 6,
        Identifier = 7,
        Substitution = 8,
        SubBrace = 9,
        Modifier = 10,
        Expand = 11,
        Word = 12,
        Word2 = 13,
        Word3 = 14,
        Word4 = 15,
        Word5 = 16,
        Word6 = 17,
        Word7 = 18,
        Word8 = 19,
        CommentBox = 20,
        BlockComment = 21,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Html
    {
        Default = 0,
        Tag = 1,
        TagUnknown = 2,
        Attribute = 3,
        AttributeUnknown = 4,
        Number = 5,
        DoubleString = 6,
        SingleString = 7,
        Other = 8,
        Comment = 9,
        Entity = 10,
        TagEnd = 11,
        XmlStart = 12,
        XmlEnd = 13,
        Script = 14,
        Asp = 15,
        AspAt = 16,
        CData = 17,
        Question = 18,
        Value = 19,
        XCComment = 20,
        SgmlDefault = 21,
        SgmlCommand = 22,
        Sgml1stParameter = 23,
        SgmlDoublestring = 24,
        SgmlSimplestring = 25,
        SgmlError = 26,
        SgmlSpecial = 27,
        SgmlEntity = 28,
        SgmlComment = 29,
        Sgml1stParameterComment = 30,
        SgmlBlockDefault = 31,
        JStart = 40,
        JDefault = 41,
        JComment = 42,
        JCommentline = 43,
        JCommentdoc = 44,
        JNumber = 45,
        JWord = 46,
        JKeyword = 47,
        JDoublestring = 48,
        JSinglestring = 49,
        JSymbols = 50,
        JStringeol = 51,
        JRegex = 52,
        JaStart = 55,
        JaDefault = 56,
        JaComment = 57,
        JaCommentline = 58,
        JaCommentdoc = 59,
        JaNumber = 60,
        JaWord = 61,
        JaKeyword = 62,
        JaDoublestring = 63,
        JaSinglestring = 64,
        JaSymbols = 65,
        JaStringeol = 66,
        JaRegex = 67,
        BStart = 70,
        BDefault = 71,
        BCommentline = 72,
        BNumber = 73,
        BWord = 74,
        BString = 75,
        BIdentifier = 76,
        BStringeol = 77,
        BaStart = 80,
        BaDefault = 81,
        BaCommentline = 82,
        BaNumber = 83,
        BaWord = 84,
        BaString = 85,
        BaIdentifier = 86,
        BaStringeol = 87,
        PStart = 90,
        PDefault = 91,
        PCommentline = 92,
        PNumber = 93,
        PString = 94,
        PCharacter = 95,
        PWord = 96,
        PTriple = 97,
        PTripledouble = 98,
        PClassname = 99,
        PDefname = 100,
        POperator = 101,
        PIdentifier = 102,
        PhpComplexVariable = 104,
        PaStart = 105,
        PaDefault = 106,
        PaCommentline = 107,
        PaNumber = 108,
        PaString = 109,
        PaCharacter = 110,
        PaWord = 111,
        PaTriple = 112,
        PaTripledouble = 113,
        PaClassname = 114,
        PaDefname = 115,
        PaOperator = 116,
        PaIdentifier = 117,
        PhpDefault = 118,
        PhpHstring = 119,
        PhpSimplestring = 120,
        PhpWord = 121,
        PhpNumber = 122,
        PhpVariable = 123,
        PhpComment = 124,
        PhpCommentline = 125,
        PhpHstringVariable = 126,
        PhpOperator = 127,
        ADefault = 0,
        AIdentifier = 1,
        AKeyword = 2,
        ANumber = 3,
        AString = 4,
        ACharacter = 5,
        AClass = 6,
        AModule = 7,
        ACapital = 8,
        AData = 9,
        AImport = 10,
        AOperator = 11,
        AInstance = 12,
        ACommentline = 13,
        ACommentblock = 14,
        ACommentblock2 = 15,
        ACommentblock3 = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Xml
    {
        Default = 0,
        Tag = 1,
        TagUnknown = 2,
        Attribute = 3,
        AttributeUnknown = 4,
        Number = 5,
        DoubleString = 6,
        SingleString = 7,
        Other = 8,
        Comment = 9,
        Entity = 10,
        TagEnd = 11,
        XmlStart = 12,
        XmlEnd = 13,
        Script = 14,
        Asp = 15,
        AspAt = 16,
        CData = 17,
        Question = 18,
        Value = 19,
        XCComment = 20,
        SgmlDefault = 21,
        SgmlCommand = 22,
        Sgml1stParameter = 23,
        SgmlDoublestring = 24,
        SgmlSimplestring = 25,
        SgmlError = 26,
        SgmlSpecial = 27,
        SgmlEntity = 28,
        SgmlComment = 29,
        Sgml1stParameterComment = 30,
        SgmlBlockDefault = 31,
        JStart = 40,
        JDefault = 41,
        JComment = 42,
        JCommentline = 43,
        JCommentdoc = 44,
        JNumber = 45,
        JWord = 46,
        JKeyword = 47,
        JDoublestring = 48,
        JSinglestring = 49,
        JSymbols = 50,
        JStringeol = 51,
        JRegex = 52,
        JaStart = 55,
        JaDefault = 56,
        JaComment = 57,
        JaCommentline = 58,
        JaCommentdoc = 59,
        JaNumber = 60,
        JaWord = 61,
        JaKeyword = 62,
        JaDoublestring = 63,
        JaSinglestring = 64,
        JaSymbols = 65,
        JaStringeol = 66,
        JaRegex = 67,
        BStart = 70,
        BDefault = 71,
        BCommentline = 72,
        BNumber = 73,
        BWord = 74,
        BString = 75,
        BIdentifier = 76,
        BStringeol = 77,
        BaStart = 80,
        BaDefault = 81,
        BaCommentline = 82,
        BaNumber = 83,
        BaWord = 84,
        BaString = 85,
        BaIdentifier = 86,
        BaStringeol = 87,
        PStart = 90,
        PDefault = 91,
        PCommentline = 92,
        PNumber = 93,
        PString = 94,
        PCharacter = 95,
        PWord = 96,
        PTriple = 97,
        PTripledouble = 98,
        PClassname = 99,
        PDefname = 100,
        POperator = 101,
        PIdentifier = 102,
        PhpComplexVariable = 104,
        PaStart = 105,
        PaDefault = 106,
        PaCommentline = 107,
        PaNumber = 108,
        PaString = 109,
        PaCharacter = 110,
        PaWord = 111,
        PaTriple = 112,
        PaTripledouble = 113,
        PaClassname = 114,
        PaDefname = 115,
        PaOperator = 116,
        PaIdentifier = 117,
        PhpDefault = 118,
        PhpHstring = 119,
        PhpSimplestring = 120,
        PhpWord = 121,
        PhpNumber = 122,
        PhpVariable = 123,
        PhpComment = 124,
        PhpCommentline = 125,
        PhpHstringVariable = 126,
        PhpOperator = 127,
        ADefault = 0,
        AIdentifier = 1,
        AKeyword = 2,
        ANumber = 3,
        AString = 4,
        ACharacter = 5,
        AClass = 6,
        AModule = 7,
        ACapital = 8,
        AData = 9,
        AImport = 10,
        AOperator = 11,
        AInstance = 12,
        ACommentline = 13,
        ACommentblock = 14,
        ACommentblock2 = 15,
        ACommentblock3 = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Asp
    {
        Default = 0,
        Tag = 1,
        TagUnknown = 2,
        Attribute = 3,
        AttributeUnknown = 4,
        Number = 5,
        DoubleString = 6,
        SingleString = 7,
        Other = 8,
        Comment = 9,
        Entity = 10,
        TagEnd = 11,
        XmlStart = 12,
        XmlEnd = 13,
        Script = 14,
        Asp = 15,
        AspAt = 16,
        CData = 17,
        Question = 18,
        Value = 19,
        XCComment = 20,
        SgmlDefault = 21,
        SgmlCommand = 22,
        Sgml1stParameter = 23,
        SgmlDoublestring = 24,
        SgmlSimplestring = 25,
        SgmlError = 26,
        SgmlSpecial = 27,
        SgmlEntity = 28,
        SgmlComment = 29,
        Sgml1stParameterComment = 30,
        SgmlBlockDefault = 31,
        JStart = 40,
        JDefault = 41,
        JComment = 42,
        JCommentline = 43,
        JCommentdoc = 44,
        JNumber = 45,
        JWord = 46,
        JKeyword = 47,
        JDoublestring = 48,
        JSinglestring = 49,
        JSymbols = 50,
        JStringeol = 51,
        JRegex = 52,
        JaStart = 55,
        JaDefault = 56,
        JaComment = 57,
        JaCommentline = 58,
        JaCommentdoc = 59,
        JaNumber = 60,
        JaWord = 61,
        JaKeyword = 62,
        JaDoublestring = 63,
        JaSinglestring = 64,
        JaSymbols = 65,
        JaStringeol = 66,
        JaRegex = 67,
        BStart = 70,
        BDefault = 71,
        BCommentline = 72,
        BNumber = 73,
        BWord = 74,
        BString = 75,
        BIdentifier = 76,
        BStringeol = 77,
        BaStart = 80,
        BaDefault = 81,
        BaCommentline = 82,
        BaNumber = 83,
        BaWord = 84,
        BaString = 85,
        BaIdentifier = 86,
        BaStringeol = 87,
        PStart = 90,
        PDefault = 91,
        PCommentline = 92,
        PNumber = 93,
        PString = 94,
        PCharacter = 95,
        PWord = 96,
        PTriple = 97,
        PTripledouble = 98,
        PClassname = 99,
        PDefname = 100,
        POperator = 101,
        PIdentifier = 102,
        PhpComplexVariable = 104,
        PaStart = 105,
        PaDefault = 106,
        PaCommentline = 107,
        PaNumber = 108,
        PaString = 109,
        PaCharacter = 110,
        PaWord = 111,
        PaTriple = 112,
        PaTripledouble = 113,
        PaClassname = 114,
        PaDefname = 115,
        PaOperator = 116,
        PaIdentifier = 117,
        PhpDefault = 118,
        PhpHstring = 119,
        PhpSimplestring = 120,
        PhpWord = 121,
        PhpNumber = 122,
        PhpVariable = 123,
        PhpComment = 124,
        PhpCommentline = 125,
        PhpHstringVariable = 126,
        PhpOperator = 127,
        ADefault = 0,
        AIdentifier = 1,
        AKeyword = 2,
        ANumber = 3,
        AString = 4,
        ACharacter = 5,
        AClass = 6,
        AModule = 7,
        ACapital = 8,
        AData = 9,
        AImport = 10,
        AOperator = 11,
        AInstance = 12,
        ACommentline = 13,
        ACommentblock = 14,
        ACommentblock2 = 15,
        ACommentblock3 = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Php
    {
        Default = 0,
        Tag = 1,
        TagUnknown = 2,
        Attribute = 3,
        AttributeUnknown = 4,
        Number = 5,
        DoubleString = 6,
        SingleString = 7,
        Other = 8,
        Comment = 9,
        Entity = 10,
        TagEnd = 11,
        XmlStart = 12,
        XmlEnd = 13,
        Script = 14,
        Asp = 15,
        AspAt = 16,
        CData = 17,
        Question = 18,
        Value = 19,
        XCComment = 20,
        SgmlDefault = 21,
        SgmlCommand = 22,
        Sgml1stParameter = 23,
        SgmlDoublestring = 24,
        SgmlSimplestring = 25,
        SgmlError = 26,
        SgmlSpecial = 27,
        SgmlEntity = 28,
        SgmlComment = 29,
        Sgml1stParameterComment = 30,
        SgmlBlockDefault = 31,
        JStart = 40,
        JDefault = 41,
        JComment = 42,
        JCommentline = 43,
        JCommentdoc = 44,
        JNumber = 45,
        JWord = 46,
        JKeyword = 47,
        JDoublestring = 48,
        JSinglestring = 49,
        JSymbols = 50,
        JStringeol = 51,
        JRegex = 52,
        JaStart = 55,
        JaDefault = 56,
        JaComment = 57,
        JaCommentline = 58,
        JaCommentdoc = 59,
        JaNumber = 60,
        JaWord = 61,
        JaKeyword = 62,
        JaDoublestring = 63,
        JaSinglestring = 64,
        JaSymbols = 65,
        JaStringeol = 66,
        JaRegex = 67,
        BStart = 70,
        BDefault = 71,
        BCommentline = 72,
        BNumber = 73,
        BWord = 74,
        BString = 75,
        BIdentifier = 76,
        BStringeol = 77,
        BaStart = 80,
        BaDefault = 81,
        BaCommentline = 82,
        BaNumber = 83,
        BaWord = 84,
        BaString = 85,
        BaIdentifier = 86,
        BaStringeol = 87,
        PStart = 90,
        PDefault = 91,
        PCommentline = 92,
        PNumber = 93,
        PString = 94,
        PCharacter = 95,
        PWord = 96,
        PTriple = 97,
        PTripledouble = 98,
        PClassname = 99,
        PDefname = 100,
        POperator = 101,
        PIdentifier = 102,
        PhpComplexVariable = 104,
        PaStart = 105,
        PaDefault = 106,
        PaCommentline = 107,
        PaNumber = 108,
        PaString = 109,
        PaCharacter = 110,
        PaWord = 111,
        PaTriple = 112,
        PaTripledouble = 113,
        PaClassname = 114,
        PaDefname = 115,
        PaOperator = 116,
        PaIdentifier = 117,
        PhpDefault = 118,
        PhpHstring = 119,
        PhpSimplestring = 120,
        PhpWord = 121,
        PhpNumber = 122,
        PhpVariable = 123,
        PhpComment = 124,
        PhpCommentline = 125,
        PhpHstringVariable = 126,
        PhpOperator = 127,
        ADefault = 0,
        AIdentifier = 1,
        AKeyword = 2,
        ANumber = 3,
        AString = 4,
        ACharacter = 5,
        AClass = 6,
        AModule = 7,
        ACapital = 8,
        AData = 9,
        AImport = 10,
        AOperator = 11,
        AInstance = 12,
        ACommentline = 13,
        ACommentblock = 14,
        ACommentblock2 = 15,
        ACommentblock3 = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Perl
    {
        Default = 0,
        Error = 1,
        CommentLine = 2,
        Pod = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Character = 7,
        Punctuation = 8,
        Preprocessor = 9,
        Operator = 10,
        Identifier = 11,
        Scalar = 12,
        Array = 13,
        Hash = 14,
        SymbolTable = 15,
        VariableIndexer = 16,
        Regex = 17,
        RegularExpressionSubstitution = 18,
        LongQuote = 19,
        BackTicks = 20,
        DataSection = 21,
        HereDelimeter = 22,
        HereQ = 23,
        HereQq = 24,
        HereQx = 25,
        StringQ = 26,
        StringQq = 27,
        StringQx = 28,
        StringQr = 29,
        StringQw = 30,
        PodVerb = 31,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Ruby
    {
        Default = 0,
        Error = 1,
        CommentLine = 2,
        Pod = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Character = 7,
        ClassName = 8,
        DefName = 9,
        Operator = 10,
        Identifier = 11,
        Regex = 12,
        Global = 13,
        Symbol = 14,
        ModuleName = 15,
        InstanceVar = 16,
        ClassVar = 17,
        BackTicks = 18,
        DataSection = 19,
        HereDelimeter = 20,
        HereQ = 21,
        HereQq = 22,
        HereQx = 23,
        StringQ = 24,
        StringQq = 25,
        StringQx = 26,
        StringQr = 27,
        StringQw = 28,
        WordDemoted = 29,
        StdIn = 30,
        StdOut = 31,
        StdErr = 40,
        UpperBound = 41,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum VB
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Keyword = 3,
        String = 4,
        Preprocessor = 5,
        Operator = 6,
        Identifier = 7,
        Date = 8,
        StringEol = 9,
        Keyword2 = 10,
        Keyword3 = 11,
        Keyword4 = 12,
        Constant = 13,
        Asm = 14,
        Label = 15,
        Error = 16,
        HexNumber = 17,
        BinNumber = 18,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum VBScript
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Keyword = 3,
        String = 4,
        Preprocessor = 5,
        Operator = 6,
        Identifier = 7,
        Date = 8,
        StringEol = 9,
        Keyword2 = 10,
        Keyword3 = 11,
        Keyword4 = 12,
        Constant = 13,
        Asm = 14,
        Label = 15,
        Error = 16,
        HexNumber = 17,
        BinNumber = 18,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum PowerBasic
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Keyword = 3,
        String = 4,
        Preprocessor = 5,
        Operator = 6,
        Identifier = 7,
        Date = 8,
        StringEol = 9,
        Keyword2 = 10,
        Keyword3 = 11,
        Keyword4 = 12,
        Constant = 13,
        Asm = 14,
        Label = 15,
        Error = 16,
        HexNumber = 17,
        BinNumber = 18,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Properties
    {
        Default = 0,
        Comment = 1,
        Section = 2,
        Assignment = 3,
        DefValue = 4,
        Key = 5,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Latex
    {
        Default = 0,
        Command = 1,
        Tag = 2,
        Math = 3,
        Comment = 4,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Lua
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        CommentDoc = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Character = 7,
        LiteralString = 8,
        Preprocessor = 9,
        Operator = 10,
        Identifier = 11,
        StringEol = 12,
        Word2 = 13,
        Word3 = 14,
        Word4 = 15,
        Word5 = 16,
        Word6 = 17,
        Word7 = 18,
        Word8 = 19,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum ErrorList
    {
        Default = 0,
        Python = 1,
        Gcc = 2,
        Ms = 3,
        Cmd = 4,
        Borland = 5,
        Perl = 6,
        Net = 7,
        Lua = 8,
        CTag = 9,
        DiffChanged = 10,
        DiffAddition = 11,
        DiffDeletion = 12,
        DiffMessage = 13,
        Php = 14,
        Elf = 15,
        IfC = 16,
        Ifort = 17,
        Absf = 18,
        Tidy = 19,
        JavaStack = 20,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Batch
    {
        Default = 0,
        Comment = 1,
        Word = 2,
        Label = 3,
        Hide = 4,
        Command = 5,
        Identifier = 6,
        Operator = 7,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum MakeFile
    {
        Default = 0,
        Comment = 1,
        Preprocessor = 2,
        Identifier = 3,
        Operator = 4,
        Target = 5,
        IDEol = 9,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Diff
    {
        Default = 0,
        Comment = 1,
        Command = 2,
        Header = 3,
        Position = 4,
        Deleted = 5,
        Added = 6,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Conf
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Identifier = 3,
        Extension = 4,
        Parameter = 5,
        String = 6,
        Operator = 7,
        Ip = 8,
        Directive = 9,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Avenue
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Word = 3,
        String = 6,
        Enum = 7,
        StringEol = 8,
        Identifier = 9,
        Operator = 10,
        Word1 = 11,
        Word2 = 12,
        Word3 = 13,
        Word4 = 14,
        Word5 = 15,
        Word6 = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Ada
    {
        Default = 0,
        Word = 1,
        Identifier = 2,
        Number = 3,
        Delimiter = 4,
        Character = 5,
        CharacterEol = 6,
        String = 7,
        StringEol = 8,
        Label = 9,
        CommentLine = 10,
        Illegal = 11,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Baan
    {
        Default = 0,
        Comment = 1,
        CommentDoc = 2,
        Number = 3,
        Word = 4,
        String = 5,
        Preprocessor = 6,
        Operator = 7,
        Identifier = 8,
        StringEol = 9,
        Word2 = 10,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Lisp
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Keyword = 3,
        KeywordKw = 4,
        Symbol = 5,
        String = 6,
        StringEol = 8,
        Identifier = 9,
        Operator = 10,
        Special = 11,
        MultiComment = 12,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Eiffel
    {
        Default = 0,
        CommentLine = 1,
        Number = 2,
        Word = 3,
        String = 4,
        Character = 5,
        Operator = 6,
        Identifier = 7,
        StringEol = 8,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum EiffelKW
    {
        Default = 0,
        CommentLine = 1,
        Number = 2,
        Word = 3,
        String = 4,
        Character = 5,
        Operator = 6,
        Identifier = 7,
        StringEol = 8,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum NNCronTab
    {
        Default = 0,
        Comment = 1,
        Task = 2,
        Section = 3,
        Keyword = 4,
        Modifier = 5,
        Asterisk = 6,
        Number = 7,
        String = 8,
        Environment = 9,
        Identifier = 10,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Forth
    {
        Default = 0,
        Comment = 1,
        CommentMl = 2,
        Identifier = 3,
        Control = 4,
        Keyword = 5,
        DefWord = 6,
        Preword1 = 7,
        Preword2 = 8,
        Number = 9,
        String = 10,
        Locale = 11,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Matlab
    {
        Default = 0,
        Comment = 1,
        Command = 2,
        Number = 3,
        Keyword = 4,
        String = 5,
        Operator = 6,
        Identifier = 7,
        DoubleQuoteString = 8,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Sol
    {
        Default = 0,
        White = 1,
        CommentLine = 2,
        Persistent = 3,
        CStyle = 4,
        CommentBlock = 5,
        Number = 6,
        String = 7,
        Character = 8,
        StringEol = 9,
        Keyword = 10,
        Operator = 11,
        Identifier = 12,
        Triple = 13,
        ClassName = 14,
        Preprocessor = 15,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Asm
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        String = 3,
        Operator = 4,
        Identifier = 5,
        CpuInstruction = 6,
        MathInstruction = 7,
        Register = 8,
        Directive = 9,
        DirectiveOperand = 10,
        CommentBlock = 11,
        Character = 12,
        StringEol = 13,
        ExtInstruction = 14,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Fortran
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        String1 = 3,
        String2 = 4,
        StringEol = 5,
        Operator = 6,
        Identifier = 7,
        Word = 8,
        Word2 = 9,
        Word3 = 10,
        Preprocessor = 11,
        Operator2 = 12,
        Label = 13,
        Continuation = 14,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum F77
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        String1 = 3,
        String2 = 4,
        StringEol = 5,
        Operator = 6,
        Identifier = 7,
        Word = 8,
        Word2 = 9,
        Word3 = 10,
        Preprocessor = 11,
        Operator2 = 12,
        Label = 13,
        Continuation = 14,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Css
    {
        Default = 0,
        Tag = 1,
        Class = 2,
        PseudoClass = 3,
        UnknownPseudoclass = 4,
        Operator = 5,
        Identifier = 6,
        UnknownIdentifier = 7,
        Value = 8,
        Comment = 9,
        Id = 10,
        Important = 11,
        Directive = 12,
        DoubleString = 13,
        SingleString = 14,
        Identifier2 = 15,
        Attribute = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Pov
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        Number = 3,
        Operator = 4,
        Identifier = 5,
        String = 6,
        StringEol = 7,
        Directive = 8,
        BadDirective = 9,
        Word2 = 10,
        Word3 = 11,
        Word4 = 12,
        Word5 = 13,
        Word6 = 14,
        Word7 = 15,
        Word8 = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Lout
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Word = 3,
        Word2 = 4,
        Word3 = 5,
        Word4 = 6,
        String = 7,
        Operator = 8,
        Identifier = 9,
        StringEol = 10,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum EScript
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        CommentDoc = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Operator = 7,
        Identifier = 8,
        Brace = 9,
        Word2 = 10,
        Word3 = 11,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum PS
    {
        Default = 0,
        Comment = 1,
        DscComment = 2,
        DscValue = 3,
        Number = 4,
        Name = 5,
        Keyword = 6,
        Literal = 7,
        ImmEval = 8,
        ParenArray = 9,
        ParenDict = 10,
        ParenProc = 11,
        Text = 12,
        HexString = 13,
        Base85string = 14,
        BadStringChar = 15,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Nsis
    {
        Default = 0,
        Comment = 1,
        StringDQ = 2,
        StringLQ = 3,
        StringRQ = 4,
        Function = 5,
        Variable = 6,
        Label = 7,
        UserDefined = 8,
        SecionDef = 9,
        SubsectionDef = 10,
        IfDefineDef = 11,
        MacroDef = 12,
        StringVar = 13,
        Number = 14,
        SectionGroup = 15,
        PageEx = 16,
        FunctionDef = 17,
        CommentBox = 18,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Mmixal
    {
        LeadWS = 0,
        Comment = 1,
        Label = 2,
        Opcode = 3,
        OpcodePre = 4,
        OpcodeValid = 5,
        OpcodeUnknown = 6,
        OpcodePost = 7,
        Operands = 8,
        Number = 9,
        Ref = 10,
        Char = 11,
        String = 12,
        Register = 13,
        Hex = 14,
        Operator = 15,
        Symbol = 16,
        Include = 17,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Clarion
    {
        Default = 0,
        Label = 1,
        Comment = 2,
        String = 3,
        UserIdentifier = 4,
        IntegerConstant = 5,
        RealConstant = 6,
        PictureString = 7,
        Keyword = 8,
        CompilerDirective = 9,
        RuntimeExpressions = 10,
        BuiltinProceduresFunction = 11,
        StructureDataType = 12,
        Attribute = 13,
        StandardEquate = 14,
        Error = 15,
        Deprecated = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Lot
    {
        Default = 0,
        Header = 1,
        Break = 2,
        Set = 3,
        Pass = 4,
        Fail = 5,
        Abort = 6,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Yaml
    {
        Default = 0,
        Comment = 1,
        Identifier = 2,
        Keyword = 3,
        Number = 4,
        Reference = 5,
        Document = 6,
        Text = 7,
        Error = 8,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Tex
    {
        Default = 0,
        Special = 1,
        Group = 2,
        Symbol = 3,
        Command = 4,
        Text = 5,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum MetaPost
    {
        Default = 0,
        Special = 1,
        Group = 2,
        Symbol = 3,
        Command = 4,
        Text = 5,
        Extra = 6,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Erlang
    {
        Default = 0,
        Comment = 1,
        Variable = 2,
        Number = 3,
        Keyword = 4,
        String = 5,
        Operator = 6,
        Atom = 7,
        FunctionName = 8,
        Character = 9,
        Macro = 10,
        Record = 11,
        Separator = 12,
        NodeName = 13,
        Unknown = 31,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Octave
    {
        Default = 0,
        Comment = 1,
        Command = 2,
        Number = 3,
        Keyword = 4,
        String = 5,
        Operator = 6,
        Identifier = 7,
        DoubleQuoteString = 8,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum MSSql
    {
        Default = 0,
        Comment = 1,
        LineComment = 2,
        Number = 3,
        String = 4,
        Operator = 5,
        Identifier = 6,
        Variable = 7,
        ColumnName = 8,
        Statement = 9,
        Datatype = 10,
        SysTable = 11,
        GlobalVariable = 12,
        Function = 13,
        StoredProcedure = 14,
        DefaultPrefDatatype = 15,
        ColumnName2 = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Verilog
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        CommentLineBang = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Word2 = 7,
        Word3 = 8,
        Preprocessor = 9,
        Operator = 10,
        Identifier = 11,
        StringEol = 12,
        User = 19,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Kix
    {
        Default = 0,
        Comment = 1,
        String1 = 2,
        String2 = 3,
        Number = 4,
        Var = 5,
        Macro = 6,
        Keyword = 7,
        Functions = 8,
        Operator = 9,
        Identifier = 31,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum SpecMan
    {
        Default = 0,
        Code = 1,
        CommentLine = 2,
        CommentLineBang = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Word2 = 7,
        Word3 = 8,
        Preprocessor = 9,
        Operator = 10,
        Identifier = 11,
        StringEol = 12,
        RegularExpressionTag = 13,
        Signal = 14,
        User = 19,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Au3
    {
        Default = 0,
        Comment = 1,
        CommentBlock = 2,
        Number = 3,
        Function = 4,
        Keyword = 5,
        Macro = 6,
        String = 7,
        Operator = 8,
        Variable = 9,
        Sent = 10,
        Preprocessor = 11,
        Special = 12,
        Expand = 13,
        ComObj = 14,
        Udf = 15,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Apdl
    {
        Default = 0,
        Comment = 1,
        CommentBlock = 2,
        Number = 3,
        String = 4,
        Operator = 5,
        Word = 6,
        Processor = 7,
        Command = 8,
        SlashCommand = 9,
        StarCommand = 10,
        Argument = 11,
        Function = 12,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Bash
    {
        Default = 0,
        Error = 1,
        CommentLine = 2,
        Number = 3,
        Word = 4,
        String = 5,
        Character = 6,
        Operator = 7,
        Identifier = 8,
        Scalar = 9,
        Parameter = 10,
        BackTicks = 11,
        HereDelimeter = 12,
        HereQ = 13,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Asn1
    {
        Default = 0,
        Comment = 1,
        Identifier = 2,
        String = 3,
        Oid = 4,
        Scalar = 5,
        Keyword = 6,
        Attribute = 7,
        Descriptor = 8,
        Type = 9,
        Operator = 10,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Vhdl
    {
        Default = 0,
        Comment = 1,
        CommentLineBang = 2,
        Number = 3,
        String = 4,
        Operator = 5,
        Identifier = 6,
        StringEol = 7,
        Keyword = 8,
        StdOperator = 9,
        Attribute = 10,
        StdFunction = 11,
        StdPackage = 12,
        StdType = 13,
        UserWord = 14,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Caml
    {
        Default = 0,
        Identifier = 1,
        TagName = 2,
        Keyword = 3,
        Keyword2 = 4,
        Keyword3 = 5,
        CamlLineNumber = 6,
        Operator = 7,
        Number = 8,
        Char = 9,
        String = 11,
        Comment = 12,
        Comment1 = 13,
        Comment2 = 14,
        Comment3 = 15,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Haskell
    {
        Default = 0,
        Identifier = 1,
        Keyword = 2,
        Number = 3,
        String = 4,
        Character = 5,
        Class = 6,
        Module = 7,
        Capital = 8,
        Data = 9,
        Import = 10,
        Operator = 11,
        Instance = 12,
        CommentLine = 13,
        CommentBlock = 14,
        Commentblock2 = 15,
        Commentblock3 = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Tads3
    {
        Default = 0,
        XDefault = 1,
        Preprocessor = 2,
        BlockComment = 3,
        LineComment = 4,
        Operator = 5,
        Keyword = 6,
        Number = 7,
        Identifier = 8,
        SString = 9,
        DString = 10,
        XString = 11,
        LibDirective = 12,
        MsgParam = 13,
        HtmlTag = 14,
        HtmlDefault = 15,
        HtmlString = 16,
        User1 = 17,
        User2 = 18,
        User3 = 19,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Rebol
    {
        Default = 0,
        CommentLine = 1,
        CommentBlock = 2,
        Preface = 3,
        Operator = 4,
        Character = 5,
        QuotedString = 6,
        BracedString = 7,
        Number = 8,
        Pair = 9,
        Tuple = 10,
        Binary = 11,
        Money = 12,
        Issue = 13,
        Tag = 14,
        File = 15,
        Email = 16,
        Url = 17,
        Date = 18,
        Time = 19,
        Identifier = 20,
        Word = 21,
        Word2 = 22,
        Word3 = 23,
        Word4 = 24,
        Word5 = 25,
        Word6 = 26,
        Word7 = 27,
        Word8 = 28,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Sql
    {
        Default = 0,
        Comment = 1,
        CommentLine = 2,
        CommentDoc = 3,
        Number = 4,
        Word = 5,
        String = 6,
        Character = 7,
        SqlPlus = 8,
        SqlplusPrompt = 9,
        Operator = 10,
        Identifier = 11,
        SqlplusComment = 13,
        CommentLineDoc = 15,
        Word2 = 16,
        CommentDocKeyword = 17,
        CommentDocKeywordError = 18,
        User1 = 19,
        User2 = 20,
        User3 = 21,
        User4 = 22,
        QuotedIdentifier = 23,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Smalltalk
    {
        Default = 0,
        String = 1,
        Number = 2,
        Comment = 3,
        Symbol = 4,
        Binary = 5,
        Bool = 6,
        Self = 7,
        Super = 8,
        Nil = 9,
        Global = 10,
        Return = 11,
        Special = 12,
        KWSend = 13,
        Assign = 14,
        Character = 15,
        SpecSel = 16,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Flagship
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Keyword = 3,
        String = 4,
        Preprocessor = 5,
        Operator = 6,
        Identifier = 7,
        Date = 8,
        StringEol = 9,
        Keyword2 = 10,
        Keyword3 = 11,
        Keyword4 = 12,
        Constant = 13,
        Asm = 14,
        Label = 15,
        Error = 16,
        HexNumber = 17,
        BinNumber = 18,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum CSound
    {
        Default = 0,
        Comment = 1,
        Number = 2,
        Operator = 3,
        Instr = 4,
        Identifier = 5,
        Opcode = 6,
        HeaderStatement = 7,
        UserKeyword = 8,
        CommentBlock = 9,
        Parameter = 10,
        ArateVar = 11,
        KrateVar = 12,
        IrateVar = 13,
        GlobalVar = 14,
        StringEol = 15,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Inno
    {
        Default = 0,
        Comment = 1,
        Keyword = 2,
        Parameter = 3,
        Section = 4,
        PreProc = 5,
        PreprocInline = 6,
        CommentPascal = 7,
        KeywordPascal = 8,
        KeywordUser = 9,
        StringDouble = 10,
        StringSingle = 11,
        Identifier = 12,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Opal
    {
        Space = 0,
        CommentBlock = 1,
        CommentLine = 2,
        Integer = 3,
        Keyword = 4,
        Sort = 5,
        String = 6,
        Par = 7,
        BoolConst = 8,
        Default = 32,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
    public enum Spice
    {
        Default = 0,
        Identifier = 1,
        Keyword = 2,
        Keyword2 = 3,
        Keyword3 = 4,
        Number = 5,
        Delimiter = 6,
        Value = 7,
        CommentLine = 8,
        GlobalDefault = 32,
        LineNumber = 33,
        BraceLight = 34,
        BraceBad = 35,
        ControlChar = 36,
        IndentGuide = 37,
        CallTip = 38,
        LastPredefined = 39,
        Max = 127,
    }
}
