[![License: GPL v2](https://img.shields.io/badge/License-GPL%20v2-blue.svg)](https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html)

About
=====

**The Battle for Wesnoth** is an Open Source, turn-based tactical strategy game with a high fantasy theme, featuring both singleplayer and online/hotseat multiplayer combat. Fight a desperate battle to reclaim the throne of Wesnoth, or take hand in any number of other adventures.

Community
---------

The official Battle for Wesnoth Forums:
  <https://forums.wesnoth.org/>

Discord:
  <https://discord.gg/battleforwesnoth>

IRC:
  <https://wiki.wesnoth.org/Support#IRC>

Twitter:
  <https://twitter.com/Wesnoth>

Steam forums:
  <https://steamcommunity.com/app/599390/discussions/>


Installing
----------

Wesnoth can be played on Windows, macOS, and Linux, and can be installed using:
* [Steam](https://store.steampowered.com/app/599390/Battle_for_Wesnoth/) (all)
* [itch.io](https://wesnoth.itch.io/battle-for-wesnoth) (Windows and macOS)
* The [macOS App Store](https://apps.apple.com/us/app/the-battle-for-wesnoth/id1450738104)
* standalone installers on [SourceForge](https://sourceforge.net/projects/wesnoth/files/) (Windows and macOS)
* [Flatpak](https://flathub.org/apps/details/org.wesnoth.Wesnoth) (Linux)

Additionally, Wesnoth is available for [iOS](https://apps.apple.com/us/app/battle-for-wesnoth/id575852062) and [Android](https://play.google.com/store/apps/details?id=it.alessandropira.wesnoth114).

To build the game from source, see [INSTALL](/INSTALL.md) for instructions.

Contributing
------------

Wesnoth is most in need of skilled C++ developers (C++14 and later), however there are things that nearly anyone can help with from simpler tasks in C++, the Lua and WML used for content scripting, Python used by various external tools, and even things like play testing and giving feedback on updated campaigns. Additionally, Wesnoth lacks art for a variety of unit animations - anyone who would be interested in lending a hand updating existing unit sprites or creating animations should take a look at the Art Forum as well as contact our current art director.

See also: [CONTRIBUTING](/CONTRIBUTING.md)

For any questions, the best place to start is to simply join Wesnoth's forums, Discord, or IRC and start asking!


Donations
---------

Donations can be sent via [Liberapay](https://liberapay.com/Wesnoth) as well as when downloading through itch.io. All money donated is used to pay for project expenses such as server rent and art commissions, and is very much appreciated.


License
-------

All source code is licensed under the GNU GPL v2+. Most art and music is also licensed under the GNU GPL v2+, however new contributions are now licensed under the Creative Commons BY-SA v4.0. For more detailed information on Wesnoth's licensing, see the wiki:

  <https://wiki.wesnoth.org/Wesnoth:Copyrights>


More Information
----------------

For extensive documentation about all aspects of the game, see the official Battle for Wesnoth web site:

  <https://www.wesnoth.org/>
  <https://wiki.wesnoth.org/>

A (translated) description of how to play the game can be found in doc/manual/manual.*.html, or online at:

  <https://wiki.wesnoth.org/WesnothManual>

For information on creating your own maps, scenarios, and other content, see:

  <https://wiki.wesnoth.org/Create>
