#include <libsoup/soup.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "support.h"
#include "tracks.h"

#define LOG_INTERVAL 9
#define NETWORK_TIMEOUT 60
#define LOGSERVER "http://www.tangogps.org"
#define LOGPATH "/friends/track_upload.php"

static SoupSession *session = NULL;

SoupSession * 
create_data_soupsession();

void
send_data();

static void
send_data_cb (SoupSession *session, SoupMessage *msg, gpointer user_data);



void
data_upload ()
{
	GSList *list, *loaded_track;
	GtkWidget *widget;
	trackpoint_t *tp = NULL;
	GString *string;
	const char *nick, *pass;
	char *login;

	loaded_track = get_loaded_track();
	
	
	widget = lookup_widget(window1, "entry7");
	nick = gtk_entry_get_text(GTK_ENTRY(widget));
	widget = lookup_widget(window1, "entry8");
	pass = gtk_entry_get_text(GTK_ENTRY(widget));
	
	login = soup_form_encode("nick",nick,"pass",pass,NULL);
	
	string = g_string_new("");	
	g_string_append_printf(string, "%s&body=",login);

	for(list = loaded_track; list != NULL; list = list->next)
	{
		tp = list->data;
		
		g_string_append_printf(string, "|||%s|%f|%f|%.1f|%.1f|%.0f|%.0f|%d%%0A",
					tp->time_iso8106, tp->lat_deg, tp->lon_deg,
					tp->alt, tp->speed, tp->head, tp->hdop, tp->heart);
	}

	
	send_data(string->str);		
	
	g_string_free(string, FALSE);
	g_free(login);
}


void
send_data(const char *formdata)
{
	GtkWidget *widget;
	SoupMessage *msg;

	widget = lookup_widget(window1, "label203");
	gtk_label_set_label(GTK_LABEL(widget), "<b>Uploading...</b>");
	
	msg = soup_message_new ("POST", LOGSERVER LOGPATH);
	soup_message_set_request (	msg, "application/x-www-form-urlencoded",
					SOUP_MEMORY_TAKE,
					formdata, strlen (formdata));
	
	if (!session) session = create_data_soupsession();
	soup_session_queue_message (session, msg, send_data_cb, NULL);
}


static void
send_data_cb (SoupSession *session, SoupMessage *msg, gpointer user_data)
{
	GtkWidget *widget;

	widget = lookup_widget(window1, "label203");
	
	if (SOUP_STATUS_IS_SUCCESSFUL (msg->status_code))
	{
		
		printf("reply: %s \n", msg->response_body->data);
		gtk_label_set_label(GTK_LABEL(widget), msg->response_body->data);
	}
	else
	{
		char *str;
		
		printf("status %d \n", msg->status_code);
		
		str = g_strdup_printf("Upload failed - %d", msg->status_code);
		gtk_label_set_label(GTK_LABEL(widget), str);
	}
}



SoupSession * 
create_data_soupsession() 
{
	SoupSession *session;
	
	session = soup_session_async_new_with_options (
			SOUP_SESSION_ADD_FEATURE_BY_TYPE, SOUP_TYPE_COOKIE_JAR,
			SOUP_SESSION_USER_AGENT, VERSION ,
			SOUP_SESSION_IDLE_TIMEOUT, NETWORK_TIMEOUT, 
			SOUP_SESSION_TIMEOUT, NETWORK_TIMEOUT,
			NULL);

#if 0
	SoupLogger *logger;
	logger = soup_logger_new (SOUP_LOGGER_LOG_BODY, -1);
	soup_session_add_feature (session, SOUP_SESSION_FEATURE (logger));
	g_object_unref (logger);
#endif
	
	return session;
}
