#include "config.h"
#include "ui_config.h"
#include <QSettings>


config::config(QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::config)
{
    m_ui->setupUi(this);
}

config::~config()
{
    delete m_ui;
}

void config::changeEvent(QEvent *e)
{
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void config::on_buttonBox_accepted()
{
    QString types = "";
    if (m_ui->chkBmp->isChecked())
    {
        types = "*.bmp";
    }
    if (m_ui->chkJpg->isChecked())
    {
        if (types != "")
        {
            types += ";*.jpg;*.jpeg";
        }
        else
        {
          types = "*.jpg;*.jpeg";
        }
     }
    if (m_ui->chkPng->isChecked())
    {
        if (types != "")
        {
            types += ";*.png";
        }
        else
        {
          types = "*.png";
        }
     }
    if (m_ui->chkTif->isChecked())
    {
        if (types != "")
        {
            types += ";*.tif;*.tiff";
        }
        else
        {
          types = "*.tif;*.tiff";
        }
     }


    QString sizes = "1024x768;800x600;Custom";
    for (int i=0; i < m_ui->listSize->count(); i++)
    {
        sizes += ";"+m_ui->listSize->item(i)->text();
    }
    QSettings settings("beli.ws","baires");
    settings.setValue("cmbRes",sizes);
    settings.setValue("Language",m_ui->cmbLanguage->currentIndex()+1);
    settings.setValue("Types",types);
    settings.sync();
}

void config::on_btnRemove_clicked()
{
    if (m_ui->listSize->currentItem())
    {
        delete m_ui->listSize->currentItem();
    }
}
