#include "dxf_create_elmt.h"

extern struct ALG Max_alg;
extern struct BLOCK Max_block;
extern struct ENTITIE Max_entitie;

extern struct DXF_base DXF_main_base[1];
extern struct DXF_header DXF_input_header[DXF_L_HEADER];
extern struct DXF_table_block_record DXF_input_table_block_record[DXF_LT_BLOCK_RECORD];

extern struct DXF_entities_arc DXF_input_entities_arc[DXF_LE_ARC];
extern struct DXF_entities_line DXF_input_entities_line[DXF_LE_LINE];
extern struct DXF_entities_attdef DXF_input_entities_attdef[DXF_LE_ATTDEF];
extern struct DXF_entities_attrib DXF_input_entities_attrib[DXF_LE_ATTRIB];
extern struct DXF_entities_circle DXF_input_entities_circle[DXF_LE_CIRCLE];
extern struct DXF_entities_point DXF_input_entities_point[DXF_LE_POINT];
extern struct DXF_entities_text DXF_input_entities_text[DXF_LE_TEXT];
extern struct DXF_entities_ellipse DXF_input_entities_ellipse[DXF_LE_ELLIPSE];
extern struct DXF_entities_insert DXF_input_entities_insert[DXF_LE_INSERT];
extern struct DXF_entities_polyline DXF_input_entities_polyline[DXF_LE_POLYLINE];
extern struct DXF_entities_seqend DXF_input_entities_seqend[DXF_LE_SEQEND];
extern struct DXF_entities_vertex DXF_input_entities_vertex[DXF_LE_VERTEX];
extern struct DXF_entities_lwpolyline DXF_input_entities_lwpolyline[DXF_LE_LWPOLYLINE];
extern struct DXF_entities_solid DXF_input_entities_solid[DXF_LE_SOLID];

extern struct DXF_block_line DXF_input_block_line[DXF_L_BLOCK][DXF_LB_LINE];
extern struct DXF_block_arc DXF_input_block_arc[DXF_L_BLOCK][DXF_LB_ARC];
extern struct DXF_block_attdef DXF_input_block_attdef[DXF_L_BLOCK][DXF_LB_ATTDEF];
extern struct DXF_block_attrib DXF_input_block_attrib[DXF_L_BLOCK][DXF_LB_ATTRIB];
extern struct DXF_block_circle DXF_input_block_circle[DXF_L_BLOCK][DXF_LB_CIRCLE];
extern struct DXF_block_ellipse DXF_input_block_ellipse[DXF_L_BLOCK][DXF_LB_ELLIPSE];

extern struct DXF_block_lwpolyline DXF_input_block_lwpolyline[DXF_L_BLOCK][DXF_LB_LWPOLYLINE];
extern struct DXF_block_point DXF_input_block_point[DXF_L_BLOCK][DXF_LB_POINT];
extern struct DXF_block_polyline DXF_input_block_polyline[DXF_L_BLOCK][DXF_LB_POLYLINE];
extern struct DXF_block_seqend DXF_input_block_seqend[DXF_L_BLOCK][DXF_LB_SEQEND];
extern struct DXF_block_text DXF_input_block_text[DXF_L_BLOCK][DXF_LB_TEXT];
extern struct DXF_block_vertex DXF_input_block_vertex[DXF_L_BLOCK][DXF_LB_VERTEX];

DXF_create_elmt::DXF_create_elmt(QWidget *parent) : QWidget(parent)//:
	//QMainWindow(parent)
{

}

 QString DXF_create_elmt::Make_ELMT()
{
	Result="";

	BaseELMT Create_ELMT;

	Count_lines=0;
	Count_header=DXF_main_base[0].dxf_header_item_count-1;
	DXF_LIMMAX=0;
	DXF_LIMMIN=0;
	DXF_LIMMAX_x=0;
	DXF_LIMMAX_y=0;
	DXF_LIMMIN_x=0;
	DXF_LIMMIN_y=0;

	while (Count_lines<Count_header)
	{

		if (DXF_input_header[Count_lines].dxf_setvar_naam=="$LIMMAX")
		{
			DXF_LIMMAX_x = DXF_input_header[Count_lines].dxf_setvar_code_10;
			DXF_LIMMAX_y = DXF_input_header[Count_lines].dxf_setvar_code_20;
			DXF_LIMMAX=1;
		}

		if (DXF_input_header[Count_lines].dxf_setvar_naam=="$LIMMIN")
		{
			DXF_LIMMIN_x = DXF_input_header[Count_lines].dxf_setvar_code_10;
			DXF_LIMMIN_y = DXF_input_header[Count_lines].dxf_setvar_code_20;
			DXF_LIMMIN=1;
		}

		if (DXF_LIMMAX==1 and DXF_LIMMIN==1)
		{
			Count_lines=Count_header+1;

		}
		else
		{
			Count_lines=Count_lines+1;
		}

	}

	if (DXF_LIMMAX==1 and DXF_LIMMIN==1)
	{
		if (DXF_LIMMAX_x<0)
		{
			DXF_LIMMAX_x= -DXF_LIMMAX_x;
		}
		if (DXF_LIMMAX_y<0)
		{
			DXF_LIMMAX_y= -DXF_LIMMAX_y;
		}
		if (DXF_LIMMIN_x<0)
		{
			DXF_LIMMIN_x= -DXF_LIMMIN_x;
		}
		if (DXF_LIMMIN_y<0)
		{
			DXF_LIMMIN_y= -DXF_LIMMIN_y;
		}

		Create_ELMT.ELMT_definition_width=QString::number((DXF_LIMMAX_x+DXF_LIMMIN_x)*DXF_main_base[0].dxf_X_factor,'f',2);
		Create_ELMT.ELMT_definition_height=QString::number((DXF_LIMMAX_y+DXF_LIMMIN_y)*DXF_main_base[0].dxf_Y_factor,'f',2);

	}
	else
	{
		Create_ELMT.ELMT_definition_height="50";
		Create_ELMT.ELMT_definition_width="40";
	}

	Create_ELMT.ELMT_definition_version="0.5";
	Create_ELMT.ELMT_definition_hotspot_x="0";
	Create_ELMT.ELMT_definition_hotspot_y="0";
	Create_ELMT.ELMT_definition_link_type="master";
	Create_ELMT.ELMT_definition_type="element";
	Create_ELMT.ELMT_definition_orientation="dyyy";

	Result.append(Create_ELMT.DefinitionStart());

	Result.append(Create_ELMT.Uuid());

	Create_ELMT.ELMT_Name_text_ar=DXF_main_base[0].DXF_ELMT_Name_text_ar;
	if (Create_ELMT.ELMT_Name_text_ar != "")
	{
		Create_ELMT.ELMT_Name_ar="ar";
	}
	else
	{
		Create_ELMT.ELMT_Name_ar="-";
	}


	Create_ELMT.ELMT_Name_text_de=DXF_main_base[0].DXF_ELMT_Name_text_de;
	if (Create_ELMT.ELMT_Name_text_de != "")
	{
		Create_ELMT.ELMT_Name_de="de";
	}
	else
	{
		Create_ELMT.ELMT_Name_de="-";
	}


	Create_ELMT.ELMT_Name_text_en=DXF_main_base[0].DXF_ELMT_Name_text_en;
	if (Create_ELMT.ELMT_Name_text_en != "")
	{
		Create_ELMT.ELMT_Name_en="en";
	}
	else
	{
		Create_ELMT.ELMT_Name_en="-";
	}

	Create_ELMT.ELMT_Name_text_it=DXF_main_base[0].DXF_ELMT_Name_text_it;
	if (Create_ELMT.ELMT_Name_text_it != "")
	{
		Create_ELMT.ELMT_Name_it="it";
	}
	else
	{
		Create_ELMT.ELMT_Name_it="-";
	}

	Create_ELMT.ELMT_Name_text_fr=DXF_main_base[0].DXF_ELMT_Name_text_fr;
	if (Create_ELMT.ELMT_Name_text_fr != "")
	{
		Create_ELMT.ELMT_Name_fr="fr";
	}
	else
	{
		Create_ELMT.ELMT_Name_fr="-";
	}

	Create_ELMT.ELMT_Name_text_pl=DXF_main_base[0].DXF_ELMT_Name_text_pl;
	if (Create_ELMT.ELMT_Name_text_pl != "")
	{
		Create_ELMT.ELMT_Name_pl="pl";
	}
	else
	{
		Create_ELMT.ELMT_Name_pl="-";
	}

	Create_ELMT.ELMT_Name_text_es=DXF_main_base[0].DXF_ELMT_Name_text_es;
	if (Create_ELMT.ELMT_Name_text_es != "")
	{
		Create_ELMT.ELMT_Name_es="es";
	}
	else
	{
		Create_ELMT.ELMT_Name_es="-";
	}

	Create_ELMT.ELMT_Name_text_nl=DXF_main_base[0].DXF_ELMT_Name_text_nl;
	if (Create_ELMT.ELMT_Name_text_nl != "")
	{
		Create_ELMT.ELMT_Name_nl="nl";
	}
	else
	{
		Create_ELMT.ELMT_Name_nl="-";
	}

	Create_ELMT.ELMT_Name_text_cs=DXF_main_base[0].DXF_ELMT_Name_text_cs;
	if (Create_ELMT.ELMT_Name_text_cs != "")
	{
		Create_ELMT.ELMT_Name_cs="cs";
	}
	else
	{
		Create_ELMT.ELMT_Name_cs="-";
	}

	Create_ELMT.ELMT_Name_text_be_nl=DXF_main_base[0].DXF_ELMT_Name_text_be_nl;
	if (Create_ELMT.ELMT_Name_text_be_nl != "")
	{
		Create_ELMT.ELMT_Name_be_nl="be-nl";
	}
	else
	{
		Create_ELMT.ELMT_Name_be_nl="-";
	}

	Result.append(Create_ELMT.Names());
	//Result.append(Create_ELMT.KindInformation());
	Result.append(Create_ELMT.Informations());
	Result.append(Create_ELMT.DescriptionStart());

	dxf_entitie_input Make_entitie_input;
	dxf_entitie_terminal Make_entitie_terminal;

	Make_entitie_input.Entitie_rotate="true";
	Make_entitie_input.Entitie_tag="label";
	Make_entitie_input.Entitie_text="_";
	Make_entitie_input.Entitie_rotation=0;


	Result.append(Make_entitie_input.dxf_entitie_make_input());			// basic item needed by elmt editor

	Make_entitie_terminal.Entitie_orientation="n";
	Result.append(Make_entitie_terminal.dxf_entitie_make_terminal());	// basic item needed by elmt editor

	/* create function instances */

	dxf_entitie_line Make_entitie_line;
	dxf_entitie_arc Make_entitie_arc;
	dxf_entitie_attdef Make_entitie_attdef;
	dxf_entitie_attrinute Make_entitie_attribute;
	dxf_entitie_circle Make_entitie_circle;
	dxf_entitie_point Make_entitie_point;
	dxf_entitie_text Make_entitie_text;
	dxf_entitie_ellipse Make_entitie_ellipse;
	dxf_entitie_polyline Make_entitie_polyline;
	dxf_entitie_insert Make_entitie_insert;
	dxf_entitie_lwpolyline Make_entitie_lwpolyline;
	dxf_entitie_solid Make_entitie_solid;

	Color_entitie=DXF_main_base[0].dxf_entitie_color;
	Color_block=DXF_main_base[0].dxf_block_color;
	Color_inserted_block=DXF_main_base[0].dxf_insert_block_color;


	/* LINE */

	Make_entitie_line.Count_entitie_line=DXF_main_base[0].DXF_entities_line_count;
	Make_entitie_line.Entitie_color=Color_entitie;
	Make_entitie_line.Entitie_filling="none";
	Make_entitie_line.Entitie_line_weight="thin";

	Result.append(Make_entitie_line.dxf_entitie_make_line());

	/* ARC */

	Make_entitie_arc.Count_entitie_arc=DXF_main_base[0].DXF_entities_arc_count;
	Make_entitie_arc.Entitie_color=Color_entitie;
	Make_entitie_arc.Entitie_antialias="false";
	Make_entitie_arc.Entitie_filling="none";
	Make_entitie_arc.Entitie_line_weight="thin";

	Result.append(Make_entitie_arc.dxf_entitie_make_arc());

	/* ATTDEF */

	Make_entitie_attdef.Count_entitie_attdef=DXF_main_base[0].DXF_entities_attdef_count;
	Make_entitie_attdef.Entitie_color=Color_entitie;
	Make_entitie_attdef.Entitie_tag="label";
	Make_entitie_attdef.Entitie_rotate="true";

	Result.append(Make_entitie_attdef.dxf_entitie_make_attdef());

	/* ATTR */

	Make_entitie_attribute.Count_entitie_attr=DXF_main_base[0].DXF_entities_attrib_count;
	Make_entitie_attribute.Entitie_color=Color_entitie;
	Make_entitie_attribute.Entitie_tag="label";
	Make_entitie_attribute.Entitie_rotate="true";

	Result.append(Make_entitie_attribute.dxf_entitie_make_attribute());

	/* CIRCLE */

	Make_entitie_circle.Count_entitie_circle=DXF_main_base[0].DXF_entities_circle_count;
	Make_entitie_circle.Entitie_color=Color_entitie;
	Make_entitie_circle.Entitie_antialias="true";
	Make_entitie_circle.Entitie_filling="none";
	Make_entitie_circle.Entitie_line_weight="thin";

	Result.append(Make_entitie_circle.dxf_entitie_make_circle());



	/* POINT */

	Make_entitie_point.Count_entitie_point=DXF_main_base[0].DXF_entities_point_count;
	Make_entitie_point.Entitie_orientation="n";

	Result.append(Make_entitie_point.dxf_entitie_make_point());

	/* TEXT */

	Make_entitie_text.Count_entitie_text=DXF_main_base[0].DXF_entities_text_count;
	Make_entitie_text.Entitie_color=Color_entitie;

	Result.append(Make_entitie_text.dxf_entitie_make_text());

	/* ELLIPSE */

	Make_entitie_ellipse.Count_entitie_ellipse=DXF_main_base[0].DXF_entities_ellipse_count;
	Make_entitie_ellipse.Entitie_color=Color_entitie;
	Make_entitie_ellipse.Entitie_antialias="true";
	Make_entitie_ellipse.Entitie_filling="none";
	Make_entitie_ellipse.Entitie_line_weight="thin";

	Result.append(Make_entitie_ellipse.dxf_entitie_make_ellipse());

	/* POLYLINE */

	Make_entitie_polyline.Count_entitie_polyline=DXF_main_base[0].DXF_entities_polyline_count;
	Make_entitie_polyline.Entitie_color=Color_entitie;
	Make_entitie_polyline.Entitie_antialias="false";
	Make_entitie_polyline.Entitie_filling="none";
	Make_entitie_polyline.Entitie_line_weight="thin";
	Make_entitie_polyline.Entitie_line_style="normal";


	Result.append(Make_entitie_polyline.dxf_entitie_make_polyline());

	/* INSERT */

	Make_entitie_insert.Count_entitie_insert=DXF_main_base[0].dxf_block_item_count;
	Make_entitie_insert.Flag_Block_insert=0;
	Make_entitie_insert.Flag_Entitie_block_insert=1;

	//Make_entitie_insert.Insert_block_nr
	Result.append(Make_entitie_insert.dxf_entitie_make_insert());

	/* LWPOLYLINE */
	Make_entitie_lwpolyline.Count_entitie_lwpolyline=DXF_main_base[0].DXF_entities_lwpolyline_count;
	Make_entitie_lwpolyline.Entitie_color=Color_entitie;
	Make_entitie_lwpolyline.Entitie_antialias="false";
	Make_entitie_lwpolyline.Entitie_filling="none";
	Make_entitie_lwpolyline.Entitie_line_weight="thin";
	Make_entitie_lwpolyline.Entitie_line_style="normal";
	Result.append(Make_entitie_lwpolyline.dxf_entitie_make_lwpolyline());

	/* SOLID */
	Make_entitie_solid.Count_entitie_solid=DXF_main_base[0].DXF_entities_solid_count;
	Make_entitie_solid.Entitie_color="red";//Color_entitie;
	Make_entitie_solid.Entitie_antialias="false";
	Make_entitie_solid.Entitie_filling="true";
	Make_entitie_solid.Entitie_line_weight="thin";
	Make_entitie_solid.Entitie_line_style="normal";
	Result.append(Make_entitie_solid.dxf_entitie_make_solid());

	/* Close elmt description */

	Result.append(Create_ELMT.DescriptionEnd());
	Result.append(Create_ELMT.DefinitionEnd());

	return Result;
}



