#ifndef DXFTOQET_MAINWINDOW_H
#define DXFTOQET_MAINWINDOW_H


#include <QWidget>
#include <QObject>
#include <QMessageBox>
#include <QtWidgets>
#include <QTableView>

#include "src/dxf_data.h"
#include "src/dxf_table_size.h"
#include "src/dxf_load.h"
#include "src/dxf_split.h"
#include "src/split_csv.h"
#include "src/csv_build_table.h"
#include "dxf_create_elmt.h"
#include "csv_create_elmt.h"

#include <QTextStream>
#include <QFileDialog>
#include <QFile>
#include <QModelIndex>




namespace Ui {
	class DXFtoQET_MainWindow;
	class dxf_split;

}

class DXFtoQET_MainWindow : public QWidget , public dxf_data //QMainWindow
{
	Q_OBJECT

	public:

	explicit DXFtoQET_MainWindow(QWidget *parent = 0);
	~DXFtoQET_MainWindow();



	int main_sw1; // Binaery = 0 ASCII = 1
	int main_sw2; // CSV = 1
	int main_sw3; // DXF = 1

	int CSV_line_count;
	int CSV_row;
	int CSV_col;

	int csv_elmt_count;

	int split_count1;
	int counter_Split;
	int split_lenght;


	QString log_file;
	QString log_trans;
	QString log_split;
	QString status1;

	QString FileType;
	QString FileName;
	QString Filename2;
	QString Config_QET_User_Symbols;
	QString Config_DXF_Block_color;
	QString Config_DXF_Entities_color;
	QString Config_save_to_file;
	QString Config_in_read_all;

	QStringList Config_list;
	QStringList Config_List_Split;

	QString Result;
	QString Result4;

	QStandardItemModel *model;
	QStandardItemModel *model2;
	QStandardItemModel *model3;
	QAbstractItemModel *model4;
	QAbstractItemModel *model5;

	QStringList List2;
	QStringList List3;

	void CSV_Load_QTable();
	void CSV_Load_settings();
	void DXF_Block_table();
	void Clear_view();
	void Clear_struct();

	protected:
	void changeEvent(QEvent *e);

	private slots:

	void on_actionOpen_triggered();

	void on_actionSave_as_elmt_triggered();

	void on_actionSave_as_qet_triggered();



	void on_load_into_tables_clicked();

	void on_cload_cvs_into_tables_clicked();




	void on_CSV_create_elmt_clicked();

	void on_CSV_create_qet_clicked();

	void on_create_elmt_clicked();

	void on_pushButton_clicked();



	void on_savepath_clicked();

	void on_savepath_2_clicked();

	void on_Save_config_file_clicked();

	void on_Open_config_file_clicked();

	private:
	Ui::DXFtoQET_MainWindow *ui;
};

#endif // DXFTOQET_MAINWINDOW_H
