#include "dxf_arc.h"
#include "dxf_base_types/dxf_base_arc.h"

dxf_arc::dxf_arc(QWidget *parent) :
	QWidget(parent)
{
}

QString dxf_arc::Create_ARC()
{

	dxf_base_arc db_arc2;

	Result_line ="";

	db_arc2.QET_x=center_x - radius;		// 10
	db_arc2.QET_y=(center_y) - radius;		// 20
	db_arc2.QET_width=radius*2;
	db_arc2.QET_height=radius*2;
	db_arc2.QET_antialias=antialias;

	DXF_Ltype_control db_line_ltype_control;

	db_line_ltype_control.FindLT=ltype;
	db_line_ltype_control.Layer=layer;


	db_arc2.QET_line_style=db_line_ltype_control.Ltype_control();

	db_arc2.QET_line_weight=line_weight;
	db_arc2.QET_filling=filling;
	db_arc2.QET_color=color;

	/*
		h = (450° - acad°)/30
		qet° = 30* (450° - acad°)/30 = 450° - acad°
		dus als acad_start° = 60° Þ qet_start° = 450° - 60° = 390° en opnieuw qet_start° > 360° dus qet_start° = 390° - 360° = 30°
		acad­­_end° = 110° Þ qet_end° = 450° - 110° = 340° < 360° dus die hoek blijft 340°
		qet_hoek° = qet_end° - qet_start° = 340° - 30° = 310°

	*/

	/* hoek ACAD omrekenen naar QET */


	begin1=450-start_angle;
	einde1=450-end_angle;


	if (begin1>360)
	{
		begin=begin1-360;
	}
	else
	{
		if(begin1<0)
		{
			begin=360-begin1;
		}
		else
		{
			begin=begin1;
		}
	}

	if (einde1>360)
	{
		einde=einde1-360;
	}
	else
	{
		if (einde1<0)
		{
			einde=einde1-360;
		}
		else
		{
			einde=einde1;
		}
	}



	/* calculate hoek */

	if (begin>einde)
	{
		N=einde-begin;
	}
	else
	{
		N=einde-begin-360;
	}

	if (N<0)
	{
		O=-N;
	}
	else
	{
		O=N;
	}

	J=end_angle-start_angle+N;
	K=360-end_angle;
	L=360-start_angle;
	M=K-L;
	R=-O;
	S=J-O;

	if (S < -360)
	{
		T=S+360;
	}
	else
	{
		T=S;
	}

	if (begin<einde)
	{
		U=M;
	}
	else
	{
		U=T;
	}

	if (U<0)
	{
		V=-U;
	}
	else
	{
		V=U;
	}

	W=U+V;

	if (W==0)
	{
		hoek2=-V;
	}
	else
	{
		hoek2=T;
	}


	/* einde omrekening */

	db_arc2.QET_angle=-hoek2;
	db_arc2.QET_start=-(begin-90);

	//if(db_arc2.QET_width==0 and db_arc2.QET_height==0)
	//{
	//}
	//else
	//{
		Result_line.append(db_arc2.Create_arc());
	//}
	return Result_line;
}
