# $Id$
##
##  This file is part of pyFormex 1.0.2  (Thu Jun 18 15:35:31 CEST 2015)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2015 (C) Benedict Verhegghe (benedict.verhegghe@feops.com)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""Menus for the pyFormex GUI.

This modules implements specialized classes and functions for building
the pyFormex GUI menu system.
"""
from __future__ import absolute_import, division, print_function

import os
from gettext import gettext as _

import pyformex as pf
from pyformex import (
    zip, utils, script,
    )
from pyformex.gui import (
    QtGui, QtCore, Signal,
    toolbar, image, draw,
    )

from pyformex.odict import OrderedDict


#save = NotImplemented
#saveAs = NotImplemented

## def editor():
##     if pf.GUI.editor:
##         print("Close editor")
##         pf.GUI.closeEditor()
##     else:
##         print("Open editor")
##         pf.GUI.showEditor()


def resetWarnings():
    """Reset the warning filters to the default."""
    del pf.prefcfg['warnings/filters']
    print("This will only become effective in your future sessions!")
    print("FILTERS:", pf.prefcfg['warnings/filters'])


# The menu actions can be simply function names instead of strings, if the
# functions have already been defined here.

def printwindow():
    pf.app.syncX()
    r = pf.GUI.frameGeometry()
    print("Qt4 geom(w,h,x,y): %s,%s,%s,%s" % (r.width(), r.height(), r.x(), r.y()))
    print("According to xwininfo, (x,y) is %s,%s" % pf.GUI.XPos())


_geometry=None

def saveGeometry():
    global _geometry
    _geometry = pf.GUI.saveGeometry()

def restoreGeometry():
    pf.GUI.restoreGeometry(_geometry)


def moveCorrect():
    pf.GUI.move(*pf.GUI.XPos())

def closeLogFile():
    if draw.logfile:
        draw.logfile.close()
        draw.logfile = None

def openLogFile():
    fn = draw.askFilename(filter=['*.log', '*'], multi=False)
    if fn:
        closeLogFile()
        draw.logfile = open(fn, 'w')


def saveBoard():
    fn = draw.askFilename(filter=['*.txt', '*'], multi=False, exist=False)
    if fn:
        pf.GUI.board.save(fn)


def unloadCurrentApp():
    appname = pf.cfg['curfile']
    from pyformex import apps
    apps.unload(appname)


def printSysPath():
    import sys
    print(sys.path)


def printModules():
    import sys
    print(sorted(sys.modules.keys()))


def printLastCommand():
    print(utils.lastCommandReport())


MenuData = (_('&Actions'),[
    (_('&Play'), draw.play),
    (_('&Rerun'), draw.replay),
    ## (_('&Step'),draw.step),
    (_('&Continue'), draw.fforward),
    (_('&Stop'), draw.raiseExit),
    ("---", None),
    (_('&App Info'), draw.showDoc),
    ## (_('&Run All Examples'),runAllExamples),
    ("---", None),
    ## (_('&Reset Picking Mode'),resetPick),
    (_('&Reset GUI'), draw.resetGUI),
    (_('&Reset Warning Filters'), resetWarnings),
    (_('&Force Finish Script'), script.force_finish),
    (_('&Unload Current App'), unloadCurrentApp),
    ## (_('&Execute single statement'),command),
    (_('&Save Message Board'), saveBoard),
    (_('&Open Log File'), openLogFile),
    (_('&Close Log File'), closeLogFile),
    (_('&Print Global Names'), script.printglobalnames),
    (_('&Print Globals'), script.printglobals),
    (_('&Print Config'), script.printconfig),
    (_('&Print Last Command'), printLastCommand),
    (_('&Print Detected Software'), script.printdetected),
    (_('&Print Loaded Apps'), script.printLoadedApps),
    (_('&Print sys.path'), printSysPath),
    (_('&Print loaded modules'), printModules),
    (_('&Print Used Memory'), script.printVMem),
    (_('&Print Environment'), script.printEnv),
    (_('&PrintBbox'), draw.printbbox),
    (_('&Print Viewport Settings'), draw.printviewportsettings),
    (_('&Print Window Geometry'), printwindow),
    (_('&Correct the Qt4 Geometry'), moveCorrect),
    (_('&Save Geometry'), saveGeometry),
    (_('&Restore Geometry'), restoreGeometry),
    (_('&Toggle Input Timeout'), toolbar.timeout),
    ])


# End
