#ifndef ABOUT_H
#define ABOUT_H

#include <libintl.h>
#ifndef gettext_noop
#define gettext_noop(String) String
#endif

static const char *about_text =
gettext_noop("Welcome to Tux Paint's graphical configuration tool.\n" "\n"
             "This tool allows you to alter Tux Paint's settings, such as "
             "full-screen mode, the interface's language, or options to simplify "
             "Tux Paint for younger children.\n" "\n"
             "You may adjust settings for the current user only, or for all users "
             "of your computer (\"system-wide\") by making a selection in the "
             "'Settings for' pull-down menu at the bottom.\n" "\n"
             "When modifying the current users' settings, you can choose to merge "
             "any system-wide (\"All Users\") settings with the user settings "
             "(the default behavior), discard any system-wide settings (use ONLY "
             "the user settings), or use only the system-wide settings "
             "(which removes the user's configuration file).\n" "\n"
             "Use the tabs at the top to select the different setting categories, "
             "adjust the options you'd like to change, and click the 'Apply' "
             "button at the bottom to write out a new configuration file.\n"
             "\n"
             "The next time Tux Paint is launched, the new settings should take "
             "effect.");

#endif /* ABOUT_H */
