#include <string/vsx_string_helper.h>
#include <test/vsx_test.h>
#include <filesystem/tree/vsx_filesystem_tree_writer.h>
#include <filesystem/tree/vsx_filesystem_tree_serialize_string.h>
#include <filesystem/tree/vsx_filesystem_tree_serialize_binary.h>
#include <filesystem/tree/vsx_filesystem_tree_reader.h>
#include <perf/vsx_perf.h>
#include <filesystem/mmap/vsx_filesystem_mmap.h>


void test_level2()
{
  vsx_filesystem_tree_writer writer;
  writer.add_file("resources/luna_game/checkpoint_textures", 1);
  writer.add_file("resources/luna_game/menu/menu_screen.png",1 );
  writer.add_file("resources/luna_game/menu/vovoid_logo_clouds.png",1 );
  writer.add_file("resources/luna_game/menu/music.raw",1 );
  writer.add_file("resources/luna_game/menu/vovoid_logo.png",1 );
  writer.add_file("resources/luna_game/menu/vovoid_logo_luna.png",1 );
  writer.add_file("resources/luna_game/menu/selection.raw",1 );
  writer.add_file("resources/luna_game/menu/start_game.raw",1 );
  writer.add_file("resources/luna_game/menu/back.raw",1 );
  writer.add_file("resources/luna_game/menu/text.png",1 );

  vsx_ma_vector<unsigned char> result_binary = vsx_filesystem_tree_serialize_binary::serialize(writer);

  FILE* fp = fopen("test_file_tree.bin", "w");
  fwrite(result_binary.get_pointer(), 1, result_binary.get_sizeof(), fp);
  fclose(fp);

  vsx::file_mmap* mm = vsx::filesystem_mmap::create("test_file_tree.bin");

  vsx_filesystem_tree_reader reader;
  reader.initialize(mm->data);

  vsx_nw_vector< vsx_string<> > filenames;
  vsx_nw_vector< uint32_t > payloads;
  reader.get_filename_payload_list(filenames, payloads);
  foreach (filenames, i)
    vsx_printf(L"level2: filename from tree: %hs    with paypload: %ld\n", filenames[i].c_str(), payloads[i]);

}

void test_level()
{
  vsx_printf(L"**** TESTING LEVEL\n");
  vsx_filesystem_tree_writer writer;
  writer.add_file("resources/luna_game/checkpoint_textures", 1);
  writer.add_file("resources/luna_game/checkpoint_textures/blinken.png", 1);
  writer.add_file("resources/luna_game/checkpoint_textures/diff.png", 1);
  writer.add_file("resources/luna_game/checkpoint_textures/diff_black.png", 1);
  writer.add_file("resources/luna_game/checkpoint_textures/norm.png", 1);
  writer.add_file("resources/luna_game/checkpoint_textures/norm_flat.png", 1);
  writer.add_file("resources/luna_game/global_textures", 1);
  writer.add_file("resources/luna_game/global_textures/basic_pipes_diff.png", 1);
  writer.add_file("resources/luna_game/global_textures/basic_pipes_diff.psd", 1);
  writer.add_file("resources/luna_game/global_textures/basic_pipes_norm.png", 1);
  writer.add_file("resources/luna_game/global_textures/basic_pipes_norm.psd", 1);
  writer.add_file("resources/luna_game/global_textures/basic_pipes_reflect.png", 1);
  writer.add_file("resources/luna_game/global_textures/metal_repeat_01.psd", 1);
  writer.add_file("resources/luna_game/global_textures/metal_repeat_01_diff.png", 1);
  writer.add_file("resources/luna_game/global_textures/metal_repeat_01_norm.png", 1);
  writer.add_file("resources/luna_game/global_textures/metal_repeat_01_reflect.png", 1);
  writer.add_file("resources/luna_game/global_textures/metal_repeat_01_reflect.psd", 1);
  writer.add_file("resources/luna_game/global_textures/metal_repeat_01_spec.png", 1);
  writer.add_file("resources/luna_game/level_actor_features", 1);
  writer.add_file("resources/luna_game/level_audio_samples", 1);
  writer.add_file("resources/luna_game/level_audio_samples/checkpoint_activate.raw", 1);
  writer.add_file("resources/luna_game/level_audio_samples/checkpoint_not_enough_stars.raw", 1);
  writer.add_file("resources/luna_game/level_audio_samples/death_teleportation.raw", 1);
  writer.add_file("resources/luna_game/level_audio_samples/machine_hum_1.raw", 1);
  writer.add_file("resources/luna_game/level_audio_samples/necklace_discharge.raw", 1);
  writer.add_file("resources/luna_game/level_audio_samples/shattering_stones.raw", 1);
  writer.add_file("resources/luna_game/level_audio_samples/spawn_point_activate.raw", 1);
  writer.add_file("resources/luna_game/level_audio_samples/stones_collide.raw", 1);
  writer.add_file("resources/luna_game/level_aux_textures", 1);
  writer.add_file("resources/luna_game/level_aux_textures/0.png", 1);
  writer.add_file("resources/luna_game/level_aux_textures/1.png", 1);
  writer.add_file("resources/luna_game/level_aux_textures/2.png", 1);
  writer.add_file("resources/luna_game/level_aux_textures/3.png", 1);
  writer.add_file("resources/luna_game/level_aux_textures/4.png", 1);
  writer.add_file("resources/luna_game/level_aux_textures/5_cube.png", 1);
  writer.add_file("resources/luna_game/level_aux_textures/5_cube.psd", 1);
  writer.add_file("resources/luna_game/level_bezier_floors", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_01/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_02/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_03/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_04/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_05/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_06/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_07/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_08/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_09/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_10/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_11/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/lightmap.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/mesh.robj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/background_rm_12/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/block_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/spec.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/spec.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/spec.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_04/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/spec.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/bounce_pad_05/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_blinken1", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_floor/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_blinken1", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_blinken1", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_blinken1", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_jump/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_ring/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_run/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_progression_skate/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_blinken1", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_blinken1", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/checkpoint_wall/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/0_diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/0_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/0_reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/decadent_background_piece_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/directional_arrow/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_01/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/doodad_04/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/girder_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/level_transition_tunnel/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/lightning", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/lightning/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/lightning/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/lightning/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/lightning/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/lightning/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/lightning/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/minimap_console/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_01/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_m_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_01/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xl_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_01/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_xxl_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/pipe_segment_z/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_field", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_field/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_field/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_field/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_field/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_field/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_field/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_field/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_blue/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/plasma_wheel_pink/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/0_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/1_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/1_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/spec.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_01/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/1_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/1_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/spec.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_02/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/0_blinken1.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/0_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/1_diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/1_shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/norm.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/spec.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/speed_boost_03/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01/reflect.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02/reflect.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03/reflect.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/tube_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_m_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03/reflect", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/walkway_xl_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/2_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/3_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/4_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/5_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/blinken1", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/diff.png", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/2_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/2_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/2_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/2_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/3_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/3_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/3_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/3_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/4_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/4_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/4_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/4_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/5_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/5_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/5_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere/5_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/1_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/2_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/2_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/3_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/3_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/4_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/4_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/5_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/5_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/6_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/6_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/diff", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/norm", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/spec", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/1_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/2_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/2_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/2_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/2_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/2_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/3_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/3_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/3_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/3_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/3_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/4_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/4_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/4_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/4_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/4_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/5_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/5_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/5_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/5_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/5_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/6_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/6_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/6_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/6_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box/6_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/0_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/1_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/2_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/3_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/4_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/5_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/6_mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/mesh.obj", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/mesh_config", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/shader", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.faces.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_background", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_background/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_background/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_background/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_background/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken1", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken1/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken1/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken1/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken1/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken_script", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken_script/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken_script/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken_script/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_blinken_script/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_lightmap", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_lightmap/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_lightmap/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_lightmap/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_lightmap/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap_lightmap", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap_lightmap/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap_lightmap/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap_lightmap/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_refmap_lightmap/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_energy_flow", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_energy_flow/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_energy_flow/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_energy_flow/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_energy_flow/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/lightning", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/lightning/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/lightning/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/lightning/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/lightning/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/plasma_field", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/plasma_field/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/plasma_field/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/plasma_field/fragment_orig", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/plasma_field/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/plasma_field/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/speed_boost", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/speed_boost/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/speed_boost/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/speed_boost/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/speed_boost/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal_window", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal_window/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal_window/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal_window/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/crystal_window/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_alpha", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_alpha/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_alpha/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_alpha/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/diff_norm_alpha/vertex", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_clean", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_clean/floats", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_clean/fragment", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_clean/textures", 1);
  writer.add_file("resources/luna_game/level_bezier_shaders/emit_clean/vertex", 1);
  writer.add_file("resources/luna_game/level_music", 1);
  writer.add_file("resources/luna_game/level_sequence_pool", 1);
  writer.add_file("resources/luna_game/level_sequences", 1);
  writer.add_file("resources/luna_game/level_sequences/tween_sin_wave", 1);
  writer.add_file("resources/luna_game/overlay", 1);
  writer.add_file("resources/luna_game/overlay/hint.png", 1);
  writer.add_file("resources/luna_game/overlay/minimap_background.png", 1);
  writer.add_file("resources/luna_game/level_audio", 1);
  writer.add_file("resources/luna_game/level_script", 1);
  writer.add_file("resources/luna_game/level_lighting", 1);
  writer.add_file("resources/luna_game/level_language", 1);
  writer.add_file("resources/luna_game/destructible_sphere", 1);
  writer.add_file("resources/luna_game/destructible_sphere/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere/2_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere/3_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere/4_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere/5_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere/blinken1", 1);
  writer.add_file("resources/luna_game/destructible_sphere/diff.png", 1);
  writer.add_file("resources/luna_game/destructible_sphere/mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere/mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere/norm", 1);
  writer.add_file("resources/luna_game/destructible_sphere/shader", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/0_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/1_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/2_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/2_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/3_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/3_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/4_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/4_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/5_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/5_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/6_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/6_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/diff", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/norm", 1073741824);
  writer.add_file("resources/luna_game/destructible_sphere_box/shader", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box/spec", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/0_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/0_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/1_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/1_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/2_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/2_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/3_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/3_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/4_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/4_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/5_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/5_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/6_mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/6_mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/mesh.obj", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/mesh_config", 1);
  writer.add_file("resources/luna_game/destructible_sphere_box_glass/shader", 1);
  writer.add_file("resources/luna_game/level", 1);
  writer.add_file("resources/luna_game/level_mesh_pool", 1);
  writer.add_file("resources/luna_game/level_shader_pool", 1);
  writer.add_file("resources/luna_game/level_stars", 1);

  vsx_perf perf;
  vsx_perf perf_cpu;
  perf.cache_misses_start();
  perf_cpu.cpu_instructions_start();

//  vsx_string<> result = vsx_filesystem_tree_serialize_string::serialize(writer);
//  vsx_printf(L"%s\n", result.c_str());

  vsx_ma_vector<unsigned char> result_binary = vsx_filesystem_tree_serialize_binary::serialize(writer);

  FILE* fp = fopen("test_file_tree.bin", "w");
  fwrite(result_binary.get_pointer(), 1, result_binary.get_sizeof(), fp);
  fclose(fp);

  vsx::file_mmap* mm = vsx::filesystem_mmap::create("test_file_tree.bin");


  vsx_filesystem_tree_reader reader;
  reader.initialize(mm->data);

  long long cache_misses;
  long long cpu_cycles;




  perf.cache_misses_begin();
  perf_cpu.cpu_instructions_begin();

  uint32_t reader_result = reader.get_payload_by_filename( "level_bezier_shaders/lightning/fragment" );
  cpu_cycles = perf_cpu.cpu_instructions_end();
  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);
  vsx_printf(L"cpu cycles: %lld\n", cpu_cycles);


  perf.cache_misses_begin();
    perf_cpu.cpu_instructions_begin();
      reader_result = reader.get_payload_by_filename( "resources/luna_game/destructible_sphere_box/norm" );
    cpu_cycles = perf_cpu.cpu_instructions_end();
  cache_misses = perf.cache_misses_end();

  test_assert( reader_result == 1073741824 );

  vsx_printf(L"cache misses: %lld\n", cache_misses);
  vsx_printf(L"cpu cycles: %lld\n", cpu_cycles);


  perf.cache_misses_begin();
    perf_cpu.cpu_instructions_begin();
      reader_result = reader.get_payload_by_filename( "level_audio" );
    cpu_cycles = perf_cpu.cpu_instructions_end();
  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);
  vsx_printf(L"cpu cycles: %lld\n", cpu_cycles);



  //vsx_nw_vector< vsx_string<> > filenames;
  //vsx_nw_vector< uint32_t > payloads;
  //reader.get_filename_payload_list(filenames, payloads);
  //foreach (filenames, i)
  //  vsx_printf(L"level_1 filename from tree: %hs    with paypload: %ld\n", filenames[i].c_str(), payloads[i]);




  perf.cache_misses_begin();
    perf_cpu.cpu_instructions_begin();
      reader_result = reader.get_payload_by_filename( "level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertex_tex_coords.cache" );
    cpu_cycles = perf_cpu.cpu_instructions_end();
  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);
  vsx_printf(L"cpu cycles: %lld\n", cpu_cycles);




  perf.cache_misses_stop();
  perf_cpu.cpu_instructions_stop();

  vsx::filesystem_mmap::destroy(mm);

  unlink("test_file_tree.bin");
}






void test_level_2()
{
  vsx_printf(L"**** TESTING LEVEL\n");
  vsx_filesystem_tree_writer writer;

  writer.add_file("resources/crystalline_expanse/checkpoint_textures/blinken.png", 1);
  writer.add_file("resources/crystalline_expanse/checkpoint_textures/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/checkpoint_textures/diff_black.png", 1);
  writer.add_file("resources/crystalline_expanse/checkpoint_textures/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/checkpoint_textures/norm_flat.png", 1);
  writer.add_file("resources/crystalline_expanse/global_textures/metallic_repeat/metallic_repeat_COLOR.png", 1);
  writer.add_file("resources/crystalline_expanse/global_textures/metallic_repeat/metallic_repeat_NRM.png", 1);
  writer.add_file("resources/crystalline_expanse/global_textures/metallic_repeat/metallic_repeat_SPEC.png", 1);
  writer.add_file("resources/crystalline_expanse/global_textures/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/global_textures/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/global_textures/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_audio_samples/checkpoint_activate.raw", 1);
  writer.add_file("resources/crystalline_expanse/level_audio_samples/checkpoint_not_enough_stars.raw", 1);
  writer.add_file("resources/crystalline_expanse/level_audio_samples/death_teleportation.raw", 1);
  writer.add_file("resources/crystalline_expanse/level_audio_samples/machine_hum_1.raw", 1);
  writer.add_file("resources/crystalline_expanse/level_audio_samples/necklace_discharge.raw", 1);
  writer.add_file("resources/crystalline_expanse/level_audio_samples/shattering_stones.raw", 1);
  writer.add_file("resources/crystalline_expanse/level_audio_samples/spawn_point_activate.raw", 1);
  writer.add_file("resources/crystalline_expanse/level_audio_samples/stones_collide.raw", 1);
  writer.add_file("resources/crystalline_expanse/level_aux_textures/0.png", 1);
  writer.add_file("resources/crystalline_expanse/level_aux_textures/1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_aux_textures/2.png", 1);
  writer.add_file("resources/crystalline_expanse/level_aux_textures/3.png", 1);
  writer.add_file("resources/crystalline_expanse/level_aux_textures/4.png", 1);
  writer.add_file("resources/crystalline_expanse/level_aux_textures/5_cube.png", 1);
  writer.add_file("resources/crystalline_expanse/level_aux_textures/6.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/1_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/1_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/1_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/1_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/0_spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/2_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/2_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/2_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/2_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/2_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/2_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/2_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/2_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_02/1_norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/1_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/1_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/1_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/1_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_03/0_norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_04/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/lightmap.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/mesh.robj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/mesh.robj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/mesh.robj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/mesh.robj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/mesh.robj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/background_rm_05/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_02/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_03/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_04/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/bounce_pad_05/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/0_blinken1", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_floor/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_blinken1", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_left/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_blinken1", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_plasma_right/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/0_blinken1", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_power_arch/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_power/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_flying_time/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_jump/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_ring/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_ring/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_ring/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_ring/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_ring/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_ring/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_ring/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_ring/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_run/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_progression_skate/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber/0_blinken1", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_spawn_chamber_doors/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/0_blinken1", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/checkpoint_wall/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_03/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_04/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_04/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_04/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_05/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_05/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_05/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_05/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_05/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_05/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_05/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_06/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_06/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_06/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_06/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_06/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_06/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_06/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_07/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_07/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_07/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_07/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_07/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_07/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_07/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_08/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_08/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_08/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_08/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_08/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_08/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/cliff_plane_08/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_01/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_01/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_02/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/crystal_02/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/2_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/2_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/2_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/2_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/3_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/3_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/3_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/3_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/4_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/4_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/4_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/4_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/5_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/5_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/5_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/5_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/blinken1", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/norm", 1073741824);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/6_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/6_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/6_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/1_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/6_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/6_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/1_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/2_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/6_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/2_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/2_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/2_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/2_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/2_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/3_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/3_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/3_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/3_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/3_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/3_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/4_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/4_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/4_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/4_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/4_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/4_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/5_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/5_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/5_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/5_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/5_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/5_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/6_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/1_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/1_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/6_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/2_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/2_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/3_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/4_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/4_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/5_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/5_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/destructible_sphere_box_glass/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/glass_tube_01/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/glass_tube_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/glass_tube_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/glass_tube_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/glass_tube_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/glass_tube_01/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/level_transition_tunnel/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/level_transition_tunnel/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/level_transition_tunnel/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/level_transition_tunnel/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/level_transition_tunnel/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/level_transition_tunnel/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/level_transition_tunnel/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/level_transition_tunnel/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/light_post_01/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/lightning/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/lightning/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/lightning/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/lightning/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/lightning/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/lightning/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/lightning/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/lightning/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/0_mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/0_mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/mesh.obj.vertex_colors.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/mesh_config", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/reflect", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/minimap_console/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_03/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_04/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_04/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_04/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_05/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_05/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_05/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_05/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_05/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_05/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_05/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_06/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_06/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_06/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_06/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_06/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_06/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_06/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_07/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_07/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_07/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_07/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_07/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_07/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_07/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_08/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_08/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_08/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_08/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_08/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_08/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/pebble_08/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/0_shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_01/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_02/blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_02/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_02/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_03/blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_03/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_03/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_04/blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_04/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_04/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_field/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_field/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_field/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_field/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_field/shader", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/plasma_field/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_03/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_04/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_04/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_04/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_05/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_05/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_05/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_05/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_05/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_05/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_05/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_03/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_floor_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pillar_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pit/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pit/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pit/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pit/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pit/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pit/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_pit/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_roof/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_roof/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_roof/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_roof/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_roof/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_roof/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_background_roof/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_ground_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_ground_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_ground_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_ground_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_ground_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_ground_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_ground_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_03/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_04/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_04/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_scenery_04/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_03/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_04/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_04/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_04/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_05/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_05/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_05/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_05/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_05/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_05/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_sheet_05/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_03/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_04/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_04/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_04/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_05/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_05/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_05/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_05/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_05/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_05/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_05/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_06/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_06/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_06/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_06/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_06/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_06/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_06/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_07/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_07/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_07/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_07/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_07/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_07/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_07/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_08/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_08/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_08/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_08/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_08/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_08/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_08/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_09/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_09/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_09/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_09/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_09/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_09/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_09/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_10/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_10/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_10/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_10/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_10/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_10/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_10/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_11/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_11/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_11/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_11/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_11/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_11/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_11/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_12/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_12/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_12/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_12/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_12/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_12/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_12/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_13/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_13/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_13/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_13/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_13/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_13/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/rock_walkway_13/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_01/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_02/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/0_blinken1.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/0_diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/0_mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/0_mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/0_mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/0_mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/diff.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/norm.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/speed_boost_03/spec.png", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_01/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_01/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_01/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_01/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_01/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_01/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_01/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_02/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_02/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_02/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_02/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_02/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_02/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_02/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_03/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_03/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_03/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_03/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_03/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_03/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_03/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_04/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_04/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_04/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_04/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_04/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_04/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_04/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_05/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_05/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_05/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_05/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_05/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_05/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_05/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_06/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_06/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_06/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_06/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_06/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_06/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_06/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_07/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_07/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_07/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_07/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_07/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_07/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_07/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_08/mesh.obj.faces.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_08/mesh.obj.vertex_normals.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_08/mesh.obj.vertex_tex_coords.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_08/mesh.obj.vertices.cache", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_08/spec", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_08/norm", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_floors/stone_08/diff", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal_background/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal_background/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal_background/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal_background/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal_window/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal_window/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal_window/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/crystal_window/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm/vec4s", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_alpha/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_alpha/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_alpha/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_alpha/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_broken/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_broken/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_broken/textures", 1024);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_broken/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_glow/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_glow/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_glow/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_glow/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_orig/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_orig/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_orig/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_orig/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_blinken1/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_blinken1/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_blinken1/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_blinken1/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_blinken_script/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_blinken_script/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_blinken_script/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_blinken_script/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_refmap/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_refmap/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_refmap/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_refmap/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_spec/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_spec/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_spec/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_spec/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_spec_lightmap/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_spec_lightmap/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_spec_lightmap/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/diff_norm_spec_lightmap/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit_clean/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit_clean/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit_clean/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit_clean/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit_energy_flow/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit_energy_flow/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit_energy_flow/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/emit_energy_flow/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/lightning/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/lightning/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/lightning/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/lightning/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/plasma_field/floats", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/plasma_field/fragment", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/plasma_field/fragment_orig", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/plasma_field/textures", 1);
  writer.add_file("resources/crystalline_expanse/level_bezier_shaders/plasma_field/vertex", 1);
  writer.add_file("resources/crystalline_expanse/level_sequences/test_up_up", 1);
  writer.add_file("resources/crystalline_expanse/level_sequences/tween_sawtooth", 1);
  writer.add_file("resources/crystalline_expanse/level_sequences/tween_sin_wave", 1);
  writer.add_file("resources/crystalline_expanse/level_sequences/tween_sin_wave_pushed", 1);
  writer.add_file("resources/crystalline_expanse/overlay/hint.png", 1);
  writer.add_file("resources/crystalline_expanse/overlay/minimap_background.dds", 1);
  writer.add_file("resources/crystalline_expanse/overlay/minimap_background.png", 1);
  writer.add_file("resources/crystalline_expanse/level", 1);
  writer.add_file("resources/crystalline_expanse/level_actor_features", 1);
  writer.add_file("resources/crystalline_expanse/level_audio", 1);
  writer.add_file("resources/crystalline_expanse/level_lighting", 1);
  writer.add_file("resources/crystalline_expanse/level_music", 1);
  writer.add_file("resources/crystalline_expanse/level_stars", 1);
  writer.add_file("resources/crystalline_expanse/level_language", 1);
  writer.add_file("resources/crystalline_expanse/level_script", 1);
  writer.add_file("resources/crystalline_expanse/level_shader_pool", 1);
  writer.add_file("resources/crystalline_expanse/level_mesh_pool", 1);
  writer.add_file("resources/crystalline_expanse/level_sequence_pool", 1);

  vsx_perf perf;
  vsx_perf perf_cpu;
  perf.cache_misses_start();
  perf_cpu.cpu_instructions_start();

//  vsx_string<> result = vsx_filesystem_tree_serialize_string::serialize(writer);
//  vsx_printf(L"%s\n", result.c_str());

  vsx_ma_vector<unsigned char> result_binary = vsx_filesystem_tree_serialize_binary::serialize(writer);

  FILE* fp = fopen("test_file_tree.bin", "w");
  fwrite(result_binary.get_pointer(), 1, result_binary.get_sizeof(), fp);
  fclose(fp);

  vsx::file_mmap* mm = vsx::filesystem_mmap::create("test_file_tree.bin");


  vsx_filesystem_tree_reader reader;
  reader.initialize(mm->data);

  long long cache_misses;
  long long cpu_cycles;




  perf.cache_misses_begin();
  perf_cpu.cpu_instructions_begin();

  uint32_t reader_result = reader.get_payload_by_filename( "resources/crystalline_expanse/level_bezier_shaders/diff_norm_background_broken/textures" );
  cpu_cycles = perf_cpu.cpu_instructions_end();
  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);
  vsx_printf(L"cpu cycles: %lld\n", cpu_cycles);


  perf.cache_misses_begin();
    perf_cpu.cpu_instructions_begin();
      reader_result = reader.get_payload_by_filename( "resources/crystalline_expanse/level_bezier_floors/destructible_sphere/norm" );
    cpu_cycles = perf_cpu.cpu_instructions_end();
  cache_misses = perf.cache_misses_end();

  test_assert( reader_result == 1073741824 );

  vsx_printf(L"cache misses: %lld\n", cache_misses);
  vsx_printf(L"cpu cycles: %lld\n", cpu_cycles);


  perf.cache_misses_begin();
    perf_cpu.cpu_instructions_begin();
      reader_result = reader.get_payload_by_filename( "level_audio" );
    cpu_cycles = perf_cpu.cpu_instructions_end();
  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);
  vsx_printf(L"cpu cycles: %lld\n", cpu_cycles);



  vsx_nw_vector< vsx_string<> > filenames;
  vsx_nw_vector< uint32_t > payloads;
  reader.get_filename_payload_list(filenames, payloads);
  foreach (filenames, i)
    vsx_printf(L"level_2 filename from tree: %hs    with paypload: %ld\n", filenames[i].c_str(), payloads[i]);




  perf.cache_misses_begin();
    perf_cpu.cpu_instructions_begin();
      reader_result = reader.get_payload_by_filename( "level_bezier_floors/destructible_sphere_box_glass/3_mesh.obj.vertex_tex_coords.cache" );
    cpu_cycles = perf_cpu.cpu_instructions_end();
  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);
  vsx_printf(L"cpu cycles: %lld\n", cpu_cycles);




  perf.cache_misses_stop();
  perf_cpu.cpu_instructions_stop();

  vsx::filesystem_mmap::destroy(mm);

  unlink("test_file_tree.bin");
}

void basic_test()
{
  vsx_printf(L"**** TESTING BASIC USAGE\n");

  vsx_perf perf;

  vsx_filesystem_tree_writer writer;

  writer.add_file("home/jaw/test1.txt", 1);
  writer.add_file("home/jaw/abc.txt", 2);
  writer.add_file("abc/xyz.txt", 1073741824 );
  writer.add_file("abc/def.txt", 2147483648 );

  vsx_ma_vector<unsigned char> result_binary = vsx_filesystem_tree_serialize_binary::serialize(writer);

  vsx_filesystem_tree_reader reader;
  reader.initialize(result_binary.get_pointer());

  // non-existent file
  uint32_t t_reader_result = reader.get_payload_by_filename( "qqqq" );
  test_assert (t_reader_result == 0);


  long long cache_misses;

  perf.cache_misses_start();
  perf.cache_misses_begin();
  uint32_t reader_result = reader.get_payload_by_filename( "abc/def.txt" );
  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);

  test_assert( reader_result == 2147483648 );

  perf.cache_misses_begin();
  reader_result = reader.get_payload_by_filename( "abc/xyz.txt" );

  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);

  test_assert( reader_result == 1073741824 );

  perf.cache_misses_begin();

  reader_result = reader.get_payload_by_filename( "home/jaw/test1.txt" );
  cache_misses = perf.cache_misses_end();

  vsx_printf(L"cache misses: %lld\n", cache_misses);

  test_assert( reader_result == 1 );

}


int main(int argc, char *argv[])
{
  VSX_UNUSED(argc);
  VSX_UNUSED(argv);

  basic_test();
  test_level();
  test_level_2();
  test_level2();

  test_complete
  return 0;
}
