/**
* Project: VSXu Engine: Realtime modular visual programming engine.
*
* This file is part of Vovoid VSXu Engine.
*
* @author Jonatan Wallmander, Robert Wenzel, Vovoid Media Technologies AB Copyright (C) 2003-2013
* @see The GNU Lesser General Public License (LGPL)
*
* VSXu Engine is free software; you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
* or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU Lesser General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <map>
#include <vector>
#include <string/vsx_string.h>
#include <vsx_param.h>
#include <module/vsx_module.h>

#include "vsx_module_list_abs.h"
#include "vsx_module_list_factory.h"

#ifdef VSXU_STATIC
  #include "vsx_module_list_static.h"
#else
  #include "vsx_module_list.h"
#endif

vsx_module_list_abs* vsx_module_list_factory_create(void* extra_modules)
{
    vsx_module_list* module_list = new vsx_module_list();
    module_list->init(extra_modules);
    return (vsx_module_list_abs*)module_list;
}

void vsx_module_list_factory_destroy( vsx_module_list_abs* object )
{
  object->destroy();
  delete (vsx_module_list*)object;
}


