

















/*
 * CommandlineLanguages.h.m4 
 *
 * CommandlineLanguages.h is autogenerated from CommandlineLanguages.h.m4
 *
 * Copyright (C) 2006 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

















































#include "swt.h"
#include <ctype.h>





bool parseCommandlineArgumentLanguages(int &i, int argc, char** argv)
{
    if (strcmp(argv[i],"-english")==0) {
       swSetLang(SW_LANG_english);   

    } else if (strcmp(argv[i],"-portuguese")==0) {
        swSetLang(SW_LANG_portuguese);   

    } else if (strcmp(argv[i],"-german")==0) {
        swSetLang(SW_LANG_german);   

    } else if (strcmp(argv[i],"-italian")==0) {
        swSetLang(SW_LANG_italian);   

    } else if (strcmp(argv[i],"-french")==0) {
        swSetLang(SW_LANG_french);   

    } else
       return false;
    return true;    
}

void setLanguage(char *lang)
{
    if (lang && (strlen(lang) >=2)) {

        } else if ((toupper(lang[0])=="PT"[0]) && 
                   (toupper(lang[1])=="PT"[1])) {
           swSetLang(SW_LANG_PT);   

        } else if ((toupper(lang[0])=="DE"[0]) && 
                   (toupper(lang[1])=="DE"[1])) {
           swSetLang(SW_LANG_DE);   

        } else if ((toupper(lang[0])=="IT"[0]) && 
                   (toupper(lang[1])=="IT"[1])) {
           swSetLang(SW_LANG_IT);   

        } else if ((toupper(lang[0])=="FR"[0]) && 
                   (toupper(lang[1])=="FR"[1])) {
           swSetLang(SW_LANG_FR);   

    }     
}

void checkLanguageEnvironment(void)
{
    char *lang = getenv("LANG");
    if (lang && (strlen(lang) >=2)) {
        if ((toupper(lang[0])=='e') && (toupper(lang[1])=='n'))
            swSetLang(SW_LANG_english);
        setLanguage(lang);
    }     
}

