/*
 * CommandlineLanguages.h.m4 
 *
 * CommandlineLanguages.h is autogenerated from CommandlineLanguages.h.m4
 *
 * Copyright (C) 2006 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

include(`swt/include/resource.m4')
`#include "swt.h"'
`#include <ctype.h>'

define(`M4_ENV_ISO',`
        } else if ((toupper(lang[0])=="$1"[0]) && 
                   (toupper(lang[1])=="$1"[1])) {
           swSetLang(SW_LANG_$1);   
')

define(`M4_COMMANDLINE_OPTION',`
    } else if (strcmp(argv[i],"-$1")==0) {
        swSetLang(SW_LANG_$1);   
')

bool parseCommandlineArgumentLanguages(int &i, int argc, char** argv)
{
    if (strcmp(argv[i],"-english")==0) {
       swSetLang(SW_LANG_english);   
M4_FOR_IN(`M4_COMMANDLINE_OPTION',M4_LANGUAGES)
    } else
       return false;
    return true;    
}

void setLanguage(char *lang)
{
    if (lang && (strlen(lang) >=2)) {
M4_FOR_IN(`M4_ENV_ISO',M4_REVERSE(M4_LANGUAGES_ISO3166))
    }     
}

void checkLanguageEnvironment(void)
{
    char *lang = getenv("LANG");
    if (lang && (strlen(lang) >=2)) {
        if ((toupper(lang[0])=='e') && (toupper(lang[1])=='n'))
            swSetLang(SW_LANG_english);
        setLanguage(lang);
    }     
}

