

/*
 *  Author: Arvin Schnell
 */


#include <stdio.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/Scale.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/Frame.h>
#include <Xm/DrawingA.h>
#include <Xm/Protocols.h>

#include "Sample.h"
#include "help.h"
#include "utils.h"
#include "Analyser.h"
#include "Scope.h"
#include "main.h"
#include "control.h"


Widget control_w;
Widget card_w, disk_w;
Widget analyseron_w, alpha_w, decay_w, search_w;
Widget scopeon_w, zoom_w;

enum {
    QUIT, ANALYSERON, SCOPEON, SOUNDCARD, DISKFILE, DECAY, ALPHA,
    SEARCH, HELP, ZOOM
};


Widget scope_w;
Widget scope_drawing_w;
int scope_visibility;

Widget analyser_w;
Widget analyser_drawing_w[2];
int analyser_visibility;

XtWorkProcId workproc_id;

bool run_analyser = false;
bool run_scope = false;

Analyser analyser[2];

Scope scope;


bool
run ()
{
    return run_analyser || run_scope;
}


Boolean
workproc (XtPointer)
{
    if (sample.shot ()) {

	if (run_analyser) {

	    if (xanalyser.stereo) {

		analyser[0].shot (sample.buffer, Analyser::LEFT,
				  analyser_visibility);
		analyser[1].shot (sample.buffer, Analyser::RIGHT,
				  analyser_visibility);
		XFlush (XtDisplay (toplevel));

	    } else {

		analyser[0].shot (sample.buffer, Analyser::MONO,
				  analyser_visibility);
		XFlush (XtDisplay (toplevel));

	    }
	}

	if (run_scope) {

	    scope.shot (sample.buffer, scope_visibility);
	    XFlush (XtDisplay (toplevel));

	}

	return FALSE;

    } else {

	sample.close ();

	run_analyser = false;
	run_scope = false;

	set_sensitivity ();

	return TRUE;

    }
}


void
startstop ()
{
    if (run ()) {

	if (!sample.isopen ())
	    if (sample.open ()) {
		workproc_id = XtAppAddWorkProc (app_context, workproc, 0);
	    } else {
		run_analyser = false;
		run_scope = false;
	    }

    } else {

	if (sample.isopen ()) {
	    XtRemoveWorkProc (workproc_id);
	    sample.close ();
	    run_analyser = false;
	    run_scope = false;
	}

    }

    set_sensitivity ();
}


void
control_close ()
{
    if (sample.isopen ())
	sample.close ();

    XtDestroyApplicationContext (app_context);

    exit (EXIT_SUCCESS);
}


void
control_close (Widget, XtPointer, XtPointer)
{
    control_close ();
}


void
analyser_close (Widget, XtPointer, XtPointer)
{
    XtUnmanageChild (analyser_w);

    XmToggleButtonSetState (analyseron_w, False, False);

    run_analyser = false;

    startstop ();
}


void
scope_close (Widget, XtPointer, XtPointer)
{
    XtUnmanageChild (scope_w);

    XmToggleButtonSetState (scopeon_w, False, False);

    run_scope = false;

    startstop ();
}


void
set_sensitivity ()
{
    XtSetSensitive (card_w, run ()? False : True);
    XtSetSensitive (disk_w, run ()? False : True);

    XmToggleButtonSetState (card_w, sample.source == Sample::SOUNDCARD ?
			    True : False, False);
    XmToggleButtonSetState (disk_w, sample.source == Sample::DISKFILE ?
			    True : False, False);

    XmToggleButtonSetState (analyseron_w, run_analyser ? True : False, False);
    XmToggleButtonSetState (scopeon_w, run_scope ? True : False, False);
}


void
control_set_default ()
{
    double alpha = xanalyser.alpha;
    myXmScaleSetValue (alpha_w, alpha);
    analyser[0].set_alpha (alpha);
    analyser[1].set_alpha (alpha);

    double decay = xanalyser.decay;
    myXmScaleSetValue (decay_w, decay);
    analyser[0].set_decay (decay);
    analyser[1].set_decay (decay);

    double zoom = xanalyser.zoom;
    myXmScaleSetValue (zoom_w, xanalyser.zoom);
    scope.set_zoom (zoom);
}


void
control_callback (Widget widget, XtPointer client_data, XtPointer)
{
    switch ((long int) client_data) {

	case SOUNDCARD: {
	    sample.source = Sample::SOUNDCARD;
	} break;

	case DISKFILE: {
	    sample.source = Sample::DISKFILE;
	} break;

	case DECAY: {
	    double decay = myXmScaleGetValue (widget);
	    analyser[0].set_decay (decay);
	    analyser[1].set_decay (decay);
	} break;

	case ALPHA: {
	    double alpha = myXmScaleGetValue (widget);
	    analyser[0].set_alpha (alpha);
	    analyser[1].set_alpha (alpha);
	} break;

	case SEARCH: {
	    int search = XmToggleButtonGetState (widget);
	    analyser[0].set_search (search);
	    analyser[1].set_search (search);
	} break;

	case ZOOM: {
	    double zoom = myXmScaleGetValue (widget);
	    scope.set_zoom (zoom);
	} break;

	case ANALYSERON: {
	    run_analyser = XmToggleButtonGetState (widget);
	    if (run_analyser)
		analyser_manage ();
	    startstop ();
	} break;

	case SCOPEON: {
	    run_scope = XmToggleButtonGetState (widget);
	    if (run_scope)
		scope_manage ();
	    startstop ();
	} break;

	case HELP: {
	    help_manage ();
	} break;

	case QUIT: {
	    control_close ();
	} break;

    }
}


void
control_create ()
{
    Arg args[10];
    int n;

    // control

    n = 0;
    control_w = XmCreateForm (toplevel, "Control", args, n);
    XtManageChild (control_w);

    // frame1 - Source

    Widget frame1_w, form1_w, label11_w, box1_w;

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    frame1_w = XmCreateFrame (control_w, "Frame1", args, n);
    XtManageChild (frame1_w);

    // form1

    n = 0;
    form1_w = XmCreateForm (frame1_w, "Form1", args, n);
    XtManageChild (form1_w);

    // label: source

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    label11_w = XmCreateLabel (form1_w, "Source", args, n);
    XtManageChild (label11_w);

    // radiobox1

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, label11_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    box1_w = XmCreateRadioBox (form1_w, "RadioBox1", args, n);
    XtManageChild (box1_w);

    // radio button: card

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    card_w = XmCreateToggleButton (box1_w, "Soundcard", args, n);
    XtManageChild (card_w);
    XtAddCallback (card_w, XmNvalueChangedCallback,
		   control_callback, (XtPointer) SOUNDCARD);

    // radio button: disk

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, card_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    disk_w = XmCreateToggleButton (box1_w, "Diskfile", args, n);
    XtManageChild (disk_w);
    XtAddCallback (disk_w, XmNvalueChangedCallback,
		   control_callback, (XtPointer) DISKFILE);

    // frame2 - Analyser

    Widget frame2_w, form2_w, label21_w;

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNleftWidget, frame1_w); n++;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    frame2_w = XmCreateFrame (control_w, "Frame2", args, n);
    XtManageChild (frame2_w);

    // form2

    n = 0;
    form2_w = XmCreateForm (frame2_w, "Form2", args, n);
    XtManageChild (form2_w);

    // label

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    label21_w = XmCreateLabel (form2_w, "Freq. Analyser", args, n);
    XtManageChild (label21_w);

    // toggle: run

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, label21_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    analyseron_w = XmCreateToggleButton (form2_w, "Run", args, n);
    XtManageChild (analyseron_w);
    XtAddCallback (analyseron_w, XmNvalueChangedCallback,
		   control_callback, (XtPointer) ANALYSERON);

    // scale: alpha

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, analyseron_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    alpha_w = XmCreateScale (form2_w, "Alpha", args, n);
    XtManageChild (alpha_w);
    XtAddCallback (alpha_w, XmNdragCallback, control_callback, (XtPointer) ALPHA);
    XtAddCallback (alpha_w, XmNvalueChangedCallback,
		   control_callback, (XtPointer) ALPHA);

    // scale: decay

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, alpha_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    decay_w = XmCreateScale (form2_w, "Decay", args, n);
    XtManageChild (decay_w);
    XtAddCallback (decay_w, XmNdragCallback, control_callback, (XtPointer) DECAY);
    XtAddCallback (decay_w, XmNvalueChangedCallback,
		   control_callback, (XtPointer) DECAY);

    // toggle: search

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, decay_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    search_w = XmCreateToggleButton (form2_w, "Peak Search", args, n);
    XtManageChild (search_w);
    XtAddCallback (search_w, XmNvalueChangedCallback,
		   control_callback, (XtPointer) SEARCH);

    // frame3 - Scope

    Widget frame3_w, form3_w, label31_w;

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNleftWidget, frame2_w); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    frame3_w = XmCreateFrame (control_w, "Frame3", args, n);
    XtManageChild (frame3_w);

    // form3

    n = 0;
    form3_w = XmCreateForm (frame3_w, "Form3", args, n);
    XtManageChild (form3_w);

    // label: Scope

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    label31_w = XmCreateLabel (form3_w, "XY Scope", args, n);
    XtManageChild (label31_w);

    // toggle: run

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, label31_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    scopeon_w = XmCreateToggleButton (form3_w, "Run", args, n);
    XtManageChild (scopeon_w);
    XtAddCallback (scopeon_w, XmNvalueChangedCallback,
		   control_callback, (XtPointer) SCOPEON);

    // scale: zoom

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, scopeon_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    zoom_w = XmCreateScale (form3_w, "Zoom", args, n);
    XtManageChild (zoom_w);
    XtAddCallback (zoom_w, XmNdragCallback, control_callback, (XtPointer) ZOOM);
    XtAddCallback (zoom_w, XmNvalueChangedCallback,
		   control_callback, (XtPointer) ZOOM);

    // frame5 - Help

    Widget frame5_w, form5_w, label51_w, help_w;

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, frame1_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNrightWidget, frame2_w); n++;
    frame5_w = XmCreateFrame (control_w, "Frame5", args, n);
    XtManageChild (frame5_w);

    // form5

    n = 0;
    form5_w = XmCreateForm (frame5_w, "Form5", args, n);
    XtManageChild (form5_w);

    // label: help

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    label51_w = XmCreateLabel (form5_w, "Help", args, n);
    XtManageChild (label51_w);

    // button: help

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, label51_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    help_w = XmCreatePushButton (form5_w, "Help", args, n);
    XtManageChild (help_w);
    XtAddCallback (help_w, XmNactivateCallback, control_callback, (XtPointer) HELP);

    // frame6 - Quit

    Widget frame6_w, form6_w, quit_w;

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, frame5_w); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNrightWidget, frame2_w); n++;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    frame6_w = XmCreateFrame (control_w, "Frame6", args, n);
    XtManageChild (frame6_w);

    // form6

    n = 0;
    form6_w = XmCreateForm (frame6_w, "Form6", args, n);
    XtManageChild (form6_w);

    // button: quit

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    quit_w = XmCreatePushButton (form6_w, "Quit", args, n);
    XtManageChild (quit_w);
    XtAddCallback (quit_w, XmNactivateCallback, control_callback,
		   (XtPointer) QUIT);
}


void
analyser_callback (Widget, XtPointer client_data, XtPointer call_data)
{
    XmDrawingAreaCallbackStruct* c = (XmDrawingAreaCallbackStruct*) call_data;

    switch (c->reason) {

	case XmCR_EXPOSE: {

	    int n = (long int) client_data;

	    if (!analyser[n].isrealized ())
		analyser[n].realize (XtDisplay (analyser_drawing_w[n]),
				     XtWindow (analyser_drawing_w[n]));

	    XExposeEvent* e = (XExposeEvent*) c->event;
	    XRectangle rect = { e->x, e->y, e->width, e->height };
	    analyser[n].draw (rect);

	} break;

	case XmCR_RESIZE: {

	    int n = (long int) client_data;
	    analyser[n].resize (1);

	} break;

	case XmCR_INPUT: {

	    switch (c->event->type) {

		case ButtonPress:
		case MotionNotify: {
		    XButtonPressedEvent* e = (XButtonPressedEvent*) c->event;
		    XPoint point = { e->x, e->y };

		    analyser[0].set_marker (point.x);
		    analyser[1].set_marker (point.x);

		} break;

	    }

	} break;

    }
}


void
analyser_notify (Widget, XtPointer, XEvent* event, Boolean*)
{
    switch (event->type) {

	case UnmapNotify:
	    analyser_visibility = 0;
	    break;

	case VisibilityNotify:
	    analyser_visibility = ((XVisibilityEvent*) (event))->state
		!= VisibilityFullyObscured;
	    break;

    }
}


void
analyser_create ()
{
    Arg args[10];
    int n;

    // form

    n = 0;
    XtSetArg (args[n], XtNiconPixmap, a_iconpixmap); n++;
    XtSetArg (args[n], XtNiconMask, a_iconmask); n++;
    analyser_w = XmCreateFormDialog (toplevel, "Analyser", args, n);
    XmAddWMProtocolCallback (XtParent (analyser_w), wm_delete_window,
			     analyser_close, 0);
    XtAddEventHandler (XtParent (analyser_w), StructureNotifyMask, False,
		       analyser_notify, 0);
    XtAddEventHandler (XtParent (analyser_w), VisibilityChangeMask, False,
		       analyser_notify, 0);

    // drawingarea 0

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    if (xanalyser.stereo) {
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_POSITION); n++;
    } else {
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    }
    XtSetArg (args[n], XmNbottomPosition, 50); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNwidth, sample.length / 2 + 1); n++; // FIXME
    analyser_drawing_w[0] = XmCreateDrawingArea (analyser_w, "Display0", args, n);
    XtManageChild (analyser_drawing_w[0]);
    XtAddCallback (analyser_drawing_w[0], XmNexposeCallback, analyser_callback,
		   (XtPointer) 0);
    XtAddCallback (analyser_drawing_w[0], XmNresizeCallback, analyser_callback,
		   (XtPointer) 0);
    XtAddCallback (analyser_drawing_w[0], XmNinputCallback, analyser_callback,
		   (XtPointer) 0);

    // drawingarea 1

    if (xanalyser.stereo) {
	n = 0;
	XtSetArg (args[n], XmNtopAttachment, XmATTACH_POSITION); n++;
	XtSetArg (args[n], XmNtopPosition, 50); n++;
	XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg (args[n], XmNwidth, sample.length / 2 + 1); n++; // FIXME
	analyser_drawing_w[1] = XmCreateDrawingArea (analyser_w, "Display1", args, n);
	XtManageChild (analyser_drawing_w[1]);
	XtAddCallback (analyser_drawing_w[1], XmNexposeCallback, analyser_callback,
		       (XtPointer) 1);
	XtAddCallback (analyser_drawing_w[1], XmNresizeCallback, analyser_callback,
		       (XtPointer) 1);
	XtAddCallback (analyser_drawing_w[1], XmNinputCallback, analyser_callback,
		       (XtPointer) 1);
    }
}


void
analyser_manage ()
{
    if (!analyser_w)
	analyser_create ();

    if (!XtIsManaged (analyser_w))
	XtManageChild (analyser_w);
#if 1
    else
	XMapRaised (XtDisplay (analyser_w), XtWindow (XtParent (analyser_w)));
#endif
}


void
scope_callback (Widget, XtPointer, XtPointer call_data)
{
    XmDrawingAreaCallbackStruct* c = (XmDrawingAreaCallbackStruct*) call_data;

    switch (c->reason) {

	case XmCR_EXPOSE: {

	    if (!scope.isrealized ())
		scope.realize (XtDisplay (scope_drawing_w), XtWindow (scope_drawing_w));

	    XExposeEvent* e = (XExposeEvent*) c->event;
	    XRectangle rect = { e->x, e->y, e->width, e->height };
	    scope.draw (rect);

	} break;

	case XmCR_RESIZE: {

	    scope.resize (1);

	} break;

    }
}


void
scope_notify (Widget, XtPointer, XEvent* event, Boolean*)
{
    switch (event->type) {

	case UnmapNotify:
	    scope_visibility = 0;
	    break;

	case VisibilityNotify:
	    scope_visibility =
		((XVisibilityEvent*) (event))->state != VisibilityFullyObscured;
	    break;

    }
}


void
scope_create ()
{
    Arg args[10];
    int n;

    // form

    n = 0;
    XtSetArg (args[n], XtNiconPixmap, s_iconpixmap); n++;
    XtSetArg (args[n], XtNiconMask, s_iconmask); n++;
    scope_w = XmCreateFormDialog (toplevel, "Scope", args, n);
    XmAddWMProtocolCallback (XtParent (scope_w), wm_delete_window,
			     scope_close, 0);
    XtAddEventHandler (XtParent (scope_w), StructureNotifyMask, False,
		       scope_notify, 0);
    XtAddEventHandler (XtParent (scope_w), VisibilityChangeMask, False,
		       scope_notify, 0);

    // drawingarea

    n = 0;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    scope_drawing_w = XmCreateDrawingArea (scope_w, "Drawing", args, n);
    XtManageChild (scope_drawing_w);
    XtAddCallback (scope_drawing_w, XmNexposeCallback, scope_callback, 0);
    XtAddCallback (scope_drawing_w, XmNresizeCallback, scope_callback, 0);
}


void
scope_manage ()
{
    if (!scope_w)
	scope_create ();

    if (!XtIsManaged (scope_w))
	XtManageChild (scope_w);
#if 1
    else
	XMapRaised (XtDisplay (scope_w), XtWindow (XtParent (scope_w)));
#endif
}
