

/*
 *  Author: Arvin Schnell
 */


#include <stdio.h>
#include <ctype.h>
#include <math.h>

#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/Scale.h>


void
myXGetDrawableSize (Display* display, Drawable drawable,
		    unsigned int* width, unsigned int* height)
{
    Window root;
    int x, y;
    unsigned int border, depth;

    XGetGeometry (display, drawable, &root, &x, &y, width, height,
		  &border, &depth);
}


double
myXmScaleGetValue (Widget widget)
{
    int value;
    short int point;
    Arg args[] = {
	{ XmNvalue, (XtArgVal) & value },
	{ XmNdecimalPoints, (XtArgVal) & point }
    };
    XtGetValues (widget, args, XtNumber (args));

    double base = pow (10.0, point);
    return value / base;
}


void
myXmScaleSetValue (Widget widget, double value)
{
    short int point;
    Arg args[] = {
	{ XmNdecimalPoints, (XtArgVal) & point }
    };
    XtGetValues (widget, args, XtNumber (args));

    double base = pow (10.0, point);
    XmScaleSetValue (widget, (int) (value * base));
}


#ifndef _BSD_SOURCE
int
strcasecmp (const char* s1, const char* s2)
{
    const char* a1 = s1;
    const char* a2 = s2;
    while (true) {
	char c1 = tolower (*a1++);
	char c2 = tolower (*a2++);
	if (c1 == '\0' && c2 == '\0')
	    return 0;
	if (c1 != c2)
	    return c1 > c2 ? +1 : -1;
    }
}
#endif


bool
one_bit_set (unsigned int x)
{
    unsigned int m = x - 1;
    return (x ^ m) >> 1 == m;
}
