/*---------------------------------------------------------------------------*
 |              PDFlib - A library for generating PDF on the fly             |
 +---------------------------------------------------------------------------+
 | Copyright (c) 1997-2006 Thomas Merz and PDFlib GmbH. All rights reserved. |
 +---------------------------------------------------------------------------+
 |                                                                           |
 |    This software is subject to the PDFlib license. It is NOT in the       |
 |    public domain. Extended versions and commercial licenses are           |
 |    available, please check http://www.pdflib.com.                         |
 |                                                                           |
 *---------------------------------------------------------------------------*/

/* $Id: pc_chartabs.h,v 1.60.2.8 2008/01/10 16:13:48 kurt Exp $
 *
 * This file contains Adobe Glyph Names, HTML character reference names and
 * some special glyph names.
 *
 */

#ifndef PC_CHARTABS_H
#define PC_CHARTABS_H

/*
 * All glyph names of Adobe Glyph List (AGL) version 2.0
 *
 */

static const char glyph__notdef[] = ".notdef";

static const char glyph_A[] = "A";
static const char glyph_AE[] = "AE";
static const char glyph_AEacute[] = "AEacute";
static const char glyph_AEmacron[] = "AEmacron";
static const char glyph_AEsmall[] = "AEsmall";
static const char glyph_Aacute[] = "Aacute";
static const char glyph_Aacutesmall[] = "Aacutesmall";
static const char glyph_Abreve[] = "Abreve";
static const char glyph_Abreveacute[] = "Abreveacute";
static const char glyph_Abrevecyrillic[] = "Abrevecyrillic";
static const char glyph_Abrevedotbelow[] = "Abrevedotbelow";
static const char glyph_Abrevegrave[] = "Abrevegrave";
static const char glyph_Abrevehookabove[] = "Abrevehookabove";
static const char glyph_Abrevetilde[] = "Abrevetilde";
static const char glyph_Acaron[] = "Acaron";
static const char glyph_Acircle[] = "Acircle";
static const char glyph_Acircumflex[] = "Acircumflex";
static const char glyph_Acircumflexacute[] = "Acircumflexacute";
static const char glyph_Acircumflexdotbelow[] = "Acircumflexdotbelow";
static const char glyph_Acircumflexgrave[] = "Acircumflexgrave";
static const char glyph_Acircumflexhookabove[] = "Acircumflexhookabove";
static const char glyph_Acircumflexsmall[] = "Acircumflexsmall";
static const char glyph_Acircumflextilde[] = "Acircumflextilde";
static const char glyph_Acute[] = "Acute";
static const char glyph_Acutesmall[] = "Acutesmall";
static const char glyph_Acyrillic[] = "Acyrillic";
static const char glyph_Adblgrave[] = "Adblgrave";
static const char glyph_Adieresis[] = "Adieresis";
static const char glyph_Adieresiscyrillic[] = "Adieresiscyrillic";
static const char glyph_Adieresismacron[] = "Adieresismacron";
static const char glyph_Adieresissmall[] = "Adieresissmall";
static const char glyph_Adotbelow[] = "Adotbelow";
static const char glyph_Adotmacron[] = "Adotmacron";
static const char glyph_Agrave[] = "Agrave";
static const char glyph_Agravesmall[] = "Agravesmall";
static const char glyph_Ahookabove[] = "Ahookabove";
static const char glyph_Aiecyrillic[] = "Aiecyrillic";
static const char glyph_Ainvertedbreve[] = "Ainvertedbreve";
static const char glyph_Alpha[] = "Alpha";
static const char glyph_Alphatonos[] = "Alphatonos";
static const char glyph_Amacron[] = "Amacron";
static const char glyph_Amonospace[] = "Amonospace";
static const char glyph_Aogonek[] = "Aogonek";
static const char glyph_Aring[] = "Aring";
static const char glyph_Aringacute[] = "Aringacute";
static const char glyph_Aringbelow[] = "Aringbelow";
static const char glyph_Aringsmall[] = "Aringsmall";
static const char glyph_Asmall[] = "Asmall";
static const char glyph_Atilde[] = "Atilde";
static const char glyph_Atildesmall[] = "Atildesmall";
static const char glyph_Aybarmenian[] = "Aybarmenian";
static const char glyph_B[] = "B";
static const char glyph_Bcircle[] = "Bcircle";
static const char glyph_Bdotaccent[] = "Bdotaccent";
static const char glyph_Bdotbelow[] = "Bdotbelow";
static const char glyph_Becyrillic[] = "Becyrillic";
static const char glyph_Benarmenian[] = "Benarmenian";
static const char glyph_Beta[] = "Beta";
static const char glyph_Bhook[] = "Bhook";
static const char glyph_Blinebelow[] = "Blinebelow";
static const char glyph_Bmonospace[] = "Bmonospace";
static const char glyph_Brevesmall[] = "Brevesmall";
static const char glyph_Bsmall[] = "Bsmall";
static const char glyph_Btopbar[] = "Btopbar";
static const char glyph_C[] = "C";
static const char glyph_Caarmenian[] = "Caarmenian";
static const char glyph_Cacute[] = "Cacute";
static const char glyph_Caron[] = "Caron";
static const char glyph_Caronsmall[] = "Caronsmall";
static const char glyph_Ccaron[] = "Ccaron";
static const char glyph_Ccedilla[] = "Ccedilla";
static const char glyph_Ccedillaacute[] = "Ccedillaacute";
static const char glyph_Ccedillasmall[] = "Ccedillasmall";
static const char glyph_Ccircle[] = "Ccircle";
static const char glyph_Ccircumflex[] = "Ccircumflex";
static const char glyph_Cdot[] = "Cdot";
static const char glyph_Cdotaccent[] = "Cdotaccent";
static const char glyph_Cedillasmall[] = "Cedillasmall";
static const char glyph_Chaarmenian[] = "Chaarmenian";
static const char glyph_Cheabkhasiancyrillic[] = "Cheabkhasiancyrillic";
static const char glyph_Checyrillic[] = "Checyrillic";
static const char glyph_Chedescenderabkhasiancyrillic[] =
"Chedescenderabkhasiancyrillic";
static const char glyph_Chedescendercyrillic[] = "Chedescendercyrillic";
static const char glyph_Chedieresiscyrillic[] = "Chedieresiscyrillic";
static const char glyph_Cheharmenian[] = "Cheharmenian";
static const char glyph_Chekhakassiancyrillic[] = "Chekhakassiancyrillic";
static const char glyph_Cheverticalstrokecyrillic[] =
"Cheverticalstrokecyrillic";
static const char glyph_Chi[] = "Chi";
static const char glyph_Chook[] = "Chook";
static const char glyph_Circumflexsmall[] = "Circumflexsmall";
static const char glyph_Cmonospace[] = "Cmonospace";
static const char glyph_Coarmenian[] = "Coarmenian";
static const char glyph_Csmall[] = "Csmall";
static const char glyph_D[] = "D";
static const char glyph_DZ[] = "DZ";
static const char glyph_DZcaron[] = "DZcaron";
static const char glyph_Daarmenian[] = "Daarmenian";
static const char glyph_Dafrican[] = "Dafrican";
static const char glyph_Dcaron[] = "Dcaron";
static const char glyph_Dcedilla[] = "Dcedilla";
static const char glyph_Dcircle[] = "Dcircle";
static const char glyph_Dcircumflexbelow[] = "Dcircumflexbelow";
static const char glyph_Dcroat[] = "Dcroat";
static const char glyph_Ddotaccent[] = "Ddotaccent";
static const char glyph_Ddotbelow[] = "Ddotbelow";
static const char glyph_Decyrillic[] = "Decyrillic";
static const char glyph_Deicoptic[] = "Deicoptic";
static const char glyph_Delta[] = "Delta";
static const char glyph_Deltagreek[] = "Deltagreek";
static const char glyph_Dhook[] = "Dhook";
static const char glyph_Dieresis[] = "Dieresis";
static const char glyph_DieresisAcute[] = "DieresisAcute";
static const char glyph_DieresisGrave[] = "DieresisGrave";
static const char glyph_Dieresissmall[] = "Dieresissmall";
static const char glyph_Digammagreek[] = "Digammagreek";
static const char glyph_Djecyrillic[] = "Djecyrillic";
static const char glyph_Dlinebelow[] = "Dlinebelow";
static const char glyph_Dmonospace[] = "Dmonospace";
static const char glyph_Dotaccentsmall[] = "Dotaccentsmall";
static const char glyph_Dslash[] = "Dslash";
static const char glyph_Dsmall[] = "Dsmall";
static const char glyph_Dtopbar[] = "Dtopbar";
static const char glyph_Dz[] = "Dz";
static const char glyph_Dzcaron[] = "Dzcaron";
static const char glyph_Dzeabkhasiancyrillic[] = "Dzeabkhasiancyrillic";
static const char glyph_Dzecyrillic[] = "Dzecyrillic";
static const char glyph_Dzhecyrillic[] = "Dzhecyrillic";
static const char glyph_E[] = "E";
static const char glyph_Eacute[] = "Eacute";
static const char glyph_Eacutesmall[] = "Eacutesmall";
static const char glyph_Ebreve[] = "Ebreve";
static const char glyph_Ecaron[] = "Ecaron";
static const char glyph_Ecedillabreve[] = "Ecedillabreve";
static const char glyph_Echarmenian[] = "Echarmenian";
static const char glyph_Ecircle[] = "Ecircle";
static const char glyph_Ecircumflex[] = "Ecircumflex";
static const char glyph_Ecircumflexacute[] = "Ecircumflexacute";
static const char glyph_Ecircumflexbelow[] = "Ecircumflexbelow";
static const char glyph_Ecircumflexdotbelow[] = "Ecircumflexdotbelow";
static const char glyph_Ecircumflexgrave[] = "Ecircumflexgrave";
static const char glyph_Ecircumflexhookabove[] = "Ecircumflexhookabove";
static const char glyph_Ecircumflexsmall[] = "Ecircumflexsmall";
static const char glyph_Ecircumflextilde[] = "Ecircumflextilde";
static const char glyph_Ecyrillic[] = "Ecyrillic";
static const char glyph_Edblgrave[] = "Edblgrave";
static const char glyph_Edieresis[] = "Edieresis";
static const char glyph_Edieresissmall[] = "Edieresissmall";
static const char glyph_Edot[] = "Edot";
static const char glyph_Edotaccent[] = "Edotaccent";
static const char glyph_Edotbelow[] = "Edotbelow";
static const char glyph_Efcyrillic[] = "Efcyrillic";
static const char glyph_Egrave[] = "Egrave";
static const char glyph_Egravesmall[] = "Egravesmall";
static const char glyph_Eharmenian[] = "Eharmenian";
static const char glyph_Ehookabove[] = "Ehookabove";
static const char glyph_Eightroman[] = "Eightroman";
static const char glyph_Einvertedbreve[] = "Einvertedbreve";
static const char glyph_Eiotifiedcyrillic[] = "Eiotifiedcyrillic";
static const char glyph_Elcyrillic[] = "Elcyrillic";
static const char glyph_Elevenroman[] = "Elevenroman";
static const char glyph_Emacron[] = "Emacron";
static const char glyph_Emacronacute[] = "Emacronacute";
static const char glyph_Emacrongrave[] = "Emacrongrave";
static const char glyph_Emcyrillic[] = "Emcyrillic";
static const char glyph_Emonospace[] = "Emonospace";
static const char glyph_Encyrillic[] = "Encyrillic";
static const char glyph_Endescendercyrillic[] = "Endescendercyrillic";
static const char glyph_Eng[] = "Eng";
static const char glyph_Enghecyrillic[] = "Enghecyrillic";
static const char glyph_Enhookcyrillic[] = "Enhookcyrillic";
static const char glyph_Eogonek[] = "Eogonek";
static const char glyph_Eopen[] = "Eopen";
static const char glyph_Epsilon[] = "Epsilon";
static const char glyph_Epsilontonos[] = "Epsilontonos";
static const char glyph_Ercyrillic[] = "Ercyrillic";
static const char glyph_Ereversed[] = "Ereversed";
static const char glyph_Ereversedcyrillic[] = "Ereversedcyrillic";
static const char glyph_Escyrillic[] = "Escyrillic";
static const char glyph_Esdescendercyrillic[] = "Esdescendercyrillic";
static const char glyph_Esh[] = "Esh";
static const char glyph_Esmall[] = "Esmall";
static const char glyph_Eta[] = "Eta";
static const char glyph_Etarmenian[] = "Etarmenian";
static const char glyph_Etatonos[] = "Etatonos";
static const char glyph_Eth[] = "Eth";
static const char glyph_Ethsmall[] = "Ethsmall";
static const char glyph_Etilde[] = "Etilde";
static const char glyph_Etildebelow[] = "Etildebelow";
static const char glyph_Euro[] = "Euro";
static const char glyph_Ezh[] = "Ezh";
static const char glyph_Ezhcaron[] = "Ezhcaron";
static const char glyph_Ezhreversed[] = "Ezhreversed";
static const char glyph_F[] = "F";
static const char glyph_Fcircle[] = "Fcircle";
static const char glyph_Fdotaccent[] = "Fdotaccent";
static const char glyph_Feharmenian[] = "Feharmenian";
static const char glyph_Feicoptic[] = "Feicoptic";
static const char glyph_Fhook[] = "Fhook";
static const char glyph_Fitacyrillic[] = "Fitacyrillic";
static const char glyph_Fiveroman[] = "Fiveroman";
static const char glyph_Fmonospace[] = "Fmonospace";
static const char glyph_Fourroman[] = "Fourroman";
static const char glyph_Fsmall[] = "Fsmall";
static const char glyph_G[] = "G";
static const char glyph_GBsquare[] = "GBsquare";
static const char glyph_Gacute[] = "Gacute";
static const char glyph_Gamma[] = "Gamma";
static const char glyph_Gammaafrican[] = "Gammaafrican";
static const char glyph_Gangiacoptic[] = "Gangiacoptic";
static const char glyph_Gbreve[] = "Gbreve";
static const char glyph_Gcaron[] = "Gcaron";
static const char glyph_Gcedilla[] = "Gcedilla";
static const char glyph_Gcircle[] = "Gcircle";
static const char glyph_Gcircumflex[] = "Gcircumflex";
static const char glyph_Gcommaaccent[] = "Gcommaaccent";
static const char glyph_Gdot[] = "Gdot";
static const char glyph_Gdotaccent[] = "Gdotaccent";
static const char glyph_Gecyrillic[] = "Gecyrillic";
static const char glyph_Ghadarmenian[] = "Ghadarmenian";
static const char glyph_Ghemiddlehookcyrillic[] = "Ghemiddlehookcyrillic";
static const char glyph_Ghestrokecyrillic[] = "Ghestrokecyrillic";
static const char glyph_Gheupturncyrillic[] = "Gheupturncyrillic";
static const char glyph_Ghook[] = "Ghook";
static const char glyph_Gimarmenian[] = "Gimarmenian";
static const char glyph_Gjecyrillic[] = "Gjecyrillic";
static const char glyph_Gmacron[] = "Gmacron";
static const char glyph_Gmonospace[] = "Gmonospace";
static const char glyph_Grave[] = "Grave";
static const char glyph_Gravesmall[] = "Gravesmall";
static const char glyph_Gsmall[] = "Gsmall";
static const char glyph_Gsmallhook[] = "Gsmallhook";
static const char glyph_Gstroke[] = "Gstroke";
static const char glyph_H[] = "H";
static const char glyph_H18533[] = "H18533";
static const char glyph_H18543[] = "H18543";
static const char glyph_H18551[] = "H18551";
static const char glyph_H22073[] = "H22073";
static const char glyph_HPsquare[] = "HPsquare";
static const char glyph_Haabkhasiancyrillic[] = "Haabkhasiancyrillic";
static const char glyph_Hadescendercyrillic[] = "Hadescendercyrillic";
static const char glyph_Hardsigncyrillic[] = "Hardsigncyrillic";
static const char glyph_Hbar[] = "Hbar";
static const char glyph_Hbrevebelow[] = "Hbrevebelow";
static const char glyph_Hcedilla[] = "Hcedilla";
static const char glyph_Hcircle[] = "Hcircle";
static const char glyph_Hcircumflex[] = "Hcircumflex";
static const char glyph_Hdieresis[] = "Hdieresis";
static const char glyph_Hdotaccent[] = "Hdotaccent";
static const char glyph_Hdotbelow[] = "Hdotbelow";
static const char glyph_Hmonospace[] = "Hmonospace";
static const char glyph_Hoarmenian[] = "Hoarmenian";
static const char glyph_Horicoptic[] = "Horicoptic";
static const char glyph_Hsmall[] = "Hsmall";
static const char glyph_Hungarumlaut[] = "Hungarumlaut";
static const char glyph_Hungarumlautsmall[] = "Hungarumlautsmall";
static const char glyph_Hzsquare[] = "Hzsquare";
static const char glyph_I[] = "I";
static const char glyph_IAcyrillic[] = "IAcyrillic";
static const char glyph_IJ[] = "IJ";
static const char glyph_IUcyrillic[] = "IUcyrillic";
static const char glyph_Iacute[] = "Iacute";
static const char glyph_Iacutesmall[] = "Iacutesmall";
static const char glyph_Ibreve[] = "Ibreve";
static const char glyph_Icaron[] = "Icaron";
static const char glyph_Icircle[] = "Icircle";
static const char glyph_Icircumflex[] = "Icircumflex";
static const char glyph_Icircumflexsmall[] = "Icircumflexsmall";
static const char glyph_Icyrillic[] = "Icyrillic";
static const char glyph_Idblgrave[] = "Idblgrave";
static const char glyph_Idieresis[] = "Idieresis";
static const char glyph_Idieresisacute[] = "Idieresisacute";
static const char glyph_Idieresiscyrillic[] = "Idieresiscyrillic";
static const char glyph_Idieresissmall[] = "Idieresissmall";
static const char glyph_Idot[] = "Idot";
static const char glyph_Idotaccent[] = "Idotaccent";
static const char glyph_Idotbelow[] = "Idotbelow";
static const char glyph_Iebrevecyrillic[] = "Iebrevecyrillic";
static const char glyph_Iecyrillic[] = "Iecyrillic";
static const char glyph_Ifraktur[] = "Ifraktur";
static const char glyph_Igrave[] = "Igrave";
static const char glyph_Igravesmall[] = "Igravesmall";
static const char glyph_Ihookabove[] = "Ihookabove";
static const char glyph_Iicyrillic[] = "Iicyrillic";
static const char glyph_Iinvertedbreve[] = "Iinvertedbreve";
static const char glyph_Iishortcyrillic[] = "Iishortcyrillic";
static const char glyph_Imacron[] = "Imacron";
static const char glyph_Imacroncyrillic[] = "Imacroncyrillic";
static const char glyph_Imonospace[] = "Imonospace";
static const char glyph_Iniarmenian[] = "Iniarmenian";
static const char glyph_Iocyrillic[] = "Iocyrillic";
static const char glyph_Iogonek[] = "Iogonek";
static const char glyph_Iota[] = "Iota";
static const char glyph_Iotaafrican[] = "Iotaafrican";
static const char glyph_Iotadieresis[] = "Iotadieresis";
static const char glyph_Iotatonos[] = "Iotatonos";
static const char glyph_Ismall[] = "Ismall";
static const char glyph_Istroke[] = "Istroke";
static const char glyph_Itilde[] = "Itilde";
static const char glyph_Itildebelow[] = "Itildebelow";
static const char glyph_Izhitsacyrillic[] = "Izhitsacyrillic";
static const char glyph_Izhitsadblgravecyrillic[] = "Izhitsadblgravecyrillic";
static const char glyph_J[] = "J";
static const char glyph_Jaarmenian[] = "Jaarmenian";
static const char glyph_Jcircle[] = "Jcircle";
static const char glyph_Jcircumflex[] = "Jcircumflex";
static const char glyph_Jecyrillic[] = "Jecyrillic";
static const char glyph_Jheharmenian[] = "Jheharmenian";
static const char glyph_Jmonospace[] = "Jmonospace";
static const char glyph_Jsmall[] = "Jsmall";
static const char glyph_K[] = "K";
static const char glyph_KBsquare[] = "KBsquare";
static const char glyph_KKsquare[] = "KKsquare";
static const char glyph_Kabashkircyrillic[] = "Kabashkircyrillic";
static const char glyph_Kacute[] = "Kacute";
static const char glyph_Kacyrillic[] = "Kacyrillic";
static const char glyph_Kadescendercyrillic[] = "Kadescendercyrillic";
static const char glyph_Kahookcyrillic[] = "Kahookcyrillic";
static const char glyph_Kappa[] = "Kappa";
static const char glyph_Kastrokecyrillic[] = "Kastrokecyrillic";
static const char glyph_Kaverticalstrokecyrillic[] = "Kaverticalstrokecyrillic";
static const char glyph_Kcaron[] = "Kcaron";
static const char glyph_Kcedilla[] = "Kcedilla";
static const char glyph_Kcircle[] = "Kcircle";
static const char glyph_Kcommaaccent[] = "Kcommaaccent";
static const char glyph_Kdotbelow[] = "Kdotbelow";
static const char glyph_Keharmenian[] = "Keharmenian";
static const char glyph_Kenarmenian[] = "Kenarmenian";
static const char glyph_Khacyrillic[] = "Khacyrillic";
static const char glyph_Kheicoptic[] = "Kheicoptic";
static const char glyph_Khook[] = "Khook";
static const char glyph_Kjecyrillic[] = "Kjecyrillic";
static const char glyph_Klinebelow[] = "Klinebelow";
static const char glyph_Kmonospace[] = "Kmonospace";
static const char glyph_Koppacyrillic[] = "Koppacyrillic";
static const char glyph_Koppagreek[] = "Koppagreek";
static const char glyph_Ksicyrillic[] = "Ksicyrillic";
static const char glyph_Ksmall[] = "Ksmall";
static const char glyph_L[] = "L";
static const char glyph_LJ[] = "LJ";
static const char glyph_LL[] = "LL";
static const char glyph_Lacute[] = "Lacute";
static const char glyph_Lambda[] = "Lambda";
static const char glyph_Lcaron[] = "Lcaron";
static const char glyph_Lcedilla[] = "Lcedilla";
static const char glyph_Lcircle[] = "Lcircle";
static const char glyph_Lcircumflexbelow[] = "Lcircumflexbelow";
static const char glyph_Lcommaaccent[] = "Lcommaaccent";
static const char glyph_Ldot[] = "Ldot";
static const char glyph_Ldotaccent[] = "Ldotaccent";
static const char glyph_Ldotbelow[] = "Ldotbelow";
static const char glyph_Ldotbelowmacron[] = "Ldotbelowmacron";
static const char glyph_Liwnarmenian[] = "Liwnarmenian";
static const char glyph_Lj[] = "Lj";
static const char glyph_Ljecyrillic[] = "Ljecyrillic";
static const char glyph_Llinebelow[] = "Llinebelow";
static const char glyph_Lmonospace[] = "Lmonospace";
static const char glyph_Lslash[] = "Lslash";
static const char glyph_Lslashsmall[] = "Lslashsmall";
static const char glyph_Lsmall[] = "Lsmall";
static const char glyph_M[] = "M";
static const char glyph_MBsquare[] = "MBsquare";
static const char glyph_Macron[] = "Macron";
static const char glyph_Macronsmall[] = "Macronsmall";
static const char glyph_Macute[] = "Macute";
static const char glyph_Mcircle[] = "Mcircle";
static const char glyph_Mdotaccent[] = "Mdotaccent";
static const char glyph_Mdotbelow[] = "Mdotbelow";
static const char glyph_Menarmenian[] = "Menarmenian";
static const char glyph_Mmonospace[] = "Mmonospace";
static const char glyph_Msmall[] = "Msmall";
static const char glyph_Mturned[] = "Mturned";
static const char glyph_Mu[] = "Mu";
static const char glyph_N[] = "N";
static const char glyph_NJ[] = "NJ";
static const char glyph_Nacute[] = "Nacute";
static const char glyph_Ncaron[] = "Ncaron";
static const char glyph_Ncedilla[] = "Ncedilla";
static const char glyph_Ncircle[] = "Ncircle";
static const char glyph_Ncircumflexbelow[] = "Ncircumflexbelow";
static const char glyph_Ncommaaccent[] = "Ncommaaccent";
static const char glyph_Ndotaccent[] = "Ndotaccent";
static const char glyph_Ndotbelow[] = "Ndotbelow";
static const char glyph_Nhookleft[] = "Nhookleft";
static const char glyph_Nineroman[] = "Nineroman";
static const char glyph_Nj[] = "Nj";
static const char glyph_Njecyrillic[] = "Njecyrillic";
static const char glyph_Nlinebelow[] = "Nlinebelow";
static const char glyph_Nmonospace[] = "Nmonospace";
static const char glyph_Nowarmenian[] = "Nowarmenian";
static const char glyph_Nsmall[] = "Nsmall";
static const char glyph_Ntilde[] = "Ntilde";
static const char glyph_Ntildesmall[] = "Ntildesmall";
static const char glyph_Nu[] = "Nu";
static const char glyph_O[] = "O";
static const char glyph_OE[] = "OE";
static const char glyph_OEsmall[] = "OEsmall";
static const char glyph_Oacute[] = "Oacute";
static const char glyph_Oacutesmall[] = "Oacutesmall";
static const char glyph_Obarredcyrillic[] = "Obarredcyrillic";
static const char glyph_Obarreddieresiscyrillic[] = "Obarreddieresiscyrillic";
static const char glyph_Obreve[] = "Obreve";
static const char glyph_Ocaron[] = "Ocaron";
static const char glyph_Ocenteredtilde[] = "Ocenteredtilde";
static const char glyph_Ocircle[] = "Ocircle";
static const char glyph_Ocircumflex[] = "Ocircumflex";
static const char glyph_Ocircumflexacute[] = "Ocircumflexacute";
static const char glyph_Ocircumflexdotbelow[] = "Ocircumflexdotbelow";
static const char glyph_Ocircumflexgrave[] = "Ocircumflexgrave";
static const char glyph_Ocircumflexhookabove[] = "Ocircumflexhookabove";
static const char glyph_Ocircumflexsmall[] = "Ocircumflexsmall";
static const char glyph_Ocircumflextilde[] = "Ocircumflextilde";
static const char glyph_Ocyrillic[] = "Ocyrillic";
static const char glyph_Odblacute[] = "Odblacute";
static const char glyph_Odblgrave[] = "Odblgrave";
static const char glyph_Odieresis[] = "Odieresis";
static const char glyph_Odieresiscyrillic[] = "Odieresiscyrillic";
static const char glyph_Odieresissmall[] = "Odieresissmall";
static const char glyph_Odotbelow[] = "Odotbelow";
static const char glyph_Ogoneksmall[] = "Ogoneksmall";
static const char glyph_Ograve[] = "Ograve";
static const char glyph_Ogravesmall[] = "Ogravesmall";
static const char glyph_Oharmenian[] = "Oharmenian";
static const char glyph_Ohm[] = "Ohm";
static const char glyph_Ohookabove[] = "Ohookabove";
static const char glyph_Ohorn[] = "Ohorn";
static const char glyph_Ohornacute[] = "Ohornacute";
static const char glyph_Ohorndotbelow[] = "Ohorndotbelow";
static const char glyph_Ohorngrave[] = "Ohorngrave";
static const char glyph_Ohornhookabove[] = "Ohornhookabove";
static const char glyph_Ohorntilde[] = "Ohorntilde";
static const char glyph_Ohungarumlaut[] = "Ohungarumlaut";
static const char glyph_Oi[] = "Oi";
static const char glyph_Oinvertedbreve[] = "Oinvertedbreve";
static const char glyph_Omacron[] = "Omacron";
static const char glyph_Omacronacute[] = "Omacronacute";
static const char glyph_Omacrongrave[] = "Omacrongrave";
static const char glyph_Omega[] = "Omega";
static const char glyph_Omegacyrillic[] = "Omegacyrillic";
static const char glyph_Omegagreek[] = "Omegagreek";
static const char glyph_Omegaroundcyrillic[] = "Omegaroundcyrillic";
static const char glyph_Omegatitlocyrillic[] = "Omegatitlocyrillic";
static const char glyph_Omegatonos[] = "Omegatonos";
static const char glyph_Omicron[] = "Omicron";
static const char glyph_Omicrontonos[] = "Omicrontonos";
static const char glyph_Omonospace[] = "Omonospace";
static const char glyph_Oneroman[] = "Oneroman";
static const char glyph_Oogonek[] = "Oogonek";
static const char glyph_Oogonekmacron[] = "Oogonekmacron";
static const char glyph_Oopen[] = "Oopen";
static const char glyph_Oslash[] = "Oslash";
static const char glyph_Oslashacute[] = "Oslashacute";
static const char glyph_Oslashsmall[] = "Oslashsmall";
static const char glyph_Osmall[] = "Osmall";
static const char glyph_Ostrokeacute[] = "Ostrokeacute";
static const char glyph_Otcyrillic[] = "Otcyrillic";
static const char glyph_Otilde[] = "Otilde";
static const char glyph_Otildeacute[] = "Otildeacute";
static const char glyph_Otildedieresis[] = "Otildedieresis";
static const char glyph_Otildesmall[] = "Otildesmall";
static const char glyph_P[] = "P";
static const char glyph_Pacute[] = "Pacute";
static const char glyph_Pcircle[] = "Pcircle";
static const char glyph_Pdotaccent[] = "Pdotaccent";
static const char glyph_Pecyrillic[] = "Pecyrillic";
static const char glyph_Peharmenian[] = "Peharmenian";
static const char glyph_Pemiddlehookcyrillic[] = "Pemiddlehookcyrillic";
static const char glyph_Phi[] = "Phi";
static const char glyph_Phook[] = "Phook";
static const char glyph_Pi[] = "Pi";
static const char glyph_Piwrarmenian[] = "Piwrarmenian";
static const char glyph_Pmonospace[] = "Pmonospace";
static const char glyph_Psi[] = "Psi";
static const char glyph_Psicyrillic[] = "Psicyrillic";
static const char glyph_Psmall[] = "Psmall";
static const char glyph_Q[] = "Q";
static const char glyph_Qcircle[] = "Qcircle";
static const char glyph_Qmonospace[] = "Qmonospace";
static const char glyph_Qsmall[] = "Qsmall";
static const char glyph_R[] = "R";
static const char glyph_Raarmenian[] = "Raarmenian";
static const char glyph_Racute[] = "Racute";
static const char glyph_Rcaron[] = "Rcaron";
static const char glyph_Rcedilla[] = "Rcedilla";
static const char glyph_Rcircle[] = "Rcircle";
static const char glyph_Rcommaaccent[] = "Rcommaaccent";
static const char glyph_Rdblgrave[] = "Rdblgrave";
static const char glyph_Rdotaccent[] = "Rdotaccent";
static const char glyph_Rdotbelow[] = "Rdotbelow";
static const char glyph_Rdotbelowmacron[] = "Rdotbelowmacron";
static const char glyph_Reharmenian[] = "Reharmenian";
static const char glyph_Rfraktur[] = "Rfraktur";
static const char glyph_Rho[] = "Rho";
static const char glyph_Ringsmall[] = "Ringsmall";
static const char glyph_Rinvertedbreve[] = "Rinvertedbreve";
static const char glyph_Rlinebelow[] = "Rlinebelow";
static const char glyph_Rmonospace[] = "Rmonospace";
static const char glyph_Rsmall[] = "Rsmall";
static const char glyph_Rsmallinverted[] = "Rsmallinverted";
static const char glyph_Rsmallinvertedsuperior[] = "Rsmallinvertedsuperior";
static const char glyph_S[] = "S";
static const char glyph_SF010000[] = "SF010000";
static const char glyph_SF020000[] = "SF020000";
static const char glyph_SF030000[] = "SF030000";
static const char glyph_SF040000[] = "SF040000";
static const char glyph_SF050000[] = "SF050000";
static const char glyph_SF060000[] = "SF060000";
static const char glyph_SF070000[] = "SF070000";
static const char glyph_SF080000[] = "SF080000";
static const char glyph_SF090000[] = "SF090000";
static const char glyph_SF100000[] = "SF100000";
static const char glyph_SF110000[] = "SF110000";
static const char glyph_SF190000[] = "SF190000";
static const char glyph_SF200000[] = "SF200000";
static const char glyph_SF210000[] = "SF210000";
static const char glyph_SF220000[] = "SF220000";
static const char glyph_SF230000[] = "SF230000";
static const char glyph_SF240000[] = "SF240000";
static const char glyph_SF250000[] = "SF250000";
static const char glyph_SF260000[] = "SF260000";
static const char glyph_SF270000[] = "SF270000";
static const char glyph_SF280000[] = "SF280000";
static const char glyph_SF360000[] = "SF360000";
static const char glyph_SF370000[] = "SF370000";
static const char glyph_SF380000[] = "SF380000";
static const char glyph_SF390000[] = "SF390000";
static const char glyph_SF400000[] = "SF400000";
static const char glyph_SF410000[] = "SF410000";
static const char glyph_SF420000[] = "SF420000";
static const char glyph_SF430000[] = "SF430000";
static const char glyph_SF440000[] = "SF440000";
static const char glyph_SF450000[] = "SF450000";
static const char glyph_SF460000[] = "SF460000";
static const char glyph_SF470000[] = "SF470000";
static const char glyph_SF480000[] = "SF480000";
static const char glyph_SF490000[] = "SF490000";
static const char glyph_SF500000[] = "SF500000";
static const char glyph_SF510000[] = "SF510000";
static const char glyph_SF520000[] = "SF520000";
static const char glyph_SF530000[] = "SF530000";
static const char glyph_SF540000[] = "SF540000";
static const char glyph_Sacute[] = "Sacute";
static const char glyph_Sacutedotaccent[] = "Sacutedotaccent";
static const char glyph_Sampigreek[] = "Sampigreek";
static const char glyph_Scaron[] = "Scaron";
static const char glyph_Scarondotaccent[] = "Scarondotaccent";
static const char glyph_Scaronsmall[] = "Scaronsmall";
static const char glyph_Scedilla[] = "Scedilla";
static const char glyph_Schwa[] = "Schwa";
static const char glyph_Schwacyrillic[] = "Schwacyrillic";
static const char glyph_Schwadieresiscyrillic[] = "Schwadieresiscyrillic";
static const char glyph_Scircle[] = "Scircle";
static const char glyph_Scircumflex[] = "Scircumflex";
static const char glyph_Scommaaccent[] = "Scommaaccent";
static const char glyph_Sdotaccent[] = "Sdotaccent";
static const char glyph_Sdotbelow[] = "Sdotbelow";
static const char glyph_Sdotbelowdotaccent[] = "Sdotbelowdotaccent";
static const char glyph_Seharmenian[] = "Seharmenian";
static const char glyph_Sevenroman[] = "Sevenroman";
static const char glyph_Shaarmenian[] = "Shaarmenian";
static const char glyph_Shacyrillic[] = "Shacyrillic";
static const char glyph_Shchacyrillic[] = "Shchacyrillic";
static const char glyph_Sheicoptic[] = "Sheicoptic";
static const char glyph_Shhacyrillic[] = "Shhacyrillic";
static const char glyph_Shimacoptic[] = "Shimacoptic";
static const char glyph_Sigma[] = "Sigma";
static const char glyph_Sixroman[] = "Sixroman";
static const char glyph_Smonospace[] = "Smonospace";
static const char glyph_Softsigncyrillic[] = "Softsigncyrillic";
static const char glyph_Ssmall[] = "Ssmall";
static const char glyph_Stigmagreek[] = "Stigmagreek";
static const char glyph_T[] = "T";
static const char glyph_Tau[] = "Tau";
static const char glyph_Tbar[] = "Tbar";
static const char glyph_Tcaron[] = "Tcaron";
static const char glyph_Tcedilla[] = "Tcedilla";
static const char glyph_Tcircle[] = "Tcircle";
static const char glyph_Tcircumflexbelow[] = "Tcircumflexbelow";
static const char glyph_Tcommaaccent[] = "Tcommaaccent";
static const char glyph_Tdotaccent[] = "Tdotaccent";
static const char glyph_Tdotbelow[] = "Tdotbelow";
static const char glyph_Tecyrillic[] = "Tecyrillic";
static const char glyph_Tedescendercyrillic[] = "Tedescendercyrillic";
static const char glyph_Tenroman[] = "Tenroman";
static const char glyph_Tetsecyrillic[] = "Tetsecyrillic";
static const char glyph_Theta[] = "Theta";
static const char glyph_Thook[] = "Thook";
static const char glyph_Thorn[] = "Thorn";
static const char glyph_Thornsmall[] = "Thornsmall";
static const char glyph_Threeroman[] = "Threeroman";
static const char glyph_Tildesmall[] = "Tildesmall";
static const char glyph_Tiwnarmenian[] = "Tiwnarmenian";
static const char glyph_Tlinebelow[] = "Tlinebelow";
static const char glyph_Tmonospace[] = "Tmonospace";
static const char glyph_Toarmenian[] = "Toarmenian";
static const char glyph_Tonefive[] = "Tonefive";
static const char glyph_Tonesix[] = "Tonesix";
static const char glyph_Tonetwo[] = "Tonetwo";
static const char glyph_Tretroflexhook[] = "Tretroflexhook";
static const char glyph_Tsecyrillic[] = "Tsecyrillic";
static const char glyph_Tshecyrillic[] = "Tshecyrillic";
static const char glyph_Tsmall[] = "Tsmall";
static const char glyph_Twelveroman[] = "Twelveroman";
static const char glyph_Tworoman[] = "Tworoman";
static const char glyph_U[] = "U";
static const char glyph_Uacute[] = "Uacute";
static const char glyph_Uacutesmall[] = "Uacutesmall";
static const char glyph_Ubreve[] = "Ubreve";
static const char glyph_Ucaron[] = "Ucaron";
static const char glyph_Ucircle[] = "Ucircle";
static const char glyph_Ucircumflex[] = "Ucircumflex";
static const char glyph_Ucircumflexbelow[] = "Ucircumflexbelow";
static const char glyph_Ucircumflexsmall[] = "Ucircumflexsmall";
static const char glyph_Ucyrillic[] = "Ucyrillic";
static const char glyph_Udblacute[] = "Udblacute";
static const char glyph_Udblgrave[] = "Udblgrave";
static const char glyph_Udieresis[] = "Udieresis";
static const char glyph_Udieresisacute[] = "Udieresisacute";
static const char glyph_Udieresisbelow[] = "Udieresisbelow";
static const char glyph_Udieresiscaron[] = "Udieresiscaron";
static const char glyph_Udieresiscyrillic[] = "Udieresiscyrillic";
static const char glyph_Udieresisgrave[] = "Udieresisgrave";
static const char glyph_Udieresismacron[] = "Udieresismacron";
static const char glyph_Udieresissmall[] = "Udieresissmall";
static const char glyph_Udotbelow[] = "Udotbelow";
static const char glyph_Ugrave[] = "Ugrave";
static const char glyph_Ugravesmall[] = "Ugravesmall";
static const char glyph_Uhookabove[] = "Uhookabove";
static const char glyph_Uhorn[] = "Uhorn";
static const char glyph_Uhornacute[] = "Uhornacute";
static const char glyph_Uhorndotbelow[] = "Uhorndotbelow";
static const char glyph_Uhorngrave[] = "Uhorngrave";
static const char glyph_Uhornhookabove[] = "Uhornhookabove";
static const char glyph_Uhorntilde[] = "Uhorntilde";
static const char glyph_Uhungarumlaut[] = "Uhungarumlaut";
static const char glyph_Uhungarumlautcyrillic[] = "Uhungarumlautcyrillic";
static const char glyph_Uinvertedbreve[] = "Uinvertedbreve";
static const char glyph_Ukcyrillic[] = "Ukcyrillic";
static const char glyph_Umacron[] = "Umacron";
static const char glyph_Umacroncyrillic[] = "Umacroncyrillic";
static const char glyph_Umacrondieresis[] = "Umacrondieresis";
static const char glyph_Umonospace[] = "Umonospace";
static const char glyph_Uogonek[] = "Uogonek";
static const char glyph_Upsilon[] = "Upsilon";
static const char glyph_Upsilon1[] = "Upsilon1";
static const char glyph_Upsilonacutehooksymbolgreek[] =
"Upsilonacutehooksymbolgreek";
static const char glyph_Upsilonafrican[] = "Upsilonafrican";
static const char glyph_Upsilondieresis[] = "Upsilondieresis";
static const char glyph_Upsilondieresishooksymbolgreek[] =
"Upsilondieresishooksymbolgreek";
static const char glyph_Upsilonhooksymbol[] = "Upsilonhooksymbol";
static const char glyph_Upsilontonos[] = "Upsilontonos";
static const char glyph_Uring[] = "Uring";
static const char glyph_Ushortcyrillic[] = "Ushortcyrillic";
static const char glyph_Usmall[] = "Usmall";
static const char glyph_Ustraightcyrillic[] = "Ustraightcyrillic";
static const char glyph_Ustraightstrokecyrillic[] = "Ustraightstrokecyrillic";
static const char glyph_Utilde[] = "Utilde";
static const char glyph_Utildeacute[] = "Utildeacute";
static const char glyph_Utildebelow[] = "Utildebelow";
static const char glyph_V[] = "V";
static const char glyph_Vcircle[] = "Vcircle";
static const char glyph_Vdotbelow[] = "Vdotbelow";
static const char glyph_Vecyrillic[] = "Vecyrillic";
static const char glyph_Vewarmenian[] = "Vewarmenian";
static const char glyph_Vhook[] = "Vhook";
static const char glyph_Vmonospace[] = "Vmonospace";
static const char glyph_Voarmenian[] = "Voarmenian";
static const char glyph_Vsmall[] = "Vsmall";
static const char glyph_Vtilde[] = "Vtilde";
static const char glyph_W[] = "W";
static const char glyph_Wacute[] = "Wacute";
static const char glyph_Wcircle[] = "Wcircle";
static const char glyph_Wcircumflex[] = "Wcircumflex";
static const char glyph_Wdieresis[] = "Wdieresis";
static const char glyph_Wdotaccent[] = "Wdotaccent";
static const char glyph_Wdotbelow[] = "Wdotbelow";
static const char glyph_Wgrave[] = "Wgrave";
static const char glyph_Wmonospace[] = "Wmonospace";
static const char glyph_Wsmall[] = "Wsmall";
static const char glyph_X[] = "X";
static const char glyph_Xcircle[] = "Xcircle";
static const char glyph_Xdieresis[] = "Xdieresis";
static const char glyph_Xdotaccent[] = "Xdotaccent";
static const char glyph_Xeharmenian[] = "Xeharmenian";
static const char glyph_Xi[] = "Xi";
static const char glyph_Xmonospace[] = "Xmonospace";
static const char glyph_Xsmall[] = "Xsmall";
static const char glyph_Y[] = "Y";
static const char glyph_Yacute[] = "Yacute";
static const char glyph_Yacutesmall[] = "Yacutesmall";
static const char glyph_Yatcyrillic[] = "Yatcyrillic";
static const char glyph_Ycircle[] = "Ycircle";
static const char glyph_Ycircumflex[] = "Ycircumflex";
static const char glyph_Ydieresis[] = "Ydieresis";
static const char glyph_Ydieresissmall[] = "Ydieresissmall";
static const char glyph_Ydotaccent[] = "Ydotaccent";
static const char glyph_Ydotbelow[] = "Ydotbelow";
static const char glyph_Yericyrillic[] = "Yericyrillic";
static const char glyph_Yerudieresiscyrillic[] = "Yerudieresiscyrillic";
static const char glyph_Ygrave[] = "Ygrave";
static const char glyph_Yhook[] = "Yhook";
static const char glyph_Yhookabove[] = "Yhookabove";
static const char glyph_Yiarmenian[] = "Yiarmenian";
static const char glyph_Yicyrillic[] = "Yicyrillic";
static const char glyph_Yiwnarmenian[] = "Yiwnarmenian";
static const char glyph_Ymonospace[] = "Ymonospace";
static const char glyph_Ysmall[] = "Ysmall";
static const char glyph_Ytilde[] = "Ytilde";
static const char glyph_Yusbigcyrillic[] = "Yusbigcyrillic";
static const char glyph_Yusbigiotifiedcyrillic[] = "Yusbigiotifiedcyrillic";
static const char glyph_Yuslittlecyrillic[] = "Yuslittlecyrillic";
static const char glyph_Yuslittleiotifiedcyrillic[] =
"Yuslittleiotifiedcyrillic";
static const char glyph_Z[] = "Z";
static const char glyph_Zaarmenian[] = "Zaarmenian";
static const char glyph_Zacute[] = "Zacute";
static const char glyph_Zcaron[] = "Zcaron";
static const char glyph_Zcaronsmall[] = "Zcaronsmall";
static const char glyph_Zcircle[] = "Zcircle";
static const char glyph_Zcircumflex[] = "Zcircumflex";
static const char glyph_Zdot[] = "Zdot";
static const char glyph_Zdotaccent[] = "Zdotaccent";
static const char glyph_Zdotbelow[] = "Zdotbelow";
static const char glyph_Zecyrillic[] = "Zecyrillic";
static const char glyph_Zedescendercyrillic[] = "Zedescendercyrillic";
static const char glyph_Zedieresiscyrillic[] = "Zedieresiscyrillic";
static const char glyph_Zeta[] = "Zeta";
static const char glyph_Zhearmenian[] = "Zhearmenian";
static const char glyph_Zhebrevecyrillic[] = "Zhebrevecyrillic";
static const char glyph_Zhecyrillic[] = "Zhecyrillic";
static const char glyph_Zhedescendercyrillic[] = "Zhedescendercyrillic";
static const char glyph_Zhedieresiscyrillic[] = "Zhedieresiscyrillic";
static const char glyph_Zlinebelow[] = "Zlinebelow";
static const char glyph_Zmonospace[] = "Zmonospace";
static const char glyph_Zsmall[] = "Zsmall";
static const char glyph_Zstroke[] = "Zstroke";
static const char glyph_a[] = "a";
static const char glyph_aabengali[] = "aabengali";
static const char glyph_aacute[] = "aacute";
static const char glyph_aadeva[] = "aadeva";
static const char glyph_aagujarati[] = "aagujarati";
static const char glyph_aagurmukhi[] = "aagurmukhi";
static const char glyph_aamatragurmukhi[] = "aamatragurmukhi";
static const char glyph_aarusquare[] = "aarusquare";
static const char glyph_aavowelsignbengali[] = "aavowelsignbengali";
static const char glyph_aavowelsigndeva[] = "aavowelsigndeva";
static const char glyph_aavowelsigngujarati[] = "aavowelsigngujarati";
static const char glyph_abbreviationmarkarmenian[] =
"abbreviationmarkarmenian";
static const char glyph_abbreviationsigndeva[] = "abbreviationsigndeva";
static const char glyph_abengali[] = "abengali";
static const char glyph_abopomofo[] = "abopomofo";
static const char glyph_abreve[] = "abreve";
static const char glyph_abreveacute[] = "abreveacute";
static const char glyph_abrevecyrillic[] = "abrevecyrillic";
static const char glyph_abrevedotbelow[] = "abrevedotbelow";
static const char glyph_abrevegrave[] = "abrevegrave";
static const char glyph_abrevehookabove[] = "abrevehookabove";
static const char glyph_abrevetilde[] = "abrevetilde";
static const char glyph_acaron[] = "acaron";
static const char glyph_acircle[] = "acircle";
static const char glyph_acircumflex[] = "acircumflex";
static const char glyph_acircumflexacute[] = "acircumflexacute";
static const char glyph_acircumflexdotbelow[] = "acircumflexdotbelow";
static const char glyph_acircumflexgrave[] = "acircumflexgrave";
static const char glyph_acircumflexhookabove[] = "acircumflexhookabove";
static const char glyph_acircumflextilde[] = "acircumflextilde";
static const char glyph_acute[] = "acute";
static const char glyph_acutebelowcmb[] = "acutebelowcmb";
static const char glyph_acutecmb[] = "acutecmb";
static const char glyph_acutecomb[] = "acutecomb";
static const char glyph_acutedeva[] = "acutedeva";
static const char glyph_acutelowmod[] = "acutelowmod";
static const char glyph_acutetonecmb[] = "acutetonecmb";
static const char glyph_acyrillic[] = "acyrillic";
static const char glyph_adblgrave[] = "adblgrave";
static const char glyph_addakgurmukhi[] = "addakgurmukhi";
static const char glyph_adeva[] = "adeva";
static const char glyph_adieresis[] = "adieresis";
static const char glyph_adieresiscyrillic[] = "adieresiscyrillic";
static const char glyph_adieresismacron[] = "adieresismacron";
static const char glyph_adotbelow[] = "adotbelow";
static const char glyph_adotmacron[] = "adotmacron";
static const char glyph_ae[] = "ae";
static const char glyph_aeacute[] = "aeacute";
static const char glyph_aekorean[] = "aekorean";
static const char glyph_aemacron[] = "aemacron";
static const char glyph_afii00208[] = "afii00208";
static const char glyph_afii08941[] = "afii08941";
static const char glyph_afii10017[] = "afii10017";
static const char glyph_afii10018[] = "afii10018";
static const char glyph_afii10019[] = "afii10019";
static const char glyph_afii10020[] = "afii10020";
static const char glyph_afii10021[] = "afii10021";
static const char glyph_afii10022[] = "afii10022";
static const char glyph_afii10023[] = "afii10023";
static const char glyph_afii10024[] = "afii10024";
static const char glyph_afii10025[] = "afii10025";
static const char glyph_afii10026[] = "afii10026";
static const char glyph_afii10027[] = "afii10027";
static const char glyph_afii10028[] = "afii10028";
static const char glyph_afii10029[] = "afii10029";
static const char glyph_afii10030[] = "afii10030";
static const char glyph_afii10031[] = "afii10031";
static const char glyph_afii10032[] = "afii10032";
static const char glyph_afii10033[] = "afii10033";
static const char glyph_afii10034[] = "afii10034";
static const char glyph_afii10035[] = "afii10035";
static const char glyph_afii10036[] = "afii10036";
static const char glyph_afii10037[] = "afii10037";
static const char glyph_afii10038[] = "afii10038";
static const char glyph_afii10039[] = "afii10039";
static const char glyph_afii10040[] = "afii10040";
static const char glyph_afii10041[] = "afii10041";
static const char glyph_afii10042[] = "afii10042";
static const char glyph_afii10043[] = "afii10043";
static const char glyph_afii10044[] = "afii10044";
static const char glyph_afii10045[] = "afii10045";
static const char glyph_afii10046[] = "afii10046";
static const char glyph_afii10047[] = "afii10047";
static const char glyph_afii10048[] = "afii10048";
static const char glyph_afii10049[] = "afii10049";
static const char glyph_afii10050[] = "afii10050";
static const char glyph_afii10051[] = "afii10051";
static const char glyph_afii10052[] = "afii10052";
static const char glyph_afii10053[] = "afii10053";
static const char glyph_afii10054[] = "afii10054";
static const char glyph_afii10055[] = "afii10055";
static const char glyph_afii10056[] = "afii10056";
static const char glyph_afii10057[] = "afii10057";
static const char glyph_afii10058[] = "afii10058";
static const char glyph_afii10059[] = "afii10059";
static const char glyph_afii10060[] = "afii10060";
static const char glyph_afii10061[] = "afii10061";
static const char glyph_afii10062[] = "afii10062";
static const char glyph_afii10063[] = "afii10063";
static const char glyph_afii10064[] = "afii10064";
static const char glyph_afii10065[] = "afii10065";
static const char glyph_afii10066[] = "afii10066";
static const char glyph_afii10067[] = "afii10067";
static const char glyph_afii10068[] = "afii10068";
static const char glyph_afii10069[] = "afii10069";
static const char glyph_afii10070[] = "afii10070";
static const char glyph_afii10071[] = "afii10071";
static const char glyph_afii10072[] = "afii10072";
static const char glyph_afii10073[] = "afii10073";
static const char glyph_afii10074[] = "afii10074";
static const char glyph_afii10075[] = "afii10075";
static const char glyph_afii10076[] = "afii10076";
static const char glyph_afii10077[] = "afii10077";
static const char glyph_afii10078[] = "afii10078";
static const char glyph_afii10079[] = "afii10079";
static const char glyph_afii10080[] = "afii10080";
static const char glyph_afii10081[] = "afii10081";
static const char glyph_afii10082[] = "afii10082";
static const char glyph_afii10083[] = "afii10083";
static const char glyph_afii10084[] = "afii10084";
static const char glyph_afii10085[] = "afii10085";
static const char glyph_afii10086[] = "afii10086";
static const char glyph_afii10087[] = "afii10087";
static const char glyph_afii10088[] = "afii10088";
static const char glyph_afii10089[] = "afii10089";
static const char glyph_afii10090[] = "afii10090";
static const char glyph_afii10091[] = "afii10091";
static const char glyph_afii10092[] = "afii10092";
static const char glyph_afii10093[] = "afii10093";
static const char glyph_afii10094[] = "afii10094";
static const char glyph_afii10095[] = "afii10095";
static const char glyph_afii10096[] = "afii10096";
static const char glyph_afii10097[] = "afii10097";
static const char glyph_afii10098[] = "afii10098";
static const char glyph_afii10099[] = "afii10099";
static const char glyph_afii10100[] = "afii10100";
static const char glyph_afii10101[] = "afii10101";
static const char glyph_afii10102[] = "afii10102";
static const char glyph_afii10103[] = "afii10103";
static const char glyph_afii10104[] = "afii10104";
static const char glyph_afii10105[] = "afii10105";
static const char glyph_afii10106[] = "afii10106";
static const char glyph_afii10107[] = "afii10107";
static const char glyph_afii10108[] = "afii10108";
static const char glyph_afii10109[] = "afii10109";
static const char glyph_afii10110[] = "afii10110";
static const char glyph_afii10145[] = "afii10145";
static const char glyph_afii10146[] = "afii10146";
static const char glyph_afii10147[] = "afii10147";
static const char glyph_afii10148[] = "afii10148";
static const char glyph_afii10192[] = "afii10192";
static const char glyph_afii10193[] = "afii10193";
static const char glyph_afii10194[] = "afii10194";
static const char glyph_afii10195[] = "afii10195";
static const char glyph_afii10196[] = "afii10196";
static const char glyph_afii10831[] = "afii10831";
static const char glyph_afii10832[] = "afii10832";
static const char glyph_afii10846[] = "afii10846";
static const char glyph_afii299[] = "afii299";
static const char glyph_afii300[] = "afii300";
static const char glyph_afii301[] = "afii301";
static const char glyph_afii57381[] = "afii57381";
static const char glyph_afii57388[] = "afii57388";
static const char glyph_afii57392[] = "afii57392";
static const char glyph_afii57393[] = "afii57393";
static const char glyph_afii57394[] = "afii57394";
static const char glyph_afii57395[] = "afii57395";
static const char glyph_afii57396[] = "afii57396";
static const char glyph_afii57397[] = "afii57397";
static const char glyph_afii57398[] = "afii57398";
static const char glyph_afii57399[] = "afii57399";
static const char glyph_afii57400[] = "afii57400";
static const char glyph_afii57401[] = "afii57401";
static const char glyph_afii57403[] = "afii57403";
static const char glyph_afii57407[] = "afii57407";
static const char glyph_afii57409[] = "afii57409";
static const char glyph_afii57410[] = "afii57410";
static const char glyph_afii57411[] = "afii57411";
static const char glyph_afii57412[] = "afii57412";
static const char glyph_afii57413[] = "afii57413";
static const char glyph_afii57414[] = "afii57414";
static const char glyph_afii57415[] = "afii57415";
static const char glyph_afii57416[] = "afii57416";
static const char glyph_afii57417[] = "afii57417";
static const char glyph_afii57418[] = "afii57418";
static const char glyph_afii57419[] = "afii57419";
static const char glyph_afii57420[] = "afii57420";
static const char glyph_afii57421[] = "afii57421";
static const char glyph_afii57422[] = "afii57422";
static const char glyph_afii57423[] = "afii57423";
static const char glyph_afii57424[] = "afii57424";
static const char glyph_afii57425[] = "afii57425";
static const char glyph_afii57426[] = "afii57426";
static const char glyph_afii57427[] = "afii57427";
static const char glyph_afii57428[] = "afii57428";
static const char glyph_afii57429[] = "afii57429";
static const char glyph_afii57430[] = "afii57430";
static const char glyph_afii57431[] = "afii57431";
static const char glyph_afii57432[] = "afii57432";
static const char glyph_afii57433[] = "afii57433";
static const char glyph_afii57434[] = "afii57434";
static const char glyph_afii57440[] = "afii57440";
static const char glyph_afii57441[] = "afii57441";
static const char glyph_afii57442[] = "afii57442";
static const char glyph_afii57443[] = "afii57443";
static const char glyph_afii57444[] = "afii57444";
static const char glyph_afii57445[] = "afii57445";
static const char glyph_afii57446[] = "afii57446";
static const char glyph_afii57448[] = "afii57448";
static const char glyph_afii57449[] = "afii57449";
static const char glyph_afii57450[] = "afii57450";
static const char glyph_afii57451[] = "afii57451";
static const char glyph_afii57452[] = "afii57452";
static const char glyph_afii57453[] = "afii57453";
static const char glyph_afii57454[] = "afii57454";
static const char glyph_afii57455[] = "afii57455";
static const char glyph_afii57456[] = "afii57456";
static const char glyph_afii57457[] = "afii57457";
static const char glyph_afii57458[] = "afii57458";
static const char glyph_afii57470[] = "afii57470";
static const char glyph_afii57505[] = "afii57505";
static const char glyph_afii57506[] = "afii57506";
static const char glyph_afii57507[] = "afii57507";
static const char glyph_afii57508[] = "afii57508";
static const char glyph_afii57509[] = "afii57509";
static const char glyph_afii57511[] = "afii57511";
static const char glyph_afii57512[] = "afii57512";
static const char glyph_afii57513[] = "afii57513";
static const char glyph_afii57514[] = "afii57514";
static const char glyph_afii57519[] = "afii57519";
static const char glyph_afii57534[] = "afii57534";
static const char glyph_afii57636[] = "afii57636";
static const char glyph_afii57645[] = "afii57645";
static const char glyph_afii57658[] = "afii57658";
static const char glyph_afii57664[] = "afii57664";
static const char glyph_afii57665[] = "afii57665";
static const char glyph_afii57666[] = "afii57666";
static const char glyph_afii57667[] = "afii57667";
static const char glyph_afii57668[] = "afii57668";
static const char glyph_afii57669[] = "afii57669";
static const char glyph_afii57670[] = "afii57670";
static const char glyph_afii57671[] = "afii57671";
static const char glyph_afii57672[] = "afii57672";
static const char glyph_afii57673[] = "afii57673";
static const char glyph_afii57674[] = "afii57674";
static const char glyph_afii57675[] = "afii57675";
static const char glyph_afii57676[] = "afii57676";
static const char glyph_afii57677[] = "afii57677";
static const char glyph_afii57678[] = "afii57678";
static const char glyph_afii57679[] = "afii57679";
static const char glyph_afii57680[] = "afii57680";
static const char glyph_afii57681[] = "afii57681";
static const char glyph_afii57682[] = "afii57682";
static const char glyph_afii57683[] = "afii57683";
static const char glyph_afii57684[] = "afii57684";
static const char glyph_afii57685[] = "afii57685";
static const char glyph_afii57686[] = "afii57686";
static const char glyph_afii57687[] = "afii57687";
static const char glyph_afii57688[] = "afii57688";
static const char glyph_afii57689[] = "afii57689";
static const char glyph_afii57690[] = "afii57690";
static const char glyph_afii57694[] = "afii57694";
static const char glyph_afii57695[] = "afii57695";
static const char glyph_afii57700[] = "afii57700";
static const char glyph_afii57705[] = "afii57705";
static const char glyph_afii57716[] = "afii57716";
static const char glyph_afii57717[] = "afii57717";
static const char glyph_afii57718[] = "afii57718";
static const char glyph_afii57723[] = "afii57723";
static const char glyph_afii57793[] = "afii57793";
static const char glyph_afii57794[] = "afii57794";
static const char glyph_afii57795[] = "afii57795";
static const char glyph_afii57796[] = "afii57796";
static const char glyph_afii57797[] = "afii57797";
static const char glyph_afii57798[] = "afii57798";
static const char glyph_afii57799[] = "afii57799";
static const char glyph_afii57800[] = "afii57800";
static const char glyph_afii57801[] = "afii57801";
static const char glyph_afii57802[] = "afii57802";
static const char glyph_afii57803[] = "afii57803";
static const char glyph_afii57804[] = "afii57804";
static const char glyph_afii57806[] = "afii57806";
static const char glyph_afii57807[] = "afii57807";
static const char glyph_afii57839[] = "afii57839";
static const char glyph_afii57841[] = "afii57841";
static const char glyph_afii57842[] = "afii57842";
static const char glyph_afii57929[] = "afii57929";
static const char glyph_afii61248[] = "afii61248";
static const char glyph_afii61289[] = "afii61289";
static const char glyph_afii61352[] = "afii61352";
static const char glyph_afii61573[] = "afii61573";
static const char glyph_afii61574[] = "afii61574";
static const char glyph_afii61575[] = "afii61575";
static const char glyph_afii61664[] = "afii61664";
static const char glyph_afii63167[] = "afii63167";
static const char glyph_afii64937[] = "afii64937";
static const char glyph_agrave[] = "agrave";
static const char glyph_agujarati[] = "agujarati";
static const char glyph_agurmukhi[] = "agurmukhi";
static const char glyph_ahiragana[] = "ahiragana";
static const char glyph_ahookabove[] = "ahookabove";
static const char glyph_aibengali[] = "aibengali";
static const char glyph_aibopomofo[] = "aibopomofo";
static const char glyph_aideva[] = "aideva";
static const char glyph_aiecyrillic[] = "aiecyrillic";
static const char glyph_aigujarati[] = "aigujarati";
static const char glyph_aigurmukhi[] = "aigurmukhi";
static const char glyph_aimatragurmukhi[] = "aimatragurmukhi";
static const char glyph_ainarabic[] = "ainarabic";
static const char glyph_ainfinalarabic[] = "ainfinalarabic";
static const char glyph_aininitialarabic[] = "aininitialarabic";
static const char glyph_ainmedialarabic[] = "ainmedialarabic";
static const char glyph_ainvertedbreve[] = "ainvertedbreve";
static const char glyph_aivowelsignbengali[] = "aivowelsignbengali";
static const char glyph_aivowelsigndeva[] = "aivowelsigndeva";
static const char glyph_aivowelsigngujarati[] = "aivowelsigngujarati";
static const char glyph_akatakana[] = "akatakana";
static const char glyph_akatakanahalfwidth[] = "akatakanahalfwidth";
static const char glyph_akorean[] = "akorean";
static const char glyph_alef[] = "alef";
static const char glyph_alefarabic[] = "alefarabic";
static const char glyph_alefdageshhebrew[] = "alefdageshhebrew";
static const char glyph_aleffinalarabic[] = "aleffinalarabic";
static const char glyph_alefhamzaabovearabic[] = "alefhamzaabovearabic";
static const char glyph_alefhamzaabovefinalarabic[] =
"alefhamzaabovefinalarabic";
static const char glyph_alefhamzabelowarabic[] = "alefhamzabelowarabic";
static const char glyph_alefhamzabelowfinalarabic[] =
"alefhamzabelowfinalarabic";
static const char glyph_alefhebrew[] = "alefhebrew";
static const char glyph_aleflamedhebrew[] = "aleflamedhebrew";
static const char glyph_alefmaddaabovearabic[] = "alefmaddaabovearabic";
static const char glyph_alefmaddaabovefinalarabic[] =
"alefmaddaabovefinalarabic";
static const char glyph_alefmaksuraarabic[] = "alefmaksuraarabic";
static const char glyph_alefmaksurafinalarabic[] = "alefmaksurafinalarabic";
static const char glyph_alefmaksurainitialarabic[] =
"alefmaksurainitialarabic";
static const char glyph_alefmaksuramedialarabic[] = "alefmaksuramedialarabic";
static const char glyph_alefpatahhebrew[] = "alefpatahhebrew";
static const char glyph_alefqamatshebrew[] = "alefqamatshebrew";
static const char glyph_aleph[] = "aleph";
static const char glyph_allequal[] = "allequal";
static const char glyph_alpha[] = "alpha";
static const char glyph_alphatonos[] = "alphatonos";
static const char glyph_amacron[] = "amacron";
static const char glyph_amonospace[] = "amonospace";
static const char glyph_ampersand[] = "ampersand";
static const char glyph_ampersandmonospace[] = "ampersandmonospace";
static const char glyph_ampersandsmall[] = "ampersandsmall";
static const char glyph_amsquare[] = "amsquare";
static const char glyph_anbopomofo[] = "anbopomofo";
static const char glyph_angbopomofo[] = "angbopomofo";
static const char glyph_angkhankhuthai[] = "angkhankhuthai";
static const char glyph_angle[] = "angle";
static const char glyph_anglebracketleft[] = "anglebracketleft";
static const char glyph_anglebracketleftvertical[] =
"anglebracketleftvertical";
static const char glyph_anglebracketright[] = "anglebracketright";
static const char glyph_anglebracketrightvertical[] =
"anglebracketrightvertical";
static const char glyph_angleleft[] = "angleleft";
static const char glyph_angleright[] = "angleright";
static const char glyph_angstrom[] = "angstrom";
static const char glyph_anoteleia[] = "anoteleia";
static const char glyph_anudattadeva[] = "anudattadeva";
static const char glyph_anusvarabengali[] = "anusvarabengali";
static const char glyph_anusvaradeva[] = "anusvaradeva";
static const char glyph_anusvaragujarati[] = "anusvaragujarati";
static const char glyph_aogonek[] = "aogonek";
static const char glyph_apaatosquare[] = "apaatosquare";
static const char glyph_aparen[] = "aparen";
static const char glyph_apostrophearmenian[] = "apostrophearmenian";
static const char glyph_apostrophemod[] = "apostrophemod";
static const char glyph_apple[] = "apple";
static const char glyph_approaches[] = "approaches";
static const char glyph_approxequal[] = "approxequal";
static const char glyph_approxequalorimage[] = "approxequalorimage";
static const char glyph_approximatelyequal[] = "approximatelyequal";
static const char glyph_araeaekorean[] = "araeaekorean";
static const char glyph_araeakorean[] = "araeakorean";
static const char glyph_arc[] = "arc";
static const char glyph_arighthalfring[] = "arighthalfring";
static const char glyph_aring[] = "aring";
static const char glyph_aringacute[] = "aringacute";
static const char glyph_aringbelow[] = "aringbelow";
static const char glyph_arrowboth[] = "arrowboth";
static const char glyph_arrowdashdown[] = "arrowdashdown";
static const char glyph_arrowdashleft[] = "arrowdashleft";
static const char glyph_arrowdashright[] = "arrowdashright";
static const char glyph_arrowdashup[] = "arrowdashup";
static const char glyph_arrowdblboth[] = "arrowdblboth";
static const char glyph_arrowdbldown[] = "arrowdbldown";
static const char glyph_arrowdblleft[] = "arrowdblleft";
static const char glyph_arrowdblright[] = "arrowdblright";
static const char glyph_arrowdblup[] = "arrowdblup";
static const char glyph_arrowdown[] = "arrowdown";
static const char glyph_arrowdownleft[] = "arrowdownleft";
static const char glyph_arrowdownright[] = "arrowdownright";
static const char glyph_arrowdownwhite[] = "arrowdownwhite";
static const char glyph_arrowheaddownmod[] = "arrowheaddownmod";
static const char glyph_arrowheadleftmod[] = "arrowheadleftmod";
static const char glyph_arrowheadrightmod[] = "arrowheadrightmod";
static const char glyph_arrowheadupmod[] = "arrowheadupmod";
static const char glyph_arrowhorizex[] = "arrowhorizex";
static const char glyph_arrowleft[] = "arrowleft";
static const char glyph_arrowleftdbl[] = "arrowleftdbl";
static const char glyph_arrowleftdblstroke[] = "arrowleftdblstroke";
static const char glyph_arrowleftoverright[] = "arrowleftoverright";
static const char glyph_arrowleftwhite[] = "arrowleftwhite";
static const char glyph_arrowright[] = "arrowright";
static const char glyph_arrowrightdblstroke[] = "arrowrightdblstroke";
static const char glyph_arrowrightheavy[] = "arrowrightheavy";
static const char glyph_arrowrightoverleft[] = "arrowrightoverleft";
static const char glyph_arrowrightwhite[] = "arrowrightwhite";
static const char glyph_arrowtableft[] = "arrowtableft";
static const char glyph_arrowtabright[] = "arrowtabright";
static const char glyph_arrowup[] = "arrowup";
static const char glyph_arrowupdn[] = "arrowupdn";
static const char glyph_arrowupdnbse[] = "arrowupdnbse";
static const char glyph_arrowupdownbase[] = "arrowupdownbase";
static const char glyph_arrowupleft[] = "arrowupleft";
static const char glyph_arrowupleftofdown[] = "arrowupleftofdown";
static const char glyph_arrowupright[] = "arrowupright";
static const char glyph_arrowupwhite[] = "arrowupwhite";
static const char glyph_arrowvertex[] = "arrowvertex";
static const char glyph_asciicircum[] = "asciicircum";
static const char glyph_asciicircummonospace[] = "asciicircummonospace";
static const char glyph_asciitilde[] = "asciitilde";
static const char glyph_asciitildemonospace[] = "asciitildemonospace";
static const char glyph_ascript[] = "ascript";
static const char glyph_ascriptturned[] = "ascriptturned";
static const char glyph_asmallhiragana[] = "asmallhiragana";
static const char glyph_asmallkatakana[] = "asmallkatakana";
static const char glyph_asmallkatakanahalfwidth[] = "asmallkatakanahalfwidth";
static const char glyph_asterisk[] = "asterisk";
static const char glyph_asteriskaltonearabic[] = "asteriskaltonearabic";
static const char glyph_asteriskarabic[] = "asteriskarabic";
static const char glyph_asteriskmath[] = "asteriskmath";
static const char glyph_asteriskmonospace[] = "asteriskmonospace";
static const char glyph_asterisksmall[] = "asterisksmall";
static const char glyph_asterism[] = "asterism";
static const char glyph_asuperior[] = "asuperior";
static const char glyph_asymptoticallyequal[] = "asymptoticallyequal";
static const char glyph_at[] = "at";
static const char glyph_atilde[] = "atilde";
static const char glyph_atmonospace[] = "atmonospace";
static const char glyph_atsmall[] = "atsmall";
static const char glyph_aturned[] = "aturned";
static const char glyph_aubengali[] = "aubengali";
static const char glyph_aubopomofo[] = "aubopomofo";
static const char glyph_audeva[] = "audeva";
static const char glyph_augujarati[] = "augujarati";
static const char glyph_augurmukhi[] = "augurmukhi";
static const char glyph_aulengthmarkbengali[] = "aulengthmarkbengali";
static const char glyph_aumatragurmukhi[] = "aumatragurmukhi";
static const char glyph_auvowelsignbengali[] = "auvowelsignbengali";
static const char glyph_auvowelsigndeva[] = "auvowelsigndeva";
static const char glyph_auvowelsigngujarati[] = "auvowelsigngujarati";
static const char glyph_avagrahadeva[] = "avagrahadeva";
static const char glyph_aybarmenian[] = "aybarmenian";
static const char glyph_ayin[] = "ayin";
static const char glyph_ayinaltonehebrew[] = "ayinaltonehebrew";
static const char glyph_ayinhebrew[] = "ayinhebrew";
static const char glyph_b[] = "b";
static const char glyph_babengali[] = "babengali";
static const char glyph_backslash[] = "backslash";
static const char glyph_backslashmonospace[] = "backslashmonospace";
static const char glyph_badeva[] = "badeva";
static const char glyph_bagujarati[] = "bagujarati";
static const char glyph_bagurmukhi[] = "bagurmukhi";
static const char glyph_bahiragana[] = "bahiragana";
static const char glyph_bahtthai[] = "bahtthai";
static const char glyph_bakatakana[] = "bakatakana";
static const char glyph_bar[] = "bar";
static const char glyph_barmonospace[] = "barmonospace";
static const char glyph_bbopomofo[] = "bbopomofo";
static const char glyph_bcircle[] = "bcircle";
static const char glyph_bdotaccent[] = "bdotaccent";
static const char glyph_bdotbelow[] = "bdotbelow";
static const char glyph_beamedsixteenthnotes[] = "beamedsixteenthnotes";
static const char glyph_because[] = "because";
static const char glyph_becyrillic[] = "becyrillic";
static const char glyph_beharabic[] = "beharabic";
static const char glyph_behfinalarabic[] = "behfinalarabic";
static const char glyph_behinitialarabic[] = "behinitialarabic";
static const char glyph_behiragana[] = "behiragana";
static const char glyph_behmedialarabic[] = "behmedialarabic";
static const char glyph_behmeeminitialarabic[] = "behmeeminitialarabic";
static const char glyph_behmeemisolatedarabic[] = "behmeemisolatedarabic";
static const char glyph_behnoonfinalarabic[] = "behnoonfinalarabic";
static const char glyph_bekatakana[] = "bekatakana";
static const char glyph_benarmenian[] = "benarmenian";
static const char glyph_bet[] = "bet";
static const char glyph_beta[] = "beta";
static const char glyph_betasymbolgreek[] = "betasymbolgreek";
static const char glyph_betdagesh[] = "betdagesh";
static const char glyph_betdageshhebrew[] = "betdageshhebrew";
static const char glyph_bethebrew[] = "bethebrew";
static const char glyph_betrafehebrew[] = "betrafehebrew";
static const char glyph_bhabengali[] = "bhabengali";
static const char glyph_bhadeva[] = "bhadeva";
static const char glyph_bhagujarati[] = "bhagujarati";
static const char glyph_bhagurmukhi[] = "bhagurmukhi";
static const char glyph_bhook[] = "bhook";
static const char glyph_bihiragana[] = "bihiragana";
static const char glyph_bikatakana[] = "bikatakana";
static const char glyph_bilabialclick[] = "bilabialclick";
static const char glyph_bindigurmukhi[] = "bindigurmukhi";
static const char glyph_birusquare[] = "birusquare";
static const char glyph_blackcircle[] = "blackcircle";
static const char glyph_blackdiamond[] = "blackdiamond";
static const char glyph_blackdownpointingtriangle[] =
"blackdownpointingtriangle";
static const char glyph_blackleftpointingpointer[] =
"blackleftpointingpointer";
static const char glyph_blackleftpointingtriangle[] =
"blackleftpointingtriangle";
static const char glyph_blacklenticularbracketleft[] =
"blacklenticularbracketleft";
static const char glyph_blacklenticularbracketleftvertical[] =
"blacklenticularbracketleftvertical";
static const char glyph_blacklenticularbracketright[] =
"blacklenticularbracketright";
static const char glyph_blacklenticularbracketrightvertical[] =
"blacklenticularbracketrightvertical";
static const char glyph_blacklowerlefttriangle[] =
"blacklowerlefttriangle";
static const char glyph_blacklowerrighttriangle[] = "blacklowerrighttriangle";
static const char glyph_blackrectangle[] = "blackrectangle";
static const char glyph_blackrightpointingpointer[] =
"blackrightpointingpointer";
static const char glyph_blackrightpointingtriangle[] =
"blackrightpointingtriangle";
static const char glyph_blacksmallsquare[] = "blacksmallsquare";
static const char glyph_blacksmilingface[] = "blacksmilingface";
static const char glyph_blacksquare[] = "blacksquare";
static const char glyph_blackstar[] = "blackstar";
static const char glyph_blackupperlefttriangle[] = "blackupperlefttriangle";
static const char glyph_blackupperrighttriangle[] = "blackupperrighttriangle";
static const char glyph_blackuppointingsmalltriangle[] =
"blackuppointingsmalltriangle";
static const char glyph_blackuppointingtriangle[] = "blackuppointingtriangle";
static const char glyph_blank[] = "blank";
static const char glyph_blinebelow[] = "blinebelow";
static const char glyph_block[] = "block";
static const char glyph_bmonospace[] = "bmonospace";
static const char glyph_bobaimaithai[] = "bobaimaithai";
static const char glyph_bohiragana[] = "bohiragana";
static const char glyph_bokatakana[] = "bokatakana";
static const char glyph_bparen[] = "bparen";
static const char glyph_bqsquare[] = "bqsquare";
static const char glyph_braceex[] = "braceex";
static const char glyph_braceleft[] = "braceleft";
static const char glyph_braceleftbt[] = "braceleftbt";
static const char glyph_braceleftmid[] = "braceleftmid";
static const char glyph_braceleftmonospace[] = "braceleftmonospace";
static const char glyph_braceleftsmall[] = "braceleftsmall";
static const char glyph_bracelefttp[] = "bracelefttp";
static const char glyph_braceleftvertical[] = "braceleftvertical";
static const char glyph_braceright[] = "braceright";
static const char glyph_bracerightbt[] = "bracerightbt";
static const char glyph_bracerightmid[] = "bracerightmid";
static const char glyph_bracerightmonospace[] = "bracerightmonospace";
static const char glyph_bracerightsmall[] = "bracerightsmall";
static const char glyph_bracerighttp[] = "bracerighttp";
static const char glyph_bracerightvertical[] = "bracerightvertical";
static const char glyph_bracketleft[] = "bracketleft";
static const char glyph_bracketleftbt[] = "bracketleftbt";
static const char glyph_bracketleftex[] = "bracketleftex";
static const char glyph_bracketleftmonospace[] = "bracketleftmonospace";
static const char glyph_bracketlefttp[] = "bracketlefttp";
static const char glyph_bracketright[] = "bracketright";
static const char glyph_bracketrightbt[] = "bracketrightbt";
static const char glyph_bracketrightex[] = "bracketrightex";
static const char glyph_bracketrightmonospace[] = "bracketrightmonospace";
static const char glyph_bracketrighttp[] = "bracketrighttp";
static const char glyph_breve[] = "breve";
static const char glyph_brevebelowcmb[] = "brevebelowcmb";
static const char glyph_brevecmb[] = "brevecmb";
static const char glyph_breveinvertedbelowcmb[] = "breveinvertedbelowcmb";
static const char glyph_breveinvertedcmb[] = "breveinvertedcmb";
static const char glyph_breveinverteddoublecmb[] = "breveinverteddoublecmb";
static const char glyph_bridgebelowcmb[] = "bridgebelowcmb";
static const char glyph_bridgeinvertedbelowcmb[] = "bridgeinvertedbelowcmb";
static const char glyph_brokenbar[] = "brokenbar";
static const char glyph_bstroke[] = "bstroke";
static const char glyph_bsuperior[] = "bsuperior";
static const char glyph_btopbar[] = "btopbar";
static const char glyph_buhiragana[] = "buhiragana";
static const char glyph_bukatakana[] = "bukatakana";
static const char glyph_bullet[] = "bullet";
static const char glyph_bulletinverse[] = "bulletinverse";
static const char glyph_bulletoperator[] = "bulletoperator";
static const char glyph_bullseye[] = "bullseye";
static const char glyph_c[] = "c";
static const char glyph_caarmenian[] = "caarmenian";
static const char glyph_cabengali[] = "cabengali";
static const char glyph_cacute[] = "cacute";
static const char glyph_cadeva[] = "cadeva";
static const char glyph_cagujarati[] = "cagujarati";
static const char glyph_cagurmukhi[] = "cagurmukhi";
static const char glyph_calsquare[] = "calsquare";
static const char glyph_candrabindubengali[] = "candrabindubengali";
static const char glyph_candrabinducmb[] = "candrabinducmb";
static const char glyph_candrabindudeva[] = "candrabindudeva";
static const char glyph_candrabindugujarati[] = "candrabindugujarati";
static const char glyph_capslock[] = "capslock";
static const char glyph_careof[] = "careof";
static const char glyph_caron[] = "caron";
static const char glyph_caronbelowcmb[] = "caronbelowcmb";
static const char glyph_caroncmb[] = "caroncmb";
static const char glyph_carriagereturn[] = "carriagereturn";
static const char glyph_cbopomofo[] = "cbopomofo";
static const char glyph_ccaron[] = "ccaron";
static const char glyph_ccedilla[] = "ccedilla";
static const char glyph_ccedillaacute[] = "ccedillaacute";
static const char glyph_ccircle[] = "ccircle";
static const char glyph_ccircumflex[] = "ccircumflex";
static const char glyph_ccurl[] = "ccurl";
static const char glyph_cdot[] = "cdot";
static const char glyph_cdotaccent[] = "cdotaccent";
static const char glyph_cdsquare[] = "cdsquare";
static const char glyph_cedilla[] = "cedilla";
static const char glyph_cedillacmb[] = "cedillacmb";
static const char glyph_cent[] = "cent";
static const char glyph_centigrade[] = "centigrade";
static const char glyph_centinferior[] = "centinferior";
static const char glyph_centmonospace[] = "centmonospace";
static const char glyph_centoldstyle[] = "centoldstyle";
static const char glyph_centsuperior[] = "centsuperior";
static const char glyph_chaarmenian[] = "chaarmenian";
static const char glyph_chabengali[] = "chabengali";
static const char glyph_chadeva[] = "chadeva";
static const char glyph_chagujarati[] = "chagujarati";
static const char glyph_chagurmukhi[] = "chagurmukhi";
static const char glyph_chbopomofo[] = "chbopomofo";
static const char glyph_cheabkhasiancyrillic[] = "cheabkhasiancyrillic";
static const char glyph_checkmark[] = "checkmark";
static const char glyph_checyrillic[] = "checyrillic";
static const char glyph_chedescenderabkhasiancyrillic[] =
"chedescenderabkhasiancyrillic";
static const char glyph_chedescendercyrillic[] = "chedescendercyrillic";
static const char glyph_chedieresiscyrillic[] = "chedieresiscyrillic";
static const char glyph_cheharmenian[] = "cheharmenian";
static const char glyph_chekhakassiancyrillic[] = "chekhakassiancyrillic";
static const char glyph_cheverticalstrokecyrillic[] =
"cheverticalstrokecyrillic";
static const char glyph_chi[] = "chi";
static const char glyph_chieuchacirclekorean[] = "chieuchacirclekorean";
static const char glyph_chieuchaparenkorean[] = "chieuchaparenkorean";
static const char glyph_chieuchcirclekorean[] = "chieuchcirclekorean";
static const char glyph_chieuchkorean[] = "chieuchkorean";
static const char glyph_chieuchparenkorean[] = "chieuchparenkorean";
static const char glyph_chochangthai[] = "chochangthai";
static const char glyph_chochanthai[] = "chochanthai";
static const char glyph_chochingthai[] = "chochingthai";
static const char glyph_chochoethai[] = "chochoethai";
static const char glyph_chook[] = "chook";
static const char glyph_cieucacirclekorean[] = "cieucacirclekorean";
static const char glyph_cieucaparenkorean[] = "cieucaparenkorean";
static const char glyph_cieuccirclekorean[] = "cieuccirclekorean";
static const char glyph_cieuckorean[] = "cieuckorean";
static const char glyph_cieucparenkorean[] = "cieucparenkorean";
static const char glyph_cieucuparenkorean[] = "cieucuparenkorean";
static const char glyph_circle[] = "circle";
static const char glyph_circlemultiply[] = "circlemultiply";
static const char glyph_circleot[] = "circleot";
static const char glyph_circleplus[] = "circleplus";
static const char glyph_circlepostalmark[] = "circlepostalmark";
static const char glyph_circlewithlefthalfblack[] = "circlewithlefthalfblack";
static const char glyph_circlewithrighthalfblack[] =
"circlewithrighthalfblack";
static const char glyph_circumflex[] = "circumflex";
static const char glyph_circumflexbelowcmb[] = "circumflexbelowcmb";
static const char glyph_circumflexcmb[] = "circumflexcmb";
static const char glyph_clear[] = "clear";
static const char glyph_clickalveolar[] = "clickalveolar";
static const char glyph_clickdental[] = "clickdental";
static const char glyph_clicklateral[] = "clicklateral";
static const char glyph_clickretroflex[] = "clickretroflex";
static const char glyph_club[] = "club";
static const char glyph_clubsuitblack[] = "clubsuitblack";
static const char glyph_clubsuitwhite[] = "clubsuitwhite";
static const char glyph_cmcubedsquare[] = "cmcubedsquare";
static const char glyph_cmonospace[] = "cmonospace";
static const char glyph_cmsquaredsquare[] = "cmsquaredsquare";
static const char glyph_coarmenian[] = "coarmenian";
static const char glyph_colon[] = "colon";
static const char glyph_colonmonetary[] = "colonmonetary";
static const char glyph_colonmonospace[] = "colonmonospace";
static const char glyph_colonsign[] = "colonsign";
static const char glyph_colonsmall[] = "colonsmall";
static const char glyph_colontriangularhalfmod[] = "colontriangularhalfmod";
static const char glyph_colontriangularmod[] = "colontriangularmod";
static const char glyph_comma[] = "comma";
static const char glyph_commaabovecmb[] = "commaabovecmb";
static const char glyph_commaaboverightcmb[] = "commaaboverightcmb";
static const char glyph_commaaccent[] = "commaaccent";
static const char glyph_commaarabic[] = "commaarabic";
static const char glyph_commaarmenian[] = "commaarmenian";
static const char glyph_commainferior[] = "commainferior";
static const char glyph_commamonospace[] = "commamonospace";
static const char glyph_commareversedabovecmb[] = "commareversedabovecmb";
static const char glyph_commareversedmod[] = "commareversedmod";
static const char glyph_commasmall[] = "commasmall";
static const char glyph_commasuperior[] = "commasuperior";
static const char glyph_commaturnedabovecmb[] = "commaturnedabovecmb";
static const char glyph_commaturnedmod[] = "commaturnedmod";
static const char glyph_compass[] = "compass";
static const char glyph_congruent[] = "congruent";
static const char glyph_contourintegral[] = "contourintegral";
static const char glyph_control[] = "control";
static const char glyph_controlACK[] = "controlACK";
static const char glyph_controlBEL[] = "controlBEL";
static const char glyph_controlBS[] = "controlBS";
static const char glyph_controlCAN[] = "controlCAN";
static const char glyph_controlCR[] = "controlCR";
static const char glyph_controlDC1[] = "controlDC1";
static const char glyph_controlDC2[] = "controlDC2";
static const char glyph_controlDC3[] = "controlDC3";
static const char glyph_controlDC4[] = "controlDC4";
static const char glyph_controlDEL[] = "controlDEL";
static const char glyph_controlDLE[] = "controlDLE";
static const char glyph_controlEM[] = "controlEM";
static const char glyph_controlENQ[] = "controlENQ";
static const char glyph_controlEOT[] = "controlEOT";
static const char glyph_controlESC[] = "controlESC";
static const char glyph_controlETB[] = "controlETB";
static const char glyph_controlETX[] = "controlETX";
static const char glyph_controlFF[] = "controlFF";
static const char glyph_controlFS[] = "controlFS";
static const char glyph_controlGS[] = "controlGS";
static const char glyph_controlHT[] = "controlHT";
static const char glyph_controlLF[] = "controlLF";
static const char glyph_controlNAK[] = "controlNAK";
static const char glyph_controlRS[] = "controlRS";
static const char glyph_controlSI[] = "controlSI";
static const char glyph_controlSO[] = "controlSO";
static const char glyph_controlSOT[] = "controlSOT";
static const char glyph_controlSTX[] = "controlSTX";
static const char glyph_controlSUB[] = "controlSUB";
static const char glyph_controlSYN[] = "controlSYN";
static const char glyph_controlUS[] = "controlUS";
static const char glyph_controlVT[] = "controlVT";
static const char glyph_copyright[] = "copyright";
static const char glyph_copyrightsans[] = "copyrightsans";
static const char glyph_copyrightserif[] = "copyrightserif";
static const char glyph_cornerbracketleft[] = "cornerbracketleft";
static const char glyph_cornerbracketlefthalfwidth[] =
"cornerbracketlefthalfwidth";
static const char glyph_cornerbracketleftvertical[] =
"cornerbracketleftvertical";
static const char glyph_cornerbracketright[] = "cornerbracketright";
static const char glyph_cornerbracketrighthalfwidth[] =
"cornerbracketrighthalfwidth";
static const char glyph_cornerbracketrightvertical[] =
"cornerbracketrightvertical";
static const char glyph_corporationsquare[] = "corporationsquare";
static const char glyph_cosquare[] = "cosquare";
static const char glyph_coverkgsquare[] = "coverkgsquare";
static const char glyph_cparen[] = "cparen";
static const char glyph_cruzeiro[] = "cruzeiro";
static const char glyph_cstretched[] = "cstretched";
static const char glyph_curlyand[] = "curlyand";
static const char glyph_curlyor[] = "curlyor";
static const char glyph_currency[] = "currency";
static const char glyph_cyrBreve[] = "cyrBreve";
static const char glyph_cyrFlex[] = "cyrFlex";
static const char glyph_cyrbreve[] = "cyrbreve";
static const char glyph_cyrflex[] = "cyrflex";
static const char glyph_d[] = "d";
static const char glyph_daarmenian[] = "daarmenian";
static const char glyph_dabengali[] = "dabengali";
static const char glyph_dadarabic[] = "dadarabic";
static const char glyph_dadeva[] = "dadeva";
static const char glyph_dadfinalarabic[] = "dadfinalarabic";
static const char glyph_dadinitialarabic[] = "dadinitialarabic";
static const char glyph_dadmedialarabic[] = "dadmedialarabic";
static const char glyph_dagesh[] = "dagesh";
static const char glyph_dageshhebrew[] = "dageshhebrew";
static const char glyph_dagger[] = "dagger";
static const char glyph_daggerdbl[] = "daggerdbl";
static const char glyph_dagujarati[] = "dagujarati";
static const char glyph_dagurmukhi[] = "dagurmukhi";
static const char glyph_dahiragana[] = "dahiragana";
static const char glyph_dakatakana[] = "dakatakana";
static const char glyph_dalarabic[] = "dalarabic";
static const char glyph_dalet[] = "dalet";
static const char glyph_daletdagesh[] = "daletdagesh";
static const char glyph_daletdageshhebrew[] = "daletdageshhebrew";
static const char glyph_dalethatafpatah[] = "dalethatafpatah";
static const char glyph_dalethatafpatahhebrew[] = "dalethatafpatahhebrew";
static const char glyph_dalethatafsegol[] = "dalethatafsegol";
static const char glyph_dalethatafsegolhebrew[] = "dalethatafsegolhebrew";
static const char glyph_dalethebrew[] = "dalethebrew";
static const char glyph_dalethiriq[] = "dalethiriq";
static const char glyph_dalethiriqhebrew[] = "dalethiriqhebrew";
static const char glyph_daletholam[] = "daletholam";
static const char glyph_daletholamhebrew[] = "daletholamhebrew";
static const char glyph_daletpatah[] = "daletpatah";
static const char glyph_daletpatahhebrew[] = "daletpatahhebrew";
static const char glyph_daletqamats[] = "daletqamats";
static const char glyph_daletqamatshebrew[] = "daletqamatshebrew";
static const char glyph_daletqubuts[] = "daletqubuts";
static const char glyph_daletqubutshebrew[] = "daletqubutshebrew";
static const char glyph_daletsegol[] = "daletsegol";
static const char glyph_daletsegolhebrew[] = "daletsegolhebrew";
static const char glyph_daletsheva[] = "daletsheva";
static const char glyph_daletshevahebrew[] = "daletshevahebrew";
static const char glyph_dalettsere[] = "dalettsere";
static const char glyph_dalettserehebrew[] = "dalettserehebrew";
static const char glyph_dalfinalarabic[] = "dalfinalarabic";
static const char glyph_dammaarabic[] = "dammaarabic";
static const char glyph_dammalowarabic[] = "dammalowarabic";
static const char glyph_dammatanaltonearabic[] = "dammatanaltonearabic";
static const char glyph_dammatanarabic[] = "dammatanarabic";
static const char glyph_danda[] = "danda";
static const char glyph_dargahebrew[] = "dargahebrew";
static const char glyph_dargalefthebrew[] = "dargalefthebrew";
static const char glyph_dasiapneumatacyrilliccmb[] =
"dasiapneumatacyrilliccmb";
static const char glyph_dblGrave[] = "dblGrave";
static const char glyph_dblanglebracketleft[] = "dblanglebracketleft";
static const char glyph_dblanglebracketleftvertical[] =
"dblanglebracketleftvertical";
static const char glyph_dblanglebracketright[] = "dblanglebracketright";
static const char glyph_dblanglebracketrightvertical[] =
"dblanglebracketrightvertical";
static const char glyph_dblarchinvertedbelowcmb[] = "dblarchinvertedbelowcmb";
static const char glyph_dblarrowleft[] = "dblarrowleft";
static const char glyph_dblarrowright[] = "dblarrowright";
static const char glyph_dbldanda[] = "dbldanda";
static const char glyph_dblgrave[] = "dblgrave";
static const char glyph_dblgravecmb[] = "dblgravecmb";
static const char glyph_dblintegral[] = "dblintegral";
static const char glyph_dbllowline[] = "dbllowline";
static const char glyph_dbllowlinecmb[] = "dbllowlinecmb";
static const char glyph_dbloverlinecmb[] = "dbloverlinecmb";
static const char glyph_dblprimemod[] = "dblprimemod";
static const char glyph_dblverticalbar[] = "dblverticalbar";
static const char glyph_dblverticallineabovecmb[] = "dblverticallineabovecmb";
static const char glyph_dbopomofo[] = "dbopomofo";
static const char glyph_dbsquare[] = "dbsquare";
static const char glyph_dcaron[] = "dcaron";
static const char glyph_dcedilla[] = "dcedilla";
static const char glyph_dcircle[] = "dcircle";
static const char glyph_dcircumflexbelow[] = "dcircumflexbelow";
static const char glyph_dcroat[] = "dcroat";
static const char glyph_ddabengali[] = "ddabengali";
static const char glyph_ddadeva[] = "ddadeva";
static const char glyph_ddagujarati[] = "ddagujarati";
static const char glyph_ddagurmukhi[] = "ddagurmukhi";
static const char glyph_ddalarabic[] = "ddalarabic";
static const char glyph_ddalfinalarabic[] = "ddalfinalarabic";
static const char glyph_dddhadeva[] = "dddhadeva";
static const char glyph_ddhabengali[] = "ddhabengali";
static const char glyph_ddhadeva[] = "ddhadeva";
static const char glyph_ddhagujarati[] = "ddhagujarati";
static const char glyph_ddhagurmukhi[] = "ddhagurmukhi";
static const char glyph_ddotaccent[] = "ddotaccent";
static const char glyph_ddotbelow[] = "ddotbelow";
static const char glyph_decimalseparatorarabic[] = "decimalseparatorarabic";
static const char glyph_decimalseparatorpersian[] = "decimalseparatorpersian";
static const char glyph_decyrillic[] = "decyrillic";
static const char glyph_degree[] = "degree";
static const char glyph_dehihebrew[] = "dehihebrew";
static const char glyph_dehiragana[] = "dehiragana";
static const char glyph_deicoptic[] = "deicoptic";
static const char glyph_dekatakana[] = "dekatakana";
static const char glyph_deleteleft[] = "deleteleft";
static const char glyph_deleteright[] = "deleteright";
static const char glyph_delta[] = "delta";
static const char glyph_deltaturned[] = "deltaturned";
static const char glyph_denominatorminusonenumeratorbengali[] =
"denominatorminusonenumeratorbengali";
static const char glyph_dezh[] = "dezh";
static const char glyph_dhabengali[] = "dhabengali";
static const char glyph_dhadeva[] = "dhadeva";
static const char glyph_dhagujarati[] = "dhagujarati";
static const char glyph_dhagurmukhi[] = "dhagurmukhi";
static const char glyph_dhook[] = "dhook";
static const char glyph_dialytikatonos[] = "dialytikatonos";
static const char glyph_dialytikatonoscmb[] = "dialytikatonoscmb";
static const char glyph_diamond[] = "diamond";
static const char glyph_diamondsuitwhite[] = "diamondsuitwhite";
static const char glyph_dieresis[] = "dieresis";
static const char glyph_dieresisacute[] = "dieresisacute";
static const char glyph_dieresisbelowcmb[] = "dieresisbelowcmb";
static const char glyph_dieresiscmb[] = "dieresiscmb";
static const char glyph_dieresisgrave[] = "dieresisgrave";
static const char glyph_dieresistonos[] = "dieresistonos";
static const char glyph_dihiragana[] = "dihiragana";
static const char glyph_dikatakana[] = "dikatakana";
static const char glyph_dittomark[] = "dittomark";
static const char glyph_divide[] = "divide";
static const char glyph_divides[] = "divides";
static const char glyph_divisionslash[] = "divisionslash";
static const char glyph_djecyrillic[] = "djecyrillic";
static const char glyph_dkshade[] = "dkshade";
static const char glyph_dlinebelow[] = "dlinebelow";
static const char glyph_dlsquare[] = "dlsquare";
static const char glyph_dmacron[] = "dmacron";
static const char glyph_dmonospace[] = "dmonospace";
static const char glyph_dnblock[] = "dnblock";
static const char glyph_dochadathai[] = "dochadathai";
static const char glyph_dodekthai[] = "dodekthai";
static const char glyph_dohiragana[] = "dohiragana";
static const char glyph_dokatakana[] = "dokatakana";
static const char glyph_dollar[] = "dollar";
static const char glyph_dollarinferior[] = "dollarinferior";
static const char glyph_dollarmonospace[] = "dollarmonospace";
static const char glyph_dollaroldstyle[] = "dollaroldstyle";
static const char glyph_dollarsmall[] = "dollarsmall";
static const char glyph_dollarsuperior[] = "dollarsuperior";
static const char glyph_dong[] = "dong";
static const char glyph_dorusquare[] = "dorusquare";
static const char glyph_dotaccent[] = "dotaccent";
static const char glyph_dotaccentcmb[] = "dotaccentcmb";
static const char glyph_dotbelowcmb[] = "dotbelowcmb";
static const char glyph_dotbelowcomb[] = "dotbelowcomb";
static const char glyph_dotkatakana[] = "dotkatakana";
static const char glyph_dotlessi[] = "dotlessi";
static const char glyph_dotlessj[] = "dotlessj";
static const char glyph_dotlessjstrokehook[] = "dotlessjstrokehook";
static const char glyph_dotmath[] = "dotmath";
static const char glyph_dottedcircle[] = "dottedcircle";
static const char glyph_doubleyodpatah[] = "doubleyodpatah";
static const char glyph_doubleyodpatahhebrew[] = "doubleyodpatahhebrew";
static const char glyph_downtackbelowcmb[] = "downtackbelowcmb";
static const char glyph_downtackmod[] = "downtackmod";
static const char glyph_dparen[] = "dparen";
static const char glyph_dsuperior[] = "dsuperior";
static const char glyph_dtail[] = "dtail";
static const char glyph_dtopbar[] = "dtopbar";
static const char glyph_duhiragana[] = "duhiragana";
static const char glyph_dukatakana[] = "dukatakana";
static const char glyph_dz[] = "dz";
static const char glyph_dzaltone[] = "dzaltone";
static const char glyph_dzcaron[] = "dzcaron";
static const char glyph_dzcurl[] = "dzcurl";
static const char glyph_dzeabkhasiancyrillic[] = "dzeabkhasiancyrillic";
static const char glyph_dzecyrillic[] = "dzecyrillic";
static const char glyph_dzhecyrillic[] = "dzhecyrillic";
static const char glyph_e[] = "e";
static const char glyph_eacute[] = "eacute";
static const char glyph_earth[] = "earth";
static const char glyph_ebengali[] = "ebengali";
static const char glyph_ebopomofo[] = "ebopomofo";
static const char glyph_ebreve[] = "ebreve";
static const char glyph_ecandradeva[] = "ecandradeva";
static const char glyph_ecandragujarati[] = "ecandragujarati";
static const char glyph_ecandravowelsigndeva[] = "ecandravowelsigndeva";
static const char glyph_ecandravowelsigngujarati[] =
"ecandravowelsigngujarati";
static const char glyph_ecaron[] = "ecaron";
static const char glyph_ecedillabreve[] = "ecedillabreve";
static const char glyph_echarmenian[] = "echarmenian";
static const char glyph_echyiwnarmenian[] = "echyiwnarmenian";
static const char glyph_ecircle[] = "ecircle";
static const char glyph_ecircumflex[] = "ecircumflex";
static const char glyph_ecircumflexacute[] = "ecircumflexacute";
static const char glyph_ecircumflexbelow[] = "ecircumflexbelow";
static const char glyph_ecircumflexdotbelow[] = "ecircumflexdotbelow";
static const char glyph_ecircumflexgrave[] = "ecircumflexgrave";
static const char glyph_ecircumflexhookabove[] = "ecircumflexhookabove";
static const char glyph_ecircumflextilde[] = "ecircumflextilde";
static const char glyph_ecyrillic[] = "ecyrillic";
static const char glyph_edblgrave[] = "edblgrave";
static const char glyph_edeva[] = "edeva";
static const char glyph_edieresis[] = "edieresis";
static const char glyph_edot[] = "edot";
static const char glyph_edotaccent[] = "edotaccent";
static const char glyph_edotbelow[] = "edotbelow";
static const char glyph_eegurmukhi[] = "eegurmukhi";
static const char glyph_eematragurmukhi[] = "eematragurmukhi";
static const char glyph_efcyrillic[] = "efcyrillic";
static const char glyph_egrave[] = "egrave";
static const char glyph_egujarati[] = "egujarati";
static const char glyph_eharmenian[] = "eharmenian";
static const char glyph_ehbopomofo[] = "ehbopomofo";
static const char glyph_ehiragana[] = "ehiragana";
static const char glyph_ehookabove[] = "ehookabove";
static const char glyph_eibopomofo[] = "eibopomofo";
static const char glyph_eight[] = "eight";
static const char glyph_eightarabic[] = "eightarabic";
static const char glyph_eightbengali[] = "eightbengali";
static const char glyph_eightcircle[] = "eightcircle";
static const char glyph_eightcircleinversesansserif[] =
"eightcircleinversesansserif";
static const char glyph_eightdeva[] = "eightdeva";
static const char glyph_eighteencircle[] = "eighteencircle";
static const char glyph_eighteenparen[] = "eighteenparen";
static const char glyph_eighteenperiod[] = "eighteenperiod";
static const char glyph_eightgujarati[] = "eightgujarati";
static const char glyph_eightgurmukhi[] = "eightgurmukhi";
static const char glyph_eighthackarabic[] = "eighthackarabic";
static const char glyph_eighthangzhou[] = "eighthangzhou";
static const char glyph_eighthnotebeamed[] = "eighthnotebeamed";
static const char glyph_eightideographicparen[] = "eightideographicparen";
static const char glyph_eightinferior[] = "eightinferior";
static const char glyph_eightmonospace[] = "eightmonospace";
static const char glyph_eightoldstyle[] = "eightoldstyle";
static const char glyph_eightparen[] = "eightparen";
static const char glyph_eightperiod[] = "eightperiod";
static const char glyph_eightpersian[] = "eightpersian";
static const char glyph_eightroman[] = "eightroman";
static const char glyph_eightsuperior[] = "eightsuperior";
static const char glyph_eightthai[] = "eightthai";
static const char glyph_einvertedbreve[] = "einvertedbreve";
static const char glyph_eiotifiedcyrillic[] = "eiotifiedcyrillic";
static const char glyph_ekatakana[] = "ekatakana";
static const char glyph_ekatakanahalfwidth[] = "ekatakanahalfwidth";
static const char glyph_ekonkargurmukhi[] = "ekonkargurmukhi";
static const char glyph_ekorean[] = "ekorean";
static const char glyph_elcyrillic[] = "elcyrillic";
static const char glyph_element[] = "element";
static const char glyph_elevencircle[] = "elevencircle";
static const char glyph_elevenparen[] = "elevenparen";
static const char glyph_elevenperiod[] = "elevenperiod";
static const char glyph_elevenroman[] = "elevenroman";
static const char glyph_ellipsis[] = "ellipsis";
static const char glyph_ellipsisvertical[] = "ellipsisvertical";
static const char glyph_emacron[] = "emacron";
static const char glyph_emacronacute[] = "emacronacute";
static const char glyph_emacrongrave[] = "emacrongrave";
static const char glyph_emcyrillic[] = "emcyrillic";
static const char glyph_emdash[] = "emdash";
static const char glyph_emdashvertical[] = "emdashvertical";
static const char glyph_emonospace[] = "emonospace";
static const char glyph_emphasismarkarmenian[] = "emphasismarkarmenian";
static const char glyph_emptyset[] = "emptyset";
static const char glyph_enbopomofo[] = "enbopomofo";
static const char glyph_encyrillic[] = "encyrillic";
static const char glyph_endash[] = "endash";
static const char glyph_endashvertical[] = "endashvertical";
static const char glyph_endescendercyrillic[] = "endescendercyrillic";
static const char glyph_eng[] = "eng";
static const char glyph_engbopomofo[] = "engbopomofo";
static const char glyph_enghecyrillic[] = "enghecyrillic";
static const char glyph_enhookcyrillic[] = "enhookcyrillic";
static const char glyph_enspace[] = "enspace";
static const char glyph_eogonek[] = "eogonek";
static const char glyph_eokorean[] = "eokorean";
static const char glyph_eopen[] = "eopen";
static const char glyph_eopenclosed[] = "eopenclosed";
static const char glyph_eopenreversed[] = "eopenreversed";
static const char glyph_eopenreversedclosed[] = "eopenreversedclosed";
static const char glyph_eopenreversedhook[] = "eopenreversedhook";
static const char glyph_eparen[] = "eparen";
static const char glyph_epsilon[] = "epsilon";
static const char glyph_epsilontonos[] = "epsilontonos";
static const char glyph_equal[] = "equal";
static const char glyph_equalmonospace[] = "equalmonospace";
static const char glyph_equalsmall[] = "equalsmall";
static const char glyph_equalsuperior[] = "equalsuperior";
static const char glyph_equivalence[] = "equivalence";
static const char glyph_erbopomofo[] = "erbopomofo";
static const char glyph_ercyrillic[] = "ercyrillic";
static const char glyph_ereversed[] = "ereversed";
static const char glyph_ereversedcyrillic[] = "ereversedcyrillic";
static const char glyph_escyrillic[] = "escyrillic";
static const char glyph_esdescendercyrillic[] = "esdescendercyrillic";
static const char glyph_esh[] = "esh";
static const char glyph_eshcurl[] = "eshcurl";
static const char glyph_eshortdeva[] = "eshortdeva";
static const char glyph_eshortvowelsigndeva[] = "eshortvowelsigndeva";
static const char glyph_eshreversedloop[] = "eshreversedloop";
static const char glyph_eshsquatreversed[] = "eshsquatreversed";
static const char glyph_esmallhiragana[] = "esmallhiragana";
static const char glyph_esmallkatakana[] = "esmallkatakana";
static const char glyph_esmallkatakanahalfwidth[] = "esmallkatakanahalfwidth";
static const char glyph_estimated[] = "estimated";
static const char glyph_esuperior[] = "esuperior";
static const char glyph_eta[] = "eta";
static const char glyph_etarmenian[] = "etarmenian";
static const char glyph_etatonos[] = "etatonos";
static const char glyph_eth[] = "eth";
static const char glyph_etilde[] = "etilde";
static const char glyph_etildebelow[] = "etildebelow";
static const char glyph_etnahtafoukhhebrew[] = "etnahtafoukhhebrew";
static const char glyph_etnahtafoukhlefthebrew[] = "etnahtafoukhlefthebrew";
static const char glyph_etnahtahebrew[] = "etnahtahebrew";
static const char glyph_etnahtalefthebrew[] = "etnahtalefthebrew";
static const char glyph_eturned[] = "eturned";
static const char glyph_eukorean[] = "eukorean";
static const char glyph_euro[] = "euro";
static const char glyph_evowelsignbengali[] = "evowelsignbengali";
static const char glyph_evowelsigndeva[] = "evowelsigndeva";
static const char glyph_evowelsigngujarati[] = "evowelsigngujarati";
static const char glyph_exclam[] = "exclam";
static const char glyph_exclamarmenian[] = "exclamarmenian";
static const char glyph_exclamdbl[] = "exclamdbl";
static const char glyph_exclamdown[] = "exclamdown";
static const char glyph_exclamdownsmall[] = "exclamdownsmall";
static const char glyph_exclammonospace[] = "exclammonospace";
static const char glyph_exclamsmall[] = "exclamsmall";
static const char glyph_existential[] = "existential";
static const char glyph_ezh[] = "ezh";
static const char glyph_ezhcaron[] = "ezhcaron";
static const char glyph_ezhcurl[] = "ezhcurl";
static const char glyph_ezhreversed[] = "ezhreversed";
static const char glyph_ezhtail[] = "ezhtail";
static const char glyph_f[] = "f";
static const char glyph_fadeva[] = "fadeva";
static const char glyph_fagurmukhi[] = "fagurmukhi";
static const char glyph_fahrenheit[] = "fahrenheit";
static const char glyph_fathaarabic[] = "fathaarabic";
static const char glyph_fathalowarabic[] = "fathalowarabic";
static const char glyph_fathatanarabic[] = "fathatanarabic";
static const char glyph_fbopomofo[] = "fbopomofo";
static const char glyph_fcircle[] = "fcircle";
static const char glyph_fdotaccent[] = "fdotaccent";
static const char glyph_feharabic[] = "feharabic";
static const char glyph_feharmenian[] = "feharmenian";
static const char glyph_fehfinalarabic[] = "fehfinalarabic";
static const char glyph_fehinitialarabic[] = "fehinitialarabic";
static const char glyph_fehmedialarabic[] = "fehmedialarabic";
static const char glyph_feicoptic[] = "feicoptic";
static const char glyph_female[] = "female";
static const char glyph_ff[] = "ff";
static const char glyph_ffi[] = "ffi";
static const char glyph_ffl[] = "ffl";
static const char glyph_fi[] = "fi";
static const char glyph_fifteencircle[] = "fifteencircle";
static const char glyph_fifteenparen[] = "fifteenparen";
static const char glyph_fifteenperiod[] = "fifteenperiod";
static const char glyph_figuredash[] = "figuredash";
static const char glyph_filledbox[] = "filledbox";
static const char glyph_filledrect[] = "filledrect";
static const char glyph_finalkaf[] = "finalkaf";
static const char glyph_finalkafdagesh[] = "finalkafdagesh";
static const char glyph_finalkafdageshhebrew[] = "finalkafdageshhebrew";
static const char glyph_finalkafhebrew[] = "finalkafhebrew";
static const char glyph_finalkafqamats[] = "finalkafqamats";
static const char glyph_finalkafqamatshebrew[] = "finalkafqamatshebrew";
static const char glyph_finalkafsheva[] = "finalkafsheva";
static const char glyph_finalkafshevahebrew[] = "finalkafshevahebrew";
static const char glyph_finalmem[] = "finalmem";
static const char glyph_finalmemhebrew[] = "finalmemhebrew";
static const char glyph_finalnun[] = "finalnun";
static const char glyph_finalnunhebrew[] = "finalnunhebrew";
static const char glyph_finalpe[] = "finalpe";
static const char glyph_finalpehebrew[] = "finalpehebrew";
static const char glyph_finaltsadi[] = "finaltsadi";
static const char glyph_finaltsadihebrew[] = "finaltsadihebrew";
static const char glyph_firsttonechinese[] = "firsttonechinese";
static const char glyph_fisheye[] = "fisheye";
static const char glyph_fitacyrillic[] = "fitacyrillic";
static const char glyph_five[] = "five";
static const char glyph_fivearabic[] = "fivearabic";
static const char glyph_fivebengali[] = "fivebengali";
static const char glyph_fivecircle[] = "fivecircle";
static const char glyph_fivecircleinversesansserif[] =
"fivecircleinversesansserif";
static const char glyph_fivedeva[] = "fivedeva";
static const char glyph_fiveeighths[] = "fiveeighths";
static const char glyph_fivegujarati[] = "fivegujarati";
static const char glyph_fivegurmukhi[] = "fivegurmukhi";
static const char glyph_fivehackarabic[] = "fivehackarabic";
static const char glyph_fivehangzhou[] = "fivehangzhou";
static const char glyph_fiveideographicparen[] = "fiveideographicparen";
static const char glyph_fiveinferior[] = "fiveinferior";
static const char glyph_fivemonospace[] = "fivemonospace";
static const char glyph_fiveoldstyle[] = "fiveoldstyle";
static const char glyph_fiveparen[] = "fiveparen";
static const char glyph_fiveperiod[] = "fiveperiod";
static const char glyph_fivepersian[] = "fivepersian";
static const char glyph_fiveroman[] = "fiveroman";
static const char glyph_fivesuperior[] = "fivesuperior";
static const char glyph_fivethai[] = "fivethai";
static const char glyph_fl[] = "fl";
static const char glyph_florin[] = "florin";
static const char glyph_fmonospace[] = "fmonospace";
static const char glyph_fmsquare[] = "fmsquare";
static const char glyph_fofanthai[] = "fofanthai";
static const char glyph_fofathai[] = "fofathai";
static const char glyph_fongmanthai[] = "fongmanthai";
static const char glyph_forall[] = "forall";
static const char glyph_four[] = "four";
static const char glyph_fourarabic[] = "fourarabic";
static const char glyph_fourbengali[] = "fourbengali";
static const char glyph_fourcircle[] = "fourcircle";
static const char glyph_fourcircleinversesansserif[] =
"fourcircleinversesansserif";
static const char glyph_fourdeva[] = "fourdeva";
static const char glyph_fourgujarati[] = "fourgujarati";
static const char glyph_fourgurmukhi[] = "fourgurmukhi";
static const char glyph_fourhackarabic[] = "fourhackarabic";
static const char glyph_fourhangzhou[] = "fourhangzhou";
static const char glyph_fourideographicparen[] = "fourideographicparen";
static const char glyph_fourinferior[] = "fourinferior";
static const char glyph_fourmonospace[] = "fourmonospace";
static const char glyph_fournumeratorbengali[] = "fournumeratorbengali";
static const char glyph_fouroldstyle[] = "fouroldstyle";
static const char glyph_fourparen[] = "fourparen";
static const char glyph_fourperiod[] = "fourperiod";
static const char glyph_fourpersian[] = "fourpersian";
static const char glyph_fourroman[] = "fourroman";
static const char glyph_foursuperior[] = "foursuperior";
static const char glyph_fourteencircle[] = "fourteencircle";
static const char glyph_fourteenparen[] = "fourteenparen";
static const char glyph_fourteenperiod[] = "fourteenperiod";
static const char glyph_fourthai[] = "fourthai";
static const char glyph_fourthtonechinese[] = "fourthtonechinese";
static const char glyph_fparen[] = "fparen";
static const char glyph_fraction[] = "fraction";
static const char glyph_franc[] = "franc";
static const char glyph_g[] = "g";
static const char glyph_gabengali[] = "gabengali";
static const char glyph_gacute[] = "gacute";
static const char glyph_gadeva[] = "gadeva";
static const char glyph_gafarabic[] = "gafarabic";
static const char glyph_gaffinalarabic[] = "gaffinalarabic";
static const char glyph_gafinitialarabic[] = "gafinitialarabic";
static const char glyph_gafmedialarabic[] = "gafmedialarabic";
static const char glyph_gagujarati[] = "gagujarati";
static const char glyph_gagurmukhi[] = "gagurmukhi";
static const char glyph_gahiragana[] = "gahiragana";
static const char glyph_gakatakana[] = "gakatakana";
static const char glyph_gamma[] = "gamma";
static const char glyph_gammalatinsmall[] = "gammalatinsmall";
static const char glyph_gammasuperior[] = "gammasuperior";
static const char glyph_gangiacoptic[] = "gangiacoptic";
static const char glyph_gbopomofo[] = "gbopomofo";
static const char glyph_gbreve[] = "gbreve";
static const char glyph_gcaron[] = "gcaron";
static const char glyph_gcedilla[] = "gcedilla";
static const char glyph_gcircle[] = "gcircle";
static const char glyph_gcircumflex[] = "gcircumflex";
static const char glyph_gcommaaccent[] = "gcommaaccent";
static const char glyph_gdot[] = "gdot";
static const char glyph_gdotaccent[] = "gdotaccent";
static const char glyph_gecyrillic[] = "gecyrillic";
static const char glyph_gehiragana[] = "gehiragana";
static const char glyph_gekatakana[] = "gekatakana";
static const char glyph_geometricallyequal[] = "geometricallyequal";
static const char glyph_gereshaccenthebrew[] = "gereshaccenthebrew";
static const char glyph_gereshhebrew[] = "gereshhebrew";
static const char glyph_gereshmuqdamhebrew[] = "gereshmuqdamhebrew";
static const char glyph_germandbls[] = "germandbls";
static const char glyph_gershayimaccenthebrew[] = "gershayimaccenthebrew";
static const char glyph_gershayimhebrew[] = "gershayimhebrew";
static const char glyph_getamark[] = "getamark";
static const char glyph_ghabengali[] = "ghabengali";
static const char glyph_ghadarmenian[] = "ghadarmenian";
static const char glyph_ghadeva[] = "ghadeva";
static const char glyph_ghagujarati[] = "ghagujarati";
static const char glyph_ghagurmukhi[] = "ghagurmukhi";
static const char glyph_ghainarabic[] = "ghainarabic";
static const char glyph_ghainfinalarabic[] = "ghainfinalarabic";
static const char glyph_ghaininitialarabic[] = "ghaininitialarabic";
static const char glyph_ghainmedialarabic[] = "ghainmedialarabic";
static const char glyph_ghemiddlehookcyrillic[] = "ghemiddlehookcyrillic";
static const char glyph_ghestrokecyrillic[] = "ghestrokecyrillic";
static const char glyph_gheupturncyrillic[] = "gheupturncyrillic";
static const char glyph_ghhadeva[] = "ghhadeva";
static const char glyph_ghhagurmukhi[] = "ghhagurmukhi";
static const char glyph_ghook[] = "ghook";
static const char glyph_ghzsquare[] = "ghzsquare";
static const char glyph_gihiragana[] = "gihiragana";
static const char glyph_gikatakana[] = "gikatakana";
static const char glyph_gimarmenian[] = "gimarmenian";
static const char glyph_gimel[] = "gimel";
static const char glyph_gimeldagesh[] = "gimeldagesh";
static const char glyph_gimeldageshhebrew[] = "gimeldageshhebrew";
static const char glyph_gimelhebrew[] = "gimelhebrew";
static const char glyph_gjecyrillic[] = "gjecyrillic";
static const char glyph_glottalinvertedstroke[] = "glottalinvertedstroke";
static const char glyph_glottalstop[] = "glottalstop";
static const char glyph_glottalstopinverted[] = "glottalstopinverted";
static const char glyph_glottalstopmod[] = "glottalstopmod";
static const char glyph_glottalstopreversed[] = "glottalstopreversed";
static const char glyph_glottalstopreversedmod[] = "glottalstopreversedmod";
static const char glyph_glottalstopreversedsuperior[] =
"glottalstopreversedsuperior";
static const char glyph_glottalstopstroke[] = "glottalstopstroke";
static const char glyph_glottalstopstrokereversed[] =
"glottalstopstrokereversed";
static const char glyph_gmacron[] = "gmacron";
static const char glyph_gmonospace[] = "gmonospace";
static const char glyph_gohiragana[] = "gohiragana";
static const char glyph_gokatakana[] = "gokatakana";
static const char glyph_gparen[] = "gparen";
static const char glyph_gpasquare[] = "gpasquare";
static const char glyph_gradient[] = "gradient";
static const char glyph_grave[] = "grave";
static const char glyph_gravebelowcmb[] = "gravebelowcmb";
static const char glyph_gravecmb[] = "gravecmb";
static const char glyph_gravecomb[] = "gravecomb";
static const char glyph_gravedeva[] = "gravedeva";
static const char glyph_gravelowmod[] = "gravelowmod";
static const char glyph_gravemonospace[] = "gravemonospace";
static const char glyph_gravetonecmb[] = "gravetonecmb";
static const char glyph_greater[] = "greater";
static const char glyph_greaterequal[] = "greaterequal";
static const char glyph_greaterequalorless[] = "greaterequalorless";
static const char glyph_greatermonospace[] = "greatermonospace";
static const char glyph_greaterorequivalent[] = "greaterorequivalent";
static const char glyph_greaterorless[] = "greaterorless";
static const char glyph_greateroverequal[] = "greateroverequal";
static const char glyph_greatersmall[] = "greatersmall";
static const char glyph_gscript[] = "gscript";
static const char glyph_gstroke[] = "gstroke";
static const char glyph_guhiragana[] = "guhiragana";
static const char glyph_guillemotleft[] = "guillemotleft";
static const char glyph_guillemotright[] = "guillemotright";
static const char glyph_guilsinglleft[] = "guilsinglleft";
static const char glyph_guilsinglright[] = "guilsinglright";
static const char glyph_gukatakana[] = "gukatakana";
static const char glyph_guramusquare[] = "guramusquare";
static const char glyph_gysquare[] = "gysquare";
static const char glyph_h[] = "h";
static const char glyph_haabkhasiancyrillic[] = "haabkhasiancyrillic";
static const char glyph_haaltonearabic[] = "haaltonearabic";
static const char glyph_habengali[] = "habengali";
static const char glyph_hadescendercyrillic[] = "hadescendercyrillic";
static const char glyph_hadeva[] = "hadeva";
static const char glyph_hagujarati[] = "hagujarati";
static const char glyph_hagurmukhi[] = "hagurmukhi";
static const char glyph_haharabic[] = "haharabic";
static const char glyph_hahfinalarabic[] = "hahfinalarabic";
static const char glyph_hahinitialarabic[] = "hahinitialarabic";
static const char glyph_hahiragana[] = "hahiragana";
static const char glyph_hahmedialarabic[] = "hahmedialarabic";
static const char glyph_haitusquare[] = "haitusquare";
static const char glyph_hakatakana[] = "hakatakana";
static const char glyph_hakatakanahalfwidth[] = "hakatakanahalfwidth";
static const char glyph_halantgurmukhi[] = "halantgurmukhi";
static const char glyph_hamzaarabic[] = "hamzaarabic";
static const char glyph_hamzadammaarabic[] = "hamzadammaarabic";
static const char glyph_hamzadammatanarabic[] = "hamzadammatanarabic";
static const char glyph_hamzafathaarabic[] = "hamzafathaarabic";
static const char glyph_hamzafathatanarabic[] = "hamzafathatanarabic";
static const char glyph_hamzalowarabic[] = "hamzalowarabic";
static const char glyph_hamzalowkasraarabic[] = "hamzalowkasraarabic";
static const char glyph_hamzalowkasratanarabic[] = "hamzalowkasratanarabic";
static const char glyph_hamzasukunarabic[] = "hamzasukunarabic";
static const char glyph_hangulfiller[] = "hangulfiller";
static const char glyph_hardsigncyrillic[] = "hardsigncyrillic";
static const char glyph_harpoonleftbarbup[] = "harpoonleftbarbup";
static const char glyph_harpoonrightbarbup[] = "harpoonrightbarbup";
static const char glyph_hasquare[] = "hasquare";
static const char glyph_hatafpatah[] = "hatafpatah";
static const char glyph_hatafpatah16[] = "hatafpatah16";
static const char glyph_hatafpatah23[] = "hatafpatah23";
static const char glyph_hatafpatah2f[] = "hatafpatah2f";
static const char glyph_hatafpatahhebrew[] = "hatafpatahhebrew";
static const char glyph_hatafpatahnarrowhebrew[] = "hatafpatahnarrowhebrew";
static const char glyph_hatafpatahquarterhebrew[] = "hatafpatahquarterhebrew";
static const char glyph_hatafpatahwidehebrew[] = "hatafpatahwidehebrew";
static const char glyph_hatafqamats[] = "hatafqamats";
static const char glyph_hatafqamats1b[] = "hatafqamats1b";
static const char glyph_hatafqamats28[] = "hatafqamats28";
static const char glyph_hatafqamats34[] = "hatafqamats34";
static const char glyph_hatafqamatshebrew[] = "hatafqamatshebrew";
static const char glyph_hatafqamatsnarrowhebrew[] = "hatafqamatsnarrowhebrew";
static const char glyph_hatafqamatsquarterhebrew[] =
"hatafqamatsquarterhebrew";
static const char glyph_hatafqamatswidehebrew[] = "hatafqamatswidehebrew";
static const char glyph_hatafsegol[] = "hatafsegol";
static const char glyph_hatafsegol17[] = "hatafsegol17";
static const char glyph_hatafsegol24[] = "hatafsegol24";
static const char glyph_hatafsegol30[] = "hatafsegol30";
static const char glyph_hatafsegolhebrew[] = "hatafsegolhebrew";
static const char glyph_hatafsegolnarrowhebrew[] = "hatafsegolnarrowhebrew";
static const char glyph_hatafsegolquarterhebrew[] = "hatafsegolquarterhebrew";
static const char glyph_hatafsegolwidehebrew[] = "hatafsegolwidehebrew";
static const char glyph_hbar[] = "hbar";
static const char glyph_hbopomofo[] = "hbopomofo";
static const char glyph_hbrevebelow[] = "hbrevebelow";
static const char glyph_hcedilla[] = "hcedilla";
static const char glyph_hcircle[] = "hcircle";
static const char glyph_hcircumflex[] = "hcircumflex";
static const char glyph_hdieresis[] = "hdieresis";
static const char glyph_hdotaccent[] = "hdotaccent";
static const char glyph_hdotbelow[] = "hdotbelow";
static const char glyph_he[] = "he";
static const char glyph_heart[] = "heart";
static const char glyph_heartsuitblack[] = "heartsuitblack";
static const char glyph_heartsuitwhite[] = "heartsuitwhite";
static const char glyph_hedagesh[] = "hedagesh";
static const char glyph_hedageshhebrew[] = "hedageshhebrew";
static const char glyph_hehaltonearabic[] = "hehaltonearabic";
static const char glyph_heharabic[] = "heharabic";
static const char glyph_hehebrew[] = "hehebrew";
static const char glyph_hehfinalaltonearabic[] = "hehfinalaltonearabic";
static const char glyph_hehfinalalttwoarabic[] = "hehfinalalttwoarabic";
static const char glyph_hehfinalarabic[] = "hehfinalarabic";
static const char glyph_hehhamzaabovefinalarabic[] =
"hehhamzaabovefinalarabic";
static const char glyph_hehhamzaaboveisolatedarabic[] =
"hehhamzaaboveisolatedarabic";
static const char glyph_hehinitialaltonearabic[] = "hehinitialaltonearabic";
static const char glyph_hehinitialarabic[] = "hehinitialarabic";
static const char glyph_hehiragana[] = "hehiragana";
static const char glyph_hehmedialaltonearabic[] = "hehmedialaltonearabic";
static const char glyph_hehmedialarabic[] = "hehmedialarabic";
static const char glyph_heiseierasquare[] = "heiseierasquare";
static const char glyph_hekatakana[] = "hekatakana";
static const char glyph_hekatakanahalfwidth[] = "hekatakanahalfwidth";
static const char glyph_hekutaarusquare[] = "hekutaarusquare";
static const char glyph_henghook[] = "henghook";
static const char glyph_herutusquare[] = "herutusquare";
static const char glyph_het[] = "het";
static const char glyph_hethebrew[] = "hethebrew";
static const char glyph_hhook[] = "hhook";
static const char glyph_hhooksuperior[] = "hhooksuperior";
static const char glyph_hieuhacirclekorean[] = "hieuhacirclekorean";
static const char glyph_hieuhaparenkorean[] = "hieuhaparenkorean";
static const char glyph_hieuhcirclekorean[] = "hieuhcirclekorean";
static const char glyph_hieuhkorean[] = "hieuhkorean";
static const char glyph_hieuhparenkorean[] = "hieuhparenkorean";
static const char glyph_hihiragana[] = "hihiragana";
static const char glyph_hikatakana[] = "hikatakana";
static const char glyph_hikatakanahalfwidth[] = "hikatakanahalfwidth";
static const char glyph_hiriq[] = "hiriq";
static const char glyph_hiriq14[] = "hiriq14";
static const char glyph_hiriq21[] = "hiriq21";
static const char glyph_hiriq2d[] = "hiriq2d";
static const char glyph_hiriqhebrew[] = "hiriqhebrew";
static const char glyph_hiriqnarrowhebrew[] = "hiriqnarrowhebrew";
static const char glyph_hiriqquarterhebrew[] = "hiriqquarterhebrew";
static const char glyph_hiriqwidehebrew[] = "hiriqwidehebrew";
static const char glyph_hlinebelow[] = "hlinebelow";
static const char glyph_hmonospace[] = "hmonospace";
static const char glyph_hoarmenian[] = "hoarmenian";
static const char glyph_hohipthai[] = "hohipthai";
static const char glyph_hohiragana[] = "hohiragana";
static const char glyph_hokatakana[] = "hokatakana";
static const char glyph_hokatakanahalfwidth[] = "hokatakanahalfwidth";
static const char glyph_holam[] = "holam";
static const char glyph_holam19[] = "holam19";
static const char glyph_holam26[] = "holam26";
static const char glyph_holam32[] = "holam32";
static const char glyph_holamhebrew[] = "holamhebrew";
static const char glyph_holamnarrowhebrew[] = "holamnarrowhebrew";
static const char glyph_holamquarterhebrew[] = "holamquarterhebrew";
static const char glyph_holamwidehebrew[] = "holamwidehebrew";
static const char glyph_honokhukthai[] = "honokhukthai";
static const char glyph_hookabovecomb[] = "hookabovecomb";
static const char glyph_hookcmb[] = "hookcmb";
static const char glyph_hookpalatalizedbelowcmb[] = "hookpalatalizedbelowcmb";
static const char glyph_hookretroflexbelowcmb[] = "hookretroflexbelowcmb";
static const char glyph_hoonsquare[] = "hoonsquare";
static const char glyph_horicoptic[] = "horicoptic";
static const char glyph_horizontalbar[] = "horizontalbar";
static const char glyph_horncmb[] = "horncmb";
static const char glyph_hotsprings[] = "hotsprings";
static const char glyph_house[] = "house";
static const char glyph_hparen[] = "hparen";
static const char glyph_hsuperior[] = "hsuperior";
static const char glyph_hturned[] = "hturned";
static const char glyph_huhiragana[] = "huhiragana";
static const char glyph_huiitosquare[] = "huiitosquare";
static const char glyph_hukatakana[] = "hukatakana";
static const char glyph_hukatakanahalfwidth[] = "hukatakanahalfwidth";
static const char glyph_hungarumlaut[] = "hungarumlaut";
static const char glyph_hungarumlautcmb[] = "hungarumlautcmb";
static const char glyph_hv[] = "hv";
static const char glyph_hyphen[] = "hyphen";
static const char glyph_hypheninferior[] = "hypheninferior";
static const char glyph_hyphenmonospace[] = "hyphenmonospace";
static const char glyph_hyphensmall[] = "hyphensmall";
static const char glyph_hyphensuperior[] = "hyphensuperior";
static const char glyph_hyphentwo[] = "hyphentwo";
static const char glyph_i[] = "i";
static const char glyph_iacute[] = "iacute";
static const char glyph_iacyrillic[] = "iacyrillic";
static const char glyph_ibengali[] = "ibengali";
static const char glyph_ibopomofo[] = "ibopomofo";
static const char glyph_ibreve[] = "ibreve";
static const char glyph_icaron[] = "icaron";
static const char glyph_icircle[] = "icircle";
static const char glyph_icircumflex[] = "icircumflex";
static const char glyph_icyrillic[] = "icyrillic";
static const char glyph_idblgrave[] = "idblgrave";
static const char glyph_ideographearthcircle[] = "ideographearthcircle";
static const char glyph_ideographfirecircle[] = "ideographfirecircle";
static const char glyph_ideographicallianceparen[] =
"ideographicallianceparen";
static const char glyph_ideographiccallparen[] = "ideographiccallparen";
static const char glyph_ideographiccentrecircle[] = "ideographiccentrecircle";
static const char glyph_ideographicclose[] = "ideographicclose";
static const char glyph_ideographiccomma[] = "ideographiccomma";
static const char glyph_ideographiccommaleft[] = "ideographiccommaleft";
static const char glyph_ideographiccongratulationparen[] =
"ideographiccongratulationparen";
static const char glyph_ideographiccorrectcircle[] =
"ideographiccorrectcircle";
static const char glyph_ideographicearthparen[] =
"ideographicearthparen";
static const char glyph_ideographicenterpriseparen[] =
"ideographicenterpriseparen";
static const char glyph_ideographicexcellentcircle[] =
"ideographicexcellentcircle";
static const char glyph_ideographicfestivalparen[] =
"ideographicfestivalparen";
static const char glyph_ideographicfinancialcircle[] =
"ideographicfinancialcircle";
static const char glyph_ideographicfinancialparen[] =
"ideographicfinancialparen";
static const char glyph_ideographicfireparen[] = "ideographicfireparen";
static const char glyph_ideographichaveparen[] = "ideographichaveparen";
static const char glyph_ideographichighcircle[] = "ideographichighcircle";
static const char glyph_ideographiciterationmark[] =
"ideographiciterationmark";
static const char glyph_ideographiclaborcircle[] = "ideographiclaborcircle";
static const char glyph_ideographiclaborparen[] = "ideographiclaborparen";
static const char glyph_ideographicleftcircle[] = "ideographicleftcircle";
static const char glyph_ideographiclowcircle[] = "ideographiclowcircle";
static const char glyph_ideographicmedicinecircle[] =
"ideographicmedicinecircle";
static const char glyph_ideographicmetalparen[] = "ideographicmetalparen";
static const char glyph_ideographicmoonparen[] = "ideographicmoonparen";
static const char glyph_ideographicnameparen[] = "ideographicnameparen";
static const char glyph_ideographicperiod[] = "ideographicperiod";
static const char glyph_ideographicprintcircle[] = "ideographicprintcircle";
static const char glyph_ideographicreachparen[] = "ideographicreachparen";
static const char glyph_ideographicrepresentparen[] =
"ideographicrepresentparen";
static const char glyph_ideographicresourceparen[] =
"ideographicresourceparen";
static const char glyph_ideographicrightcircle[] = "ideographicrightcircle";
static const char glyph_ideographicsecretcircle[] = "ideographicsecretcircle";
static const char glyph_ideographicselfparen[] = "ideographicselfparen";
static const char glyph_ideographicsocietyparen[] = "ideographicsocietyparen";
static const char glyph_ideographicspace[] = "ideographicspace";
static const char glyph_ideographicspecialparen[] = "ideographicspecialparen";
static const char glyph_ideographicstockparen[] = "ideographicstockparen";
static const char glyph_ideographicstudyparen[] = "ideographicstudyparen";
static const char glyph_ideographicsunparen[] = "ideographicsunparen";
static const char glyph_ideographicsuperviseparen[] =
"ideographicsuperviseparen";
static const char glyph_ideographicwaterparen[] = "ideographicwaterparen";
static const char glyph_ideographicwoodparen[] = "ideographicwoodparen";
static const char glyph_ideographiczero[] = "ideographiczero";
static const char glyph_ideographmetalcircle[] = "ideographmetalcircle";
static const char glyph_ideographmooncircle[] = "ideographmooncircle";
static const char glyph_ideographnamecircle[] = "ideographnamecircle";
static const char glyph_ideographsuncircle[] = "ideographsuncircle";
static const char glyph_ideographwatercircle[] = "ideographwatercircle";
static const char glyph_ideographwoodcircle[] = "ideographwoodcircle";
static const char glyph_ideva[] = "ideva";
static const char glyph_idieresis[] = "idieresis";
static const char glyph_idieresisacute[] = "idieresisacute";
static const char glyph_idieresiscyrillic[] = "idieresiscyrillic";
static const char glyph_idotbelow[] = "idotbelow";
static const char glyph_iebrevecyrillic[] = "iebrevecyrillic";
static const char glyph_iecyrillic[] = "iecyrillic";
static const char glyph_ieungacirclekorean[] = "ieungacirclekorean";
static const char glyph_ieungaparenkorean[] = "ieungaparenkorean";
static const char glyph_ieungcirclekorean[] = "ieungcirclekorean";
static const char glyph_ieungkorean[] = "ieungkorean";
static const char glyph_ieungparenkorean[] = "ieungparenkorean";
static const char glyph_igrave[] = "igrave";
static const char glyph_igujarati[] = "igujarati";
static const char glyph_igurmukhi[] = "igurmukhi";
static const char glyph_ihiragana[] = "ihiragana";
static const char glyph_ihookabove[] = "ihookabove";
static const char glyph_iibengali[] = "iibengali";
static const char glyph_iicyrillic[] = "iicyrillic";
static const char glyph_iideva[] = "iideva";
static const char glyph_iigujarati[] = "iigujarati";
static const char glyph_iigurmukhi[] = "iigurmukhi";
static const char glyph_iimatragurmukhi[] = "iimatragurmukhi";
static const char glyph_iinvertedbreve[] = "iinvertedbreve";
static const char glyph_iishortcyrillic[] = "iishortcyrillic";
static const char glyph_iivowelsignbengali[] = "iivowelsignbengali";
static const char glyph_iivowelsigndeva[] = "iivowelsigndeva";
static const char glyph_iivowelsigngujarati[] = "iivowelsigngujarati";
static const char glyph_ij[] = "ij";
static const char glyph_ikatakana[] = "ikatakana";
static const char glyph_ikatakanahalfwidth[] = "ikatakanahalfwidth";
static const char glyph_ikorean[] = "ikorean";
static const char glyph_ilde[] = "ilde";
static const char glyph_iluyhebrew[] = "iluyhebrew";
static const char glyph_imacron[] = "imacron";
static const char glyph_imacroncyrillic[] = "imacroncyrillic";
static const char glyph_imageorapproximatelyequal[] =
"imageorapproximatelyequal";
static const char glyph_imatragurmukhi[] = "imatragurmukhi";
static const char glyph_imonospace[] = "imonospace";
static const char glyph_increment[] = "increment";
static const char glyph_infinity[] = "infinity";
static const char glyph_iniarmenian[] = "iniarmenian";
static const char glyph_integral[] = "integral";
static const char glyph_integralbottom[] = "integralbottom";
static const char glyph_integralbt[] = "integralbt";
static const char glyph_integralex[] = "integralex";
static const char glyph_integraltop[] = "integraltop";
static const char glyph_integraltp[] = "integraltp";
static const char glyph_intersection[] = "intersection";
static const char glyph_intisquare[] = "intisquare";
static const char glyph_invbullet[] = "invbullet";
static const char glyph_invcircle[] = "invcircle";
static const char glyph_invsmileface[] = "invsmileface";
static const char glyph_iocyrillic[] = "iocyrillic";
static const char glyph_iogonek[] = "iogonek";
static const char glyph_iota[] = "iota";
static const char glyph_iotadieresis[] = "iotadieresis";
static const char glyph_iotadieresistonos[] = "iotadieresistonos";
static const char glyph_iotalatin[] = "iotalatin";
static const char glyph_iotatonos[] = "iotatonos";
static const char glyph_iparen[] = "iparen";
static const char glyph_irigurmukhi[] = "irigurmukhi";
static const char glyph_ismallhiragana[] = "ismallhiragana";
static const char glyph_ismallkatakana[] = "ismallkatakana";
static const char glyph_ismallkatakanahalfwidth[] = "ismallkatakanahalfwidth";
static const char glyph_issharbengali[] = "issharbengali";
static const char glyph_istroke[] = "istroke";
static const char glyph_isuperior[] = "isuperior";
static const char glyph_iterationhiragana[] = "iterationhiragana";
static const char glyph_iterationkatakana[] = "iterationkatakana";
static const char glyph_itilde[] = "itilde";
static const char glyph_itildebelow[] = "itildebelow";
static const char glyph_iubopomofo[] = "iubopomofo";
static const char glyph_iucyrillic[] = "iucyrillic";
static const char glyph_ivowelsignbengali[] = "ivowelsignbengali";
static const char glyph_ivowelsigndeva[] = "ivowelsigndeva";
static const char glyph_ivowelsigngujarati[] = "ivowelsigngujarati";
static const char glyph_izhitsacyrillic[] = "izhitsacyrillic";
static const char glyph_izhitsadblgravecyrillic[] = "izhitsadblgravecyrillic";
static const char glyph_j[] = "j";
static const char glyph_jaarmenian[] = "jaarmenian";
static const char glyph_jabengali[] = "jabengali";
static const char glyph_jadeva[] = "jadeva";
static const char glyph_jagujarati[] = "jagujarati";
static const char glyph_jagurmukhi[] = "jagurmukhi";
static const char glyph_jbopomofo[] = "jbopomofo";
static const char glyph_jcaron[] = "jcaron";
static const char glyph_jcircle[] = "jcircle";
static const char glyph_jcircumflex[] = "jcircumflex";
static const char glyph_jcrossedtail[] = "jcrossedtail";
static const char glyph_jdotlessstroke[] = "jdotlessstroke";
static const char glyph_jecyrillic[] = "jecyrillic";
static const char glyph_jeemarabic[] = "jeemarabic";
static const char glyph_jeemfinalarabic[] = "jeemfinalarabic";
static const char glyph_jeeminitialarabic[] = "jeeminitialarabic";
static const char glyph_jeemmedialarabic[] = "jeemmedialarabic";
static const char glyph_jeharabic[] = "jeharabic";
static const char glyph_jehfinalarabic[] = "jehfinalarabic";
static const char glyph_jhabengali[] = "jhabengali";
static const char glyph_jhadeva[] = "jhadeva";
static const char glyph_jhagujarati[] = "jhagujarati";
static const char glyph_jhagurmukhi[] = "jhagurmukhi";
static const char glyph_jheharmenian[] = "jheharmenian";
static const char glyph_jis[] = "jis";
static const char glyph_jmonospace[] = "jmonospace";
static const char glyph_jparen[] = "jparen";
static const char glyph_jsuperior[] = "jsuperior";
static const char glyph_k[] = "k";
static const char glyph_kabashkircyrillic[] = "kabashkircyrillic";
static const char glyph_kabengali[] = "kabengali";
static const char glyph_kacute[] = "kacute";
static const char glyph_kacyrillic[] = "kacyrillic";
static const char glyph_kadescendercyrillic[] = "kadescendercyrillic";
static const char glyph_kadeva[] = "kadeva";
static const char glyph_kaf[] = "kaf";
static const char glyph_kafarabic[] = "kafarabic";
static const char glyph_kafdagesh[] = "kafdagesh";
static const char glyph_kafdageshhebrew[] = "kafdageshhebrew";
static const char glyph_kaffinalarabic[] = "kaffinalarabic";
static const char glyph_kafhebrew[] = "kafhebrew";
static const char glyph_kafinitialarabic[] = "kafinitialarabic";
static const char glyph_kafmedialarabic[] = "kafmedialarabic";
static const char glyph_kafrafehebrew[] = "kafrafehebrew";
static const char glyph_kagujarati[] = "kagujarati";
static const char glyph_kagurmukhi[] = "kagurmukhi";
static const char glyph_kahiragana[] = "kahiragana";
static const char glyph_kahookcyrillic[] = "kahookcyrillic";
static const char glyph_kakatakana[] = "kakatakana";
static const char glyph_kakatakanahalfwidth[] = "kakatakanahalfwidth";
static const char glyph_kappa[] = "kappa";
static const char glyph_kappasymbolgreek[] = "kappasymbolgreek";
static const char glyph_kapyeounmieumkorean[] = "kapyeounmieumkorean";
static const char glyph_kapyeounphieuphkorean[] = "kapyeounphieuphkorean";
static const char glyph_kapyeounpieupkorean[] = "kapyeounpieupkorean";
static const char glyph_kapyeounssangpieupkorean[] =
"kapyeounssangpieupkorean";
static const char glyph_karoriisquare[] = "karoriisquare";
static const char glyph_kashidaautoarabic[] = "kashidaautoarabic";
static const char glyph_kashidaautonosidebearingarabic[] =
"kashidaautonosidebearingarabic";
static const char glyph_kasmallkatakana[] = "kasmallkatakana";
static const char glyph_kasquare[] = "kasquare";
static const char glyph_kasraarabic[] = "kasraarabic";
static const char glyph_kasratanarabic[] = "kasratanarabic";
static const char glyph_kastrokecyrillic[] = "kastrokecyrillic";
static const char glyph_katahiraprolongmarkhalfwidth[] =
"katahiraprolongmarkhalfwidth";
static const char glyph_kaverticalstrokecyrillic[] =
"kaverticalstrokecyrillic";
static const char glyph_kbopomofo[] = "kbopomofo";
static const char glyph_kcalsquare[] = "kcalsquare";
static const char glyph_kcaron[] = "kcaron";
static const char glyph_kcedilla[] = "kcedilla";
static const char glyph_kcircle[] = "kcircle";
static const char glyph_kcommaaccent[] = "kcommaaccent";
static const char glyph_kdotbelow[] = "kdotbelow";
static const char glyph_keharmenian[] = "keharmenian";
static const char glyph_kehiragana[] = "kehiragana";
static const char glyph_kekatakana[] = "kekatakana";
static const char glyph_kekatakanahalfwidth[] = "kekatakanahalfwidth";
static const char glyph_kenarmenian[] = "kenarmenian";
static const char glyph_kesmallkatakana[] = "kesmallkatakana";
static const char glyph_kgreenlandic[] = "kgreenlandic";
static const char glyph_khabengali[] = "khabengali";
static const char glyph_khacyrillic[] = "khacyrillic";
static const char glyph_khadeva[] = "khadeva";
static const char glyph_khagujarati[] = "khagujarati";
static const char glyph_khagurmukhi[] = "khagurmukhi";
static const char glyph_khaharabic[] = "khaharabic";
static const char glyph_khahfinalarabic[] = "khahfinalarabic";
static const char glyph_khahinitialarabic[] = "khahinitialarabic";
static const char glyph_khahmedialarabic[] = "khahmedialarabic";
static const char glyph_kheicoptic[] = "kheicoptic";
static const char glyph_khhadeva[] = "khhadeva";
static const char glyph_khhagurmukhi[] = "khhagurmukhi";
static const char glyph_khieukhacirclekorean[] = "khieukhacirclekorean";
static const char glyph_khieukhaparenkorean[] = "khieukhaparenkorean";
static const char glyph_khieukhcirclekorean[] = "khieukhcirclekorean";
static const char glyph_khieukhkorean[] = "khieukhkorean";
static const char glyph_khieukhparenkorean[] = "khieukhparenkorean";
static const char glyph_khokhaithai[] = "khokhaithai";
static const char glyph_khokhonthai[] = "khokhonthai";
static const char glyph_khokhuatthai[] = "khokhuatthai";
static const char glyph_khokhwaithai[] = "khokhwaithai";
static const char glyph_khomutthai[] = "khomutthai";
static const char glyph_khook[] = "khook";
static const char glyph_khorakhangthai[] = "khorakhangthai";
static const char glyph_khzsquare[] = "khzsquare";
static const char glyph_kihiragana[] = "kihiragana";
static const char glyph_kikatakana[] = "kikatakana";
static const char glyph_kikatakanahalfwidth[] = "kikatakanahalfwidth";
static const char glyph_kiroguramusquare[] = "kiroguramusquare";
static const char glyph_kiromeetorusquare[] = "kiromeetorusquare";
static const char glyph_kirosquare[] = "kirosquare";
static const char glyph_kiyeokacirclekorean[] = "kiyeokacirclekorean";
static const char glyph_kiyeokaparenkorean[] = "kiyeokaparenkorean";
static const char glyph_kiyeokcirclekorean[] = "kiyeokcirclekorean";
static const char glyph_kiyeokkorean[] = "kiyeokkorean";
static const char glyph_kiyeokparenkorean[] = "kiyeokparenkorean";
static const char glyph_kiyeoksioskorean[] = "kiyeoksioskorean";
static const char glyph_kjecyrillic[] = "kjecyrillic";
static const char glyph_klinebelow[] = "klinebelow";
static const char glyph_klsquare[] = "klsquare";
static const char glyph_kmcubedsquare[] = "kmcubedsquare";
static const char glyph_kmonospace[] = "kmonospace";
static const char glyph_kmsquaredsquare[] = "kmsquaredsquare";
static const char glyph_kohiragana[] = "kohiragana";
static const char glyph_kohmsquare[] = "kohmsquare";
static const char glyph_kokaithai[] = "kokaithai";
static const char glyph_kokatakana[] = "kokatakana";
static const char glyph_kokatakanahalfwidth[] = "kokatakanahalfwidth";
static const char glyph_kooposquare[] = "kooposquare";
static const char glyph_koppacyrillic[] = "koppacyrillic";
static const char glyph_koreanstandardsymbol[] = "koreanstandardsymbol";
static const char glyph_koroniscmb[] = "koroniscmb";
static const char glyph_kparen[] = "kparen";
static const char glyph_kpasquare[] = "kpasquare";
static const char glyph_ksicyrillic[] = "ksicyrillic";
static const char glyph_ktsquare[] = "ktsquare";
static const char glyph_kturned[] = "kturned";
static const char glyph_kuhiragana[] = "kuhiragana";
static const char glyph_kukatakana[] = "kukatakana";
static const char glyph_kukatakanahalfwidth[] = "kukatakanahalfwidth";
static const char glyph_kvsquare[] = "kvsquare";
static const char glyph_kwsquare[] = "kwsquare";
static const char glyph_l[] = "l";
static const char glyph_labengali[] = "labengali";
static const char glyph_lacute[] = "lacute";
static const char glyph_ladeva[] = "ladeva";
static const char glyph_lagujarati[] = "lagujarati";
static const char glyph_lagurmukhi[] = "lagurmukhi";
static const char glyph_lakkhangyaothai[] = "lakkhangyaothai";
static const char glyph_lamaleffinalarabic[] = "lamaleffinalarabic";
static const char glyph_lamalefhamzaabovefinalarabic[] =
"lamalefhamzaabovefinalarabic";
static const char glyph_lamalefhamzaaboveisolatedarabic[] =
"lamalefhamzaaboveisolatedarabic";
static const char glyph_lamalefhamzabelowfinalarabic[] =
"lamalefhamzabelowfinalarabic";
static const char glyph_lamalefhamzabelowisolatedarabic[] =
"lamalefhamzabelowisolatedarabic";
static const char glyph_lamalefisolatedarabic[] =
"lamalefisolatedarabic";
static const char glyph_lamalefmaddaabovefinalarabic[] =
"lamalefmaddaabovefinalarabic";
static const char glyph_lamalefmaddaaboveisolatedarabic[] =
"lamalefmaddaaboveisolatedarabic";
static const char glyph_lamarabic[] = "lamarabic";
static const char glyph_lambda[] = "lambda";
static const char glyph_lambdastroke[] = "lambdastroke";
static const char glyph_lamed[] = "lamed";
static const char glyph_lameddagesh[] = "lameddagesh";
static const char glyph_lameddageshhebrew[] = "lameddageshhebrew";
static const char glyph_lamedhebrew[] = "lamedhebrew";
static const char glyph_lamedholam[] = "lamedholam";
static const char glyph_lamedholamdagesh[] = "lamedholamdagesh";
static const char glyph_lamedholamdageshhebrew[] = "lamedholamdageshhebrew";
static const char glyph_lamedholamhebrew[] = "lamedholamhebrew";
static const char glyph_lamfinalarabic[] = "lamfinalarabic";
static const char glyph_lamhahinitialarabic[] = "lamhahinitialarabic";
static const char glyph_laminitialarabic[] = "laminitialarabic";
static const char glyph_lamjeeminitialarabic[] = "lamjeeminitialarabic";
static const char glyph_lamkhahinitialarabic[] = "lamkhahinitialarabic";
static const char glyph_lamlamhehisolatedarabic[] = "lamlamhehisolatedarabic";
static const char glyph_lammedialarabic[] = "lammedialarabic";
static const char glyph_lammeemhahinitialarabic[] = "lammeemhahinitialarabic";
static const char glyph_lammeeminitialarabic[] = "lammeeminitialarabic";
static const char glyph_lammeemjeeminitialarabic[] =
"lammeemjeeminitialarabic";
static const char glyph_lammeemkhahinitialarabic[] =
"lammeemkhahinitialarabic";
static const char glyph_largecircle[] = "largecircle";
static const char glyph_lbar[] = "lbar";
static const char glyph_lbelt[] = "lbelt";
static const char glyph_lbopomofo[] = "lbopomofo";
static const char glyph_lcaron[] = "lcaron";
static const char glyph_lcedilla[] = "lcedilla";
static const char glyph_lcircle[] = "lcircle";
static const char glyph_lcircumflexbelow[] = "lcircumflexbelow";
static const char glyph_lcommaaccent[] = "lcommaaccent";
static const char glyph_ldot[] = "ldot";
static const char glyph_ldotaccent[] = "ldotaccent";
static const char glyph_ldotbelow[] = "ldotbelow";
static const char glyph_ldotbelowmacron[] = "ldotbelowmacron";
static const char glyph_leftangleabovecmb[] = "leftangleabovecmb";
static const char glyph_lefttackbelowcmb[] = "lefttackbelowcmb";
static const char glyph_less[] = "less";
static const char glyph_lessequal[] = "lessequal";
static const char glyph_lessequalorgreater[] = "lessequalorgreater";
static const char glyph_lessmonospace[] = "lessmonospace";
static const char glyph_lessorequivalent[] = "lessorequivalent";
static const char glyph_lessorgreater[] = "lessorgreater";
static const char glyph_lessoverequal[] = "lessoverequal";
static const char glyph_lesssmall[] = "lesssmall";
static const char glyph_lezh[] = "lezh";
static const char glyph_lfblock[] = "lfblock";
static const char glyph_lhookretroflex[] = "lhookretroflex";
static const char glyph_lira[] = "lira";
static const char glyph_liwnarmenian[] = "liwnarmenian";
static const char glyph_lj[] = "lj";
static const char glyph_ljecyrillic[] = "ljecyrillic";
static const char glyph_ll[] = "ll";
static const char glyph_lladeva[] = "lladeva";
static const char glyph_llagujarati[] = "llagujarati";
static const char glyph_llinebelow[] = "llinebelow";
static const char glyph_llladeva[] = "llladeva";
static const char glyph_llvocalicbengali[] = "llvocalicbengali";
static const char glyph_llvocalicdeva[] = "llvocalicdeva";
static const char glyph_llvocalicvowelsignbengali[] =
"llvocalicvowelsignbengali";
static const char glyph_llvocalicvowelsigndeva[] = "llvocalicvowelsigndeva";
static const char glyph_lmiddletilde[] = "lmiddletilde";
static const char glyph_lmonospace[] = "lmonospace";
static const char glyph_lmsquare[] = "lmsquare";
static const char glyph_lochulathai[] = "lochulathai";
static const char glyph_logicaland[] = "logicaland";
static const char glyph_logicalnot[] = "logicalnot";
static const char glyph_logicalnotreversed[] = "logicalnotreversed";
static const char glyph_logicalor[] = "logicalor";
static const char glyph_lolingthai[] = "lolingthai";
static const char glyph_longs[] = "longs";
static const char glyph_lowlinecenterline[] = "lowlinecenterline";
static const char glyph_lowlinecmb[] = "lowlinecmb";
static const char glyph_lowlinedashed[] = "lowlinedashed";
static const char glyph_lozenge[] = "lozenge";
static const char glyph_lparen[] = "lparen";
static const char glyph_lslash[] = "lslash";
static const char glyph_lsquare[] = "lsquare";
static const char glyph_lsuperior[] = "lsuperior";
static const char glyph_ltshade[] = "ltshade";
static const char glyph_luthai[] = "luthai";
static const char glyph_lvocalicbengali[] = "lvocalicbengali";
static const char glyph_lvocalicdeva[] = "lvocalicdeva";
static const char glyph_lvocalicvowelsignbengali[] =
"lvocalicvowelsignbengali";
static const char glyph_lvocalicvowelsigndeva[] = "lvocalicvowelsigndeva";
static const char glyph_lxsquare[] = "lxsquare";
static const char glyph_m[] = "m";
static const char glyph_mabengali[] = "mabengali";
static const char glyph_macron[] = "macron";
static const char glyph_macronbelowcmb[] = "macronbelowcmb";
static const char glyph_macroncmb[] = "macroncmb";
static const char glyph_macronlowmod[] = "macronlowmod";
static const char glyph_macronmonospace[] = "macronmonospace";
static const char glyph_macute[] = "macute";
static const char glyph_madeva[] = "madeva";
static const char glyph_magujarati[] = "magujarati";
static const char glyph_magurmukhi[] = "magurmukhi";
static const char glyph_mahapakhhebrew[] = "mahapakhhebrew";
static const char glyph_mahapakhlefthebrew[] = "mahapakhlefthebrew";
static const char glyph_mahiragana[] = "mahiragana";
static const char glyph_maichattawalowleftthai[] = "maichattawalowleftthai";
static const char glyph_maichattawalowrightthai[] = "maichattawalowrightthai";
static const char glyph_maichattawathai[] = "maichattawathai";
static const char glyph_maichattawaupperleftthai[] =
"maichattawaupperleftthai";
static const char glyph_maieklowleftthai[] = "maieklowleftthai";
static const char glyph_maieklowrightthai[] = "maieklowrightthai";
static const char glyph_maiekthai[] = "maiekthai";
static const char glyph_maiekupperleftthai[] = "maiekupperleftthai";
static const char glyph_maihanakatleftthai[] = "maihanakatleftthai";
static const char glyph_maihanakatthai[] = "maihanakatthai";
static const char glyph_maitaikhuleftthai[] = "maitaikhuleftthai";
static const char glyph_maitaikhuthai[] = "maitaikhuthai";
static const char glyph_maitholowleftthai[] = "maitholowleftthai";
static const char glyph_maitholowrightthai[] = "maitholowrightthai";
static const char glyph_maithothai[] = "maithothai";
static const char glyph_maithoupperleftthai[] = "maithoupperleftthai";
static const char glyph_maitrilowleftthai[] = "maitrilowleftthai";
static const char glyph_maitrilowrightthai[] = "maitrilowrightthai";
static const char glyph_maitrithai[] = "maitrithai";
static const char glyph_maitriupperleftthai[] = "maitriupperleftthai";
static const char glyph_maiyamokthai[] = "maiyamokthai";
static const char glyph_makatakana[] = "makatakana";
static const char glyph_makatakanahalfwidth[] = "makatakanahalfwidth";
static const char glyph_male[] = "male";
static const char glyph_mansyonsquare[] = "mansyonsquare";
static const char glyph_maqafhebrew[] = "maqafhebrew";
static const char glyph_mars[] = "mars";
static const char glyph_masoracirclehebrew[] = "masoracirclehebrew";
static const char glyph_masquare[] = "masquare";
static const char glyph_mbopomofo[] = "mbopomofo";
static const char glyph_mbsquare[] = "mbsquare";
static const char glyph_mcircle[] = "mcircle";
static const char glyph_mcubedsquare[] = "mcubedsquare";
static const char glyph_mdotaccent[] = "mdotaccent";
static const char glyph_mdotbelow[] = "mdotbelow";
static const char glyph_meemarabic[] = "meemarabic";
static const char glyph_meemfinalarabic[] = "meemfinalarabic";
static const char glyph_meeminitialarabic[] = "meeminitialarabic";
static const char glyph_meemmedialarabic[] = "meemmedialarabic";
static const char glyph_meemmeeminitialarabic[] = "meemmeeminitialarabic";
static const char glyph_meemmeemisolatedarabic[] = "meemmeemisolatedarabic";
static const char glyph_meetorusquare[] = "meetorusquare";
static const char glyph_mehiragana[] = "mehiragana";
static const char glyph_meizierasquare[] = "meizierasquare";
static const char glyph_mekatakana[] = "mekatakana";
static const char glyph_mekatakanahalfwidth[] = "mekatakanahalfwidth";
static const char glyph_mem[] = "mem";
static const char glyph_memdagesh[] = "memdagesh";
static const char glyph_memdageshhebrew[] = "memdageshhebrew";
static const char glyph_memhebrew[] = "memhebrew";
static const char glyph_menarmenian[] = "menarmenian";
static const char glyph_merkhahebrew[] = "merkhahebrew";
static const char glyph_merkhakefulahebrew[] = "merkhakefulahebrew";
static const char glyph_merkhakefulalefthebrew[] = "merkhakefulalefthebrew";
static const char glyph_merkhalefthebrew[] = "merkhalefthebrew";
static const char glyph_mhook[] = "mhook";
static const char glyph_mhzsquare[] = "mhzsquare";
static const char glyph_middledotkatakanahalfwidth[] =
"middledotkatakanahalfwidth";
static const char glyph_middot[] = "middot";
static const char glyph_mieumacirclekorean[] = "mieumacirclekorean";
static const char glyph_mieumaparenkorean[] = "mieumaparenkorean";
static const char glyph_mieumcirclekorean[] = "mieumcirclekorean";
static const char glyph_mieumkorean[] = "mieumkorean";
static const char glyph_mieumpansioskorean[] = "mieumpansioskorean";
static const char glyph_mieumparenkorean[] = "mieumparenkorean";
static const char glyph_mieumpieupkorean[] = "mieumpieupkorean";
static const char glyph_mieumsioskorean[] = "mieumsioskorean";
static const char glyph_mihiragana[] = "mihiragana";
static const char glyph_mikatakana[] = "mikatakana";
static const char glyph_mikatakanahalfwidth[] = "mikatakanahalfwidth";
static const char glyph_minus[] = "minus";
static const char glyph_minusbelowcmb[] = "minusbelowcmb";
static const char glyph_minuscircle[] = "minuscircle";
static const char glyph_minusmod[] = "minusmod";
static const char glyph_minusplus[] = "minusplus";
static const char glyph_minute[] = "minute";
static const char glyph_miribaarusquare[] = "miribaarusquare";
static const char glyph_mirisquare[] = "mirisquare";
static const char glyph_mlonglegturned[] = "mlonglegturned";
static const char glyph_mlsquare[] = "mlsquare";
static const char glyph_mmcubedsquare[] = "mmcubedsquare";
static const char glyph_mmonospace[] = "mmonospace";
static const char glyph_mmsquaredsquare[] = "mmsquaredsquare";
static const char glyph_mohiragana[] = "mohiragana";
static const char glyph_mohmsquare[] = "mohmsquare";
static const char glyph_mokatakana[] = "mokatakana";
static const char glyph_mokatakanahalfwidth[] = "mokatakanahalfwidth";
static const char glyph_molsquare[] = "molsquare";
static const char glyph_momathai[] = "momathai";
static const char glyph_moverssquare[] = "moverssquare";
static const char glyph_moverssquaredsquare[] = "moverssquaredsquare";
static const char glyph_mparen[] = "mparen";
static const char glyph_mpasquare[] = "mpasquare";
static const char glyph_mssquare[] = "mssquare";
static const char glyph_msuperior[] = "msuperior";
static const char glyph_mturned[] = "mturned";
static const char glyph_mu[] = "mu";
static const char glyph_mu1[] = "mu1";
static const char glyph_muasquare[] = "muasquare";
static const char glyph_muchgreater[] = "muchgreater";
static const char glyph_muchless[] = "muchless";
static const char glyph_mufsquare[] = "mufsquare";
static const char glyph_mugreek[] = "mugreek";
static const char glyph_mugsquare[] = "mugsquare";
static const char glyph_muhiragana[] = "muhiragana";
static const char glyph_mukatakana[] = "mukatakana";
static const char glyph_mukatakanahalfwidth[] = "mukatakanahalfwidth";
static const char glyph_mulsquare[] = "mulsquare";
static const char glyph_multiply[] = "multiply";
static const char glyph_mumsquare[] = "mumsquare";
static const char glyph_munahhebrew[] = "munahhebrew";
static const char glyph_munahlefthebrew[] = "munahlefthebrew";
static const char glyph_musicalnote[] = "musicalnote";
static const char glyph_musicalnotedbl[] = "musicalnotedbl";
static const char glyph_musicflatsign[] = "musicflatsign";
static const char glyph_musicsharpsign[] = "musicsharpsign";
static const char glyph_mussquare[] = "mussquare";
static const char glyph_muvsquare[] = "muvsquare";
static const char glyph_muwsquare[] = "muwsquare";
static const char glyph_mvmegasquare[] = "mvmegasquare";
static const char glyph_mvsquare[] = "mvsquare";
static const char glyph_mwmegasquare[] = "mwmegasquare";
static const char glyph_mwsquare[] = "mwsquare";
static const char glyph_n[] = "n";
static const char glyph_nabengali[] = "nabengali";
static const char glyph_nabla[] = "nabla";
static const char glyph_nacute[] = "nacute";
static const char glyph_nadeva[] = "nadeva";
static const char glyph_nagujarati[] = "nagujarati";
static const char glyph_nagurmukhi[] = "nagurmukhi";
static const char glyph_nahiragana[] = "nahiragana";
static const char glyph_nakatakana[] = "nakatakana";
static const char glyph_nakatakanahalfwidth[] = "nakatakanahalfwidth";
static const char glyph_napostrophe[] = "napostrophe";
static const char glyph_nasquare[] = "nasquare";
static const char glyph_nbopomofo[] = "nbopomofo";
static const char glyph_nbspace[] = "nbspace";
static const char glyph_ncaron[] = "ncaron";
static const char glyph_ncedilla[] = "ncedilla";
static const char glyph_ncircle[] = "ncircle";
static const char glyph_ncircumflexbelow[] = "ncircumflexbelow";
static const char glyph_ncommaaccent[] = "ncommaaccent";
static const char glyph_ndotaccent[] = "ndotaccent";
static const char glyph_ndotbelow[] = "ndotbelow";
static const char glyph_nehiragana[] = "nehiragana";
static const char glyph_nekatakana[] = "nekatakana";
static const char glyph_nekatakanahalfwidth[] = "nekatakanahalfwidth";
static const char glyph_newsheqelsign[] = "newsheqelsign";
static const char glyph_nfsquare[] = "nfsquare";
static const char glyph_ngabengali[] = "ngabengali";
static const char glyph_ngadeva[] = "ngadeva";
static const char glyph_ngagujarati[] = "ngagujarati";
static const char glyph_ngagurmukhi[] = "ngagurmukhi";
static const char glyph_ngonguthai[] = "ngonguthai";
static const char glyph_nhiragana[] = "nhiragana";
static const char glyph_nhookleft[] = "nhookleft";
static const char glyph_nhookretroflex[] = "nhookretroflex";
static const char glyph_nieunacirclekorean[] = "nieunacirclekorean";
static const char glyph_nieunaparenkorean[] = "nieunaparenkorean";
static const char glyph_nieuncieuckorean[] = "nieuncieuckorean";
static const char glyph_nieuncirclekorean[] = "nieuncirclekorean";
static const char glyph_nieunhieuhkorean[] = "nieunhieuhkorean";
static const char glyph_nieunkorean[] = "nieunkorean";
static const char glyph_nieunpansioskorean[] = "nieunpansioskorean";
static const char glyph_nieunparenkorean[] = "nieunparenkorean";
static const char glyph_nieunsioskorean[] = "nieunsioskorean";
static const char glyph_nieuntikeutkorean[] = "nieuntikeutkorean";
static const char glyph_nihiragana[] = "nihiragana";
static const char glyph_nikatakana[] = "nikatakana";
static const char glyph_nikatakanahalfwidth[] = "nikatakanahalfwidth";
static const char glyph_nikhahitleftthai[] = "nikhahitleftthai";
static const char glyph_nikhahitthai[] = "nikhahitthai";
static const char glyph_nine[] = "nine";
static const char glyph_ninearabic[] = "ninearabic";
static const char glyph_ninebengali[] = "ninebengali";
static const char glyph_ninecircle[] = "ninecircle";
static const char glyph_ninecircleinversesansserif[] =
"ninecircleinversesansserif";
static const char glyph_ninedeva[] = "ninedeva";
static const char glyph_ninegujarati[] = "ninegujarati";
static const char glyph_ninegurmukhi[] = "ninegurmukhi";
static const char glyph_ninehackarabic[] = "ninehackarabic";
static const char glyph_ninehangzhou[] = "ninehangzhou";
static const char glyph_nineideographicparen[] = "nineideographicparen";
static const char glyph_nineinferior[] = "nineinferior";
static const char glyph_ninemonospace[] = "ninemonospace";
static const char glyph_nineoldstyle[] = "nineoldstyle";
static const char glyph_nineparen[] = "nineparen";
static const char glyph_nineperiod[] = "nineperiod";
static const char glyph_ninepersian[] = "ninepersian";
static const char glyph_nineroman[] = "nineroman";
static const char glyph_ninesuperior[] = "ninesuperior";
static const char glyph_nineteencircle[] = "nineteencircle";
static const char glyph_nineteenparen[] = "nineteenparen";
static const char glyph_nineteenperiod[] = "nineteenperiod";
static const char glyph_ninethai[] = "ninethai";
static const char glyph_nj[] = "nj";
static const char glyph_njecyrillic[] = "njecyrillic";
static const char glyph_nkatakana[] = "nkatakana";
static const char glyph_nkatakanahalfwidth[] = "nkatakanahalfwidth";
static const char glyph_nlegrightlong[] = "nlegrightlong";
static const char glyph_nlinebelow[] = "nlinebelow";
static const char glyph_nmonospace[] = "nmonospace";
static const char glyph_nmsquare[] = "nmsquare";
static const char glyph_nnabengali[] = "nnabengali";
static const char glyph_nnadeva[] = "nnadeva";
static const char glyph_nnagujarati[] = "nnagujarati";
static const char glyph_nnagurmukhi[] = "nnagurmukhi";
static const char glyph_nnnadeva[] = "nnnadeva";
static const char glyph_nohiragana[] = "nohiragana";
static const char glyph_nokatakana[] = "nokatakana";
static const char glyph_nokatakanahalfwidth[] = "nokatakanahalfwidth";
static const char glyph_nonbreakingspace[] = "nonbreakingspace";
static const char glyph_nonenthai[] = "nonenthai";
static const char glyph_nonuthai[] = "nonuthai";
static const char glyph_noonarabic[] = "noonarabic";
static const char glyph_noonfinalarabic[] = "noonfinalarabic";
static const char glyph_noonghunnaarabic[] = "noonghunnaarabic";
static const char glyph_noonghunnafinalarabic[] = "noonghunnafinalarabic";
static const char glyph_noonhehinitialarabic[] = "noonhehinitialarabic";
static const char glyph_nooninitialarabic[] = "nooninitialarabic";
static const char glyph_noonjeeminitialarabic[] = "noonjeeminitialarabic";
static const char glyph_noonjeemisolatedarabic[] = "noonjeemisolatedarabic";
static const char glyph_noonmedialarabic[] = "noonmedialarabic";
static const char glyph_noonmeeminitialarabic[] = "noonmeeminitialarabic";
static const char glyph_noonmeemisolatedarabic[] = "noonmeemisolatedarabic";
static const char glyph_noonnoonfinalarabic[] = "noonnoonfinalarabic";
static const char glyph_notcontains[] = "notcontains";
static const char glyph_notelement[] = "notelement";
static const char glyph_notelementof[] = "notelementof";
static const char glyph_notequal[] = "notequal";
static const char glyph_notgreater[] = "notgreater";
static const char glyph_notgreaternorequal[] = "notgreaternorequal";
static const char glyph_notgreaternorless[] = "notgreaternorless";
static const char glyph_notidentical[] = "notidentical";
static const char glyph_notless[] = "notless";
static const char glyph_notlessnorequal[] = "notlessnorequal";
static const char glyph_notparallel[] = "notparallel";
static const char glyph_notprecedes[] = "notprecedes";
static const char glyph_notsubset[] = "notsubset";
static const char glyph_notsucceeds[] = "notsucceeds";
static const char glyph_notsuperset[] = "notsuperset";
static const char glyph_nowarmenian[] = "nowarmenian";
static const char glyph_nparen[] = "nparen";
static const char glyph_nssquare[] = "nssquare";
static const char glyph_nsuperior[] = "nsuperior";
static const char glyph_ntilde[] = "ntilde";
static const char glyph_nu[] = "nu";
static const char glyph_nuhiragana[] = "nuhiragana";
static const char glyph_nukatakana[] = "nukatakana";
static const char glyph_nukatakanahalfwidth[] = "nukatakanahalfwidth";
static const char glyph_nuktabengali[] = "nuktabengali";
static const char glyph_nuktadeva[] = "nuktadeva";
static const char glyph_nuktagujarati[] = "nuktagujarati";
static const char glyph_nuktagurmukhi[] = "nuktagurmukhi";
static const char glyph_numbersign[] = "numbersign";
static const char glyph_numbersignmonospace[] = "numbersignmonospace";
static const char glyph_numbersignsmall[] = "numbersignsmall";
static const char glyph_numeralsigngreek[] = "numeralsigngreek";
static const char glyph_numeralsignlowergreek[] = "numeralsignlowergreek";
static const char glyph_numero[] = "numero";
static const char glyph_nun[] = "nun";
static const char glyph_nundagesh[] = "nundagesh";
static const char glyph_nundageshhebrew[] = "nundageshhebrew";
static const char glyph_nunhebrew[] = "nunhebrew";
static const char glyph_nvsquare[] = "nvsquare";
static const char glyph_nwsquare[] = "nwsquare";
static const char glyph_nyabengali[] = "nyabengali";
static const char glyph_nyadeva[] = "nyadeva";
static const char glyph_nyagujarati[] = "nyagujarati";
static const char glyph_nyagurmukhi[] = "nyagurmukhi";
static const char glyph_o[] = "o";
static const char glyph_oacute[] = "oacute";
static const char glyph_oangthai[] = "oangthai";
static const char glyph_obarred[] = "obarred";
static const char glyph_obarredcyrillic[] = "obarredcyrillic";
static const char glyph_obarreddieresiscyrillic[] = "obarreddieresiscyrillic";
static const char glyph_obengali[] = "obengali";
static const char glyph_obopomofo[] = "obopomofo";
static const char glyph_obreve[] = "obreve";
static const char glyph_ocandradeva[] = "ocandradeva";
static const char glyph_ocandragujarati[] = "ocandragujarati";
static const char glyph_ocandravowelsigndeva[] = "ocandravowelsigndeva";
static const char glyph_ocandravowelsigngujarati[] =
"ocandravowelsigngujarati";
static const char glyph_ocaron[] = "ocaron";
static const char glyph_ocircle[] = "ocircle";
static const char glyph_ocircumflex[] = "ocircumflex";
static const char glyph_ocircumflexacute[] = "ocircumflexacute";
static const char glyph_ocircumflexdotbelow[] = "ocircumflexdotbelow";
static const char glyph_ocircumflexgrave[] = "ocircumflexgrave";
static const char glyph_ocircumflexhookabove[] = "ocircumflexhookabove";
static const char glyph_ocircumflextilde[] = "ocircumflextilde";
static const char glyph_ocyrillic[] = "ocyrillic";
static const char glyph_odblacute[] = "odblacute";
static const char glyph_odblgrave[] = "odblgrave";
static const char glyph_odeva[] = "odeva";
static const char glyph_odieresis[] = "odieresis";
static const char glyph_odieresiscyrillic[] = "odieresiscyrillic";
static const char glyph_odotbelow[] = "odotbelow";
static const char glyph_oe[] = "oe";
static const char glyph_oekorean[] = "oekorean";
static const char glyph_ogonek[] = "ogonek";
static const char glyph_ogonekcmb[] = "ogonekcmb";
static const char glyph_ograve[] = "ograve";
static const char glyph_ogujarati[] = "ogujarati";
static const char glyph_oharmenian[] = "oharmenian";
static const char glyph_ohiragana[] = "ohiragana";
static const char glyph_ohookabove[] = "ohookabove";
static const char glyph_ohorn[] = "ohorn";
static const char glyph_ohornacute[] = "ohornacute";
static const char glyph_ohorndotbelow[] = "ohorndotbelow";
static const char glyph_ohorngrave[] = "ohorngrave";
static const char glyph_ohornhookabove[] = "ohornhookabove";
static const char glyph_ohorntilde[] = "ohorntilde";
static const char glyph_ohungarumlaut[] = "ohungarumlaut";
static const char glyph_oi[] = "oi";
static const char glyph_oinvertedbreve[] = "oinvertedbreve";
static const char glyph_okatakana[] = "okatakana";
static const char glyph_okatakanahalfwidth[] = "okatakanahalfwidth";
static const char glyph_okorean[] = "okorean";
static const char glyph_olehebrew[] = "olehebrew";
static const char glyph_omacron[] = "omacron";
static const char glyph_omacronacute[] = "omacronacute";
static const char glyph_omacrongrave[] = "omacrongrave";
static const char glyph_omdeva[] = "omdeva";
static const char glyph_omega[] = "omega";
static const char glyph_omega1[] = "omega1";
static const char glyph_omegacyrillic[] = "omegacyrillic";
static const char glyph_omegalatinclosed[] = "omegalatinclosed";
static const char glyph_omegaroundcyrillic[] = "omegaroundcyrillic";
static const char glyph_omegatitlocyrillic[] = "omegatitlocyrillic";
static const char glyph_omegatonos[] = "omegatonos";
static const char glyph_omgujarati[] = "omgujarati";
static const char glyph_omicron[] = "omicron";
static const char glyph_omicrontonos[] = "omicrontonos";
static const char glyph_omonospace[] = "omonospace";
static const char glyph_one[] = "one";
static const char glyph_onearabic[] = "onearabic";
static const char glyph_onebengali[] = "onebengali";
static const char glyph_onecircle[] = "onecircle";
static const char glyph_onecircleinversesansserif[] =
"onecircleinversesansserif";
static const char glyph_onedeva[] = "onedeva";
static const char glyph_onedotenleader[] = "onedotenleader";
static const char glyph_oneeighth[] = "oneeighth";
static const char glyph_onefitted[] = "onefitted";
static const char glyph_onegujarati[] = "onegujarati";
static const char glyph_onegurmukhi[] = "onegurmukhi";
static const char glyph_onehackarabic[] = "onehackarabic";
static const char glyph_onehalf[] = "onehalf";
static const char glyph_onehangzhou[] = "onehangzhou";
static const char glyph_oneideographicparen[] = "oneideographicparen";
static const char glyph_oneinferior[] = "oneinferior";
static const char glyph_onemonospace[] = "onemonospace";
static const char glyph_onenumeratorbengali[] = "onenumeratorbengali";
static const char glyph_oneoldstyle[] = "oneoldstyle";
static const char glyph_oneparen[] = "oneparen";
static const char glyph_oneperiod[] = "oneperiod";
static const char glyph_onepersian[] = "onepersian";
static const char glyph_onequarter[] = "onequarter";
static const char glyph_oneroman[] = "oneroman";
static const char glyph_onesuperior[] = "onesuperior";
static const char glyph_onethai[] = "onethai";
static const char glyph_onethird[] = "onethird";
static const char glyph_oogonek[] = "oogonek";
static const char glyph_oogonekmacron[] = "oogonekmacron";
static const char glyph_oogurmukhi[] = "oogurmukhi";
static const char glyph_oomatragurmukhi[] = "oomatragurmukhi";
static const char glyph_oopen[] = "oopen";
static const char glyph_oparen[] = "oparen";
static const char glyph_openbullet[] = "openbullet";
static const char glyph_option[] = "option";
static const char glyph_ordfeminine[] = "ordfeminine";
static const char glyph_ordmasculine[] = "ordmasculine";
static const char glyph_orthogonal[] = "orthogonal";
static const char glyph_oshortdeva[] = "oshortdeva";
static const char glyph_oshortvowelsigndeva[] = "oshortvowelsigndeva";
static const char glyph_oslash[] = "oslash";
static const char glyph_oslashacute[] = "oslashacute";
static const char glyph_osmallhiragana[] = "osmallhiragana";
static const char glyph_osmallkatakana[] = "osmallkatakana";
static const char glyph_osmallkatakanahalfwidth[] = "osmallkatakanahalfwidth";
static const char glyph_ostrokeacute[] = "ostrokeacute";
static const char glyph_osuperior[] = "osuperior";
static const char glyph_otcyrillic[] = "otcyrillic";
static const char glyph_otilde[] = "otilde";
static const char glyph_otildeacute[] = "otildeacute";
static const char glyph_otildedieresis[] = "otildedieresis";
static const char glyph_oubopomofo[] = "oubopomofo";
static const char glyph_overline[] = "overline";
static const char glyph_overlinecenterline[] = "overlinecenterline";
static const char glyph_overlinecmb[] = "overlinecmb";
static const char glyph_overlinedashed[] = "overlinedashed";
static const char glyph_overlinedblwavy[] = "overlinedblwavy";
static const char glyph_overlinewavy[] = "overlinewavy";
static const char glyph_overscore[] = "overscore";
static const char glyph_ovowelsignbengali[] = "ovowelsignbengali";
static const char glyph_ovowelsigndeva[] = "ovowelsigndeva";
static const char glyph_ovowelsigngujarati[] = "ovowelsigngujarati";
static const char glyph_p[] = "p";
static const char glyph_paampssquare[] = "paampssquare";
static const char glyph_paasentosquare[] = "paasentosquare";
static const char glyph_pabengali[] = "pabengali";
static const char glyph_pacute[] = "pacute";
static const char glyph_padeva[] = "padeva";
static const char glyph_pagedown[] = "pagedown";
static const char glyph_pageup[] = "pageup";
static const char glyph_pagujarati[] = "pagujarati";
static const char glyph_pagurmukhi[] = "pagurmukhi";
static const char glyph_pahiragana[] = "pahiragana";
static const char glyph_paiyannoithai[] = "paiyannoithai";
static const char glyph_pakatakana[] = "pakatakana";
static const char glyph_palatalizationcyrilliccmb[] =
"palatalizationcyrilliccmb";
static const char glyph_palochkacyrillic[] = "palochkacyrillic";
static const char glyph_pansioskorean[] = "pansioskorean";
static const char glyph_paragraph[] = "paragraph";
static const char glyph_parallel[] = "parallel";
static const char glyph_parenleft[] = "parenleft";
static const char glyph_parenleftaltonearabic[] = "parenleftaltonearabic";
static const char glyph_parenleftbt[] = "parenleftbt";
static const char glyph_parenleftex[] = "parenleftex";
static const char glyph_parenleftinferior[] = "parenleftinferior";
static const char glyph_parenleftmonospace[] = "parenleftmonospace";
static const char glyph_parenleftsmall[] = "parenleftsmall";
static const char glyph_parenleftsuperior[] = "parenleftsuperior";
static const char glyph_parenlefttp[] = "parenlefttp";
static const char glyph_parenleftvertical[] = "parenleftvertical";
static const char glyph_parenright[] = "parenright";
static const char glyph_parenrightaltonearabic[] = "parenrightaltonearabic";
static const char glyph_parenrightbt[] = "parenrightbt";
static const char glyph_parenrightex[] = "parenrightex";
static const char glyph_parenrightinferior[] = "parenrightinferior";
static const char glyph_parenrightmonospace[] = "parenrightmonospace";
static const char glyph_parenrightsmall[] = "parenrightsmall";
static const char glyph_parenrightsuperior[] = "parenrightsuperior";
static const char glyph_parenrighttp[] = "parenrighttp";
static const char glyph_parenrightvertical[] = "parenrightvertical";
static const char glyph_partialdiff[] = "partialdiff";
static const char glyph_paseqhebrew[] = "paseqhebrew";
static const char glyph_pashtahebrew[] = "pashtahebrew";
static const char glyph_pasquare[] = "pasquare";
static const char glyph_patah[] = "patah";
static const char glyph_patah11[] = "patah11";
static const char glyph_patah1d[] = "patah1d";
static const char glyph_patah2a[] = "patah2a";
static const char glyph_patahhebrew[] = "patahhebrew";
static const char glyph_patahnarrowhebrew[] = "patahnarrowhebrew";
static const char glyph_patahquarterhebrew[] = "patahquarterhebrew";
static const char glyph_patahwidehebrew[] = "patahwidehebrew";
static const char glyph_pazerhebrew[] = "pazerhebrew";
static const char glyph_pbopomofo[] = "pbopomofo";
static const char glyph_pcircle[] = "pcircle";
static const char glyph_pdotaccent[] = "pdotaccent";
static const char glyph_pe[] = "pe";
static const char glyph_pecyrillic[] = "pecyrillic";
static const char glyph_pedagesh[] = "pedagesh";
static const char glyph_pedageshhebrew[] = "pedageshhebrew";
static const char glyph_peezisquare[] = "peezisquare";
static const char glyph_pefinaldageshhebrew[] = "pefinaldageshhebrew";
static const char glyph_peharabic[] = "peharabic";
static const char glyph_peharmenian[] = "peharmenian";
static const char glyph_pehebrew[] = "pehebrew";
static const char glyph_pehfinalarabic[] = "pehfinalarabic";
static const char glyph_pehinitialarabic[] = "pehinitialarabic";
static const char glyph_pehiragana[] = "pehiragana";
static const char glyph_pehmedialarabic[] = "pehmedialarabic";
static const char glyph_pekatakana[] = "pekatakana";
static const char glyph_pemiddlehookcyrillic[] = "pemiddlehookcyrillic";
static const char glyph_perafehebrew[] = "perafehebrew";
static const char glyph_percent[] = "percent";
static const char glyph_percentarabic[] = "percentarabic";
static const char glyph_percentmonospace[] = "percentmonospace";
static const char glyph_percentsmall[] = "percentsmall";
static const char glyph_period[] = "period";
static const char glyph_periodarmenian[] = "periodarmenian";
static const char glyph_periodcentered[] = "periodcentered";
static const char glyph_periodhalfwidth[] = "periodhalfwidth";
static const char glyph_periodinferior[] = "periodinferior";
static const char glyph_periodmonospace[] = "periodmonospace";
static const char glyph_periodsmall[] = "periodsmall";
static const char glyph_periodsuperior[] = "periodsuperior";
static const char glyph_perispomenigreekcmb[] = "perispomenigreekcmb";
static const char glyph_perpendicular[] = "perpendicular";
static const char glyph_perthousand[] = "perthousand";
static const char glyph_peseta[] = "peseta";
static const char glyph_pfsquare[] = "pfsquare";
static const char glyph_phabengali[] = "phabengali";
static const char glyph_phadeva[] = "phadeva";
static const char glyph_phagujarati[] = "phagujarati";
static const char glyph_phagurmukhi[] = "phagurmukhi";
static const char glyph_phi[] = "phi";
static const char glyph_phi1[] = "phi1";
static const char glyph_phieuphacirclekorean[] = "phieuphacirclekorean";
static const char glyph_phieuphaparenkorean[] = "phieuphaparenkorean";
static const char glyph_phieuphcirclekorean[] = "phieuphcirclekorean";
static const char glyph_phieuphkorean[] = "phieuphkorean";
static const char glyph_phieuphparenkorean[] = "phieuphparenkorean";
static const char glyph_philatin[] = "philatin";
static const char glyph_phinthuthai[] = "phinthuthai";
static const char glyph_phisymbolgreek[] = "phisymbolgreek";
static const char glyph_phook[] = "phook";
static const char glyph_phophanthai[] = "phophanthai";
static const char glyph_phophungthai[] = "phophungthai";
static const char glyph_phosamphaothai[] = "phosamphaothai";
static const char glyph_pi[] = "pi";
static const char glyph_pieupacirclekorean[] = "pieupacirclekorean";
static const char glyph_pieupaparenkorean[] = "pieupaparenkorean";
static const char glyph_pieupcieuckorean[] = "pieupcieuckorean";
static const char glyph_pieupcirclekorean[] = "pieupcirclekorean";
static const char glyph_pieupkiyeokkorean[] = "pieupkiyeokkorean";
static const char glyph_pieupkorean[] = "pieupkorean";
static const char glyph_pieupparenkorean[] = "pieupparenkorean";
static const char glyph_pieupsioskiyeokkorean[] = "pieupsioskiyeokkorean";
static const char glyph_pieupsioskorean[] = "pieupsioskorean";
static const char glyph_pieupsiostikeutkorean[] = "pieupsiostikeutkorean";
static const char glyph_pieupthieuthkorean[] = "pieupthieuthkorean";
static const char glyph_pieuptikeutkorean[] = "pieuptikeutkorean";
static const char glyph_pihiragana[] = "pihiragana";
static const char glyph_pikatakana[] = "pikatakana";
static const char glyph_pisymbolgreek[] = "pisymbolgreek";
static const char glyph_piwrarmenian[] = "piwrarmenian";
static const char glyph_plus[] = "plus";
static const char glyph_plusbelowcmb[] = "plusbelowcmb";
static const char glyph_pluscircle[] = "pluscircle";
static const char glyph_plusminus[] = "plusminus";
static const char glyph_plusmod[] = "plusmod";
static const char glyph_plusmonospace[] = "plusmonospace";
static const char glyph_plussmall[] = "plussmall";
static const char glyph_plussuperior[] = "plussuperior";
static const char glyph_pmonospace[] = "pmonospace";
static const char glyph_pmsquare[] = "pmsquare";
static const char glyph_pohiragana[] = "pohiragana";
static const char glyph_pointingindexdownwhite[] = "pointingindexdownwhite";
static const char glyph_pointingindexleftwhite[] = "pointingindexleftwhite";
static const char glyph_pointingindexrightwhite[] = "pointingindexrightwhite";
static const char glyph_pointingindexupwhite[] = "pointingindexupwhite";
static const char glyph_pokatakana[] = "pokatakana";
static const char glyph_poplathai[] = "poplathai";
static const char glyph_postalmark[] = "postalmark";
static const char glyph_postalmarkface[] = "postalmarkface";
static const char glyph_pparen[] = "pparen";
static const char glyph_precedes[] = "precedes";
static const char glyph_prescription[] = "prescription";
static const char glyph_primemod[] = "primemod";
static const char glyph_primereversed[] = "primereversed";
static const char glyph_product[] = "product";
static const char glyph_projective[] = "projective";
static const char glyph_prolongedkana[] = "prolongedkana";
static const char glyph_propellor[] = "propellor";
static const char glyph_propersubset[] = "propersubset";
static const char glyph_propersuperset[] = "propersuperset";
static const char glyph_proportion[] = "proportion";
static const char glyph_proportional[] = "proportional";
static const char glyph_psi[] = "psi";
static const char glyph_psicyrillic[] = "psicyrillic";
static const char glyph_psilipneumatacyrilliccmb[] =
"psilipneumatacyrilliccmb";
static const char glyph_pssquare[] = "pssquare";
static const char glyph_puhiragana[] = "puhiragana";
static const char glyph_pukatakana[] = "pukatakana";
static const char glyph_pvsquare[] = "pvsquare";
static const char glyph_pwsquare[] = "pwsquare";
static const char glyph_q[] = "q";
static const char glyph_qadeva[] = "qadeva";
static const char glyph_qadmahebrew[] = "qadmahebrew";
static const char glyph_qafarabic[] = "qafarabic";
static const char glyph_qaffinalarabic[] = "qaffinalarabic";
static const char glyph_qafinitialarabic[] = "qafinitialarabic";
static const char glyph_qafmedialarabic[] = "qafmedialarabic";
static const char glyph_qamats[] = "qamats";
static const char glyph_qamats10[] = "qamats10";
static const char glyph_qamats1a[] = "qamats1a";
static const char glyph_qamats1c[] = "qamats1c";
static const char glyph_qamats27[] = "qamats27";
static const char glyph_qamats29[] = "qamats29";
static const char glyph_qamats33[] = "qamats33";
static const char glyph_qamatsde[] = "qamatsde";
static const char glyph_qamatshebrew[] = "qamatshebrew";
static const char glyph_qamatsnarrowhebrew[] = "qamatsnarrowhebrew";
static const char glyph_qamatsqatanhebrew[] = "qamatsqatanhebrew";
static const char glyph_qamatsqatannarrowhebrew[] = "qamatsqatannarrowhebrew";
static const char glyph_qamatsqatanquarterhebrew[] =
"qamatsqatanquarterhebrew";
static const char glyph_qamatsqatanwidehebrew[] = "qamatsqatanwidehebrew";
static const char glyph_qamatsquarterhebrew[] = "qamatsquarterhebrew";
static const char glyph_qamatswidehebrew[] = "qamatswidehebrew";
static const char glyph_qarneyparahebrew[] = "qarneyparahebrew";
static const char glyph_qbopomofo[] = "qbopomofo";
static const char glyph_qcircle[] = "qcircle";
static const char glyph_qhook[] = "qhook";
static const char glyph_qmonospace[] = "qmonospace";
static const char glyph_qof[] = "qof";
static const char glyph_qofdagesh[] = "qofdagesh";
static const char glyph_qofdageshhebrew[] = "qofdageshhebrew";
static const char glyph_qofhatafpatah[] = "qofhatafpatah";
static const char glyph_qofhatafpatahhebrew[] = "qofhatafpatahhebrew";
static const char glyph_qofhatafsegol[] = "qofhatafsegol";
static const char glyph_qofhatafsegolhebrew[] = "qofhatafsegolhebrew";
static const char glyph_qofhebrew[] = "qofhebrew";
static const char glyph_qofhiriq[] = "qofhiriq";
static const char glyph_qofhiriqhebrew[] = "qofhiriqhebrew";
static const char glyph_qofholam[] = "qofholam";
static const char glyph_qofholamhebrew[] = "qofholamhebrew";
static const char glyph_qofpatah[] = "qofpatah";
static const char glyph_qofpatahhebrew[] = "qofpatahhebrew";
static const char glyph_qofqamats[] = "qofqamats";
static const char glyph_qofqamatshebrew[] = "qofqamatshebrew";
static const char glyph_qofqubuts[] = "qofqubuts";
static const char glyph_qofqubutshebrew[] = "qofqubutshebrew";
static const char glyph_qofsegol[] = "qofsegol";
static const char glyph_qofsegolhebrew[] = "qofsegolhebrew";
static const char glyph_qofsheva[] = "qofsheva";
static const char glyph_qofshevahebrew[] = "qofshevahebrew";
static const char glyph_qoftsere[] = "qoftsere";
static const char glyph_qoftserehebrew[] = "qoftserehebrew";
static const char glyph_qparen[] = "qparen";
static const char glyph_quarternote[] = "quarternote";
static const char glyph_qubuts[] = "qubuts";
static const char glyph_qubuts18[] = "qubuts18";
static const char glyph_qubuts25[] = "qubuts25";
static const char glyph_qubuts31[] = "qubuts31";
static const char glyph_qubutshebrew[] = "qubutshebrew";
static const char glyph_qubutsnarrowhebrew[] = "qubutsnarrowhebrew";
static const char glyph_qubutsquarterhebrew[] = "qubutsquarterhebrew";
static const char glyph_qubutswidehebrew[] = "qubutswidehebrew";
static const char glyph_question[] = "question";
static const char glyph_questionarabic[] = "questionarabic";
static const char glyph_questionarmenian[] = "questionarmenian";
static const char glyph_questiondown[] = "questiondown";
static const char glyph_questiondownsmall[] = "questiondownsmall";
static const char glyph_questiongreek[] = "questiongreek";
static const char glyph_questionmonospace[] = "questionmonospace";
static const char glyph_questionsmall[] = "questionsmall";
static const char glyph_quotedbl[] = "quotedbl";
static const char glyph_quotedblbase[] = "quotedblbase";
static const char glyph_quotedblleft[] = "quotedblleft";
static const char glyph_quotedblmonospace[] = "quotedblmonospace";
static const char glyph_quotedblprime[] = "quotedblprime";
static const char glyph_quotedblprimereversed[] = "quotedblprimereversed";
static const char glyph_quotedblright[] = "quotedblright";
static const char glyph_quoteleft[] = "quoteleft";
static const char glyph_quoteleftreversed[] = "quoteleftreversed";
static const char glyph_quotereversed[] = "quotereversed";
static const char glyph_quoteright[] = "quoteright";
static const char glyph_quoterightn[] = "quoterightn";
static const char glyph_quotesinglbase[] = "quotesinglbase";
static const char glyph_quotesingle[] = "quotesingle";
static const char glyph_quotesinglemonospace[] = "quotesinglemonospace";
static const char glyph_r[] = "r";
static const char glyph_raarmenian[] = "raarmenian";
static const char glyph_rabengali[] = "rabengali";
static const char glyph_racute[] = "racute";
static const char glyph_radeva[] = "radeva";
static const char glyph_radical[] = "radical";
static const char glyph_radicalex[] = "radicalex";
static const char glyph_radoverssquare[] = "radoverssquare";
static const char glyph_radoverssquaredsquare[] = "radoverssquaredsquare";
static const char glyph_radsquare[] = "radsquare";
static const char glyph_rafe[] = "rafe";
static const char glyph_rafehebrew[] = "rafehebrew";
static const char glyph_ragujarati[] = "ragujarati";
static const char glyph_ragurmukhi[] = "ragurmukhi";
static const char glyph_rahiragana[] = "rahiragana";
static const char glyph_rakatakana[] = "rakatakana";
static const char glyph_rakatakanahalfwidth[] = "rakatakanahalfwidth";
static const char glyph_ralowerdiagonalbengali[] = "ralowerdiagonalbengali";
static const char glyph_ramiddlediagonalbengali[] = "ramiddlediagonalbengali";
static const char glyph_ramshorn[] = "ramshorn";
static const char glyph_ratio[] = "ratio";
static const char glyph_rbopomofo[] = "rbopomofo";
static const char glyph_rcaron[] = "rcaron";
static const char glyph_rcedilla[] = "rcedilla";
static const char glyph_rcircle[] = "rcircle";
static const char glyph_rcommaaccent[] = "rcommaaccent";
static const char glyph_rdblgrave[] = "rdblgrave";
static const char glyph_rdotaccent[] = "rdotaccent";
static const char glyph_rdotbelow[] = "rdotbelow";
static const char glyph_rdotbelowmacron[] = "rdotbelowmacron";
static const char glyph_referencemark[] = "referencemark";
static const char glyph_reflexsubset[] = "reflexsubset";
static const char glyph_reflexsuperset[] = "reflexsuperset";
static const char glyph_registered[] = "registered";
static const char glyph_registersans[] = "registersans";
static const char glyph_registerserif[] = "registerserif";
static const char glyph_reharabic[] = "reharabic";
static const char glyph_reharmenian[] = "reharmenian";
static const char glyph_rehfinalarabic[] = "rehfinalarabic";
static const char glyph_rehiragana[] = "rehiragana";
static const char glyph_rehyehaleflamarabic[] = "rehyehaleflamarabic";
static const char glyph_rekatakana[] = "rekatakana";
static const char glyph_rekatakanahalfwidth[] = "rekatakanahalfwidth";
static const char glyph_resh[] = "resh";
static const char glyph_reshdageshhebrew[] = "reshdageshhebrew";
static const char glyph_reshhatafpatah[] = "reshhatafpatah";
static const char glyph_reshhatafpatahhebrew[] = "reshhatafpatahhebrew";
static const char glyph_reshhatafsegol[] = "reshhatafsegol";
static const char glyph_reshhatafsegolhebrew[] = "reshhatafsegolhebrew";
static const char glyph_reshhebrew[] = "reshhebrew";
static const char glyph_reshhiriq[] = "reshhiriq";
static const char glyph_reshhiriqhebrew[] = "reshhiriqhebrew";
static const char glyph_reshholam[] = "reshholam";
static const char glyph_reshholamhebrew[] = "reshholamhebrew";
static const char glyph_reshpatah[] = "reshpatah";
static const char glyph_reshpatahhebrew[] = "reshpatahhebrew";
static const char glyph_reshqamats[] = "reshqamats";
static const char glyph_reshqamatshebrew[] = "reshqamatshebrew";
static const char glyph_reshqubuts[] = "reshqubuts";
static const char glyph_reshqubutshebrew[] = "reshqubutshebrew";
static const char glyph_reshsegol[] = "reshsegol";
static const char glyph_reshsegolhebrew[] = "reshsegolhebrew";
static const char glyph_reshsheva[] = "reshsheva";
static const char glyph_reshshevahebrew[] = "reshshevahebrew";
static const char glyph_reshtsere[] = "reshtsere";
static const char glyph_reshtserehebrew[] = "reshtserehebrew";
static const char glyph_reversedtilde[] = "reversedtilde";
static const char glyph_reviahebrew[] = "reviahebrew";
static const char glyph_reviamugrashhebrew[] = "reviamugrashhebrew";
static const char glyph_revlogicalnot[] = "revlogicalnot";
static const char glyph_rfishhook[] = "rfishhook";
static const char glyph_rfishhookreversed[] = "rfishhookreversed";
static const char glyph_rhabengali[] = "rhabengali";
static const char glyph_rhadeva[] = "rhadeva";
static const char glyph_rho[] = "rho";
static const char glyph_rhook[] = "rhook";
static const char glyph_rhookturned[] = "rhookturned";
static const char glyph_rhookturnedsuperior[] = "rhookturnedsuperior";
static const char glyph_rhosymbolgreek[] = "rhosymbolgreek";
static const char glyph_rhotichookmod[] = "rhotichookmod";
static const char glyph_rieulacirclekorean[] = "rieulacirclekorean";
static const char glyph_rieulaparenkorean[] = "rieulaparenkorean";
static const char glyph_rieulcirclekorean[] = "rieulcirclekorean";
static const char glyph_rieulhieuhkorean[] = "rieulhieuhkorean";
static const char glyph_rieulkiyeokkorean[] = "rieulkiyeokkorean";
static const char glyph_rieulkiyeoksioskorean[] = "rieulkiyeoksioskorean";
static const char glyph_rieulkorean[] = "rieulkorean";
static const char glyph_rieulmieumkorean[] = "rieulmieumkorean";
static const char glyph_rieulpansioskorean[] = "rieulpansioskorean";
static const char glyph_rieulparenkorean[] = "rieulparenkorean";
static const char glyph_rieulphieuphkorean[] = "rieulphieuphkorean";
static const char glyph_rieulpieupkorean[] = "rieulpieupkorean";
static const char glyph_rieulpieupsioskorean[] = "rieulpieupsioskorean";
static const char glyph_rieulsioskorean[] = "rieulsioskorean";
static const char glyph_rieulthieuthkorean[] = "rieulthieuthkorean";
static const char glyph_rieultikeutkorean[] = "rieultikeutkorean";
static const char glyph_rieulyeorinhieuhkorean[] = "rieulyeorinhieuhkorean";
static const char glyph_rightangle[] = "rightangle";
static const char glyph_righttackbelowcmb[] = "righttackbelowcmb";
static const char glyph_righttriangle[] = "righttriangle";
static const char glyph_rihiragana[] = "rihiragana";
static const char glyph_rikatakana[] = "rikatakana";
static const char glyph_rikatakanahalfwidth[] = "rikatakanahalfwidth";
static const char glyph_ring[] = "ring";
static const char glyph_ringbelowcmb[] = "ringbelowcmb";
static const char glyph_ringcmb[] = "ringcmb";
static const char glyph_ringhalfleft[] = "ringhalfleft";
static const char glyph_ringhalfleftarmenian[] = "ringhalfleftarmenian";
static const char glyph_ringhalfleftbelowcmb[] = "ringhalfleftbelowcmb";
static const char glyph_ringhalfleftcentered[] = "ringhalfleftcentered";
static const char glyph_ringhalfright[] = "ringhalfright";
static const char glyph_ringhalfrightbelowcmb[] = "ringhalfrightbelowcmb";
static const char glyph_ringhalfrightcentered[] = "ringhalfrightcentered";
static const char glyph_rinvertedbreve[] = "rinvertedbreve";
static const char glyph_rittorusquare[] = "rittorusquare";
static const char glyph_rlinebelow[] = "rlinebelow";
static const char glyph_rlongleg[] = "rlongleg";
static const char glyph_rlonglegturned[] = "rlonglegturned";
static const char glyph_rmonospace[] = "rmonospace";
static const char glyph_rohiragana[] = "rohiragana";
static const char glyph_rokatakana[] = "rokatakana";
static const char glyph_rokatakanahalfwidth[] = "rokatakanahalfwidth";
static const char glyph_roruathai[] = "roruathai";
static const char glyph_rparen[] = "rparen";
static const char glyph_rrabengali[] = "rrabengali";
static const char glyph_rradeva[] = "rradeva";
static const char glyph_rragurmukhi[] = "rragurmukhi";
static const char glyph_rreharabic[] = "rreharabic";
static const char glyph_rrehfinalarabic[] = "rrehfinalarabic";
static const char glyph_rrvocalicbengali[] = "rrvocalicbengali";
static const char glyph_rrvocalicdeva[] = "rrvocalicdeva";
static const char glyph_rrvocalicgujarati[] = "rrvocalicgujarati";
static const char glyph_rrvocalicvowelsignbengali[] =
"rrvocalicvowelsignbengali";
static const char glyph_rrvocalicvowelsigndeva[] = "rrvocalicvowelsigndeva";
static const char glyph_rrvocalicvowelsigngujarati[] =
"rrvocalicvowelsigngujarati";
static const char glyph_rsuperior[] = "rsuperior";
static const char glyph_rtblock[] = "rtblock";
static const char glyph_rturned[] = "rturned";
static const char glyph_rturnedsuperior[] = "rturnedsuperior";
static const char glyph_ruhiragana[] = "ruhiragana";
static const char glyph_rukatakana[] = "rukatakana";
static const char glyph_rukatakanahalfwidth[] = "rukatakanahalfwidth";
static const char glyph_rupeemarkbengali[] = "rupeemarkbengali";
static const char glyph_rupeesignbengali[] = "rupeesignbengali";
static const char glyph_rupiah[] = "rupiah";
static const char glyph_ruthai[] = "ruthai";
static const char glyph_rvocalicbengali[] = "rvocalicbengali";
static const char glyph_rvocalicdeva[] = "rvocalicdeva";
static const char glyph_rvocalicgujarati[] = "rvocalicgujarati";
static const char glyph_rvocalicvowelsignbengali[] =
"rvocalicvowelsignbengali";
static const char glyph_rvocalicvowelsigndeva[] = "rvocalicvowelsigndeva";
static const char glyph_rvocalicvowelsigngujarati[] =
"rvocalicvowelsigngujarati";
static const char glyph_s[] = "s";
static const char glyph_sabengali[] = "sabengali";
static const char glyph_sacute[] = "sacute";
static const char glyph_sacutedotaccent[] = "sacutedotaccent";
static const char glyph_sadarabic[] = "sadarabic";
static const char glyph_sadeva[] = "sadeva";
static const char glyph_sadfinalarabic[] = "sadfinalarabic";
static const char glyph_sadinitialarabic[] = "sadinitialarabic";
static const char glyph_sadmedialarabic[] = "sadmedialarabic";
static const char glyph_sagujarati[] = "sagujarati";
static const char glyph_sagurmukhi[] = "sagurmukhi";
static const char glyph_sahiragana[] = "sahiragana";
static const char glyph_sakatakana[] = "sakatakana";
static const char glyph_sakatakanahalfwidth[] = "sakatakanahalfwidth";
static const char glyph_sallallahoualayhewasallamarabic[] =
"sallallahoualayhewasallamarabic";
static const char glyph_samekh[] = "samekh";
static const char glyph_samekhdagesh[] = "samekhdagesh";
static const char glyph_samekhdageshhebrew[] = "samekhdageshhebrew";
static const char glyph_samekhhebrew[] = "samekhhebrew";
static const char glyph_saraaathai[] = "saraaathai";
static const char glyph_saraaethai[] = "saraaethai";
static const char glyph_saraaimaimalaithai[] = "saraaimaimalaithai";
static const char glyph_saraaimaimuanthai[] = "saraaimaimuanthai";
static const char glyph_saraamthai[] = "saraamthai";
static const char glyph_saraathai[] = "saraathai";
static const char glyph_saraethai[] = "saraethai";
static const char glyph_saraiileftthai[] = "saraiileftthai";
static const char glyph_saraiithai[] = "saraiithai";
static const char glyph_saraileftthai[] = "saraileftthai";
static const char glyph_saraithai[] = "saraithai";
static const char glyph_saraothai[] = "saraothai";
static const char glyph_saraueeleftthai[] = "saraueeleftthai";
static const char glyph_saraueethai[] = "saraueethai";
static const char glyph_saraueleftthai[] = "saraueleftthai";
static const char glyph_sarauethai[] = "sarauethai";
static const char glyph_sarauthai[] = "sarauthai";
static const char glyph_sarauuthai[] = "sarauuthai";
static const char glyph_sbopomofo[] = "sbopomofo";
static const char glyph_scaron[] = "scaron";
static const char glyph_scarondotaccent[] = "scarondotaccent";
static const char glyph_scedilla[] = "scedilla";
static const char glyph_schwa[] = "schwa";
static const char glyph_schwacyrillic[] = "schwacyrillic";
static const char glyph_schwadieresiscyrillic[] = "schwadieresiscyrillic";
static const char glyph_schwahook[] = "schwahook";
static const char glyph_scircle[] = "scircle";
static const char glyph_scircumflex[] = "scircumflex";
static const char glyph_scommaaccent[] = "scommaaccent";
static const char glyph_sdotaccent[] = "sdotaccent";
static const char glyph_sdotbelow[] = "sdotbelow";
static const char glyph_sdotbelowdotaccent[] = "sdotbelowdotaccent";
static const char glyph_seagullbelowcmb[] = "seagullbelowcmb";
static const char glyph_second[] = "second";
static const char glyph_secondtonechinese[] = "secondtonechinese";
static const char glyph_section[] = "section";
static const char glyph_seenarabic[] = "seenarabic";
static const char glyph_seenfinalarabic[] = "seenfinalarabic";
static const char glyph_seeninitialarabic[] = "seeninitialarabic";
static const char glyph_seenmedialarabic[] = "seenmedialarabic";
static const char glyph_segol[] = "segol";
static const char glyph_segol13[] = "segol13";
static const char glyph_segol1f[] = "segol1f";
static const char glyph_segol2c[] = "segol2c";
static const char glyph_segolhebrew[] = "segolhebrew";
static const char glyph_segolnarrowhebrew[] = "segolnarrowhebrew";
static const char glyph_segolquarterhebrew[] = "segolquarterhebrew";
static const char glyph_segoltahebrew[] = "segoltahebrew";
static const char glyph_segolwidehebrew[] = "segolwidehebrew";
static const char glyph_seharmenian[] = "seharmenian";
static const char glyph_sehiragana[] = "sehiragana";
static const char glyph_sekatakana[] = "sekatakana";
static const char glyph_sekatakanahalfwidth[] = "sekatakanahalfwidth";
static const char glyph_semicolon[] = "semicolon";
static const char glyph_semicolonarabic[] = "semicolonarabic";
static const char glyph_semicolonmonospace[] = "semicolonmonospace";
static const char glyph_semicolonsmall[] = "semicolonsmall";
static const char glyph_semivoicedmarkkana[] = "semivoicedmarkkana";
static const char glyph_semivoicedmarkkanahalfwidth[] =
"semivoicedmarkkanahalfwidth";
static const char glyph_sentisquare[] = "sentisquare";
static const char glyph_sentosquare[] = "sentosquare";
static const char glyph_seven[] = "seven";
static const char glyph_sevenarabic[] = "sevenarabic";
static const char glyph_sevenbengali[] = "sevenbengali";
static const char glyph_sevencircle[] = "sevencircle";
static const char glyph_sevencircleinversesansserif[] =
"sevencircleinversesansserif";
static const char glyph_sevendeva[] = "sevendeva";
static const char glyph_seveneighths[] = "seveneighths";
static const char glyph_sevengujarati[] = "sevengujarati";
static const char glyph_sevengurmukhi[] = "sevengurmukhi";
static const char glyph_sevenhackarabic[] = "sevenhackarabic";
static const char glyph_sevenhangzhou[] = "sevenhangzhou";
static const char glyph_sevenideographicparen[] = "sevenideographicparen";
static const char glyph_seveninferior[] = "seveninferior";
static const char glyph_sevenmonospace[] = "sevenmonospace";
static const char glyph_sevenoldstyle[] = "sevenoldstyle";
static const char glyph_sevenparen[] = "sevenparen";
static const char glyph_sevenperiod[] = "sevenperiod";
static const char glyph_sevenpersian[] = "sevenpersian";
static const char glyph_sevenroman[] = "sevenroman";
static const char glyph_sevensuperior[] = "sevensuperior";
static const char glyph_seventeencircle[] = "seventeencircle";
static const char glyph_seventeenparen[] = "seventeenparen";
static const char glyph_seventeenperiod[] = "seventeenperiod";
static const char glyph_seventhai[] = "seventhai";
static const char glyph_sfthyphen[] = "sfthyphen";
static const char glyph_shaarmenian[] = "shaarmenian";
static const char glyph_shabengali[] = "shabengali";
static const char glyph_shacyrillic[] = "shacyrillic";
static const char glyph_shaddaarabic[] = "shaddaarabic";
static const char glyph_shaddadammaarabic[] = "shaddadammaarabic";
static const char glyph_shaddadammatanarabic[] = "shaddadammatanarabic";
static const char glyph_shaddafathaarabic[] = "shaddafathaarabic";
static const char glyph_shaddafathatanarabic[] = "shaddafathatanarabic";
static const char glyph_shaddakasraarabic[] = "shaddakasraarabic";
static const char glyph_shaddakasratanarabic[] = "shaddakasratanarabic";
static const char glyph_shade[] = "shade";
static const char glyph_shadedark[] = "shadedark";
static const char glyph_shadelight[] = "shadelight";
static const char glyph_shademedium[] = "shademedium";
static const char glyph_shadeva[] = "shadeva";
static const char glyph_shagujarati[] = "shagujarati";
static const char glyph_shagurmukhi[] = "shagurmukhi";
static const char glyph_shalshelethebrew[] = "shalshelethebrew";
static const char glyph_shbopomofo[] = "shbopomofo";
static const char glyph_shchacyrillic[] = "shchacyrillic";
static const char glyph_sheenarabic[] = "sheenarabic";
static const char glyph_sheenfinalarabic[] = "sheenfinalarabic";
static const char glyph_sheeninitialarabic[] = "sheeninitialarabic";
static const char glyph_sheenmedialarabic[] = "sheenmedialarabic";
static const char glyph_sheicoptic[] = "sheicoptic";
static const char glyph_sheqel[] = "sheqel";
static const char glyph_sheqelhebrew[] = "sheqelhebrew";
static const char glyph_sheva[] = "sheva";
static const char glyph_sheva115[] = "sheva115";
static const char glyph_sheva15[] = "sheva15";
static const char glyph_sheva22[] = "sheva22";
static const char glyph_sheva2e[] = "sheva2e";
static const char glyph_shevahebrew[] = "shevahebrew";
static const char glyph_shevanarrowhebrew[] = "shevanarrowhebrew";
static const char glyph_shevaquarterhebrew[] = "shevaquarterhebrew";
static const char glyph_shevawidehebrew[] = "shevawidehebrew";
static const char glyph_shhacyrillic[] = "shhacyrillic";
static const char glyph_shimacoptic[] = "shimacoptic";
static const char glyph_shin[] = "shin";
static const char glyph_shindagesh[] = "shindagesh";
static const char glyph_shindageshhebrew[] = "shindageshhebrew";
static const char glyph_shindageshshindot[] = "shindageshshindot";
static const char glyph_shindageshshindothebrew[] = "shindageshshindothebrew";
static const char glyph_shindageshsindot[] = "shindageshsindot";
static const char glyph_shindageshsindothebrew[] = "shindageshsindothebrew";
static const char glyph_shindothebrew[] = "shindothebrew";
static const char glyph_shinhebrew[] = "shinhebrew";
static const char glyph_shinshindot[] = "shinshindot";
static const char glyph_shinshindothebrew[] = "shinshindothebrew";
static const char glyph_shinsindot[] = "shinsindot";
static const char glyph_shinsindothebrew[] = "shinsindothebrew";
static const char glyph_shook[] = "shook";
static const char glyph_sigma[] = "sigma";
static const char glyph_sigma1[] = "sigma1";
static const char glyph_sigmafinal[] = "sigmafinal";
static const char glyph_sigmalunatesymbolgreek[] = "sigmalunatesymbolgreek";
static const char glyph_sihiragana[] = "sihiragana";
static const char glyph_sikatakana[] = "sikatakana";
static const char glyph_sikatakanahalfwidth[] = "sikatakanahalfwidth";
static const char glyph_siluqhebrew[] = "siluqhebrew";
static const char glyph_siluqlefthebrew[] = "siluqlefthebrew";
static const char glyph_similar[] = "similar";
static const char glyph_sindothebrew[] = "sindothebrew";
static const char glyph_siosacirclekorean[] = "siosacirclekorean";
static const char glyph_siosaparenkorean[] = "siosaparenkorean";
static const char glyph_sioscieuckorean[] = "sioscieuckorean";
static const char glyph_sioscirclekorean[] = "sioscirclekorean";
static const char glyph_sioskiyeokkorean[] = "sioskiyeokkorean";
static const char glyph_sioskorean[] = "sioskorean";
static const char glyph_siosnieunkorean[] = "siosnieunkorean";
static const char glyph_siosparenkorean[] = "siosparenkorean";
static const char glyph_siospieupkorean[] = "siospieupkorean";
static const char glyph_siostikeutkorean[] = "siostikeutkorean";
static const char glyph_six[] = "six";
static const char glyph_sixarabic[] = "sixarabic";
static const char glyph_sixbengali[] = "sixbengali";
static const char glyph_sixcircle[] = "sixcircle";
static const char glyph_sixcircleinversesansserif[] =
"sixcircleinversesansserif";
static const char glyph_sixdeva[] = "sixdeva";
static const char glyph_sixgujarati[] = "sixgujarati";
static const char glyph_sixgurmukhi[] = "sixgurmukhi";
static const char glyph_sixhackarabic[] = "sixhackarabic";
static const char glyph_sixhangzhou[] = "sixhangzhou";
static const char glyph_sixideographicparen[] = "sixideographicparen";
static const char glyph_sixinferior[] = "sixinferior";
static const char glyph_sixmonospace[] = "sixmonospace";
static const char glyph_sixoldstyle[] = "sixoldstyle";
static const char glyph_sixparen[] = "sixparen";
static const char glyph_sixperiod[] = "sixperiod";
static const char glyph_sixpersian[] = "sixpersian";
static const char glyph_sixroman[] = "sixroman";
static const char glyph_sixsuperior[] = "sixsuperior";
static const char glyph_sixteencircle[] = "sixteencircle";
static const char glyph_sixteencurrencydenominatorbengali[] =
"sixteencurrencydenominatorbengali";
static const char glyph_sixteenparen[] = "sixteenparen";
static const char glyph_sixteenperiod[] = "sixteenperiod";
static const char glyph_sixthai[] = "sixthai";
static const char glyph_slash[] = "slash";
static const char glyph_slashmonospace[] = "slashmonospace";
static const char glyph_slong[] = "slong";
static const char glyph_slongdotaccent[] = "slongdotaccent";
static const char glyph_smileface[] = "smileface";
static const char glyph_smonospace[] = "smonospace";
static const char glyph_sofpasuqhebrew[] = "sofpasuqhebrew";
static const char glyph_softhyphen[] = "softhyphen";
static const char glyph_softsigncyrillic[] = "softsigncyrillic";
static const char glyph_sohiragana[] = "sohiragana";
static const char glyph_sokatakana[] = "sokatakana";
static const char glyph_sokatakanahalfwidth[] = "sokatakanahalfwidth";
static const char glyph_soliduslongoverlaycmb[] = "soliduslongoverlaycmb";
static const char glyph_solidusshortoverlaycmb[] = "solidusshortoverlaycmb";
static const char glyph_sorusithai[] = "sorusithai";
static const char glyph_sosalathai[] = "sosalathai";
static const char glyph_sosothai[] = "sosothai";
static const char glyph_sosuathai[] = "sosuathai";
static const char glyph_space[] = "space";
static const char glyph_spacehackarabic[] = "spacehackarabic";
static const char glyph_spade[] = "spade";
static const char glyph_spadesuitblack[] = "spadesuitblack";
static const char glyph_spadesuitwhite[] = "spadesuitwhite";
static const char glyph_sparen[] = "sparen";
static const char glyph_squarebelowcmb[] = "squarebelowcmb";
static const char glyph_squarecc[] = "squarecc";
static const char glyph_squarecm[] = "squarecm";
static const char glyph_squarediagonalcrosshatchfill[] =
"squarediagonalcrosshatchfill";
static const char glyph_squarehorizontalfill[] = "squarehorizontalfill";
static const char glyph_squarekg[] = "squarekg";
static const char glyph_squarekm[] = "squarekm";
static const char glyph_squarekmcapital[] = "squarekmcapital";
static const char glyph_squareln[] = "squareln";
static const char glyph_squarelog[] = "squarelog";
static const char glyph_squaremg[] = "squaremg";
static const char glyph_squaremil[] = "squaremil";
static const char glyph_squaremm[] = "squaremm";
static const char glyph_squaremsquared[] = "squaremsquared";
static const char glyph_squareorthogonalcrosshatchfill[] =
"squareorthogonalcrosshatchfill";
static const char glyph_squareupperlefttolowerrightfill[] =
"squareupperlefttolowerrightfill";
static const char glyph_squareupperrighttolowerleftfill[] =
"squareupperrighttolowerleftfill";
static const char glyph_squareverticalfill[] = "squareverticalfill";
static const char glyph_squarewhitewithsmallblack[] =
"squarewhitewithsmallblack";
static const char glyph_srsquare[] = "srsquare";
static const char glyph_ssabengali[] = "ssabengali";
static const char glyph_ssadeva[] = "ssadeva";
static const char glyph_ssagujarati[] = "ssagujarati";
static const char glyph_ssangcieuckorean[] = "ssangcieuckorean";
static const char glyph_ssanghieuhkorean[] = "ssanghieuhkorean";
static const char glyph_ssangieungkorean[] = "ssangieungkorean";
static const char glyph_ssangkiyeokkorean[] = "ssangkiyeokkorean";
static const char glyph_ssangnieunkorean[] = "ssangnieunkorean";
static const char glyph_ssangpieupkorean[] = "ssangpieupkorean";
static const char glyph_ssangsioskorean[] = "ssangsioskorean";
static const char glyph_ssangtikeutkorean[] = "ssangtikeutkorean";
static const char glyph_ssuperior[] = "ssuperior";
static const char glyph_sterling[] = "sterling";
static const char glyph_sterlingmonospace[] = "sterlingmonospace";
static const char glyph_strokelongoverlaycmb[] = "strokelongoverlaycmb";
static const char glyph_strokeshortoverlaycmb[] = "strokeshortoverlaycmb";
static const char glyph_subset[] = "subset";
static const char glyph_subsetnotequal[] = "subsetnotequal";
static const char glyph_subsetorequal[] = "subsetorequal";
static const char glyph_succeeds[] = "succeeds";
static const char glyph_suchthat[] = "suchthat";
static const char glyph_suhiragana[] = "suhiragana";
static const char glyph_sukatakana[] = "sukatakana";
static const char glyph_sukatakanahalfwidth[] = "sukatakanahalfwidth";
static const char glyph_sukunarabic[] = "sukunarabic";
static const char glyph_summation[] = "summation";
static const char glyph_sun[] = "sun";
static const char glyph_superset[] = "superset";
static const char glyph_supersetnotequal[] = "supersetnotequal";
static const char glyph_supersetorequal[] = "supersetorequal";
static const char glyph_svsquare[] = "svsquare";
static const char glyph_syouwaerasquare[] = "syouwaerasquare";
static const char glyph_t[] = "t";
static const char glyph_tabengali[] = "tabengali";
static const char glyph_tackdown[] = "tackdown";
static const char glyph_tackleft[] = "tackleft";
static const char glyph_tadeva[] = "tadeva";
static const char glyph_tagujarati[] = "tagujarati";
static const char glyph_tagurmukhi[] = "tagurmukhi";
static const char glyph_taharabic[] = "taharabic";
static const char glyph_tahfinalarabic[] = "tahfinalarabic";
static const char glyph_tahinitialarabic[] = "tahinitialarabic";
static const char glyph_tahiragana[] = "tahiragana";
static const char glyph_tahmedialarabic[] = "tahmedialarabic";
static const char glyph_taisyouerasquare[] = "taisyouerasquare";
static const char glyph_takatakana[] = "takatakana";
static const char glyph_takatakanahalfwidth[] = "takatakanahalfwidth";
static const char glyph_tatweelarabic[] = "tatweelarabic";
static const char glyph_tau[] = "tau";
static const char glyph_tav[] = "tav";
static const char glyph_tavdages[] = "tavdages";
static const char glyph_tavdagesh[] = "tavdagesh";
static const char glyph_tavdageshhebrew[] = "tavdageshhebrew";
static const char glyph_tavhebrew[] = "tavhebrew";
static const char glyph_tbar[] = "tbar";
static const char glyph_tbopomofo[] = "tbopomofo";
static const char glyph_tcaron[] = "tcaron";
static const char glyph_tccurl[] = "tccurl";
static const char glyph_tcedilla[] = "tcedilla";
static const char glyph_tcheharabic[] = "tcheharabic";
static const char glyph_tchehfinalarabic[] = "tchehfinalarabic";
static const char glyph_tchehinitialarabic[] = "tchehinitialarabic";
static const char glyph_tchehmedialarabic[] = "tchehmedialarabic";
static const char glyph_tchehmeeminitialarabic[] = "tchehmeeminitialarabic";
static const char glyph_tcircle[] = "tcircle";
static const char glyph_tcircumflexbelow[] = "tcircumflexbelow";
static const char glyph_tcommaaccent[] = "tcommaaccent";
static const char glyph_tdieresis[] = "tdieresis";
static const char glyph_tdotaccent[] = "tdotaccent";
static const char glyph_tdotbelow[] = "tdotbelow";
static const char glyph_tecyrillic[] = "tecyrillic";
static const char glyph_tedescendercyrillic[] = "tedescendercyrillic";
static const char glyph_teharabic[] = "teharabic";
static const char glyph_tehfinalarabic[] = "tehfinalarabic";
static const char glyph_tehhahinitialarabic[] = "tehhahinitialarabic";
static const char glyph_tehhahisolatedarabic[] = "tehhahisolatedarabic";
static const char glyph_tehinitialarabic[] = "tehinitialarabic";
static const char glyph_tehiragana[] = "tehiragana";
static const char glyph_tehjeeminitialarabic[] = "tehjeeminitialarabic";
static const char glyph_tehjeemisolatedarabic[] = "tehjeemisolatedarabic";
static const char glyph_tehmarbutaarabic[] = "tehmarbutaarabic";
static const char glyph_tehmarbutafinalarabic[] = "tehmarbutafinalarabic";
static const char glyph_tehmedialarabic[] = "tehmedialarabic";
static const char glyph_tehmeeminitialarabic[] = "tehmeeminitialarabic";
static const char glyph_tehmeemisolatedarabic[] = "tehmeemisolatedarabic";
static const char glyph_tehnoonfinalarabic[] = "tehnoonfinalarabic";
static const char glyph_tekatakana[] = "tekatakana";
static const char glyph_tekatakanahalfwidth[] = "tekatakanahalfwidth";
static const char glyph_telephone[] = "telephone";
static const char glyph_telephoneblack[] = "telephoneblack";
static const char glyph_telishagedolahebrew[] = "telishagedolahebrew";
static const char glyph_telishaqetanahebrew[] = "telishaqetanahebrew";
static const char glyph_tencircle[] = "tencircle";
static const char glyph_tenideographicparen[] = "tenideographicparen";
static const char glyph_tenparen[] = "tenparen";
static const char glyph_tenperiod[] = "tenperiod";
static const char glyph_tenroman[] = "tenroman";
static const char glyph_tesh[] = "tesh";
static const char glyph_tet[] = "tet";
static const char glyph_tetdagesh[] = "tetdagesh";
static const char glyph_tetdageshhebrew[] = "tetdageshhebrew";
static const char glyph_tethebrew[] = "tethebrew";
static const char glyph_tetsecyrillic[] = "tetsecyrillic";
static const char glyph_tevirhebrew[] = "tevirhebrew";
static const char glyph_tevirlefthebrew[] = "tevirlefthebrew";
static const char glyph_thabengali[] = "thabengali";
static const char glyph_thadeva[] = "thadeva";
static const char glyph_thagujarati[] = "thagujarati";
static const char glyph_thagurmukhi[] = "thagurmukhi";
static const char glyph_thalarabic[] = "thalarabic";
static const char glyph_thalfinalarabic[] = "thalfinalarabic";
static const char glyph_thanthakhatlowleftthai[] = "thanthakhatlowleftthai";
static const char glyph_thanthakhatlowrightthai[] = "thanthakhatlowrightthai";
static const char glyph_thanthakhatthai[] = "thanthakhatthai";
static const char glyph_thanthakhatupperleftthai[] =
"thanthakhatupperleftthai";
static const char glyph_theharabic[] = "theharabic";
static const char glyph_thehfinalarabic[] = "thehfinalarabic";
static const char glyph_thehinitialarabic[] = "thehinitialarabic";
static const char glyph_thehmedialarabic[] = "thehmedialarabic";
static const char glyph_thereexists[] = "thereexists";
static const char glyph_therefore[] = "therefore";
static const char glyph_theta[] = "theta";
static const char glyph_theta1[] = "theta1";
static const char glyph_thetasymbolgreek[] = "thetasymbolgreek";
static const char glyph_thieuthacirclekorean[] = "thieuthacirclekorean";
static const char glyph_thieuthaparenkorean[] = "thieuthaparenkorean";
static const char glyph_thieuthcirclekorean[] = "thieuthcirclekorean";
static const char glyph_thieuthkorean[] = "thieuthkorean";
static const char glyph_thieuthparenkorean[] = "thieuthparenkorean";
static const char glyph_thirteencircle[] = "thirteencircle";
static const char glyph_thirteenparen[] = "thirteenparen";
static const char glyph_thirteenperiod[] = "thirteenperiod";
static const char glyph_thonangmonthothai[] = "thonangmonthothai";
static const char glyph_thook[] = "thook";
static const char glyph_thophuthaothai[] = "thophuthaothai";
static const char glyph_thorn[] = "thorn";
static const char glyph_thothahanthai[] = "thothahanthai";
static const char glyph_thothanthai[] = "thothanthai";
static const char glyph_thothongthai[] = "thothongthai";
static const char glyph_thothungthai[] = "thothungthai";
static const char glyph_thousandcyrillic[] = "thousandcyrillic";
static const char glyph_thousandsseparatorarabic[] =
"thousandsseparatorarabic";
static const char glyph_thousandsseparatorpersian[] =
"thousandsseparatorpersian";
static const char glyph_three[] = "three";
static const char glyph_threearabic[] = "threearabic";
static const char glyph_threebengali[] = "threebengali";
static const char glyph_threecircle[] = "threecircle";
static const char glyph_threecircleinversesansserif[] =
"threecircleinversesansserif";
static const char glyph_threedeva[] = "threedeva";
static const char glyph_threeeighths[] = "threeeighths";
static const char glyph_threegujarati[] = "threegujarati";
static const char glyph_threegurmukhi[] = "threegurmukhi";
static const char glyph_threehackarabic[] = "threehackarabic";
static const char glyph_threehangzhou[] = "threehangzhou";
static const char glyph_threeideographicparen[] = "threeideographicparen";
static const char glyph_threeinferior[] = "threeinferior";
static const char glyph_threemonospace[] = "threemonospace";
static const char glyph_threenumeratorbengali[] = "threenumeratorbengali";
static const char glyph_threeoldstyle[] = "threeoldstyle";
static const char glyph_threeparen[] = "threeparen";
static const char glyph_threeperiod[] = "threeperiod";
static const char glyph_threepersian[] = "threepersian";
static const char glyph_threequarters[] = "threequarters";
static const char glyph_threequartersemdash[] = "threequartersemdash";
static const char glyph_threeroman[] = "threeroman";
static const char glyph_threesuperior[] = "threesuperior";
static const char glyph_threethai[] = "threethai";
static const char glyph_thzsquare[] = "thzsquare";
static const char glyph_tihiragana[] = "tihiragana";
static const char glyph_tikatakana[] = "tikatakana";
static const char glyph_tikatakanahalfwidth[] = "tikatakanahalfwidth";
static const char glyph_tikeutacirclekorean[] = "tikeutacirclekorean";
static const char glyph_tikeutaparenkorean[] = "tikeutaparenkorean";
static const char glyph_tikeutcirclekorean[] = "tikeutcirclekorean";
static const char glyph_tikeutkorean[] = "tikeutkorean";
static const char glyph_tikeutparenkorean[] = "tikeutparenkorean";
static const char glyph_tilde[] = "tilde";
static const char glyph_tildebelowcmb[] = "tildebelowcmb";
static const char glyph_tildecmb[] = "tildecmb";
static const char glyph_tildecomb[] = "tildecomb";
static const char glyph_tildedoublecmb[] = "tildedoublecmb";
static const char glyph_tildeoperator[] = "tildeoperator";
static const char glyph_tildeoverlaycmb[] = "tildeoverlaycmb";
static const char glyph_tildeverticalcmb[] = "tildeverticalcmb";
static const char glyph_timescircle[] = "timescircle";
static const char glyph_tipehahebrew[] = "tipehahebrew";
static const char glyph_tipehalefthebrew[] = "tipehalefthebrew";
static const char glyph_tippigurmukhi[] = "tippigurmukhi";
static const char glyph_titlocyrilliccmb[] = "titlocyrilliccmb";
static const char glyph_tiwnarmenian[] = "tiwnarmenian";
static const char glyph_tlinebelow[] = "tlinebelow";
static const char glyph_tmonospace[] = "tmonospace";
static const char glyph_toarmenian[] = "toarmenian";
static const char glyph_tohiragana[] = "tohiragana";
static const char glyph_tokatakana[] = "tokatakana";
static const char glyph_tokatakanahalfwidth[] = "tokatakanahalfwidth";
static const char glyph_tonebarextrahighmod[] = "tonebarextrahighmod";
static const char glyph_tonebarextralowmod[] = "tonebarextralowmod";
static const char glyph_tonebarhighmod[] = "tonebarhighmod";
static const char glyph_tonebarlowmod[] = "tonebarlowmod";
static const char glyph_tonebarmidmod[] = "tonebarmidmod";
static const char glyph_tonefive[] = "tonefive";
static const char glyph_tonesix[] = "tonesix";
static const char glyph_tonetwo[] = "tonetwo";
static const char glyph_tonos[] = "tonos";
static const char glyph_tonsquare[] = "tonsquare";
static const char glyph_topatakthai[] = "topatakthai";
static const char glyph_tortoiseshellbracketleft[] =
"tortoiseshellbracketleft";
static const char glyph_tortoiseshellbracketleftsmall[] =
"tortoiseshellbracketleftsmall";
static const char glyph_tortoiseshellbracketleftvertical[] =
"tortoiseshellbracketleftvertical";
static const char glyph_tortoiseshellbracketright[] =
"tortoiseshellbracketright";
static const char glyph_tortoiseshellbracketrightsmall[] =
"tortoiseshellbracketrightsmall";
static const char glyph_tortoiseshellbracketrightvertical[] =
"tortoiseshellbracketrightvertical";
static const char glyph_totaothai[] = "totaothai";
static const char glyph_tpalatalhook[] = "tpalatalhook";
static const char glyph_tparen[] = "tparen";
static const char glyph_trademark[] = "trademark";
static const char glyph_trademarksans[] = "trademarksans";
static const char glyph_trademarkserif[] = "trademarkserif";
static const char glyph_tretroflexhook[] = "tretroflexhook";
static const char glyph_triagdn[] = "triagdn";
static const char glyph_triaglf[] = "triaglf";
static const char glyph_triagrt[] = "triagrt";
static const char glyph_triagup[] = "triagup";
static const char glyph_ts[] = "ts";
static const char glyph_tsadi[] = "tsadi";
static const char glyph_tsadidagesh[] = "tsadidagesh";
static const char glyph_tsadidageshhebrew[] = "tsadidageshhebrew";
static const char glyph_tsadihebrew[] = "tsadihebrew";
static const char glyph_tsecyrillic[] = "tsecyrillic";
static const char glyph_tsere[] = "tsere";
static const char glyph_tsere12[] = "tsere12";
static const char glyph_tsere1e[] = "tsere1e";
static const char glyph_tsere2b[] = "tsere2b";
static const char glyph_tserehebrew[] = "tserehebrew";
static const char glyph_tserenarrowhebrew[] = "tserenarrowhebrew";
static const char glyph_tserequarterhebrew[] = "tserequarterhebrew";
static const char glyph_tserewidehebrew[] = "tserewidehebrew";
static const char glyph_tshecyrillic[] = "tshecyrillic";
static const char glyph_tsuperior[] = "tsuperior";
static const char glyph_ttabengali[] = "ttabengali";
static const char glyph_ttadeva[] = "ttadeva";
static const char glyph_ttagujarati[] = "ttagujarati";
static const char glyph_ttagurmukhi[] = "ttagurmukhi";
static const char glyph_tteharabic[] = "tteharabic";
static const char glyph_ttehfinalarabic[] = "ttehfinalarabic";
static const char glyph_ttehinitialarabic[] = "ttehinitialarabic";
static const char glyph_ttehmedialarabic[] = "ttehmedialarabic";
static const char glyph_tthabengali[] = "tthabengali";
static const char glyph_tthadeva[] = "tthadeva";
static const char glyph_tthagujarati[] = "tthagujarati";
static const char glyph_tthagurmukhi[] = "tthagurmukhi";
static const char glyph_tturned[] = "tturned";
static const char glyph_tuhiragana[] = "tuhiragana";
static const char glyph_tukatakana[] = "tukatakana";
static const char glyph_tukatakanahalfwidth[] = "tukatakanahalfwidth";
static const char glyph_tusmallhiragana[] = "tusmallhiragana";
static const char glyph_tusmallkatakana[] = "tusmallkatakana";
static const char glyph_tusmallkatakanahalfwidth[] =
"tusmallkatakanahalfwidth";
static const char glyph_twelvecircle[] = "twelvecircle";
static const char glyph_twelveparen[] = "twelveparen";
static const char glyph_twelveperiod[] = "twelveperiod";
static const char glyph_twelveroman[] = "twelveroman";
static const char glyph_twentycircle[] = "twentycircle";
static const char glyph_twentyhangzhou[] = "twentyhangzhou";
static const char glyph_twentyparen[] = "twentyparen";
static const char glyph_twentyperiod[] = "twentyperiod";
static const char glyph_two[] = "two";
static const char glyph_twoarabic[] = "twoarabic";
static const char glyph_twobengali[] = "twobengali";
static const char glyph_twocircle[] = "twocircle";
static const char glyph_twocircleinversesansserif[] =
"twocircleinversesansserif";
static const char glyph_twodeva[] = "twodeva";
static const char glyph_twodotenleader[] = "twodotenleader";
static const char glyph_twodotleader[] = "twodotleader";
static const char glyph_twodotleadervertical[] = "twodotleadervertical";
static const char glyph_twogujarati[] = "twogujarati";
static const char glyph_twogurmukhi[] = "twogurmukhi";
static const char glyph_twohackarabic[] = "twohackarabic";
static const char glyph_twohangzhou[] = "twohangzhou";
static const char glyph_twoideographicparen[] = "twoideographicparen";
static const char glyph_twoinferior[] = "twoinferior";
static const char glyph_twomonospace[] = "twomonospace";
static const char glyph_twonumeratorbengali[] = "twonumeratorbengali";
static const char glyph_twooldstyle[] = "twooldstyle";
static const char glyph_twoparen[] = "twoparen";
static const char glyph_twoperiod[] = "twoperiod";
static const char glyph_twopersian[] = "twopersian";
static const char glyph_tworoman[] = "tworoman";
static const char glyph_twostroke[] = "twostroke";
static const char glyph_twosuperior[] = "twosuperior";
static const char glyph_twothai[] = "twothai";
static const char glyph_twothirds[] = "twothirds";
static const char glyph_u[] = "u";
static const char glyph_uacute[] = "uacute";
static const char glyph_ubar[] = "ubar";
static const char glyph_ubengali[] = "ubengali";
static const char glyph_ubopomofo[] = "ubopomofo";
static const char glyph_ubreve[] = "ubreve";
static const char glyph_ucaron[] = "ucaron";
static const char glyph_ucircle[] = "ucircle";
static const char glyph_ucircumflex[] = "ucircumflex";
static const char glyph_ucircumflexbelow[] = "ucircumflexbelow";
static const char glyph_ucyrillic[] = "ucyrillic";
static const char glyph_udattadeva[] = "udattadeva";
static const char glyph_udblacute[] = "udblacute";
static const char glyph_udblgrave[] = "udblgrave";
static const char glyph_udeva[] = "udeva";
static const char glyph_udieresis[] = "udieresis";
static const char glyph_udieresisacute[] = "udieresisacute";
static const char glyph_udieresisbelow[] = "udieresisbelow";
static const char glyph_udieresiscaron[] = "udieresiscaron";
static const char glyph_udieresiscyrillic[] = "udieresiscyrillic";
static const char glyph_udieresisgrave[] = "udieresisgrave";
static const char glyph_udieresismacron[] = "udieresismacron";
static const char glyph_udotbelow[] = "udotbelow";
static const char glyph_ugrave[] = "ugrave";
static const char glyph_ugujarati[] = "ugujarati";
static const char glyph_ugurmukhi[] = "ugurmukhi";
static const char glyph_uhiragana[] = "uhiragana";
static const char glyph_uhookabove[] = "uhookabove";
static const char glyph_uhorn[] = "uhorn";
static const char glyph_uhornacute[] = "uhornacute";
static const char glyph_uhorndotbelow[] = "uhorndotbelow";
static const char glyph_uhorngrave[] = "uhorngrave";
static const char glyph_uhornhookabove[] = "uhornhookabove";
static const char glyph_uhorntilde[] = "uhorntilde";
static const char glyph_uhungarumlaut[] = "uhungarumlaut";
static const char glyph_uhungarumlautcyrillic[] = "uhungarumlautcyrillic";
static const char glyph_uinvertedbreve[] = "uinvertedbreve";
static const char glyph_ukatakana[] = "ukatakana";
static const char glyph_ukatakanahalfwidth[] = "ukatakanahalfwidth";
static const char glyph_ukcyrillic[] = "ukcyrillic";
static const char glyph_ukorean[] = "ukorean";
static const char glyph_umacron[] = "umacron";
static const char glyph_umacroncyrillic[] = "umacroncyrillic";
static const char glyph_umacrondieresis[] = "umacrondieresis";
static const char glyph_umatragurmukhi[] = "umatragurmukhi";
static const char glyph_umonospace[] = "umonospace";
static const char glyph_underscore[] = "underscore";
static const char glyph_underscoredbl[] = "underscoredbl";
static const char glyph_underscoremonospace[] = "underscoremonospace";
static const char glyph_underscorevertical[] = "underscorevertical";
static const char glyph_underscorewavy[] = "underscorewavy";
static const char glyph_union[] = "union";
static const char glyph_universal[] = "universal";
static const char glyph_uogonek[] = "uogonek";
static const char glyph_uparen[] = "uparen";
static const char glyph_upblock[] = "upblock";
static const char glyph_upperdothebrew[] = "upperdothebrew";
static const char glyph_upsilon[] = "upsilon";
static const char glyph_upsilondieresis[] = "upsilondieresis";
static const char glyph_upsilondieresistonos[] = "upsilondieresistonos";
static const char glyph_upsilonlatin[] = "upsilonlatin";
static const char glyph_upsilontonos[] = "upsilontonos";
static const char glyph_uptackbelowcmb[] = "uptackbelowcmb";
static const char glyph_uptackmod[] = "uptackmod";
static const char glyph_uragurmukhi[] = "uragurmukhi";
static const char glyph_uring[] = "uring";
static const char glyph_ushortcyrillic[] = "ushortcyrillic";
static const char glyph_usmallhiragana[] = "usmallhiragana";
static const char glyph_usmallkatakana[] = "usmallkatakana";
static const char glyph_usmallkatakanahalfwidth[] = "usmallkatakanahalfwidth";
static const char glyph_ustraightcyrillic[] = "ustraightcyrillic";
static const char glyph_ustraightstrokecyrillic[] = "ustraightstrokecyrillic";
static const char glyph_utilde[] = "utilde";
static const char glyph_utildeacute[] = "utildeacute";
static const char glyph_utildebelow[] = "utildebelow";
static const char glyph_uubengali[] = "uubengali";
static const char glyph_uudeva[] = "uudeva";
static const char glyph_uugujarati[] = "uugujarati";
static const char glyph_uugurmukhi[] = "uugurmukhi";
static const char glyph_uumatragurmukhi[] = "uumatragurmukhi";
static const char glyph_uuvowelsignbengali[] = "uuvowelsignbengali";
static const char glyph_uuvowelsigndeva[] = "uuvowelsigndeva";
static const char glyph_uuvowelsigngujarati[] = "uuvowelsigngujarati";
static const char glyph_uvowelsignbengali[] = "uvowelsignbengali";
static const char glyph_uvowelsigndeva[] = "uvowelsigndeva";
static const char glyph_uvowelsigngujarati[] = "uvowelsigngujarati";
static const char glyph_v[] = "v";
static const char glyph_vadeva[] = "vadeva";
static const char glyph_vagujarati[] = "vagujarati";
static const char glyph_vagurmukhi[] = "vagurmukhi";
static const char glyph_vakatakana[] = "vakatakana";
static const char glyph_vav[] = "vav";
static const char glyph_vavdagesh[] = "vavdagesh";
static const char glyph_vavdagesh65[] = "vavdagesh65";
static const char glyph_vavdageshhebrew[] = "vavdageshhebrew";
static const char glyph_vavhebrew[] = "vavhebrew";
static const char glyph_vavholam[] = "vavholam";
static const char glyph_vavholamhebrew[] = "vavholamhebrew";
static const char glyph_vavvavhebrew[] = "vavvavhebrew";
static const char glyph_vavyodhebrew[] = "vavyodhebrew";
static const char glyph_vcircle[] = "vcircle";
static const char glyph_vdotbelow[] = "vdotbelow";
static const char glyph_vecyrillic[] = "vecyrillic";
static const char glyph_veharabic[] = "veharabic";
static const char glyph_vehfinalarabic[] = "vehfinalarabic";
static const char glyph_vehinitialarabic[] = "vehinitialarabic";
static const char glyph_vehmedialarabic[] = "vehmedialarabic";
static const char glyph_vekatakana[] = "vekatakana";
static const char glyph_venus[] = "venus";
static const char glyph_verticalbar[] = "verticalbar";
static const char glyph_verticallineabovecmb[] = "verticallineabovecmb";
static const char glyph_verticallinebelowcmb[] = "verticallinebelowcmb";
static const char glyph_verticallinelowmod[] = "verticallinelowmod";
static const char glyph_verticallinemod[] = "verticallinemod";
static const char glyph_vewarmenian[] = "vewarmenian";
static const char glyph_vhook[] = "vhook";
static const char glyph_vikatakana[] = "vikatakana";
static const char glyph_viramabengali[] = "viramabengali";
static const char glyph_viramadeva[] = "viramadeva";
static const char glyph_viramagujarati[] = "viramagujarati";
static const char glyph_visargabengali[] = "visargabengali";
static const char glyph_visargadeva[] = "visargadeva";
static const char glyph_visargagujarati[] = "visargagujarati";
static const char glyph_vmonospace[] = "vmonospace";
static const char glyph_voarmenian[] = "voarmenian";
static const char glyph_voicediterationhiragana[] = "voicediterationhiragana";
static const char glyph_voicediterationkatakana[] = "voicediterationkatakana";
static const char glyph_voicedmarkkana[] = "voicedmarkkana";
static const char glyph_voicedmarkkanahalfwidth[] = "voicedmarkkanahalfwidth";
static const char glyph_vokatakana[] = "vokatakana";
static const char glyph_vparen[] = "vparen";
static const char glyph_vtilde[] = "vtilde";
static const char glyph_vturned[] = "vturned";
static const char glyph_vuhiragana[] = "vuhiragana";
static const char glyph_vukatakana[] = "vukatakana";
static const char glyph_w[] = "w";
static const char glyph_wacute[] = "wacute";
static const char glyph_waekorean[] = "waekorean";
static const char glyph_wahiragana[] = "wahiragana";
static const char glyph_wakatakana[] = "wakatakana";
static const char glyph_wakatakanahalfwidth[] = "wakatakanahalfwidth";
static const char glyph_wakorean[] = "wakorean";
static const char glyph_wasmallhiragana[] = "wasmallhiragana";
static const char glyph_wasmallkatakana[] = "wasmallkatakana";
static const char glyph_wattosquare[] = "wattosquare";
static const char glyph_wavedash[] = "wavedash";
static const char glyph_wavyunderscorevertical[] = "wavyunderscorevertical";
static const char glyph_wawarabic[] = "wawarabic";
static const char glyph_wawfinalarabic[] = "wawfinalarabic";
static const char glyph_wawhamzaabovearabic[] = "wawhamzaabovearabic";
static const char glyph_wawhamzaabovefinalarabic[] =
"wawhamzaabovefinalarabic";
static const char glyph_wbsquare[] = "wbsquare";
static const char glyph_wcircle[] = "wcircle";
static const char glyph_wcircumflex[] = "wcircumflex";
static const char glyph_wdieresis[] = "wdieresis";
static const char glyph_wdotaccent[] = "wdotaccent";
static const char glyph_wdotbelow[] = "wdotbelow";
static const char glyph_wehiragana[] = "wehiragana";
static const char glyph_weierstrass[] = "weierstrass";
static const char glyph_wekatakana[] = "wekatakana";
static const char glyph_wekorean[] = "wekorean";
static const char glyph_weokorean[] = "weokorean";
static const char glyph_wgrave[] = "wgrave";
static const char glyph_whitebullet[] = "whitebullet";
static const char glyph_whitecircle[] = "whitecircle";
static const char glyph_whitecircleinverse[] = "whitecircleinverse";
static const char glyph_whitecornerbracketleft[] =
"whitecornerbracketleft";
static const char glyph_whitecornerbracketleftvertical[] =
"whitecornerbracketleftvertical";
static const char glyph_whitecornerbracketright[] =
"whitecornerbracketright";
static const char glyph_whitecornerbracketrightvertical[] =
"whitecornerbracketrightvertical";
static const char glyph_whitediamond[] = "whitediamond";
static const char glyph_whitediamondcontainingblacksmalldiamond[] =
"whitediamondcontainingblacksmalldiamond";
static const char glyph_whitedownpointingsmalltriangle[] =
"whitedownpointingsmalltriangle";
static const char glyph_whitedownpointingtriangle[] =
"whitedownpointingtriangle";
static const char glyph_whiteleftpointingsmalltriangle[] =
"whiteleftpointingsmalltriangle";
static const char glyph_whiteleftpointingtriangle[] =
"whiteleftpointingtriangle";
static const char glyph_whitelenticularbracketleft[] =
"whitelenticularbracketleft";
static const char glyph_whitelenticularbracketright[] =
"whitelenticularbracketright";
static const char glyph_whiterightpointingsmalltriangle[] =
"whiterightpointingsmalltriangle";
static const char glyph_whiterightpointingtriangle[] =
"whiterightpointingtriangle";
static const char glyph_whitesmallsquare[] = "whitesmallsquare";
static const char glyph_whitesmilingface[] = "whitesmilingface";
static const char glyph_whitesquare[] = "whitesquare";
static const char glyph_whitestar[] = "whitestar";
static const char glyph_whitetelephone[] = "whitetelephone";
static const char glyph_whitetortoiseshellbracketleft[] =
"whitetortoiseshellbracketleft";
static const char glyph_whitetortoiseshellbracketright[] =
"whitetortoiseshellbracketright";
static const char glyph_whiteuppointingsmalltriangle[] =
"whiteuppointingsmalltriangle";
static const char glyph_whiteuppointingtriangle[] = "whiteuppointingtriangle";
static const char glyph_wihiragana[] = "wihiragana";
static const char glyph_wikatakana[] = "wikatakana";
static const char glyph_wikorean[] = "wikorean";
static const char glyph_wmonospace[] = "wmonospace";
static const char glyph_wohiragana[] = "wohiragana";
static const char glyph_wokatakana[] = "wokatakana";
static const char glyph_wokatakanahalfwidth[] = "wokatakanahalfwidth";
static const char glyph_won[] = "won";
static const char glyph_wonmonospace[] = "wonmonospace";
static const char glyph_wowaenthai[] = "wowaenthai";
static const char glyph_wparen[] = "wparen";
static const char glyph_wring[] = "wring";
static const char glyph_wsuperior[] = "wsuperior";
static const char glyph_wturned[] = "wturned";
static const char glyph_wynn[] = "wynn";
static const char glyph_x[] = "x";
static const char glyph_xabovecmb[] = "xabovecmb";
static const char glyph_xbopomofo[] = "xbopomofo";
static const char glyph_xcircle[] = "xcircle";
static const char glyph_xdieresis[] = "xdieresis";
static const char glyph_xdotaccent[] = "xdotaccent";
static const char glyph_xeharmenian[] = "xeharmenian";
static const char glyph_xi[] = "xi";
static const char glyph_xmonospace[] = "xmonospace";
static const char glyph_xparen[] = "xparen";
static const char glyph_xsuperior[] = "xsuperior";
static const char glyph_y[] = "y";
static const char glyph_yaadosquare[] = "yaadosquare";
static const char glyph_yabengali[] = "yabengali";
static const char glyph_yacute[] = "yacute";
static const char glyph_yadeva[] = "yadeva";
static const char glyph_yaekorean[] = "yaekorean";
static const char glyph_yagujarati[] = "yagujarati";
static const char glyph_yagurmukhi[] = "yagurmukhi";
static const char glyph_yahiragana[] = "yahiragana";
static const char glyph_yakatakana[] = "yakatakana";
static const char glyph_yakatakanahalfwidth[] = "yakatakanahalfwidth";
static const char glyph_yakorean[] = "yakorean";
static const char glyph_yamakkanthai[] = "yamakkanthai";
static const char glyph_yasmallhiragana[] = "yasmallhiragana";
static const char glyph_yasmallkatakana[] = "yasmallkatakana";
static const char glyph_yasmallkatakanahalfwidth[] =
"yasmallkatakanahalfwidth";
static const char glyph_yatcyrillic[] = "yatcyrillic";
static const char glyph_ycircle[] = "ycircle";
static const char glyph_ycircumflex[] = "ycircumflex";
static const char glyph_ydieresis[] = "ydieresis";
static const char glyph_ydotaccent[] = "ydotaccent";
static const char glyph_ydotbelow[] = "ydotbelow";
static const char glyph_yeharabic[] = "yeharabic";
static const char glyph_yehbarreearabic[] = "yehbarreearabic";
static const char glyph_yehbarreefinalarabic[] = "yehbarreefinalarabic";
static const char glyph_yehfinalarabic[] = "yehfinalarabic";
static const char glyph_yehhamzaabovearabic[] = "yehhamzaabovearabic";
static const char glyph_yehhamzaabovefinalarabic[] =
"yehhamzaabovefinalarabic";
static const char glyph_yehhamzaaboveinitialarabic[] =
"yehhamzaaboveinitialarabic";
static const char glyph_yehhamzaabovemedialarabic[] =
"yehhamzaabovemedialarabic";
static const char glyph_yehinitialarabic[] = "yehinitialarabic";
static const char glyph_yehmedialarabic[] = "yehmedialarabic";
static const char glyph_yehmeeminitialarabic[] = "yehmeeminitialarabic";
static const char glyph_yehmeemisolatedarabic[] = "yehmeemisolatedarabic";
static const char glyph_yehnoonfinalarabic[] = "yehnoonfinalarabic";
static const char glyph_yehthreedotsbelowarabic[] = "yehthreedotsbelowarabic";
static const char glyph_yekorean[] = "yekorean";
static const char glyph_yen[] = "yen";
static const char glyph_yenmonospace[] = "yenmonospace";
static const char glyph_yeokorean[] = "yeokorean";
static const char glyph_yeorinhieuhkorean[] = "yeorinhieuhkorean";
static const char glyph_yerahbenyomohebrew[] = "yerahbenyomohebrew";
static const char glyph_yerahbenyomolefthebrew[] = "yerahbenyomolefthebrew";
static const char glyph_yericyrillic[] = "yericyrillic";
static const char glyph_yerudieresiscyrillic[] = "yerudieresiscyrillic";
static const char glyph_yesieungkorean[] = "yesieungkorean";
static const char glyph_yesieungpansioskorean[] = "yesieungpansioskorean";
static const char glyph_yesieungsioskorean[] = "yesieungsioskorean";
static const char glyph_yetivhebrew[] = "yetivhebrew";
static const char glyph_ygrave[] = "ygrave";
static const char glyph_yhook[] = "yhook";
static const char glyph_yhookabove[] = "yhookabove";
static const char glyph_yiarmenian[] = "yiarmenian";
static const char glyph_yicyrillic[] = "yicyrillic";
static const char glyph_yikorean[] = "yikorean";
static const char glyph_yinyang[] = "yinyang";
static const char glyph_yiwnarmenian[] = "yiwnarmenian";
static const char glyph_ymonospace[] = "ymonospace";
static const char glyph_yod[] = "yod";
static const char glyph_yoddagesh[] = "yoddagesh";
static const char glyph_yoddageshhebrew[] = "yoddageshhebrew";
static const char glyph_yodhebrew[] = "yodhebrew";
static const char glyph_yodyodhebrew[] = "yodyodhebrew";
static const char glyph_yodyodpatahhebrew[] = "yodyodpatahhebrew";
static const char glyph_yohiragana[] = "yohiragana";
static const char glyph_yoikorean[] = "yoikorean";
static const char glyph_yokatakana[] = "yokatakana";
static const char glyph_yokatakanahalfwidth[] = "yokatakanahalfwidth";
static const char glyph_yokorean[] = "yokorean";
static const char glyph_yosmallhiragana[] = "yosmallhiragana";
static const char glyph_yosmallkatakana[] = "yosmallkatakana";
static const char glyph_yosmallkatakanahalfwidth[] =
"yosmallkatakanahalfwidth";
static const char glyph_yotgreek[] = "yotgreek";
static const char glyph_yoyaekorean[] = "yoyaekorean";
static const char glyph_yoyakorean[] = "yoyakorean";
static const char glyph_yoyakthai[] = "yoyakthai";
static const char glyph_yoyingthai[] = "yoyingthai";
static const char glyph_yparen[] = "yparen";
static const char glyph_ypogegrammeni[] = "ypogegrammeni";
static const char glyph_ypogegrammenigreekcmb[] = "ypogegrammenigreekcmb";
static const char glyph_yr[] = "yr";
static const char glyph_yring[] = "yring";
static const char glyph_ysuperior[] = "ysuperior";
static const char glyph_ytilde[] = "ytilde";
static const char glyph_yturned[] = "yturned";
static const char glyph_yuhiragana[] = "yuhiragana";
static const char glyph_yuikorean[] = "yuikorean";
static const char glyph_yukatakana[] = "yukatakana";
static const char glyph_yukatakanahalfwidth[] = "yukatakanahalfwidth";
static const char glyph_yukorean[] = "yukorean";
static const char glyph_yusbigcyrillic[] = "yusbigcyrillic";
static const char glyph_yusbigiotifiedcyrillic[] = "yusbigiotifiedcyrillic";
static const char glyph_yuslittlecyrillic[] = "yuslittlecyrillic";
static const char glyph_yuslittleiotifiedcyrillic[] =
"yuslittleiotifiedcyrillic";
static const char glyph_yusmallhiragana[] = "yusmallhiragana";
static const char glyph_yusmallkatakana[] = "yusmallkatakana";
static const char glyph_yusmallkatakanahalfwidth[] =
"yusmallkatakanahalfwidth";
static const char glyph_yuyekorean[] = "yuyekorean";
static const char glyph_yuyeokorean[] = "yuyeokorean";
static const char glyph_yyabengali[] = "yyabengali";
static const char glyph_yyadeva[] = "yyadeva";
static const char glyph_z[] = "z";
static const char glyph_zaarmenian[] = "zaarmenian";
static const char glyph_zacute[] = "zacute";
static const char glyph_zadeva[] = "zadeva";
static const char glyph_zagurmukhi[] = "zagurmukhi";
static const char glyph_zaharabic[] = "zaharabic";
static const char glyph_zahfinalarabic[] = "zahfinalarabic";
static const char glyph_zahinitialarabic[] = "zahinitialarabic";
static const char glyph_zahiragana[] = "zahiragana";
static const char glyph_zahmedialarabic[] = "zahmedialarabic";
static const char glyph_zainarabic[] = "zainarabic";
static const char glyph_zainfinalarabic[] = "zainfinalarabic";
static const char glyph_zakatakana[] = "zakatakana";
static const char glyph_zaqefgadolhebrew[] = "zaqefgadolhebrew";
static const char glyph_zaqefqatanhebrew[] = "zaqefqatanhebrew";
static const char glyph_zarqahebrew[] = "zarqahebrew";
static const char glyph_zayin[] = "zayin";
static const char glyph_zayindagesh[] = "zayindagesh";
static const char glyph_zayindageshhebrew[] = "zayindageshhebrew";
static const char glyph_zayinhebrew[] = "zayinhebrew";
static const char glyph_zbopomofo[] = "zbopomofo";
static const char glyph_zcaron[] = "zcaron";
static const char glyph_zcircle[] = "zcircle";
static const char glyph_zcircumflex[] = "zcircumflex";
static const char glyph_zcurl[] = "zcurl";
static const char glyph_zdot[] = "zdot";
static const char glyph_zdotaccent[] = "zdotaccent";
static const char glyph_zdotbelow[] = "zdotbelow";
static const char glyph_zecyrillic[] = "zecyrillic";
static const char glyph_zedescendercyrillic[] = "zedescendercyrillic";
static const char glyph_zedieresiscyrillic[] = "zedieresiscyrillic";
static const char glyph_zehiragana[] = "zehiragana";
static const char glyph_zekatakana[] = "zekatakana";
static const char glyph_zero[] = "zero";
static const char glyph_zeroarabic[] = "zeroarabic";
static const char glyph_zerobengali[] = "zerobengali";
static const char glyph_zerodeva[] = "zerodeva";
static const char glyph_zerogujarati[] = "zerogujarati";
static const char glyph_zerogurmukhi[] = "zerogurmukhi";
static const char glyph_zerohackarabic[] = "zerohackarabic";
static const char glyph_zeroinferior[] = "zeroinferior";
static const char glyph_zeromonospace[] = "zeromonospace";
static const char glyph_zerooldstyle[] = "zerooldstyle";
static const char glyph_zeropersian[] = "zeropersian";
static const char glyph_zerosuperior[] = "zerosuperior";
static const char glyph_zerothai[] = "zerothai";
static const char glyph_zerowidthjoiner[] = "zerowidthjoiner";
static const char glyph_zerowidthnonjoiner[] = "zerowidthnonjoiner";
static const char glyph_zerowidthspace[] = "zerowidthspace";
static const char glyph_zeta[] = "zeta";
static const char glyph_zhbopomofo[] = "zhbopomofo";
static const char glyph_zhearmenian[] = "zhearmenian";
static const char glyph_zhebrevecyrillic[] = "zhebrevecyrillic";
static const char glyph_zhecyrillic[] = "zhecyrillic";
static const char glyph_zhedescendercyrillic[] = "zhedescendercyrillic";
static const char glyph_zhedieresiscyrillic[] = "zhedieresiscyrillic";
static const char glyph_zihiragana[] = "zihiragana";
static const char glyph_zikatakana[] = "zikatakana";
static const char glyph_zinorhebrew[] = "zinorhebrew";
static const char glyph_zlinebelow[] = "zlinebelow";
static const char glyph_zmonospace[] = "zmonospace";
static const char glyph_zohiragana[] = "zohiragana";
static const char glyph_zokatakana[] = "zokatakana";
static const char glyph_zparen[] = "zparen";
static const char glyph_zretroflexhook[] = "zretroflexhook";
static const char glyph_zstroke[] = "zstroke";
static const char glyph_zuhiragana[] = "zuhiragana";
static const char glyph_zukatakana[] = "zukatakana";


/* Glyph names of ZapfDingbats font */
static const char glyph_a100[] = "a100";
static const char glyph_a101[] = "a101";
static const char glyph_a102[] = "a102";
static const char glyph_a103[] = "a103";
static const char glyph_a104[] = "a104";
static const char glyph_a105[] = "a105";
static const char glyph_a106[] = "a106";
static const char glyph_a107[] = "a107";
static const char glyph_a108[] = "a108";
static const char glyph_a109[] = "a109";
static const char glyph_a10[] = "a10";
static const char glyph_a110[] = "a110";
static const char glyph_a111[] = "a111";
static const char glyph_a112[] = "a112";
static const char glyph_a117[] = "a117";
static const char glyph_a118[] = "a118";
static const char glyph_a119[] = "a119";
static const char glyph_a11[] = "a11";
static const char glyph_a120[] = "a120";
static const char glyph_a121[] = "a121";
static const char glyph_a122[] = "a122";
static const char glyph_a123[] = "a123";
static const char glyph_a124[] = "a124";
static const char glyph_a125[] = "a125";
static const char glyph_a126[] = "a126";
static const char glyph_a127[] = "a127";
static const char glyph_a128[] = "a128";
static const char glyph_a129[] = "a129";
static const char glyph_a12[] = "a12";
static const char glyph_a130[] = "a130";
static const char glyph_a131[] = "a131";
static const char glyph_a132[] = "a132";
static const char glyph_a133[] = "a133";
static const char glyph_a134[] = "a134";
static const char glyph_a135[] = "a135";
static const char glyph_a136[] = "a136";
static const char glyph_a137[] = "a137";
static const char glyph_a138[] = "a138";
static const char glyph_a139[] = "a139";
static const char glyph_a13[] = "a13";
static const char glyph_a140[] = "a140";
static const char glyph_a141[] = "a141";
static const char glyph_a142[] = "a142";
static const char glyph_a143[] = "a143";
static const char glyph_a144[] = "a144";
static const char glyph_a145[] = "a145";
static const char glyph_a146[] = "a146";
static const char glyph_a147[] = "a147";
static const char glyph_a148[] = "a148";
static const char glyph_a149[] = "a149";
static const char glyph_a14[] = "a14";
static const char glyph_a150[] = "a150";
static const char glyph_a151[] = "a151";
static const char glyph_a152[] = "a152";
static const char glyph_a153[] = "a153";
static const char glyph_a154[] = "a154";
static const char glyph_a155[] = "a155";
static const char glyph_a156[] = "a156";
static const char glyph_a157[] = "a157";
static const char glyph_a158[] = "a158";
static const char glyph_a159[] = "a159";
static const char glyph_a15[] = "a15";
static const char glyph_a160[] = "a160";
static const char glyph_a161[] = "a161";
static const char glyph_a162[] = "a162";
static const char glyph_a163[] = "a163";
static const char glyph_a164[] = "a164";
static const char glyph_a165[] = "a165";
static const char glyph_a166[] = "a166";
static const char glyph_a167[] = "a167";
static const char glyph_a168[] = "a168";
static const char glyph_a169[] = "a169";
static const char glyph_a16[] = "a16";
static const char glyph_a170[] = "a170";
static const char glyph_a171[] = "a171";
static const char glyph_a172[] = "a172";
static const char glyph_a173[] = "a173";
static const char glyph_a174[] = "a174";
static const char glyph_a175[] = "a175";
static const char glyph_a176[] = "a176";
static const char glyph_a177[] = "a177";
static const char glyph_a178[] = "a178";
static const char glyph_a179[] = "a179";
static const char glyph_a17[] = "a17";
static const char glyph_a180[] = "a180";
static const char glyph_a181[] = "a181";
static const char glyph_a182[] = "a182";
static const char glyph_a183[] = "a183";
static const char glyph_a184[] = "a184";
static const char glyph_a185[] = "a185";
static const char glyph_a186[] = "a186";
static const char glyph_a187[] = "a187";
static const char glyph_a188[] = "a188";
static const char glyph_a189[] = "a189";
static const char glyph_a18[] = "a18";
static const char glyph_a190[] = "a190";
static const char glyph_a191[] = "a191";
static const char glyph_a192[] = "a192";
static const char glyph_a193[] = "a193";
static const char glyph_a194[] = "a194";
static const char glyph_a195[] = "a195";
static const char glyph_a196[] = "a196";
static const char glyph_a197[] = "a197";
static const char glyph_a198[] = "a198";
static const char glyph_a199[] = "a199";
static const char glyph_a19[] = "a19";
static const char glyph_a1[] = "a1";
static const char glyph_a200[] = "a200";
static const char glyph_a201[] = "a201";
static const char glyph_a202[] = "a202";
static const char glyph_a203[] = "a203";
static const char glyph_a204[] = "a204";
static const char glyph_a205[] = "a205";
static const char glyph_a206[] = "a206";
static const char glyph_a20[] = "a20";
static const char glyph_a21[] = "a21";
static const char glyph_a22[] = "a22";
static const char glyph_a23[] = "a23";
static const char glyph_a24[] = "a24";
static const char glyph_a25[] = "a25";
static const char glyph_a26[] = "a26";
static const char glyph_a27[] = "a27";
static const char glyph_a28[] = "a28";
static const char glyph_a29[] = "a29";
static const char glyph_a2[] = "a2";
static const char glyph_a30[] = "a30";
static const char glyph_a31[] = "a31";
static const char glyph_a32[] = "a32";
static const char glyph_a33[] = "a33";
static const char glyph_a34[] = "a34";
static const char glyph_a35[] = "a35";
static const char glyph_a36[] = "a36";
static const char glyph_a37[] = "a37";
static const char glyph_a38[] = "a38";
static const char glyph_a39[] = "a39";
static const char glyph_a3[] = "a3";
static const char glyph_a40[] = "a40";
static const char glyph_a41[] = "a41";
static const char glyph_a42[] = "a42";
static const char glyph_a43[] = "a43";
static const char glyph_a44[] = "a44";
static const char glyph_a45[] = "a45";
static const char glyph_a46[] = "a46";
static const char glyph_a47[] = "a47";
static const char glyph_a48[] = "a48";
static const char glyph_a49[] = "a49";
static const char glyph_a4[] = "a4";
static const char glyph_a50[] = "a50";
static const char glyph_a51[] = "a51";
static const char glyph_a52[] = "a52";
static const char glyph_a53[] = "a53";
static const char glyph_a54[] = "a54";
static const char glyph_a55[] = "a55";
static const char glyph_a56[] = "a56";
static const char glyph_a57[] = "a57";
static const char glyph_a58[] = "a58";
static const char glyph_a59[] = "a59";
static const char glyph_a5[] = "a5";
static const char glyph_a60[] = "a60";
static const char glyph_a61[] = "a61";
static const char glyph_a62[] = "a62";
static const char glyph_a63[] = "a63";
static const char glyph_a64[] = "a64";
static const char glyph_a65[] = "a65";
static const char glyph_a66[] = "a66";
static const char glyph_a67[] = "a67";
static const char glyph_a68[] = "a68";
static const char glyph_a69[] = "a69";
static const char glyph_a6[] = "a6";
static const char glyph_a70[] = "a70";
static const char glyph_a71[] = "a71";
static const char glyph_a72[] = "a72";
static const char glyph_a73[] = "a73";
static const char glyph_a74[] = "a74";
static const char glyph_a75[] = "a75";
static const char glyph_a76[] = "a76";
static const char glyph_a77[] = "a77";
static const char glyph_a78[] = "a78";
static const char glyph_a79[] = "a79";
static const char glyph_a7[] = "a7";
static const char glyph_a81[] = "a81";
static const char glyph_a82[] = "a82";
static const char glyph_a83[] = "a83";
static const char glyph_a84[] = "a84";
static const char glyph_a85[] = "a85";
static const char glyph_a86[] = "a86";
static const char glyph_a87[] = "a87";
static const char glyph_a88[] = "a88";
static const char glyph_a89[] = "a89";
static const char glyph_a8[] = "a8";
static const char glyph_a90[] = "a90";
static const char glyph_a91[] = "a91";
static const char glyph_a92[] = "a92";
static const char glyph_a93[] = "a93";
static const char glyph_a94[] = "a94";
static const char glyph_a95[] = "a95";
static const char glyph_a96[] = "a96";
static const char glyph_a97[] = "a97";
static const char glyph_a98[] = "a98";
static const char glyph_a99[] = "a99";
static const char glyph_a9[] = "a9";


/*
 * Adobe Glyph List (AGL) version 1.2'  -  sorted by names
 *
 * Version 1.2' means:
 * Version 1.2 + resolved double-mappings by following
 * glyph names defined in AGL version 2.0:
 *
 *      Deltagreek (Delta)
 *      Omegagreek (Omega)
 *      Tcedilla (Tcommaaccent)
 *      bulletoperator (periodcentered)
 *      divisionslash (fraction)
 *      firsttonechinese (macron)
 *      mugreek (mu)
 *      nbspace (space)
 *      sfthyphen (hyphen)
 *      tcedilla (tcommaaccent)
 *
 * (cf. table 'tab_double_mappping' below and
 *      function 'pdc_get_alter_glyphname')
 *
 */

static const pdc_glyph_tab tab_agl2uni[] =
{
#ifndef PDFLIB_EBCDIC
    { 0x0000, glyph__notdef },
    { 0x0041, glyph_A },
    { 0x00C6, glyph_AE },
    { 0x01FC, glyph_AEacute },
    { 0xF7E6, glyph_AEsmall },
    { 0x00C1, glyph_Aacute },
    { 0xF7E1, glyph_Aacutesmall },
    { 0x0102, glyph_Abreve },
    { 0x00C2, glyph_Acircumflex },
    { 0xF7E2, glyph_Acircumflexsmall },
    { 0xF6C9, glyph_Acute },
    { 0xF7B4, glyph_Acutesmall },
    { 0x00C4, glyph_Adieresis },
    { 0xF7E4, glyph_Adieresissmall },
    { 0x00C0, glyph_Agrave },
    { 0xF7E0, glyph_Agravesmall },
    { 0x0391, glyph_Alpha },
    { 0x0386, glyph_Alphatonos },
    { 0x0100, glyph_Amacron },
    { 0x0104, glyph_Aogonek },
    { 0x00C5, glyph_Aring },
    { 0x01FA, glyph_Aringacute },
    { 0xF7E5, glyph_Aringsmall },
    { 0xF761, glyph_Asmall },
    { 0x00C3, glyph_Atilde },
    { 0xF7E3, glyph_Atildesmall },
    { 0x0042, glyph_B },
    { 0x0392, glyph_Beta },
    { 0xF6F4, glyph_Brevesmall },
    { 0xF762, glyph_Bsmall },
    { 0x0043, glyph_C },
    { 0x0106, glyph_Cacute },
    { 0xF6CA, glyph_Caron },
    { 0xF6F5, glyph_Caronsmall },
    { 0x010C, glyph_Ccaron },
    { 0x00C7, glyph_Ccedilla },
    { 0xF7E7, glyph_Ccedillasmall },
    { 0x0108, glyph_Ccircumflex },
    { 0x010A, glyph_Cdotaccent },
    { 0xF7B8, glyph_Cedillasmall },
    { 0x03A7, glyph_Chi },
    { 0xF6F6, glyph_Circumflexsmall },
    { 0xF763, glyph_Csmall },
    { 0x0044, glyph_D },
    { 0x010E, glyph_Dcaron },
    { 0x0110, glyph_Dcroat },
    { 0x2206, glyph_Delta },
    { 0x0394, glyph_Deltagreek },
    { 0xF6CB, glyph_Dieresis },
    { 0xF6CC, glyph_DieresisAcute },
    { 0xF6CD, glyph_DieresisGrave },
    { 0xF7A8, glyph_Dieresissmall },
    { 0xF6F7, glyph_Dotaccentsmall },
    { 0xF764, glyph_Dsmall },
    { 0x0045, glyph_E },
    { 0x00C9, glyph_Eacute },
    { 0xF7E9, glyph_Eacutesmall },
    { 0x0114, glyph_Ebreve },
    { 0x011A, glyph_Ecaron },
    { 0x00CA, glyph_Ecircumflex },
    { 0xF7EA, glyph_Ecircumflexsmall },
    { 0x00CB, glyph_Edieresis },
    { 0xF7EB, glyph_Edieresissmall },
    { 0x0116, glyph_Edotaccent },
    { 0x00C8, glyph_Egrave },
    { 0xF7E8, glyph_Egravesmall },
    { 0x0112, glyph_Emacron },
    { 0x014A, glyph_Eng },
    { 0x0118, glyph_Eogonek },
    { 0x0395, glyph_Epsilon },
    { 0x0388, glyph_Epsilontonos },
    { 0xF765, glyph_Esmall },
    { 0x0397, glyph_Eta },
    { 0x0389, glyph_Etatonos },
    { 0x00D0, glyph_Eth },
    { 0xF7F0, glyph_Ethsmall },
    { 0x20AC, glyph_Euro },
    { 0x0046, glyph_F },
    { 0xF766, glyph_Fsmall },
    { 0x0047, glyph_G },
    { 0x0393, glyph_Gamma },
    { 0x011E, glyph_Gbreve },
    { 0x01E6, glyph_Gcaron },
    { 0x011C, glyph_Gcircumflex },
    { 0x0122, glyph_Gcommaaccent },
    { 0x0120, glyph_Gdotaccent },
    { 0xF6CE, glyph_Grave },
    { 0xF760, glyph_Gravesmall },
    { 0xF767, glyph_Gsmall },
    { 0x0048, glyph_H },
    { 0x25CF, glyph_H18533 },
    { 0x25AA, glyph_H18543 },
    { 0x25AB, glyph_H18551 },
    { 0x25A1, glyph_H22073 },
    { 0x0126, glyph_Hbar },
    { 0x0124, glyph_Hcircumflex },
    { 0xF768, glyph_Hsmall },
    { 0xF6CF, glyph_Hungarumlaut },
    { 0xF6F8, glyph_Hungarumlautsmall },
    { 0x0049, glyph_I },
    { 0x0132, glyph_IJ },
    { 0x00CD, glyph_Iacute },
    { 0xF7ED, glyph_Iacutesmall },
    { 0x012C, glyph_Ibreve },
    { 0x00CE, glyph_Icircumflex },
    { 0xF7EE, glyph_Icircumflexsmall },
    { 0x00CF, glyph_Idieresis },
    { 0xF7EF, glyph_Idieresissmall },
    { 0x0130, glyph_Idotaccent },
    { 0x2111, glyph_Ifraktur },
    { 0x00CC, glyph_Igrave },
    { 0xF7EC, glyph_Igravesmall },
    { 0x012A, glyph_Imacron },
    { 0x012E, glyph_Iogonek },
    { 0x0399, glyph_Iota },
    { 0x03AA, glyph_Iotadieresis },
    { 0x038A, glyph_Iotatonos },
    { 0xF769, glyph_Ismall },
    { 0x0128, glyph_Itilde },
    { 0x004A, glyph_J },
    { 0x0134, glyph_Jcircumflex },
    { 0xF76A, glyph_Jsmall },
    { 0x004B, glyph_K },
    { 0x039A, glyph_Kappa },
    { 0x0136, glyph_Kcommaaccent },
    { 0xF76B, glyph_Ksmall },
    { 0x004C, glyph_L },
    { 0xF6BF, glyph_LL },
    { 0x0139, glyph_Lacute },
    { 0x039B, glyph_Lambda },
    { 0x013D, glyph_Lcaron },
    { 0x013B, glyph_Lcommaaccent },
    { 0x013F, glyph_Ldot },
    { 0x0141, glyph_Lslash },
    { 0xF6F9, glyph_Lslashsmall },
    { 0xF76C, glyph_Lsmall },
    { 0x004D, glyph_M },
    { 0xF6D0, glyph_Macron },
    { 0xF7AF, glyph_Macronsmall },
    { 0xF76D, glyph_Msmall },
    { 0x039C, glyph_Mu },
    { 0x004E, glyph_N },
    { 0x0143, glyph_Nacute },
    { 0x0147, glyph_Ncaron },
    { 0x0145, glyph_Ncommaaccent },
    { 0xF76E, glyph_Nsmall },
    { 0x00D1, glyph_Ntilde },
    { 0xF7F1, glyph_Ntildesmall },
    { 0x039D, glyph_Nu },
    { 0x004F, glyph_O },
    { 0x0152, glyph_OE },
    { 0xF6FA, glyph_OEsmall },
    { 0x00D3, glyph_Oacute },
    { 0xF7F3, glyph_Oacutesmall },
    { 0x014E, glyph_Obreve },
    { 0x00D4, glyph_Ocircumflex },
    { 0xF7F4, glyph_Ocircumflexsmall },
    { 0x00D6, glyph_Odieresis },
    { 0xF7F6, glyph_Odieresissmall },
    { 0xF6FB, glyph_Ogoneksmall },
    { 0x00D2, glyph_Ograve },
    { 0xF7F2, glyph_Ogravesmall },
    { 0x01A0, glyph_Ohorn },
    { 0x0150, glyph_Ohungarumlaut },
    { 0x014C, glyph_Omacron },
    { 0x2126, glyph_Omega },
    { 0x03A9, glyph_Omegagreek },
    { 0x038F, glyph_Omegatonos },
    { 0x039F, glyph_Omicron },
    { 0x038C, glyph_Omicrontonos },
    { 0x00D8, glyph_Oslash },
    { 0x01FE, glyph_Oslashacute },
    { 0xF7F8, glyph_Oslashsmall },
    { 0xF76F, glyph_Osmall },
    { 0x00D5, glyph_Otilde },
    { 0xF7F5, glyph_Otildesmall },
    { 0x0050, glyph_P },
    { 0x03A6, glyph_Phi },
    { 0x03A0, glyph_Pi },
    { 0x03A8, glyph_Psi },
    { 0xF770, glyph_Psmall },
    { 0x0051, glyph_Q },
    { 0xF771, glyph_Qsmall },
    { 0x0052, glyph_R },
    { 0x0154, glyph_Racute },
    { 0x0158, glyph_Rcaron },
    { 0x0156, glyph_Rcommaaccent },
    { 0x211C, glyph_Rfraktur },
    { 0x03A1, glyph_Rho },
    { 0xF6FC, glyph_Ringsmall },
    { 0xF772, glyph_Rsmall },
    { 0x0053, glyph_S },
    { 0x250C, glyph_SF010000 },
    { 0x2514, glyph_SF020000 },
    { 0x2510, glyph_SF030000 },
    { 0x2518, glyph_SF040000 },
    { 0x253C, glyph_SF050000 },
    { 0x252C, glyph_SF060000 },
    { 0x2534, glyph_SF070000 },
    { 0x251C, glyph_SF080000 },
    { 0x2524, glyph_SF090000 },
    { 0x2500, glyph_SF100000 },
    { 0x2502, glyph_SF110000 },
    { 0x2561, glyph_SF190000 },
    { 0x2562, glyph_SF200000 },
    { 0x2556, glyph_SF210000 },
    { 0x2555, glyph_SF220000 },
    { 0x2563, glyph_SF230000 },
    { 0x2551, glyph_SF240000 },
    { 0x2557, glyph_SF250000 },
    { 0x255D, glyph_SF260000 },
    { 0x255C, glyph_SF270000 },
    { 0x255B, glyph_SF280000 },
    { 0x255E, glyph_SF360000 },
    { 0x255F, glyph_SF370000 },
    { 0x255A, glyph_SF380000 },
    { 0x2554, glyph_SF390000 },
    { 0x2569, glyph_SF400000 },
    { 0x2566, glyph_SF410000 },
    { 0x2560, glyph_SF420000 },
    { 0x2550, glyph_SF430000 },
    { 0x256C, glyph_SF440000 },
    { 0x2567, glyph_SF450000 },
    { 0x2568, glyph_SF460000 },
    { 0x2564, glyph_SF470000 },
    { 0x2565, glyph_SF480000 },
    { 0x2559, glyph_SF490000 },
    { 0x2558, glyph_SF500000 },
    { 0x2552, glyph_SF510000 },
    { 0x2553, glyph_SF520000 },
    { 0x256B, glyph_SF530000 },
    { 0x256A, glyph_SF540000 },
    { 0x015A, glyph_Sacute },
    { 0x0160, glyph_Scaron },
    { 0xF6FD, glyph_Scaronsmall },
    { 0x015E, glyph_Scedilla },
    { 0x015C, glyph_Scircumflex },
    { 0x0218, glyph_Scommaaccent },
    { 0x03A3, glyph_Sigma },
    { 0xF773, glyph_Ssmall },
    { 0x0054, glyph_T },
    { 0x03A4, glyph_Tau },
    { 0x0166, glyph_Tbar },
    { 0x0164, glyph_Tcaron },
    { 0x0162, glyph_Tcedilla },
    { 0x021A, glyph_Tcommaaccent },
    { 0x0398, glyph_Theta },
    { 0x00DE, glyph_Thorn },
    { 0xF7FE, glyph_Thornsmall },
    { 0xF6FE, glyph_Tildesmall },
    { 0xF774, glyph_Tsmall },
    { 0x0055, glyph_U },
    { 0x00DA, glyph_Uacute },
    { 0xF7FA, glyph_Uacutesmall },
    { 0x016C, glyph_Ubreve },
    { 0x00DB, glyph_Ucircumflex },
    { 0xF7FB, glyph_Ucircumflexsmall },
    { 0x00DC, glyph_Udieresis },
    { 0xF7FC, glyph_Udieresissmall },
    { 0x00D9, glyph_Ugrave },
    { 0xF7F9, glyph_Ugravesmall },
    { 0x01AF, glyph_Uhorn },
    { 0x0170, glyph_Uhungarumlaut },
    { 0x016A, glyph_Umacron },
    { 0x0172, glyph_Uogonek },
    { 0x03A5, glyph_Upsilon },
    { 0x03D2, glyph_Upsilon1 },
    { 0x03AB, glyph_Upsilondieresis },
    { 0x038E, glyph_Upsilontonos },
    { 0x016E, glyph_Uring },
    { 0xF775, glyph_Usmall },
    { 0x0168, glyph_Utilde },
    { 0x0056, glyph_V },
    { 0xF776, glyph_Vsmall },
    { 0x0057, glyph_W },
    { 0x1E82, glyph_Wacute },
    { 0x0174, glyph_Wcircumflex },
    { 0x1E84, glyph_Wdieresis },
    { 0x1E80, glyph_Wgrave },
    { 0xF777, glyph_Wsmall },
    { 0x0058, glyph_X },
    { 0x039E, glyph_Xi },
    { 0xF778, glyph_Xsmall },
    { 0x0059, glyph_Y },
    { 0x00DD, glyph_Yacute },
    { 0xF7FD, glyph_Yacutesmall },
    { 0x0176, glyph_Ycircumflex },
    { 0x0178, glyph_Ydieresis },
    { 0xF7FF, glyph_Ydieresissmall },
    { 0x1EF2, glyph_Ygrave },
    { 0xF779, glyph_Ysmall },
    { 0x005A, glyph_Z },
    { 0x0179, glyph_Zacute },
    { 0x017D, glyph_Zcaron },
    { 0xF6FF, glyph_Zcaronsmall },
    { 0x017B, glyph_Zdotaccent },
    { 0x0396, glyph_Zeta },
    { 0xF77A, glyph_Zsmall },
    { 0x0061, glyph_a },
    { 0x00E1, glyph_aacute },
    { 0x0103, glyph_abreve },
    { 0x00E2, glyph_acircumflex },
    { 0x00B4, glyph_acute },
    { 0x0301, glyph_acutecomb },
    { 0x00E4, glyph_adieresis },
    { 0x00E6, glyph_ae },
    { 0x01FD, glyph_aeacute },
    { 0x2015, glyph_afii00208 },
    { 0x0410, glyph_afii10017 },
    { 0x0411, glyph_afii10018 },
    { 0x0412, glyph_afii10019 },
    { 0x0413, glyph_afii10020 },
    { 0x0414, glyph_afii10021 },
    { 0x0415, glyph_afii10022 },
    { 0x0401, glyph_afii10023 },
    { 0x0416, glyph_afii10024 },
    { 0x0417, glyph_afii10025 },
    { 0x0418, glyph_afii10026 },
    { 0x0419, glyph_afii10027 },
    { 0x041A, glyph_afii10028 },
    { 0x041B, glyph_afii10029 },
    { 0x041C, glyph_afii10030 },
    { 0x041D, glyph_afii10031 },
    { 0x041E, glyph_afii10032 },
    { 0x041F, glyph_afii10033 },
    { 0x0420, glyph_afii10034 },
    { 0x0421, glyph_afii10035 },
    { 0x0422, glyph_afii10036 },
    { 0x0423, glyph_afii10037 },
    { 0x0424, glyph_afii10038 },
    { 0x0425, glyph_afii10039 },
    { 0x0426, glyph_afii10040 },
    { 0x0427, glyph_afii10041 },
    { 0x0428, glyph_afii10042 },
    { 0x0429, glyph_afii10043 },
    { 0x042A, glyph_afii10044 },
    { 0x042B, glyph_afii10045 },
    { 0x042C, glyph_afii10046 },
    { 0x042D, glyph_afii10047 },
    { 0x042E, glyph_afii10048 },
    { 0x042F, glyph_afii10049 },
    { 0x0490, glyph_afii10050 },
    { 0x0402, glyph_afii10051 },
    { 0x0403, glyph_afii10052 },
    { 0x0404, glyph_afii10053 },
    { 0x0405, glyph_afii10054 },
    { 0x0406, glyph_afii10055 },
    { 0x0407, glyph_afii10056 },
    { 0x0408, glyph_afii10057 },
    { 0x0409, glyph_afii10058 },
    { 0x040A, glyph_afii10059 },
    { 0x040B, glyph_afii10060 },
    { 0x040C, glyph_afii10061 },
    { 0x040E, glyph_afii10062 },
    { 0xF6C4, glyph_afii10063 },
    { 0xF6C5, glyph_afii10064 },
    { 0x0430, glyph_afii10065 },
    { 0x0431, glyph_afii10066 },
    { 0x0432, glyph_afii10067 },
    { 0x0433, glyph_afii10068 },
    { 0x0434, glyph_afii10069 },
    { 0x0435, glyph_afii10070 },
    { 0x0451, glyph_afii10071 },
    { 0x0436, glyph_afii10072 },
    { 0x0437, glyph_afii10073 },
    { 0x0438, glyph_afii10074 },
    { 0x0439, glyph_afii10075 },
    { 0x043A, glyph_afii10076 },
    { 0x043B, glyph_afii10077 },
    { 0x043C, glyph_afii10078 },
    { 0x043D, glyph_afii10079 },
    { 0x043E, glyph_afii10080 },
    { 0x043F, glyph_afii10081 },
    { 0x0440, glyph_afii10082 },
    { 0x0441, glyph_afii10083 },
    { 0x0442, glyph_afii10084 },
    { 0x0443, glyph_afii10085 },
    { 0x0444, glyph_afii10086 },
    { 0x0445, glyph_afii10087 },
    { 0x0446, glyph_afii10088 },
    { 0x0447, glyph_afii10089 },
    { 0x0448, glyph_afii10090 },
    { 0x0449, glyph_afii10091 },
    { 0x044A, glyph_afii10092 },
    { 0x044B, glyph_afii10093 },
    { 0x044C, glyph_afii10094 },
    { 0x044D, glyph_afii10095 },
    { 0x044E, glyph_afii10096 },
    { 0x044F, glyph_afii10097 },
    { 0x0491, glyph_afii10098 },
    { 0x0452, glyph_afii10099 },
    { 0x0453, glyph_afii10100 },
    { 0x0454, glyph_afii10101 },
    { 0x0455, glyph_afii10102 },
    { 0x0456, glyph_afii10103 },
    { 0x0457, glyph_afii10104 },
    { 0x0458, glyph_afii10105 },
    { 0x0459, glyph_afii10106 },
    { 0x045A, glyph_afii10107 },
    { 0x045B, glyph_afii10108 },
    { 0x045C, glyph_afii10109 },
    { 0x045E, glyph_afii10110 },
    { 0x040F, glyph_afii10145 },
    { 0x0462, glyph_afii10146 },
    { 0x0472, glyph_afii10147 },
    { 0x0474, glyph_afii10148 },
    { 0xF6C6, glyph_afii10192 },
    { 0x045F, glyph_afii10193 },
    { 0x0463, glyph_afii10194 },
    { 0x0473, glyph_afii10195 },
    { 0x0475, glyph_afii10196 },
    { 0xF6C7, glyph_afii10831 },
    { 0xF6C8, glyph_afii10832 },
    { 0x04D9, glyph_afii10846 },
    { 0x200E, glyph_afii299 },
    { 0x200F, glyph_afii300 },
    { 0x200D, glyph_afii301 },
    { 0x066A, glyph_afii57381 },
    { 0x060C, glyph_afii57388 },
    { 0x0660, glyph_afii57392 },
    { 0x0661, glyph_afii57393 },
    { 0x0662, glyph_afii57394 },
    { 0x0663, glyph_afii57395 },
    { 0x0664, glyph_afii57396 },
    { 0x0665, glyph_afii57397 },
    { 0x0666, glyph_afii57398 },
    { 0x0667, glyph_afii57399 },
    { 0x0668, glyph_afii57400 },
    { 0x0669, glyph_afii57401 },
    { 0x061B, glyph_afii57403 },
    { 0x061F, glyph_afii57407 },
    { 0x0621, glyph_afii57409 },
    { 0x0622, glyph_afii57410 },
    { 0x0623, glyph_afii57411 },
    { 0x0624, glyph_afii57412 },
    { 0x0625, glyph_afii57413 },
    { 0x0626, glyph_afii57414 },
    { 0x0627, glyph_afii57415 },
    { 0x0628, glyph_afii57416 },
    { 0x0629, glyph_afii57417 },
    { 0x062A, glyph_afii57418 },
    { 0x062B, glyph_afii57419 },
    { 0x062C, glyph_afii57420 },
    { 0x062D, glyph_afii57421 },
    { 0x062E, glyph_afii57422 },
    { 0x062F, glyph_afii57423 },
    { 0x0630, glyph_afii57424 },
    { 0x0631, glyph_afii57425 },
    { 0x0632, glyph_afii57426 },
    { 0x0633, glyph_afii57427 },
    { 0x0634, glyph_afii57428 },
    { 0x0635, glyph_afii57429 },
    { 0x0636, glyph_afii57430 },
    { 0x0637, glyph_afii57431 },
    { 0x0638, glyph_afii57432 },
    { 0x0639, glyph_afii57433 },
    { 0x063A, glyph_afii57434 },
    { 0x0640, glyph_afii57440 },
    { 0x0641, glyph_afii57441 },
    { 0x0642, glyph_afii57442 },
    { 0x0643, glyph_afii57443 },
    { 0x0644, glyph_afii57444 },
    { 0x0645, glyph_afii57445 },
    { 0x0646, glyph_afii57446 },
    { 0x0648, glyph_afii57448 },
    { 0x0649, glyph_afii57449 },
    { 0x064A, glyph_afii57450 },
    { 0x064B, glyph_afii57451 },
    { 0x064C, glyph_afii57452 },
    { 0x064D, glyph_afii57453 },
    { 0x064E, glyph_afii57454 },
    { 0x064F, glyph_afii57455 },
    { 0x0650, glyph_afii57456 },
    { 0x0651, glyph_afii57457 },
    { 0x0652, glyph_afii57458 },
    { 0x0647, glyph_afii57470 },
    { 0x06A4, glyph_afii57505 },
    { 0x067E, glyph_afii57506 },
    { 0x0686, glyph_afii57507 },
    { 0x0698, glyph_afii57508 },
    { 0x06AF, glyph_afii57509 },
    { 0x0679, glyph_afii57511 },
    { 0x0688, glyph_afii57512 },
    { 0x0691, glyph_afii57513 },
    { 0x06BA, glyph_afii57514 },
    { 0x06D2, glyph_afii57519 },
    { 0x06D5, glyph_afii57534 },
    { 0x20AA, glyph_afii57636 },
    { 0x05BE, glyph_afii57645 },
    { 0x05C3, glyph_afii57658 },
    { 0x05D0, glyph_afii57664 },
    { 0x05D1, glyph_afii57665 },
    { 0x05D2, glyph_afii57666 },
    { 0x05D3, glyph_afii57667 },
    { 0x05D4, glyph_afii57668 },
    { 0x05D5, glyph_afii57669 },
    { 0x05D6, glyph_afii57670 },
    { 0x05D7, glyph_afii57671 },
    { 0x05D8, glyph_afii57672 },
    { 0x05D9, glyph_afii57673 },
    { 0x05DA, glyph_afii57674 },
    { 0x05DB, glyph_afii57675 },
    { 0x05DC, glyph_afii57676 },
    { 0x05DD, glyph_afii57677 },
    { 0x05DE, glyph_afii57678 },
    { 0x05DF, glyph_afii57679 },
    { 0x05E0, glyph_afii57680 },
    { 0x05E1, glyph_afii57681 },
    { 0x05E2, glyph_afii57682 },
    { 0x05E3, glyph_afii57683 },
    { 0x05E4, glyph_afii57684 },
    { 0x05E5, glyph_afii57685 },
    { 0x05E6, glyph_afii57686 },
    { 0x05E7, glyph_afii57687 },
    { 0x05E8, glyph_afii57688 },
    { 0x05E9, glyph_afii57689 },
    { 0x05EA, glyph_afii57690 },
    { 0xFB2A, glyph_afii57694 },
    { 0xFB2B, glyph_afii57695 },
    { 0xFB4B, glyph_afii57700 },
    { 0xFB1F, glyph_afii57705 },
    { 0x05F0, glyph_afii57716 },
    { 0x05F1, glyph_afii57717 },
    { 0x05F2, glyph_afii57718 },
    { 0xFB35, glyph_afii57723 },
    { 0x05B4, glyph_afii57793 },
    { 0x05B5, glyph_afii57794 },
    { 0x05B6, glyph_afii57795 },
    { 0x05BB, glyph_afii57796 },
    { 0x05B8, glyph_afii57797 },
    { 0x05B7, glyph_afii57798 },
    { 0x05B0, glyph_afii57799 },
    { 0x05B2, glyph_afii57800 },
    { 0x05B1, glyph_afii57801 },
    { 0x05B3, glyph_afii57802 },
    { 0x05C2, glyph_afii57803 },
    { 0x05C1, glyph_afii57804 },
    { 0x05B9, glyph_afii57806 },
    { 0x05BC, glyph_afii57807 },
    { 0x05BD, glyph_afii57839 },
    { 0x05BF, glyph_afii57841 },
    { 0x05C0, glyph_afii57842 },
    { 0x02BC, glyph_afii57929 },
    { 0x2105, glyph_afii61248 },
    { 0x2113, glyph_afii61289 },
    { 0x2116, glyph_afii61352 },
    { 0x202C, glyph_afii61573 },
    { 0x202D, glyph_afii61574 },
    { 0x202E, glyph_afii61575 },
    { 0x200C, glyph_afii61664 },
    { 0x066D, glyph_afii63167 },
    { 0x02BD, glyph_afii64937 },
    { 0x00E0, glyph_agrave },
    { 0x2135, glyph_aleph },
    { 0x03B1, glyph_alpha },
    { 0x03AC, glyph_alphatonos },
    { 0x0101, glyph_amacron },
    { 0x0026, glyph_ampersand },
    { 0xF726, glyph_ampersandsmall },
    { 0x2220, glyph_angle },
    { 0x2329, glyph_angleleft },
    { 0x232A, glyph_angleright },
    { 0x0387, glyph_anoteleia },
    { 0x0105, glyph_aogonek },
    { 0xF8FF, glyph_apple },
    { 0x2248, glyph_approxequal },
    { 0x00E5, glyph_aring },
    { 0x01FB, glyph_aringacute },
    { 0x2194, glyph_arrowboth },
    { 0x21D4, glyph_arrowdblboth },
    { 0x21D3, glyph_arrowdbldown },
    { 0x21D0, glyph_arrowdblleft },
    { 0x21D2, glyph_arrowdblright },
    { 0x21D1, glyph_arrowdblup },
    { 0x2193, glyph_arrowdown },
    { 0xF8E7, glyph_arrowhorizex },
    { 0x2190, glyph_arrowleft },
    { 0x2192, glyph_arrowright },
    { 0x2191, glyph_arrowup },
    { 0x2195, glyph_arrowupdn },
    { 0x21A8, glyph_arrowupdnbse },
    { 0xF8E6, glyph_arrowvertex },
    { 0x005E, glyph_asciicircum },
    { 0x007E, glyph_asciitilde },
    { 0x002A, glyph_asterisk },
    { 0x2217, glyph_asteriskmath },
    { 0xF6E9, glyph_asuperior },
    { 0x0040, glyph_at },
    { 0x00E3, glyph_atilde },
    { 0x0062, glyph_b },
    { 0x005C, glyph_backslash },
    { 0x007C, glyph_bar },
    { 0x03B2, glyph_beta },
    { 0x2588, glyph_block },
    { 0xF8F4, glyph_braceex },
    { 0x007B, glyph_braceleft },
    { 0xF8F3, glyph_braceleftbt },
    { 0xF8F2, glyph_braceleftmid },
    { 0xF8F1, glyph_bracelefttp },
    { 0x007D, glyph_braceright },
    { 0xF8FE, glyph_bracerightbt },
    { 0xF8FD, glyph_bracerightmid },
    { 0xF8FC, glyph_bracerighttp },
    { 0x005B, glyph_bracketleft },
    { 0xF8F0, glyph_bracketleftbt },
    { 0xF8EF, glyph_bracketleftex },
    { 0xF8EE, glyph_bracketlefttp },
    { 0x005D, glyph_bracketright },
    { 0xF8FB, glyph_bracketrightbt },
    { 0xF8FA, glyph_bracketrightex },
    { 0xF8F9, glyph_bracketrighttp },
    { 0x02D8, glyph_breve },
    { 0x00A6, glyph_brokenbar },
    { 0xF6EA, glyph_bsuperior },
    { 0x2022, glyph_bullet },
    { 0x2219, glyph_bulletoperator },
    { 0x0063, glyph_c },
    { 0x0107, glyph_cacute },
    { 0x02C7, glyph_caron },
    { 0x21B5, glyph_carriagereturn },
    { 0x010D, glyph_ccaron },
    { 0x00E7, glyph_ccedilla },
    { 0x0109, glyph_ccircumflex },
    { 0x010B, glyph_cdotaccent },
    { 0x00B8, glyph_cedilla },
    { 0x00A2, glyph_cent },
    { 0xF6DF, glyph_centinferior },
    { 0xF7A2, glyph_centoldstyle },
    { 0xF6E0, glyph_centsuperior },
    { 0x03C7, glyph_chi },
    { 0x25CB, glyph_circle },
    { 0x2297, glyph_circlemultiply },
    { 0x2295, glyph_circleplus },
    { 0x02C6, glyph_circumflex },
    { 0x2663, glyph_club },
    { 0x003A, glyph_colon },
    { 0x20A1, glyph_colonmonetary },
    { 0x002C, glyph_comma },
    { 0xF6C3, glyph_commaaccent },
    { 0xF6E1, glyph_commainferior },
    { 0xF6E2, glyph_commasuperior },
    { 0x2245, glyph_congruent },
    { 0x00A9, glyph_copyright },
    { 0xF8E9, glyph_copyrightsans },
    { 0xF6D9, glyph_copyrightserif },
    { 0x00A4, glyph_currency },
    { 0xF6D1, glyph_cyrBreve },
    { 0xF6D2, glyph_cyrFlex },
    { 0xF6D4, glyph_cyrbreve },
    { 0xF6D5, glyph_cyrflex },
    { 0x0064, glyph_d },
    { 0x2020, glyph_dagger },
    { 0x2021, glyph_daggerdbl },
    { 0xF6D3, glyph_dblGrave },
    { 0xF6D6, glyph_dblgrave },
    { 0x010F, glyph_dcaron },
    { 0x0111, glyph_dcroat },
    { 0x00B0, glyph_degree },
    { 0x03B4, glyph_delta },
    { 0x2666, glyph_diamond },
    { 0x00A8, glyph_dieresis },
    { 0xF6D7, glyph_dieresisacute },
    { 0xF6D8, glyph_dieresisgrave },
    { 0x0385, glyph_dieresistonos },
    { 0x00F7, glyph_divide },
    { 0x2215, glyph_divisionslash },
    { 0x2593, glyph_dkshade },
    { 0x2584, glyph_dnblock },
    { 0x0024, glyph_dollar },
    { 0xF6E3, glyph_dollarinferior },
    { 0xF724, glyph_dollaroldstyle },
    { 0xF6E4, glyph_dollarsuperior },
    { 0x20AB, glyph_dong },
    { 0x02D9, glyph_dotaccent },
    { 0x0323, glyph_dotbelowcomb },
    { 0x0131, glyph_dotlessi },
    { 0xF6BE, glyph_dotlessj },
    { 0x22C5, glyph_dotmath },
    { 0xF6EB, glyph_dsuperior },
    { 0x0065, glyph_e },
    { 0x00E9, glyph_eacute },
    { 0x0115, glyph_ebreve },
    { 0x011B, glyph_ecaron },
    { 0x00EA, glyph_ecircumflex },
    { 0x00EB, glyph_edieresis },
    { 0x0117, glyph_edotaccent },
    { 0x00E8, glyph_egrave },
    { 0x0038, glyph_eight },
    { 0x2088, glyph_eightinferior },
    { 0xF738, glyph_eightoldstyle },
    { 0x2078, glyph_eightsuperior },
    { 0x2208, glyph_element },
    { 0x2026, glyph_ellipsis },
    { 0x0113, glyph_emacron },
    { 0x2014, glyph_emdash },
    { 0x2205, glyph_emptyset },
    { 0x2013, glyph_endash },
    { 0x014B, glyph_eng },
    { 0x0119, glyph_eogonek },
    { 0x03B5, glyph_epsilon },
    { 0x03AD, glyph_epsilontonos },
    { 0x003D, glyph_equal },
    { 0x2261, glyph_equivalence },
    { 0x212E, glyph_estimated },
    { 0xF6EC, glyph_esuperior },
    { 0x03B7, glyph_eta },
    { 0x03AE, glyph_etatonos },
    { 0x00F0, glyph_eth },
    { 0x0021, glyph_exclam },
    { 0x203C, glyph_exclamdbl },
    { 0x00A1, glyph_exclamdown },
    { 0xF7A1, glyph_exclamdownsmall },
    { 0xF721, glyph_exclamsmall },
    { 0x2203, glyph_existential },
    { 0x0066, glyph_f },
    { 0x2640, glyph_female },
    { 0xFB00, glyph_ff },
    { 0xFB03, glyph_ffi },
    { 0xFB04, glyph_ffl },
    { 0xFB01, glyph_fi },
    { 0x2012, glyph_figuredash },
    { 0x25A0, glyph_filledbox },
    { 0x25AC, glyph_filledrect },
    { 0x02C9, glyph_firsttonechinese },
    { 0x0035, glyph_five },
    { 0x215D, glyph_fiveeighths },
    { 0x2085, glyph_fiveinferior },
    { 0xF735, glyph_fiveoldstyle },
    { 0x2075, glyph_fivesuperior },
    { 0xFB02, glyph_fl },
    { 0x0192, glyph_florin },
    { 0x0034, glyph_four },
    { 0x2084, glyph_fourinferior },
    { 0xF734, glyph_fouroldstyle },
    { 0x2074, glyph_foursuperior },
    { 0x2044, glyph_fraction },
    { 0x20A3, glyph_franc },
    { 0x0067, glyph_g },
    { 0x03B3, glyph_gamma },
    { 0x011F, glyph_gbreve },
    { 0x01E7, glyph_gcaron },
    { 0x011D, glyph_gcircumflex },
    { 0x0123, glyph_gcommaaccent },
    { 0x0121, glyph_gdotaccent },
    { 0x00DF, glyph_germandbls },
    { 0x2207, glyph_gradient },
    { 0x0060, glyph_grave },
    { 0x0300, glyph_gravecomb },
    { 0x003E, glyph_greater },
    { 0x2265, glyph_greaterequal },
    { 0x00AB, glyph_guillemotleft },
    { 0x00BB, glyph_guillemotright },
    { 0x2039, glyph_guilsinglleft },
    { 0x203A, glyph_guilsinglright },
    { 0x0068, glyph_h },
    { 0x0127, glyph_hbar },
    { 0x0125, glyph_hcircumflex },
    { 0x2665, glyph_heart },
    { 0x0309, glyph_hookabovecomb },
    { 0x2302, glyph_house },
    { 0x02DD, glyph_hungarumlaut },
    { 0x002D, glyph_hyphen },
    { 0xF6E5, glyph_hypheninferior },
    { 0xF6E6, glyph_hyphensuperior },
    { 0x0069, glyph_i },
    { 0x00ED, glyph_iacute },
    { 0x012D, glyph_ibreve },
    { 0x00EE, glyph_icircumflex },
    { 0x00EF, glyph_idieresis },
    { 0x00EC, glyph_igrave },
    { 0x0133, glyph_ij },
    { 0x012B, glyph_imacron },
    { 0x221E, glyph_infinity },
    { 0x222B, glyph_integral },
    { 0x2321, glyph_integralbt },
    { 0xF8F5, glyph_integralex },
    { 0x2320, glyph_integraltp },
    { 0x2229, glyph_intersection },
    { 0x25D8, glyph_invbullet },
    { 0x25D9, glyph_invcircle },
    { 0x263B, glyph_invsmileface },
    { 0x012F, glyph_iogonek },
    { 0x03B9, glyph_iota },
    { 0x03CA, glyph_iotadieresis },
    { 0x0390, glyph_iotadieresistonos },
    { 0x03AF, glyph_iotatonos },
    { 0xF6ED, glyph_isuperior },
    { 0x0129, glyph_itilde },
    { 0x006A, glyph_j },
    { 0x0135, glyph_jcircumflex },
    { 0x006B, glyph_k },
    { 0x03BA, glyph_kappa },
    { 0x0137, glyph_kcommaaccent },
    { 0x0138, glyph_kgreenlandic },
    { 0x006C, glyph_l },
    { 0x013A, glyph_lacute },
    { 0x03BB, glyph_lambda },
    { 0x013E, glyph_lcaron },
    { 0x013C, glyph_lcommaaccent },
    { 0x0140, glyph_ldot },
    { 0x003C, glyph_less },
    { 0x2264, glyph_lessequal },
    { 0x258C, glyph_lfblock },
    { 0x20A4, glyph_lira },
    { 0xF6C0, glyph_ll },
    { 0x2227, glyph_logicaland },
    { 0x00AC, glyph_logicalnot },
    { 0x2228, glyph_logicalor },
    { 0x017F, glyph_longs },
    { 0x25CA, glyph_lozenge },
    { 0x0142, glyph_lslash },
    { 0xF6EE, glyph_lsuperior },
    { 0x2591, glyph_ltshade },
    { 0x006D, glyph_m },
    { 0x00AF, glyph_macron },
    { 0x2642, glyph_male },
    { 0x2212, glyph_minus },
    { 0x2032, glyph_minute },
    { 0xF6EF, glyph_msuperior },
    { 0x00B5, glyph_mu },
    { 0x03BC, glyph_mugreek },
    { 0x00D7, glyph_multiply },
    { 0x266A, glyph_musicalnote },
    { 0x266B, glyph_musicalnotedbl },
    { 0x006E, glyph_n },
    { 0x0144, glyph_nacute },
    { 0x0149, glyph_napostrophe },
    { 0x00A0, glyph_nbspace },
    { 0x0148, glyph_ncaron },
    { 0x0146, glyph_ncommaaccent },
    { 0x0039, glyph_nine },
    { 0x2089, glyph_nineinferior },
    { 0xF739, glyph_nineoldstyle },
    { 0x2079, glyph_ninesuperior },
    { 0x2209, glyph_notelement },
    { 0x2260, glyph_notequal },
    { 0x2284, glyph_notsubset },
    { 0x207F, glyph_nsuperior },
    { 0x00F1, glyph_ntilde },
    { 0x03BD, glyph_nu },
    { 0x0023, glyph_numbersign },
    { 0x006F, glyph_o },
    { 0x00F3, glyph_oacute },
    { 0x014F, glyph_obreve },
    { 0x00F4, glyph_ocircumflex },
    { 0x00F6, glyph_odieresis },
    { 0x0153, glyph_oe },
    { 0x02DB, glyph_ogonek },
    { 0x00F2, glyph_ograve },
    { 0x01A1, glyph_ohorn },
    { 0x0151, glyph_ohungarumlaut },
    { 0x014D, glyph_omacron },
    { 0x03C9, glyph_omega },
    { 0x03D6, glyph_omega1 },
    { 0x03CE, glyph_omegatonos },
    { 0x03BF, glyph_omicron },
    { 0x03CC, glyph_omicrontonos },
    { 0x0031, glyph_one },
    { 0x2024, glyph_onedotenleader },
    { 0x215B, glyph_oneeighth },
    { 0xF6DC, glyph_onefitted },
    { 0x00BD, glyph_onehalf },
    { 0x2081, glyph_oneinferior },
    { 0xF731, glyph_oneoldstyle },
    { 0x00BC, glyph_onequarter },
    { 0x00B9, glyph_onesuperior },
    { 0x2153, glyph_onethird },
    { 0x25E6, glyph_openbullet },
    { 0x00AA, glyph_ordfeminine },
    { 0x00BA, glyph_ordmasculine },
    { 0x221F, glyph_orthogonal },
    { 0x00F8, glyph_oslash },
    { 0x01FF, glyph_oslashacute },
    { 0xF6F0, glyph_osuperior },
    { 0x00F5, glyph_otilde },
    { 0x0070, glyph_p },
    { 0x00B6, glyph_paragraph },
    { 0x0028, glyph_parenleft },
    { 0xF8ED, glyph_parenleftbt },
    { 0xF8EC, glyph_parenleftex },
    { 0x208D, glyph_parenleftinferior },
    { 0x207D, glyph_parenleftsuperior },
    { 0xF8EB, glyph_parenlefttp },
    { 0x0029, glyph_parenright },
    { 0xF8F8, glyph_parenrightbt },
    { 0xF8F7, glyph_parenrightex },
    { 0x208E, glyph_parenrightinferior },
    { 0x207E, glyph_parenrightsuperior },
    { 0xF8F6, glyph_parenrighttp },
    { 0x2202, glyph_partialdiff },
    { 0x0025, glyph_percent },
    { 0x002E, glyph_period },
    { 0x00B7, glyph_periodcentered },
    { 0xF6E7, glyph_periodinferior },
    { 0xF6E8, glyph_periodsuperior },
    { 0x22A5, glyph_perpendicular },
    { 0x2030, glyph_perthousand },
    { 0x20A7, glyph_peseta },
    { 0x03C6, glyph_phi },
    { 0x03D5, glyph_phi1 },
    { 0x03C0, glyph_pi },
    { 0x002B, glyph_plus },
    { 0x00B1, glyph_plusminus },
    { 0x211E, glyph_prescription },
    { 0x220F, glyph_product },
    { 0x2282, glyph_propersubset },
    { 0x2283, glyph_propersuperset },
    { 0x221D, glyph_proportional },
    { 0x03C8, glyph_psi },
    { 0x0071, glyph_q },
    { 0x003F, glyph_question },
    { 0x00BF, glyph_questiondown },
    { 0xF7BF, glyph_questiondownsmall },
    { 0xF73F, glyph_questionsmall },
    { 0x0022, glyph_quotedbl },
    { 0x201E, glyph_quotedblbase },
    { 0x201C, glyph_quotedblleft },
    { 0x201D, glyph_quotedblright },
    { 0x2018, glyph_quoteleft },
    { 0x201B, glyph_quotereversed },
    { 0x2019, glyph_quoteright },
    { 0x201A, glyph_quotesinglbase },
    { 0x0027, glyph_quotesingle },
    { 0x0072, glyph_r },
    { 0x0155, glyph_racute },
    { 0x221A, glyph_radical },
    { 0xF8E5, glyph_radicalex },
    { 0x0159, glyph_rcaron },
    { 0x0157, glyph_rcommaaccent },
    { 0x2286, glyph_reflexsubset },
    { 0x2287, glyph_reflexsuperset },
    { 0x00AE, glyph_registered },
    { 0xF8E8, glyph_registersans },
    { 0xF6DA, glyph_registerserif },
    { 0x2310, glyph_revlogicalnot },
    { 0x03C1, glyph_rho },
    { 0x02DA, glyph_ring },
    { 0xF6F1, glyph_rsuperior },
    { 0x2590, glyph_rtblock },
    { 0xF6DD, glyph_rupiah },
    { 0x0073, glyph_s },
    { 0x015B, glyph_sacute },
    { 0x0161, glyph_scaron },
    { 0x015F, glyph_scedilla },
    { 0x015D, glyph_scircumflex },
    { 0x0219, glyph_scommaaccent },
    { 0x2033, glyph_second },
    { 0x00A7, glyph_section },
    { 0x003B, glyph_semicolon },
    { 0x0037, glyph_seven },
    { 0x215E, glyph_seveneighths },
    { 0x2087, glyph_seveninferior },
    { 0xF737, glyph_sevenoldstyle },
    { 0x2077, glyph_sevensuperior },
    { 0x00AD, glyph_sfthyphen },
    { 0x2592, glyph_shade },
    { 0x03C3, glyph_sigma },
    { 0x03C2, glyph_sigma1 },
    { 0x223C, glyph_similar },
    { 0x0036, glyph_six },
    { 0x2086, glyph_sixinferior },
    { 0xF736, glyph_sixoldstyle },
    { 0x2076, glyph_sixsuperior },
    { 0x002F, glyph_slash },
    { 0x263A, glyph_smileface },
    { 0x0020, glyph_space },
    { 0x2660, glyph_spade },
    { 0xF6F2, glyph_ssuperior },
    { 0x00A3, glyph_sterling },
    { 0x220B, glyph_suchthat },
    { 0x2211, glyph_summation },
    { 0x263C, glyph_sun },
    { 0x0074, glyph_t },
    { 0x03C4, glyph_tau },
    { 0x0167, glyph_tbar },
    { 0x0165, glyph_tcaron },
    { 0x0163, glyph_tcedilla },
    { 0x021B, glyph_tcommaaccent },
    { 0x2234, glyph_therefore },
    { 0x03B8, glyph_theta },
    { 0x03D1, glyph_theta1 },
    { 0x00FE, glyph_thorn },
    { 0x0033, glyph_three },
    { 0x215C, glyph_threeeighths },
    { 0x2083, glyph_threeinferior },
    { 0xF733, glyph_threeoldstyle },
    { 0x00BE, glyph_threequarters },
    { 0xF6DE, glyph_threequartersemdash },
    { 0x00B3, glyph_threesuperior },
    { 0x02DC, glyph_tilde },
    { 0x0303, glyph_tildecomb },
    { 0x0384, glyph_tonos },
    { 0x2122, glyph_trademark },
    { 0xF8EA, glyph_trademarksans },
    { 0xF6DB, glyph_trademarkserif },
    { 0x25BC, glyph_triagdn },
    { 0x25C4, glyph_triaglf },
    { 0x25BA, glyph_triagrt },
    { 0x25B2, glyph_triagup },
    { 0xF6F3, glyph_tsuperior },
    { 0x0032, glyph_two },
    { 0x2025, glyph_twodotenleader },
    { 0x2082, glyph_twoinferior },
    { 0xF732, glyph_twooldstyle },
    { 0x00B2, glyph_twosuperior },
    { 0x2154, glyph_twothirds },
    { 0x0075, glyph_u },
    { 0x00FA, glyph_uacute },
    { 0x016D, glyph_ubreve },
    { 0x00FB, glyph_ucircumflex },
    { 0x00FC, glyph_udieresis },
    { 0x00F9, glyph_ugrave },
    { 0x01B0, glyph_uhorn },
    { 0x0171, glyph_uhungarumlaut },
    { 0x016B, glyph_umacron },
    { 0x005F, glyph_underscore },
    { 0x2017, glyph_underscoredbl },
    { 0x222A, glyph_union },
    { 0x2200, glyph_universal },
    { 0x0173, glyph_uogonek },
    { 0x2580, glyph_upblock },
    { 0x03C5, glyph_upsilon },
    { 0x03CB, glyph_upsilondieresis },
    { 0x03B0, glyph_upsilondieresistonos },
    { 0x03CD, glyph_upsilontonos },
    { 0x016F, glyph_uring },
    { 0x0169, glyph_utilde },
    { 0x0076, glyph_v },
    { 0x0077, glyph_w },
    { 0x1E83, glyph_wacute },
    { 0x0175, glyph_wcircumflex },
    { 0x1E85, glyph_wdieresis },
    { 0x2118, glyph_weierstrass },
    { 0x1E81, glyph_wgrave },
    { 0x0078, glyph_x },
    { 0x03BE, glyph_xi },
    { 0x0079, glyph_y },
    { 0x00FD, glyph_yacute },
    { 0x0177, glyph_ycircumflex },
    { 0x00FF, glyph_ydieresis },
    { 0x00A5, glyph_yen },
    { 0x1EF3, glyph_ygrave },
    { 0x007A, glyph_z },
    { 0x017A, glyph_zacute },
    { 0x017E, glyph_zcaron },
    { 0x017C, glyph_zdotaccent },
    { 0x0030, glyph_zero },
    { 0x2080, glyph_zeroinferior },
    { 0xF730, glyph_zerooldstyle },
    { 0x2070, glyph_zerosuperior },
    { 0x03B6, glyph_zeta },
#else
#endif
}; /* tab_agl2uni */

/*
 * Adobe Glyph List (AGL) version 1.2  -  sorted by Unicode values
 */
static const pdc_glyph_tab tab_uni2agl[] =
{
    { 0x0020, glyph_space },
    { 0x0021, glyph_exclam },
    { 0x0022, glyph_quotedbl },
    { 0x0023, glyph_numbersign },
    { 0x0024, glyph_dollar },
    { 0x0025, glyph_percent },
    { 0x0026, glyph_ampersand },
    { 0x0027, glyph_quotesingle },
    { 0x0028, glyph_parenleft },
    { 0x0029, glyph_parenright },
    { 0x002A, glyph_asterisk },
    { 0x002B, glyph_plus },
    { 0x002C, glyph_comma },
    { 0x002D, glyph_hyphen },
    { 0x002E, glyph_period },
    { 0x002F, glyph_slash },
    { 0x0030, glyph_zero },
    { 0x0031, glyph_one },
    { 0x0032, glyph_two },
    { 0x0033, glyph_three },
    { 0x0034, glyph_four },
    { 0x0035, glyph_five },
    { 0x0036, glyph_six },
    { 0x0037, glyph_seven },
    { 0x0038, glyph_eight },
    { 0x0039, glyph_nine },
    { 0x003A, glyph_colon },
    { 0x003B, glyph_semicolon },
    { 0x003C, glyph_less },
    { 0x003D, glyph_equal },
    { 0x003E, glyph_greater },
    { 0x003F, glyph_question },
    { 0x0040, glyph_at },
    { 0x0041, glyph_A },
    { 0x0042, glyph_B },
    { 0x0043, glyph_C },
    { 0x0044, glyph_D },
    { 0x0045, glyph_E },
    { 0x0046, glyph_F },
    { 0x0047, glyph_G },
    { 0x0048, glyph_H },
    { 0x0049, glyph_I },
    { 0x004A, glyph_J },
    { 0x004B, glyph_K },
    { 0x004C, glyph_L },
    { 0x004D, glyph_M },
    { 0x004E, glyph_N },
    { 0x004F, glyph_O },
    { 0x0050, glyph_P },
    { 0x0051, glyph_Q },
    { 0x0052, glyph_R },
    { 0x0053, glyph_S },
    { 0x0054, glyph_T },
    { 0x0055, glyph_U },
    { 0x0056, glyph_V },
    { 0x0057, glyph_W },
    { 0x0058, glyph_X },
    { 0x0059, glyph_Y },
    { 0x005A, glyph_Z },
    { 0x005B, glyph_bracketleft },
    { 0x005C, glyph_backslash },
    { 0x005D, glyph_bracketright },
    { 0x005E, glyph_asciicircum },
    { 0x005F, glyph_underscore },
    { 0x0060, glyph_grave },
    { 0x0061, glyph_a },
    { 0x0062, glyph_b },
    { 0x0063, glyph_c },
    { 0x0064, glyph_d },
    { 0x0065, glyph_e },
    { 0x0066, glyph_f },
    { 0x0067, glyph_g },
    { 0x0068, glyph_h },
    { 0x0069, glyph_i },
    { 0x006A, glyph_j },
    { 0x006B, glyph_k },
    { 0x006C, glyph_l },
    { 0x006D, glyph_m },
    { 0x006E, glyph_n },
    { 0x006F, glyph_o },
    { 0x0070, glyph_p },
    { 0x0071, glyph_q },
    { 0x0072, glyph_r },
    { 0x0073, glyph_s },
    { 0x0074, glyph_t },
    { 0x0075, glyph_u },
    { 0x0076, glyph_v },
    { 0x0077, glyph_w },
    { 0x0078, glyph_x },
    { 0x0079, glyph_y },
    { 0x007A, glyph_z },
    { 0x007B, glyph_braceleft },
    { 0x007C, glyph_bar },
    { 0x007D, glyph_braceright },
    { 0x007E, glyph_asciitilde },
    { 0x00A0, glyph_nbspace },
    { 0x00A1, glyph_exclamdown },
    { 0x00A2, glyph_cent },
    { 0x00A3, glyph_sterling },
    { 0x00A4, glyph_currency },
    { 0x00A5, glyph_yen },
    { 0x00A6, glyph_brokenbar },
    { 0x00A7, glyph_section },
    { 0x00A8, glyph_dieresis },
    { 0x00A9, glyph_copyright },
    { 0x00AA, glyph_ordfeminine },
    { 0x00AB, glyph_guillemotleft },
    { 0x00AC, glyph_logicalnot },
    { 0x00AD, glyph_sfthyphen },
    { 0x00AE, glyph_registered },
    { 0x00AF, glyph_macron },
    { 0x00B0, glyph_degree },
    { 0x00B1, glyph_plusminus },
    { 0x00B2, glyph_twosuperior },
    { 0x00B3, glyph_threesuperior },
    { 0x00B4, glyph_acute },
    { 0x00B5, glyph_mu },
    { 0x00B6, glyph_paragraph },
    { 0x00B7, glyph_periodcentered },
    { 0x00B8, glyph_cedilla },
    { 0x00B9, glyph_onesuperior },
    { 0x00BA, glyph_ordmasculine },
    { 0x00BB, glyph_guillemotright },
    { 0x00BC, glyph_onequarter },
    { 0x00BD, glyph_onehalf },
    { 0x00BE, glyph_threequarters },
    { 0x00BF, glyph_questiondown },
    { 0x00C0, glyph_Agrave },
    { 0x00C1, glyph_Aacute },
    { 0x00C2, glyph_Acircumflex },
    { 0x00C3, glyph_Atilde },
    { 0x00C4, glyph_Adieresis },
    { 0x00C5, glyph_Aring },
    { 0x00C6, glyph_AE },
    { 0x00C7, glyph_Ccedilla },
    { 0x00C8, glyph_Egrave },
    { 0x00C9, glyph_Eacute },
    { 0x00CA, glyph_Ecircumflex },
    { 0x00CB, glyph_Edieresis },
    { 0x00CC, glyph_Igrave },
    { 0x00CD, glyph_Iacute },
    { 0x00CE, glyph_Icircumflex },
    { 0x00CF, glyph_Idieresis },
    { 0x00D0, glyph_Eth },
    { 0x00D1, glyph_Ntilde },
    { 0x00D2, glyph_Ograve },
    { 0x00D3, glyph_Oacute },
    { 0x00D4, glyph_Ocircumflex },
    { 0x00D5, glyph_Otilde },
    { 0x00D6, glyph_Odieresis },
    { 0x00D7, glyph_multiply },
    { 0x00D8, glyph_Oslash },
    { 0x00D9, glyph_Ugrave },
    { 0x00DA, glyph_Uacute },
    { 0x00DB, glyph_Ucircumflex },
    { 0x00DC, glyph_Udieresis },
    { 0x00DD, glyph_Yacute },
    { 0x00DE, glyph_Thorn },
    { 0x00DF, glyph_germandbls },
    { 0x00E0, glyph_agrave },
    { 0x00E1, glyph_aacute },
    { 0x00E2, glyph_acircumflex },
    { 0x00E3, glyph_atilde },
    { 0x00E4, glyph_adieresis },
    { 0x00E5, glyph_aring },
    { 0x00E6, glyph_ae },
    { 0x00E7, glyph_ccedilla },
    { 0x00E8, glyph_egrave },
    { 0x00E9, glyph_eacute },
    { 0x00EA, glyph_ecircumflex },
    { 0x00EB, glyph_edieresis },
    { 0x00EC, glyph_igrave },
    { 0x00ED, glyph_iacute },
    { 0x00EE, glyph_icircumflex },
    { 0x00EF, glyph_idieresis },
    { 0x00F0, glyph_eth },
    { 0x00F1, glyph_ntilde },
    { 0x00F2, glyph_ograve },
    { 0x00F3, glyph_oacute },
    { 0x00F4, glyph_ocircumflex },
    { 0x00F5, glyph_otilde },
    { 0x00F6, glyph_odieresis },
    { 0x00F7, glyph_divide },
    { 0x00F8, glyph_oslash },
    { 0x00F9, glyph_ugrave },
    { 0x00FA, glyph_uacute },
    { 0x00FB, glyph_ucircumflex },
    { 0x00FC, glyph_udieresis },
    { 0x00FD, glyph_yacute },
    { 0x00FE, glyph_thorn },
    { 0x00FF, glyph_ydieresis },
    { 0x0100, glyph_Amacron },
    { 0x0101, glyph_amacron },
    { 0x0102, glyph_Abreve },
    { 0x0103, glyph_abreve },
    { 0x0104, glyph_Aogonek },
    { 0x0105, glyph_aogonek },
    { 0x0106, glyph_Cacute },
    { 0x0107, glyph_cacute },
    { 0x0108, glyph_Ccircumflex },
    { 0x0109, glyph_ccircumflex },
    { 0x010A, glyph_Cdotaccent },
    { 0x010B, glyph_cdotaccent },
    { 0x010C, glyph_Ccaron },
    { 0x010D, glyph_ccaron },
    { 0x010E, glyph_Dcaron },
    { 0x010F, glyph_dcaron },
    { 0x0110, glyph_Dcroat },
    { 0x0111, glyph_dcroat },
    { 0x0112, glyph_Emacron },
    { 0x0113, glyph_emacron },
    { 0x0114, glyph_Ebreve },
    { 0x0115, glyph_ebreve },
    { 0x0116, glyph_Edotaccent },
    { 0x0117, glyph_edotaccent },
    { 0x0118, glyph_Eogonek },
    { 0x0119, glyph_eogonek },
    { 0x011A, glyph_Ecaron },
    { 0x011B, glyph_ecaron },
    { 0x011C, glyph_Gcircumflex },
    { 0x011D, glyph_gcircumflex },
    { 0x011E, glyph_Gbreve },
    { 0x011F, glyph_gbreve },
    { 0x0120, glyph_Gdotaccent },
    { 0x0121, glyph_gdotaccent },
    { 0x0122, glyph_Gcommaaccent },
    { 0x0123, glyph_gcommaaccent },
    { 0x0124, glyph_Hcircumflex },
    { 0x0125, glyph_hcircumflex },
    { 0x0126, glyph_Hbar },
    { 0x0127, glyph_hbar },
    { 0x0128, glyph_Itilde },
    { 0x0129, glyph_itilde },
    { 0x012A, glyph_Imacron },
    { 0x012B, glyph_imacron },
    { 0x012C, glyph_Ibreve },
    { 0x012D, glyph_ibreve },
    { 0x012E, glyph_Iogonek },
    { 0x012F, glyph_iogonek },
    { 0x0130, glyph_Idotaccent },
    { 0x0131, glyph_dotlessi },
    { 0x0132, glyph_IJ },
    { 0x0133, glyph_ij },
    { 0x0134, glyph_Jcircumflex },
    { 0x0135, glyph_jcircumflex },
    { 0x0136, glyph_Kcommaaccent },
    { 0x0137, glyph_kcommaaccent },
    { 0x0138, glyph_kgreenlandic },
    { 0x0139, glyph_Lacute },
    { 0x013A, glyph_lacute },
    { 0x013B, glyph_Lcommaaccent },
    { 0x013C, glyph_lcommaaccent },
    { 0x013D, glyph_Lcaron },
    { 0x013E, glyph_lcaron },
    { 0x013F, glyph_Ldot },
    { 0x0140, glyph_ldot },
    { 0x0141, glyph_Lslash },
    { 0x0142, glyph_lslash },
    { 0x0143, glyph_Nacute },
    { 0x0144, glyph_nacute },
    { 0x0145, glyph_Ncommaaccent },
    { 0x0146, glyph_ncommaaccent },
    { 0x0147, glyph_Ncaron },
    { 0x0148, glyph_ncaron },
    { 0x0149, glyph_napostrophe },
    { 0x014A, glyph_Eng },
    { 0x014B, glyph_eng },
    { 0x014C, glyph_Omacron },
    { 0x014D, glyph_omacron },
    { 0x014E, glyph_Obreve },
    { 0x014F, glyph_obreve },
    { 0x0150, glyph_Ohungarumlaut },
    { 0x0151, glyph_ohungarumlaut },
    { 0x0152, glyph_OE },
    { 0x0153, glyph_oe },
    { 0x0154, glyph_Racute },
    { 0x0155, glyph_racute },
    { 0x0156, glyph_Rcommaaccent },
    { 0x0157, glyph_rcommaaccent },
    { 0x0158, glyph_Rcaron },
    { 0x0159, glyph_rcaron },
    { 0x015A, glyph_Sacute },
    { 0x015B, glyph_sacute },
    { 0x015C, glyph_Scircumflex },
    { 0x015D, glyph_scircumflex },
    { 0x015E, glyph_Scedilla },
    { 0x015F, glyph_scedilla },
    { 0x0160, glyph_Scaron },
    { 0x0161, glyph_scaron },
    { 0x0162, glyph_Tcedilla },
    { 0x0163, glyph_tcedilla },
    { 0x0164, glyph_Tcaron },
    { 0x0165, glyph_tcaron },
    { 0x0166, glyph_Tbar },
    { 0x0167, glyph_tbar },
    { 0x0168, glyph_Utilde },
    { 0x0169, glyph_utilde },
    { 0x016A, glyph_Umacron },
    { 0x016B, glyph_umacron },
    { 0x016C, glyph_Ubreve },
    { 0x016D, glyph_ubreve },
    { 0x016E, glyph_Uring },
    { 0x016F, glyph_uring },
    { 0x0170, glyph_Uhungarumlaut },
    { 0x0171, glyph_uhungarumlaut },
    { 0x0172, glyph_Uogonek },
    { 0x0173, glyph_uogonek },
    { 0x0174, glyph_Wcircumflex },
    { 0x0175, glyph_wcircumflex },
    { 0x0176, glyph_Ycircumflex },
    { 0x0177, glyph_ycircumflex },
    { 0x0178, glyph_Ydieresis },
    { 0x0179, glyph_Zacute },
    { 0x017A, glyph_zacute },
    { 0x017B, glyph_Zdotaccent },
    { 0x017C, glyph_zdotaccent },
    { 0x017D, glyph_Zcaron },
    { 0x017E, glyph_zcaron },
    { 0x017F, glyph_longs },
    { 0x0192, glyph_florin },
    { 0x01A0, glyph_Ohorn },
    { 0x01A1, glyph_ohorn },
    { 0x01AF, glyph_Uhorn },
    { 0x01B0, glyph_uhorn },
    { 0x01E6, glyph_Gcaron },
    { 0x01E7, glyph_gcaron },
    { 0x01FA, glyph_Aringacute },
    { 0x01FB, glyph_aringacute },
    { 0x01FC, glyph_AEacute },
    { 0x01FD, glyph_aeacute },
    { 0x01FE, glyph_Oslashacute },
    { 0x01FF, glyph_oslashacute },
    { 0x0218, glyph_Scommaaccent },
    { 0x0219, glyph_scommaaccent },
    { 0x021A, glyph_Tcommaaccent },
    { 0x021B, glyph_tcommaaccent },
    { 0x02BC, glyph_afii57929 },
    { 0x02BD, glyph_afii64937 },
    { 0x02C6, glyph_circumflex },
    { 0x02C7, glyph_caron },
    { 0x02C9, glyph_firsttonechinese },
    { 0x02D8, glyph_breve },
    { 0x02D9, glyph_dotaccent },
    { 0x02DA, glyph_ring },
    { 0x02DB, glyph_ogonek },
    { 0x02DC, glyph_tilde },
    { 0x02DD, glyph_hungarumlaut },
    { 0x0300, glyph_gravecomb },
    { 0x0301, glyph_acutecomb },
    { 0x0303, glyph_tildecomb },
    { 0x0309, glyph_hookabovecomb },
    { 0x0323, glyph_dotbelowcomb },
    { 0x0384, glyph_tonos },
    { 0x0385, glyph_dieresistonos },
    { 0x0386, glyph_Alphatonos },
    { 0x0387, glyph_anoteleia },
    { 0x0388, glyph_Epsilontonos },
    { 0x0389, glyph_Etatonos },
    { 0x038A, glyph_Iotatonos },
    { 0x038C, glyph_Omicrontonos },
    { 0x038E, glyph_Upsilontonos },
    { 0x038F, glyph_Omegatonos },
    { 0x0390, glyph_iotadieresistonos },
    { 0x0391, glyph_Alpha },
    { 0x0392, glyph_Beta },
    { 0x0393, glyph_Gamma },
    { 0x0394, glyph_Deltagreek },
    { 0x0395, glyph_Epsilon },
    { 0x0396, glyph_Zeta },
    { 0x0397, glyph_Eta },
    { 0x0398, glyph_Theta },
    { 0x0399, glyph_Iota },
    { 0x039A, glyph_Kappa },
    { 0x039B, glyph_Lambda },
    { 0x039C, glyph_Mu },
    { 0x039D, glyph_Nu },
    { 0x039E, glyph_Xi },
    { 0x039F, glyph_Omicron },
    { 0x03A0, glyph_Pi },
    { 0x03A1, glyph_Rho },
    { 0x03A3, glyph_Sigma },
    { 0x03A4, glyph_Tau },
    { 0x03A5, glyph_Upsilon },
    { 0x03A6, glyph_Phi },
    { 0x03A7, glyph_Chi },
    { 0x03A8, glyph_Psi },
    { 0x03A9, glyph_Omegagreek },
    { 0x03AA, glyph_Iotadieresis },
    { 0x03AB, glyph_Upsilondieresis },
    { 0x03AC, glyph_alphatonos },
    { 0x03AD, glyph_epsilontonos },
    { 0x03AE, glyph_etatonos },
    { 0x03AF, glyph_iotatonos },
    { 0x03B0, glyph_upsilondieresistonos },
    { 0x03B1, glyph_alpha },
    { 0x03B2, glyph_beta },
    { 0x03B3, glyph_gamma },
    { 0x03B4, glyph_delta },
    { 0x03B5, glyph_epsilon },
    { 0x03B6, glyph_zeta },
    { 0x03B7, glyph_eta },
    { 0x03B8, glyph_theta },
    { 0x03B9, glyph_iota },
    { 0x03BA, glyph_kappa },
    { 0x03BB, glyph_lambda },
    { 0x03BC, glyph_mugreek },
    { 0x03BD, glyph_nu },
    { 0x03BE, glyph_xi },
    { 0x03BF, glyph_omicron },
    { 0x03C0, glyph_pi },
    { 0x03C1, glyph_rho },
    { 0x03C2, glyph_sigma1 },
    { 0x03C3, glyph_sigma },
    { 0x03C4, glyph_tau },
    { 0x03C5, glyph_upsilon },
    { 0x03C6, glyph_phi },
    { 0x03C7, glyph_chi },
    { 0x03C8, glyph_psi },
    { 0x03C9, glyph_omega },
    { 0x03CA, glyph_iotadieresis },
    { 0x03CB, glyph_upsilondieresis },
    { 0x03CC, glyph_omicrontonos },
    { 0x03CD, glyph_upsilontonos },
    { 0x03CE, glyph_omegatonos },
    { 0x03D1, glyph_theta1 },
    { 0x03D2, glyph_Upsilon1 },
    { 0x03D5, glyph_phi1 },
    { 0x03D6, glyph_omega1 },
    { 0x0401, glyph_afii10023 },
    { 0x0402, glyph_afii10051 },
    { 0x0403, glyph_afii10052 },
    { 0x0404, glyph_afii10053 },
    { 0x0405, glyph_afii10054 },
    { 0x0406, glyph_afii10055 },
    { 0x0407, glyph_afii10056 },
    { 0x0408, glyph_afii10057 },
    { 0x0409, glyph_afii10058 },
    { 0x040A, glyph_afii10059 },
    { 0x040B, glyph_afii10060 },
    { 0x040C, glyph_afii10061 },
    { 0x040E, glyph_afii10062 },
    { 0x040F, glyph_afii10145 },
    { 0x0410, glyph_afii10017 },
    { 0x0411, glyph_afii10018 },
    { 0x0412, glyph_afii10019 },
    { 0x0413, glyph_afii10020 },
    { 0x0414, glyph_afii10021 },
    { 0x0415, glyph_afii10022 },
    { 0x0416, glyph_afii10024 },
    { 0x0417, glyph_afii10025 },
    { 0x0418, glyph_afii10026 },
    { 0x0419, glyph_afii10027 },
    { 0x041A, glyph_afii10028 },
    { 0x041B, glyph_afii10029 },
    { 0x041C, glyph_afii10030 },
    { 0x041D, glyph_afii10031 },
    { 0x041E, glyph_afii10032 },
    { 0x041F, glyph_afii10033 },
    { 0x0420, glyph_afii10034 },
    { 0x0421, glyph_afii10035 },
    { 0x0422, glyph_afii10036 },
    { 0x0423, glyph_afii10037 },
    { 0x0424, glyph_afii10038 },
    { 0x0425, glyph_afii10039 },
    { 0x0426, glyph_afii10040 },
    { 0x0427, glyph_afii10041 },
    { 0x0428, glyph_afii10042 },
    { 0x0429, glyph_afii10043 },
    { 0x042A, glyph_afii10044 },
    { 0x042B, glyph_afii10045 },
    { 0x042C, glyph_afii10046 },
    { 0x042D, glyph_afii10047 },
    { 0x042E, glyph_afii10048 },
    { 0x042F, glyph_afii10049 },
    { 0x0430, glyph_afii10065 },
    { 0x0431, glyph_afii10066 },
    { 0x0432, glyph_afii10067 },
    { 0x0433, glyph_afii10068 },
    { 0x0434, glyph_afii10069 },
    { 0x0435, glyph_afii10070 },
    { 0x0436, glyph_afii10072 },
    { 0x0437, glyph_afii10073 },
    { 0x0438, glyph_afii10074 },
    { 0x0439, glyph_afii10075 },
    { 0x043A, glyph_afii10076 },
    { 0x043B, glyph_afii10077 },
    { 0x043C, glyph_afii10078 },
    { 0x043D, glyph_afii10079 },
    { 0x043E, glyph_afii10080 },
    { 0x043F, glyph_afii10081 },
    { 0x0440, glyph_afii10082 },
    { 0x0441, glyph_afii10083 },
    { 0x0442, glyph_afii10084 },
    { 0x0443, glyph_afii10085 },
    { 0x0444, glyph_afii10086 },
    { 0x0445, glyph_afii10087 },
    { 0x0446, glyph_afii10088 },
    { 0x0447, glyph_afii10089 },
    { 0x0448, glyph_afii10090 },
    { 0x0449, glyph_afii10091 },
    { 0x044A, glyph_afii10092 },
    { 0x044B, glyph_afii10093 },
    { 0x044C, glyph_afii10094 },
    { 0x044D, glyph_afii10095 },
    { 0x044E, glyph_afii10096 },
    { 0x044F, glyph_afii10097 },
    { 0x0451, glyph_afii10071 },
    { 0x0452, glyph_afii10099 },
    { 0x0453, glyph_afii10100 },
    { 0x0454, glyph_afii10101 },
    { 0x0455, glyph_afii10102 },
    { 0x0456, glyph_afii10103 },
    { 0x0457, glyph_afii10104 },
    { 0x0458, glyph_afii10105 },
    { 0x0459, glyph_afii10106 },
    { 0x045A, glyph_afii10107 },
    { 0x045B, glyph_afii10108 },
    { 0x045C, glyph_afii10109 },
    { 0x045E, glyph_afii10110 },
    { 0x045F, glyph_afii10193 },
    { 0x0462, glyph_afii10146 },
    { 0x0463, glyph_afii10194 },
    { 0x0472, glyph_afii10147 },
    { 0x0473, glyph_afii10195 },
    { 0x0474, glyph_afii10148 },
    { 0x0475, glyph_afii10196 },
    { 0x0490, glyph_afii10050 },
    { 0x0491, glyph_afii10098 },
    { 0x04D9, glyph_afii10846 },
    { 0x05B0, glyph_afii57799 },
    { 0x05B1, glyph_afii57801 },
    { 0x05B2, glyph_afii57800 },
    { 0x05B3, glyph_afii57802 },
    { 0x05B4, glyph_afii57793 },
    { 0x05B5, glyph_afii57794 },
    { 0x05B6, glyph_afii57795 },
    { 0x05B7, glyph_afii57798 },
    { 0x05B8, glyph_afii57797 },
    { 0x05B9, glyph_afii57806 },
    { 0x05BB, glyph_afii57796 },
    { 0x05BC, glyph_afii57807 },
    { 0x05BD, glyph_afii57839 },
    { 0x05BE, glyph_afii57645 },
    { 0x05BF, glyph_afii57841 },
    { 0x05C0, glyph_afii57842 },
    { 0x05C1, glyph_afii57804 },
    { 0x05C2, glyph_afii57803 },
    { 0x05C3, glyph_afii57658 },
    { 0x05D0, glyph_afii57664 },
    { 0x05D1, glyph_afii57665 },
    { 0x05D2, glyph_afii57666 },
    { 0x05D3, glyph_afii57667 },
    { 0x05D4, glyph_afii57668 },
    { 0x05D5, glyph_afii57669 },
    { 0x05D6, glyph_afii57670 },
    { 0x05D7, glyph_afii57671 },
    { 0x05D8, glyph_afii57672 },
    { 0x05D9, glyph_afii57673 },
    { 0x05DA, glyph_afii57674 },
    { 0x05DB, glyph_afii57675 },
    { 0x05DC, glyph_afii57676 },
    { 0x05DD, glyph_afii57677 },
    { 0x05DE, glyph_afii57678 },
    { 0x05DF, glyph_afii57679 },
    { 0x05E0, glyph_afii57680 },
    { 0x05E1, glyph_afii57681 },
    { 0x05E2, glyph_afii57682 },
    { 0x05E3, glyph_afii57683 },
    { 0x05E4, glyph_afii57684 },
    { 0x05E5, glyph_afii57685 },
    { 0x05E6, glyph_afii57686 },
    { 0x05E7, glyph_afii57687 },
    { 0x05E8, glyph_afii57688 },
    { 0x05E9, glyph_afii57689 },
    { 0x05EA, glyph_afii57690 },
    { 0x05F0, glyph_afii57716 },
    { 0x05F1, glyph_afii57717 },
    { 0x05F2, glyph_afii57718 },
    { 0x060C, glyph_afii57388 },
    { 0x061B, glyph_afii57403 },
    { 0x061F, glyph_afii57407 },
    { 0x0621, glyph_afii57409 },
    { 0x0622, glyph_afii57410 },
    { 0x0623, glyph_afii57411 },
    { 0x0624, glyph_afii57412 },
    { 0x0625, glyph_afii57413 },
    { 0x0626, glyph_afii57414 },
    { 0x0627, glyph_afii57415 },
    { 0x0628, glyph_afii57416 },
    { 0x0629, glyph_afii57417 },
    { 0x062A, glyph_afii57418 },
    { 0x062B, glyph_afii57419 },
    { 0x062C, glyph_afii57420 },
    { 0x062D, glyph_afii57421 },
    { 0x062E, glyph_afii57422 },
    { 0x062F, glyph_afii57423 },
    { 0x0630, glyph_afii57424 },
    { 0x0631, glyph_afii57425 },
    { 0x0632, glyph_afii57426 },
    { 0x0633, glyph_afii57427 },
    { 0x0634, glyph_afii57428 },
    { 0x0635, glyph_afii57429 },
    { 0x0636, glyph_afii57430 },
    { 0x0637, glyph_afii57431 },
    { 0x0638, glyph_afii57432 },
    { 0x0639, glyph_afii57433 },
    { 0x063A, glyph_afii57434 },
    { 0x0640, glyph_afii57440 },
    { 0x0641, glyph_afii57441 },
    { 0x0642, glyph_afii57442 },
    { 0x0643, glyph_afii57443 },
    { 0x0644, glyph_afii57444 },
    { 0x0645, glyph_afii57445 },
    { 0x0646, glyph_afii57446 },
    { 0x0647, glyph_afii57470 },
    { 0x0648, glyph_afii57448 },
    { 0x0649, glyph_afii57449 },
    { 0x064A, glyph_afii57450 },
    { 0x064B, glyph_afii57451 },
    { 0x064C, glyph_afii57452 },
    { 0x064D, glyph_afii57453 },
    { 0x064E, glyph_afii57454 },
    { 0x064F, glyph_afii57455 },
    { 0x0650, glyph_afii57456 },
    { 0x0651, glyph_afii57457 },
    { 0x0652, glyph_afii57458 },
    { 0x0660, glyph_afii57392 },
    { 0x0661, glyph_afii57393 },
    { 0x0662, glyph_afii57394 },
    { 0x0663, glyph_afii57395 },
    { 0x0664, glyph_afii57396 },
    { 0x0665, glyph_afii57397 },
    { 0x0666, glyph_afii57398 },
    { 0x0667, glyph_afii57399 },
    { 0x0668, glyph_afii57400 },
    { 0x0669, glyph_afii57401 },
    { 0x066A, glyph_afii57381 },
    { 0x066D, glyph_afii63167 },
    { 0x0679, glyph_afii57511 },
    { 0x067E, glyph_afii57506 },
    { 0x0686, glyph_afii57507 },
    { 0x0688, glyph_afii57512 },
    { 0x0691, glyph_afii57513 },
    { 0x0698, glyph_afii57508 },
    { 0x06A4, glyph_afii57505 },
    { 0x06AF, glyph_afii57509 },
    { 0x06BA, glyph_afii57514 },
    { 0x06D2, glyph_afii57519 },
    { 0x06D5, glyph_afii57534 },
    { 0x1E80, glyph_Wgrave },
    { 0x1E81, glyph_wgrave },
    { 0x1E82, glyph_Wacute },
    { 0x1E83, glyph_wacute },
    { 0x1E84, glyph_Wdieresis },
    { 0x1E85, glyph_wdieresis },
    { 0x1EF2, glyph_Ygrave },
    { 0x1EF3, glyph_ygrave },
    { 0x200C, glyph_afii61664 },
    { 0x200D, glyph_afii301 },
    { 0x200E, glyph_afii299 },
    { 0x200F, glyph_afii300 },
    { 0x2012, glyph_figuredash },
    { 0x2013, glyph_endash },
    { 0x2014, glyph_emdash },
    { 0x2015, glyph_afii00208 },
    { 0x2017, glyph_underscoredbl },
    { 0x2018, glyph_quoteleft },
    { 0x2019, glyph_quoteright },
    { 0x201A, glyph_quotesinglbase },
    { 0x201B, glyph_quotereversed },
    { 0x201C, glyph_quotedblleft },
    { 0x201D, glyph_quotedblright },
    { 0x201E, glyph_quotedblbase },
    { 0x2020, glyph_dagger },
    { 0x2021, glyph_daggerdbl },
    { 0x2022, glyph_bullet },
    { 0x2024, glyph_onedotenleader },
    { 0x2025, glyph_twodotenleader },
    { 0x2026, glyph_ellipsis },
    { 0x202C, glyph_afii61573 },
    { 0x202D, glyph_afii61574 },
    { 0x202E, glyph_afii61575 },
    { 0x2030, glyph_perthousand },
    { 0x2032, glyph_minute },
    { 0x2033, glyph_second },
    { 0x2039, glyph_guilsinglleft },
    { 0x203A, glyph_guilsinglright },
    { 0x203C, glyph_exclamdbl },
    { 0x2044, glyph_fraction },
    { 0x2070, glyph_zerosuperior },
    { 0x2074, glyph_foursuperior },
    { 0x2075, glyph_fivesuperior },
    { 0x2076, glyph_sixsuperior },
    { 0x2077, glyph_sevensuperior },
    { 0x2078, glyph_eightsuperior },
    { 0x2079, glyph_ninesuperior },
    { 0x207D, glyph_parenleftsuperior },
    { 0x207E, glyph_parenrightsuperior },
    { 0x207F, glyph_nsuperior },
    { 0x2080, glyph_zeroinferior },
    { 0x2081, glyph_oneinferior },
    { 0x2082, glyph_twoinferior },
    { 0x2083, glyph_threeinferior },
    { 0x2084, glyph_fourinferior },
    { 0x2085, glyph_fiveinferior },
    { 0x2086, glyph_sixinferior },
    { 0x2087, glyph_seveninferior },
    { 0x2088, glyph_eightinferior },
    { 0x2089, glyph_nineinferior },
    { 0x208D, glyph_parenleftinferior },
    { 0x208E, glyph_parenrightinferior },
    { 0x20A1, glyph_colonmonetary },
    { 0x20A3, glyph_franc },
    { 0x20A4, glyph_lira },
    { 0x20A7, glyph_peseta },
    { 0x20AA, glyph_afii57636 },
    { 0x20AB, glyph_dong },
    { 0x20AC, glyph_Euro },
    { 0x2105, glyph_afii61248 },
    { 0x2111, glyph_Ifraktur },
    { 0x2113, glyph_afii61289 },
    { 0x2116, glyph_afii61352 },
    { 0x2118, glyph_weierstrass },
    { 0x211C, glyph_Rfraktur },
    { 0x211E, glyph_prescription },
    { 0x2122, glyph_trademark },
    { 0x2126, glyph_Omega },
    { 0x212E, glyph_estimated },
    { 0x2135, glyph_aleph },
    { 0x2153, glyph_onethird },
    { 0x2154, glyph_twothirds },
    { 0x215B, glyph_oneeighth },
    { 0x215C, glyph_threeeighths },
    { 0x215D, glyph_fiveeighths },
    { 0x215E, glyph_seveneighths },
    { 0x2190, glyph_arrowleft },
    { 0x2191, glyph_arrowup },
    { 0x2192, glyph_arrowright },
    { 0x2193, glyph_arrowdown },
    { 0x2194, glyph_arrowboth },
    { 0x2195, glyph_arrowupdn },
    { 0x21A8, glyph_arrowupdnbse },
    { 0x21B5, glyph_carriagereturn },
    { 0x21D0, glyph_arrowdblleft },
    { 0x21D1, glyph_arrowdblup },
    { 0x21D2, glyph_arrowdblright },
    { 0x21D3, glyph_arrowdbldown },
    { 0x21D4, glyph_arrowdblboth },
    { 0x2200, glyph_universal },
    { 0x2202, glyph_partialdiff },
    { 0x2203, glyph_existential },
    { 0x2205, glyph_emptyset },
    { 0x2206, glyph_Delta },
    { 0x2207, glyph_gradient },
    { 0x2208, glyph_element },
    { 0x2209, glyph_notelement },
    { 0x220B, glyph_suchthat },
    { 0x220F, glyph_product },
    { 0x2211, glyph_summation },
    { 0x2212, glyph_minus },
    { 0x2215, glyph_divisionslash },
    { 0x2217, glyph_asteriskmath },
    { 0x2219, glyph_bulletoperator },
    { 0x221A, glyph_radical },
    { 0x221D, glyph_proportional },
    { 0x221E, glyph_infinity },
    { 0x221F, glyph_orthogonal },
    { 0x2220, glyph_angle },
    { 0x2227, glyph_logicaland },
    { 0x2228, glyph_logicalor },
    { 0x2229, glyph_intersection },
    { 0x222A, glyph_union },
    { 0x222B, glyph_integral },
    { 0x2234, glyph_therefore },
    { 0x223C, glyph_similar },
    { 0x2245, glyph_congruent },
    { 0x2248, glyph_approxequal },
    { 0x2260, glyph_notequal },
    { 0x2261, glyph_equivalence },
    { 0x2264, glyph_lessequal },
    { 0x2265, glyph_greaterequal },
    { 0x2282, glyph_propersubset },
    { 0x2283, glyph_propersuperset },
    { 0x2284, glyph_notsubset },
    { 0x2286, glyph_reflexsubset },
    { 0x2287, glyph_reflexsuperset },
    { 0x2295, glyph_circleplus },
    { 0x2297, glyph_circlemultiply },
    { 0x22A5, glyph_perpendicular },
    { 0x22C5, glyph_dotmath },
    { 0x2302, glyph_house },
    { 0x2310, glyph_revlogicalnot },
    { 0x2320, glyph_integraltp },
    { 0x2321, glyph_integralbt },
    { 0x2329, glyph_angleleft },
    { 0x232A, glyph_angleright },
    { 0x2500, glyph_SF100000 },
    { 0x2502, glyph_SF110000 },
    { 0x250C, glyph_SF010000 },
    { 0x2510, glyph_SF030000 },
    { 0x2514, glyph_SF020000 },
    { 0x2518, glyph_SF040000 },
    { 0x251C, glyph_SF080000 },
    { 0x2524, glyph_SF090000 },
    { 0x252C, glyph_SF060000 },
    { 0x2534, glyph_SF070000 },
    { 0x253C, glyph_SF050000 },
    { 0x2550, glyph_SF430000 },
    { 0x2551, glyph_SF240000 },
    { 0x2552, glyph_SF510000 },
    { 0x2553, glyph_SF520000 },
    { 0x2554, glyph_SF390000 },
    { 0x2555, glyph_SF220000 },
    { 0x2556, glyph_SF210000 },
    { 0x2557, glyph_SF250000 },
    { 0x2558, glyph_SF500000 },
    { 0x2559, glyph_SF490000 },
    { 0x255A, glyph_SF380000 },
    { 0x255B, glyph_SF280000 },
    { 0x255C, glyph_SF270000 },
    { 0x255D, glyph_SF260000 },
    { 0x255E, glyph_SF360000 },
    { 0x255F, glyph_SF370000 },
    { 0x2560, glyph_SF420000 },
    { 0x2561, glyph_SF190000 },
    { 0x2562, glyph_SF200000 },
    { 0x2563, glyph_SF230000 },
    { 0x2564, glyph_SF470000 },
    { 0x2565, glyph_SF480000 },
    { 0x2566, glyph_SF410000 },
    { 0x2567, glyph_SF450000 },
    { 0x2568, glyph_SF460000 },
    { 0x2569, glyph_SF400000 },
    { 0x256A, glyph_SF540000 },
    { 0x256B, glyph_SF530000 },
    { 0x256C, glyph_SF440000 },
    { 0x2580, glyph_upblock },
    { 0x2584, glyph_dnblock },
    { 0x2588, glyph_block },
    { 0x258C, glyph_lfblock },
    { 0x2590, glyph_rtblock },
    { 0x2591, glyph_ltshade },
    { 0x2592, glyph_shade },
    { 0x2593, glyph_dkshade },
    { 0x25A0, glyph_filledbox },
    { 0x25A1, glyph_H22073 },
    { 0x25AA, glyph_H18543 },
    { 0x25AB, glyph_H18551 },
    { 0x25AC, glyph_filledrect },
    { 0x25B2, glyph_triagup },
    { 0x25BA, glyph_triagrt },
    { 0x25BC, glyph_triagdn },
    { 0x25C4, glyph_triaglf },
    { 0x25CA, glyph_lozenge },
    { 0x25CB, glyph_circle },
    { 0x25CF, glyph_H18533 },
    { 0x25D8, glyph_invbullet },
    { 0x25D9, glyph_invcircle },
    { 0x25E6, glyph_openbullet },
    { 0x263A, glyph_smileface },
    { 0x263B, glyph_invsmileface },
    { 0x263C, glyph_sun },
    { 0x2640, glyph_female },
    { 0x2642, glyph_male },
    { 0x2660, glyph_spade },
    { 0x2663, glyph_club },
    { 0x2665, glyph_heart },
    { 0x2666, glyph_diamond },
    { 0x266A, glyph_musicalnote },
    { 0x266B, glyph_musicalnotedbl },
    { 0xF6BE, glyph_dotlessj },
    { 0xF6BF, glyph_LL },
    { 0xF6C0, glyph_ll },
    { 0xF6C3, glyph_commaaccent },
    { 0xF6C4, glyph_afii10063 },
    { 0xF6C5, glyph_afii10064 },
    { 0xF6C6, glyph_afii10192 },
    { 0xF6C7, glyph_afii10831 },
    { 0xF6C8, glyph_afii10832 },
    { 0xF6C9, glyph_Acute },
    { 0xF6CA, glyph_Caron },
    { 0xF6CB, glyph_Dieresis },
    { 0xF6CC, glyph_DieresisAcute },
    { 0xF6CD, glyph_DieresisGrave },
    { 0xF6CE, glyph_Grave },
    { 0xF6CF, glyph_Hungarumlaut },
    { 0xF6D0, glyph_Macron },
    { 0xF6D1, glyph_cyrBreve },
    { 0xF6D2, glyph_cyrFlex },
    { 0xF6D3, glyph_dblGrave },
    { 0xF6D4, glyph_cyrbreve },
    { 0xF6D5, glyph_cyrflex },
    { 0xF6D6, glyph_dblgrave },
    { 0xF6D7, glyph_dieresisacute },
    { 0xF6D8, glyph_dieresisgrave },
    { 0xF6D9, glyph_copyrightserif },
    { 0xF6DA, glyph_registerserif },
    { 0xF6DB, glyph_trademarkserif },
    { 0xF6DC, glyph_onefitted },
    { 0xF6DD, glyph_rupiah },
    { 0xF6DE, glyph_threequartersemdash },
    { 0xF6DF, glyph_centinferior },
    { 0xF6E0, glyph_centsuperior },
    { 0xF6E1, glyph_commainferior },
    { 0xF6E2, glyph_commasuperior },
    { 0xF6E3, glyph_dollarinferior },
    { 0xF6E4, glyph_dollarsuperior },
    { 0xF6E5, glyph_hypheninferior },
    { 0xF6E6, glyph_hyphensuperior },
    { 0xF6E7, glyph_periodinferior },
    { 0xF6E8, glyph_periodsuperior },
    { 0xF6E9, glyph_asuperior },
    { 0xF6EA, glyph_bsuperior },
    { 0xF6EB, glyph_dsuperior },
    { 0xF6EC, glyph_esuperior },
    { 0xF6ED, glyph_isuperior },
    { 0xF6EE, glyph_lsuperior },
    { 0xF6EF, glyph_msuperior },
    { 0xF6F0, glyph_osuperior },
    { 0xF6F1, glyph_rsuperior },
    { 0xF6F2, glyph_ssuperior },
    { 0xF6F3, glyph_tsuperior },
    { 0xF6F4, glyph_Brevesmall },
    { 0xF6F5, glyph_Caronsmall },
    { 0xF6F6, glyph_Circumflexsmall },
    { 0xF6F7, glyph_Dotaccentsmall },
    { 0xF6F8, glyph_Hungarumlautsmall },
    { 0xF6F9, glyph_Lslashsmall },
    { 0xF6FA, glyph_OEsmall },
    { 0xF6FB, glyph_Ogoneksmall },
    { 0xF6FC, glyph_Ringsmall },
    { 0xF6FD, glyph_Scaronsmall },
    { 0xF6FE, glyph_Tildesmall },
    { 0xF6FF, glyph_Zcaronsmall },
    { 0xF721, glyph_exclamsmall },
    { 0xF724, glyph_dollaroldstyle },
    { 0xF726, glyph_ampersandsmall },
    { 0xF730, glyph_zerooldstyle },
    { 0xF731, glyph_oneoldstyle },
    { 0xF732, glyph_twooldstyle },
    { 0xF733, glyph_threeoldstyle },
    { 0xF734, glyph_fouroldstyle },
    { 0xF735, glyph_fiveoldstyle },
    { 0xF736, glyph_sixoldstyle },
    { 0xF737, glyph_sevenoldstyle },
    { 0xF738, glyph_eightoldstyle },
    { 0xF739, glyph_nineoldstyle },
    { 0xF73F, glyph_questionsmall },
    { 0xF760, glyph_Gravesmall },
    { 0xF761, glyph_Asmall },
    { 0xF762, glyph_Bsmall },
    { 0xF763, glyph_Csmall },
    { 0xF764, glyph_Dsmall },
    { 0xF765, glyph_Esmall },
    { 0xF766, glyph_Fsmall },
    { 0xF767, glyph_Gsmall },
    { 0xF768, glyph_Hsmall },
    { 0xF769, glyph_Ismall },
    { 0xF76A, glyph_Jsmall },
    { 0xF76B, glyph_Ksmall },
    { 0xF76C, glyph_Lsmall },
    { 0xF76D, glyph_Msmall },
    { 0xF76E, glyph_Nsmall },
    { 0xF76F, glyph_Osmall },
    { 0xF770, glyph_Psmall },
    { 0xF771, glyph_Qsmall },
    { 0xF772, glyph_Rsmall },
    { 0xF773, glyph_Ssmall },
    { 0xF774, glyph_Tsmall },
    { 0xF775, glyph_Usmall },
    { 0xF776, glyph_Vsmall },
    { 0xF777, glyph_Wsmall },
    { 0xF778, glyph_Xsmall },
    { 0xF779, glyph_Ysmall },
    { 0xF77A, glyph_Zsmall },
    { 0xF7A1, glyph_exclamdownsmall },
    { 0xF7A2, glyph_centoldstyle },
    { 0xF7A8, glyph_Dieresissmall },
    { 0xF7AF, glyph_Macronsmall },
    { 0xF7B4, glyph_Acutesmall },
    { 0xF7B8, glyph_Cedillasmall },
    { 0xF7BF, glyph_questiondownsmall },
    { 0xF7E0, glyph_Agravesmall },
    { 0xF7E1, glyph_Aacutesmall },
    { 0xF7E2, glyph_Acircumflexsmall },
    { 0xF7E3, glyph_Atildesmall },
    { 0xF7E4, glyph_Adieresissmall },
    { 0xF7E5, glyph_Aringsmall },
    { 0xF7E6, glyph_AEsmall },
    { 0xF7E7, glyph_Ccedillasmall },
    { 0xF7E8, glyph_Egravesmall },
    { 0xF7E9, glyph_Eacutesmall },
    { 0xF7EA, glyph_Ecircumflexsmall },
    { 0xF7EB, glyph_Edieresissmall },
    { 0xF7EC, glyph_Igravesmall },
    { 0xF7ED, glyph_Iacutesmall },
    { 0xF7EE, glyph_Icircumflexsmall },
    { 0xF7EF, glyph_Idieresissmall },
    { 0xF7F0, glyph_Ethsmall },
    { 0xF7F1, glyph_Ntildesmall },
    { 0xF7F2, glyph_Ogravesmall },
    { 0xF7F3, glyph_Oacutesmall },
    { 0xF7F4, glyph_Ocircumflexsmall },
    { 0xF7F5, glyph_Otildesmall },
    { 0xF7F6, glyph_Odieresissmall },
    { 0xF7F8, glyph_Oslashsmall },
    { 0xF7F9, glyph_Ugravesmall },
    { 0xF7FA, glyph_Uacutesmall },
    { 0xF7FB, glyph_Ucircumflexsmall },
    { 0xF7FC, glyph_Udieresissmall },
    { 0xF7FD, glyph_Yacutesmall },
    { 0xF7FE, glyph_Thornsmall },
    { 0xF7FF, glyph_Ydieresissmall },
    { 0xF8E5, glyph_radicalex },
    { 0xF8E6, glyph_arrowvertex },
    { 0xF8E7, glyph_arrowhorizex },
    { 0xF8E8, glyph_registersans },
    { 0xF8E9, glyph_copyrightsans },
    { 0xF8EA, glyph_trademarksans },
    { 0xF8EB, glyph_parenlefttp },
    { 0xF8EC, glyph_parenleftex },
    { 0xF8ED, glyph_parenleftbt },
    { 0xF8EE, glyph_bracketlefttp },
    { 0xF8EF, glyph_bracketleftex },
    { 0xF8F0, glyph_bracketleftbt },
    { 0xF8F1, glyph_bracelefttp },
    { 0xF8F2, glyph_braceleftmid },
    { 0xF8F3, glyph_braceleftbt },
    { 0xF8F4, glyph_braceex },
    { 0xF8F5, glyph_integralex },
    { 0xF8F6, glyph_parenrighttp },
    { 0xF8F7, glyph_parenrightex },
    { 0xF8F8, glyph_parenrightbt },
    { 0xF8F9, glyph_bracketrighttp },
    { 0xF8FA, glyph_bracketrightex },
    { 0xF8FB, glyph_bracketrightbt },
    { 0xF8FC, glyph_bracerighttp },
    { 0xF8FD, glyph_bracerightmid },
    { 0xF8FE, glyph_bracerightbt },
    { 0xF8FF, glyph_apple },
    { 0xFB00, glyph_ff },
    { 0xFB01, glyph_fi },
    { 0xFB02, glyph_fl },
    { 0xFB03, glyph_ffi },
    { 0xFB04, glyph_ffl },
    { 0xFB1F, glyph_afii57705 },
    { 0xFB2A, glyph_afii57694 },
    { 0xFB2B, glyph_afii57695 },
    { 0xFB35, glyph_afii57723 },
    { 0xFB4B, glyph_afii57700 },
}; /* tab_uni2agl */

/* ZapfDingbats glyphs - sorted by names */
static const pdc_glyph_tab tab_zadb2uni[] =
{
    { 0x2701, glyph_a1 },
    { 0x2721, glyph_a10 },
    { 0x275E, glyph_a100 },
    { 0x2761, glyph_a101 },
    { 0x2762, glyph_a102 },
    { 0x2763, glyph_a103 },
    { 0x2764, glyph_a104 },
    { 0x2710, glyph_a105 },
    { 0x2765, glyph_a106 },
    { 0x2766, glyph_a107 },
    { 0x2767, glyph_a108 },
    { 0x2660, glyph_a109 },
    { 0x261B, glyph_a11 },
    { 0x2665, glyph_a110 },
    { 0x2666, glyph_a111 },
    { 0x2663, glyph_a112 },
    { 0x2709, glyph_a117 },
    { 0x2708, glyph_a118 },
    { 0x2707, glyph_a119 },
    { 0x261E, glyph_a12 },
    { 0x2460, glyph_a120 },
    { 0x2461, glyph_a121 },
    { 0x2462, glyph_a122 },
    { 0x2463, glyph_a123 },
    { 0x2464, glyph_a124 },
    { 0x2465, glyph_a125 },
    { 0x2466, glyph_a126 },
    { 0x2467, glyph_a127 },
    { 0x2468, glyph_a128 },
    { 0x2469, glyph_a129 },
    { 0x270C, glyph_a13 },
    { 0x2776, glyph_a130 },
    { 0x2777, glyph_a131 },
    { 0x2778, glyph_a132 },
    { 0x2779, glyph_a133 },
    { 0x277A, glyph_a134 },
    { 0x277B, glyph_a135 },
    { 0x277C, glyph_a136 },
    { 0x277D, glyph_a137 },
    { 0x277E, glyph_a138 },
    { 0x277F, glyph_a139 },
    { 0x270D, glyph_a14 },
    { 0x2780, glyph_a140 },
    { 0x2781, glyph_a141 },
    { 0x2782, glyph_a142 },
    { 0x2783, glyph_a143 },
    { 0x2784, glyph_a144 },
    { 0x2785, glyph_a145 },
    { 0x2786, glyph_a146 },
    { 0x2787, glyph_a147 },
    { 0x2788, glyph_a148 },
    { 0x2789, glyph_a149 },
    { 0x270E, glyph_a15 },
    { 0x278A, glyph_a150 },
    { 0x278B, glyph_a151 },
    { 0x278C, glyph_a152 },
    { 0x278D, glyph_a153 },
    { 0x278E, glyph_a154 },
    { 0x278F, glyph_a155 },
    { 0x2790, glyph_a156 },
    { 0x2791, glyph_a157 },
    { 0x2792, glyph_a158 },
    { 0x2793, glyph_a159 },
    { 0x270F, glyph_a16 },
    { 0x2794, glyph_a160 },
    { 0x2192, glyph_a161 },
    { 0x27A3, glyph_a162 },
    { 0x2194, glyph_a163 },
    { 0x2195, glyph_a164 },
    { 0x2799, glyph_a165 },
    { 0x279B, glyph_a166 },
    { 0x279C, glyph_a167 },
    { 0x279D, glyph_a168 },
    { 0x279E, glyph_a169 },
    { 0x2711, glyph_a17 },
    { 0x279F, glyph_a170 },
    { 0x27A0, glyph_a171 },
    { 0x27A1, glyph_a172 },
    { 0x27A2, glyph_a173 },
    { 0x27A4, glyph_a174 },
    { 0x27A5, glyph_a175 },
    { 0x27A6, glyph_a176 },
    { 0x27A7, glyph_a177 },
    { 0x27A8, glyph_a178 },
    { 0x27A9, glyph_a179 },
    { 0x2712, glyph_a18 },
    { 0x27AB, glyph_a180 },
    { 0x27AD, glyph_a181 },
    { 0x27AF, glyph_a182 },
    { 0x27B2, glyph_a183 },
    { 0x27B3, glyph_a184 },
    { 0x27B5, glyph_a185 },
    { 0x27B8, glyph_a186 },
    { 0x27BA, glyph_a187 },
    { 0x27BB, glyph_a188 },
    { 0x27BC, glyph_a189 },
    { 0x2713, glyph_a19 },
    { 0x27BD, glyph_a190 },
    { 0x27BE, glyph_a191 },
    { 0x279A, glyph_a192 },
    { 0x27AA, glyph_a193 },
    { 0x27B6, glyph_a194 },
    { 0x27B9, glyph_a195 },
    { 0x2798, glyph_a196 },
    { 0x27B4, glyph_a197 },
    { 0x27B7, glyph_a198 },
    { 0x27AC, glyph_a199 },
    { 0x2702, glyph_a2 },
    { 0x2714, glyph_a20 },
    { 0x27AE, glyph_a200 },
    { 0x27B1, glyph_a201 },
    { 0x2703, glyph_a202 },
    { 0x2750, glyph_a203 },
    { 0x2752, glyph_a204 },
    { 0x276E, glyph_a205 },
    { 0x2770, glyph_a206 },
    { 0x2715, glyph_a21 },
    { 0x2716, glyph_a22 },
    { 0x2717, glyph_a23 },
    { 0x2718, glyph_a24 },
    { 0x2719, glyph_a25 },
    { 0x271A, glyph_a26 },
    { 0x271B, glyph_a27 },
    { 0x271C, glyph_a28 },
    { 0x2722, glyph_a29 },
    { 0x2704, glyph_a3 },
    { 0x2723, glyph_a30 },
    { 0x2724, glyph_a31 },
    { 0x2725, glyph_a32 },
    { 0x2726, glyph_a33 },
    { 0x2727, glyph_a34 },
    { 0x2605, glyph_a35 },
    { 0x2729, glyph_a36 },
    { 0x272A, glyph_a37 },
    { 0x272B, glyph_a38 },
    { 0x272C, glyph_a39 },
    { 0x260E, glyph_a4 },
    { 0x272D, glyph_a40 },
    { 0x272E, glyph_a41 },
    { 0x272F, glyph_a42 },
    { 0x2730, glyph_a43 },
    { 0x2731, glyph_a44 },
    { 0x2732, glyph_a45 },
    { 0x2733, glyph_a46 },
    { 0x2734, glyph_a47 },
    { 0x2735, glyph_a48 },
    { 0x2736, glyph_a49 },
    { 0x2706, glyph_a5 },
    { 0x2737, glyph_a50 },
    { 0x2738, glyph_a51 },
    { 0x2739, glyph_a52 },
    { 0x273A, glyph_a53 },
    { 0x273B, glyph_a54 },
    { 0x273C, glyph_a55 },
    { 0x273D, glyph_a56 },
    { 0x273E, glyph_a57 },
    { 0x273F, glyph_a58 },
    { 0x2740, glyph_a59 },
    { 0x271D, glyph_a6 },
    { 0x2741, glyph_a60 },
    { 0x2742, glyph_a61 },
    { 0x2743, glyph_a62 },
    { 0x2744, glyph_a63 },
    { 0x2745, glyph_a64 },
    { 0x2746, glyph_a65 },
    { 0x2747, glyph_a66 },
    { 0x2748, glyph_a67 },
    { 0x2749, glyph_a68 },
    { 0x274A, glyph_a69 },
    { 0x271E, glyph_a7 },
    { 0x274B, glyph_a70 },
    { 0x25CF, glyph_a71 },
    { 0x274D, glyph_a72 },
    { 0x25A0, glyph_a73 },
    { 0x274F, glyph_a74 },
    { 0x2751, glyph_a75 },
    { 0x25B2, glyph_a76 },
    { 0x25BC, glyph_a77 },
    { 0x25C6, glyph_a78 },
    { 0x2756, glyph_a79 },
    { 0x271F, glyph_a8 },
    { 0x25D7, glyph_a81 },
    { 0x2758, glyph_a82 },
    { 0x2759, glyph_a83 },
    { 0x275A, glyph_a84 },
    { 0x276F, glyph_a85 },
    { 0x2771, glyph_a86 },
    { 0x2772, glyph_a87 },
    { 0x2773, glyph_a88 },
    { 0x2768, glyph_a89 },
    { 0x2720, glyph_a9 },
    { 0x2769, glyph_a90 },
    { 0x276C, glyph_a91 },
    { 0x276D, glyph_a92 },
    { 0x276A, glyph_a93 },
    { 0x276B, glyph_a94 },
    { 0x2774, glyph_a95 },
    { 0x2775, glyph_a96 },
    { 0x275B, glyph_a97 },
    { 0x275C, glyph_a98 },
    { 0x275D, glyph_a99 },
    { 0x0020, glyph_space },
}; /* tab_zadb2uni */

/* ZapfDingbats glyphs - sorted by unicode values */
static const pdc_glyph_tab tab_uni2zadb[] =
{
    { 0x0020, glyph_space },
    { 0x2192, glyph_a161 },
    { 0x2194, glyph_a163 },
    { 0x2195, glyph_a164 },
    { 0x2460, glyph_a120 },
    { 0x2461, glyph_a121 },
    { 0x2462, glyph_a122 },
    { 0x2463, glyph_a123 },
    { 0x2464, glyph_a124 },
    { 0x2465, glyph_a125 },
    { 0x2466, glyph_a126 },
    { 0x2467, glyph_a127 },
    { 0x2468, glyph_a128 },
    { 0x2469, glyph_a129 },
    { 0x25A0, glyph_a73 },
    { 0x25B2, glyph_a76 },
    { 0x25BC, glyph_a77 },
    { 0x25C6, glyph_a78 },
    { 0x25CF, glyph_a71 },
    { 0x25D7, glyph_a81 },
    { 0x2605, glyph_a35 },
    { 0x260E, glyph_a4 },
    { 0x261B, glyph_a11 },
    { 0x261E, glyph_a12 },
    { 0x2660, glyph_a109 },
    { 0x2663, glyph_a112 },
    { 0x2665, glyph_a110 },
    { 0x2666, glyph_a111 },
    { 0x2701, glyph_a1 },
    { 0x2702, glyph_a2 },
    { 0x2703, glyph_a202 },
    { 0x2704, glyph_a3 },
    { 0x2706, glyph_a5 },
    { 0x2707, glyph_a119 },
    { 0x2708, glyph_a118 },
    { 0x2709, glyph_a117 },
    { 0x270C, glyph_a13 },
    { 0x270D, glyph_a14 },
    { 0x270E, glyph_a15 },
    { 0x270F, glyph_a16 },
    { 0x2710, glyph_a105 },
    { 0x2711, glyph_a17 },
    { 0x2712, glyph_a18 },
    { 0x2713, glyph_a19 },
    { 0x2714, glyph_a20 },
    { 0x2715, glyph_a21 },
    { 0x2716, glyph_a22 },
    { 0x2717, glyph_a23 },
    { 0x2718, glyph_a24 },
    { 0x2719, glyph_a25 },
    { 0x271A, glyph_a26 },
    { 0x271B, glyph_a27 },
    { 0x271C, glyph_a28 },
    { 0x271D, glyph_a6 },
    { 0x271E, glyph_a7 },
    { 0x271F, glyph_a8 },
    { 0x2720, glyph_a9 },
    { 0x2721, glyph_a10 },
    { 0x2722, glyph_a29 },
    { 0x2723, glyph_a30 },
    { 0x2724, glyph_a31 },
    { 0x2725, glyph_a32 },
    { 0x2726, glyph_a33 },
    { 0x2727, glyph_a34 },
    { 0x2729, glyph_a36 },
    { 0x272A, glyph_a37 },
    { 0x272B, glyph_a38 },
    { 0x272C, glyph_a39 },
    { 0x272D, glyph_a40 },
    { 0x272E, glyph_a41 },
    { 0x272F, glyph_a42 },
    { 0x2730, glyph_a43 },
    { 0x2731, glyph_a44 },
    { 0x2732, glyph_a45 },
    { 0x2733, glyph_a46 },
    { 0x2734, glyph_a47 },
    { 0x2735, glyph_a48 },
    { 0x2736, glyph_a49 },
    { 0x2737, glyph_a50 },
    { 0x2738, glyph_a51 },
    { 0x2739, glyph_a52 },
    { 0x273A, glyph_a53 },
    { 0x273B, glyph_a54 },
    { 0x273C, glyph_a55 },
    { 0x273D, glyph_a56 },
    { 0x273E, glyph_a57 },
    { 0x273F, glyph_a58 },
    { 0x2740, glyph_a59 },
    { 0x2741, glyph_a60 },
    { 0x2742, glyph_a61 },
    { 0x2743, glyph_a62 },
    { 0x2744, glyph_a63 },
    { 0x2745, glyph_a64 },
    { 0x2746, glyph_a65 },
    { 0x2747, glyph_a66 },
    { 0x2748, glyph_a67 },
    { 0x2749, glyph_a68 },
    { 0x274A, glyph_a69 },
    { 0x274B, glyph_a70 },
    { 0x274D, glyph_a72 },
    { 0x274F, glyph_a74 },
    { 0x2750, glyph_a203 },
    { 0x2751, glyph_a75 },
    { 0x2752, glyph_a204 },
    { 0x2756, glyph_a79 },
    { 0x2758, glyph_a82 },
    { 0x2759, glyph_a83 },
    { 0x275A, glyph_a84 },
    { 0x275B, glyph_a97 },
    { 0x275C, glyph_a98 },
    { 0x275D, glyph_a99 },
    { 0x275E, glyph_a100 },
    { 0x2761, glyph_a101 },
    { 0x2762, glyph_a102 },
    { 0x2763, glyph_a103 },
    { 0x2764, glyph_a104 },
    { 0x2765, glyph_a106 },
    { 0x2766, glyph_a107 },
    { 0x2767, glyph_a108 },

    /*  >= Unicode 4.0*/
    { 0x2768, glyph_a89 },
    { 0x2769, glyph_a90 },
    { 0x276A, glyph_a93 },
    { 0x276B, glyph_a94 },
    { 0x276C, glyph_a91 },
    { 0x276D, glyph_a92 },
    { 0x276E, glyph_a205 },
    { 0x276F, glyph_a85 },
    { 0x2770, glyph_a206 },
    { 0x2771, glyph_a86 },
    { 0x2772, glyph_a87 },
    { 0x2773, glyph_a88 },
    { 0x2774, glyph_a95 },
    { 0x2775, glyph_a96 },
    /* ---------------- */

    { 0x2776, glyph_a130 },
    { 0x2777, glyph_a131 },
    { 0x2778, glyph_a132 },
    { 0x2779, glyph_a133 },
    { 0x277A, glyph_a134 },
    { 0x277B, glyph_a135 },
    { 0x277C, glyph_a136 },
    { 0x277D, glyph_a137 },
    { 0x277E, glyph_a138 },
    { 0x277F, glyph_a139 },
    { 0x2780, glyph_a140 },
    { 0x2781, glyph_a141 },
    { 0x2782, glyph_a142 },
    { 0x2783, glyph_a143 },
    { 0x2784, glyph_a144 },
    { 0x2785, glyph_a145 },
    { 0x2786, glyph_a146 },
    { 0x2787, glyph_a147 },
    { 0x2788, glyph_a148 },
    { 0x2789, glyph_a149 },
    { 0x278A, glyph_a150 },
    { 0x278B, glyph_a151 },
    { 0x278C, glyph_a152 },
    { 0x278D, glyph_a153 },
    { 0x278E, glyph_a154 },
    { 0x278F, glyph_a155 },
    { 0x2790, glyph_a156 },
    { 0x2791, glyph_a157 },
    { 0x2792, glyph_a158 },
    { 0x2793, glyph_a159 },
    { 0x2794, glyph_a160 },
    { 0x2798, glyph_a196 },
    { 0x2799, glyph_a165 },
    { 0x279A, glyph_a192 },
    { 0x279B, glyph_a166 },
    { 0x279C, glyph_a167 },
    { 0x279D, glyph_a168 },
    { 0x279E, glyph_a169 },
    { 0x279F, glyph_a170 },
    { 0x27A0, glyph_a171 },
    { 0x27A1, glyph_a172 },
    { 0x27A2, glyph_a173 },
    { 0x27A3, glyph_a162 },
    { 0x27A4, glyph_a174 },
    { 0x27A5, glyph_a175 },
    { 0x27A6, glyph_a176 },
    { 0x27A7, glyph_a177 },
    { 0x27A8, glyph_a178 },
    { 0x27A9, glyph_a179 },
    { 0x27AA, glyph_a193 },
    { 0x27AB, glyph_a180 },
    { 0x27AC, glyph_a199 },
    { 0x27AD, glyph_a181 },
    { 0x27AE, glyph_a200 },
    { 0x27AF, glyph_a182 },
    { 0x27B1, glyph_a201 },
    { 0x27B2, glyph_a183 },
    { 0x27B3, glyph_a184 },
    { 0x27B4, glyph_a197 },
    { 0x27B5, glyph_a185 },
    { 0x27B6, glyph_a194 },
    { 0x27B7, glyph_a198 },
    { 0x27B8, glyph_a186 },
    { 0x27B9, glyph_a195 },
    { 0x27BA, glyph_a187 },
    { 0x27BB, glyph_a188 },
    { 0x27BC, glyph_a189 },
    { 0x27BD, glyph_a190 },
    { 0x27BE, glyph_a191 },

    /*  < Unicode 4.0  */
    { 0xF8D7, glyph_a89 },
    { 0xF8D8, glyph_a90 },
    { 0xF8D9, glyph_a93 },
    { 0xF8DA, glyph_a94 },
    { 0xF8DB, glyph_a91 },
    { 0xF8DC, glyph_a92 },
    { 0xF8DD, glyph_a205 },
    { 0xF8DE, glyph_a85 },
    { 0xF8DF, glyph_a206 },
    { 0xF8E0, glyph_a86 },
    { 0xF8E1, glyph_a87 },
    { 0xF8E2, glyph_a88 },
    { 0xF8E3, glyph_a95 },
    { 0xF8E4, glyph_a96 },
}; /* tab_uni2zadb */


/*
 * Difference table of AGL version 2.0 - 1.2'  -  sorted by names
 *
 */
static const pdc_glyph_tab tab_diffagl2uni[] =
{
#ifndef PDFLIB_EBCDIC

    { 0x01E2, glyph_AEmacron },
    { 0x1EAE, glyph_Abreveacute },
    { 0x04D0, glyph_Abrevecyrillic },
    { 0x1EB6, glyph_Abrevedotbelow },
    { 0x1EB0, glyph_Abrevegrave },
    { 0x1EB2, glyph_Abrevehookabove },
    { 0x1EB4, glyph_Abrevetilde },
    { 0x01CD, glyph_Acaron },
    { 0x24B6, glyph_Acircle },
    { 0x1EA4, glyph_Acircumflexacute },
    { 0x1EAC, glyph_Acircumflexdotbelow },
    { 0x1EA6, glyph_Acircumflexgrave },
    { 0x1EA8, glyph_Acircumflexhookabove },
    { 0x1EAA, glyph_Acircumflextilde },
    { 0x0410, glyph_Acyrillic },
    { 0x0200, glyph_Adblgrave },
    { 0x04D2, glyph_Adieresiscyrillic },
    { 0x01DE, glyph_Adieresismacron },
    { 0x1EA0, glyph_Adotbelow },
    { 0x01E0, glyph_Adotmacron },
    { 0x1EA2, glyph_Ahookabove },
    { 0x04D4, glyph_Aiecyrillic },
    { 0x0202, glyph_Ainvertedbreve },
    { 0xFF21, glyph_Amonospace },
    { 0x1E00, glyph_Aringbelow },
    { 0x0531, glyph_Aybarmenian },
    { 0x24B7, glyph_Bcircle },
    { 0x1E02, glyph_Bdotaccent },
    { 0x1E04, glyph_Bdotbelow },
    { 0x0411, glyph_Becyrillic },
    { 0x0532, glyph_Benarmenian },
    { 0x0181, glyph_Bhook },
    { 0x1E06, glyph_Blinebelow },
    { 0xFF22, glyph_Bmonospace },
    { 0x0182, glyph_Btopbar },
    { 0x053E, glyph_Caarmenian },
    { 0x1E08, glyph_Ccedillaacute },
    { 0x24B8, glyph_Ccircle },
    { 0x010A, glyph_Cdot },
    { 0x0549, glyph_Chaarmenian },
    { 0x04BC, glyph_Cheabkhasiancyrillic },
    { 0x0427, glyph_Checyrillic },
    { 0x04BE, glyph_Chedescenderabkhasiancyrillic },
    { 0x04B6, glyph_Chedescendercyrillic },
    { 0x04F4, glyph_Chedieresiscyrillic },
    { 0x0543, glyph_Cheharmenian },
    { 0x04CB, glyph_Chekhakassiancyrillic },
    { 0x04B8, glyph_Cheverticalstrokecyrillic },
    { 0x0187, glyph_Chook },
    { 0xFF23, glyph_Cmonospace },
    { 0x0551, glyph_Coarmenian },
    { 0x01F1, glyph_DZ },
    { 0x01C4, glyph_DZcaron },
    { 0x0534, glyph_Daarmenian },
    { 0x0189, glyph_Dafrican },
    { 0x1E10, glyph_Dcedilla },
    { 0x24B9, glyph_Dcircle },
    { 0x1E12, glyph_Dcircumflexbelow },
    { 0x1E0A, glyph_Ddotaccent },
    { 0x1E0C, glyph_Ddotbelow },
    { 0x0414, glyph_Decyrillic },
    { 0x03EE, glyph_Deicoptic },
    { 0x018A, glyph_Dhook },
    { 0x03DC, glyph_Digammagreek },
    { 0x0402, glyph_Djecyrillic },
    { 0x1E0E, glyph_Dlinebelow },
    { 0xFF24, glyph_Dmonospace },
    { 0x0110, glyph_Dslash },
    { 0x018B, glyph_Dtopbar },
    { 0x01F2, glyph_Dz },
    { 0x01C5, glyph_Dzcaron },
    { 0x04E0, glyph_Dzeabkhasiancyrillic },
    { 0x0405, glyph_Dzecyrillic },
    { 0x040F, glyph_Dzhecyrillic },
    { 0x1E1C, glyph_Ecedillabreve },
    { 0x0535, glyph_Echarmenian },
    { 0x24BA, glyph_Ecircle },
    { 0x1EBE, glyph_Ecircumflexacute },
    { 0x1E18, glyph_Ecircumflexbelow },
    { 0x1EC6, glyph_Ecircumflexdotbelow },
    { 0x1EC0, glyph_Ecircumflexgrave },
    { 0x1EC2, glyph_Ecircumflexhookabove },
    { 0x1EC4, glyph_Ecircumflextilde },
    { 0x0404, glyph_Ecyrillic },
    { 0x0204, glyph_Edblgrave },
    { 0x0116, glyph_Edot },
    { 0x1EB8, glyph_Edotbelow },
    { 0x0424, glyph_Efcyrillic },
    { 0x0537, glyph_Eharmenian },
    { 0x1EBA, glyph_Ehookabove },
    { 0x2167, glyph_Eightroman },
    { 0x0206, glyph_Einvertedbreve },
    { 0x0464, glyph_Eiotifiedcyrillic },
    { 0x041B, glyph_Elcyrillic },
    { 0x216A, glyph_Elevenroman },
    { 0x1E16, glyph_Emacronacute },
    { 0x1E14, glyph_Emacrongrave },
    { 0x041C, glyph_Emcyrillic },
    { 0xFF25, glyph_Emonospace },
    { 0x041D, glyph_Encyrillic },
    { 0x04A2, glyph_Endescendercyrillic },
    { 0x04A4, glyph_Enghecyrillic },
    { 0x04C7, glyph_Enhookcyrillic },
    { 0x0190, glyph_Eopen },
    { 0x0420, glyph_Ercyrillic },
    { 0x018E, glyph_Ereversed },
    { 0x042D, glyph_Ereversedcyrillic },
    { 0x0421, glyph_Escyrillic },
    { 0x04AA, glyph_Esdescendercyrillic },
    { 0x01A9, glyph_Esh },
    { 0x0538, glyph_Etarmenian },
    { 0x1EBC, glyph_Etilde },
    { 0x1E1A, glyph_Etildebelow },
    { 0x01B7, glyph_Ezh },
    { 0x01EE, glyph_Ezhcaron },
    { 0x01B8, glyph_Ezhreversed },
    { 0x24BB, glyph_Fcircle },
    { 0x1E1E, glyph_Fdotaccent },
    { 0x0556, glyph_Feharmenian },
    { 0x03E4, glyph_Feicoptic },
    { 0x0191, glyph_Fhook },
    { 0x0472, glyph_Fitacyrillic },
    { 0x2164, glyph_Fiveroman },
    { 0xFF26, glyph_Fmonospace },
    { 0x2163, glyph_Fourroman },
    { 0x3387, glyph_GBsquare },
    { 0x01F4, glyph_Gacute },
    { 0x0194, glyph_Gammaafrican },
    { 0x03EA, glyph_Gangiacoptic },
    { 0x0122, glyph_Gcedilla },
    { 0x24BC, glyph_Gcircle },
    { 0x0120, glyph_Gdot },
    { 0x0413, glyph_Gecyrillic },
    { 0x0542, glyph_Ghadarmenian },
    { 0x0494, glyph_Ghemiddlehookcyrillic },
    { 0x0492, glyph_Ghestrokecyrillic },
    { 0x0490, glyph_Gheupturncyrillic },
    { 0x0193, glyph_Ghook },
    { 0x0533, glyph_Gimarmenian },
    { 0x0403, glyph_Gjecyrillic },
    { 0x1E20, glyph_Gmacron },
    { 0xFF27, glyph_Gmonospace },
    { 0x029B, glyph_Gsmallhook },
    { 0x01E4, glyph_Gstroke },
    { 0x33CB, glyph_HPsquare },
    { 0x04A8, glyph_Haabkhasiancyrillic },
    { 0x04B2, glyph_Hadescendercyrillic },
    { 0x042A, glyph_Hardsigncyrillic },
    { 0x1E2A, glyph_Hbrevebelow },
    { 0x1E28, glyph_Hcedilla },
    { 0x24BD, glyph_Hcircle },
    { 0x1E26, glyph_Hdieresis },
    { 0x1E22, glyph_Hdotaccent },
    { 0x1E24, glyph_Hdotbelow },
    { 0xFF28, glyph_Hmonospace },
    { 0x0540, glyph_Hoarmenian },
    { 0x03E8, glyph_Horicoptic },
    { 0x3390, glyph_Hzsquare },
    { 0x042F, glyph_IAcyrillic },
    { 0x042E, glyph_IUcyrillic },
    { 0x01CF, glyph_Icaron },
    { 0x24BE, glyph_Icircle },
    { 0x0406, glyph_Icyrillic },
    { 0x0208, glyph_Idblgrave },
    { 0x1E2E, glyph_Idieresisacute },
    { 0x04E4, glyph_Idieresiscyrillic },
    { 0x0130, glyph_Idot },
    { 0x1ECA, glyph_Idotbelow },
    { 0x04D6, glyph_Iebrevecyrillic },
    { 0x0415, glyph_Iecyrillic },
    { 0x1EC8, glyph_Ihookabove },
    { 0x0418, glyph_Iicyrillic },
    { 0x020A, glyph_Iinvertedbreve },
    { 0x0419, glyph_Iishortcyrillic },
    { 0x04E2, glyph_Imacroncyrillic },
    { 0xFF29, glyph_Imonospace },
    { 0x053B, glyph_Iniarmenian },
    { 0x0401, glyph_Iocyrillic },
    { 0x0196, glyph_Iotaafrican },
    { 0x0197, glyph_Istroke },
    { 0x1E2C, glyph_Itildebelow },
    { 0x0474, glyph_Izhitsacyrillic },
    { 0x0476, glyph_Izhitsadblgravecyrillic },
    { 0x0541, glyph_Jaarmenian },
    { 0x24BF, glyph_Jcircle },
    { 0x0408, glyph_Jecyrillic },
    { 0x054B, glyph_Jheharmenian },
    { 0xFF2A, glyph_Jmonospace },
    { 0x3385, glyph_KBsquare },
    { 0x33CD, glyph_KKsquare },
    { 0x04A0, glyph_Kabashkircyrillic },
    { 0x1E30, glyph_Kacute },
    { 0x041A, glyph_Kacyrillic },
    { 0x049A, glyph_Kadescendercyrillic },
    { 0x04C3, glyph_Kahookcyrillic },
    { 0x049E, glyph_Kastrokecyrillic },
    { 0x049C, glyph_Kaverticalstrokecyrillic },
    { 0x01E8, glyph_Kcaron },
    { 0x0136, glyph_Kcedilla },
    { 0x24C0, glyph_Kcircle },
    { 0x1E32, glyph_Kdotbelow },
    { 0x0554, glyph_Keharmenian },
    { 0x053F, glyph_Kenarmenian },
    { 0x0425, glyph_Khacyrillic },
    { 0x03E6, glyph_Kheicoptic },
    { 0x0198, glyph_Khook },
    { 0x040C, glyph_Kjecyrillic },
    { 0x1E34, glyph_Klinebelow },
    { 0xFF2B, glyph_Kmonospace },
    { 0x0480, glyph_Koppacyrillic },
    { 0x03DE, glyph_Koppagreek },
    { 0x046E, glyph_Ksicyrillic },
    { 0x01C7, glyph_LJ },
    { 0x013B, glyph_Lcedilla },
    { 0x24C1, glyph_Lcircle },
    { 0x1E3C, glyph_Lcircumflexbelow },
    { 0x013F, glyph_Ldotaccent },
    { 0x1E36, glyph_Ldotbelow },
    { 0x1E38, glyph_Ldotbelowmacron },
    { 0x053C, glyph_Liwnarmenian },
    { 0x01C8, glyph_Lj },
    { 0x0409, glyph_Ljecyrillic },
    { 0x1E3A, glyph_Llinebelow },
    { 0xFF2C, glyph_Lmonospace },
    { 0x3386, glyph_MBsquare },
    { 0x1E3E, glyph_Macute },
    { 0x24C2, glyph_Mcircle },
    { 0x1E40, glyph_Mdotaccent },
    { 0x1E42, glyph_Mdotbelow },
    { 0x0544, glyph_Menarmenian },
    { 0xFF2D, glyph_Mmonospace },
    { 0x019C, glyph_Mturned },
    { 0x01CA, glyph_NJ },
    { 0x0145, glyph_Ncedilla },
    { 0x24C3, glyph_Ncircle },
    { 0x1E4A, glyph_Ncircumflexbelow },
    { 0x1E44, glyph_Ndotaccent },
    { 0x1E46, glyph_Ndotbelow },
    { 0x019D, glyph_Nhookleft },
    { 0x2168, glyph_Nineroman },
    { 0x01CB, glyph_Nj },
    { 0x040A, glyph_Njecyrillic },
    { 0x1E48, glyph_Nlinebelow },
    { 0xFF2E, glyph_Nmonospace },
    { 0x0546, glyph_Nowarmenian },
    { 0x04E8, glyph_Obarredcyrillic },
    { 0x04EA, glyph_Obarreddieresiscyrillic },
    { 0x01D1, glyph_Ocaron },
    { 0x019F, glyph_Ocenteredtilde },
    { 0x24C4, glyph_Ocircle },
    { 0x1ED0, glyph_Ocircumflexacute },
    { 0x1ED8, glyph_Ocircumflexdotbelow },
    { 0x1ED2, glyph_Ocircumflexgrave },
    { 0x1ED4, glyph_Ocircumflexhookabove },
    { 0x1ED6, glyph_Ocircumflextilde },
    { 0x041E, glyph_Ocyrillic },
    { 0x0150, glyph_Odblacute },
    { 0x020C, glyph_Odblgrave },
    { 0x04E6, glyph_Odieresiscyrillic },
    { 0x1ECC, glyph_Odotbelow },
    { 0x0555, glyph_Oharmenian },
    { 0x2126, glyph_Ohm },
    { 0x1ECE, glyph_Ohookabove },
    { 0x1EDA, glyph_Ohornacute },
    { 0x1EE2, glyph_Ohorndotbelow },
    { 0x1EDC, glyph_Ohorngrave },
    { 0x1EDE, glyph_Ohornhookabove },
    { 0x1EE0, glyph_Ohorntilde },
    { 0x01A2, glyph_Oi },
    { 0x020E, glyph_Oinvertedbreve },
    { 0x1E52, glyph_Omacronacute },
    { 0x1E50, glyph_Omacrongrave },
    { 0x0460, glyph_Omegacyrillic },
    { 0x047A, glyph_Omegaroundcyrillic },
    { 0x047C, glyph_Omegatitlocyrillic },
    { 0xFF2F, glyph_Omonospace },
    { 0x2160, glyph_Oneroman },
    { 0x01EA, glyph_Oogonek },
    { 0x01EC, glyph_Oogonekmacron },
    { 0x0186, glyph_Oopen },
    { 0x01FE, glyph_Ostrokeacute },
    { 0x047E, glyph_Otcyrillic },
    { 0x1E4C, glyph_Otildeacute },
    { 0x1E4E, glyph_Otildedieresis },
    { 0x1E54, glyph_Pacute },
    { 0x24C5, glyph_Pcircle },
    { 0x1E56, glyph_Pdotaccent },
    { 0x041F, glyph_Pecyrillic },
    { 0x054A, glyph_Peharmenian },
    { 0x04A6, glyph_Pemiddlehookcyrillic },
    { 0x01A4, glyph_Phook },
    { 0x0553, glyph_Piwrarmenian },
    { 0xFF30, glyph_Pmonospace },
    { 0x0470, glyph_Psicyrillic },
    { 0x24C6, glyph_Qcircle },
    { 0xFF31, glyph_Qmonospace },
    { 0x054C, glyph_Raarmenian },
    { 0x0156, glyph_Rcedilla },
    { 0x24C7, glyph_Rcircle },
    { 0x0210, glyph_Rdblgrave },
    { 0x1E58, glyph_Rdotaccent },
    { 0x1E5A, glyph_Rdotbelow },
    { 0x1E5C, glyph_Rdotbelowmacron },
    { 0x0550, glyph_Reharmenian },
    { 0x0212, glyph_Rinvertedbreve },
    { 0x1E5E, glyph_Rlinebelow },
    { 0xFF32, glyph_Rmonospace },
    { 0x0281, glyph_Rsmallinverted },
    { 0x02B6, glyph_Rsmallinvertedsuperior },
    { 0x1E64, glyph_Sacutedotaccent },
    { 0x03E0, glyph_Sampigreek },
    { 0x1E66, glyph_Scarondotaccent },
    { 0x018F, glyph_Schwa },
    { 0x04D8, glyph_Schwacyrillic },
    { 0x04DA, glyph_Schwadieresiscyrillic },
    { 0x24C8, glyph_Scircle },
    { 0x1E60, glyph_Sdotaccent },
    { 0x1E62, glyph_Sdotbelow },
    { 0x1E68, glyph_Sdotbelowdotaccent },
    { 0x054D, glyph_Seharmenian },
    { 0x2166, glyph_Sevenroman },
    { 0x0547, glyph_Shaarmenian },
    { 0x0428, glyph_Shacyrillic },
    { 0x0429, glyph_Shchacyrillic },
    { 0x03E2, glyph_Sheicoptic },
    { 0x04BA, glyph_Shhacyrillic },
    { 0x03EC, glyph_Shimacoptic },
    { 0x2165, glyph_Sixroman },
    { 0xFF33, glyph_Smonospace },
    { 0x042C, glyph_Softsigncyrillic },
    { 0x03DA, glyph_Stigmagreek },
    { 0x24C9, glyph_Tcircle },
    { 0x1E70, glyph_Tcircumflexbelow },
    { 0x1E6A, glyph_Tdotaccent },
    { 0x1E6C, glyph_Tdotbelow },
    { 0x0422, glyph_Tecyrillic },
    { 0x04AC, glyph_Tedescendercyrillic },
    { 0x2169, glyph_Tenroman },
    { 0x04B4, glyph_Tetsecyrillic },
    { 0x01AC, glyph_Thook },
    { 0x2162, glyph_Threeroman },
    { 0x054F, glyph_Tiwnarmenian },
    { 0x1E6E, glyph_Tlinebelow },
    { 0xFF34, glyph_Tmonospace },
    { 0x0539, glyph_Toarmenian },
    { 0x01BC, glyph_Tonefive },
    { 0x0184, glyph_Tonesix },
    { 0x01A7, glyph_Tonetwo },
    { 0x01AE, glyph_Tretroflexhook },
    { 0x0426, glyph_Tsecyrillic },
    { 0x040B, glyph_Tshecyrillic },
    { 0x216B, glyph_Twelveroman },
    { 0x2161, glyph_Tworoman },
    { 0x01D3, glyph_Ucaron },
    { 0x24CA, glyph_Ucircle },
    { 0x1E76, glyph_Ucircumflexbelow },
    { 0x0423, glyph_Ucyrillic },
    { 0x0170, glyph_Udblacute },
    { 0x0214, glyph_Udblgrave },
    { 0x01D7, glyph_Udieresisacute },
    { 0x1E72, glyph_Udieresisbelow },
    { 0x01D9, glyph_Udieresiscaron },
    { 0x04F0, glyph_Udieresiscyrillic },
    { 0x01DB, glyph_Udieresisgrave },
    { 0x01D5, glyph_Udieresismacron },
    { 0x1EE4, glyph_Udotbelow },
    { 0x1EE6, glyph_Uhookabove },
    { 0x1EE8, glyph_Uhornacute },
    { 0x1EF0, glyph_Uhorndotbelow },
    { 0x1EEA, glyph_Uhorngrave },
    { 0x1EEC, glyph_Uhornhookabove },
    { 0x1EEE, glyph_Uhorntilde },
    { 0x04F2, glyph_Uhungarumlautcyrillic },
    { 0x0216, glyph_Uinvertedbreve },
    { 0x0478, glyph_Ukcyrillic },
    { 0x04EE, glyph_Umacroncyrillic },
    { 0x1E7A, glyph_Umacrondieresis },
    { 0xFF35, glyph_Umonospace },
    { 0x03D3, glyph_Upsilonacutehooksymbolgreek },
    { 0x01B1, glyph_Upsilonafrican },
    { 0x03D4, glyph_Upsilondieresishooksymbolgreek },
    { 0x03D2, glyph_Upsilonhooksymbol },
    { 0x040E, glyph_Ushortcyrillic },
    { 0x04AE, glyph_Ustraightcyrillic },
    { 0x04B0, glyph_Ustraightstrokecyrillic },
    { 0x1E78, glyph_Utildeacute },
    { 0x1E74, glyph_Utildebelow },
    { 0x24CB, glyph_Vcircle },
    { 0x1E7E, glyph_Vdotbelow },
    { 0x0412, glyph_Vecyrillic },
    { 0x054E, glyph_Vewarmenian },
    { 0x01B2, glyph_Vhook },
    { 0xFF36, glyph_Vmonospace },
    { 0x0548, glyph_Voarmenian },
    { 0x1E7C, glyph_Vtilde },
    { 0x24CC, glyph_Wcircle },
    { 0x1E86, glyph_Wdotaccent },
    { 0x1E88, glyph_Wdotbelow },
    { 0xFF37, glyph_Wmonospace },
    { 0x24CD, glyph_Xcircle },
    { 0x1E8C, glyph_Xdieresis },
    { 0x1E8A, glyph_Xdotaccent },
    { 0x053D, glyph_Xeharmenian },
    { 0xFF38, glyph_Xmonospace },
    { 0x0462, glyph_Yatcyrillic },
    { 0x24CE, glyph_Ycircle },
    { 0x1E8E, glyph_Ydotaccent },
    { 0x1EF4, glyph_Ydotbelow },
    { 0x042B, glyph_Yericyrillic },
    { 0x04F8, glyph_Yerudieresiscyrillic },
    { 0x01B3, glyph_Yhook },
    { 0x1EF6, glyph_Yhookabove },
    { 0x0545, glyph_Yiarmenian },
    { 0x0407, glyph_Yicyrillic },
    { 0x0552, glyph_Yiwnarmenian },
    { 0xFF39, glyph_Ymonospace },
    { 0x1EF8, glyph_Ytilde },
    { 0x046A, glyph_Yusbigcyrillic },
    { 0x046C, glyph_Yusbigiotifiedcyrillic },
    { 0x0466, glyph_Yuslittlecyrillic },
    { 0x0468, glyph_Yuslittleiotifiedcyrillic },
    { 0x0536, glyph_Zaarmenian },
    { 0x24CF, glyph_Zcircle },
    { 0x1E90, glyph_Zcircumflex },
    { 0x017B, glyph_Zdot },
    { 0x1E92, glyph_Zdotbelow },
    { 0x0417, glyph_Zecyrillic },
    { 0x0498, glyph_Zedescendercyrillic },
    { 0x04DE, glyph_Zedieresiscyrillic },
    { 0x053A, glyph_Zhearmenian },
    { 0x04C1, glyph_Zhebrevecyrillic },
    { 0x0416, glyph_Zhecyrillic },
    { 0x0496, glyph_Zhedescendercyrillic },
    { 0x04DC, glyph_Zhedieresiscyrillic },
    { 0x1E94, glyph_Zlinebelow },
    { 0xFF3A, glyph_Zmonospace },
    { 0x01B5, glyph_Zstroke },
    { 0x0986, glyph_aabengali },
    { 0x0906, glyph_aadeva },
    { 0x0A86, glyph_aagujarati },
    { 0x0A06, glyph_aagurmukhi },
    { 0x0A3E, glyph_aamatragurmukhi },
    { 0x3303, glyph_aarusquare },
    { 0x09BE, glyph_aavowelsignbengali },
    { 0x093E, glyph_aavowelsigndeva },
    { 0x0ABE, glyph_aavowelsigngujarati },
    { 0x055F, glyph_abbreviationmarkarmenian },
    { 0x0970, glyph_abbreviationsigndeva },
    { 0x0985, glyph_abengali },
    { 0x311A, glyph_abopomofo },
    { 0x1EAF, glyph_abreveacute },
    { 0x04D1, glyph_abrevecyrillic },
    { 0x1EB7, glyph_abrevedotbelow },
    { 0x1EB1, glyph_abrevegrave },
    { 0x1EB3, glyph_abrevehookabove },
    { 0x1EB5, glyph_abrevetilde },
    { 0x01CE, glyph_acaron },
    { 0x24D0, glyph_acircle },
    { 0x1EA5, glyph_acircumflexacute },
    { 0x1EAD, glyph_acircumflexdotbelow },
    { 0x1EA7, glyph_acircumflexgrave },
    { 0x1EA9, glyph_acircumflexhookabove },
    { 0x1EAB, glyph_acircumflextilde },
    { 0x0317, glyph_acutebelowcmb },
    { 0x0301, glyph_acutecmb },
    { 0x0954, glyph_acutedeva },
    { 0x02CF, glyph_acutelowmod },
    { 0x0341, glyph_acutetonecmb },
    { 0x0430, glyph_acyrillic },
    { 0x0201, glyph_adblgrave },
    { 0x0A71, glyph_addakgurmukhi },
    { 0x0905, glyph_adeva },
    { 0x04D3, glyph_adieresiscyrillic },
    { 0x01DF, glyph_adieresismacron },
    { 0x1EA1, glyph_adotbelow },
    { 0x01E1, glyph_adotmacron },
    { 0x3150, glyph_aekorean },
    { 0x01E3, glyph_aemacron },
    { 0x20A4, glyph_afii08941 },
    { 0x0A85, glyph_agujarati },
    { 0x0A05, glyph_agurmukhi },
    { 0x3042, glyph_ahiragana },
    { 0x1EA3, glyph_ahookabove },
    { 0x0990, glyph_aibengali },
    { 0x311E, glyph_aibopomofo },
    { 0x0910, glyph_aideva },
    { 0x04D5, glyph_aiecyrillic },
    { 0x0A90, glyph_aigujarati },
    { 0x0A10, glyph_aigurmukhi },
    { 0x0A48, glyph_aimatragurmukhi },
    { 0x0639, glyph_ainarabic },
    { 0xFECA, glyph_ainfinalarabic },
    { 0xFECB, glyph_aininitialarabic },
    { 0xFECC, glyph_ainmedialarabic },
    { 0x0203, glyph_ainvertedbreve },
    { 0x09C8, glyph_aivowelsignbengali },
    { 0x0948, glyph_aivowelsigndeva },
    { 0x0AC8, glyph_aivowelsigngujarati },
    { 0x30A2, glyph_akatakana },
    { 0xFF71, glyph_akatakanahalfwidth },
    { 0x314F, glyph_akorean },
    { 0x05D0, glyph_alef },
    { 0x0627, glyph_alefarabic },
    { 0xFB30, glyph_alefdageshhebrew },
    { 0xFE8E, glyph_aleffinalarabic },
    { 0x0623, glyph_alefhamzaabovearabic },
    { 0xFE84, glyph_alefhamzaabovefinalarabic },
    { 0x0625, glyph_alefhamzabelowarabic },
    { 0xFE88, glyph_alefhamzabelowfinalarabic },
    { 0x05D0, glyph_alefhebrew },
    { 0xFB4F, glyph_aleflamedhebrew },
    { 0x0622, glyph_alefmaddaabovearabic },
    { 0xFE82, glyph_alefmaddaabovefinalarabic },
    { 0x0649, glyph_alefmaksuraarabic },
    { 0xFEF0, glyph_alefmaksurafinalarabic },
    { 0xFEF3, glyph_alefmaksurainitialarabic },
    { 0xFEF4, glyph_alefmaksuramedialarabic },
    { 0xFB2E, glyph_alefpatahhebrew },
    { 0xFB2F, glyph_alefqamatshebrew },
    { 0x224C, glyph_allequal },
    { 0xFF41, glyph_amonospace },
    { 0xFF06, glyph_ampersandmonospace },
    { 0x33C2, glyph_amsquare },
    { 0x3122, glyph_anbopomofo },
    { 0x3124, glyph_angbopomofo },
    { 0x0E5A, glyph_angkhankhuthai },
    { 0x3008, glyph_anglebracketleft },
    { 0xFE3F, glyph_anglebracketleftvertical },
    { 0x3009, glyph_anglebracketright },
    { 0xFE40, glyph_anglebracketrightvertical },
    { 0x212B, glyph_angstrom },
    { 0x0952, glyph_anudattadeva },
    { 0x0982, glyph_anusvarabengali },
    { 0x0902, glyph_anusvaradeva },
    { 0x0A82, glyph_anusvaragujarati },
    { 0x3300, glyph_apaatosquare },
    { 0x249C, glyph_aparen },
    { 0x055A, glyph_apostrophearmenian },
    { 0x02BC, glyph_apostrophemod },
    { 0x2250, glyph_approaches },
    { 0x2252, glyph_approxequalorimage },
    { 0x2245, glyph_approximatelyequal },
    { 0x318E, glyph_araeaekorean },
    { 0x318D, glyph_araeakorean },
    { 0x2312, glyph_arc },
    { 0x1E9A, glyph_arighthalfring },
    { 0x1E01, glyph_aringbelow },
    { 0x21E3, glyph_arrowdashdown },
    { 0x21E0, glyph_arrowdashleft },
    { 0x21E2, glyph_arrowdashright },
    { 0x21E1, glyph_arrowdashup },
    { 0x2199, glyph_arrowdownleft },
    { 0x2198, glyph_arrowdownright },
    { 0x21E9, glyph_arrowdownwhite },
    { 0x02C5, glyph_arrowheaddownmod },
    { 0x02C2, glyph_arrowheadleftmod },
    { 0x02C3, glyph_arrowheadrightmod },
    { 0x02C4, glyph_arrowheadupmod },
    { 0x21D0, glyph_arrowleftdbl },
    { 0x21CD, glyph_arrowleftdblstroke },
    { 0x21C6, glyph_arrowleftoverright },
    { 0x21E6, glyph_arrowleftwhite },
    { 0x21CF, glyph_arrowrightdblstroke },
    { 0x279E, glyph_arrowrightheavy },
    { 0x21C4, glyph_arrowrightoverleft },
    { 0x21E8, glyph_arrowrightwhite },
    { 0x21E4, glyph_arrowtableft },
    { 0x21E5, glyph_arrowtabright },
    { 0x21A8, glyph_arrowupdownbase },
    { 0x2196, glyph_arrowupleft },
    { 0x21C5, glyph_arrowupleftofdown },
    { 0x2197, glyph_arrowupright },
    { 0x21E7, glyph_arrowupwhite },
    { 0xFF3E, glyph_asciicircummonospace },
    { 0xFF5E, glyph_asciitildemonospace },
    { 0x0251, glyph_ascript },
    { 0x0252, glyph_ascriptturned },
    { 0x3041, glyph_asmallhiragana },
    { 0x30A1, glyph_asmallkatakana },
    { 0xFF67, glyph_asmallkatakanahalfwidth },
    { 0x066D, glyph_asteriskaltonearabic },
    { 0x066D, glyph_asteriskarabic },
    { 0xFF0A, glyph_asteriskmonospace },
    { 0xFE61, glyph_asterisksmall },
    { 0x2042, glyph_asterism },
    { 0x2243, glyph_asymptoticallyequal },
    { 0xFF20, glyph_atmonospace },
    { 0xFE6B, glyph_atsmall },
    { 0x0250, glyph_aturned },
    { 0x0994, glyph_aubengali },
    { 0x3120, glyph_aubopomofo },
    { 0x0914, glyph_audeva },
    { 0x0A94, glyph_augujarati },
    { 0x0A14, glyph_augurmukhi },
    { 0x09D7, glyph_aulengthmarkbengali },
    { 0x0A4C, glyph_aumatragurmukhi },
    { 0x09CC, glyph_auvowelsignbengali },
    { 0x094C, glyph_auvowelsigndeva },
    { 0x0ACC, glyph_auvowelsigngujarati },
    { 0x093D, glyph_avagrahadeva },
    { 0x0561, glyph_aybarmenian },
    { 0x05E2, glyph_ayin },
    { 0xFB20, glyph_ayinaltonehebrew },
    { 0x05E2, glyph_ayinhebrew },
    { 0x09AC, glyph_babengali },
    { 0xFF3C, glyph_backslashmonospace },
    { 0x092C, glyph_badeva },
    { 0x0AAC, glyph_bagujarati },
    { 0x0A2C, glyph_bagurmukhi },
    { 0x3070, glyph_bahiragana },
    { 0x0E3F, glyph_bahtthai },
    { 0x30D0, glyph_bakatakana },
    { 0xFF5C, glyph_barmonospace },
    { 0x3105, glyph_bbopomofo },
    { 0x24D1, glyph_bcircle },
    { 0x1E03, glyph_bdotaccent },
    { 0x1E05, glyph_bdotbelow },
    { 0x266C, glyph_beamedsixteenthnotes },
    { 0x2235, glyph_because },
    { 0x0431, glyph_becyrillic },
    { 0x0628, glyph_beharabic },
    { 0xFE90, glyph_behfinalarabic },
    { 0xFE91, glyph_behinitialarabic },
    { 0x3079, glyph_behiragana },
    { 0xFE92, glyph_behmedialarabic },
    { 0xFC9F, glyph_behmeeminitialarabic },
    { 0xFC08, glyph_behmeemisolatedarabic },
    { 0xFC6D, glyph_behnoonfinalarabic },
    { 0x30D9, glyph_bekatakana },
    { 0x0562, glyph_benarmenian },
    { 0x05D1, glyph_bet },
    { 0x03D0, glyph_betasymbolgreek },
    { 0xFB31, glyph_betdagesh },
    { 0xFB31, glyph_betdageshhebrew },
    { 0x05D1, glyph_bethebrew },
    { 0xFB4C, glyph_betrafehebrew },
    { 0x09AD, glyph_bhabengali },
    { 0x092D, glyph_bhadeva },
    { 0x0AAD, glyph_bhagujarati },
    { 0x0A2D, glyph_bhagurmukhi },
    { 0x0253, glyph_bhook },
    { 0x3073, glyph_bihiragana },
    { 0x30D3, glyph_bikatakana },
    { 0x0298, glyph_bilabialclick },
    { 0x0A02, glyph_bindigurmukhi },
    { 0x3331, glyph_birusquare },
    { 0x25CF, glyph_blackcircle },
    { 0x25C6, glyph_blackdiamond },
    { 0x25BC, glyph_blackdownpointingtriangle },
    { 0x25C4, glyph_blackleftpointingpointer },
    { 0x25C0, glyph_blackleftpointingtriangle },
    { 0x3010, glyph_blacklenticularbracketleft },
    { 0xFE3B, glyph_blacklenticularbracketleftvertical },
    { 0x3011, glyph_blacklenticularbracketright },
    { 0xFE3C, glyph_blacklenticularbracketrightvertical },
    { 0x25E3, glyph_blacklowerlefttriangle },
    { 0x25E2, glyph_blacklowerrighttriangle },
    { 0x25AC, glyph_blackrectangle },
    { 0x25BA, glyph_blackrightpointingpointer },
    { 0x25B6, glyph_blackrightpointingtriangle },
    { 0x25AA, glyph_blacksmallsquare },
    { 0x263B, glyph_blacksmilingface },
    { 0x25A0, glyph_blacksquare },
    { 0x2605, glyph_blackstar },
    { 0x25E4, glyph_blackupperlefttriangle },
    { 0x25E5, glyph_blackupperrighttriangle },
    { 0x25B4, glyph_blackuppointingsmalltriangle },
    { 0x25B2, glyph_blackuppointingtriangle },
    { 0x2423, glyph_blank },
    { 0x1E07, glyph_blinebelow },
    { 0xFF42, glyph_bmonospace },
    { 0x0E1A, glyph_bobaimaithai },
    { 0x307C, glyph_bohiragana },
    { 0x30DC, glyph_bokatakana },
    { 0x249D, glyph_bparen },
    { 0x33C3, glyph_bqsquare },
    { 0xFF5B, glyph_braceleftmonospace },
    { 0xFE5B, glyph_braceleftsmall },
    { 0xFE37, glyph_braceleftvertical },
    { 0xFF5D, glyph_bracerightmonospace },
    { 0xFE5C, glyph_bracerightsmall },
    { 0xFE38, glyph_bracerightvertical },
    { 0xFF3B, glyph_bracketleftmonospace },
    { 0xFF3D, glyph_bracketrightmonospace },
    { 0x032E, glyph_brevebelowcmb },
    { 0x0306, glyph_brevecmb },
    { 0x032F, glyph_breveinvertedbelowcmb },
    { 0x0311, glyph_breveinvertedcmb },
    { 0x0361, glyph_breveinverteddoublecmb },
    { 0x032A, glyph_bridgebelowcmb },
    { 0x033A, glyph_bridgeinvertedbelowcmb },
    { 0x0180, glyph_bstroke },
    { 0x0183, glyph_btopbar },
    { 0x3076, glyph_buhiragana },
    { 0x30D6, glyph_bukatakana },
    { 0x25D8, glyph_bulletinverse },
    { 0x25CE, glyph_bullseye },
    { 0x056E, glyph_caarmenian },
    { 0x099A, glyph_cabengali },
    { 0x091A, glyph_cadeva },
    { 0x0A9A, glyph_cagujarati },
    { 0x0A1A, glyph_cagurmukhi },
    { 0x3388, glyph_calsquare },
    { 0x0981, glyph_candrabindubengali },
    { 0x0310, glyph_candrabinducmb },
    { 0x0901, glyph_candrabindudeva },
    { 0x0A81, glyph_candrabindugujarati },
    { 0x21EA, glyph_capslock },
    { 0x2105, glyph_careof },
    { 0x032C, glyph_caronbelowcmb },
    { 0x030C, glyph_caroncmb },
    { 0x3118, glyph_cbopomofo },
    { 0x1E09, glyph_ccedillaacute },
    { 0x24D2, glyph_ccircle },
    { 0x0255, glyph_ccurl },
    { 0x010B, glyph_cdot },
    { 0x33C5, glyph_cdsquare },
    { 0x0327, glyph_cedillacmb },
    { 0x2103, glyph_centigrade },
    { 0xFFE0, glyph_centmonospace },
    { 0x0579, glyph_chaarmenian },
    { 0x099B, glyph_chabengali },
    { 0x091B, glyph_chadeva },
    { 0x0A9B, glyph_chagujarati },
    { 0x0A1B, glyph_chagurmukhi },
    { 0x3114, glyph_chbopomofo },
    { 0x04BD, glyph_cheabkhasiancyrillic },
    { 0x2713, glyph_checkmark },
    { 0x0447, glyph_checyrillic },
    { 0x04BF, glyph_chedescenderabkhasiancyrillic },
    { 0x04B7, glyph_chedescendercyrillic },
    { 0x04F5, glyph_chedieresiscyrillic },
    { 0x0573, glyph_cheharmenian },
    { 0x04CC, glyph_chekhakassiancyrillic },
    { 0x04B9, glyph_cheverticalstrokecyrillic },
    { 0x3277, glyph_chieuchacirclekorean },
    { 0x3217, glyph_chieuchaparenkorean },
    { 0x3269, glyph_chieuchcirclekorean },
    { 0x314A, glyph_chieuchkorean },
    { 0x3209, glyph_chieuchparenkorean },
    { 0x0E0A, glyph_chochangthai },
    { 0x0E08, glyph_chochanthai },
    { 0x0E09, glyph_chochingthai },
    { 0x0E0C, glyph_chochoethai },
    { 0x0188, glyph_chook },
    { 0x3276, glyph_cieucacirclekorean },
    { 0x3216, glyph_cieucaparenkorean },
    { 0x3268, glyph_cieuccirclekorean },
    { 0x3148, glyph_cieuckorean },
    { 0x3208, glyph_cieucparenkorean },
    { 0x321C, glyph_cieucuparenkorean },
    { 0x2299, glyph_circleot },
    { 0x3036, glyph_circlepostalmark },
    { 0x25D0, glyph_circlewithlefthalfblack },
    { 0x25D1, glyph_circlewithrighthalfblack },
    { 0x032D, glyph_circumflexbelowcmb },
    { 0x0302, glyph_circumflexcmb },
    { 0x2327, glyph_clear },
    { 0x01C2, glyph_clickalveolar },
    { 0x01C0, glyph_clickdental },
    { 0x01C1, glyph_clicklateral },
    { 0x01C3, glyph_clickretroflex },
    { 0x2663, glyph_clubsuitblack },
    { 0x2667, glyph_clubsuitwhite },
    { 0x33A4, glyph_cmcubedsquare },
    { 0xFF43, glyph_cmonospace },
    { 0x33A0, glyph_cmsquaredsquare },
    { 0x0581, glyph_coarmenian },
    { 0xFF1A, glyph_colonmonospace },
    { 0x20A1, glyph_colonsign },
    { 0xFE55, glyph_colonsmall },
    { 0x02D1, glyph_colontriangularhalfmod },
    { 0x02D0, glyph_colontriangularmod },
    { 0x0313, glyph_commaabovecmb },
    { 0x0315, glyph_commaaboverightcmb },
    { 0x060C, glyph_commaarabic },
    { 0x055D, glyph_commaarmenian },
    { 0xFF0C, glyph_commamonospace },
    { 0x0314, glyph_commareversedabovecmb },
    { 0x02BD, glyph_commareversedmod },
    { 0xFE50, glyph_commasmall },
    { 0x0312, glyph_commaturnedabovecmb },
    { 0x02BB, glyph_commaturnedmod },
    { 0x263C, glyph_compass },
    { 0x222E, glyph_contourintegral },
    { 0x2303, glyph_control },
    { 0x0006, glyph_controlACK },
    { 0x0007, glyph_controlBEL },
    { 0x0008, glyph_controlBS },
    { 0x0018, glyph_controlCAN },
    { 0x000D, glyph_controlCR },
    { 0x0011, glyph_controlDC1 },
    { 0x0012, glyph_controlDC2 },
    { 0x0013, glyph_controlDC3 },
    { 0x0014, glyph_controlDC4 },
    { 0x007F, glyph_controlDEL },
    { 0x0010, glyph_controlDLE },
    { 0x0019, glyph_controlEM },
    { 0x0005, glyph_controlENQ },
    { 0x0004, glyph_controlEOT },
    { 0x001B, glyph_controlESC },
    { 0x0017, glyph_controlETB },
    { 0x0003, glyph_controlETX },
    { 0x000C, glyph_controlFF },
    { 0x001C, glyph_controlFS },
    { 0x001D, glyph_controlGS },
    { 0x0009, glyph_controlHT },
    { 0x000A, glyph_controlLF },
    { 0x0015, glyph_controlNAK },
    { 0x001E, glyph_controlRS },
    { 0x000F, glyph_controlSI },
    { 0x000E, glyph_controlSO },
    { 0x0002, glyph_controlSOT },
    { 0x0001, glyph_controlSTX },
    { 0x001A, glyph_controlSUB },
    { 0x0016, glyph_controlSYN },
    { 0x001F, glyph_controlUS },
    { 0x000B, glyph_controlVT },
    { 0x300C, glyph_cornerbracketleft },
    { 0xFF62, glyph_cornerbracketlefthalfwidth },
    { 0xFE41, glyph_cornerbracketleftvertical },
    { 0x300D, glyph_cornerbracketright },
    { 0xFF63, glyph_cornerbracketrighthalfwidth },
    { 0xFE42, glyph_cornerbracketrightvertical },
    { 0x337F, glyph_corporationsquare },
    { 0x33C7, glyph_cosquare },
    { 0x33C6, glyph_coverkgsquare },
    { 0x249E, glyph_cparen },
    { 0x20A2, glyph_cruzeiro },
    { 0x0297, glyph_cstretched },
    { 0x22CF, glyph_curlyand },
    { 0x22CE, glyph_curlyor },
    { 0x0564, glyph_daarmenian },
    { 0x09A6, glyph_dabengali },
    { 0x0636, glyph_dadarabic },
    { 0x0926, glyph_dadeva },
    { 0xFEBE, glyph_dadfinalarabic },
    { 0xFEBF, glyph_dadinitialarabic },
    { 0xFEC0, glyph_dadmedialarabic },
    { 0x05BC, glyph_dagesh },
    { 0x05BC, glyph_dageshhebrew },
    { 0x0AA6, glyph_dagujarati },
    { 0x0A26, glyph_dagurmukhi },
    { 0x3060, glyph_dahiragana },
    { 0x30C0, glyph_dakatakana },
    { 0x062F, glyph_dalarabic },
    { 0x05D3, glyph_dalet },
    { 0xFB33, glyph_daletdagesh },
    { 0xFB33, glyph_daletdageshhebrew },
    { 0x05D3, glyph_dalethatafpatah },
    { 0x05B2, glyph_dalethatafpatah },
    { 0x05D3, glyph_dalethatafpatahhebrew },
    { 0x05B2, glyph_dalethatafpatahhebrew },
    { 0x05D3, glyph_dalethatafsegol },
    { 0x05B1, glyph_dalethatafsegol },
    { 0x05D3, glyph_dalethatafsegolhebrew },
    { 0x05B1, glyph_dalethatafsegolhebrew },
    { 0x05D3, glyph_dalethebrew },
    { 0x05D3, glyph_dalethiriq },
    { 0x05B4, glyph_dalethiriq },
    { 0x05D3, glyph_dalethiriqhebrew },
    { 0x05B4, glyph_dalethiriqhebrew },
    { 0x05D3, glyph_daletholam },
    { 0x05B9, glyph_daletholam },
    { 0x05D3, glyph_daletholamhebrew },
    { 0x05B9, glyph_daletholamhebrew },
    { 0x05D3, glyph_daletpatah },
    { 0x05B7, glyph_daletpatah },
    { 0x05D3, glyph_daletpatahhebrew },
    { 0x05B7, glyph_daletpatahhebrew },
    { 0x05D3, glyph_daletqamats },
    { 0x05B8, glyph_daletqamats },
    { 0x05D3, glyph_daletqamatshebrew },
    { 0x05B8, glyph_daletqamatshebrew },
    { 0x05D3, glyph_daletqubuts },
    { 0x05BB, glyph_daletqubuts },
    { 0x05D3, glyph_daletqubutshebrew },
    { 0x05BB, glyph_daletqubutshebrew },
    { 0x05D3, glyph_daletsegol },
    { 0x05B6, glyph_daletsegol },
    { 0x05D3, glyph_daletsegolhebrew },
    { 0x05B6, glyph_daletsegolhebrew },
    { 0x05D3, glyph_daletsheva },
    { 0x05B0, glyph_daletsheva },
    { 0x05D3, glyph_daletshevahebrew },
    { 0x05B0, glyph_daletshevahebrew },
    { 0x05D3, glyph_dalettsere },
    { 0x05B5, glyph_dalettsere },
    { 0x05D3, glyph_dalettserehebrew },
    { 0x05B5, glyph_dalettserehebrew },
    { 0xFEAA, glyph_dalfinalarabic },
    { 0x064F, glyph_dammaarabic },
    { 0x064F, glyph_dammalowarabic },
    { 0x064C, glyph_dammatanaltonearabic },
    { 0x064C, glyph_dammatanarabic },
    { 0x0964, glyph_danda },
    { 0x05A7, glyph_dargahebrew },
    { 0x05A7, glyph_dargalefthebrew },
    { 0x0485, glyph_dasiapneumatacyrilliccmb },
    { 0x300A, glyph_dblanglebracketleft },
    { 0xFE3D, glyph_dblanglebracketleftvertical },
    { 0x300B, glyph_dblanglebracketright },
    { 0xFE3E, glyph_dblanglebracketrightvertical },
    { 0x032B, glyph_dblarchinvertedbelowcmb },
    { 0x21D4, glyph_dblarrowleft },
    { 0x21D2, glyph_dblarrowright },
    { 0x0965, glyph_dbldanda },
    { 0x030F, glyph_dblgravecmb },
    { 0x222C, glyph_dblintegral },
    { 0x2017, glyph_dbllowline },
    { 0x0333, glyph_dbllowlinecmb },
    { 0x033F, glyph_dbloverlinecmb },
    { 0x02BA, glyph_dblprimemod },
    { 0x2016, glyph_dblverticalbar },
    { 0x030E, glyph_dblverticallineabovecmb },
    { 0x3109, glyph_dbopomofo },
    { 0x33C8, glyph_dbsquare },
    { 0x1E11, glyph_dcedilla },
    { 0x24D3, glyph_dcircle },
    { 0x1E13, glyph_dcircumflexbelow },
    { 0x09A1, glyph_ddabengali },
    { 0x0921, glyph_ddadeva },
    { 0x0AA1, glyph_ddagujarati },
    { 0x0A21, glyph_ddagurmukhi },
    { 0x0688, glyph_ddalarabic },
    { 0xFB89, glyph_ddalfinalarabic },
    { 0x095C, glyph_dddhadeva },
    { 0x09A2, glyph_ddhabengali },
    { 0x0922, glyph_ddhadeva },
    { 0x0AA2, glyph_ddhagujarati },
    { 0x0A22, glyph_ddhagurmukhi },
    { 0x1E0B, glyph_ddotaccent },
    { 0x1E0D, glyph_ddotbelow },
    { 0x066B, glyph_decimalseparatorarabic },
    { 0x066B, glyph_decimalseparatorpersian },
    { 0x0434, glyph_decyrillic },
    { 0x05AD, glyph_dehihebrew },
    { 0x3067, glyph_dehiragana },
    { 0x03EF, glyph_deicoptic },
    { 0x30C7, glyph_dekatakana },
    { 0x232B, glyph_deleteleft },
    { 0x2326, glyph_deleteright },
    { 0x018D, glyph_deltaturned },
    { 0x09F8, glyph_denominatorminusonenumeratorbengali },
    { 0x02A4, glyph_dezh },
    { 0x09A7, glyph_dhabengali },
    { 0x0927, glyph_dhadeva },
    { 0x0AA7, glyph_dhagujarati },
    { 0x0A27, glyph_dhagurmukhi },
    { 0x0257, glyph_dhook },
    { 0x0385, glyph_dialytikatonos },
    { 0x0344, glyph_dialytikatonoscmb },
    { 0x2662, glyph_diamondsuitwhite },
    { 0x0324, glyph_dieresisbelowcmb },
    { 0x0308, glyph_dieresiscmb },
    { 0x3062, glyph_dihiragana },
    { 0x30C2, glyph_dikatakana },
    { 0x3003, glyph_dittomark },
    { 0x2223, glyph_divides },
    { 0x0452, glyph_djecyrillic },
    { 0x1E0F, glyph_dlinebelow },
    { 0x3397, glyph_dlsquare },
    { 0x0111, glyph_dmacron },
    { 0xFF44, glyph_dmonospace },
    { 0x0E0E, glyph_dochadathai },
    { 0x0E14, glyph_dodekthai },
    { 0x3069, glyph_dohiragana },
    { 0x30C9, glyph_dokatakana },
    { 0xFF04, glyph_dollarmonospace },
    { 0xFE69, glyph_dollarsmall },
    { 0x3326, glyph_dorusquare },
    { 0x0307, glyph_dotaccentcmb },
    { 0x0323, glyph_dotbelowcmb },
    { 0x30FB, glyph_dotkatakana },
    { 0x0284, glyph_dotlessjstrokehook },
    { 0x25CC, glyph_dottedcircle },
    { 0xFB1F, glyph_doubleyodpatah },
    { 0xFB1F, glyph_doubleyodpatahhebrew },
    { 0x031E, glyph_downtackbelowcmb },
    { 0x02D5, glyph_downtackmod },
    { 0x249F, glyph_dparen },
    { 0x0256, glyph_dtail },
    { 0x018C, glyph_dtopbar },
    { 0x3065, glyph_duhiragana },
    { 0x30C5, glyph_dukatakana },
    { 0x01F3, glyph_dz },
    { 0x02A3, glyph_dzaltone },
    { 0x01C6, glyph_dzcaron },
    { 0x02A5, glyph_dzcurl },
    { 0x04E1, glyph_dzeabkhasiancyrillic },
    { 0x0455, glyph_dzecyrillic },
    { 0x045F, glyph_dzhecyrillic },
    { 0x2641, glyph_earth },
    { 0x098F, glyph_ebengali },
    { 0x311C, glyph_ebopomofo },
    { 0x090D, glyph_ecandradeva },
    { 0x0A8D, glyph_ecandragujarati },
    { 0x0945, glyph_ecandravowelsigndeva },
    { 0x0AC5, glyph_ecandravowelsigngujarati },
    { 0x1E1D, glyph_ecedillabreve },
    { 0x0565, glyph_echarmenian },
    { 0x0587, glyph_echyiwnarmenian },
    { 0x24D4, glyph_ecircle },
    { 0x1EBF, glyph_ecircumflexacute },
    { 0x1E19, glyph_ecircumflexbelow },
    { 0x1EC7, glyph_ecircumflexdotbelow },
    { 0x1EC1, glyph_ecircumflexgrave },
    { 0x1EC3, glyph_ecircumflexhookabove },
    { 0x1EC5, glyph_ecircumflextilde },
    { 0x0454, glyph_ecyrillic },
    { 0x0205, glyph_edblgrave },
    { 0x090F, glyph_edeva },
    { 0x0117, glyph_edot },
    { 0x1EB9, glyph_edotbelow },
    { 0x0A0F, glyph_eegurmukhi },
    { 0x0A47, glyph_eematragurmukhi },
    { 0x0444, glyph_efcyrillic },
    { 0x0A8F, glyph_egujarati },
    { 0x0567, glyph_eharmenian },
    { 0x311D, glyph_ehbopomofo },
    { 0x3048, glyph_ehiragana },
    { 0x1EBB, glyph_ehookabove },
    { 0x311F, glyph_eibopomofo },
    { 0x0668, glyph_eightarabic },
    { 0x09EE, glyph_eightbengali },
    { 0x2467, glyph_eightcircle },
    { 0x2791, glyph_eightcircleinversesansserif },
    { 0x096E, glyph_eightdeva },
    { 0x2471, glyph_eighteencircle },
    { 0x2485, glyph_eighteenparen },
    { 0x2499, glyph_eighteenperiod },
    { 0x0AEE, glyph_eightgujarati },
    { 0x0A6E, glyph_eightgurmukhi },
    { 0x0668, glyph_eighthackarabic },
    { 0x3028, glyph_eighthangzhou },
    { 0x266B, glyph_eighthnotebeamed },
    { 0x3227, glyph_eightideographicparen },
    { 0xFF18, glyph_eightmonospace },
    { 0x247B, glyph_eightparen },
    { 0x248F, glyph_eightperiod },
    { 0x06F8, glyph_eightpersian },
    { 0x2177, glyph_eightroman },
    { 0x0E58, glyph_eightthai },
    { 0x0207, glyph_einvertedbreve },
    { 0x0465, glyph_eiotifiedcyrillic },
    { 0x30A8, glyph_ekatakana },
    { 0xFF74, glyph_ekatakanahalfwidth },
    { 0x0A74, glyph_ekonkargurmukhi },
    { 0x3154, glyph_ekorean },
    { 0x043B, glyph_elcyrillic },
    { 0x246A, glyph_elevencircle },
    { 0x247E, glyph_elevenparen },
    { 0x2492, glyph_elevenperiod },
    { 0x217A, glyph_elevenroman },
    { 0x22EE, glyph_ellipsisvertical },
    { 0x1E17, glyph_emacronacute },
    { 0x1E15, glyph_emacrongrave },
    { 0x043C, glyph_emcyrillic },
    { 0xFE31, glyph_emdashvertical },
    { 0xFF45, glyph_emonospace },
    { 0x055B, glyph_emphasismarkarmenian },
    { 0x3123, glyph_enbopomofo },
    { 0x043D, glyph_encyrillic },
    { 0xFE32, glyph_endashvertical },
    { 0x04A3, glyph_endescendercyrillic },
    { 0x3125, glyph_engbopomofo },
    { 0x04A5, glyph_enghecyrillic },
    { 0x04C8, glyph_enhookcyrillic },
    { 0x2002, glyph_enspace },
    { 0x3153, glyph_eokorean },
    { 0x025B, glyph_eopen },
    { 0x029A, glyph_eopenclosed },
    { 0x025C, glyph_eopenreversed },
    { 0x025E, glyph_eopenreversedclosed },
    { 0x025D, glyph_eopenreversedhook },
    { 0x24A0, glyph_eparen },
    { 0xFF1D, glyph_equalmonospace },
    { 0xFE66, glyph_equalsmall },
    { 0x207C, glyph_equalsuperior },
    { 0x3126, glyph_erbopomofo },
    { 0x0440, glyph_ercyrillic },
    { 0x0258, glyph_ereversed },
    { 0x044D, glyph_ereversedcyrillic },
    { 0x0441, glyph_escyrillic },
    { 0x04AB, glyph_esdescendercyrillic },
    { 0x0283, glyph_esh },
    { 0x0286, glyph_eshcurl },
    { 0x090E, glyph_eshortdeva },
    { 0x0946, glyph_eshortvowelsigndeva },
    { 0x01AA, glyph_eshreversedloop },
    { 0x0285, glyph_eshsquatreversed },
    { 0x3047, glyph_esmallhiragana },
    { 0x30A7, glyph_esmallkatakana },
    { 0xFF6A, glyph_esmallkatakanahalfwidth },
    { 0x0568, glyph_etarmenian },
    { 0x1EBD, glyph_etilde },
    { 0x1E1B, glyph_etildebelow },
    { 0x0591, glyph_etnahtafoukhhebrew },
    { 0x0591, glyph_etnahtafoukhlefthebrew },
    { 0x0591, glyph_etnahtahebrew },
    { 0x0591, glyph_etnahtalefthebrew },
    { 0x01DD, glyph_eturned },
    { 0x3161, glyph_eukorean },
    { 0x20AC, glyph_euro },
    { 0x09C7, glyph_evowelsignbengali },
    { 0x0947, glyph_evowelsigndeva },
    { 0x0AC7, glyph_evowelsigngujarati },
    { 0x055C, glyph_exclamarmenian },
    { 0xFF01, glyph_exclammonospace },
    { 0x0292, glyph_ezh },
    { 0x01EF, glyph_ezhcaron },
    { 0x0293, glyph_ezhcurl },
    { 0x01B9, glyph_ezhreversed },
    { 0x01BA, glyph_ezhtail },
    { 0x095E, glyph_fadeva },
    { 0x0A5E, glyph_fagurmukhi },
    { 0x2109, glyph_fahrenheit },
    { 0x064E, glyph_fathaarabic },
    { 0x064E, glyph_fathalowarabic },
    { 0x064B, glyph_fathatanarabic },
    { 0x3108, glyph_fbopomofo },
    { 0x24D5, glyph_fcircle },
    { 0x1E1F, glyph_fdotaccent },
    { 0x0641, glyph_feharabic },
    { 0x0586, glyph_feharmenian },
    { 0xFED2, glyph_fehfinalarabic },
    { 0xFED3, glyph_fehinitialarabic },
    { 0xFED4, glyph_fehmedialarabic },
    { 0x03E5, glyph_feicoptic },
    { 0x246E, glyph_fifteencircle },
    { 0x2482, glyph_fifteenparen },
    { 0x2496, glyph_fifteenperiod },
    { 0x05DA, glyph_finalkaf },
    { 0xFB3A, glyph_finalkafdagesh },
    { 0xFB3A, glyph_finalkafdageshhebrew },
    { 0x05DA, glyph_finalkafhebrew },
    { 0x05DA, glyph_finalkafqamats },
    { 0x05B8, glyph_finalkafqamats },
    { 0x05DA, glyph_finalkafqamatshebrew },
    { 0x05B8, glyph_finalkafqamatshebrew },
    { 0x05DA, glyph_finalkafsheva },
    { 0x05B0, glyph_finalkafsheva },
    { 0x05DA, glyph_finalkafshevahebrew },
    { 0x05B0, glyph_finalkafshevahebrew },
    { 0x05DD, glyph_finalmem },
    { 0x05DD, glyph_finalmemhebrew },
    { 0x05DF, glyph_finalnun },
    { 0x05DF, glyph_finalnunhebrew },
    { 0x05E3, glyph_finalpe },
    { 0x05E3, glyph_finalpehebrew },
    { 0x05E5, glyph_finaltsadi },
    { 0x05E5, glyph_finaltsadihebrew },
    { 0x25C9, glyph_fisheye },
    { 0x0473, glyph_fitacyrillic },
    { 0x0665, glyph_fivearabic },
    { 0x09EB, glyph_fivebengali },
    { 0x2464, glyph_fivecircle },
    { 0x278E, glyph_fivecircleinversesansserif },
    { 0x096B, glyph_fivedeva },
    { 0x0AEB, glyph_fivegujarati },
    { 0x0A6B, glyph_fivegurmukhi },
    { 0x0665, glyph_fivehackarabic },
    { 0x3025, glyph_fivehangzhou },
    { 0x3224, glyph_fiveideographicparen },
    { 0xFF15, glyph_fivemonospace },
    { 0x2478, glyph_fiveparen },
    { 0x248C, glyph_fiveperiod },
    { 0x06F5, glyph_fivepersian },
    { 0x2174, glyph_fiveroman },
    { 0x0E55, glyph_fivethai },
    { 0xFF46, glyph_fmonospace },
    { 0x3399, glyph_fmsquare },
    { 0x0E1F, glyph_fofanthai },
    { 0x0E1D, glyph_fofathai },
    { 0x0E4F, glyph_fongmanthai },
    { 0x2200, glyph_forall },
    { 0x0664, glyph_fourarabic },
    { 0x09EA, glyph_fourbengali },
    { 0x2463, glyph_fourcircle },
    { 0x278D, glyph_fourcircleinversesansserif },
    { 0x096A, glyph_fourdeva },
    { 0x0AEA, glyph_fourgujarati },
    { 0x0A6A, glyph_fourgurmukhi },
    { 0x0664, glyph_fourhackarabic },
    { 0x3024, glyph_fourhangzhou },
    { 0x3223, glyph_fourideographicparen },
    { 0xFF14, glyph_fourmonospace },
    { 0x09F7, glyph_fournumeratorbengali },
    { 0x2477, glyph_fourparen },
    { 0x248B, glyph_fourperiod },
    { 0x06F4, glyph_fourpersian },
    { 0x2173, glyph_fourroman },
    { 0x246D, glyph_fourteencircle },
    { 0x2481, glyph_fourteenparen },
    { 0x2495, glyph_fourteenperiod },
    { 0x0E54, glyph_fourthai },
    { 0x02CB, glyph_fourthtonechinese },
    { 0x24A1, glyph_fparen },
    { 0x0997, glyph_gabengali },
    { 0x01F5, glyph_gacute },
    { 0x0917, glyph_gadeva },
    { 0x06AF, glyph_gafarabic },
    { 0xFB93, glyph_gaffinalarabic },
    { 0xFB94, glyph_gafinitialarabic },
    { 0xFB95, glyph_gafmedialarabic },
    { 0x0A97, glyph_gagujarati },
    { 0x0A17, glyph_gagurmukhi },
    { 0x304C, glyph_gahiragana },
    { 0x30AC, glyph_gakatakana },
    { 0x0263, glyph_gammalatinsmall },
    { 0x02E0, glyph_gammasuperior },
    { 0x03EB, glyph_gangiacoptic },
    { 0x310D, glyph_gbopomofo },
    { 0x0123, glyph_gcedilla },
    { 0x24D6, glyph_gcircle },
    { 0x0121, glyph_gdot },
    { 0x0433, glyph_gecyrillic },
    { 0x3052, glyph_gehiragana },
    { 0x30B2, glyph_gekatakana },
    { 0x2251, glyph_geometricallyequal },
    { 0x059C, glyph_gereshaccenthebrew },
    { 0x05F3, glyph_gereshhebrew },
    { 0x059D, glyph_gereshmuqdamhebrew },
    { 0x059E, glyph_gershayimaccenthebrew },
    { 0x05F4, glyph_gershayimhebrew },
    { 0x3013, glyph_getamark },
    { 0x0998, glyph_ghabengali },
    { 0x0572, glyph_ghadarmenian },
    { 0x0918, glyph_ghadeva },
    { 0x0A98, glyph_ghagujarati },
    { 0x0A18, glyph_ghagurmukhi },
    { 0x063A, glyph_ghainarabic },
    { 0xFECE, glyph_ghainfinalarabic },
    { 0xFECF, glyph_ghaininitialarabic },
    { 0xFED0, glyph_ghainmedialarabic },
    { 0x0495, glyph_ghemiddlehookcyrillic },
    { 0x0493, glyph_ghestrokecyrillic },
    { 0x0491, glyph_gheupturncyrillic },
    { 0x095A, glyph_ghhadeva },
    { 0x0A5A, glyph_ghhagurmukhi },
    { 0x0260, glyph_ghook },
    { 0x3393, glyph_ghzsquare },
    { 0x304E, glyph_gihiragana },
    { 0x30AE, glyph_gikatakana },
    { 0x0563, glyph_gimarmenian },
    { 0x05D2, glyph_gimel },
    { 0xFB32, glyph_gimeldagesh },
    { 0xFB32, glyph_gimeldageshhebrew },
    { 0x05D2, glyph_gimelhebrew },
    { 0x0453, glyph_gjecyrillic },
    { 0x01BE, glyph_glottalinvertedstroke },
    { 0x0294, glyph_glottalstop },
    { 0x0296, glyph_glottalstopinverted },
    { 0x02C0, glyph_glottalstopmod },
    { 0x0295, glyph_glottalstopreversed },
    { 0x02C1, glyph_glottalstopreversedmod },
    { 0x02E4, glyph_glottalstopreversedsuperior },
    { 0x02A1, glyph_glottalstopstroke },
    { 0x02A2, glyph_glottalstopstrokereversed },
    { 0x1E21, glyph_gmacron },
    { 0xFF47, glyph_gmonospace },
    { 0x3054, glyph_gohiragana },
    { 0x30B4, glyph_gokatakana },
    { 0x24A2, glyph_gparen },
    { 0x33AC, glyph_gpasquare },
    { 0x0316, glyph_gravebelowcmb },
    { 0x0300, glyph_gravecmb },
    { 0x0953, glyph_gravedeva },
    { 0x02CE, glyph_gravelowmod },
    { 0xFF40, glyph_gravemonospace },
    { 0x0340, glyph_gravetonecmb },
    { 0x22DB, glyph_greaterequalorless },
    { 0xFF1E, glyph_greatermonospace },
    { 0x2273, glyph_greaterorequivalent },
    { 0x2277, glyph_greaterorless },
    { 0x2267, glyph_greateroverequal },
    { 0xFE65, glyph_greatersmall },
    { 0x0261, glyph_gscript },
    { 0x01E5, glyph_gstroke },
    { 0x3050, glyph_guhiragana },
    { 0x30B0, glyph_gukatakana },
    { 0x3318, glyph_guramusquare },
    { 0x33C9, glyph_gysquare },
    { 0x04A9, glyph_haabkhasiancyrillic },
    { 0x06C1, glyph_haaltonearabic },
    { 0x09B9, glyph_habengali },
    { 0x04B3, glyph_hadescendercyrillic },
    { 0x0939, glyph_hadeva },
    { 0x0AB9, glyph_hagujarati },
    { 0x0A39, glyph_hagurmukhi },
    { 0x062D, glyph_haharabic },
    { 0xFEA2, glyph_hahfinalarabic },
    { 0xFEA3, glyph_hahinitialarabic },
    { 0x306F, glyph_hahiragana },
    { 0xFEA4, glyph_hahmedialarabic },
    { 0x332A, glyph_haitusquare },
    { 0x30CF, glyph_hakatakana },
    { 0xFF8A, glyph_hakatakanahalfwidth },
    { 0x0A4D, glyph_halantgurmukhi },
    { 0x0621, glyph_hamzaarabic },
    { 0x0621, glyph_hamzadammaarabic },
    { 0x064F, glyph_hamzadammaarabic },
    { 0x0621, glyph_hamzadammatanarabic },
    { 0x064C, glyph_hamzadammatanarabic },
    { 0x0621, glyph_hamzafathaarabic },
    { 0x064E, glyph_hamzafathaarabic },
    { 0x0621, glyph_hamzafathatanarabic },
    { 0x064B, glyph_hamzafathatanarabic },
    { 0x0621, glyph_hamzalowarabic },
    { 0x0621, glyph_hamzalowkasraarabic },
    { 0x0650, glyph_hamzalowkasraarabic },
    { 0x0621, glyph_hamzalowkasratanarabic },
    { 0x064D, glyph_hamzalowkasratanarabic },
    { 0x0621, glyph_hamzasukunarabic },
    { 0x0652, glyph_hamzasukunarabic },
    { 0x3164, glyph_hangulfiller },
    { 0x044A, glyph_hardsigncyrillic },
    { 0x21BC, glyph_harpoonleftbarbup },
    { 0x21C0, glyph_harpoonrightbarbup },
    { 0x33CA, glyph_hasquare },
    { 0x05B2, glyph_hatafpatah },
    { 0x05B2, glyph_hatafpatah16 },
    { 0x05B2, glyph_hatafpatah23 },
    { 0x05B2, glyph_hatafpatah2f },
    { 0x05B2, glyph_hatafpatahhebrew },
    { 0x05B2, glyph_hatafpatahnarrowhebrew },
    { 0x05B2, glyph_hatafpatahquarterhebrew },
    { 0x05B2, glyph_hatafpatahwidehebrew },
    { 0x05B3, glyph_hatafqamats },
    { 0x05B3, glyph_hatafqamats1b },
    { 0x05B3, glyph_hatafqamats28 },
    { 0x05B3, glyph_hatafqamats34 },
    { 0x05B3, glyph_hatafqamatshebrew },
    { 0x05B3, glyph_hatafqamatsnarrowhebrew },
    { 0x05B3, glyph_hatafqamatsquarterhebrew },
    { 0x05B3, glyph_hatafqamatswidehebrew },
    { 0x05B1, glyph_hatafsegol },
    { 0x05B1, glyph_hatafsegol17 },
    { 0x05B1, glyph_hatafsegol24 },
    { 0x05B1, glyph_hatafsegol30 },
    { 0x05B1, glyph_hatafsegolhebrew },
    { 0x05B1, glyph_hatafsegolnarrowhebrew },
    { 0x05B1, glyph_hatafsegolquarterhebrew },
    { 0x05B1, glyph_hatafsegolwidehebrew },
    { 0x310F, glyph_hbopomofo },
    { 0x1E2B, glyph_hbrevebelow },
    { 0x1E29, glyph_hcedilla },
    { 0x24D7, glyph_hcircle },
    { 0x1E27, glyph_hdieresis },
    { 0x1E23, glyph_hdotaccent },
    { 0x1E25, glyph_hdotbelow },
    { 0x05D4, glyph_he },
    { 0x2665, glyph_heartsuitblack },
    { 0x2661, glyph_heartsuitwhite },
    { 0xFB34, glyph_hedagesh },
    { 0xFB34, glyph_hedageshhebrew },
    { 0x06C1, glyph_hehaltonearabic },
    { 0x0647, glyph_heharabic },
    { 0x05D4, glyph_hehebrew },
    { 0xFBA7, glyph_hehfinalaltonearabic },
    { 0xFEEA, glyph_hehfinalalttwoarabic },
    { 0xFEEA, glyph_hehfinalarabic },
    { 0xFBA5, glyph_hehhamzaabovefinalarabic },
    { 0xFBA4, glyph_hehhamzaaboveisolatedarabic },
    { 0xFBA8, glyph_hehinitialaltonearabic },
    { 0xFEEB, glyph_hehinitialarabic },
    { 0x3078, glyph_hehiragana },
    { 0xFBA9, glyph_hehmedialaltonearabic },
    { 0xFEEC, glyph_hehmedialarabic },
    { 0x337B, glyph_heiseierasquare },
    { 0x30D8, glyph_hekatakana },
    { 0xFF8D, glyph_hekatakanahalfwidth },
    { 0x3336, glyph_hekutaarusquare },
    { 0x0267, glyph_henghook },
    { 0x3339, glyph_herutusquare },
    { 0x05D7, glyph_het },
    { 0x05D7, glyph_hethebrew },
    { 0x0266, glyph_hhook },
    { 0x02B1, glyph_hhooksuperior },
    { 0x327B, glyph_hieuhacirclekorean },
    { 0x321B, glyph_hieuhaparenkorean },
    { 0x326D, glyph_hieuhcirclekorean },
    { 0x314E, glyph_hieuhkorean },
    { 0x320D, glyph_hieuhparenkorean },
    { 0x3072, glyph_hihiragana },
    { 0x30D2, glyph_hikatakana },
    { 0xFF8B, glyph_hikatakanahalfwidth },
    { 0x05B4, glyph_hiriq },
    { 0x05B4, glyph_hiriq14 },
    { 0x05B4, glyph_hiriq21 },
    { 0x05B4, glyph_hiriq2d },
    { 0x05B4, glyph_hiriqhebrew },
    { 0x05B4, glyph_hiriqnarrowhebrew },
    { 0x05B4, glyph_hiriqquarterhebrew },
    { 0x05B4, glyph_hiriqwidehebrew },
    { 0x1E96, glyph_hlinebelow },
    { 0xFF48, glyph_hmonospace },
    { 0x0570, glyph_hoarmenian },
    { 0x0E2B, glyph_hohipthai },
    { 0x307B, glyph_hohiragana },
    { 0x30DB, glyph_hokatakana },
    { 0xFF8E, glyph_hokatakanahalfwidth },
    { 0x05B9, glyph_holam },
    { 0x05B9, glyph_holam19 },
    { 0x05B9, glyph_holam26 },
    { 0x05B9, glyph_holam32 },
    { 0x05B9, glyph_holamhebrew },
    { 0x05B9, glyph_holamnarrowhebrew },
    { 0x05B9, glyph_holamquarterhebrew },
    { 0x05B9, glyph_holamwidehebrew },
    { 0x0E2E, glyph_honokhukthai },
    { 0x0309, glyph_hookcmb },
    { 0x0321, glyph_hookpalatalizedbelowcmb },
    { 0x0322, glyph_hookretroflexbelowcmb },
    { 0x3342, glyph_hoonsquare },
    { 0x03E9, glyph_horicoptic },
    { 0x2015, glyph_horizontalbar },
    { 0x031B, glyph_horncmb },
    { 0x2668, glyph_hotsprings },
    { 0x24A3, glyph_hparen },
    { 0x02B0, glyph_hsuperior },
    { 0x0265, glyph_hturned },
    { 0x3075, glyph_huhiragana },
    { 0x3333, glyph_huiitosquare },
    { 0x30D5, glyph_hukatakana },
    { 0xFF8C, glyph_hukatakanahalfwidth },
    { 0x030B, glyph_hungarumlautcmb },
    { 0x0195, glyph_hv },
    { 0xFF0D, glyph_hyphenmonospace },
    { 0xFE63, glyph_hyphensmall },
    { 0x2010, glyph_hyphentwo },
    { 0x044F, glyph_iacyrillic },
    { 0x0987, glyph_ibengali },
    { 0x3127, glyph_ibopomofo },
    { 0x01D0, glyph_icaron },
    { 0x24D8, glyph_icircle },
    { 0x0456, glyph_icyrillic },
    { 0x0209, glyph_idblgrave },
    { 0x328F, glyph_ideographearthcircle },
    { 0x328B, glyph_ideographfirecircle },
    { 0x323F, glyph_ideographicallianceparen },
    { 0x323A, glyph_ideographiccallparen },
    { 0x32A5, glyph_ideographiccentrecircle },
    { 0x3006, glyph_ideographicclose },
    { 0x3001, glyph_ideographiccomma },
    { 0xFF64, glyph_ideographiccommaleft },
    { 0x3237, glyph_ideographiccongratulationparen },
    { 0x32A3, glyph_ideographiccorrectcircle },
    { 0x322F, glyph_ideographicearthparen },
    { 0x323D, glyph_ideographicenterpriseparen },
    { 0x329D, glyph_ideographicexcellentcircle },
    { 0x3240, glyph_ideographicfestivalparen },
    { 0x3296, glyph_ideographicfinancialcircle },
    { 0x3236, glyph_ideographicfinancialparen },
    { 0x322B, glyph_ideographicfireparen },
    { 0x3232, glyph_ideographichaveparen },
    { 0x32A4, glyph_ideographichighcircle },
    { 0x3005, glyph_ideographiciterationmark },
    { 0x3298, glyph_ideographiclaborcircle },
    { 0x3238, glyph_ideographiclaborparen },
    { 0x32A7, glyph_ideographicleftcircle },
    { 0x32A6, glyph_ideographiclowcircle },
    { 0x32A9, glyph_ideographicmedicinecircle },
    { 0x322E, glyph_ideographicmetalparen },
    { 0x322A, glyph_ideographicmoonparen },
    { 0x3234, glyph_ideographicnameparen },
    { 0x3002, glyph_ideographicperiod },
    { 0x329E, glyph_ideographicprintcircle },
    { 0x3243, glyph_ideographicreachparen },
    { 0x3239, glyph_ideographicrepresentparen },
    { 0x323E, glyph_ideographicresourceparen },
    { 0x32A8, glyph_ideographicrightcircle },
    { 0x3299, glyph_ideographicsecretcircle },
    { 0x3242, glyph_ideographicselfparen },
    { 0x3233, glyph_ideographicsocietyparen },
    { 0x3000, glyph_ideographicspace },
    { 0x3235, glyph_ideographicspecialparen },
    { 0x3231, glyph_ideographicstockparen },
    { 0x323B, glyph_ideographicstudyparen },
    { 0x3230, glyph_ideographicsunparen },
    { 0x323C, glyph_ideographicsuperviseparen },
    { 0x322C, glyph_ideographicwaterparen },
    { 0x322D, glyph_ideographicwoodparen },
    { 0x3007, glyph_ideographiczero },
    { 0x328E, glyph_ideographmetalcircle },
    { 0x328A, glyph_ideographmooncircle },
    { 0x3294, glyph_ideographnamecircle },
    { 0x3290, glyph_ideographsuncircle },
    { 0x328C, glyph_ideographwatercircle },
    { 0x328D, glyph_ideographwoodcircle },
    { 0x0907, glyph_ideva },
    { 0x1E2F, glyph_idieresisacute },
    { 0x04E5, glyph_idieresiscyrillic },
    { 0x1ECB, glyph_idotbelow },
    { 0x04D7, glyph_iebrevecyrillic },
    { 0x0435, glyph_iecyrillic },
    { 0x3275, glyph_ieungacirclekorean },
    { 0x3215, glyph_ieungaparenkorean },
    { 0x3267, glyph_ieungcirclekorean },
    { 0x3147, glyph_ieungkorean },
    { 0x3207, glyph_ieungparenkorean },
    { 0x0A87, glyph_igujarati },
    { 0x0A07, glyph_igurmukhi },
    { 0x3044, glyph_ihiragana },
    { 0x1EC9, glyph_ihookabove },
    { 0x0988, glyph_iibengali },
    { 0x0438, glyph_iicyrillic },
    { 0x0908, glyph_iideva },
    { 0x0A88, glyph_iigujarati },
    { 0x0A08, glyph_iigurmukhi },
    { 0x0A40, glyph_iimatragurmukhi },
    { 0x020B, glyph_iinvertedbreve },
    { 0x0439, glyph_iishortcyrillic },
    { 0x09C0, glyph_iivowelsignbengali },
    { 0x0940, glyph_iivowelsigndeva },
    { 0x0AC0, glyph_iivowelsigngujarati },
    { 0x30A4, glyph_ikatakana },
    { 0xFF72, glyph_ikatakanahalfwidth },
    { 0x3163, glyph_ikorean },
    { 0x02DC, glyph_ilde },
    { 0x05AC, glyph_iluyhebrew },
    { 0x04E3, glyph_imacroncyrillic },
    { 0x2253, glyph_imageorapproximatelyequal },
    { 0x0A3F, glyph_imatragurmukhi },
    { 0xFF49, glyph_imonospace },
    { 0x2206, glyph_increment },
    { 0x056B, glyph_iniarmenian },
    { 0x2321, glyph_integralbottom },
    { 0x2320, glyph_integraltop },
    { 0x3305, glyph_intisquare },
    { 0x0451, glyph_iocyrillic },
    { 0x0269, glyph_iotalatin },
    { 0x24A4, glyph_iparen },
    { 0x0A72, glyph_irigurmukhi },
    { 0x3043, glyph_ismallhiragana },
    { 0x30A3, glyph_ismallkatakana },
    { 0xFF68, glyph_ismallkatakanahalfwidth },
    { 0x09FA, glyph_issharbengali },
    { 0x0268, glyph_istroke },
    { 0x309D, glyph_iterationhiragana },
    { 0x30FD, glyph_iterationkatakana },
    { 0x1E2D, glyph_itildebelow },
    { 0x3129, glyph_iubopomofo },
    { 0x044E, glyph_iucyrillic },
    { 0x09BF, glyph_ivowelsignbengali },
    { 0x093F, glyph_ivowelsigndeva },
    { 0x0ABF, glyph_ivowelsigngujarati },
    { 0x0475, glyph_izhitsacyrillic },
    { 0x0477, glyph_izhitsadblgravecyrillic },
    { 0x0571, glyph_jaarmenian },
    { 0x099C, glyph_jabengali },
    { 0x091C, glyph_jadeva },
    { 0x0A9C, glyph_jagujarati },
    { 0x0A1C, glyph_jagurmukhi },
    { 0x3110, glyph_jbopomofo },
    { 0x01F0, glyph_jcaron },
    { 0x24D9, glyph_jcircle },
    { 0x029D, glyph_jcrossedtail },
    { 0x025F, glyph_jdotlessstroke },
    { 0x0458, glyph_jecyrillic },
    { 0x062C, glyph_jeemarabic },
    { 0xFE9E, glyph_jeemfinalarabic },
    { 0xFE9F, glyph_jeeminitialarabic },
    { 0xFEA0, glyph_jeemmedialarabic },
    { 0x0698, glyph_jeharabic },
    { 0xFB8B, glyph_jehfinalarabic },
    { 0x099D, glyph_jhabengali },
    { 0x091D, glyph_jhadeva },
    { 0x0A9D, glyph_jhagujarati },
    { 0x0A1D, glyph_jhagurmukhi },
    { 0x057B, glyph_jheharmenian },
    { 0x3004, glyph_jis },
    { 0xFF4A, glyph_jmonospace },
    { 0x24A5, glyph_jparen },
    { 0x02B2, glyph_jsuperior },
    { 0x04A1, glyph_kabashkircyrillic },
    { 0x0995, glyph_kabengali },
    { 0x1E31, glyph_kacute },
    { 0x043A, glyph_kacyrillic },
    { 0x049B, glyph_kadescendercyrillic },
    { 0x0915, glyph_kadeva },
    { 0x05DB, glyph_kaf },
    { 0x0643, glyph_kafarabic },
    { 0xFB3B, glyph_kafdagesh },
    { 0xFB3B, glyph_kafdageshhebrew },
    { 0xFEDA, glyph_kaffinalarabic },
    { 0x05DB, glyph_kafhebrew },
    { 0xFEDB, glyph_kafinitialarabic },
    { 0xFEDC, glyph_kafmedialarabic },
    { 0xFB4D, glyph_kafrafehebrew },
    { 0x0A95, glyph_kagujarati },
    { 0x0A15, glyph_kagurmukhi },
    { 0x304B, glyph_kahiragana },
    { 0x04C4, glyph_kahookcyrillic },
    { 0x30AB, glyph_kakatakana },
    { 0xFF76, glyph_kakatakanahalfwidth },
    { 0x03F0, glyph_kappasymbolgreek },
    { 0x3171, glyph_kapyeounmieumkorean },
    { 0x3184, glyph_kapyeounphieuphkorean },
    { 0x3178, glyph_kapyeounpieupkorean },
    { 0x3179, glyph_kapyeounssangpieupkorean },
    { 0x330D, glyph_karoriisquare },
    { 0x0640, glyph_kashidaautoarabic },
    { 0x0640, glyph_kashidaautonosidebearingarabic },
    { 0x30F5, glyph_kasmallkatakana },
    { 0x3384, glyph_kasquare },
    { 0x0650, glyph_kasraarabic },
    { 0x064D, glyph_kasratanarabic },
    { 0x049F, glyph_kastrokecyrillic },
    { 0xFF70, glyph_katahiraprolongmarkhalfwidth },
    { 0x049D, glyph_kaverticalstrokecyrillic },
    { 0x310E, glyph_kbopomofo },
    { 0x3389, glyph_kcalsquare },
    { 0x01E9, glyph_kcaron },
    { 0x0137, glyph_kcedilla },
    { 0x24DA, glyph_kcircle },
    { 0x1E33, glyph_kdotbelow },
    { 0x0584, glyph_keharmenian },
    { 0x3051, glyph_kehiragana },
    { 0x30B1, glyph_kekatakana },
    { 0xFF79, glyph_kekatakanahalfwidth },
    { 0x056F, glyph_kenarmenian },
    { 0x30F6, glyph_kesmallkatakana },
    { 0x0996, glyph_khabengali },
    { 0x0445, glyph_khacyrillic },
    { 0x0916, glyph_khadeva },
    { 0x0A96, glyph_khagujarati },
    { 0x0A16, glyph_khagurmukhi },
    { 0x062E, glyph_khaharabic },
    { 0xFEA6, glyph_khahfinalarabic },
    { 0xFEA7, glyph_khahinitialarabic },
    { 0xFEA8, glyph_khahmedialarabic },
    { 0x03E7, glyph_kheicoptic },
    { 0x0959, glyph_khhadeva },
    { 0x0A59, glyph_khhagurmukhi },
    { 0x3278, glyph_khieukhacirclekorean },
    { 0x3218, glyph_khieukhaparenkorean },
    { 0x326A, glyph_khieukhcirclekorean },
    { 0x314B, glyph_khieukhkorean },
    { 0x320A, glyph_khieukhparenkorean },
    { 0x0E02, glyph_khokhaithai },
    { 0x0E05, glyph_khokhonthai },
    { 0x0E03, glyph_khokhuatthai },
    { 0x0E04, glyph_khokhwaithai },
    { 0x0E5B, glyph_khomutthai },
    { 0x0199, glyph_khook },
    { 0x0E06, glyph_khorakhangthai },
    { 0x3391, glyph_khzsquare },
    { 0x304D, glyph_kihiragana },
    { 0x30AD, glyph_kikatakana },
    { 0xFF77, glyph_kikatakanahalfwidth },
    { 0x3315, glyph_kiroguramusquare },
    { 0x3316, glyph_kiromeetorusquare },
    { 0x3314, glyph_kirosquare },
    { 0x326E, glyph_kiyeokacirclekorean },
    { 0x320E, glyph_kiyeokaparenkorean },
    { 0x3260, glyph_kiyeokcirclekorean },
    { 0x3131, glyph_kiyeokkorean },
    { 0x3200, glyph_kiyeokparenkorean },
    { 0x3133, glyph_kiyeoksioskorean },
    { 0x045C, glyph_kjecyrillic },
    { 0x1E35, glyph_klinebelow },
    { 0x3398, glyph_klsquare },
    { 0x33A6, glyph_kmcubedsquare },
    { 0xFF4B, glyph_kmonospace },
    { 0x33A2, glyph_kmsquaredsquare },
    { 0x3053, glyph_kohiragana },
    { 0x33C0, glyph_kohmsquare },
    { 0x0E01, glyph_kokaithai },
    { 0x30B3, glyph_kokatakana },
    { 0xFF7A, glyph_kokatakanahalfwidth },
    { 0x331E, glyph_kooposquare },
    { 0x0481, glyph_koppacyrillic },
    { 0x327F, glyph_koreanstandardsymbol },
    { 0x0343, glyph_koroniscmb },
    { 0x24A6, glyph_kparen },
    { 0x33AA, glyph_kpasquare },
    { 0x046F, glyph_ksicyrillic },
    { 0x33CF, glyph_ktsquare },
    { 0x029E, glyph_kturned },
    { 0x304F, glyph_kuhiragana },
    { 0x30AF, glyph_kukatakana },
    { 0xFF78, glyph_kukatakanahalfwidth },
    { 0x33B8, glyph_kvsquare },
    { 0x33BE, glyph_kwsquare },
    { 0x09B2, glyph_labengali },
    { 0x0932, glyph_ladeva },
    { 0x0AB2, glyph_lagujarati },
    { 0x0A32, glyph_lagurmukhi },
    { 0x0E45, glyph_lakkhangyaothai },
    { 0xFEFC, glyph_lamaleffinalarabic },
    { 0xFEF8, glyph_lamalefhamzaabovefinalarabic },
    { 0xFEF7, glyph_lamalefhamzaaboveisolatedarabic },
    { 0xFEFA, glyph_lamalefhamzabelowfinalarabic },
    { 0xFEF9, glyph_lamalefhamzabelowisolatedarabic },
    { 0xFEFB, glyph_lamalefisolatedarabic },
    { 0xFEF6, glyph_lamalefmaddaabovefinalarabic },
    { 0xFEF5, glyph_lamalefmaddaaboveisolatedarabic },
    { 0x0644, glyph_lamarabic },
    { 0x019B, glyph_lambdastroke },
    { 0x05DC, glyph_lamed },
    { 0xFB3C, glyph_lameddagesh },
    { 0xFB3C, glyph_lameddageshhebrew },
    { 0x05DC, glyph_lamedhebrew },
    { 0x05DC, glyph_lamedholam },
    { 0x05B9, glyph_lamedholam },
    { 0x05DC, glyph_lamedholamdagesh },
    { 0x05B9, glyph_lamedholamdagesh },
    { 0x05BC, glyph_lamedholamdagesh },
    { 0x05DC, glyph_lamedholamdageshhebrew },
    { 0x05B9, glyph_lamedholamdageshhebrew },
    { 0x05BC, glyph_lamedholamdageshhebrew },
    { 0x05DC, glyph_lamedholamhebrew },
    { 0x05B9, glyph_lamedholamhebrew },
    { 0xFEDE, glyph_lamfinalarabic },
    { 0xFCCA, glyph_lamhahinitialarabic },
    { 0xFEDF, glyph_laminitialarabic },
    { 0xFCC9, glyph_lamjeeminitialarabic },
    { 0xFCCB, glyph_lamkhahinitialarabic },
    { 0xFDF2, glyph_lamlamhehisolatedarabic },
    { 0xFEE0, glyph_lammedialarabic },
    { 0xFD88, glyph_lammeemhahinitialarabic },
    { 0xFCCC, glyph_lammeeminitialarabic },
    { 0xFEDF, glyph_lammeemjeeminitialarabic },
    { 0xFEE4, glyph_lammeemjeeminitialarabic },
    { 0xFEA0, glyph_lammeemjeeminitialarabic },
    { 0xFEDF, glyph_lammeemkhahinitialarabic },
    { 0xFEE4, glyph_lammeemkhahinitialarabic },
    { 0xFEA8, glyph_lammeemkhahinitialarabic },
    { 0x25EF, glyph_largecircle },
    { 0x019A, glyph_lbar },
    { 0x026C, glyph_lbelt },
    { 0x310C, glyph_lbopomofo },
    { 0x013C, glyph_lcedilla },
    { 0x24DB, glyph_lcircle },
    { 0x1E3D, glyph_lcircumflexbelow },
    { 0x0140, glyph_ldotaccent },
    { 0x1E37, glyph_ldotbelow },
    { 0x1E39, glyph_ldotbelowmacron },
    { 0x031A, glyph_leftangleabovecmb },
    { 0x0318, glyph_lefttackbelowcmb },
    { 0x22DA, glyph_lessequalorgreater },
    { 0xFF1C, glyph_lessmonospace },
    { 0x2272, glyph_lessorequivalent },
    { 0x2276, glyph_lessorgreater },
    { 0x2266, glyph_lessoverequal },
    { 0xFE64, glyph_lesssmall },
    { 0x026E, glyph_lezh },
    { 0x026D, glyph_lhookretroflex },
    { 0x056C, glyph_liwnarmenian },
    { 0x01C9, glyph_lj },
    { 0x0459, glyph_ljecyrillic },
    { 0x0933, glyph_lladeva },
    { 0x0AB3, glyph_llagujarati },
    { 0x1E3B, glyph_llinebelow },
    { 0x0934, glyph_llladeva },
    { 0x09E1, glyph_llvocalicbengali },
    { 0x0961, glyph_llvocalicdeva },
    { 0x09E3, glyph_llvocalicvowelsignbengali },
    { 0x0963, glyph_llvocalicvowelsigndeva },
    { 0x026B, glyph_lmiddletilde },
    { 0xFF4C, glyph_lmonospace },
    { 0x33D0, glyph_lmsquare },
    { 0x0E2C, glyph_lochulathai },
    { 0x2310, glyph_logicalnotreversed },
    { 0x0E25, glyph_lolingthai },
    { 0xFE4E, glyph_lowlinecenterline },
    { 0x0332, glyph_lowlinecmb },
    { 0xFE4D, glyph_lowlinedashed },
    { 0x24A7, glyph_lparen },
    { 0x2113, glyph_lsquare },
    { 0x0E26, glyph_luthai },
    { 0x098C, glyph_lvocalicbengali },
    { 0x090C, glyph_lvocalicdeva },
    { 0x09E2, glyph_lvocalicvowelsignbengali },
    { 0x0962, glyph_lvocalicvowelsigndeva },
    { 0x33D3, glyph_lxsquare },
    { 0x09AE, glyph_mabengali },
    { 0x0331, glyph_macronbelowcmb },
    { 0x0304, glyph_macroncmb },
    { 0x02CD, glyph_macronlowmod },
    { 0xFFE3, glyph_macronmonospace },
    { 0x1E3F, glyph_macute },
    { 0x092E, glyph_madeva },
    { 0x0AAE, glyph_magujarati },
    { 0x0A2E, glyph_magurmukhi },
    { 0x05A4, glyph_mahapakhhebrew },
    { 0x05A4, glyph_mahapakhlefthebrew },
    { 0x307E, glyph_mahiragana },
    { 0xF895, glyph_maichattawalowleftthai },
    { 0xF894, glyph_maichattawalowrightthai },
    { 0x0E4B, glyph_maichattawathai },
    { 0xF893, glyph_maichattawaupperleftthai },
    { 0xF88C, glyph_maieklowleftthai },
    { 0xF88B, glyph_maieklowrightthai },
    { 0x0E48, glyph_maiekthai },
    { 0xF88A, glyph_maiekupperleftthai },
    { 0xF884, glyph_maihanakatleftthai },
    { 0x0E31, glyph_maihanakatthai },
    { 0xF889, glyph_maitaikhuleftthai },
    { 0x0E47, glyph_maitaikhuthai },
    { 0xF88F, glyph_maitholowleftthai },
    { 0xF88E, glyph_maitholowrightthai },
    { 0x0E49, glyph_maithothai },
    { 0xF88D, glyph_maithoupperleftthai },
    { 0xF892, glyph_maitrilowleftthai },
    { 0xF891, glyph_maitrilowrightthai },
    { 0x0E4A, glyph_maitrithai },
    { 0xF890, glyph_maitriupperleftthai },
    { 0x0E46, glyph_maiyamokthai },
    { 0x30DE, glyph_makatakana },
    { 0xFF8F, glyph_makatakanahalfwidth },
    { 0x3347, glyph_mansyonsquare },
    { 0x05BE, glyph_maqafhebrew },
    { 0x2642, glyph_mars },
    { 0x05AF, glyph_masoracirclehebrew },
    { 0x3383, glyph_masquare },
    { 0x3107, glyph_mbopomofo },
    { 0x33D4, glyph_mbsquare },
    { 0x24DC, glyph_mcircle },
    { 0x33A5, glyph_mcubedsquare },
    { 0x1E41, glyph_mdotaccent },
    { 0x1E43, glyph_mdotbelow },
    { 0x0645, glyph_meemarabic },
    { 0xFEE2, glyph_meemfinalarabic },
    { 0xFEE3, glyph_meeminitialarabic },
    { 0xFEE4, glyph_meemmedialarabic },
    { 0xFCD1, glyph_meemmeeminitialarabic },
    { 0xFC48, glyph_meemmeemisolatedarabic },
    { 0x334D, glyph_meetorusquare },
    { 0x3081, glyph_mehiragana },
    { 0x337E, glyph_meizierasquare },
    { 0x30E1, glyph_mekatakana },
    { 0xFF92, glyph_mekatakanahalfwidth },
    { 0x05DE, glyph_mem },
    { 0xFB3E, glyph_memdagesh },
    { 0xFB3E, glyph_memdageshhebrew },
    { 0x05DE, glyph_memhebrew },
    { 0x0574, glyph_menarmenian },
    { 0x05A5, glyph_merkhahebrew },
    { 0x05A6, glyph_merkhakefulahebrew },
    { 0x05A6, glyph_merkhakefulalefthebrew },
    { 0x05A5, glyph_merkhalefthebrew },
    { 0x0271, glyph_mhook },
    { 0x3392, glyph_mhzsquare },
    { 0xFF65, glyph_middledotkatakanahalfwidth },
    { 0x00B7, glyph_middot },
    { 0x3272, glyph_mieumacirclekorean },
    { 0x3212, glyph_mieumaparenkorean },
    { 0x3264, glyph_mieumcirclekorean },
    { 0x3141, glyph_mieumkorean },
    { 0x3170, glyph_mieumpansioskorean },
    { 0x3204, glyph_mieumparenkorean },
    { 0x316E, glyph_mieumpieupkorean },
    { 0x316F, glyph_mieumsioskorean },
    { 0x307F, glyph_mihiragana },
    { 0x30DF, glyph_mikatakana },
    { 0xFF90, glyph_mikatakanahalfwidth },
    { 0x0320, glyph_minusbelowcmb },
    { 0x2296, glyph_minuscircle },
    { 0x02D7, glyph_minusmod },
    { 0x2213, glyph_minusplus },
    { 0x334A, glyph_miribaarusquare },
    { 0x3349, glyph_mirisquare },
    { 0x0270, glyph_mlonglegturned },
    { 0x3396, glyph_mlsquare },
    { 0x33A3, glyph_mmcubedsquare },
    { 0xFF4D, glyph_mmonospace },
    { 0x339F, glyph_mmsquaredsquare },
    { 0x3082, glyph_mohiragana },
    { 0x33C1, glyph_mohmsquare },
    { 0x30E2, glyph_mokatakana },
    { 0xFF93, glyph_mokatakanahalfwidth },
    { 0x33D6, glyph_molsquare },
    { 0x0E21, glyph_momathai },
    { 0x33A7, glyph_moverssquare },
    { 0x33A8, glyph_moverssquaredsquare },
    { 0x24A8, glyph_mparen },
    { 0x33AB, glyph_mpasquare },
    { 0x33B3, glyph_mssquare },
    { 0x026F, glyph_mturned },
    { 0x00B5, glyph_mu1 },
    { 0x3382, glyph_muasquare },
    { 0x226B, glyph_muchgreater },
    { 0x226A, glyph_muchless },
    { 0x338C, glyph_mufsquare },
    { 0x338D, glyph_mugsquare },
    { 0x3080, glyph_muhiragana },
    { 0x30E0, glyph_mukatakana },
    { 0xFF91, glyph_mukatakanahalfwidth },
    { 0x3395, glyph_mulsquare },
    { 0x339B, glyph_mumsquare },
    { 0x05A3, glyph_munahhebrew },
    { 0x05A3, glyph_munahlefthebrew },
    { 0x266D, glyph_musicflatsign },
    { 0x266F, glyph_musicsharpsign },
    { 0x33B2, glyph_mussquare },
    { 0x33B6, glyph_muvsquare },
    { 0x33BC, glyph_muwsquare },
    { 0x33B9, glyph_mvmegasquare },
    { 0x33B7, glyph_mvsquare },
    { 0x33BF, glyph_mwmegasquare },
    { 0x33BD, glyph_mwsquare },
    { 0x09A8, glyph_nabengali },
    { 0x2207, glyph_nabla },
    { 0x0928, glyph_nadeva },
    { 0x0AA8, glyph_nagujarati },
    { 0x0A28, glyph_nagurmukhi },
    { 0x306A, glyph_nahiragana },
    { 0x30CA, glyph_nakatakana },
    { 0xFF85, glyph_nakatakanahalfwidth },
    { 0x3381, glyph_nasquare },
    { 0x310B, glyph_nbopomofo },
    { 0x0146, glyph_ncedilla },
    { 0x24DD, glyph_ncircle },
    { 0x1E4B, glyph_ncircumflexbelow },
    { 0x1E45, glyph_ndotaccent },
    { 0x1E47, glyph_ndotbelow },
    { 0x306D, glyph_nehiragana },
    { 0x30CD, glyph_nekatakana },
    { 0xFF88, glyph_nekatakanahalfwidth },
    { 0x20AA, glyph_newsheqelsign },
    { 0x338B, glyph_nfsquare },
    { 0x0999, glyph_ngabengali },
    { 0x0919, glyph_ngadeva },
    { 0x0A99, glyph_ngagujarati },
    { 0x0A19, glyph_ngagurmukhi },
    { 0x0E07, glyph_ngonguthai },
    { 0x3093, glyph_nhiragana },
    { 0x0272, glyph_nhookleft },
    { 0x0273, glyph_nhookretroflex },
    { 0x326F, glyph_nieunacirclekorean },
    { 0x320F, glyph_nieunaparenkorean },
    { 0x3135, glyph_nieuncieuckorean },
    { 0x3261, glyph_nieuncirclekorean },
    { 0x3136, glyph_nieunhieuhkorean },
    { 0x3134, glyph_nieunkorean },
    { 0x3168, glyph_nieunpansioskorean },
    { 0x3201, glyph_nieunparenkorean },
    { 0x3167, glyph_nieunsioskorean },
    { 0x3166, glyph_nieuntikeutkorean },
    { 0x306B, glyph_nihiragana },
    { 0x30CB, glyph_nikatakana },
    { 0xFF86, glyph_nikatakanahalfwidth },
    { 0xF899, glyph_nikhahitleftthai },
    { 0x0E4D, glyph_nikhahitthai },
    { 0x0669, glyph_ninearabic },
    { 0x09EF, glyph_ninebengali },
    { 0x2468, glyph_ninecircle },
    { 0x2792, glyph_ninecircleinversesansserif },
    { 0x096F, glyph_ninedeva },
    { 0x0AEF, glyph_ninegujarati },
    { 0x0A6F, glyph_ninegurmukhi },
    { 0x0669, glyph_ninehackarabic },
    { 0x3029, glyph_ninehangzhou },
    { 0x3228, glyph_nineideographicparen },
    { 0xFF19, glyph_ninemonospace },
    { 0x247C, glyph_nineparen },
    { 0x2490, glyph_nineperiod },
    { 0x06F9, glyph_ninepersian },
    { 0x2178, glyph_nineroman },
    { 0x2472, glyph_nineteencircle },
    { 0x2486, glyph_nineteenparen },
    { 0x249A, glyph_nineteenperiod },
    { 0x0E59, glyph_ninethai },
    { 0x01CC, glyph_nj },
    { 0x045A, glyph_njecyrillic },
    { 0x30F3, glyph_nkatakana },
    { 0xFF9D, glyph_nkatakanahalfwidth },
    { 0x019E, glyph_nlegrightlong },
    { 0x1E49, glyph_nlinebelow },
    { 0xFF4E, glyph_nmonospace },
    { 0x339A, glyph_nmsquare },
    { 0x09A3, glyph_nnabengali },
    { 0x0923, glyph_nnadeva },
    { 0x0AA3, glyph_nnagujarati },
    { 0x0A23, glyph_nnagurmukhi },
    { 0x0929, glyph_nnnadeva },
    { 0x306E, glyph_nohiragana },
    { 0x30CE, glyph_nokatakana },
    { 0xFF89, glyph_nokatakanahalfwidth },
    { 0x00A0, glyph_nonbreakingspace },
    { 0x0E13, glyph_nonenthai },
    { 0x0E19, glyph_nonuthai },
    { 0x0646, glyph_noonarabic },
    { 0xFEE6, glyph_noonfinalarabic },
    { 0x06BA, glyph_noonghunnaarabic },
    { 0xFB9F, glyph_noonghunnafinalarabic },
    { 0xFEE7, glyph_noonhehinitialarabic },
    { 0xFEEC, glyph_noonhehinitialarabic },
    { 0xFEE7, glyph_nooninitialarabic },
    { 0xFCD2, glyph_noonjeeminitialarabic },
    { 0xFC4B, glyph_noonjeemisolatedarabic },
    { 0xFEE8, glyph_noonmedialarabic },
    { 0xFCD5, glyph_noonmeeminitialarabic },
    { 0xFC4E, glyph_noonmeemisolatedarabic },
    { 0xFC8D, glyph_noonnoonfinalarabic },
    { 0x220C, glyph_notcontains },
    { 0x2209, glyph_notelementof },
    { 0x226F, glyph_notgreater },
    { 0x2271, glyph_notgreaternorequal },
    { 0x2279, glyph_notgreaternorless },
    { 0x2262, glyph_notidentical },
    { 0x226E, glyph_notless },
    { 0x2270, glyph_notlessnorequal },
    { 0x2226, glyph_notparallel },
    { 0x2280, glyph_notprecedes },
    { 0x2281, glyph_notsucceeds },
    { 0x2285, glyph_notsuperset },
    { 0x0576, glyph_nowarmenian },
    { 0x24A9, glyph_nparen },
    { 0x33B1, glyph_nssquare },
    { 0x306C, glyph_nuhiragana },
    { 0x30CC, glyph_nukatakana },
    { 0xFF87, glyph_nukatakanahalfwidth },
    { 0x09BC, glyph_nuktabengali },
    { 0x093C, glyph_nuktadeva },
    { 0x0ABC, glyph_nuktagujarati },
    { 0x0A3C, glyph_nuktagurmukhi },
    { 0xFF03, glyph_numbersignmonospace },
    { 0xFE5F, glyph_numbersignsmall },
    { 0x0374, glyph_numeralsigngreek },
    { 0x0375, glyph_numeralsignlowergreek },
    { 0x2116, glyph_numero },
    { 0x05E0, glyph_nun },
    { 0xFB40, glyph_nundagesh },
    { 0xFB40, glyph_nundageshhebrew },
    { 0x05E0, glyph_nunhebrew },
    { 0x33B5, glyph_nvsquare },
    { 0x33BB, glyph_nwsquare },
    { 0x099E, glyph_nyabengali },
    { 0x091E, glyph_nyadeva },
    { 0x0A9E, glyph_nyagujarati },
    { 0x0A1E, glyph_nyagurmukhi },
    { 0x0E2D, glyph_oangthai },
    { 0x0275, glyph_obarred },
    { 0x04E9, glyph_obarredcyrillic },
    { 0x04EB, glyph_obarreddieresiscyrillic },
    { 0x0993, glyph_obengali },
    { 0x311B, glyph_obopomofo },
    { 0x0911, glyph_ocandradeva },
    { 0x0A91, glyph_ocandragujarati },
    { 0x0949, glyph_ocandravowelsigndeva },
    { 0x0AC9, glyph_ocandravowelsigngujarati },
    { 0x01D2, glyph_ocaron },
    { 0x24DE, glyph_ocircle },
    { 0x1ED1, glyph_ocircumflexacute },
    { 0x1ED9, glyph_ocircumflexdotbelow },
    { 0x1ED3, glyph_ocircumflexgrave },
    { 0x1ED5, glyph_ocircumflexhookabove },
    { 0x1ED7, glyph_ocircumflextilde },
    { 0x043E, glyph_ocyrillic },
    { 0x0151, glyph_odblacute },
    { 0x020D, glyph_odblgrave },
    { 0x0913, glyph_odeva },
    { 0x04E7, glyph_odieresiscyrillic },
    { 0x1ECD, glyph_odotbelow },
    { 0x315A, glyph_oekorean },
    { 0x0328, glyph_ogonekcmb },
    { 0x0A93, glyph_ogujarati },
    { 0x0585, glyph_oharmenian },
    { 0x304A, glyph_ohiragana },
    { 0x1ECF, glyph_ohookabove },
    { 0x1EDB, glyph_ohornacute },
    { 0x1EE3, glyph_ohorndotbelow },
    { 0x1EDD, glyph_ohorngrave },
    { 0x1EDF, glyph_ohornhookabove },
    { 0x1EE1, glyph_ohorntilde },
    { 0x01A3, glyph_oi },
    { 0x020F, glyph_oinvertedbreve },
    { 0x30AA, glyph_okatakana },
    { 0xFF75, glyph_okatakanahalfwidth },
    { 0x3157, glyph_okorean },
    { 0x05AB, glyph_olehebrew },
    { 0x1E53, glyph_omacronacute },
    { 0x1E51, glyph_omacrongrave },
    { 0x0950, glyph_omdeva },
    { 0x0461, glyph_omegacyrillic },
    { 0x0277, glyph_omegalatinclosed },
    { 0x047B, glyph_omegaroundcyrillic },
    { 0x047D, glyph_omegatitlocyrillic },
    { 0x0AD0, glyph_omgujarati },
    { 0xFF4F, glyph_omonospace },
    { 0x0661, glyph_onearabic },
    { 0x09E7, glyph_onebengali },
    { 0x2460, glyph_onecircle },
    { 0x278A, glyph_onecircleinversesansserif },
    { 0x0967, glyph_onedeva },
    { 0x0AE7, glyph_onegujarati },
    { 0x0A67, glyph_onegurmukhi },
    { 0x0661, glyph_onehackarabic },
    { 0x3021, glyph_onehangzhou },
    { 0x3220, glyph_oneideographicparen },
    { 0xFF11, glyph_onemonospace },
    { 0x09F4, glyph_onenumeratorbengali },
    { 0x2474, glyph_oneparen },
    { 0x2488, glyph_oneperiod },
    { 0x06F1, glyph_onepersian },
    { 0x2170, glyph_oneroman },
    { 0x0E51, glyph_onethai },
    { 0x01EB, glyph_oogonek },
    { 0x01ED, glyph_oogonekmacron },
    { 0x0A13, glyph_oogurmukhi },
    { 0x0A4B, glyph_oomatragurmukhi },
    { 0x0254, glyph_oopen },
    { 0x24AA, glyph_oparen },
    { 0x2325, glyph_option },
    { 0x0912, glyph_oshortdeva },
    { 0x094A, glyph_oshortvowelsigndeva },
    { 0x3049, glyph_osmallhiragana },
    { 0x30A9, glyph_osmallkatakana },
    { 0xFF6B, glyph_osmallkatakanahalfwidth },
    { 0x01FF, glyph_ostrokeacute },
    { 0x047F, glyph_otcyrillic },
    { 0x1E4D, glyph_otildeacute },
    { 0x1E4F, glyph_otildedieresis },
    { 0x3121, glyph_oubopomofo },
    { 0x203E, glyph_overline },
    { 0xFE4A, glyph_overlinecenterline },
    { 0x0305, glyph_overlinecmb },
    { 0xFE49, glyph_overlinedashed },
    { 0xFE4C, glyph_overlinedblwavy },
    { 0xFE4B, glyph_overlinewavy },
    { 0x00AF, glyph_overscore },
    { 0x09CB, glyph_ovowelsignbengali },
    { 0x094B, glyph_ovowelsigndeva },
    { 0x0ACB, glyph_ovowelsigngujarati },
    { 0x3380, glyph_paampssquare },
    { 0x332B, glyph_paasentosquare },
    { 0x09AA, glyph_pabengali },
    { 0x1E55, glyph_pacute },
    { 0x092A, glyph_padeva },
    { 0x21DF, glyph_pagedown },
    { 0x21DE, glyph_pageup },
    { 0x0AAA, glyph_pagujarati },
    { 0x0A2A, glyph_pagurmukhi },
    { 0x3071, glyph_pahiragana },
    { 0x0E2F, glyph_paiyannoithai },
    { 0x30D1, glyph_pakatakana },
    { 0x0484, glyph_palatalizationcyrilliccmb },
    { 0x04C0, glyph_palochkacyrillic },
    { 0x317F, glyph_pansioskorean },
    { 0x2225, glyph_parallel },
    { 0xFD3E, glyph_parenleftaltonearabic },
    { 0xFF08, glyph_parenleftmonospace },
    { 0xFE59, glyph_parenleftsmall },
    { 0xFE35, glyph_parenleftvertical },
    { 0xFD3F, glyph_parenrightaltonearabic },
    { 0xFF09, glyph_parenrightmonospace },
    { 0xFE5A, glyph_parenrightsmall },
    { 0xFE36, glyph_parenrightvertical },
    { 0x05C0, glyph_paseqhebrew },
    { 0x0599, glyph_pashtahebrew },
    { 0x33A9, glyph_pasquare },
    { 0x05B7, glyph_patah },
    { 0x05B7, glyph_patah11 },
    { 0x05B7, glyph_patah1d },
    { 0x05B7, glyph_patah2a },
    { 0x05B7, glyph_patahhebrew },
    { 0x05B7, glyph_patahnarrowhebrew },
    { 0x05B7, glyph_patahquarterhebrew },
    { 0x05B7, glyph_patahwidehebrew },
    { 0x05A1, glyph_pazerhebrew },
    { 0x3106, glyph_pbopomofo },
    { 0x24DF, glyph_pcircle },
    { 0x1E57, glyph_pdotaccent },
    { 0x05E4, glyph_pe },
    { 0x043F, glyph_pecyrillic },
    { 0xFB44, glyph_pedagesh },
    { 0xFB44, glyph_pedageshhebrew },
    { 0x333B, glyph_peezisquare },
    { 0xFB43, glyph_pefinaldageshhebrew },
    { 0x067E, glyph_peharabic },
    { 0x057A, glyph_peharmenian },
    { 0x05E4, glyph_pehebrew },
    { 0xFB57, glyph_pehfinalarabic },
    { 0xFB58, glyph_pehinitialarabic },
    { 0x307A, glyph_pehiragana },
    { 0xFB59, glyph_pehmedialarabic },
    { 0x30DA, glyph_pekatakana },
    { 0x04A7, glyph_pemiddlehookcyrillic },
    { 0xFB4E, glyph_perafehebrew },
    { 0x066A, glyph_percentarabic },
    { 0xFF05, glyph_percentmonospace },
    { 0xFE6A, glyph_percentsmall },
    { 0x0589, glyph_periodarmenian },
    { 0xFF61, glyph_periodhalfwidth },
    { 0xFF0E, glyph_periodmonospace },
    { 0xFE52, glyph_periodsmall },
    { 0x0342, glyph_perispomenigreekcmb },
    { 0x338A, glyph_pfsquare },
    { 0x09AB, glyph_phabengali },
    { 0x092B, glyph_phadeva },
    { 0x0AAB, glyph_phagujarati },
    { 0x0A2B, glyph_phagurmukhi },
    { 0x327A, glyph_phieuphacirclekorean },
    { 0x321A, glyph_phieuphaparenkorean },
    { 0x326C, glyph_phieuphcirclekorean },
    { 0x314D, glyph_phieuphkorean },
    { 0x320C, glyph_phieuphparenkorean },
    { 0x0278, glyph_philatin },
    { 0x0E3A, glyph_phinthuthai },
    { 0x03D5, glyph_phisymbolgreek },
    { 0x01A5, glyph_phook },
    { 0x0E1E, glyph_phophanthai },
    { 0x0E1C, glyph_phophungthai },
    { 0x0E20, glyph_phosamphaothai },
    { 0x3273, glyph_pieupacirclekorean },
    { 0x3213, glyph_pieupaparenkorean },
    { 0x3176, glyph_pieupcieuckorean },
    { 0x3265, glyph_pieupcirclekorean },
    { 0x3172, glyph_pieupkiyeokkorean },
    { 0x3142, glyph_pieupkorean },
    { 0x3205, glyph_pieupparenkorean },
    { 0x3174, glyph_pieupsioskiyeokkorean },
    { 0x3144, glyph_pieupsioskorean },
    { 0x3175, glyph_pieupsiostikeutkorean },
    { 0x3177, glyph_pieupthieuthkorean },
    { 0x3173, glyph_pieuptikeutkorean },
    { 0x3074, glyph_pihiragana },
    { 0x30D4, glyph_pikatakana },
    { 0x03D6, glyph_pisymbolgreek },
    { 0x0583, glyph_piwrarmenian },
    { 0x031F, glyph_plusbelowcmb },
    { 0x2295, glyph_pluscircle },
    { 0x02D6, glyph_plusmod },
    { 0xFF0B, glyph_plusmonospace },
    { 0xFE62, glyph_plussmall },
    { 0x207A, glyph_plussuperior },
    { 0xFF50, glyph_pmonospace },
    { 0x33D8, glyph_pmsquare },
    { 0x307D, glyph_pohiragana },
    { 0x261F, glyph_pointingindexdownwhite },
    { 0x261C, glyph_pointingindexleftwhite },
    { 0x261E, glyph_pointingindexrightwhite },
    { 0x261D, glyph_pointingindexupwhite },
    { 0x30DD, glyph_pokatakana },
    { 0x0E1B, glyph_poplathai },
    { 0x3012, glyph_postalmark },
    { 0x3020, glyph_postalmarkface },
    { 0x24AB, glyph_pparen },
    { 0x227A, glyph_precedes },
    { 0x02B9, glyph_primemod },
    { 0x2035, glyph_primereversed },
    { 0x2305, glyph_projective },
    { 0x30FC, glyph_prolongedkana },
    { 0x2318, glyph_propellor },
    { 0x2237, glyph_proportion },
    { 0x0471, glyph_psicyrillic },
    { 0x0486, glyph_psilipneumatacyrilliccmb },
    { 0x33B0, glyph_pssquare },
    { 0x3077, glyph_puhiragana },
    { 0x30D7, glyph_pukatakana },
    { 0x33B4, glyph_pvsquare },
    { 0x33BA, glyph_pwsquare },
    { 0x0958, glyph_qadeva },
    { 0x05A8, glyph_qadmahebrew },
    { 0x0642, glyph_qafarabic },
    { 0xFED6, glyph_qaffinalarabic },
    { 0xFED7, glyph_qafinitialarabic },
    { 0xFED8, glyph_qafmedialarabic },
    { 0x05B8, glyph_qamats },
    { 0x05B8, glyph_qamats10 },
    { 0x05B8, glyph_qamats1a },
    { 0x05B8, glyph_qamats1c },
    { 0x05B8, glyph_qamats27 },
    { 0x05B8, glyph_qamats29 },
    { 0x05B8, glyph_qamats33 },
    { 0x05B8, glyph_qamatsde },
    { 0x05B8, glyph_qamatshebrew },
    { 0x05B8, glyph_qamatsnarrowhebrew },
    { 0x05B8, glyph_qamatsqatanhebrew },
    { 0x05B8, glyph_qamatsqatannarrowhebrew },
    { 0x05B8, glyph_qamatsqatanquarterhebrew },
    { 0x05B8, glyph_qamatsqatanwidehebrew },
    { 0x05B8, glyph_qamatsquarterhebrew },
    { 0x05B8, glyph_qamatswidehebrew },
    { 0x059F, glyph_qarneyparahebrew },
    { 0x3111, glyph_qbopomofo },
    { 0x24E0, glyph_qcircle },
    { 0x02A0, glyph_qhook },
    { 0xFF51, glyph_qmonospace },
    { 0x05E7, glyph_qof },
    { 0xFB47, glyph_qofdagesh },
    { 0xFB47, glyph_qofdageshhebrew },
    { 0x05E7, glyph_qofhatafpatah },
    { 0x05B2, glyph_qofhatafpatah },
    { 0x05E7, glyph_qofhatafpatahhebrew },
    { 0x05B2, glyph_qofhatafpatahhebrew },
    { 0x05E7, glyph_qofhatafsegol },
    { 0x05B1, glyph_qofhatafsegol },
    { 0x05E7, glyph_qofhatafsegolhebrew },
    { 0x05B1, glyph_qofhatafsegolhebrew },
    { 0x05E7, glyph_qofhebrew },
    { 0x05E7, glyph_qofhiriq },
    { 0x05B4, glyph_qofhiriq },
    { 0x05E7, glyph_qofhiriqhebrew },
    { 0x05B4, glyph_qofhiriqhebrew },
    { 0x05E7, glyph_qofholam },
    { 0x05B9, glyph_qofholam },
    { 0x05E7, glyph_qofholamhebrew },
    { 0x05B9, glyph_qofholamhebrew },
    { 0x05E7, glyph_qofpatah },
    { 0x05B7, glyph_qofpatah },
    { 0x05E7, glyph_qofpatahhebrew },
    { 0x05B7, glyph_qofpatahhebrew },
    { 0x05E7, glyph_qofqamats },
    { 0x05B8, glyph_qofqamats },
    { 0x05E7, glyph_qofqamatshebrew },
    { 0x05B8, glyph_qofqamatshebrew },
    { 0x05E7, glyph_qofqubuts },
    { 0x05BB, glyph_qofqubuts },
    { 0x05E7, glyph_qofqubutshebrew },
    { 0x05BB, glyph_qofqubutshebrew },
    { 0x05E7, glyph_qofsegol },
    { 0x05B6, glyph_qofsegol },
    { 0x05E7, glyph_qofsegolhebrew },
    { 0x05B6, glyph_qofsegolhebrew },
    { 0x05E7, glyph_qofsheva },
    { 0x05B0, glyph_qofsheva },
    { 0x05E7, glyph_qofshevahebrew },
    { 0x05B0, glyph_qofshevahebrew },
    { 0x05E7, glyph_qoftsere },
    { 0x05B5, glyph_qoftsere },
    { 0x05E7, glyph_qoftserehebrew },
    { 0x05B5, glyph_qoftserehebrew },
    { 0x24AC, glyph_qparen },
    { 0x2669, glyph_quarternote },
    { 0x05BB, glyph_qubuts },
    { 0x05BB, glyph_qubuts18 },
    { 0x05BB, glyph_qubuts25 },
    { 0x05BB, glyph_qubuts31 },
    { 0x05BB, glyph_qubutshebrew },
    { 0x05BB, glyph_qubutsnarrowhebrew },
    { 0x05BB, glyph_qubutsquarterhebrew },
    { 0x05BB, glyph_qubutswidehebrew },
    { 0x061F, glyph_questionarabic },
    { 0x055E, glyph_questionarmenian },
    { 0x037E, glyph_questiongreek },
    { 0xFF1F, glyph_questionmonospace },
    { 0xFF02, glyph_quotedblmonospace },
    { 0x301E, glyph_quotedblprime },
    { 0x301D, glyph_quotedblprimereversed },
    { 0x201B, glyph_quoteleftreversed },
    { 0x0149, glyph_quoterightn },
    { 0xFF07, glyph_quotesinglemonospace },
    { 0x057C, glyph_raarmenian },
    { 0x09B0, glyph_rabengali },
    { 0x0930, glyph_radeva },
    { 0x33AE, glyph_radoverssquare },
    { 0x33AF, glyph_radoverssquaredsquare },
    { 0x33AD, glyph_radsquare },
    { 0x05BF, glyph_rafe },
    { 0x05BF, glyph_rafehebrew },
    { 0x0AB0, glyph_ragujarati },
    { 0x0A30, glyph_ragurmukhi },
    { 0x3089, glyph_rahiragana },
    { 0x30E9, glyph_rakatakana },
    { 0xFF97, glyph_rakatakanahalfwidth },
    { 0x09F1, glyph_ralowerdiagonalbengali },
    { 0x09F0, glyph_ramiddlediagonalbengali },
    { 0x0264, glyph_ramshorn },
    { 0x2236, glyph_ratio },
    { 0x3116, glyph_rbopomofo },
    { 0x0157, glyph_rcedilla },
    { 0x24E1, glyph_rcircle },
    { 0x0211, glyph_rdblgrave },
    { 0x1E59, glyph_rdotaccent },
    { 0x1E5B, glyph_rdotbelow },
    { 0x1E5D, glyph_rdotbelowmacron },
    { 0x203B, glyph_referencemark },
    { 0x0631, glyph_reharabic },
    { 0x0580, glyph_reharmenian },
    { 0xFEAE, glyph_rehfinalarabic },
    { 0x308C, glyph_rehiragana },
    { 0x0631, glyph_rehyehaleflamarabic },
    { 0xFEF3, glyph_rehyehaleflamarabic },
    { 0xFE8E, glyph_rehyehaleflamarabic },
    { 0x0644, glyph_rehyehaleflamarabic },
    { 0x30EC, glyph_rekatakana },
    { 0xFF9A, glyph_rekatakanahalfwidth },
    { 0x05E8, glyph_resh },
    { 0xFB48, glyph_reshdageshhebrew },
    { 0x05E8, glyph_reshhatafpatah },
    { 0x05B2, glyph_reshhatafpatah },
    { 0x05E8, glyph_reshhatafpatahhebrew },
    { 0x05B2, glyph_reshhatafpatahhebrew },
    { 0x05E8, glyph_reshhatafsegol },
    { 0x05B1, glyph_reshhatafsegol },
    { 0x05E8, glyph_reshhatafsegolhebrew },
    { 0x05B1, glyph_reshhatafsegolhebrew },
    { 0x05E8, glyph_reshhebrew },
    { 0x05E8, glyph_reshhiriq },
    { 0x05B4, glyph_reshhiriq },
    { 0x05E8, glyph_reshhiriqhebrew },
    { 0x05B4, glyph_reshhiriqhebrew },
    { 0x05E8, glyph_reshholam },
    { 0x05B9, glyph_reshholam },
    { 0x05E8, glyph_reshholamhebrew },
    { 0x05B9, glyph_reshholamhebrew },
    { 0x05E8, glyph_reshpatah },
    { 0x05B7, glyph_reshpatah },
    { 0x05E8, glyph_reshpatahhebrew },
    { 0x05B7, glyph_reshpatahhebrew },
    { 0x05E8, glyph_reshqamats },
    { 0x05B8, glyph_reshqamats },
    { 0x05E8, glyph_reshqamatshebrew },
    { 0x05B8, glyph_reshqamatshebrew },
    { 0x05E8, glyph_reshqubuts },
    { 0x05BB, glyph_reshqubuts },
    { 0x05E8, glyph_reshqubutshebrew },
    { 0x05BB, glyph_reshqubutshebrew },
    { 0x05E8, glyph_reshsegol },
    { 0x05B6, glyph_reshsegol },
    { 0x05E8, glyph_reshsegolhebrew },
    { 0x05B6, glyph_reshsegolhebrew },
    { 0x05E8, glyph_reshsheva },
    { 0x05B0, glyph_reshsheva },
    { 0x05E8, glyph_reshshevahebrew },
    { 0x05B0, glyph_reshshevahebrew },
    { 0x05E8, glyph_reshtsere },
    { 0x05B5, glyph_reshtsere },
    { 0x05E8, glyph_reshtserehebrew },
    { 0x05B5, glyph_reshtserehebrew },
    { 0x223D, glyph_reversedtilde },
    { 0x0597, glyph_reviahebrew },
    { 0x0597, glyph_reviamugrashhebrew },
    { 0x027E, glyph_rfishhook },
    { 0x027F, glyph_rfishhookreversed },
    { 0x09DD, glyph_rhabengali },
    { 0x095D, glyph_rhadeva },
    { 0x027D, glyph_rhook },
    { 0x027B, glyph_rhookturned },
    { 0x02B5, glyph_rhookturnedsuperior },
    { 0x03F1, glyph_rhosymbolgreek },
    { 0x02DE, glyph_rhotichookmod },
    { 0x3271, glyph_rieulacirclekorean },
    { 0x3211, glyph_rieulaparenkorean },
    { 0x3263, glyph_rieulcirclekorean },
    { 0x3140, glyph_rieulhieuhkorean },
    { 0x313A, glyph_rieulkiyeokkorean },
    { 0x3169, glyph_rieulkiyeoksioskorean },
    { 0x3139, glyph_rieulkorean },
    { 0x313B, glyph_rieulmieumkorean },
    { 0x316C, glyph_rieulpansioskorean },
    { 0x3203, glyph_rieulparenkorean },
    { 0x313F, glyph_rieulphieuphkorean },
    { 0x313C, glyph_rieulpieupkorean },
    { 0x316B, glyph_rieulpieupsioskorean },
    { 0x313D, glyph_rieulsioskorean },
    { 0x313E, glyph_rieulthieuthkorean },
    { 0x316A, glyph_rieultikeutkorean },
    { 0x316D, glyph_rieulyeorinhieuhkorean },
    { 0x221F, glyph_rightangle },
    { 0x0319, glyph_righttackbelowcmb },
    { 0x22BF, glyph_righttriangle },
    { 0x308A, glyph_rihiragana },
    { 0x30EA, glyph_rikatakana },
    { 0xFF98, glyph_rikatakanahalfwidth },
    { 0x0325, glyph_ringbelowcmb },
    { 0x030A, glyph_ringcmb },
    { 0x02BF, glyph_ringhalfleft },
    { 0x0559, glyph_ringhalfleftarmenian },
    { 0x031C, glyph_ringhalfleftbelowcmb },
    { 0x02D3, glyph_ringhalfleftcentered },
    { 0x02BE, glyph_ringhalfright },
    { 0x0339, glyph_ringhalfrightbelowcmb },
    { 0x02D2, glyph_ringhalfrightcentered },
    { 0x0213, glyph_rinvertedbreve },
    { 0x3351, glyph_rittorusquare },
    { 0x1E5F, glyph_rlinebelow },
    { 0x027C, glyph_rlongleg },
    { 0x027A, glyph_rlonglegturned },
    { 0xFF52, glyph_rmonospace },
    { 0x308D, glyph_rohiragana },
    { 0x30ED, glyph_rokatakana },
    { 0xFF9B, glyph_rokatakanahalfwidth },
    { 0x0E23, glyph_roruathai },
    { 0x24AD, glyph_rparen },
    { 0x09DC, glyph_rrabengali },
    { 0x0931, glyph_rradeva },
    { 0x0A5C, glyph_rragurmukhi },
    { 0x0691, glyph_rreharabic },
    { 0xFB8D, glyph_rrehfinalarabic },
    { 0x09E0, glyph_rrvocalicbengali },
    { 0x0960, glyph_rrvocalicdeva },
    { 0x0AE0, glyph_rrvocalicgujarati },
    { 0x09C4, glyph_rrvocalicvowelsignbengali },
    { 0x0944, glyph_rrvocalicvowelsigndeva },
    { 0x0AC4, glyph_rrvocalicvowelsigngujarati },
    { 0x0279, glyph_rturned },
    { 0x02B4, glyph_rturnedsuperior },
    { 0x308B, glyph_ruhiragana },
    { 0x30EB, glyph_rukatakana },
    { 0xFF99, glyph_rukatakanahalfwidth },
    { 0x09F2, glyph_rupeemarkbengali },
    { 0x09F3, glyph_rupeesignbengali },
    { 0x0E24, glyph_ruthai },
    { 0x098B, glyph_rvocalicbengali },
    { 0x090B, glyph_rvocalicdeva },
    { 0x0A8B, glyph_rvocalicgujarati },
    { 0x09C3, glyph_rvocalicvowelsignbengali },
    { 0x0943, glyph_rvocalicvowelsigndeva },
    { 0x0AC3, glyph_rvocalicvowelsigngujarati },
    { 0x09B8, glyph_sabengali },
    { 0x1E65, glyph_sacutedotaccent },
    { 0x0635, glyph_sadarabic },
    { 0x0938, glyph_sadeva },
    { 0xFEBA, glyph_sadfinalarabic },
    { 0xFEBB, glyph_sadinitialarabic },
    { 0xFEBC, glyph_sadmedialarabic },
    { 0x0AB8, glyph_sagujarati },
    { 0x0A38, glyph_sagurmukhi },
    { 0x3055, glyph_sahiragana },
    { 0x30B5, glyph_sakatakana },
    { 0xFF7B, glyph_sakatakanahalfwidth },
    { 0xFDFA, glyph_sallallahoualayhewasallamarabic },
    { 0x05E1, glyph_samekh },
    { 0xFB41, glyph_samekhdagesh },
    { 0xFB41, glyph_samekhdageshhebrew },
    { 0x05E1, glyph_samekhhebrew },
    { 0x0E32, glyph_saraaathai },
    { 0x0E41, glyph_saraaethai },
    { 0x0E44, glyph_saraaimaimalaithai },
    { 0x0E43, glyph_saraaimaimuanthai },
    { 0x0E33, glyph_saraamthai },
    { 0x0E30, glyph_saraathai },
    { 0x0E40, glyph_saraethai },
    { 0xF886, glyph_saraiileftthai },
    { 0x0E35, glyph_saraiithai },
    { 0xF885, glyph_saraileftthai },
    { 0x0E34, glyph_saraithai },
    { 0x0E42, glyph_saraothai },
    { 0xF888, glyph_saraueeleftthai },
    { 0x0E37, glyph_saraueethai },
    { 0xF887, glyph_saraueleftthai },
    { 0x0E36, glyph_sarauethai },
    { 0x0E38, glyph_sarauthai },
    { 0x0E39, glyph_sarauuthai },
    { 0x3119, glyph_sbopomofo },
    { 0x1E67, glyph_scarondotaccent },
    { 0x0259, glyph_schwa },
    { 0x04D9, glyph_schwacyrillic },
    { 0x04DB, glyph_schwadieresiscyrillic },
    { 0x025A, glyph_schwahook },
    { 0x24E2, glyph_scircle },
    { 0x1E61, glyph_sdotaccent },
    { 0x1E63, glyph_sdotbelow },
    { 0x1E69, glyph_sdotbelowdotaccent },
    { 0x033C, glyph_seagullbelowcmb },
    { 0x02CA, glyph_secondtonechinese },
    { 0x0633, glyph_seenarabic },
    { 0xFEB2, glyph_seenfinalarabic },
    { 0xFEB3, glyph_seeninitialarabic },
    { 0xFEB4, glyph_seenmedialarabic },
    { 0x05B6, glyph_segol },
    { 0x05B6, glyph_segol13 },
    { 0x05B6, glyph_segol1f },
    { 0x05B6, glyph_segol2c },
    { 0x05B6, glyph_segolhebrew },
    { 0x05B6, glyph_segolnarrowhebrew },
    { 0x05B6, glyph_segolquarterhebrew },
    { 0x0592, glyph_segoltahebrew },
    { 0x05B6, glyph_segolwidehebrew },
    { 0x057D, glyph_seharmenian },
    { 0x305B, glyph_sehiragana },
    { 0x30BB, glyph_sekatakana },
    { 0xFF7E, glyph_sekatakanahalfwidth },
    { 0x061B, glyph_semicolonarabic },
    { 0xFF1B, glyph_semicolonmonospace },
    { 0xFE54, glyph_semicolonsmall },
    { 0x309C, glyph_semivoicedmarkkana },
    { 0xFF9F, glyph_semivoicedmarkkanahalfwidth },
    { 0x3322, glyph_sentisquare },
    { 0x3323, glyph_sentosquare },
    { 0x0667, glyph_sevenarabic },
    { 0x09ED, glyph_sevenbengali },
    { 0x2466, glyph_sevencircle },
    { 0x2790, glyph_sevencircleinversesansserif },
    { 0x096D, glyph_sevendeva },
    { 0x0AED, glyph_sevengujarati },
    { 0x0A6D, glyph_sevengurmukhi },
    { 0x0667, glyph_sevenhackarabic },
    { 0x3027, glyph_sevenhangzhou },
    { 0x3226, glyph_sevenideographicparen },
    { 0xFF17, glyph_sevenmonospace },
    { 0x247A, glyph_sevenparen },
    { 0x248E, glyph_sevenperiod },
    { 0x06F7, glyph_sevenpersian },
    { 0x2176, glyph_sevenroman },
    { 0x2470, glyph_seventeencircle },
    { 0x2484, glyph_seventeenparen },
    { 0x2498, glyph_seventeenperiod },
    { 0x0E57, glyph_seventhai },
    { 0x0577, glyph_shaarmenian },
    { 0x09B6, glyph_shabengali },
    { 0x0448, glyph_shacyrillic },
    { 0x0651, glyph_shaddaarabic },
    { 0xFC61, glyph_shaddadammaarabic },
    { 0xFC5E, glyph_shaddadammatanarabic },
    { 0xFC60, glyph_shaddafathaarabic },
    { 0x0651, glyph_shaddafathatanarabic },
    { 0x064B, glyph_shaddafathatanarabic },
    { 0xFC62, glyph_shaddakasraarabic },
    { 0xFC5F, glyph_shaddakasratanarabic },
    { 0x2593, glyph_shadedark },
    { 0x2591, glyph_shadelight },
    { 0x2592, glyph_shademedium },
    { 0x0936, glyph_shadeva },
    { 0x0AB6, glyph_shagujarati },
    { 0x0A36, glyph_shagurmukhi },
    { 0x0593, glyph_shalshelethebrew },
    { 0x3115, glyph_shbopomofo },
    { 0x0449, glyph_shchacyrillic },
    { 0x0634, glyph_sheenarabic },
    { 0xFEB6, glyph_sheenfinalarabic },
    { 0xFEB7, glyph_sheeninitialarabic },
    { 0xFEB8, glyph_sheenmedialarabic },
    { 0x03E3, glyph_sheicoptic },
    { 0x20AA, glyph_sheqel },
    { 0x20AA, glyph_sheqelhebrew },
    { 0x05B0, glyph_sheva },
    { 0x05B0, glyph_sheva115 },
    { 0x05B0, glyph_sheva15 },
    { 0x05B0, glyph_sheva22 },
    { 0x05B0, glyph_sheva2e },
    { 0x05B0, glyph_shevahebrew },
    { 0x05B0, glyph_shevanarrowhebrew },
    { 0x05B0, glyph_shevaquarterhebrew },
    { 0x05B0, glyph_shevawidehebrew },
    { 0x04BB, glyph_shhacyrillic },
    { 0x03ED, glyph_shimacoptic },
    { 0x05E9, glyph_shin },
    { 0xFB49, glyph_shindagesh },
    { 0xFB49, glyph_shindageshhebrew },
    { 0xFB2C, glyph_shindageshshindot },
    { 0xFB2C, glyph_shindageshshindothebrew },
    { 0xFB2D, glyph_shindageshsindot },
    { 0xFB2D, glyph_shindageshsindothebrew },
    { 0x05C1, glyph_shindothebrew },
    { 0x05E9, glyph_shinhebrew },
    { 0xFB2A, glyph_shinshindot },
    { 0xFB2A, glyph_shinshindothebrew },
    { 0xFB2B, glyph_shinsindot },
    { 0xFB2B, glyph_shinsindothebrew },
    { 0x0282, glyph_shook },
    { 0x03C2, glyph_sigmafinal },
    { 0x03F2, glyph_sigmalunatesymbolgreek },
    { 0x3057, glyph_sihiragana },
    { 0x30B7, glyph_sikatakana },
    { 0xFF7C, glyph_sikatakanahalfwidth },
    { 0x05BD, glyph_siluqhebrew },
    { 0x05BD, glyph_siluqlefthebrew },
    { 0x05C2, glyph_sindothebrew },
    { 0x3274, glyph_siosacirclekorean },
    { 0x3214, glyph_siosaparenkorean },
    { 0x317E, glyph_sioscieuckorean },
    { 0x3266, glyph_sioscirclekorean },
    { 0x317A, glyph_sioskiyeokkorean },
    { 0x3145, glyph_sioskorean },
    { 0x317B, glyph_siosnieunkorean },
    { 0x3206, glyph_siosparenkorean },
    { 0x317D, glyph_siospieupkorean },
    { 0x317C, glyph_siostikeutkorean },
    { 0x0666, glyph_sixarabic },
    { 0x09EC, glyph_sixbengali },
    { 0x2465, glyph_sixcircle },
    { 0x278F, glyph_sixcircleinversesansserif },
    { 0x096C, glyph_sixdeva },
    { 0x0AEC, glyph_sixgujarati },
    { 0x0A6C, glyph_sixgurmukhi },
    { 0x0666, glyph_sixhackarabic },
    { 0x3026, glyph_sixhangzhou },
    { 0x3225, glyph_sixideographicparen },
    { 0xFF16, glyph_sixmonospace },
    { 0x2479, glyph_sixparen },
    { 0x248D, glyph_sixperiod },
    { 0x06F6, glyph_sixpersian },
    { 0x2175, glyph_sixroman },
    { 0x246F, glyph_sixteencircle },
    { 0x09F9, glyph_sixteencurrencydenominatorbengali },
    { 0x2483, glyph_sixteenparen },
    { 0x2497, glyph_sixteenperiod },
    { 0x0E56, glyph_sixthai },
    { 0xFF0F, glyph_slashmonospace },
    { 0x017F, glyph_slong },
    { 0x1E9B, glyph_slongdotaccent },
    { 0xFF53, glyph_smonospace },
    { 0x05C3, glyph_sofpasuqhebrew },
    { 0x00AD, glyph_softhyphen },
    { 0x044C, glyph_softsigncyrillic },
    { 0x305D, glyph_sohiragana },
    { 0x30BD, glyph_sokatakana },
    { 0xFF7F, glyph_sokatakanahalfwidth },
    { 0x0338, glyph_soliduslongoverlaycmb },
    { 0x0337, glyph_solidusshortoverlaycmb },
    { 0x0E29, glyph_sorusithai },
    { 0x0E28, glyph_sosalathai },
    { 0x0E0B, glyph_sosothai },
    { 0x0E2A, glyph_sosuathai },
    { 0x0020, glyph_spacehackarabic },
    { 0x2660, glyph_spadesuitblack },
    { 0x2664, glyph_spadesuitwhite },
    { 0x24AE, glyph_sparen },
    { 0x033B, glyph_squarebelowcmb },
    { 0x33C4, glyph_squarecc },
    { 0x339D, glyph_squarecm },
    { 0x25A9, glyph_squarediagonalcrosshatchfill },
    { 0x25A4, glyph_squarehorizontalfill },
    { 0x338F, glyph_squarekg },
    { 0x339E, glyph_squarekm },
    { 0x33CE, glyph_squarekmcapital },
    { 0x33D1, glyph_squareln },
    { 0x33D2, glyph_squarelog },
    { 0x338E, glyph_squaremg },
    { 0x33D5, glyph_squaremil },
    { 0x339C, glyph_squaremm },
    { 0x33A1, glyph_squaremsquared },
    { 0x25A6, glyph_squareorthogonalcrosshatchfill },
    { 0x25A7, glyph_squareupperlefttolowerrightfill },
    { 0x25A8, glyph_squareupperrighttolowerleftfill },
    { 0x25A5, glyph_squareverticalfill },
    { 0x25A3, glyph_squarewhitewithsmallblack },
    { 0x33DB, glyph_srsquare },
    { 0x09B7, glyph_ssabengali },
    { 0x0937, glyph_ssadeva },
    { 0x0AB7, glyph_ssagujarati },
    { 0x3149, glyph_ssangcieuckorean },
    { 0x3185, glyph_ssanghieuhkorean },
    { 0x3180, glyph_ssangieungkorean },
    { 0x3132, glyph_ssangkiyeokkorean },
    { 0x3165, glyph_ssangnieunkorean },
    { 0x3143, glyph_ssangpieupkorean },
    { 0x3146, glyph_ssangsioskorean },
    { 0x3138, glyph_ssangtikeutkorean },
    { 0xFFE1, glyph_sterlingmonospace },
    { 0x0336, glyph_strokelongoverlaycmb },
    { 0x0335, glyph_strokeshortoverlaycmb },
    { 0x2282, glyph_subset },
    { 0x228A, glyph_subsetnotequal },
    { 0x2286, glyph_subsetorequal },
    { 0x227B, glyph_succeeds },
    { 0x3059, glyph_suhiragana },
    { 0x30B9, glyph_sukatakana },
    { 0xFF7D, glyph_sukatakanahalfwidth },
    { 0x0652, glyph_sukunarabic },
    { 0x2283, glyph_superset },
    { 0x228B, glyph_supersetnotequal },
    { 0x2287, glyph_supersetorequal },
    { 0x33DC, glyph_svsquare },
    { 0x337C, glyph_syouwaerasquare },
    { 0x09A4, glyph_tabengali },
    { 0x22A4, glyph_tackdown },
    { 0x22A3, glyph_tackleft },
    { 0x0924, glyph_tadeva },
    { 0x0AA4, glyph_tagujarati },
    { 0x0A24, glyph_tagurmukhi },
    { 0x0637, glyph_taharabic },
    { 0xFEC2, glyph_tahfinalarabic },
    { 0xFEC3, glyph_tahinitialarabic },
    { 0x305F, glyph_tahiragana },
    { 0xFEC4, glyph_tahmedialarabic },
    { 0x337D, glyph_taisyouerasquare },
    { 0x30BF, glyph_takatakana },
    { 0xFF80, glyph_takatakanahalfwidth },
    { 0x0640, glyph_tatweelarabic },
    { 0x05EA, glyph_tav },
    { 0xFB4A, glyph_tavdages },
    { 0xFB4A, glyph_tavdagesh },
    { 0xFB4A, glyph_tavdageshhebrew },
    { 0x05EA, glyph_tavhebrew },
    { 0x310A, glyph_tbopomofo },
    { 0x02A8, glyph_tccurl },
    { 0x0686, glyph_tcheharabic },
    { 0xFB7B, glyph_tchehfinalarabic },
    { 0xFB7C, glyph_tchehinitialarabic },
    { 0xFB7D, glyph_tchehmedialarabic },
    { 0xFB7C, glyph_tchehmeeminitialarabic },
    { 0xFEE4, glyph_tchehmeeminitialarabic },
    { 0x24E3, glyph_tcircle },
    { 0x1E71, glyph_tcircumflexbelow },
    { 0x1E97, glyph_tdieresis },
    { 0x1E6B, glyph_tdotaccent },
    { 0x1E6D, glyph_tdotbelow },
    { 0x0442, glyph_tecyrillic },
    { 0x04AD, glyph_tedescendercyrillic },
    { 0x062A, glyph_teharabic },
    { 0xFE96, glyph_tehfinalarabic },
    { 0xFCA2, glyph_tehhahinitialarabic },
    { 0xFC0C, glyph_tehhahisolatedarabic },
    { 0xFE97, glyph_tehinitialarabic },
    { 0x3066, glyph_tehiragana },
    { 0xFCA1, glyph_tehjeeminitialarabic },
    { 0xFC0B, glyph_tehjeemisolatedarabic },
    { 0x0629, glyph_tehmarbutaarabic },
    { 0xFE94, glyph_tehmarbutafinalarabic },
    { 0xFE98, glyph_tehmedialarabic },
    { 0xFCA4, glyph_tehmeeminitialarabic },
    { 0xFC0E, glyph_tehmeemisolatedarabic },
    { 0xFC73, glyph_tehnoonfinalarabic },
    { 0x30C6, glyph_tekatakana },
    { 0xFF83, glyph_tekatakanahalfwidth },
    { 0x2121, glyph_telephone },
    { 0x260E, glyph_telephoneblack },
    { 0x05A0, glyph_telishagedolahebrew },
    { 0x05A9, glyph_telishaqetanahebrew },
    { 0x2469, glyph_tencircle },
    { 0x3229, glyph_tenideographicparen },
    { 0x247D, glyph_tenparen },
    { 0x2491, glyph_tenperiod },
    { 0x2179, glyph_tenroman },
    { 0x02A7, glyph_tesh },
    { 0x05D8, glyph_tet },
    { 0xFB38, glyph_tetdagesh },
    { 0xFB38, glyph_tetdageshhebrew },
    { 0x05D8, glyph_tethebrew },
    { 0x04B5, glyph_tetsecyrillic },
    { 0x059B, glyph_tevirhebrew },
    { 0x059B, glyph_tevirlefthebrew },
    { 0x09A5, glyph_thabengali },
    { 0x0925, glyph_thadeva },
    { 0x0AA5, glyph_thagujarati },
    { 0x0A25, glyph_thagurmukhi },
    { 0x0630, glyph_thalarabic },
    { 0xFEAC, glyph_thalfinalarabic },
    { 0xF898, glyph_thanthakhatlowleftthai },
    { 0xF897, glyph_thanthakhatlowrightthai },
    { 0x0E4C, glyph_thanthakhatthai },
    { 0xF896, glyph_thanthakhatupperleftthai },
    { 0x062B, glyph_theharabic },
    { 0xFE9A, glyph_thehfinalarabic },
    { 0xFE9B, glyph_thehinitialarabic },
    { 0xFE9C, glyph_thehmedialarabic },
    { 0x2203, glyph_thereexists },
    { 0x03D1, glyph_thetasymbolgreek },
    { 0x3279, glyph_thieuthacirclekorean },
    { 0x3219, glyph_thieuthaparenkorean },
    { 0x326B, glyph_thieuthcirclekorean },
    { 0x314C, glyph_thieuthkorean },
    { 0x320B, glyph_thieuthparenkorean },
    { 0x246C, glyph_thirteencircle },
    { 0x2480, glyph_thirteenparen },
    { 0x2494, glyph_thirteenperiod },
    { 0x0E11, glyph_thonangmonthothai },
    { 0x01AD, glyph_thook },
    { 0x0E12, glyph_thophuthaothai },
    { 0x0E17, glyph_thothahanthai },
    { 0x0E10, glyph_thothanthai },
    { 0x0E18, glyph_thothongthai },
    { 0x0E16, glyph_thothungthai },
    { 0x0482, glyph_thousandcyrillic },
    { 0x066C, glyph_thousandsseparatorarabic },
    { 0x066C, glyph_thousandsseparatorpersian },
    { 0x0663, glyph_threearabic },
    { 0x09E9, glyph_threebengali },
    { 0x2462, glyph_threecircle },
    { 0x278C, glyph_threecircleinversesansserif },
    { 0x0969, glyph_threedeva },
    { 0x0AE9, glyph_threegujarati },
    { 0x0A69, glyph_threegurmukhi },
    { 0x0663, glyph_threehackarabic },
    { 0x3023, glyph_threehangzhou },
    { 0x3222, glyph_threeideographicparen },
    { 0xFF13, glyph_threemonospace },
    { 0x09F6, glyph_threenumeratorbengali },
    { 0x2476, glyph_threeparen },
    { 0x248A, glyph_threeperiod },
    { 0x06F3, glyph_threepersian },
    { 0x2172, glyph_threeroman },
    { 0x0E53, glyph_threethai },
    { 0x3394, glyph_thzsquare },
    { 0x3061, glyph_tihiragana },
    { 0x30C1, glyph_tikatakana },
    { 0xFF81, glyph_tikatakanahalfwidth },
    { 0x3270, glyph_tikeutacirclekorean },
    { 0x3210, glyph_tikeutaparenkorean },
    { 0x3262, glyph_tikeutcirclekorean },
    { 0x3137, glyph_tikeutkorean },
    { 0x3202, glyph_tikeutparenkorean },
    { 0x0330, glyph_tildebelowcmb },
    { 0x0303, glyph_tildecmb },
    { 0x0360, glyph_tildedoublecmb },
    { 0x223C, glyph_tildeoperator },
    { 0x0334, glyph_tildeoverlaycmb },
    { 0x033E, glyph_tildeverticalcmb },
    { 0x2297, glyph_timescircle },
    { 0x0596, glyph_tipehahebrew },
    { 0x0596, glyph_tipehalefthebrew },
    { 0x0A70, glyph_tippigurmukhi },
    { 0x0483, glyph_titlocyrilliccmb },
    { 0x057F, glyph_tiwnarmenian },
    { 0x1E6F, glyph_tlinebelow },
    { 0xFF54, glyph_tmonospace },
    { 0x0569, glyph_toarmenian },
    { 0x3068, glyph_tohiragana },
    { 0x30C8, glyph_tokatakana },
    { 0xFF84, glyph_tokatakanahalfwidth },
    { 0x02E5, glyph_tonebarextrahighmod },
    { 0x02E9, glyph_tonebarextralowmod },
    { 0x02E6, glyph_tonebarhighmod },
    { 0x02E8, glyph_tonebarlowmod },
    { 0x02E7, glyph_tonebarmidmod },
    { 0x01BD, glyph_tonefive },
    { 0x0185, glyph_tonesix },
    { 0x01A8, glyph_tonetwo },
    { 0x3327, glyph_tonsquare },
    { 0x0E0F, glyph_topatakthai },
    { 0x3014, glyph_tortoiseshellbracketleft },
    { 0xFE5D, glyph_tortoiseshellbracketleftsmall },
    { 0xFE39, glyph_tortoiseshellbracketleftvertical },
    { 0x3015, glyph_tortoiseshellbracketright },
    { 0xFE5E, glyph_tortoiseshellbracketrightsmall },
    { 0xFE3A, glyph_tortoiseshellbracketrightvertical },
    { 0x0E15, glyph_totaothai },
    { 0x01AB, glyph_tpalatalhook },
    { 0x24AF, glyph_tparen },
    { 0x0288, glyph_tretroflexhook },
    { 0x02A6, glyph_ts },
    { 0x05E6, glyph_tsadi },
    { 0xFB46, glyph_tsadidagesh },
    { 0xFB46, glyph_tsadidageshhebrew },
    { 0x05E6, glyph_tsadihebrew },
    { 0x0446, glyph_tsecyrillic },
    { 0x05B5, glyph_tsere },
    { 0x05B5, glyph_tsere12 },
    { 0x05B5, glyph_tsere1e },
    { 0x05B5, glyph_tsere2b },
    { 0x05B5, glyph_tserehebrew },
    { 0x05B5, glyph_tserenarrowhebrew },
    { 0x05B5, glyph_tserequarterhebrew },
    { 0x05B5, glyph_tserewidehebrew },
    { 0x045B, glyph_tshecyrillic },
    { 0x099F, glyph_ttabengali },
    { 0x091F, glyph_ttadeva },
    { 0x0A9F, glyph_ttagujarati },
    { 0x0A1F, glyph_ttagurmukhi },
    { 0x0679, glyph_tteharabic },
    { 0xFB67, glyph_ttehfinalarabic },
    { 0xFB68, glyph_ttehinitialarabic },
    { 0xFB69, glyph_ttehmedialarabic },
    { 0x09A0, glyph_tthabengali },
    { 0x0920, glyph_tthadeva },
    { 0x0AA0, glyph_tthagujarati },
    { 0x0A20, glyph_tthagurmukhi },
    { 0x0287, glyph_tturned },
    { 0x3064, glyph_tuhiragana },
    { 0x30C4, glyph_tukatakana },
    { 0xFF82, glyph_tukatakanahalfwidth },
    { 0x3063, glyph_tusmallhiragana },
    { 0x30C3, glyph_tusmallkatakana },
    { 0xFF6F, glyph_tusmallkatakanahalfwidth },
    { 0x246B, glyph_twelvecircle },
    { 0x247F, glyph_twelveparen },
    { 0x2493, glyph_twelveperiod },
    { 0x217B, glyph_twelveroman },
    { 0x2473, glyph_twentycircle },
    { 0x5344, glyph_twentyhangzhou },
    { 0x2487, glyph_twentyparen },
    { 0x249B, glyph_twentyperiod },
    { 0x0662, glyph_twoarabic },
    { 0x09E8, glyph_twobengali },
    { 0x2461, glyph_twocircle },
    { 0x278B, glyph_twocircleinversesansserif },
    { 0x0968, glyph_twodeva },
    { 0x2025, glyph_twodotleader },
    { 0xFE30, glyph_twodotleadervertical },
    { 0x0AE8, glyph_twogujarati },
    { 0x0A68, glyph_twogurmukhi },
    { 0x0662, glyph_twohackarabic },
    { 0x3022, glyph_twohangzhou },
    { 0x3221, glyph_twoideographicparen },
    { 0xFF12, glyph_twomonospace },
    { 0x09F5, glyph_twonumeratorbengali },
    { 0x2475, glyph_twoparen },
    { 0x2489, glyph_twoperiod },
    { 0x06F2, glyph_twopersian },
    { 0x2171, glyph_tworoman },
    { 0x01BB, glyph_twostroke },
    { 0x0E52, glyph_twothai },
    { 0x0289, glyph_ubar },
    { 0x0989, glyph_ubengali },
    { 0x3128, glyph_ubopomofo },
    { 0x01D4, glyph_ucaron },
    { 0x24E4, glyph_ucircle },
    { 0x1E77, glyph_ucircumflexbelow },
    { 0x0443, glyph_ucyrillic },
    { 0x0951, glyph_udattadeva },
    { 0x0171, glyph_udblacute },
    { 0x0215, glyph_udblgrave },
    { 0x0909, glyph_udeva },
    { 0x01D8, glyph_udieresisacute },
    { 0x1E73, glyph_udieresisbelow },
    { 0x01DA, glyph_udieresiscaron },
    { 0x04F1, glyph_udieresiscyrillic },
    { 0x01DC, glyph_udieresisgrave },
    { 0x01D6, glyph_udieresismacron },
    { 0x1EE5, glyph_udotbelow },
    { 0x0A89, glyph_ugujarati },
    { 0x0A09, glyph_ugurmukhi },
    { 0x3046, glyph_uhiragana },
    { 0x1EE7, glyph_uhookabove },
    { 0x1EE9, glyph_uhornacute },
    { 0x1EF1, glyph_uhorndotbelow },
    { 0x1EEB, glyph_uhorngrave },
    { 0x1EED, glyph_uhornhookabove },
    { 0x1EEF, glyph_uhorntilde },
    { 0x04F3, glyph_uhungarumlautcyrillic },
    { 0x0217, glyph_uinvertedbreve },
    { 0x30A6, glyph_ukatakana },
    { 0xFF73, glyph_ukatakanahalfwidth },
    { 0x0479, glyph_ukcyrillic },
    { 0x315C, glyph_ukorean },
    { 0x04EF, glyph_umacroncyrillic },
    { 0x1E7B, glyph_umacrondieresis },
    { 0x0A41, glyph_umatragurmukhi },
    { 0xFF55, glyph_umonospace },
    { 0xFF3F, glyph_underscoremonospace },
    { 0xFE33, glyph_underscorevertical },
    { 0xFE4F, glyph_underscorewavy },
    { 0x24B0, glyph_uparen },
    { 0x05C4, glyph_upperdothebrew },
    { 0x028A, glyph_upsilonlatin },
    { 0x031D, glyph_uptackbelowcmb },
    { 0x02D4, glyph_uptackmod },
    { 0x0A73, glyph_uragurmukhi },
    { 0x045E, glyph_ushortcyrillic },
    { 0x3045, glyph_usmallhiragana },
    { 0x30A5, glyph_usmallkatakana },
    { 0xFF69, glyph_usmallkatakanahalfwidth },
    { 0x04AF, glyph_ustraightcyrillic },
    { 0x04B1, glyph_ustraightstrokecyrillic },
    { 0x1E79, glyph_utildeacute },
    { 0x1E75, glyph_utildebelow },
    { 0x098A, glyph_uubengali },
    { 0x090A, glyph_uudeva },
    { 0x0A8A, glyph_uugujarati },
    { 0x0A0A, glyph_uugurmukhi },
    { 0x0A42, glyph_uumatragurmukhi },
    { 0x09C2, glyph_uuvowelsignbengali },
    { 0x0942, glyph_uuvowelsigndeva },
    { 0x0AC2, glyph_uuvowelsigngujarati },
    { 0x09C1, glyph_uvowelsignbengali },
    { 0x0941, glyph_uvowelsigndeva },
    { 0x0AC1, glyph_uvowelsigngujarati },
    { 0x0935, glyph_vadeva },
    { 0x0AB5, glyph_vagujarati },
    { 0x0A35, glyph_vagurmukhi },
    { 0x30F7, glyph_vakatakana },
    { 0x05D5, glyph_vav },
    { 0xFB35, glyph_vavdagesh },
    { 0xFB35, glyph_vavdagesh65 },
    { 0xFB35, glyph_vavdageshhebrew },
    { 0x05D5, glyph_vavhebrew },
    { 0xFB4B, glyph_vavholam },
    { 0xFB4B, glyph_vavholamhebrew },
    { 0x05F0, glyph_vavvavhebrew },
    { 0x05F1, glyph_vavyodhebrew },
    { 0x24E5, glyph_vcircle },
    { 0x1E7F, glyph_vdotbelow },
    { 0x0432, glyph_vecyrillic },
    { 0x06A4, glyph_veharabic },
    { 0xFB6B, glyph_vehfinalarabic },
    { 0xFB6C, glyph_vehinitialarabic },
    { 0xFB6D, glyph_vehmedialarabic },
    { 0x30F9, glyph_vekatakana },
    { 0x2640, glyph_venus },
    { 0x007C, glyph_verticalbar },
    { 0x030D, glyph_verticallineabovecmb },
    { 0x0329, glyph_verticallinebelowcmb },
    { 0x02CC, glyph_verticallinelowmod },
    { 0x02C8, glyph_verticallinemod },
    { 0x057E, glyph_vewarmenian },
    { 0x028B, glyph_vhook },
    { 0x30F8, glyph_vikatakana },
    { 0x09CD, glyph_viramabengali },
    { 0x094D, glyph_viramadeva },
    { 0x0ACD, glyph_viramagujarati },
    { 0x0983, glyph_visargabengali },
    { 0x0903, glyph_visargadeva },
    { 0x0A83, glyph_visargagujarati },
    { 0xFF56, glyph_vmonospace },
    { 0x0578, glyph_voarmenian },
    { 0x309E, glyph_voicediterationhiragana },
    { 0x30FE, glyph_voicediterationkatakana },
    { 0x309B, glyph_voicedmarkkana },
    { 0xFF9E, glyph_voicedmarkkanahalfwidth },
    { 0x30FA, glyph_vokatakana },
    { 0x24B1, glyph_vparen },
    { 0x1E7D, glyph_vtilde },
    { 0x028C, glyph_vturned },
    { 0x3094, glyph_vuhiragana },
    { 0x30F4, glyph_vukatakana },
    { 0x3159, glyph_waekorean },
    { 0x308F, glyph_wahiragana },
    { 0x30EF, glyph_wakatakana },
    { 0xFF9C, glyph_wakatakanahalfwidth },
    { 0x3158, glyph_wakorean },
    { 0x308E, glyph_wasmallhiragana },
    { 0x30EE, glyph_wasmallkatakana },
    { 0x3357, glyph_wattosquare },
    { 0x301C, glyph_wavedash },
    { 0xFE34, glyph_wavyunderscorevertical },
    { 0x0648, glyph_wawarabic },
    { 0xFEEE, glyph_wawfinalarabic },
    { 0x0624, glyph_wawhamzaabovearabic },
    { 0xFE86, glyph_wawhamzaabovefinalarabic },
    { 0x33DD, glyph_wbsquare },
    { 0x24E6, glyph_wcircle },
    { 0x1E87, glyph_wdotaccent },
    { 0x1E89, glyph_wdotbelow },
    { 0x3091, glyph_wehiragana },
    { 0x30F1, glyph_wekatakana },
    { 0x315E, glyph_wekorean },
    { 0x315D, glyph_weokorean },
    { 0x25E6, glyph_whitebullet },
    { 0x25CB, glyph_whitecircle },
    { 0x25D9, glyph_whitecircleinverse },
    { 0x300E, glyph_whitecornerbracketleft },
    { 0xFE43, glyph_whitecornerbracketleftvertical },
    { 0x300F, glyph_whitecornerbracketright },
    { 0xFE44, glyph_whitecornerbracketrightvertical },
    { 0x25C7, glyph_whitediamond },
    { 0x25C8, glyph_whitediamondcontainingblacksmalldiamond },
    { 0x25BF, glyph_whitedownpointingsmalltriangle },
    { 0x25BD, glyph_whitedownpointingtriangle },
    { 0x25C3, glyph_whiteleftpointingsmalltriangle },
    { 0x25C1, glyph_whiteleftpointingtriangle },
    { 0x3016, glyph_whitelenticularbracketleft },
    { 0x3017, glyph_whitelenticularbracketright },
    { 0x25B9, glyph_whiterightpointingsmalltriangle },
    { 0x25B7, glyph_whiterightpointingtriangle },
    { 0x25AB, glyph_whitesmallsquare },
    { 0x263A, glyph_whitesmilingface },
    { 0x25A1, glyph_whitesquare },
    { 0x2606, glyph_whitestar },
    { 0x260F, glyph_whitetelephone },
    { 0x3018, glyph_whitetortoiseshellbracketleft },
    { 0x3019, glyph_whitetortoiseshellbracketright },
    { 0x25B5, glyph_whiteuppointingsmalltriangle },
    { 0x25B3, glyph_whiteuppointingtriangle },
    { 0x3090, glyph_wihiragana },
    { 0x30F0, glyph_wikatakana },
    { 0x315F, glyph_wikorean },
    { 0xFF57, glyph_wmonospace },
    { 0x3092, glyph_wohiragana },
    { 0x30F2, glyph_wokatakana },
    { 0xFF66, glyph_wokatakanahalfwidth },
    { 0x20A9, glyph_won },
    { 0xFFE6, glyph_wonmonospace },
    { 0x0E27, glyph_wowaenthai },
    { 0x24B2, glyph_wparen },
    { 0x1E98, glyph_wring },
    { 0x02B7, glyph_wsuperior },
    { 0x028D, glyph_wturned },
    { 0x01BF, glyph_wynn },
    { 0x033D, glyph_xabovecmb },
    { 0x3112, glyph_xbopomofo },
    { 0x24E7, glyph_xcircle },
    { 0x1E8D, glyph_xdieresis },
    { 0x1E8B, glyph_xdotaccent },
    { 0x056D, glyph_xeharmenian },
    { 0xFF58, glyph_xmonospace },
    { 0x24B3, glyph_xparen },
    { 0x02E3, glyph_xsuperior },
    { 0x334E, glyph_yaadosquare },
    { 0x09AF, glyph_yabengali },
    { 0x092F, glyph_yadeva },
    { 0x3152, glyph_yaekorean },
    { 0x0AAF, glyph_yagujarati },
    { 0x0A2F, glyph_yagurmukhi },
    { 0x3084, glyph_yahiragana },
    { 0x30E4, glyph_yakatakana },
    { 0xFF94, glyph_yakatakanahalfwidth },
    { 0x3151, glyph_yakorean },
    { 0x0E4E, glyph_yamakkanthai },
    { 0x3083, glyph_yasmallhiragana },
    { 0x30E3, glyph_yasmallkatakana },
    { 0xFF6C, glyph_yasmallkatakanahalfwidth },
    { 0x0463, glyph_yatcyrillic },
    { 0x24E8, glyph_ycircle },
    { 0x1E8F, glyph_ydotaccent },
    { 0x1EF5, glyph_ydotbelow },
    { 0x064A, glyph_yeharabic },
    { 0x06D2, glyph_yehbarreearabic },
    { 0xFBAF, glyph_yehbarreefinalarabic },
    { 0xFEF2, glyph_yehfinalarabic },
    { 0x0626, glyph_yehhamzaabovearabic },
    { 0xFE8A, glyph_yehhamzaabovefinalarabic },
    { 0xFE8B, glyph_yehhamzaaboveinitialarabic },
    { 0xFE8C, glyph_yehhamzaabovemedialarabic },
    { 0xFEF3, glyph_yehinitialarabic },
    { 0xFEF4, glyph_yehmedialarabic },
    { 0xFCDD, glyph_yehmeeminitialarabic },
    { 0xFC58, glyph_yehmeemisolatedarabic },
    { 0xFC94, glyph_yehnoonfinalarabic },
    { 0x06D1, glyph_yehthreedotsbelowarabic },
    { 0x3156, glyph_yekorean },
    { 0xFFE5, glyph_yenmonospace },
    { 0x3155, glyph_yeokorean },
    { 0x3186, glyph_yeorinhieuhkorean },
    { 0x05AA, glyph_yerahbenyomohebrew },
    { 0x05AA, glyph_yerahbenyomolefthebrew },
    { 0x044B, glyph_yericyrillic },
    { 0x04F9, glyph_yerudieresiscyrillic },
    { 0x3181, glyph_yesieungkorean },
    { 0x3183, glyph_yesieungpansioskorean },
    { 0x3182, glyph_yesieungsioskorean },
    { 0x059A, glyph_yetivhebrew },
    { 0x01B4, glyph_yhook },
    { 0x1EF7, glyph_yhookabove },
    { 0x0575, glyph_yiarmenian },
    { 0x0457, glyph_yicyrillic },
    { 0x3162, glyph_yikorean },
    { 0x262F, glyph_yinyang },
    { 0x0582, glyph_yiwnarmenian },
    { 0xFF59, glyph_ymonospace },
    { 0x05D9, glyph_yod },
    { 0xFB39, glyph_yoddagesh },
    { 0xFB39, glyph_yoddageshhebrew },
    { 0x05D9, glyph_yodhebrew },
    { 0x05F2, glyph_yodyodhebrew },
    { 0xFB1F, glyph_yodyodpatahhebrew },
    { 0x3088, glyph_yohiragana },
    { 0x3189, glyph_yoikorean },
    { 0x30E8, glyph_yokatakana },
    { 0xFF96, glyph_yokatakanahalfwidth },
    { 0x315B, glyph_yokorean },
    { 0x3087, glyph_yosmallhiragana },
    { 0x30E7, glyph_yosmallkatakana },
    { 0xFF6E, glyph_yosmallkatakanahalfwidth },
    { 0x03F3, glyph_yotgreek },
    { 0x3188, glyph_yoyaekorean },
    { 0x3187, glyph_yoyakorean },
    { 0x0E22, glyph_yoyakthai },
    { 0x0E0D, glyph_yoyingthai },
    { 0x24B4, glyph_yparen },
    { 0x037A, glyph_ypogegrammeni },
    { 0x0345, glyph_ypogegrammenigreekcmb },
    { 0x01A6, glyph_yr },
    { 0x1E99, glyph_yring },
    { 0x02B8, glyph_ysuperior },
    { 0x1EF9, glyph_ytilde },
    { 0x028E, glyph_yturned },
    { 0x3086, glyph_yuhiragana },
    { 0x318C, glyph_yuikorean },
    { 0x30E6, glyph_yukatakana },
    { 0xFF95, glyph_yukatakanahalfwidth },
    { 0x3160, glyph_yukorean },
    { 0x046B, glyph_yusbigcyrillic },
    { 0x046D, glyph_yusbigiotifiedcyrillic },
    { 0x0467, glyph_yuslittlecyrillic },
    { 0x0469, glyph_yuslittleiotifiedcyrillic },
    { 0x3085, glyph_yusmallhiragana },
    { 0x30E5, glyph_yusmallkatakana },
    { 0xFF6D, glyph_yusmallkatakanahalfwidth },
    { 0x318B, glyph_yuyekorean },
    { 0x318A, glyph_yuyeokorean },
    { 0x09DF, glyph_yyabengali },
    { 0x095F, glyph_yyadeva },
    { 0x0566, glyph_zaarmenian },
    { 0x095B, glyph_zadeva },
    { 0x0A5B, glyph_zagurmukhi },
    { 0x0638, glyph_zaharabic },
    { 0xFEC6, glyph_zahfinalarabic },
    { 0xFEC7, glyph_zahinitialarabic },
    { 0x3056, glyph_zahiragana },
    { 0xFEC8, glyph_zahmedialarabic },
    { 0x0632, glyph_zainarabic },
    { 0xFEB0, glyph_zainfinalarabic },
    { 0x30B6, glyph_zakatakana },
    { 0x0595, glyph_zaqefgadolhebrew },
    { 0x0594, glyph_zaqefqatanhebrew },
    { 0x0598, glyph_zarqahebrew },
    { 0x05D6, glyph_zayin },
    { 0xFB36, glyph_zayindagesh },
    { 0xFB36, glyph_zayindageshhebrew },
    { 0x05D6, glyph_zayinhebrew },
    { 0x3117, glyph_zbopomofo },
    { 0x24E9, glyph_zcircle },
    { 0x1E91, glyph_zcircumflex },
    { 0x0291, glyph_zcurl },
    { 0x017C, glyph_zdot },
    { 0x1E93, glyph_zdotbelow },
    { 0x0437, glyph_zecyrillic },
    { 0x0499, glyph_zedescendercyrillic },
    { 0x04DF, glyph_zedieresiscyrillic },
    { 0x305C, glyph_zehiragana },
    { 0x30BC, glyph_zekatakana },
    { 0x0660, glyph_zeroarabic },
    { 0x09E6, glyph_zerobengali },
    { 0x0966, glyph_zerodeva },
    { 0x0AE6, glyph_zerogujarati },
    { 0x0A66, glyph_zerogurmukhi },
    { 0x0660, glyph_zerohackarabic },
    { 0xFF10, glyph_zeromonospace },
    { 0x06F0, glyph_zeropersian },
    { 0x0E50, glyph_zerothai },
    { 0xFEFF, glyph_zerowidthjoiner },
    { 0x200C, glyph_zerowidthnonjoiner },
    { 0x200B, glyph_zerowidthspace },
    { 0x3113, glyph_zhbopomofo },
    { 0x056A, glyph_zhearmenian },
    { 0x04C2, glyph_zhebrevecyrillic },
    { 0x0436, glyph_zhecyrillic },
    { 0x0497, glyph_zhedescendercyrillic },
    { 0x04DD, glyph_zhedieresiscyrillic },
    { 0x3058, glyph_zihiragana },
    { 0x30B8, glyph_zikatakana },
    { 0x05AE, glyph_zinorhebrew },
    { 0x1E95, glyph_zlinebelow },
    { 0xFF5A, glyph_zmonospace },
    { 0x305E, glyph_zohiragana },
    { 0x30BE, glyph_zokatakana },
    { 0x24B5, glyph_zparen },
    { 0x0290, glyph_zretroflexhook },
    { 0x01B6, glyph_zstroke },
    { 0x305A, glyph_zuhiragana },
    { 0x30BA, glyph_zukatakana },
#else
#endif
}; /* tab_diffagl2uni */

/*
 * Difference table of AGL version 2.0 - 1.2'  -  sorted by Unicode values
 *
 * Without Unicode values which map to multiple glyph names or which is
 * contained in a Unicode sequence mapping to a single glyph name.
 * This means, that all n:m entries are ignored!
 *
 * The multiple named Unicode values are listed in an extra table below.
 *
 */
static const pdc_glyph_tab tab_uni2diffagl[] =
{
    { 0x0001, glyph_controlSTX },
    { 0x0002, glyph_controlSOT },
    { 0x0003, glyph_controlETX },
    { 0x0004, glyph_controlEOT },
    { 0x0005, glyph_controlENQ },
    { 0x0006, glyph_controlACK },
    { 0x0007, glyph_controlBEL },
    { 0x0008, glyph_controlBS },
    { 0x0009, glyph_controlHT },
    { 0x000A, glyph_controlLF },
    { 0x000B, glyph_controlVT },
    { 0x000C, glyph_controlFF },
    { 0x000D, glyph_controlCR },
    { 0x000E, glyph_controlSO },
    { 0x000F, glyph_controlSI },
    { 0x0010, glyph_controlDLE },
    { 0x0011, glyph_controlDC1 },
    { 0x0012, glyph_controlDC2 },
    { 0x0013, glyph_controlDC3 },
    { 0x0014, glyph_controlDC4 },
    { 0x0015, glyph_controlNAK },
    { 0x0016, glyph_controlSYN },
    { 0x0017, glyph_controlETB },
    { 0x0018, glyph_controlCAN },
    { 0x0019, glyph_controlEM },
    { 0x001A, glyph_controlSUB },
    { 0x001B, glyph_controlESC },
    { 0x001C, glyph_controlFS },
    { 0x001D, glyph_controlGS },
    { 0x001E, glyph_controlRS },
    { 0x001F, glyph_controlUS },
    { 0x0020, glyph_spacehackarabic },
    { 0x007C, glyph_verticalbar },
    { 0x007F, glyph_controlDEL },
    { 0x00A0, glyph_nonbreakingspace },
    { 0x00AD, glyph_softhyphen },
    { 0x00AF, glyph_overscore },
    { 0x00B5, glyph_mu1 },
    { 0x00B7, glyph_middot },
    { 0x010A, glyph_Cdot },
    { 0x010B, glyph_cdot },
    { 0x0110, glyph_Dslash },
    { 0x0111, glyph_dmacron },
    { 0x0116, glyph_Edot },
    { 0x0117, glyph_edot },
    { 0x0120, glyph_Gdot },
    { 0x0121, glyph_gdot },
    { 0x0122, glyph_Gcedilla },
    { 0x0123, glyph_gcedilla },
    { 0x0130, glyph_Idot },
    { 0x0136, glyph_Kcedilla },
    { 0x0137, glyph_kcedilla },
    { 0x013B, glyph_Lcedilla },
    { 0x013C, glyph_lcedilla },
    { 0x013F, glyph_Ldotaccent },
    { 0x0140, glyph_ldotaccent },
    { 0x0145, glyph_Ncedilla },
    { 0x0146, glyph_ncedilla },
    { 0x0149, glyph_quoterightn },
    { 0x0150, glyph_Odblacute },
    { 0x0151, glyph_odblacute },
    { 0x0156, glyph_Rcedilla },
    { 0x0157, glyph_rcedilla },
    { 0x0162, glyph_Tcedilla },
    { 0x0163, glyph_tcedilla },
    { 0x0170, glyph_Udblacute },
    { 0x0171, glyph_udblacute },
    { 0x017B, glyph_Zdot },
    { 0x017C, glyph_zdot },
    { 0x017F, glyph_slong },
    { 0x0180, glyph_bstroke },
    { 0x0181, glyph_Bhook },
    { 0x0182, glyph_Btopbar },
    { 0x0183, glyph_btopbar },
    { 0x0184, glyph_Tonesix },
    { 0x0185, glyph_tonesix },
    { 0x0186, glyph_Oopen },
    { 0x0187, glyph_Chook },
    { 0x0188, glyph_chook },
    { 0x0189, glyph_Dafrican },
    { 0x018A, glyph_Dhook },
    { 0x018B, glyph_Dtopbar },
    { 0x018C, glyph_dtopbar },
    { 0x018D, glyph_deltaturned },
    { 0x018E, glyph_Ereversed },
    { 0x018F, glyph_Schwa },
    { 0x0190, glyph_Eopen },
    { 0x0191, glyph_Fhook },
    { 0x0193, glyph_Ghook },
    { 0x0194, glyph_Gammaafrican },
    { 0x0195, glyph_hv },
    { 0x0196, glyph_Iotaafrican },
    { 0x0197, glyph_Istroke },
    { 0x0198, glyph_Khook },
    { 0x0199, glyph_khook },
    { 0x019A, glyph_lbar },
    { 0x019B, glyph_lambdastroke },
    { 0x019C, glyph_Mturned },
    { 0x019D, glyph_Nhookleft },
    { 0x019E, glyph_nlegrightlong },
    { 0x019F, glyph_Ocenteredtilde },
    { 0x01A2, glyph_Oi },
    { 0x01A3, glyph_oi },
    { 0x01A4, glyph_Phook },
    { 0x01A5, glyph_phook },
    { 0x01A6, glyph_yr },
    { 0x01A7, glyph_Tonetwo },
    { 0x01A8, glyph_tonetwo },
    { 0x01A9, glyph_Esh },
    { 0x01AA, glyph_eshreversedloop },
    { 0x01AB, glyph_tpalatalhook },
    { 0x01AC, glyph_Thook },
    { 0x01AD, glyph_thook },
    { 0x01AE, glyph_Tretroflexhook },
    { 0x01B1, glyph_Upsilonafrican },
    { 0x01B2, glyph_Vhook },
    { 0x01B3, glyph_Yhook },
    { 0x01B4, glyph_yhook },
    { 0x01B5, glyph_Zstroke },
    { 0x01B6, glyph_zstroke },
    { 0x01B7, glyph_Ezh },
    { 0x01B8, glyph_Ezhreversed },
    { 0x01B9, glyph_ezhreversed },
    { 0x01BA, glyph_ezhtail },
    { 0x01BB, glyph_twostroke },
    { 0x01BC, glyph_Tonefive },
    { 0x01BD, glyph_tonefive },
    { 0x01BE, glyph_glottalinvertedstroke },
    { 0x01BF, glyph_wynn },
    { 0x01C0, glyph_clickdental },
    { 0x01C1, glyph_clicklateral },
    { 0x01C2, glyph_clickalveolar },
    { 0x01C3, glyph_clickretroflex },
    { 0x01C4, glyph_DZcaron },
    { 0x01C5, glyph_Dzcaron },
    { 0x01C6, glyph_dzcaron },
    { 0x01C7, glyph_LJ },
    { 0x01C8, glyph_Lj },
    { 0x01C9, glyph_lj },
    { 0x01CA, glyph_NJ },
    { 0x01CB, glyph_Nj },
    { 0x01CC, glyph_nj },
    { 0x01CD, glyph_Acaron },
    { 0x01CE, glyph_acaron },
    { 0x01CF, glyph_Icaron },
    { 0x01D0, glyph_icaron },
    { 0x01D1, glyph_Ocaron },
    { 0x01D2, glyph_ocaron },
    { 0x01D3, glyph_Ucaron },
    { 0x01D4, glyph_ucaron },
    { 0x01D5, glyph_Udieresismacron },
    { 0x01D6, glyph_udieresismacron },
    { 0x01D7, glyph_Udieresisacute },
    { 0x01D8, glyph_udieresisacute },
    { 0x01D9, glyph_Udieresiscaron },
    { 0x01DA, glyph_udieresiscaron },
    { 0x01DB, glyph_Udieresisgrave },
    { 0x01DC, glyph_udieresisgrave },
    { 0x01DD, glyph_eturned },
    { 0x01DE, glyph_Adieresismacron },
    { 0x01DF, glyph_adieresismacron },
    { 0x01E0, glyph_Adotmacron },
    { 0x01E1, glyph_adotmacron },
    { 0x01E2, glyph_AEmacron },
    { 0x01E3, glyph_aemacron },
    { 0x01E4, glyph_Gstroke },
    { 0x01E5, glyph_gstroke },
    { 0x01E8, glyph_Kcaron },
    { 0x01E9, glyph_kcaron },
    { 0x01EA, glyph_Oogonek },
    { 0x01EB, glyph_oogonek },
    { 0x01EC, glyph_Oogonekmacron },
    { 0x01ED, glyph_oogonekmacron },
    { 0x01EE, glyph_Ezhcaron },
    { 0x01EF, glyph_ezhcaron },
    { 0x01F0, glyph_jcaron },
    { 0x01F1, glyph_DZ },
    { 0x01F2, glyph_Dz },
    { 0x01F3, glyph_dz },
    { 0x01F4, glyph_Gacute },
    { 0x01F5, glyph_gacute },
    { 0x01FE, glyph_Ostrokeacute },
    { 0x01FF, glyph_ostrokeacute },
    { 0x0200, glyph_Adblgrave },
    { 0x0201, glyph_adblgrave },
    { 0x0202, glyph_Ainvertedbreve },
    { 0x0203, glyph_ainvertedbreve },
    { 0x0204, glyph_Edblgrave },
    { 0x0205, glyph_edblgrave },
    { 0x0206, glyph_Einvertedbreve },
    { 0x0207, glyph_einvertedbreve },
    { 0x0208, glyph_Idblgrave },
    { 0x0209, glyph_idblgrave },
    { 0x020A, glyph_Iinvertedbreve },
    { 0x020B, glyph_iinvertedbreve },
    { 0x020C, glyph_Odblgrave },
    { 0x020D, glyph_odblgrave },
    { 0x020E, glyph_Oinvertedbreve },
    { 0x020F, glyph_oinvertedbreve },
    { 0x0210, glyph_Rdblgrave },
    { 0x0211, glyph_rdblgrave },
    { 0x0212, glyph_Rinvertedbreve },
    { 0x0213, glyph_rinvertedbreve },
    { 0x0214, glyph_Udblgrave },
    { 0x0215, glyph_udblgrave },
    { 0x0216, glyph_Uinvertedbreve },
    { 0x0217, glyph_uinvertedbreve },
    { 0x0250, glyph_aturned },
    { 0x0251, glyph_ascript },
    { 0x0252, glyph_ascriptturned },
    { 0x0253, glyph_bhook },
    { 0x0254, glyph_oopen },
    { 0x0255, glyph_ccurl },
    { 0x0256, glyph_dtail },
    { 0x0257, glyph_dhook },
    { 0x0258, glyph_ereversed },
    { 0x0259, glyph_schwa },
    { 0x025A, glyph_schwahook },
    { 0x025B, glyph_eopen },
    { 0x025C, glyph_eopenreversed },
    { 0x025D, glyph_eopenreversedhook },
    { 0x025E, glyph_eopenreversedclosed },
    { 0x025F, glyph_jdotlessstroke },
    { 0x0260, glyph_ghook },
    { 0x0261, glyph_gscript },
    { 0x0263, glyph_gammalatinsmall },
    { 0x0264, glyph_ramshorn },
    { 0x0265, glyph_hturned },
    { 0x0266, glyph_hhook },
    { 0x0267, glyph_henghook },
    { 0x0268, glyph_istroke },
    { 0x0269, glyph_iotalatin },
    { 0x026B, glyph_lmiddletilde },
    { 0x026C, glyph_lbelt },
    { 0x026D, glyph_lhookretroflex },
    { 0x026E, glyph_lezh },
    { 0x026F, glyph_mturned },
    { 0x0270, glyph_mlonglegturned },
    { 0x0271, glyph_mhook },
    { 0x0272, glyph_nhookleft },
    { 0x0273, glyph_nhookretroflex },
    { 0x0275, glyph_obarred },
    { 0x0277, glyph_omegalatinclosed },
    { 0x0278, glyph_philatin },
    { 0x0279, glyph_rturned },
    { 0x027A, glyph_rlonglegturned },
    { 0x027B, glyph_rhookturned },
    { 0x027C, glyph_rlongleg },
    { 0x027D, glyph_rhook },
    { 0x027E, glyph_rfishhook },
    { 0x027F, glyph_rfishhookreversed },
    { 0x0281, glyph_Rsmallinverted },
    { 0x0282, glyph_shook },
    { 0x0283, glyph_esh },
    { 0x0284, glyph_dotlessjstrokehook },
    { 0x0285, glyph_eshsquatreversed },
    { 0x0286, glyph_eshcurl },
    { 0x0287, glyph_tturned },
    { 0x0288, glyph_tretroflexhook },
    { 0x0289, glyph_ubar },
    { 0x028A, glyph_upsilonlatin },
    { 0x028B, glyph_vhook },
    { 0x028C, glyph_vturned },
    { 0x028D, glyph_wturned },
    { 0x028E, glyph_yturned },
    { 0x0290, glyph_zretroflexhook },
    { 0x0291, glyph_zcurl },
    { 0x0292, glyph_ezh },
    { 0x0293, glyph_ezhcurl },
    { 0x0294, glyph_glottalstop },
    { 0x0295, glyph_glottalstopreversed },
    { 0x0296, glyph_glottalstopinverted },
    { 0x0297, glyph_cstretched },
    { 0x0298, glyph_bilabialclick },
    { 0x029A, glyph_eopenclosed },
    { 0x029B, glyph_Gsmallhook },
    { 0x029D, glyph_jcrossedtail },
    { 0x029E, glyph_kturned },
    { 0x02A0, glyph_qhook },
    { 0x02A1, glyph_glottalstopstroke },
    { 0x02A2, glyph_glottalstopstrokereversed },
    { 0x02A3, glyph_dzaltone },
    { 0x02A4, glyph_dezh },
    { 0x02A5, glyph_dzcurl },
    { 0x02A6, glyph_ts },
    { 0x02A7, glyph_tesh },
    { 0x02A8, glyph_tccurl },
    { 0x02B0, glyph_hsuperior },
    { 0x02B1, glyph_hhooksuperior },
    { 0x02B2, glyph_jsuperior },
    { 0x02B4, glyph_rturnedsuperior },
    { 0x02B5, glyph_rhookturnedsuperior },
    { 0x02B6, glyph_Rsmallinvertedsuperior },
    { 0x02B7, glyph_wsuperior },
    { 0x02B8, glyph_ysuperior },
    { 0x02B9, glyph_primemod },
    { 0x02BA, glyph_dblprimemod },
    { 0x02BB, glyph_commaturnedmod },
    { 0x02BC, glyph_apostrophemod },
    { 0x02BD, glyph_commareversedmod },
    { 0x02BE, glyph_ringhalfright },
    { 0x02BF, glyph_ringhalfleft },
    { 0x02C0, glyph_glottalstopmod },
    { 0x02C1, glyph_glottalstopreversedmod },
    { 0x02C2, glyph_arrowheadleftmod },
    { 0x02C3, glyph_arrowheadrightmod },
    { 0x02C4, glyph_arrowheadupmod },
    { 0x02C5, glyph_arrowheaddownmod },
    { 0x02C8, glyph_verticallinemod },
    { 0x02CA, glyph_secondtonechinese },
    { 0x02CB, glyph_fourthtonechinese },
    { 0x02CC, glyph_verticallinelowmod },
    { 0x02CD, glyph_macronlowmod },
    { 0x02CE, glyph_gravelowmod },
    { 0x02CF, glyph_acutelowmod },
    { 0x02D0, glyph_colontriangularmod },
    { 0x02D1, glyph_colontriangularhalfmod },
    { 0x02D2, glyph_ringhalfrightcentered },
    { 0x02D3, glyph_ringhalfleftcentered },
    { 0x02D4, glyph_uptackmod },
    { 0x02D5, glyph_downtackmod },
    { 0x02D6, glyph_plusmod },
    { 0x02D7, glyph_minusmod },
    { 0x02DC, glyph_ilde },
    { 0x02DE, glyph_rhotichookmod },
    { 0x02E0, glyph_gammasuperior },
    { 0x02E3, glyph_xsuperior },
    { 0x02E4, glyph_glottalstopreversedsuperior },
    { 0x02E5, glyph_tonebarextrahighmod },
    { 0x02E6, glyph_tonebarhighmod },
    { 0x02E7, glyph_tonebarmidmod },
    { 0x02E8, glyph_tonebarlowmod },
    { 0x02E9, glyph_tonebarextralowmod },
    { 0x0300, glyph_gravecmb },
    { 0x0301, glyph_acutecmb },
    { 0x0302, glyph_circumflexcmb },
    { 0x0303, glyph_tildecmb },
    { 0x0304, glyph_macroncmb },
    { 0x0305, glyph_overlinecmb },
    { 0x0306, glyph_brevecmb },
    { 0x0307, glyph_dotaccentcmb },
    { 0x0308, glyph_dieresiscmb },
    { 0x0309, glyph_hookcmb },
    { 0x030A, glyph_ringcmb },
    { 0x030B, glyph_hungarumlautcmb },
    { 0x030C, glyph_caroncmb },
    { 0x030D, glyph_verticallineabovecmb },
    { 0x030E, glyph_dblverticallineabovecmb },
    { 0x030F, glyph_dblgravecmb },
    { 0x0310, glyph_candrabinducmb },
    { 0x0311, glyph_breveinvertedcmb },
    { 0x0312, glyph_commaturnedabovecmb },
    { 0x0313, glyph_commaabovecmb },
    { 0x0314, glyph_commareversedabovecmb },
    { 0x0315, glyph_commaaboverightcmb },
    { 0x0316, glyph_gravebelowcmb },
    { 0x0317, glyph_acutebelowcmb },
    { 0x0318, glyph_lefttackbelowcmb },
    { 0x0319, glyph_righttackbelowcmb },
    { 0x031A, glyph_leftangleabovecmb },
    { 0x031B, glyph_horncmb },
    { 0x031C, glyph_ringhalfleftbelowcmb },
    { 0x031D, glyph_uptackbelowcmb },
    { 0x031E, glyph_downtackbelowcmb },
    { 0x031F, glyph_plusbelowcmb },
    { 0x0320, glyph_minusbelowcmb },
    { 0x0321, glyph_hookpalatalizedbelowcmb },
    { 0x0322, glyph_hookretroflexbelowcmb },
    { 0x0323, glyph_dotbelowcmb },
    { 0x0324, glyph_dieresisbelowcmb },
    { 0x0325, glyph_ringbelowcmb },
    { 0x0327, glyph_cedillacmb },
    { 0x0328, glyph_ogonekcmb },
    { 0x0329, glyph_verticallinebelowcmb },
    { 0x032A, glyph_bridgebelowcmb },
    { 0x032B, glyph_dblarchinvertedbelowcmb },
    { 0x032C, glyph_caronbelowcmb },
    { 0x032D, glyph_circumflexbelowcmb },
    { 0x032E, glyph_brevebelowcmb },
    { 0x032F, glyph_breveinvertedbelowcmb },
    { 0x0330, glyph_tildebelowcmb },
    { 0x0331, glyph_macronbelowcmb },
    { 0x0332, glyph_lowlinecmb },
    { 0x0333, glyph_dbllowlinecmb },
    { 0x0334, glyph_tildeoverlaycmb },
    { 0x0335, glyph_strokeshortoverlaycmb },
    { 0x0336, glyph_strokelongoverlaycmb },
    { 0x0337, glyph_solidusshortoverlaycmb },
    { 0x0338, glyph_soliduslongoverlaycmb },
    { 0x0339, glyph_ringhalfrightbelowcmb },
    { 0x033A, glyph_bridgeinvertedbelowcmb },
    { 0x033B, glyph_squarebelowcmb },
    { 0x033C, glyph_seagullbelowcmb },
    { 0x033D, glyph_xabovecmb },
    { 0x033E, glyph_tildeverticalcmb },
    { 0x033F, glyph_dbloverlinecmb },
    { 0x0340, glyph_gravetonecmb },
    { 0x0341, glyph_acutetonecmb },
    { 0x0342, glyph_perispomenigreekcmb },
    { 0x0343, glyph_koroniscmb },
    { 0x0344, glyph_dialytikatonoscmb },
    { 0x0345, glyph_ypogegrammenigreekcmb },
    { 0x0360, glyph_tildedoublecmb },
    { 0x0361, glyph_breveinverteddoublecmb },
    { 0x0374, glyph_numeralsigngreek },
    { 0x0375, glyph_numeralsignlowergreek },
    { 0x037A, glyph_ypogegrammeni },
    { 0x037E, glyph_questiongreek },
    { 0x0385, glyph_dialytikatonos },
    { 0x03C2, glyph_sigmafinal },
    { 0x03D0, glyph_betasymbolgreek },
    { 0x03D1, glyph_thetasymbolgreek },
    { 0x03D2, glyph_Upsilonhooksymbol },
    { 0x03D3, glyph_Upsilonacutehooksymbolgreek },
    { 0x03D4, glyph_Upsilondieresishooksymbolgreek },
    { 0x03D5, glyph_phisymbolgreek },
    { 0x03D6, glyph_pisymbolgreek },
    { 0x03DA, glyph_Stigmagreek },
    { 0x03DC, glyph_Digammagreek },
    { 0x03DE, glyph_Koppagreek },
    { 0x03E0, glyph_Sampigreek },
    { 0x03E2, glyph_Sheicoptic },
    { 0x03E3, glyph_sheicoptic },
    { 0x03E4, glyph_Feicoptic },
    { 0x03E5, glyph_feicoptic },
    { 0x03E6, glyph_Kheicoptic },
    { 0x03E7, glyph_kheicoptic },
    { 0x03E8, glyph_Horicoptic },
    { 0x03E9, glyph_horicoptic },
    { 0x03EA, glyph_Gangiacoptic },
    { 0x03EB, glyph_gangiacoptic },
    { 0x03EC, glyph_Shimacoptic },
    { 0x03ED, glyph_shimacoptic },
    { 0x03EE, glyph_Deicoptic },
    { 0x03EF, glyph_deicoptic },
    { 0x03F0, glyph_kappasymbolgreek },
    { 0x03F1, glyph_rhosymbolgreek },
    { 0x03F2, glyph_sigmalunatesymbolgreek },
    { 0x03F3, glyph_yotgreek },
    { 0x0401, glyph_Iocyrillic },
    { 0x0402, glyph_Djecyrillic },
    { 0x0403, glyph_Gjecyrillic },
    { 0x0404, glyph_Ecyrillic },
    { 0x0405, glyph_Dzecyrillic },
    { 0x0406, glyph_Icyrillic },
    { 0x0407, glyph_Yicyrillic },
    { 0x0408, glyph_Jecyrillic },
    { 0x0409, glyph_Ljecyrillic },
    { 0x040A, glyph_Njecyrillic },
    { 0x040B, glyph_Tshecyrillic },
    { 0x040C, glyph_Kjecyrillic },
    { 0x040E, glyph_Ushortcyrillic },
    { 0x040F, glyph_Dzhecyrillic },
    { 0x0410, glyph_Acyrillic },
    { 0x0411, glyph_Becyrillic },
    { 0x0412, glyph_Vecyrillic },
    { 0x0413, glyph_Gecyrillic },
    { 0x0414, glyph_Decyrillic },
    { 0x0415, glyph_Iecyrillic },
    { 0x0416, glyph_Zhecyrillic },
    { 0x0417, glyph_Zecyrillic },
    { 0x0418, glyph_Iicyrillic },
    { 0x0419, glyph_Iishortcyrillic },
    { 0x041A, glyph_Kacyrillic },
    { 0x041B, glyph_Elcyrillic },
    { 0x041C, glyph_Emcyrillic },
    { 0x041D, glyph_Encyrillic },
    { 0x041E, glyph_Ocyrillic },
    { 0x041F, glyph_Pecyrillic },
    { 0x0420, glyph_Ercyrillic },
    { 0x0421, glyph_Escyrillic },
    { 0x0422, glyph_Tecyrillic },
    { 0x0423, glyph_Ucyrillic },
    { 0x0424, glyph_Efcyrillic },
    { 0x0425, glyph_Khacyrillic },
    { 0x0426, glyph_Tsecyrillic },
    { 0x0427, glyph_Checyrillic },
    { 0x0428, glyph_Shacyrillic },
    { 0x0429, glyph_Shchacyrillic },
    { 0x042A, glyph_Hardsigncyrillic },
    { 0x042B, glyph_Yericyrillic },
    { 0x042C, glyph_Softsigncyrillic },
    { 0x042D, glyph_Ereversedcyrillic },
    { 0x042E, glyph_IUcyrillic },
    { 0x042F, glyph_IAcyrillic },
    { 0x0430, glyph_acyrillic },
    { 0x0431, glyph_becyrillic },
    { 0x0432, glyph_vecyrillic },
    { 0x0433, glyph_gecyrillic },
    { 0x0434, glyph_decyrillic },
    { 0x0435, glyph_iecyrillic },
    { 0x0436, glyph_zhecyrillic },
    { 0x0437, glyph_zecyrillic },
    { 0x0438, glyph_iicyrillic },
    { 0x0439, glyph_iishortcyrillic },
    { 0x043A, glyph_kacyrillic },
    { 0x043B, glyph_elcyrillic },
    { 0x043C, glyph_emcyrillic },
    { 0x043D, glyph_encyrillic },
    { 0x043E, glyph_ocyrillic },
    { 0x043F, glyph_pecyrillic },
    { 0x0440, glyph_ercyrillic },
    { 0x0441, glyph_escyrillic },
    { 0x0442, glyph_tecyrillic },
    { 0x0443, glyph_ucyrillic },
    { 0x0444, glyph_efcyrillic },
    { 0x0445, glyph_khacyrillic },
    { 0x0446, glyph_tsecyrillic },
    { 0x0447, glyph_checyrillic },
    { 0x0448, glyph_shacyrillic },
    { 0x0449, glyph_shchacyrillic },
    { 0x044A, glyph_hardsigncyrillic },
    { 0x044B, glyph_yericyrillic },
    { 0x044C, glyph_softsigncyrillic },
    { 0x044D, glyph_ereversedcyrillic },
    { 0x044E, glyph_iucyrillic },
    { 0x044F, glyph_iacyrillic },
    { 0x0451, glyph_iocyrillic },
    { 0x0452, glyph_djecyrillic },
    { 0x0453, glyph_gjecyrillic },
    { 0x0454, glyph_ecyrillic },
    { 0x0455, glyph_dzecyrillic },
    { 0x0456, glyph_icyrillic },
    { 0x0457, glyph_yicyrillic },
    { 0x0458, glyph_jecyrillic },
    { 0x0459, glyph_ljecyrillic },
    { 0x045A, glyph_njecyrillic },
    { 0x045B, glyph_tshecyrillic },
    { 0x045C, glyph_kjecyrillic },
    { 0x045E, glyph_ushortcyrillic },
    { 0x045F, glyph_dzhecyrillic },
    { 0x0460, glyph_Omegacyrillic },
    { 0x0461, glyph_omegacyrillic },
    { 0x0462, glyph_Yatcyrillic },
    { 0x0463, glyph_yatcyrillic },
    { 0x0464, glyph_Eiotifiedcyrillic },
    { 0x0465, glyph_eiotifiedcyrillic },
    { 0x0466, glyph_Yuslittlecyrillic },
    { 0x0467, glyph_yuslittlecyrillic },
    { 0x0468, glyph_Yuslittleiotifiedcyrillic },
    { 0x0469, glyph_yuslittleiotifiedcyrillic },
    { 0x046A, glyph_Yusbigcyrillic },
    { 0x046B, glyph_yusbigcyrillic },
    { 0x046C, glyph_Yusbigiotifiedcyrillic },
    { 0x046D, glyph_yusbigiotifiedcyrillic },
    { 0x046E, glyph_Ksicyrillic },
    { 0x046F, glyph_ksicyrillic },
    { 0x0470, glyph_Psicyrillic },
    { 0x0471, glyph_psicyrillic },
    { 0x0472, glyph_Fitacyrillic },
    { 0x0473, glyph_fitacyrillic },
    { 0x0474, glyph_Izhitsacyrillic },
    { 0x0475, glyph_izhitsacyrillic },
    { 0x0476, glyph_Izhitsadblgravecyrillic },
    { 0x0477, glyph_izhitsadblgravecyrillic },
    { 0x0478, glyph_Ukcyrillic },
    { 0x0479, glyph_ukcyrillic },
    { 0x047A, glyph_Omegaroundcyrillic },
    { 0x047B, glyph_omegaroundcyrillic },
    { 0x047C, glyph_Omegatitlocyrillic },
    { 0x047D, glyph_omegatitlocyrillic },
    { 0x047E, glyph_Otcyrillic },
    { 0x047F, glyph_otcyrillic },
    { 0x0480, glyph_Koppacyrillic },
    { 0x0481, glyph_koppacyrillic },
    { 0x0482, glyph_thousandcyrillic },
    { 0x0483, glyph_titlocyrilliccmb },
    { 0x0484, glyph_palatalizationcyrilliccmb },
    { 0x0485, glyph_dasiapneumatacyrilliccmb },
    { 0x0486, glyph_psilipneumatacyrilliccmb },
    { 0x0490, glyph_Gheupturncyrillic },
    { 0x0491, glyph_gheupturncyrillic },
    { 0x0492, glyph_Ghestrokecyrillic },
    { 0x0493, glyph_ghestrokecyrillic },
    { 0x0494, glyph_Ghemiddlehookcyrillic },
    { 0x0495, glyph_ghemiddlehookcyrillic },
    { 0x0496, glyph_Zhedescendercyrillic },
    { 0x0497, glyph_zhedescendercyrillic },
    { 0x0498, glyph_Zedescendercyrillic },
    { 0x0499, glyph_zedescendercyrillic },
    { 0x049A, glyph_Kadescendercyrillic },
    { 0x049B, glyph_kadescendercyrillic },
    { 0x049C, glyph_Kaverticalstrokecyrillic },
    { 0x049D, glyph_kaverticalstrokecyrillic },
    { 0x049E, glyph_Kastrokecyrillic },
    { 0x049F, glyph_kastrokecyrillic },
    { 0x04A0, glyph_Kabashkircyrillic },
    { 0x04A1, glyph_kabashkircyrillic },
    { 0x04A2, glyph_Endescendercyrillic },
    { 0x04A3, glyph_endescendercyrillic },
    { 0x04A4, glyph_Enghecyrillic },
    { 0x04A5, glyph_enghecyrillic },
    { 0x04A6, glyph_Pemiddlehookcyrillic },
    { 0x04A7, glyph_pemiddlehookcyrillic },
    { 0x04A8, glyph_Haabkhasiancyrillic },
    { 0x04A9, glyph_haabkhasiancyrillic },
    { 0x04AA, glyph_Esdescendercyrillic },
    { 0x04AB, glyph_esdescendercyrillic },
    { 0x04AC, glyph_Tedescendercyrillic },
    { 0x04AD, glyph_tedescendercyrillic },
    { 0x04AE, glyph_Ustraightcyrillic },
    { 0x04AF, glyph_ustraightcyrillic },
    { 0x04B0, glyph_Ustraightstrokecyrillic },
    { 0x04B1, glyph_ustraightstrokecyrillic },
    { 0x04B2, glyph_Hadescendercyrillic },
    { 0x04B3, glyph_hadescendercyrillic },
    { 0x04B4, glyph_Tetsecyrillic },
    { 0x04B5, glyph_tetsecyrillic },
    { 0x04B6, glyph_Chedescendercyrillic },
    { 0x04B7, glyph_chedescendercyrillic },
    { 0x04B8, glyph_Cheverticalstrokecyrillic },
    { 0x04B9, glyph_cheverticalstrokecyrillic },
    { 0x04BA, glyph_Shhacyrillic },
    { 0x04BB, glyph_shhacyrillic },
    { 0x04BC, glyph_Cheabkhasiancyrillic },
    { 0x04BD, glyph_cheabkhasiancyrillic },
    { 0x04BE, glyph_Chedescenderabkhasiancyrillic },
    { 0x04BF, glyph_chedescenderabkhasiancyrillic },
    { 0x04C0, glyph_palochkacyrillic },
    { 0x04C1, glyph_Zhebrevecyrillic },
    { 0x04C2, glyph_zhebrevecyrillic },
    { 0x04C3, glyph_Kahookcyrillic },
    { 0x04C4, glyph_kahookcyrillic },
    { 0x04C7, glyph_Enhookcyrillic },
    { 0x04C8, glyph_enhookcyrillic },
    { 0x04CB, glyph_Chekhakassiancyrillic },
    { 0x04CC, glyph_chekhakassiancyrillic },
    { 0x04D0, glyph_Abrevecyrillic },
    { 0x04D1, glyph_abrevecyrillic },
    { 0x04D2, glyph_Adieresiscyrillic },
    { 0x04D3, glyph_adieresiscyrillic },
    { 0x04D4, glyph_Aiecyrillic },
    { 0x04D5, glyph_aiecyrillic },
    { 0x04D6, glyph_Iebrevecyrillic },
    { 0x04D7, glyph_iebrevecyrillic },
    { 0x04D8, glyph_Schwacyrillic },
    { 0x04D9, glyph_schwacyrillic },
    { 0x04DA, glyph_Schwadieresiscyrillic },
    { 0x04DB, glyph_schwadieresiscyrillic },
    { 0x04DC, glyph_Zhedieresiscyrillic },
    { 0x04DD, glyph_zhedieresiscyrillic },
    { 0x04DE, glyph_Zedieresiscyrillic },
    { 0x04DF, glyph_zedieresiscyrillic },
    { 0x04E0, glyph_Dzeabkhasiancyrillic },
    { 0x04E1, glyph_dzeabkhasiancyrillic },
    { 0x04E2, glyph_Imacroncyrillic },
    { 0x04E3, glyph_imacroncyrillic },
    { 0x04E4, glyph_Idieresiscyrillic },
    { 0x04E5, glyph_idieresiscyrillic },
    { 0x04E6, glyph_Odieresiscyrillic },
    { 0x04E7, glyph_odieresiscyrillic },
    { 0x04E8, glyph_Obarredcyrillic },
    { 0x04E9, glyph_obarredcyrillic },
    { 0x04EA, glyph_Obarreddieresiscyrillic },
    { 0x04EB, glyph_obarreddieresiscyrillic },
    { 0x04EE, glyph_Umacroncyrillic },
    { 0x04EF, glyph_umacroncyrillic },
    { 0x04F0, glyph_Udieresiscyrillic },
    { 0x04F1, glyph_udieresiscyrillic },
    { 0x04F2, glyph_Uhungarumlautcyrillic },
    { 0x04F3, glyph_uhungarumlautcyrillic },
    { 0x04F4, glyph_Chedieresiscyrillic },
    { 0x04F5, glyph_chedieresiscyrillic },
    { 0x04F8, glyph_Yerudieresiscyrillic },
    { 0x04F9, glyph_yerudieresiscyrillic },
    { 0x0531, glyph_Aybarmenian },
    { 0x0532, glyph_Benarmenian },
    { 0x0533, glyph_Gimarmenian },
    { 0x0534, glyph_Daarmenian },
    { 0x0535, glyph_Echarmenian },
    { 0x0536, glyph_Zaarmenian },
    { 0x0537, glyph_Eharmenian },
    { 0x0538, glyph_Etarmenian },
    { 0x0539, glyph_Toarmenian },
    { 0x053A, glyph_Zhearmenian },
    { 0x053B, glyph_Iniarmenian },
    { 0x053C, glyph_Liwnarmenian },
    { 0x053D, glyph_Xeharmenian },
    { 0x053E, glyph_Caarmenian },
    { 0x053F, glyph_Kenarmenian },
    { 0x0540, glyph_Hoarmenian },
    { 0x0541, glyph_Jaarmenian },
    { 0x0542, glyph_Ghadarmenian },
    { 0x0543, glyph_Cheharmenian },
    { 0x0544, glyph_Menarmenian },
    { 0x0545, glyph_Yiarmenian },
    { 0x0546, glyph_Nowarmenian },
    { 0x0547, glyph_Shaarmenian },
    { 0x0548, glyph_Voarmenian },
    { 0x0549, glyph_Chaarmenian },
    { 0x054A, glyph_Peharmenian },
    { 0x054B, glyph_Jheharmenian },
    { 0x054C, glyph_Raarmenian },
    { 0x054D, glyph_Seharmenian },
    { 0x054E, glyph_Vewarmenian },
    { 0x054F, glyph_Tiwnarmenian },
    { 0x0550, glyph_Reharmenian },
    { 0x0551, glyph_Coarmenian },
    { 0x0552, glyph_Yiwnarmenian },
    { 0x0553, glyph_Piwrarmenian },
    { 0x0554, glyph_Keharmenian },
    { 0x0555, glyph_Oharmenian },
    { 0x0556, glyph_Feharmenian },
    { 0x0559, glyph_ringhalfleftarmenian },
    { 0x055A, glyph_apostrophearmenian },
    { 0x055B, glyph_emphasismarkarmenian },
    { 0x055C, glyph_exclamarmenian },
    { 0x055D, glyph_commaarmenian },
    { 0x055E, glyph_questionarmenian },
    { 0x055F, glyph_abbreviationmarkarmenian },
    { 0x0561, glyph_aybarmenian },
    { 0x0562, glyph_benarmenian },
    { 0x0563, glyph_gimarmenian },
    { 0x0564, glyph_daarmenian },
    { 0x0565, glyph_echarmenian },
    { 0x0566, glyph_zaarmenian },
    { 0x0567, glyph_eharmenian },
    { 0x0568, glyph_etarmenian },
    { 0x0569, glyph_toarmenian },
    { 0x056A, glyph_zhearmenian },
    { 0x056B, glyph_iniarmenian },
    { 0x056C, glyph_liwnarmenian },
    { 0x056D, glyph_xeharmenian },
    { 0x056E, glyph_caarmenian },
    { 0x056F, glyph_kenarmenian },
    { 0x0570, glyph_hoarmenian },
    { 0x0571, glyph_jaarmenian },
    { 0x0572, glyph_ghadarmenian },
    { 0x0573, glyph_cheharmenian },
    { 0x0574, glyph_menarmenian },
    { 0x0575, glyph_yiarmenian },
    { 0x0576, glyph_nowarmenian },
    { 0x0577, glyph_shaarmenian },
    { 0x0578, glyph_voarmenian },
    { 0x0579, glyph_chaarmenian },
    { 0x057A, glyph_peharmenian },
    { 0x057B, glyph_jheharmenian },
    { 0x057C, glyph_raarmenian },
    { 0x057D, glyph_seharmenian },
    { 0x057E, glyph_vewarmenian },
    { 0x057F, glyph_tiwnarmenian },
    { 0x0580, glyph_reharmenian },
    { 0x0581, glyph_coarmenian },
    { 0x0582, glyph_yiwnarmenian },
    { 0x0583, glyph_piwrarmenian },
    { 0x0584, glyph_keharmenian },
    { 0x0585, glyph_oharmenian },
    { 0x0586, glyph_feharmenian },
    { 0x0587, glyph_echyiwnarmenian },
    { 0x0589, glyph_periodarmenian },
    { 0x0592, glyph_segoltahebrew },
    { 0x0593, glyph_shalshelethebrew },
    { 0x0594, glyph_zaqefqatanhebrew },
    { 0x0595, glyph_zaqefgadolhebrew },
    { 0x0598, glyph_zarqahebrew },
    { 0x0599, glyph_pashtahebrew },
    { 0x059A, glyph_yetivhebrew },
    { 0x059C, glyph_gereshaccenthebrew },
    { 0x059D, glyph_gereshmuqdamhebrew },
    { 0x059E, glyph_gershayimaccenthebrew },
    { 0x059F, glyph_qarneyparahebrew },
    { 0x05A0, glyph_telishagedolahebrew },
    { 0x05A1, glyph_pazerhebrew },
    { 0x05A8, glyph_qadmahebrew },
    { 0x05A9, glyph_telishaqetanahebrew },
    { 0x05AB, glyph_olehebrew },
    { 0x05AC, glyph_iluyhebrew },
    { 0x05AD, glyph_dehihebrew },
    { 0x05AE, glyph_zinorhebrew },
    { 0x05AF, glyph_masoracirclehebrew },
    { 0x05BE, glyph_maqafhebrew },
    { 0x05C0, glyph_paseqhebrew },
    { 0x05C1, glyph_shindothebrew },
    { 0x05C2, glyph_sindothebrew },
    { 0x05C3, glyph_sofpasuqhebrew },
    { 0x05C4, glyph_upperdothebrew },
    { 0x05F0, glyph_vavvavhebrew },
    { 0x05F1, glyph_vavyodhebrew },
    { 0x05F2, glyph_yodyodhebrew },
    { 0x05F3, glyph_gereshhebrew },
    { 0x05F4, glyph_gershayimhebrew },
    { 0x060C, glyph_commaarabic },
    { 0x061B, glyph_semicolonarabic },
    { 0x061F, glyph_questionarabic },
    { 0x0622, glyph_alefmaddaabovearabic },
    { 0x0623, glyph_alefhamzaabovearabic },
    { 0x0624, glyph_wawhamzaabovearabic },
    { 0x0625, glyph_alefhamzabelowarabic },
    { 0x0626, glyph_yehhamzaabovearabic },
    { 0x0627, glyph_alefarabic },
    { 0x0628, glyph_beharabic },
    { 0x0629, glyph_tehmarbutaarabic },
    { 0x062A, glyph_teharabic },
    { 0x062B, glyph_theharabic },
    { 0x062C, glyph_jeemarabic },
    { 0x062D, glyph_haharabic },
    { 0x062E, glyph_khaharabic },
    { 0x062F, glyph_dalarabic },
    { 0x0630, glyph_thalarabic },
    { 0x0631, glyph_reharabic },
    { 0x0632, glyph_zainarabic },
    { 0x0633, glyph_seenarabic },
    { 0x0634, glyph_sheenarabic },
    { 0x0635, glyph_sadarabic },
    { 0x0636, glyph_dadarabic },
    { 0x0637, glyph_taharabic },
    { 0x0638, glyph_zaharabic },
    { 0x0639, glyph_ainarabic },
    { 0x063A, glyph_ghainarabic },
    { 0x0641, glyph_feharabic },
    { 0x0642, glyph_qafarabic },
    { 0x0643, glyph_kafarabic },
    { 0x0644, glyph_lamarabic },
    { 0x0645, glyph_meemarabic },
    { 0x0646, glyph_noonarabic },
    { 0x0647, glyph_heharabic },
    { 0x0648, glyph_wawarabic },
    { 0x0649, glyph_alefmaksuraarabic },
    { 0x064A, glyph_yeharabic },
    { 0x064B, glyph_fathatanarabic },
    { 0x064D, glyph_kasratanarabic },
    { 0x0650, glyph_kasraarabic },
    { 0x0651, glyph_shaddaarabic },
    { 0x0652, glyph_sukunarabic },
    { 0x066A, glyph_percentarabic },
    { 0x0679, glyph_tteharabic },
    { 0x067E, glyph_peharabic },
    { 0x0686, glyph_tcheharabic },
    { 0x0688, glyph_ddalarabic },
    { 0x0691, glyph_rreharabic },
    { 0x0698, glyph_jeharabic },
    { 0x06A4, glyph_veharabic },
    { 0x06AF, glyph_gafarabic },
    { 0x06BA, glyph_noonghunnaarabic },
    { 0x06D1, glyph_yehthreedotsbelowarabic },
    { 0x06D2, glyph_yehbarreearabic },
    { 0x06F0, glyph_zeropersian },
    { 0x06F1, glyph_onepersian },
    { 0x06F2, glyph_twopersian },
    { 0x06F3, glyph_threepersian },
    { 0x06F4, glyph_fourpersian },
    { 0x06F5, glyph_fivepersian },
    { 0x06F6, glyph_sixpersian },
    { 0x06F7, glyph_sevenpersian },
    { 0x06F8, glyph_eightpersian },
    { 0x06F9, glyph_ninepersian },
    { 0x0901, glyph_candrabindudeva },
    { 0x0902, glyph_anusvaradeva },
    { 0x0903, glyph_visargadeva },
    { 0x0905, glyph_adeva },
    { 0x0906, glyph_aadeva },
    { 0x0907, glyph_ideva },
    { 0x0908, glyph_iideva },
    { 0x0909, glyph_udeva },
    { 0x090A, glyph_uudeva },
    { 0x090B, glyph_rvocalicdeva },
    { 0x090C, glyph_lvocalicdeva },
    { 0x090D, glyph_ecandradeva },
    { 0x090E, glyph_eshortdeva },
    { 0x090F, glyph_edeva },
    { 0x0910, glyph_aideva },
    { 0x0911, glyph_ocandradeva },
    { 0x0912, glyph_oshortdeva },
    { 0x0913, glyph_odeva },
    { 0x0914, glyph_audeva },
    { 0x0915, glyph_kadeva },
    { 0x0916, glyph_khadeva },
    { 0x0917, glyph_gadeva },
    { 0x0918, glyph_ghadeva },
    { 0x0919, glyph_ngadeva },
    { 0x091A, glyph_cadeva },
    { 0x091B, glyph_chadeva },
    { 0x091C, glyph_jadeva },
    { 0x091D, glyph_jhadeva },
    { 0x091E, glyph_nyadeva },
    { 0x091F, glyph_ttadeva },
    { 0x0920, glyph_tthadeva },
    { 0x0921, glyph_ddadeva },
    { 0x0922, glyph_ddhadeva },
    { 0x0923, glyph_nnadeva },
    { 0x0924, glyph_tadeva },
    { 0x0925, glyph_thadeva },
    { 0x0926, glyph_dadeva },
    { 0x0927, glyph_dhadeva },
    { 0x0928, glyph_nadeva },
    { 0x0929, glyph_nnnadeva },
    { 0x092A, glyph_padeva },
    { 0x092B, glyph_phadeva },
    { 0x092C, glyph_badeva },
    { 0x092D, glyph_bhadeva },
    { 0x092E, glyph_madeva },
    { 0x092F, glyph_yadeva },
    { 0x0930, glyph_radeva },
    { 0x0931, glyph_rradeva },
    { 0x0932, glyph_ladeva },
    { 0x0933, glyph_lladeva },
    { 0x0934, glyph_llladeva },
    { 0x0935, glyph_vadeva },
    { 0x0936, glyph_shadeva },
    { 0x0937, glyph_ssadeva },
    { 0x0938, glyph_sadeva },
    { 0x0939, glyph_hadeva },
    { 0x093C, glyph_nuktadeva },
    { 0x093D, glyph_avagrahadeva },
    { 0x093E, glyph_aavowelsigndeva },
    { 0x093F, glyph_ivowelsigndeva },
    { 0x0940, glyph_iivowelsigndeva },
    { 0x0941, glyph_uvowelsigndeva },
    { 0x0942, glyph_uuvowelsigndeva },
    { 0x0943, glyph_rvocalicvowelsigndeva },
    { 0x0944, glyph_rrvocalicvowelsigndeva },
    { 0x0945, glyph_ecandravowelsigndeva },
    { 0x0946, glyph_eshortvowelsigndeva },
    { 0x0947, glyph_evowelsigndeva },
    { 0x0948, glyph_aivowelsigndeva },
    { 0x0949, glyph_ocandravowelsigndeva },
    { 0x094A, glyph_oshortvowelsigndeva },
    { 0x094B, glyph_ovowelsigndeva },
    { 0x094C, glyph_auvowelsigndeva },
    { 0x094D, glyph_viramadeva },
    { 0x0950, glyph_omdeva },
    { 0x0951, glyph_udattadeva },
    { 0x0952, glyph_anudattadeva },
    { 0x0953, glyph_gravedeva },
    { 0x0954, glyph_acutedeva },
    { 0x0958, glyph_qadeva },
    { 0x0959, glyph_khhadeva },
    { 0x095A, glyph_ghhadeva },
    { 0x095B, glyph_zadeva },
    { 0x095C, glyph_dddhadeva },
    { 0x095D, glyph_rhadeva },
    { 0x095E, glyph_fadeva },
    { 0x095F, glyph_yyadeva },
    { 0x0960, glyph_rrvocalicdeva },
    { 0x0961, glyph_llvocalicdeva },
    { 0x0962, glyph_lvocalicvowelsigndeva },
    { 0x0963, glyph_llvocalicvowelsigndeva },
    { 0x0964, glyph_danda },
    { 0x0965, glyph_dbldanda },
    { 0x0966, glyph_zerodeva },
    { 0x0967, glyph_onedeva },
    { 0x0968, glyph_twodeva },
    { 0x0969, glyph_threedeva },
    { 0x096A, glyph_fourdeva },
    { 0x096B, glyph_fivedeva },
    { 0x096C, glyph_sixdeva },
    { 0x096D, glyph_sevendeva },
    { 0x096E, glyph_eightdeva },
    { 0x096F, glyph_ninedeva },
    { 0x0970, glyph_abbreviationsigndeva },
    { 0x0981, glyph_candrabindubengali },
    { 0x0982, glyph_anusvarabengali },
    { 0x0983, glyph_visargabengali },
    { 0x0985, glyph_abengali },
    { 0x0986, glyph_aabengali },
    { 0x0987, glyph_ibengali },
    { 0x0988, glyph_iibengali },
    { 0x0989, glyph_ubengali },
    { 0x098A, glyph_uubengali },
    { 0x098B, glyph_rvocalicbengali },
    { 0x098C, glyph_lvocalicbengali },
    { 0x098F, glyph_ebengali },
    { 0x0990, glyph_aibengali },
    { 0x0993, glyph_obengali },
    { 0x0994, glyph_aubengali },
    { 0x0995, glyph_kabengali },
    { 0x0996, glyph_khabengali },
    { 0x0997, glyph_gabengali },
    { 0x0998, glyph_ghabengali },
    { 0x0999, glyph_ngabengali },
    { 0x099A, glyph_cabengali },
    { 0x099B, glyph_chabengali },
    { 0x099C, glyph_jabengali },
    { 0x099D, glyph_jhabengali },
    { 0x099E, glyph_nyabengali },
    { 0x099F, glyph_ttabengali },
    { 0x09A0, glyph_tthabengali },
    { 0x09A1, glyph_ddabengali },
    { 0x09A2, glyph_ddhabengali },
    { 0x09A3, glyph_nnabengali },
    { 0x09A4, glyph_tabengali },
    { 0x09A5, glyph_thabengali },
    { 0x09A6, glyph_dabengali },
    { 0x09A7, glyph_dhabengali },
    { 0x09A8, glyph_nabengali },
    { 0x09AA, glyph_pabengali },
    { 0x09AB, glyph_phabengali },
    { 0x09AC, glyph_babengali },
    { 0x09AD, glyph_bhabengali },
    { 0x09AE, glyph_mabengali },
    { 0x09AF, glyph_yabengali },
    { 0x09B0, glyph_rabengali },
    { 0x09B2, glyph_labengali },
    { 0x09B6, glyph_shabengali },
    { 0x09B7, glyph_ssabengali },
    { 0x09B8, glyph_sabengali },
    { 0x09B9, glyph_habengali },
    { 0x09BC, glyph_nuktabengali },
    { 0x09BE, glyph_aavowelsignbengali },
    { 0x09BF, glyph_ivowelsignbengali },
    { 0x09C0, glyph_iivowelsignbengali },
    { 0x09C1, glyph_uvowelsignbengali },
    { 0x09C2, glyph_uuvowelsignbengali },
    { 0x09C3, glyph_rvocalicvowelsignbengali },
    { 0x09C4, glyph_rrvocalicvowelsignbengali },
    { 0x09C7, glyph_evowelsignbengali },
    { 0x09C8, glyph_aivowelsignbengali },
    { 0x09CB, glyph_ovowelsignbengali },
    { 0x09CC, glyph_auvowelsignbengali },
    { 0x09CD, glyph_viramabengali },
    { 0x09D7, glyph_aulengthmarkbengali },
    { 0x09DC, glyph_rrabengali },
    { 0x09DD, glyph_rhabengali },
    { 0x09DF, glyph_yyabengali },
    { 0x09E0, glyph_rrvocalicbengali },
    { 0x09E1, glyph_llvocalicbengali },
    { 0x09E2, glyph_lvocalicvowelsignbengali },
    { 0x09E3, glyph_llvocalicvowelsignbengali },
    { 0x09E6, glyph_zerobengali },
    { 0x09E7, glyph_onebengali },
    { 0x09E8, glyph_twobengali },
    { 0x09E9, glyph_threebengali },
    { 0x09EA, glyph_fourbengali },
    { 0x09EB, glyph_fivebengali },
    { 0x09EC, glyph_sixbengali },
    { 0x09ED, glyph_sevenbengali },
    { 0x09EE, glyph_eightbengali },
    { 0x09EF, glyph_ninebengali },
    { 0x09F0, glyph_ramiddlediagonalbengali },
    { 0x09F1, glyph_ralowerdiagonalbengali },
    { 0x09F2, glyph_rupeemarkbengali },
    { 0x09F3, glyph_rupeesignbengali },
    { 0x09F4, glyph_onenumeratorbengali },
    { 0x09F5, glyph_twonumeratorbengali },
    { 0x09F6, glyph_threenumeratorbengali },
    { 0x09F7, glyph_fournumeratorbengali },
    { 0x09F8, glyph_denominatorminusonenumeratorbengali },
    { 0x09F9, glyph_sixteencurrencydenominatorbengali },
    { 0x09FA, glyph_issharbengali },
    { 0x0A02, glyph_bindigurmukhi },
    { 0x0A05, glyph_agurmukhi },
    { 0x0A06, glyph_aagurmukhi },
    { 0x0A07, glyph_igurmukhi },
    { 0x0A08, glyph_iigurmukhi },
    { 0x0A09, glyph_ugurmukhi },
    { 0x0A0A, glyph_uugurmukhi },
    { 0x0A0F, glyph_eegurmukhi },
    { 0x0A10, glyph_aigurmukhi },
    { 0x0A13, glyph_oogurmukhi },
    { 0x0A14, glyph_augurmukhi },
    { 0x0A15, glyph_kagurmukhi },
    { 0x0A16, glyph_khagurmukhi },
    { 0x0A17, glyph_gagurmukhi },
    { 0x0A18, glyph_ghagurmukhi },
    { 0x0A19, glyph_ngagurmukhi },
    { 0x0A1A, glyph_cagurmukhi },
    { 0x0A1B, glyph_chagurmukhi },
    { 0x0A1C, glyph_jagurmukhi },
    { 0x0A1D, glyph_jhagurmukhi },
    { 0x0A1E, glyph_nyagurmukhi },
    { 0x0A1F, glyph_ttagurmukhi },
    { 0x0A20, glyph_tthagurmukhi },
    { 0x0A21, glyph_ddagurmukhi },
    { 0x0A22, glyph_ddhagurmukhi },
    { 0x0A23, glyph_nnagurmukhi },
    { 0x0A24, glyph_tagurmukhi },
    { 0x0A25, glyph_thagurmukhi },
    { 0x0A26, glyph_dagurmukhi },
    { 0x0A27, glyph_dhagurmukhi },
    { 0x0A28, glyph_nagurmukhi },
    { 0x0A2A, glyph_pagurmukhi },
    { 0x0A2B, glyph_phagurmukhi },
    { 0x0A2C, glyph_bagurmukhi },
    { 0x0A2D, glyph_bhagurmukhi },
    { 0x0A2E, glyph_magurmukhi },
    { 0x0A2F, glyph_yagurmukhi },
    { 0x0A30, glyph_ragurmukhi },
    { 0x0A32, glyph_lagurmukhi },
    { 0x0A35, glyph_vagurmukhi },
    { 0x0A36, glyph_shagurmukhi },
    { 0x0A38, glyph_sagurmukhi },
    { 0x0A39, glyph_hagurmukhi },
    { 0x0A3C, glyph_nuktagurmukhi },
    { 0x0A3E, glyph_aamatragurmukhi },
    { 0x0A3F, glyph_imatragurmukhi },
    { 0x0A40, glyph_iimatragurmukhi },
    { 0x0A41, glyph_umatragurmukhi },
    { 0x0A42, glyph_uumatragurmukhi },
    { 0x0A47, glyph_eematragurmukhi },
    { 0x0A48, glyph_aimatragurmukhi },
    { 0x0A4B, glyph_oomatragurmukhi },
    { 0x0A4C, glyph_aumatragurmukhi },
    { 0x0A4D, glyph_halantgurmukhi },
    { 0x0A59, glyph_khhagurmukhi },
    { 0x0A5A, glyph_ghhagurmukhi },
    { 0x0A5B, glyph_zagurmukhi },
    { 0x0A5C, glyph_rragurmukhi },
    { 0x0A5E, glyph_fagurmukhi },
    { 0x0A66, glyph_zerogurmukhi },
    { 0x0A67, glyph_onegurmukhi },
    { 0x0A68, glyph_twogurmukhi },
    { 0x0A69, glyph_threegurmukhi },
    { 0x0A6A, glyph_fourgurmukhi },
    { 0x0A6B, glyph_fivegurmukhi },
    { 0x0A6C, glyph_sixgurmukhi },
    { 0x0A6D, glyph_sevengurmukhi },
    { 0x0A6E, glyph_eightgurmukhi },
    { 0x0A6F, glyph_ninegurmukhi },
    { 0x0A70, glyph_tippigurmukhi },
    { 0x0A71, glyph_addakgurmukhi },
    { 0x0A72, glyph_irigurmukhi },
    { 0x0A73, glyph_uragurmukhi },
    { 0x0A74, glyph_ekonkargurmukhi },
    { 0x0A81, glyph_candrabindugujarati },
    { 0x0A82, glyph_anusvaragujarati },
    { 0x0A83, glyph_visargagujarati },
    { 0x0A85, glyph_agujarati },
    { 0x0A86, glyph_aagujarati },
    { 0x0A87, glyph_igujarati },
    { 0x0A88, glyph_iigujarati },
    { 0x0A89, glyph_ugujarati },
    { 0x0A8A, glyph_uugujarati },
    { 0x0A8B, glyph_rvocalicgujarati },
    { 0x0A8D, glyph_ecandragujarati },
    { 0x0A8F, glyph_egujarati },
    { 0x0A90, glyph_aigujarati },
    { 0x0A91, glyph_ocandragujarati },
    { 0x0A93, glyph_ogujarati },
    { 0x0A94, glyph_augujarati },
    { 0x0A95, glyph_kagujarati },
    { 0x0A96, glyph_khagujarati },
    { 0x0A97, glyph_gagujarati },
    { 0x0A98, glyph_ghagujarati },
    { 0x0A99, glyph_ngagujarati },
    { 0x0A9A, glyph_cagujarati },
    { 0x0A9B, glyph_chagujarati },
    { 0x0A9C, glyph_jagujarati },
    { 0x0A9D, glyph_jhagujarati },
    { 0x0A9E, glyph_nyagujarati },
    { 0x0A9F, glyph_ttagujarati },
    { 0x0AA0, glyph_tthagujarati },
    { 0x0AA1, glyph_ddagujarati },
    { 0x0AA2, glyph_ddhagujarati },
    { 0x0AA3, glyph_nnagujarati },
    { 0x0AA4, glyph_tagujarati },
    { 0x0AA5, glyph_thagujarati },
    { 0x0AA6, glyph_dagujarati },
    { 0x0AA7, glyph_dhagujarati },
    { 0x0AA8, glyph_nagujarati },
    { 0x0AAA, glyph_pagujarati },
    { 0x0AAB, glyph_phagujarati },
    { 0x0AAC, glyph_bagujarati },
    { 0x0AAD, glyph_bhagujarati },
    { 0x0AAE, glyph_magujarati },
    { 0x0AAF, glyph_yagujarati },
    { 0x0AB0, glyph_ragujarati },
    { 0x0AB2, glyph_lagujarati },
    { 0x0AB3, glyph_llagujarati },
    { 0x0AB5, glyph_vagujarati },
    { 0x0AB6, glyph_shagujarati },
    { 0x0AB7, glyph_ssagujarati },
    { 0x0AB8, glyph_sagujarati },
    { 0x0AB9, glyph_hagujarati },
    { 0x0ABC, glyph_nuktagujarati },
    { 0x0ABE, glyph_aavowelsigngujarati },
    { 0x0ABF, glyph_ivowelsigngujarati },
    { 0x0AC0, glyph_iivowelsigngujarati },
    { 0x0AC1, glyph_uvowelsigngujarati },
    { 0x0AC2, glyph_uuvowelsigngujarati },
    { 0x0AC3, glyph_rvocalicvowelsigngujarati },
    { 0x0AC4, glyph_rrvocalicvowelsigngujarati },
    { 0x0AC5, glyph_ecandravowelsigngujarati },
    { 0x0AC7, glyph_evowelsigngujarati },
    { 0x0AC8, glyph_aivowelsigngujarati },
    { 0x0AC9, glyph_ocandravowelsigngujarati },
    { 0x0ACB, glyph_ovowelsigngujarati },
    { 0x0ACC, glyph_auvowelsigngujarati },
    { 0x0ACD, glyph_viramagujarati },
    { 0x0AD0, glyph_omgujarati },
    { 0x0AE0, glyph_rrvocalicgujarati },
    { 0x0AE6, glyph_zerogujarati },
    { 0x0AE7, glyph_onegujarati },
    { 0x0AE8, glyph_twogujarati },
    { 0x0AE9, glyph_threegujarati },
    { 0x0AEA, glyph_fourgujarati },
    { 0x0AEB, glyph_fivegujarati },
    { 0x0AEC, glyph_sixgujarati },
    { 0x0AED, glyph_sevengujarati },
    { 0x0AEE, glyph_eightgujarati },
    { 0x0AEF, glyph_ninegujarati },
    { 0x0E01, glyph_kokaithai },
    { 0x0E02, glyph_khokhaithai },
    { 0x0E03, glyph_khokhuatthai },
    { 0x0E04, glyph_khokhwaithai },
    { 0x0E05, glyph_khokhonthai },
    { 0x0E06, glyph_khorakhangthai },
    { 0x0E07, glyph_ngonguthai },
    { 0x0E08, glyph_chochanthai },
    { 0x0E09, glyph_chochingthai },
    { 0x0E0A, glyph_chochangthai },
    { 0x0E0B, glyph_sosothai },
    { 0x0E0C, glyph_chochoethai },
    { 0x0E0D, glyph_yoyingthai },
    { 0x0E0E, glyph_dochadathai },
    { 0x0E0F, glyph_topatakthai },
    { 0x0E10, glyph_thothanthai },
    { 0x0E11, glyph_thonangmonthothai },
    { 0x0E12, glyph_thophuthaothai },
    { 0x0E13, glyph_nonenthai },
    { 0x0E14, glyph_dodekthai },
    { 0x0E15, glyph_totaothai },
    { 0x0E16, glyph_thothungthai },
    { 0x0E17, glyph_thothahanthai },
    { 0x0E18, glyph_thothongthai },
    { 0x0E19, glyph_nonuthai },
    { 0x0E1A, glyph_bobaimaithai },
    { 0x0E1B, glyph_poplathai },
    { 0x0E1C, glyph_phophungthai },
    { 0x0E1D, glyph_fofathai },
    { 0x0E1E, glyph_phophanthai },
    { 0x0E1F, glyph_fofanthai },
    { 0x0E20, glyph_phosamphaothai },
    { 0x0E21, glyph_momathai },
    { 0x0E22, glyph_yoyakthai },
    { 0x0E23, glyph_roruathai },
    { 0x0E24, glyph_ruthai },
    { 0x0E25, glyph_lolingthai },
    { 0x0E26, glyph_luthai },
    { 0x0E27, glyph_wowaenthai },
    { 0x0E28, glyph_sosalathai },
    { 0x0E29, glyph_sorusithai },
    { 0x0E2A, glyph_sosuathai },
    { 0x0E2B, glyph_hohipthai },
    { 0x0E2C, glyph_lochulathai },
    { 0x0E2D, glyph_oangthai },
    { 0x0E2E, glyph_honokhukthai },
    { 0x0E2F, glyph_paiyannoithai },
    { 0x0E30, glyph_saraathai },
    { 0x0E31, glyph_maihanakatthai },
    { 0x0E32, glyph_saraaathai },
    { 0x0E33, glyph_saraamthai },
    { 0x0E34, glyph_saraithai },
    { 0x0E35, glyph_saraiithai },
    { 0x0E36, glyph_sarauethai },
    { 0x0E37, glyph_saraueethai },
    { 0x0E38, glyph_sarauthai },
    { 0x0E39, glyph_sarauuthai },
    { 0x0E3A, glyph_phinthuthai },
    { 0x0E3F, glyph_bahtthai },
    { 0x0E40, glyph_saraethai },
    { 0x0E41, glyph_saraaethai },
    { 0x0E42, glyph_saraothai },
    { 0x0E43, glyph_saraaimaimuanthai },
    { 0x0E44, glyph_saraaimaimalaithai },
    { 0x0E45, glyph_lakkhangyaothai },
    { 0x0E46, glyph_maiyamokthai },
    { 0x0E47, glyph_maitaikhuthai },
    { 0x0E48, glyph_maiekthai },
    { 0x0E49, glyph_maithothai },
    { 0x0E4A, glyph_maitrithai },
    { 0x0E4B, glyph_maichattawathai },
    { 0x0E4C, glyph_thanthakhatthai },
    { 0x0E4D, glyph_nikhahitthai },
    { 0x0E4E, glyph_yamakkanthai },
    { 0x0E4F, glyph_fongmanthai },
    { 0x0E50, glyph_zerothai },
    { 0x0E51, glyph_onethai },
    { 0x0E52, glyph_twothai },
    { 0x0E53, glyph_threethai },
    { 0x0E54, glyph_fourthai },
    { 0x0E55, glyph_fivethai },
    { 0x0E56, glyph_sixthai },
    { 0x0E57, glyph_seventhai },
    { 0x0E58, glyph_eightthai },
    { 0x0E59, glyph_ninethai },
    { 0x0E5A, glyph_angkhankhuthai },
    { 0x0E5B, glyph_khomutthai },
    { 0x1E00, glyph_Aringbelow },
    { 0x1E01, glyph_aringbelow },
    { 0x1E02, glyph_Bdotaccent },
    { 0x1E03, glyph_bdotaccent },
    { 0x1E04, glyph_Bdotbelow },
    { 0x1E05, glyph_bdotbelow },
    { 0x1E06, glyph_Blinebelow },
    { 0x1E07, glyph_blinebelow },
    { 0x1E08, glyph_Ccedillaacute },
    { 0x1E09, glyph_ccedillaacute },
    { 0x1E0A, glyph_Ddotaccent },
    { 0x1E0B, glyph_ddotaccent },
    { 0x1E0C, glyph_Ddotbelow },
    { 0x1E0D, glyph_ddotbelow },
    { 0x1E0E, glyph_Dlinebelow },
    { 0x1E0F, glyph_dlinebelow },
    { 0x1E10, glyph_Dcedilla },
    { 0x1E11, glyph_dcedilla },
    { 0x1E12, glyph_Dcircumflexbelow },
    { 0x1E13, glyph_dcircumflexbelow },
    { 0x1E14, glyph_Emacrongrave },
    { 0x1E15, glyph_emacrongrave },
    { 0x1E16, glyph_Emacronacute },
    { 0x1E17, glyph_emacronacute },
    { 0x1E18, glyph_Ecircumflexbelow },
    { 0x1E19, glyph_ecircumflexbelow },
    { 0x1E1A, glyph_Etildebelow },
    { 0x1E1B, glyph_etildebelow },
    { 0x1E1C, glyph_Ecedillabreve },
    { 0x1E1D, glyph_ecedillabreve },
    { 0x1E1E, glyph_Fdotaccent },
    { 0x1E1F, glyph_fdotaccent },
    { 0x1E20, glyph_Gmacron },
    { 0x1E21, glyph_gmacron },
    { 0x1E22, glyph_Hdotaccent },
    { 0x1E23, glyph_hdotaccent },
    { 0x1E24, glyph_Hdotbelow },
    { 0x1E25, glyph_hdotbelow },
    { 0x1E26, glyph_Hdieresis },
    { 0x1E27, glyph_hdieresis },
    { 0x1E28, glyph_Hcedilla },
    { 0x1E29, glyph_hcedilla },
    { 0x1E2A, glyph_Hbrevebelow },
    { 0x1E2B, glyph_hbrevebelow },
    { 0x1E2C, glyph_Itildebelow },
    { 0x1E2D, glyph_itildebelow },
    { 0x1E2E, glyph_Idieresisacute },
    { 0x1E2F, glyph_idieresisacute },
    { 0x1E30, glyph_Kacute },
    { 0x1E31, glyph_kacute },
    { 0x1E32, glyph_Kdotbelow },
    { 0x1E33, glyph_kdotbelow },
    { 0x1E34, glyph_Klinebelow },
    { 0x1E35, glyph_klinebelow },
    { 0x1E36, glyph_Ldotbelow },
    { 0x1E37, glyph_ldotbelow },
    { 0x1E38, glyph_Ldotbelowmacron },
    { 0x1E39, glyph_ldotbelowmacron },
    { 0x1E3A, glyph_Llinebelow },
    { 0x1E3B, glyph_llinebelow },
    { 0x1E3C, glyph_Lcircumflexbelow },
    { 0x1E3D, glyph_lcircumflexbelow },
    { 0x1E3E, glyph_Macute },
    { 0x1E3F, glyph_macute },
    { 0x1E40, glyph_Mdotaccent },
    { 0x1E41, glyph_mdotaccent },
    { 0x1E42, glyph_Mdotbelow },
    { 0x1E43, glyph_mdotbelow },
    { 0x1E44, glyph_Ndotaccent },
    { 0x1E45, glyph_ndotaccent },
    { 0x1E46, glyph_Ndotbelow },
    { 0x1E47, glyph_ndotbelow },
    { 0x1E48, glyph_Nlinebelow },
    { 0x1E49, glyph_nlinebelow },
    { 0x1E4A, glyph_Ncircumflexbelow },
    { 0x1E4B, glyph_ncircumflexbelow },
    { 0x1E4C, glyph_Otildeacute },
    { 0x1E4D, glyph_otildeacute },
    { 0x1E4E, glyph_Otildedieresis },
    { 0x1E4F, glyph_otildedieresis },
    { 0x1E50, glyph_Omacrongrave },
    { 0x1E51, glyph_omacrongrave },
    { 0x1E52, glyph_Omacronacute },
    { 0x1E53, glyph_omacronacute },
    { 0x1E54, glyph_Pacute },
    { 0x1E55, glyph_pacute },
    { 0x1E56, glyph_Pdotaccent },
    { 0x1E57, glyph_pdotaccent },
    { 0x1E58, glyph_Rdotaccent },
    { 0x1E59, glyph_rdotaccent },
    { 0x1E5A, glyph_Rdotbelow },
    { 0x1E5B, glyph_rdotbelow },
    { 0x1E5C, glyph_Rdotbelowmacron },
    { 0x1E5D, glyph_rdotbelowmacron },
    { 0x1E5E, glyph_Rlinebelow },
    { 0x1E5F, glyph_rlinebelow },
    { 0x1E60, glyph_Sdotaccent },
    { 0x1E61, glyph_sdotaccent },
    { 0x1E62, glyph_Sdotbelow },
    { 0x1E63, glyph_sdotbelow },
    { 0x1E64, glyph_Sacutedotaccent },
    { 0x1E65, glyph_sacutedotaccent },
    { 0x1E66, glyph_Scarondotaccent },
    { 0x1E67, glyph_scarondotaccent },
    { 0x1E68, glyph_Sdotbelowdotaccent },
    { 0x1E69, glyph_sdotbelowdotaccent },
    { 0x1E6A, glyph_Tdotaccent },
    { 0x1E6B, glyph_tdotaccent },
    { 0x1E6C, glyph_Tdotbelow },
    { 0x1E6D, glyph_tdotbelow },
    { 0x1E6E, glyph_Tlinebelow },
    { 0x1E6F, glyph_tlinebelow },
    { 0x1E70, glyph_Tcircumflexbelow },
    { 0x1E71, glyph_tcircumflexbelow },
    { 0x1E72, glyph_Udieresisbelow },
    { 0x1E73, glyph_udieresisbelow },
    { 0x1E74, glyph_Utildebelow },
    { 0x1E75, glyph_utildebelow },
    { 0x1E76, glyph_Ucircumflexbelow },
    { 0x1E77, glyph_ucircumflexbelow },
    { 0x1E78, glyph_Utildeacute },
    { 0x1E79, glyph_utildeacute },
    { 0x1E7A, glyph_Umacrondieresis },
    { 0x1E7B, glyph_umacrondieresis },
    { 0x1E7C, glyph_Vtilde },
    { 0x1E7D, glyph_vtilde },
    { 0x1E7E, glyph_Vdotbelow },
    { 0x1E7F, glyph_vdotbelow },
    { 0x1E86, glyph_Wdotaccent },
    { 0x1E87, glyph_wdotaccent },
    { 0x1E88, glyph_Wdotbelow },
    { 0x1E89, glyph_wdotbelow },
    { 0x1E8A, glyph_Xdotaccent },
    { 0x1E8B, glyph_xdotaccent },
    { 0x1E8C, glyph_Xdieresis },
    { 0x1E8D, glyph_xdieresis },
    { 0x1E8E, glyph_Ydotaccent },
    { 0x1E8F, glyph_ydotaccent },
    { 0x1E90, glyph_Zcircumflex },
    { 0x1E91, glyph_zcircumflex },
    { 0x1E92, glyph_Zdotbelow },
    { 0x1E93, glyph_zdotbelow },
    { 0x1E94, glyph_Zlinebelow },
    { 0x1E95, glyph_zlinebelow },
    { 0x1E96, glyph_hlinebelow },
    { 0x1E97, glyph_tdieresis },
    { 0x1E98, glyph_wring },
    { 0x1E99, glyph_yring },
    { 0x1E9A, glyph_arighthalfring },
    { 0x1E9B, glyph_slongdotaccent },
    { 0x1EA0, glyph_Adotbelow },
    { 0x1EA1, glyph_adotbelow },
    { 0x1EA2, glyph_Ahookabove },
    { 0x1EA3, glyph_ahookabove },
    { 0x1EA4, glyph_Acircumflexacute },
    { 0x1EA5, glyph_acircumflexacute },
    { 0x1EA6, glyph_Acircumflexgrave },
    { 0x1EA7, glyph_acircumflexgrave },
    { 0x1EA8, glyph_Acircumflexhookabove },
    { 0x1EA9, glyph_acircumflexhookabove },
    { 0x1EAA, glyph_Acircumflextilde },
    { 0x1EAB, glyph_acircumflextilde },
    { 0x1EAC, glyph_Acircumflexdotbelow },
    { 0x1EAD, glyph_acircumflexdotbelow },
    { 0x1EAE, glyph_Abreveacute },
    { 0x1EAF, glyph_abreveacute },
    { 0x1EB0, glyph_Abrevegrave },
    { 0x1EB1, glyph_abrevegrave },
    { 0x1EB2, glyph_Abrevehookabove },
    { 0x1EB3, glyph_abrevehookabove },
    { 0x1EB4, glyph_Abrevetilde },
    { 0x1EB5, glyph_abrevetilde },
    { 0x1EB6, glyph_Abrevedotbelow },
    { 0x1EB7, glyph_abrevedotbelow },
    { 0x1EB8, glyph_Edotbelow },
    { 0x1EB9, glyph_edotbelow },
    { 0x1EBA, glyph_Ehookabove },
    { 0x1EBB, glyph_ehookabove },
    { 0x1EBC, glyph_Etilde },
    { 0x1EBD, glyph_etilde },
    { 0x1EBE, glyph_Ecircumflexacute },
    { 0x1EBF, glyph_ecircumflexacute },
    { 0x1EC0, glyph_Ecircumflexgrave },
    { 0x1EC1, glyph_ecircumflexgrave },
    { 0x1EC2, glyph_Ecircumflexhookabove },
    { 0x1EC3, glyph_ecircumflexhookabove },
    { 0x1EC4, glyph_Ecircumflextilde },
    { 0x1EC5, glyph_ecircumflextilde },
    { 0x1EC6, glyph_Ecircumflexdotbelow },
    { 0x1EC7, glyph_ecircumflexdotbelow },
    { 0x1EC8, glyph_Ihookabove },
    { 0x1EC9, glyph_ihookabove },
    { 0x1ECA, glyph_Idotbelow },
    { 0x1ECB, glyph_idotbelow },
    { 0x1ECC, glyph_Odotbelow },
    { 0x1ECD, glyph_odotbelow },
    { 0x1ECE, glyph_Ohookabove },
    { 0x1ECF, glyph_ohookabove },
    { 0x1ED0, glyph_Ocircumflexacute },
    { 0x1ED1, glyph_ocircumflexacute },
    { 0x1ED2, glyph_Ocircumflexgrave },
    { 0x1ED3, glyph_ocircumflexgrave },
    { 0x1ED4, glyph_Ocircumflexhookabove },
    { 0x1ED5, glyph_ocircumflexhookabove },
    { 0x1ED6, glyph_Ocircumflextilde },
    { 0x1ED7, glyph_ocircumflextilde },
    { 0x1ED8, glyph_Ocircumflexdotbelow },
    { 0x1ED9, glyph_ocircumflexdotbelow },
    { 0x1EDA, glyph_Ohornacute },
    { 0x1EDB, glyph_ohornacute },
    { 0x1EDC, glyph_Ohorngrave },
    { 0x1EDD, glyph_ohorngrave },
    { 0x1EDE, glyph_Ohornhookabove },
    { 0x1EDF, glyph_ohornhookabove },
    { 0x1EE0, glyph_Ohorntilde },
    { 0x1EE1, glyph_ohorntilde },
    { 0x1EE2, glyph_Ohorndotbelow },
    { 0x1EE3, glyph_ohorndotbelow },
    { 0x1EE4, glyph_Udotbelow },
    { 0x1EE5, glyph_udotbelow },
    { 0x1EE6, glyph_Uhookabove },
    { 0x1EE7, glyph_uhookabove },
    { 0x1EE8, glyph_Uhornacute },
    { 0x1EE9, glyph_uhornacute },
    { 0x1EEA, glyph_Uhorngrave },
    { 0x1EEB, glyph_uhorngrave },
    { 0x1EEC, glyph_Uhornhookabove },
    { 0x1EED, glyph_uhornhookabove },
    { 0x1EEE, glyph_Uhorntilde },
    { 0x1EEF, glyph_uhorntilde },
    { 0x1EF0, glyph_Uhorndotbelow },
    { 0x1EF1, glyph_uhorndotbelow },
    { 0x1EF4, glyph_Ydotbelow },
    { 0x1EF5, glyph_ydotbelow },
    { 0x1EF6, glyph_Yhookabove },
    { 0x1EF7, glyph_yhookabove },
    { 0x1EF8, glyph_Ytilde },
    { 0x1EF9, glyph_ytilde },
    { 0x2002, glyph_enspace },
    { 0x200B, glyph_zerowidthspace },
    { 0x200C, glyph_zerowidthnonjoiner },
    { 0x2010, glyph_hyphentwo },
    { 0x2015, glyph_horizontalbar },
    { 0x2016, glyph_dblverticalbar },
    { 0x2017, glyph_dbllowline },
    { 0x201B, glyph_quoteleftreversed },
    { 0x2025, glyph_twodotleader },
    { 0x2035, glyph_primereversed },
    { 0x203B, glyph_referencemark },
    { 0x203E, glyph_overline },
    { 0x2042, glyph_asterism },
    { 0x207A, glyph_plussuperior },
    { 0x207C, glyph_equalsuperior },
    { 0x20A1, glyph_colonsign },
    { 0x20A2, glyph_cruzeiro },
    { 0x20A4, glyph_afii08941 },
    { 0x20A9, glyph_won },
    { 0x20AC, glyph_euro },
    { 0x2103, glyph_centigrade },
    { 0x2105, glyph_careof },
    { 0x2109, glyph_fahrenheit },
    { 0x2113, glyph_lsquare },
    { 0x2116, glyph_numero },
    { 0x2121, glyph_telephone },
    { 0x2126, glyph_Ohm },
    { 0x212B, glyph_angstrom },
    { 0x2160, glyph_Oneroman },
    { 0x2161, glyph_Tworoman },
    { 0x2162, glyph_Threeroman },
    { 0x2163, glyph_Fourroman },
    { 0x2164, glyph_Fiveroman },
    { 0x2165, glyph_Sixroman },
    { 0x2166, glyph_Sevenroman },
    { 0x2167, glyph_Eightroman },
    { 0x2168, glyph_Nineroman },
    { 0x2169, glyph_Tenroman },
    { 0x216A, glyph_Elevenroman },
    { 0x216B, glyph_Twelveroman },
    { 0x2170, glyph_oneroman },
    { 0x2171, glyph_tworoman },
    { 0x2172, glyph_threeroman },
    { 0x2173, glyph_fourroman },
    { 0x2174, glyph_fiveroman },
    { 0x2175, glyph_sixroman },
    { 0x2176, glyph_sevenroman },
    { 0x2177, glyph_eightroman },
    { 0x2178, glyph_nineroman },
    { 0x2179, glyph_tenroman },
    { 0x217A, glyph_elevenroman },
    { 0x217B, glyph_twelveroman },
    { 0x2196, glyph_arrowupleft },
    { 0x2197, glyph_arrowupright },
    { 0x2198, glyph_arrowdownright },
    { 0x2199, glyph_arrowdownleft },
    { 0x21A8, glyph_arrowupdownbase },
    { 0x21BC, glyph_harpoonleftbarbup },
    { 0x21C0, glyph_harpoonrightbarbup },
    { 0x21C4, glyph_arrowrightoverleft },
    { 0x21C5, glyph_arrowupleftofdown },
    { 0x21C6, glyph_arrowleftoverright },
    { 0x21CD, glyph_arrowleftdblstroke },
    { 0x21CF, glyph_arrowrightdblstroke },
    { 0x21D0, glyph_arrowleftdbl },
    { 0x21D2, glyph_dblarrowright },
    { 0x21D4, glyph_dblarrowleft },
    { 0x21DE, glyph_pageup },
    { 0x21DF, glyph_pagedown },
    { 0x21E0, glyph_arrowdashleft },
    { 0x21E1, glyph_arrowdashup },
    { 0x21E2, glyph_arrowdashright },
    { 0x21E3, glyph_arrowdashdown },
    { 0x21E4, glyph_arrowtableft },
    { 0x21E5, glyph_arrowtabright },
    { 0x21E6, glyph_arrowleftwhite },
    { 0x21E7, glyph_arrowupwhite },
    { 0x21E8, glyph_arrowrightwhite },
    { 0x21E9, glyph_arrowdownwhite },
    { 0x21EA, glyph_capslock },
    { 0x2200, glyph_forall },
    { 0x2203, glyph_thereexists },
    { 0x2206, glyph_increment },
    { 0x2207, glyph_nabla },
    { 0x2209, glyph_notelementof },
    { 0x220C, glyph_notcontains },
    { 0x2213, glyph_minusplus },
    { 0x221F, glyph_rightangle },
    { 0x2223, glyph_divides },
    { 0x2225, glyph_parallel },
    { 0x2226, glyph_notparallel },
    { 0x222C, glyph_dblintegral },
    { 0x222E, glyph_contourintegral },
    { 0x2235, glyph_because },
    { 0x2236, glyph_ratio },
    { 0x2237, glyph_proportion },
    { 0x223C, glyph_tildeoperator },
    { 0x223D, glyph_reversedtilde },
    { 0x2243, glyph_asymptoticallyequal },
    { 0x2245, glyph_approximatelyequal },
    { 0x224C, glyph_allequal },
    { 0x2250, glyph_approaches },
    { 0x2251, glyph_geometricallyequal },
    { 0x2252, glyph_approxequalorimage },
    { 0x2253, glyph_imageorapproximatelyequal },
    { 0x2262, glyph_notidentical },
    { 0x2266, glyph_lessoverequal },
    { 0x2267, glyph_greateroverequal },
    { 0x226A, glyph_muchless },
    { 0x226B, glyph_muchgreater },
    { 0x226E, glyph_notless },
    { 0x226F, glyph_notgreater },
    { 0x2270, glyph_notlessnorequal },
    { 0x2271, glyph_notgreaternorequal },
    { 0x2272, glyph_lessorequivalent },
    { 0x2273, glyph_greaterorequivalent },
    { 0x2276, glyph_lessorgreater },
    { 0x2277, glyph_greaterorless },
    { 0x2279, glyph_notgreaternorless },
    { 0x227A, glyph_precedes },
    { 0x227B, glyph_succeeds },
    { 0x2280, glyph_notprecedes },
    { 0x2281, glyph_notsucceeds },
    { 0x2282, glyph_subset },
    { 0x2283, glyph_superset },
    { 0x2285, glyph_notsuperset },
    { 0x2286, glyph_subsetorequal },
    { 0x2287, glyph_supersetorequal },
    { 0x228A, glyph_subsetnotequal },
    { 0x228B, glyph_supersetnotequal },
    { 0x2295, glyph_pluscircle },
    { 0x2296, glyph_minuscircle },
    { 0x2297, glyph_timescircle },
    { 0x2299, glyph_circleot },
    { 0x22A3, glyph_tackleft },
    { 0x22A4, glyph_tackdown },
    { 0x22BF, glyph_righttriangle },
    { 0x22CE, glyph_curlyor },
    { 0x22CF, glyph_curlyand },
    { 0x22DA, glyph_lessequalorgreater },
    { 0x22DB, glyph_greaterequalorless },
    { 0x22EE, glyph_ellipsisvertical },
    { 0x2303, glyph_control },
    { 0x2305, glyph_projective },
    { 0x2310, glyph_logicalnotreversed },
    { 0x2312, glyph_arc },
    { 0x2318, glyph_propellor },
    { 0x2320, glyph_integraltop },
    { 0x2321, glyph_integralbottom },
    { 0x2325, glyph_option },
    { 0x2326, glyph_deleteright },
    { 0x2327, glyph_clear },
    { 0x232B, glyph_deleteleft },
    { 0x2423, glyph_blank },
    { 0x2460, glyph_onecircle },
    { 0x2461, glyph_twocircle },
    { 0x2462, glyph_threecircle },
    { 0x2463, glyph_fourcircle },
    { 0x2464, glyph_fivecircle },
    { 0x2465, glyph_sixcircle },
    { 0x2466, glyph_sevencircle },
    { 0x2467, glyph_eightcircle },
    { 0x2468, glyph_ninecircle },
    { 0x2469, glyph_tencircle },
    { 0x246A, glyph_elevencircle },
    { 0x246B, glyph_twelvecircle },
    { 0x246C, glyph_thirteencircle },
    { 0x246D, glyph_fourteencircle },
    { 0x246E, glyph_fifteencircle },
    { 0x246F, glyph_sixteencircle },
    { 0x2470, glyph_seventeencircle },
    { 0x2471, glyph_eighteencircle },
    { 0x2472, glyph_nineteencircle },
    { 0x2473, glyph_twentycircle },
    { 0x2474, glyph_oneparen },
    { 0x2475, glyph_twoparen },
    { 0x2476, glyph_threeparen },
    { 0x2477, glyph_fourparen },
    { 0x2478, glyph_fiveparen },
    { 0x2479, glyph_sixparen },
    { 0x247A, glyph_sevenparen },
    { 0x247B, glyph_eightparen },
    { 0x247C, glyph_nineparen },
    { 0x247D, glyph_tenparen },
    { 0x247E, glyph_elevenparen },
    { 0x247F, glyph_twelveparen },
    { 0x2480, glyph_thirteenparen },
    { 0x2481, glyph_fourteenparen },
    { 0x2482, glyph_fifteenparen },
    { 0x2483, glyph_sixteenparen },
    { 0x2484, glyph_seventeenparen },
    { 0x2485, glyph_eighteenparen },
    { 0x2486, glyph_nineteenparen },
    { 0x2487, glyph_twentyparen },
    { 0x2488, glyph_oneperiod },
    { 0x2489, glyph_twoperiod },
    { 0x248A, glyph_threeperiod },
    { 0x248B, glyph_fourperiod },
    { 0x248C, glyph_fiveperiod },
    { 0x248D, glyph_sixperiod },
    { 0x248E, glyph_sevenperiod },
    { 0x248F, glyph_eightperiod },
    { 0x2490, glyph_nineperiod },
    { 0x2491, glyph_tenperiod },
    { 0x2492, glyph_elevenperiod },
    { 0x2493, glyph_twelveperiod },
    { 0x2494, glyph_thirteenperiod },
    { 0x2495, glyph_fourteenperiod },
    { 0x2496, glyph_fifteenperiod },
    { 0x2497, glyph_sixteenperiod },
    { 0x2498, glyph_seventeenperiod },
    { 0x2499, glyph_eighteenperiod },
    { 0x249A, glyph_nineteenperiod },
    { 0x249B, glyph_twentyperiod },
    { 0x249C, glyph_aparen },
    { 0x249D, glyph_bparen },
    { 0x249E, glyph_cparen },
    { 0x249F, glyph_dparen },
    { 0x24A0, glyph_eparen },
    { 0x24A1, glyph_fparen },
    { 0x24A2, glyph_gparen },
    { 0x24A3, glyph_hparen },
    { 0x24A4, glyph_iparen },
    { 0x24A5, glyph_jparen },
    { 0x24A6, glyph_kparen },
    { 0x24A7, glyph_lparen },
    { 0x24A8, glyph_mparen },
    { 0x24A9, glyph_nparen },
    { 0x24AA, glyph_oparen },
    { 0x24AB, glyph_pparen },
    { 0x24AC, glyph_qparen },
    { 0x24AD, glyph_rparen },
    { 0x24AE, glyph_sparen },
    { 0x24AF, glyph_tparen },
    { 0x24B0, glyph_uparen },
    { 0x24B1, glyph_vparen },
    { 0x24B2, glyph_wparen },
    { 0x24B3, glyph_xparen },
    { 0x24B4, glyph_yparen },
    { 0x24B5, glyph_zparen },
    { 0x24B6, glyph_Acircle },
    { 0x24B7, glyph_Bcircle },
    { 0x24B8, glyph_Ccircle },
    { 0x24B9, glyph_Dcircle },
    { 0x24BA, glyph_Ecircle },
    { 0x24BB, glyph_Fcircle },
    { 0x24BC, glyph_Gcircle },
    { 0x24BD, glyph_Hcircle },
    { 0x24BE, glyph_Icircle },
    { 0x24BF, glyph_Jcircle },
    { 0x24C0, glyph_Kcircle },
    { 0x24C1, glyph_Lcircle },
    { 0x24C2, glyph_Mcircle },
    { 0x24C3, glyph_Ncircle },
    { 0x24C4, glyph_Ocircle },
    { 0x24C5, glyph_Pcircle },
    { 0x24C6, glyph_Qcircle },
    { 0x24C7, glyph_Rcircle },
    { 0x24C8, glyph_Scircle },
    { 0x24C9, glyph_Tcircle },
    { 0x24CA, glyph_Ucircle },
    { 0x24CB, glyph_Vcircle },
    { 0x24CC, glyph_Wcircle },
    { 0x24CD, glyph_Xcircle },
    { 0x24CE, glyph_Ycircle },
    { 0x24CF, glyph_Zcircle },
    { 0x24D0, glyph_acircle },
    { 0x24D1, glyph_bcircle },
    { 0x24D2, glyph_ccircle },
    { 0x24D3, glyph_dcircle },
    { 0x24D4, glyph_ecircle },
    { 0x24D5, glyph_fcircle },
    { 0x24D6, glyph_gcircle },
    { 0x24D7, glyph_hcircle },
    { 0x24D8, glyph_icircle },
    { 0x24D9, glyph_jcircle },
    { 0x24DA, glyph_kcircle },
    { 0x24DB, glyph_lcircle },
    { 0x24DC, glyph_mcircle },
    { 0x24DD, glyph_ncircle },
    { 0x24DE, glyph_ocircle },
    { 0x24DF, glyph_pcircle },
    { 0x24E0, glyph_qcircle },
    { 0x24E1, glyph_rcircle },
    { 0x24E2, glyph_scircle },
    { 0x24E3, glyph_tcircle },
    { 0x24E4, glyph_ucircle },
    { 0x24E5, glyph_vcircle },
    { 0x24E6, glyph_wcircle },
    { 0x24E7, glyph_xcircle },
    { 0x24E8, glyph_ycircle },
    { 0x24E9, glyph_zcircle },
    { 0x2591, glyph_shadelight },
    { 0x2592, glyph_shademedium },
    { 0x2593, glyph_shadedark },
    { 0x25A0, glyph_blacksquare },
    { 0x25A1, glyph_whitesquare },
    { 0x25A3, glyph_squarewhitewithsmallblack },
    { 0x25A4, glyph_squarehorizontalfill },
    { 0x25A5, glyph_squareverticalfill },
    { 0x25A6, glyph_squareorthogonalcrosshatchfill },
    { 0x25A7, glyph_squareupperlefttolowerrightfill },
    { 0x25A8, glyph_squareupperrighttolowerleftfill },
    { 0x25A9, glyph_squarediagonalcrosshatchfill },
    { 0x25AA, glyph_blacksmallsquare },
    { 0x25AB, glyph_whitesmallsquare },
    { 0x25AC, glyph_blackrectangle },
    { 0x25B2, glyph_blackuppointingtriangle },
    { 0x25B3, glyph_whiteuppointingtriangle },
    { 0x25B4, glyph_blackuppointingsmalltriangle },
    { 0x25B5, glyph_whiteuppointingsmalltriangle },
    { 0x25B6, glyph_blackrightpointingtriangle },
    { 0x25B7, glyph_whiterightpointingtriangle },
    { 0x25B9, glyph_whiterightpointingsmalltriangle },
    { 0x25BA, glyph_blackrightpointingpointer },
    { 0x25BC, glyph_blackdownpointingtriangle },
    { 0x25BD, glyph_whitedownpointingtriangle },
    { 0x25BF, glyph_whitedownpointingsmalltriangle },
    { 0x25C0, glyph_blackleftpointingtriangle },
    { 0x25C1, glyph_whiteleftpointingtriangle },
    { 0x25C3, glyph_whiteleftpointingsmalltriangle },
    { 0x25C4, glyph_blackleftpointingpointer },
    { 0x25C6, glyph_blackdiamond },
    { 0x25C7, glyph_whitediamond },
    { 0x25C8, glyph_whitediamondcontainingblacksmalldiamond },
    { 0x25C9, glyph_fisheye },
    { 0x25CB, glyph_whitecircle },
    { 0x25CC, glyph_dottedcircle },
    { 0x25CE, glyph_bullseye },
    { 0x25CF, glyph_blackcircle },
    { 0x25D0, glyph_circlewithlefthalfblack },
    { 0x25D1, glyph_circlewithrighthalfblack },
    { 0x25D8, glyph_bulletinverse },
    { 0x25D9, glyph_whitecircleinverse },
    { 0x25E2, glyph_blacklowerrighttriangle },
    { 0x25E3, glyph_blacklowerlefttriangle },
    { 0x25E4, glyph_blackupperlefttriangle },
    { 0x25E5, glyph_blackupperrighttriangle },
    { 0x25E6, glyph_whitebullet },
    { 0x25EF, glyph_largecircle },
    { 0x2605, glyph_blackstar },
    { 0x2606, glyph_whitestar },
    { 0x260E, glyph_telephoneblack },
    { 0x260F, glyph_whitetelephone },
    { 0x261C, glyph_pointingindexleftwhite },
    { 0x261D, glyph_pointingindexupwhite },
    { 0x261E, glyph_pointingindexrightwhite },
    { 0x261F, glyph_pointingindexdownwhite },
    { 0x262F, glyph_yinyang },
    { 0x263A, glyph_whitesmilingface },
    { 0x263B, glyph_blacksmilingface },
    { 0x263C, glyph_compass },
    { 0x2640, glyph_venus },
    { 0x2641, glyph_earth },
    { 0x2642, glyph_mars },
    { 0x2660, glyph_spadesuitblack },
    { 0x2661, glyph_heartsuitwhite },
    { 0x2662, glyph_diamondsuitwhite },
    { 0x2663, glyph_clubsuitblack },
    { 0x2664, glyph_spadesuitwhite },
    { 0x2665, glyph_heartsuitblack },
    { 0x2667, glyph_clubsuitwhite },
    { 0x2668, glyph_hotsprings },
    { 0x2669, glyph_quarternote },
    { 0x266B, glyph_eighthnotebeamed },
    { 0x266C, glyph_beamedsixteenthnotes },
    { 0x266D, glyph_musicflatsign },
    { 0x266F, glyph_musicsharpsign },
    { 0x2713, glyph_checkmark },
    { 0x278A, glyph_onecircleinversesansserif },
    { 0x278B, glyph_twocircleinversesansserif },
    { 0x278C, glyph_threecircleinversesansserif },
    { 0x278D, glyph_fourcircleinversesansserif },
    { 0x278E, glyph_fivecircleinversesansserif },
    { 0x278F, glyph_sixcircleinversesansserif },
    { 0x2790, glyph_sevencircleinversesansserif },
    { 0x2791, glyph_eightcircleinversesansserif },
    { 0x2792, glyph_ninecircleinversesansserif },
    { 0x279E, glyph_arrowrightheavy },
    { 0x3000, glyph_ideographicspace },
    { 0x3001, glyph_ideographiccomma },
    { 0x3002, glyph_ideographicperiod },
    { 0x3003, glyph_dittomark },
    { 0x3004, glyph_jis },
    { 0x3005, glyph_ideographiciterationmark },
    { 0x3006, glyph_ideographicclose },
    { 0x3007, glyph_ideographiczero },
    { 0x3008, glyph_anglebracketleft },
    { 0x3009, glyph_anglebracketright },
    { 0x300A, glyph_dblanglebracketleft },
    { 0x300B, glyph_dblanglebracketright },
    { 0x300C, glyph_cornerbracketleft },
    { 0x300D, glyph_cornerbracketright },
    { 0x300E, glyph_whitecornerbracketleft },
    { 0x300F, glyph_whitecornerbracketright },
    { 0x3010, glyph_blacklenticularbracketleft },
    { 0x3011, glyph_blacklenticularbracketright },
    { 0x3012, glyph_postalmark },
    { 0x3013, glyph_getamark },
    { 0x3014, glyph_tortoiseshellbracketleft },
    { 0x3015, glyph_tortoiseshellbracketright },
    { 0x3016, glyph_whitelenticularbracketleft },
    { 0x3017, glyph_whitelenticularbracketright },
    { 0x3018, glyph_whitetortoiseshellbracketleft },
    { 0x3019, glyph_whitetortoiseshellbracketright },
    { 0x301C, glyph_wavedash },
    { 0x301D, glyph_quotedblprimereversed },
    { 0x301E, glyph_quotedblprime },
    { 0x3020, glyph_postalmarkface },
    { 0x3021, glyph_onehangzhou },
    { 0x3022, glyph_twohangzhou },
    { 0x3023, glyph_threehangzhou },
    { 0x3024, glyph_fourhangzhou },
    { 0x3025, glyph_fivehangzhou },
    { 0x3026, glyph_sixhangzhou },
    { 0x3027, glyph_sevenhangzhou },
    { 0x3028, glyph_eighthangzhou },
    { 0x3029, glyph_ninehangzhou },
    { 0x3036, glyph_circlepostalmark },
    { 0x3041, glyph_asmallhiragana },
    { 0x3042, glyph_ahiragana },
    { 0x3043, glyph_ismallhiragana },
    { 0x3044, glyph_ihiragana },
    { 0x3045, glyph_usmallhiragana },
    { 0x3046, glyph_uhiragana },
    { 0x3047, glyph_esmallhiragana },
    { 0x3048, glyph_ehiragana },
    { 0x3049, glyph_osmallhiragana },
    { 0x304A, glyph_ohiragana },
    { 0x304B, glyph_kahiragana },
    { 0x304C, glyph_gahiragana },
    { 0x304D, glyph_kihiragana },
    { 0x304E, glyph_gihiragana },
    { 0x304F, glyph_kuhiragana },
    { 0x3050, glyph_guhiragana },
    { 0x3051, glyph_kehiragana },
    { 0x3052, glyph_gehiragana },
    { 0x3053, glyph_kohiragana },
    { 0x3054, glyph_gohiragana },
    { 0x3055, glyph_sahiragana },
    { 0x3056, glyph_zahiragana },
    { 0x3057, glyph_sihiragana },
    { 0x3058, glyph_zihiragana },
    { 0x3059, glyph_suhiragana },
    { 0x305A, glyph_zuhiragana },
    { 0x305B, glyph_sehiragana },
    { 0x305C, glyph_zehiragana },
    { 0x305D, glyph_sohiragana },
    { 0x305E, glyph_zohiragana },
    { 0x305F, glyph_tahiragana },
    { 0x3060, glyph_dahiragana },
    { 0x3061, glyph_tihiragana },
    { 0x3062, glyph_dihiragana },
    { 0x3063, glyph_tusmallhiragana },
    { 0x3064, glyph_tuhiragana },
    { 0x3065, glyph_duhiragana },
    { 0x3066, glyph_tehiragana },
    { 0x3067, glyph_dehiragana },
    { 0x3068, glyph_tohiragana },
    { 0x3069, glyph_dohiragana },
    { 0x306A, glyph_nahiragana },
    { 0x306B, glyph_nihiragana },
    { 0x306C, glyph_nuhiragana },
    { 0x306D, glyph_nehiragana },
    { 0x306E, glyph_nohiragana },
    { 0x306F, glyph_hahiragana },
    { 0x3070, glyph_bahiragana },
    { 0x3071, glyph_pahiragana },
    { 0x3072, glyph_hihiragana },
    { 0x3073, glyph_bihiragana },
    { 0x3074, glyph_pihiragana },
    { 0x3075, glyph_huhiragana },
    { 0x3076, glyph_buhiragana },
    { 0x3077, glyph_puhiragana },
    { 0x3078, glyph_hehiragana },
    { 0x3079, glyph_behiragana },
    { 0x307A, glyph_pehiragana },
    { 0x307B, glyph_hohiragana },
    { 0x307C, glyph_bohiragana },
    { 0x307D, glyph_pohiragana },
    { 0x307E, glyph_mahiragana },
    { 0x307F, glyph_mihiragana },
    { 0x3080, glyph_muhiragana },
    { 0x3081, glyph_mehiragana },
    { 0x3082, glyph_mohiragana },
    { 0x3083, glyph_yasmallhiragana },
    { 0x3084, glyph_yahiragana },
    { 0x3085, glyph_yusmallhiragana },
    { 0x3086, glyph_yuhiragana },
    { 0x3087, glyph_yosmallhiragana },
    { 0x3088, glyph_yohiragana },
    { 0x3089, glyph_rahiragana },
    { 0x308A, glyph_rihiragana },
    { 0x308B, glyph_ruhiragana },
    { 0x308C, glyph_rehiragana },
    { 0x308D, glyph_rohiragana },
    { 0x308E, glyph_wasmallhiragana },
    { 0x308F, glyph_wahiragana },
    { 0x3090, glyph_wihiragana },
    { 0x3091, glyph_wehiragana },
    { 0x3092, glyph_wohiragana },
    { 0x3093, glyph_nhiragana },
    { 0x3094, glyph_vuhiragana },
    { 0x309B, glyph_voicedmarkkana },
    { 0x309C, glyph_semivoicedmarkkana },
    { 0x309D, glyph_iterationhiragana },
    { 0x309E, glyph_voicediterationhiragana },
    { 0x30A1, glyph_asmallkatakana },
    { 0x30A2, glyph_akatakana },
    { 0x30A3, glyph_ismallkatakana },
    { 0x30A4, glyph_ikatakana },
    { 0x30A5, glyph_usmallkatakana },
    { 0x30A6, glyph_ukatakana },
    { 0x30A7, glyph_esmallkatakana },
    { 0x30A8, glyph_ekatakana },
    { 0x30A9, glyph_osmallkatakana },
    { 0x30AA, glyph_okatakana },
    { 0x30AB, glyph_kakatakana },
    { 0x30AC, glyph_gakatakana },
    { 0x30AD, glyph_kikatakana },
    { 0x30AE, glyph_gikatakana },
    { 0x30AF, glyph_kukatakana },
    { 0x30B0, glyph_gukatakana },
    { 0x30B1, glyph_kekatakana },
    { 0x30B2, glyph_gekatakana },
    { 0x30B3, glyph_kokatakana },
    { 0x30B4, glyph_gokatakana },
    { 0x30B5, glyph_sakatakana },
    { 0x30B6, glyph_zakatakana },
    { 0x30B7, glyph_sikatakana },
    { 0x30B8, glyph_zikatakana },
    { 0x30B9, glyph_sukatakana },
    { 0x30BA, glyph_zukatakana },
    { 0x30BB, glyph_sekatakana },
    { 0x30BC, glyph_zekatakana },
    { 0x30BD, glyph_sokatakana },
    { 0x30BE, glyph_zokatakana },
    { 0x30BF, glyph_takatakana },
    { 0x30C0, glyph_dakatakana },
    { 0x30C1, glyph_tikatakana },
    { 0x30C2, glyph_dikatakana },
    { 0x30C3, glyph_tusmallkatakana },
    { 0x30C4, glyph_tukatakana },
    { 0x30C5, glyph_dukatakana },
    { 0x30C6, glyph_tekatakana },
    { 0x30C7, glyph_dekatakana },
    { 0x30C8, glyph_tokatakana },
    { 0x30C9, glyph_dokatakana },
    { 0x30CA, glyph_nakatakana },
    { 0x30CB, glyph_nikatakana },
    { 0x30CC, glyph_nukatakana },
    { 0x30CD, glyph_nekatakana },
    { 0x30CE, glyph_nokatakana },
    { 0x30CF, glyph_hakatakana },
    { 0x30D0, glyph_bakatakana },
    { 0x30D1, glyph_pakatakana },
    { 0x30D2, glyph_hikatakana },
    { 0x30D3, glyph_bikatakana },
    { 0x30D4, glyph_pikatakana },
    { 0x30D5, glyph_hukatakana },
    { 0x30D6, glyph_bukatakana },
    { 0x30D7, glyph_pukatakana },
    { 0x30D8, glyph_hekatakana },
    { 0x30D9, glyph_bekatakana },
    { 0x30DA, glyph_pekatakana },
    { 0x30DB, glyph_hokatakana },
    { 0x30DC, glyph_bokatakana },
    { 0x30DD, glyph_pokatakana },
    { 0x30DE, glyph_makatakana },
    { 0x30DF, glyph_mikatakana },
    { 0x30E0, glyph_mukatakana },
    { 0x30E1, glyph_mekatakana },
    { 0x30E2, glyph_mokatakana },
    { 0x30E3, glyph_yasmallkatakana },
    { 0x30E4, glyph_yakatakana },
    { 0x30E5, glyph_yusmallkatakana },
    { 0x30E6, glyph_yukatakana },
    { 0x30E7, glyph_yosmallkatakana },
    { 0x30E8, glyph_yokatakana },
    { 0x30E9, glyph_rakatakana },
    { 0x30EA, glyph_rikatakana },
    { 0x30EB, glyph_rukatakana },
    { 0x30EC, glyph_rekatakana },
    { 0x30ED, glyph_rokatakana },
    { 0x30EE, glyph_wasmallkatakana },
    { 0x30EF, glyph_wakatakana },
    { 0x30F0, glyph_wikatakana },
    { 0x30F1, glyph_wekatakana },
    { 0x30F2, glyph_wokatakana },
    { 0x30F3, glyph_nkatakana },
    { 0x30F4, glyph_vukatakana },
    { 0x30F5, glyph_kasmallkatakana },
    { 0x30F6, glyph_kesmallkatakana },
    { 0x30F7, glyph_vakatakana },
    { 0x30F8, glyph_vikatakana },
    { 0x30F9, glyph_vekatakana },
    { 0x30FA, glyph_vokatakana },
    { 0x30FB, glyph_dotkatakana },
    { 0x30FC, glyph_prolongedkana },
    { 0x30FD, glyph_iterationkatakana },
    { 0x30FE, glyph_voicediterationkatakana },
    { 0x3105, glyph_bbopomofo },
    { 0x3106, glyph_pbopomofo },
    { 0x3107, glyph_mbopomofo },
    { 0x3108, glyph_fbopomofo },
    { 0x3109, glyph_dbopomofo },
    { 0x310A, glyph_tbopomofo },
    { 0x310B, glyph_nbopomofo },
    { 0x310C, glyph_lbopomofo },
    { 0x310D, glyph_gbopomofo },
    { 0x310E, glyph_kbopomofo },
    { 0x310F, glyph_hbopomofo },
    { 0x3110, glyph_jbopomofo },
    { 0x3111, glyph_qbopomofo },
    { 0x3112, glyph_xbopomofo },
    { 0x3113, glyph_zhbopomofo },
    { 0x3114, glyph_chbopomofo },
    { 0x3115, glyph_shbopomofo },
    { 0x3116, glyph_rbopomofo },
    { 0x3117, glyph_zbopomofo },
    { 0x3118, glyph_cbopomofo },
    { 0x3119, glyph_sbopomofo },
    { 0x311A, glyph_abopomofo },
    { 0x311B, glyph_obopomofo },
    { 0x311C, glyph_ebopomofo },
    { 0x311D, glyph_ehbopomofo },
    { 0x311E, glyph_aibopomofo },
    { 0x311F, glyph_eibopomofo },
    { 0x3120, glyph_aubopomofo },
    { 0x3121, glyph_oubopomofo },
    { 0x3122, glyph_anbopomofo },
    { 0x3123, glyph_enbopomofo },
    { 0x3124, glyph_angbopomofo },
    { 0x3125, glyph_engbopomofo },
    { 0x3126, glyph_erbopomofo },
    { 0x3127, glyph_ibopomofo },
    { 0x3128, glyph_ubopomofo },
    { 0x3129, glyph_iubopomofo },
    { 0x3131, glyph_kiyeokkorean },
    { 0x3132, glyph_ssangkiyeokkorean },
    { 0x3133, glyph_kiyeoksioskorean },
    { 0x3134, glyph_nieunkorean },
    { 0x3135, glyph_nieuncieuckorean },
    { 0x3136, glyph_nieunhieuhkorean },
    { 0x3137, glyph_tikeutkorean },
    { 0x3138, glyph_ssangtikeutkorean },
    { 0x3139, glyph_rieulkorean },
    { 0x313A, glyph_rieulkiyeokkorean },
    { 0x313B, glyph_rieulmieumkorean },
    { 0x313C, glyph_rieulpieupkorean },
    { 0x313D, glyph_rieulsioskorean },
    { 0x313E, glyph_rieulthieuthkorean },
    { 0x313F, glyph_rieulphieuphkorean },
    { 0x3140, glyph_rieulhieuhkorean },
    { 0x3141, glyph_mieumkorean },
    { 0x3142, glyph_pieupkorean },
    { 0x3143, glyph_ssangpieupkorean },
    { 0x3144, glyph_pieupsioskorean },
    { 0x3145, glyph_sioskorean },
    { 0x3146, glyph_ssangsioskorean },
    { 0x3147, glyph_ieungkorean },
    { 0x3148, glyph_cieuckorean },
    { 0x3149, glyph_ssangcieuckorean },
    { 0x314A, glyph_chieuchkorean },
    { 0x314B, glyph_khieukhkorean },
    { 0x314C, glyph_thieuthkorean },
    { 0x314D, glyph_phieuphkorean },
    { 0x314E, glyph_hieuhkorean },
    { 0x314F, glyph_akorean },
    { 0x3150, glyph_aekorean },
    { 0x3151, glyph_yakorean },
    { 0x3152, glyph_yaekorean },
    { 0x3153, glyph_eokorean },
    { 0x3154, glyph_ekorean },
    { 0x3155, glyph_yeokorean },
    { 0x3156, glyph_yekorean },
    { 0x3157, glyph_okorean },
    { 0x3158, glyph_wakorean },
    { 0x3159, glyph_waekorean },
    { 0x315A, glyph_oekorean },
    { 0x315B, glyph_yokorean },
    { 0x315C, glyph_ukorean },
    { 0x315D, glyph_weokorean },
    { 0x315E, glyph_wekorean },
    { 0x315F, glyph_wikorean },
    { 0x3160, glyph_yukorean },
    { 0x3161, glyph_eukorean },
    { 0x3162, glyph_yikorean },
    { 0x3163, glyph_ikorean },
    { 0x3164, glyph_hangulfiller },
    { 0x3165, glyph_ssangnieunkorean },
    { 0x3166, glyph_nieuntikeutkorean },
    { 0x3167, glyph_nieunsioskorean },
    { 0x3168, glyph_nieunpansioskorean },
    { 0x3169, glyph_rieulkiyeoksioskorean },
    { 0x316A, glyph_rieultikeutkorean },
    { 0x316B, glyph_rieulpieupsioskorean },
    { 0x316C, glyph_rieulpansioskorean },
    { 0x316D, glyph_rieulyeorinhieuhkorean },
    { 0x316E, glyph_mieumpieupkorean },
    { 0x316F, glyph_mieumsioskorean },
    { 0x3170, glyph_mieumpansioskorean },
    { 0x3171, glyph_kapyeounmieumkorean },
    { 0x3172, glyph_pieupkiyeokkorean },
    { 0x3173, glyph_pieuptikeutkorean },
    { 0x3174, glyph_pieupsioskiyeokkorean },
    { 0x3175, glyph_pieupsiostikeutkorean },
    { 0x3176, glyph_pieupcieuckorean },
    { 0x3177, glyph_pieupthieuthkorean },
    { 0x3178, glyph_kapyeounpieupkorean },
    { 0x3179, glyph_kapyeounssangpieupkorean },
    { 0x317A, glyph_sioskiyeokkorean },
    { 0x317B, glyph_siosnieunkorean },
    { 0x317C, glyph_siostikeutkorean },
    { 0x317D, glyph_siospieupkorean },
    { 0x317E, glyph_sioscieuckorean },
    { 0x317F, glyph_pansioskorean },
    { 0x3180, glyph_ssangieungkorean },
    { 0x3181, glyph_yesieungkorean },
    { 0x3182, glyph_yesieungsioskorean },
    { 0x3183, glyph_yesieungpansioskorean },
    { 0x3184, glyph_kapyeounphieuphkorean },
    { 0x3185, glyph_ssanghieuhkorean },
    { 0x3186, glyph_yeorinhieuhkorean },
    { 0x3187, glyph_yoyakorean },
    { 0x3188, glyph_yoyaekorean },
    { 0x3189, glyph_yoikorean },
    { 0x318A, glyph_yuyeokorean },
    { 0x318B, glyph_yuyekorean },
    { 0x318C, glyph_yuikorean },
    { 0x318D, glyph_araeakorean },
    { 0x318E, glyph_araeaekorean },
    { 0x3200, glyph_kiyeokparenkorean },
    { 0x3201, glyph_nieunparenkorean },
    { 0x3202, glyph_tikeutparenkorean },
    { 0x3203, glyph_rieulparenkorean },
    { 0x3204, glyph_mieumparenkorean },
    { 0x3205, glyph_pieupparenkorean },
    { 0x3206, glyph_siosparenkorean },
    { 0x3207, glyph_ieungparenkorean },
    { 0x3208, glyph_cieucparenkorean },
    { 0x3209, glyph_chieuchparenkorean },
    { 0x320A, glyph_khieukhparenkorean },
    { 0x320B, glyph_thieuthparenkorean },
    { 0x320C, glyph_phieuphparenkorean },
    { 0x320D, glyph_hieuhparenkorean },
    { 0x320E, glyph_kiyeokaparenkorean },
    { 0x320F, glyph_nieunaparenkorean },
    { 0x3210, glyph_tikeutaparenkorean },
    { 0x3211, glyph_rieulaparenkorean },
    { 0x3212, glyph_mieumaparenkorean },
    { 0x3213, glyph_pieupaparenkorean },
    { 0x3214, glyph_siosaparenkorean },
    { 0x3215, glyph_ieungaparenkorean },
    { 0x3216, glyph_cieucaparenkorean },
    { 0x3217, glyph_chieuchaparenkorean },
    { 0x3218, glyph_khieukhaparenkorean },
    { 0x3219, glyph_thieuthaparenkorean },
    { 0x321A, glyph_phieuphaparenkorean },
    { 0x321B, glyph_hieuhaparenkorean },
    { 0x321C, glyph_cieucuparenkorean },
    { 0x3220, glyph_oneideographicparen },
    { 0x3221, glyph_twoideographicparen },
    { 0x3222, glyph_threeideographicparen },
    { 0x3223, glyph_fourideographicparen },
    { 0x3224, glyph_fiveideographicparen },
    { 0x3225, glyph_sixideographicparen },
    { 0x3226, glyph_sevenideographicparen },
    { 0x3227, glyph_eightideographicparen },
    { 0x3228, glyph_nineideographicparen },
    { 0x3229, glyph_tenideographicparen },
    { 0x322A, glyph_ideographicmoonparen },
    { 0x322B, glyph_ideographicfireparen },
    { 0x322C, glyph_ideographicwaterparen },
    { 0x322D, glyph_ideographicwoodparen },
    { 0x322E, glyph_ideographicmetalparen },
    { 0x322F, glyph_ideographicearthparen },
    { 0x3230, glyph_ideographicsunparen },
    { 0x3231, glyph_ideographicstockparen },
    { 0x3232, glyph_ideographichaveparen },
    { 0x3233, glyph_ideographicsocietyparen },
    { 0x3234, glyph_ideographicnameparen },
    { 0x3235, glyph_ideographicspecialparen },
    { 0x3236, glyph_ideographicfinancialparen },
    { 0x3237, glyph_ideographiccongratulationparen },
    { 0x3238, glyph_ideographiclaborparen },
    { 0x3239, glyph_ideographicrepresentparen },
    { 0x323A, glyph_ideographiccallparen },
    { 0x323B, glyph_ideographicstudyparen },
    { 0x323C, glyph_ideographicsuperviseparen },
    { 0x323D, glyph_ideographicenterpriseparen },
    { 0x323E, glyph_ideographicresourceparen },
    { 0x323F, glyph_ideographicallianceparen },
    { 0x3240, glyph_ideographicfestivalparen },
    { 0x3242, glyph_ideographicselfparen },
    { 0x3243, glyph_ideographicreachparen },
    { 0x3260, glyph_kiyeokcirclekorean },
    { 0x3261, glyph_nieuncirclekorean },
    { 0x3262, glyph_tikeutcirclekorean },
    { 0x3263, glyph_rieulcirclekorean },
    { 0x3264, glyph_mieumcirclekorean },
    { 0x3265, glyph_pieupcirclekorean },
    { 0x3266, glyph_sioscirclekorean },
    { 0x3267, glyph_ieungcirclekorean },
    { 0x3268, glyph_cieuccirclekorean },
    { 0x3269, glyph_chieuchcirclekorean },
    { 0x326A, glyph_khieukhcirclekorean },
    { 0x326B, glyph_thieuthcirclekorean },
    { 0x326C, glyph_phieuphcirclekorean },
    { 0x326D, glyph_hieuhcirclekorean },
    { 0x326E, glyph_kiyeokacirclekorean },
    { 0x326F, glyph_nieunacirclekorean },
    { 0x3270, glyph_tikeutacirclekorean },
    { 0x3271, glyph_rieulacirclekorean },
    { 0x3272, glyph_mieumacirclekorean },
    { 0x3273, glyph_pieupacirclekorean },
    { 0x3274, glyph_siosacirclekorean },
    { 0x3275, glyph_ieungacirclekorean },
    { 0x3276, glyph_cieucacirclekorean },
    { 0x3277, glyph_chieuchacirclekorean },
    { 0x3278, glyph_khieukhacirclekorean },
    { 0x3279, glyph_thieuthacirclekorean },
    { 0x327A, glyph_phieuphacirclekorean },
    { 0x327B, glyph_hieuhacirclekorean },
    { 0x327F, glyph_koreanstandardsymbol },
    { 0x328A, glyph_ideographmooncircle },
    { 0x328B, glyph_ideographfirecircle },
    { 0x328C, glyph_ideographwatercircle },
    { 0x328D, glyph_ideographwoodcircle },
    { 0x328E, glyph_ideographmetalcircle },
    { 0x328F, glyph_ideographearthcircle },
    { 0x3290, glyph_ideographsuncircle },
    { 0x3294, glyph_ideographnamecircle },
    { 0x3296, glyph_ideographicfinancialcircle },
    { 0x3298, glyph_ideographiclaborcircle },
    { 0x3299, glyph_ideographicsecretcircle },
    { 0x329D, glyph_ideographicexcellentcircle },
    { 0x329E, glyph_ideographicprintcircle },
    { 0x32A3, glyph_ideographiccorrectcircle },
    { 0x32A4, glyph_ideographichighcircle },
    { 0x32A5, glyph_ideographiccentrecircle },
    { 0x32A6, glyph_ideographiclowcircle },
    { 0x32A7, glyph_ideographicleftcircle },
    { 0x32A8, glyph_ideographicrightcircle },
    { 0x32A9, glyph_ideographicmedicinecircle },
    { 0x3300, glyph_apaatosquare },
    { 0x3303, glyph_aarusquare },
    { 0x3305, glyph_intisquare },
    { 0x330D, glyph_karoriisquare },
    { 0x3314, glyph_kirosquare },
    { 0x3315, glyph_kiroguramusquare },
    { 0x3316, glyph_kiromeetorusquare },
    { 0x3318, glyph_guramusquare },
    { 0x331E, glyph_kooposquare },
    { 0x3322, glyph_sentisquare },
    { 0x3323, glyph_sentosquare },
    { 0x3326, glyph_dorusquare },
    { 0x3327, glyph_tonsquare },
    { 0x332A, glyph_haitusquare },
    { 0x332B, glyph_paasentosquare },
    { 0x3331, glyph_birusquare },
    { 0x3333, glyph_huiitosquare },
    { 0x3336, glyph_hekutaarusquare },
    { 0x3339, glyph_herutusquare },
    { 0x333B, glyph_peezisquare },
    { 0x3342, glyph_hoonsquare },
    { 0x3347, glyph_mansyonsquare },
    { 0x3349, glyph_mirisquare },
    { 0x334A, glyph_miribaarusquare },
    { 0x334D, glyph_meetorusquare },
    { 0x334E, glyph_yaadosquare },
    { 0x3351, glyph_rittorusquare },
    { 0x3357, glyph_wattosquare },
    { 0x337B, glyph_heiseierasquare },
    { 0x337C, glyph_syouwaerasquare },
    { 0x337D, glyph_taisyouerasquare },
    { 0x337E, glyph_meizierasquare },
    { 0x337F, glyph_corporationsquare },
    { 0x3380, glyph_paampssquare },
    { 0x3381, glyph_nasquare },
    { 0x3382, glyph_muasquare },
    { 0x3383, glyph_masquare },
    { 0x3384, glyph_kasquare },
    { 0x3385, glyph_KBsquare },
    { 0x3386, glyph_MBsquare },
    { 0x3387, glyph_GBsquare },
    { 0x3388, glyph_calsquare },
    { 0x3389, glyph_kcalsquare },
    { 0x338A, glyph_pfsquare },
    { 0x338B, glyph_nfsquare },
    { 0x338C, glyph_mufsquare },
    { 0x338D, glyph_mugsquare },
    { 0x338E, glyph_squaremg },
    { 0x338F, glyph_squarekg },
    { 0x3390, glyph_Hzsquare },
    { 0x3391, glyph_khzsquare },
    { 0x3392, glyph_mhzsquare },
    { 0x3393, glyph_ghzsquare },
    { 0x3394, glyph_thzsquare },
    { 0x3395, glyph_mulsquare },
    { 0x3396, glyph_mlsquare },
    { 0x3397, glyph_dlsquare },
    { 0x3398, glyph_klsquare },
    { 0x3399, glyph_fmsquare },
    { 0x339A, glyph_nmsquare },
    { 0x339B, glyph_mumsquare },
    { 0x339C, glyph_squaremm },
    { 0x339D, glyph_squarecm },
    { 0x339E, glyph_squarekm },
    { 0x339F, glyph_mmsquaredsquare },
    { 0x33A0, glyph_cmsquaredsquare },
    { 0x33A1, glyph_squaremsquared },
    { 0x33A2, glyph_kmsquaredsquare },
    { 0x33A3, glyph_mmcubedsquare },
    { 0x33A4, glyph_cmcubedsquare },
    { 0x33A5, glyph_mcubedsquare },
    { 0x33A6, glyph_kmcubedsquare },
    { 0x33A7, glyph_moverssquare },
    { 0x33A8, glyph_moverssquaredsquare },
    { 0x33A9, glyph_pasquare },
    { 0x33AA, glyph_kpasquare },
    { 0x33AB, glyph_mpasquare },
    { 0x33AC, glyph_gpasquare },
    { 0x33AD, glyph_radsquare },
    { 0x33AE, glyph_radoverssquare },
    { 0x33AF, glyph_radoverssquaredsquare },
    { 0x33B0, glyph_pssquare },
    { 0x33B1, glyph_nssquare },
    { 0x33B2, glyph_mussquare },
    { 0x33B3, glyph_mssquare },
    { 0x33B4, glyph_pvsquare },
    { 0x33B5, glyph_nvsquare },
    { 0x33B6, glyph_muvsquare },
    { 0x33B7, glyph_mvsquare },
    { 0x33B8, glyph_kvsquare },
    { 0x33B9, glyph_mvmegasquare },
    { 0x33BA, glyph_pwsquare },
    { 0x33BB, glyph_nwsquare },
    { 0x33BC, glyph_muwsquare },
    { 0x33BD, glyph_mwsquare },
    { 0x33BE, glyph_kwsquare },
    { 0x33BF, glyph_mwmegasquare },
    { 0x33C0, glyph_kohmsquare },
    { 0x33C1, glyph_mohmsquare },
    { 0x33C2, glyph_amsquare },
    { 0x33C3, glyph_bqsquare },
    { 0x33C4, glyph_squarecc },
    { 0x33C5, glyph_cdsquare },
    { 0x33C6, glyph_coverkgsquare },
    { 0x33C7, glyph_cosquare },
    { 0x33C8, glyph_dbsquare },
    { 0x33C9, glyph_gysquare },
    { 0x33CA, glyph_hasquare },
    { 0x33CB, glyph_HPsquare },
    { 0x33CD, glyph_KKsquare },
    { 0x33CE, glyph_squarekmcapital },
    { 0x33CF, glyph_ktsquare },
    { 0x33D0, glyph_lmsquare },
    { 0x33D1, glyph_squareln },
    { 0x33D2, glyph_squarelog },
    { 0x33D3, glyph_lxsquare },
    { 0x33D4, glyph_mbsquare },
    { 0x33D5, glyph_squaremil },
    { 0x33D6, glyph_molsquare },
    { 0x33D8, glyph_pmsquare },
    { 0x33DB, glyph_srsquare },
    { 0x33DC, glyph_svsquare },
    { 0x33DD, glyph_wbsquare },
    { 0x5344, glyph_twentyhangzhou },
    { 0xF884, glyph_maihanakatleftthai },
    { 0xF885, glyph_saraileftthai },
    { 0xF886, glyph_saraiileftthai },
    { 0xF887, glyph_saraueleftthai },
    { 0xF888, glyph_saraueeleftthai },
    { 0xF889, glyph_maitaikhuleftthai },
    { 0xF88A, glyph_maiekupperleftthai },
    { 0xF88B, glyph_maieklowrightthai },
    { 0xF88C, glyph_maieklowleftthai },
    { 0xF88D, glyph_maithoupperleftthai },
    { 0xF88E, glyph_maitholowrightthai },
    { 0xF88F, glyph_maitholowleftthai },
    { 0xF890, glyph_maitriupperleftthai },
    { 0xF891, glyph_maitrilowrightthai },
    { 0xF892, glyph_maitrilowleftthai },
    { 0xF893, glyph_maichattawaupperleftthai },
    { 0xF894, glyph_maichattawalowrightthai },
    { 0xF895, glyph_maichattawalowleftthai },
    { 0xF896, glyph_thanthakhatupperleftthai },
    { 0xF897, glyph_thanthakhatlowrightthai },
    { 0xF898, glyph_thanthakhatlowleftthai },
    { 0xF899, glyph_nikhahitleftthai },
    { 0xFB20, glyph_ayinaltonehebrew },
    { 0xFB2E, glyph_alefpatahhebrew },
    { 0xFB2F, glyph_alefqamatshebrew },
    { 0xFB30, glyph_alefdageshhebrew },
    { 0xFB43, glyph_pefinaldageshhebrew },
    { 0xFB48, glyph_reshdageshhebrew },
    { 0xFB4C, glyph_betrafehebrew },
    { 0xFB4D, glyph_kafrafehebrew },
    { 0xFB4E, glyph_perafehebrew },
    { 0xFB4F, glyph_aleflamedhebrew },
    { 0xFB57, glyph_pehfinalarabic },
    { 0xFB58, glyph_pehinitialarabic },
    { 0xFB59, glyph_pehmedialarabic },
    { 0xFB67, glyph_ttehfinalarabic },
    { 0xFB68, glyph_ttehinitialarabic },
    { 0xFB69, glyph_ttehmedialarabic },
    { 0xFB6B, glyph_vehfinalarabic },
    { 0xFB6C, glyph_vehinitialarabic },
    { 0xFB6D, glyph_vehmedialarabic },
    { 0xFB7B, glyph_tchehfinalarabic },
    { 0xFB7C, glyph_tchehinitialarabic },
    { 0xFB7D, glyph_tchehmedialarabic },
    { 0xFB89, glyph_ddalfinalarabic },
    { 0xFB8B, glyph_jehfinalarabic },
    { 0xFB8D, glyph_rrehfinalarabic },
    { 0xFB93, glyph_gaffinalarabic },
    { 0xFB94, glyph_gafinitialarabic },
    { 0xFB95, glyph_gafmedialarabic },
    { 0xFB9F, glyph_noonghunnafinalarabic },
    { 0xFBA4, glyph_hehhamzaaboveisolatedarabic },
    { 0xFBA5, glyph_hehhamzaabovefinalarabic },
    { 0xFBA7, glyph_hehfinalaltonearabic },
    { 0xFBA8, glyph_hehinitialaltonearabic },
    { 0xFBA9, glyph_hehmedialaltonearabic },
    { 0xFBAF, glyph_yehbarreefinalarabic },
    { 0xFC08, glyph_behmeemisolatedarabic },
    { 0xFC0B, glyph_tehjeemisolatedarabic },
    { 0xFC0C, glyph_tehhahisolatedarabic },
    { 0xFC0E, glyph_tehmeemisolatedarabic },
    { 0xFC48, glyph_meemmeemisolatedarabic },
    { 0xFC4B, glyph_noonjeemisolatedarabic },
    { 0xFC4E, glyph_noonmeemisolatedarabic },
    { 0xFC58, glyph_yehmeemisolatedarabic },
    { 0xFC5E, glyph_shaddadammatanarabic },
    { 0xFC5F, glyph_shaddakasratanarabic },
    { 0xFC60, glyph_shaddafathaarabic },
    { 0xFC61, glyph_shaddadammaarabic },
    { 0xFC62, glyph_shaddakasraarabic },
    { 0xFC6D, glyph_behnoonfinalarabic },
    { 0xFC73, glyph_tehnoonfinalarabic },
    { 0xFC8D, glyph_noonnoonfinalarabic },
    { 0xFC94, glyph_yehnoonfinalarabic },
    { 0xFC9F, glyph_behmeeminitialarabic },
    { 0xFCA1, glyph_tehjeeminitialarabic },
    { 0xFCA2, glyph_tehhahinitialarabic },
    { 0xFCA4, glyph_tehmeeminitialarabic },
    { 0xFCC9, glyph_lamjeeminitialarabic },
    { 0xFCCA, glyph_lamhahinitialarabic },
    { 0xFCCB, glyph_lamkhahinitialarabic },
    { 0xFCCC, glyph_lammeeminitialarabic },
    { 0xFCD1, glyph_meemmeeminitialarabic },
    { 0xFCD2, glyph_noonjeeminitialarabic },
    { 0xFCD5, glyph_noonmeeminitialarabic },
    { 0xFCDD, glyph_yehmeeminitialarabic },
    { 0xFD3E, glyph_parenleftaltonearabic },
    { 0xFD3F, glyph_parenrightaltonearabic },
    { 0xFD88, glyph_lammeemhahinitialarabic },
    { 0xFDF2, glyph_lamlamhehisolatedarabic },
    { 0xFDFA, glyph_sallallahoualayhewasallamarabic },
    { 0xFE30, glyph_twodotleadervertical },
    { 0xFE31, glyph_emdashvertical },
    { 0xFE32, glyph_endashvertical },
    { 0xFE33, glyph_underscorevertical },
    { 0xFE34, glyph_wavyunderscorevertical },
    { 0xFE35, glyph_parenleftvertical },
    { 0xFE36, glyph_parenrightvertical },
    { 0xFE37, glyph_braceleftvertical },
    { 0xFE38, glyph_bracerightvertical },
    { 0xFE39, glyph_tortoiseshellbracketleftvertical },
    { 0xFE3A, glyph_tortoiseshellbracketrightvertical },
    { 0xFE3B, glyph_blacklenticularbracketleftvertical },
    { 0xFE3C, glyph_blacklenticularbracketrightvertical },
    { 0xFE3D, glyph_dblanglebracketleftvertical },
    { 0xFE3E, glyph_dblanglebracketrightvertical },
    { 0xFE3F, glyph_anglebracketleftvertical },
    { 0xFE40, glyph_anglebracketrightvertical },
    { 0xFE41, glyph_cornerbracketleftvertical },
    { 0xFE42, glyph_cornerbracketrightvertical },
    { 0xFE43, glyph_whitecornerbracketleftvertical },
    { 0xFE44, glyph_whitecornerbracketrightvertical },
    { 0xFE49, glyph_overlinedashed },
    { 0xFE4A, glyph_overlinecenterline },
    { 0xFE4B, glyph_overlinewavy },
    { 0xFE4C, glyph_overlinedblwavy },
    { 0xFE4D, glyph_lowlinedashed },
    { 0xFE4E, glyph_lowlinecenterline },
    { 0xFE4F, glyph_underscorewavy },
    { 0xFE50, glyph_commasmall },
    { 0xFE52, glyph_periodsmall },
    { 0xFE54, glyph_semicolonsmall },
    { 0xFE55, glyph_colonsmall },
    { 0xFE59, glyph_parenleftsmall },
    { 0xFE5A, glyph_parenrightsmall },
    { 0xFE5B, glyph_braceleftsmall },
    { 0xFE5C, glyph_bracerightsmall },
    { 0xFE5D, glyph_tortoiseshellbracketleftsmall },
    { 0xFE5E, glyph_tortoiseshellbracketrightsmall },
    { 0xFE5F, glyph_numbersignsmall },
    { 0xFE61, glyph_asterisksmall },
    { 0xFE62, glyph_plussmall },
    { 0xFE63, glyph_hyphensmall },
    { 0xFE64, glyph_lesssmall },
    { 0xFE65, glyph_greatersmall },
    { 0xFE66, glyph_equalsmall },
    { 0xFE69, glyph_dollarsmall },
    { 0xFE6A, glyph_percentsmall },
    { 0xFE6B, glyph_atsmall },
    { 0xFE82, glyph_alefmaddaabovefinalarabic },
    { 0xFE84, glyph_alefhamzaabovefinalarabic },
    { 0xFE86, glyph_wawhamzaabovefinalarabic },
    { 0xFE88, glyph_alefhamzabelowfinalarabic },
    { 0xFE8A, glyph_yehhamzaabovefinalarabic },
    { 0xFE8B, glyph_yehhamzaaboveinitialarabic },
    { 0xFE8C, glyph_yehhamzaabovemedialarabic },
    { 0xFE8E, glyph_aleffinalarabic },
    { 0xFE90, glyph_behfinalarabic },
    { 0xFE91, glyph_behinitialarabic },
    { 0xFE92, glyph_behmedialarabic },
    { 0xFE94, glyph_tehmarbutafinalarabic },
    { 0xFE96, glyph_tehfinalarabic },
    { 0xFE97, glyph_tehinitialarabic },
    { 0xFE98, glyph_tehmedialarabic },
    { 0xFE9A, glyph_thehfinalarabic },
    { 0xFE9B, glyph_thehinitialarabic },
    { 0xFE9C, glyph_thehmedialarabic },
    { 0xFE9E, glyph_jeemfinalarabic },
    { 0xFE9F, glyph_jeeminitialarabic },
    { 0xFEA0, glyph_jeemmedialarabic },
    { 0xFEA2, glyph_hahfinalarabic },
    { 0xFEA3, glyph_hahinitialarabic },
    { 0xFEA4, glyph_hahmedialarabic },
    { 0xFEA6, glyph_khahfinalarabic },
    { 0xFEA7, glyph_khahinitialarabic },
    { 0xFEA8, glyph_khahmedialarabic },
    { 0xFEAA, glyph_dalfinalarabic },
    { 0xFEAC, glyph_thalfinalarabic },
    { 0xFEAE, glyph_rehfinalarabic },
    { 0xFEB0, glyph_zainfinalarabic },
    { 0xFEB2, glyph_seenfinalarabic },
    { 0xFEB3, glyph_seeninitialarabic },
    { 0xFEB4, glyph_seenmedialarabic },
    { 0xFEB6, glyph_sheenfinalarabic },
    { 0xFEB7, glyph_sheeninitialarabic },
    { 0xFEB8, glyph_sheenmedialarabic },
    { 0xFEBA, glyph_sadfinalarabic },
    { 0xFEBB, glyph_sadinitialarabic },
    { 0xFEBC, glyph_sadmedialarabic },
    { 0xFEBE, glyph_dadfinalarabic },
    { 0xFEBF, glyph_dadinitialarabic },
    { 0xFEC0, glyph_dadmedialarabic },
    { 0xFEC2, glyph_tahfinalarabic },
    { 0xFEC3, glyph_tahinitialarabic },
    { 0xFEC4, glyph_tahmedialarabic },
    { 0xFEC6, glyph_zahfinalarabic },
    { 0xFEC7, glyph_zahinitialarabic },
    { 0xFEC8, glyph_zahmedialarabic },
    { 0xFECA, glyph_ainfinalarabic },
    { 0xFECB, glyph_aininitialarabic },
    { 0xFECC, glyph_ainmedialarabic },
    { 0xFECE, glyph_ghainfinalarabic },
    { 0xFECF, glyph_ghaininitialarabic },
    { 0xFED0, glyph_ghainmedialarabic },
    { 0xFED2, glyph_fehfinalarabic },
    { 0xFED3, glyph_fehinitialarabic },
    { 0xFED4, glyph_fehmedialarabic },
    { 0xFED6, glyph_qaffinalarabic },
    { 0xFED7, glyph_qafinitialarabic },
    { 0xFED8, glyph_qafmedialarabic },
    { 0xFEDA, glyph_kaffinalarabic },
    { 0xFEDB, glyph_kafinitialarabic },
    { 0xFEDC, glyph_kafmedialarabic },
    { 0xFEDE, glyph_lamfinalarabic },
    { 0xFEDF, glyph_laminitialarabic },
    { 0xFEE0, glyph_lammedialarabic },
    { 0xFEE2, glyph_meemfinalarabic },
    { 0xFEE3, glyph_meeminitialarabic },
    { 0xFEE4, glyph_meemmedialarabic },
    { 0xFEE6, glyph_noonfinalarabic },
    { 0xFEE7, glyph_nooninitialarabic },
    { 0xFEE8, glyph_noonmedialarabic },
    { 0xFEEB, glyph_hehinitialarabic },
    { 0xFEEC, glyph_hehmedialarabic },
    { 0xFEEE, glyph_wawfinalarabic },
    { 0xFEF0, glyph_alefmaksurafinalarabic },
    { 0xFEF2, glyph_yehfinalarabic },
    { 0xFEF5, glyph_lamalefmaddaaboveisolatedarabic },
    { 0xFEF6, glyph_lamalefmaddaabovefinalarabic },
    { 0xFEF7, glyph_lamalefhamzaaboveisolatedarabic },
    { 0xFEF8, glyph_lamalefhamzaabovefinalarabic },
    { 0xFEF9, glyph_lamalefhamzabelowisolatedarabic },
    { 0xFEFA, glyph_lamalefhamzabelowfinalarabic },
    { 0xFEFB, glyph_lamalefisolatedarabic },
    { 0xFEFC, glyph_lamaleffinalarabic },
    { 0xFEFF, glyph_zerowidthjoiner },
    { 0xFF01, glyph_exclammonospace },
    { 0xFF02, glyph_quotedblmonospace },
    { 0xFF03, glyph_numbersignmonospace },
    { 0xFF04, glyph_dollarmonospace },
    { 0xFF05, glyph_percentmonospace },
    { 0xFF06, glyph_ampersandmonospace },
    { 0xFF07, glyph_quotesinglemonospace },
    { 0xFF08, glyph_parenleftmonospace },
    { 0xFF09, glyph_parenrightmonospace },
    { 0xFF0A, glyph_asteriskmonospace },
    { 0xFF0B, glyph_plusmonospace },
    { 0xFF0C, glyph_commamonospace },
    { 0xFF0D, glyph_hyphenmonospace },
    { 0xFF0E, glyph_periodmonospace },
    { 0xFF0F, glyph_slashmonospace },
    { 0xFF10, glyph_zeromonospace },
    { 0xFF11, glyph_onemonospace },
    { 0xFF12, glyph_twomonospace },
    { 0xFF13, glyph_threemonospace },
    { 0xFF14, glyph_fourmonospace },
    { 0xFF15, glyph_fivemonospace },
    { 0xFF16, glyph_sixmonospace },
    { 0xFF17, glyph_sevenmonospace },
    { 0xFF18, glyph_eightmonospace },
    { 0xFF19, glyph_ninemonospace },
    { 0xFF1A, glyph_colonmonospace },
    { 0xFF1B, glyph_semicolonmonospace },
    { 0xFF1C, glyph_lessmonospace },
    { 0xFF1D, glyph_equalmonospace },
    { 0xFF1E, glyph_greatermonospace },
    { 0xFF1F, glyph_questionmonospace },
    { 0xFF20, glyph_atmonospace },
    { 0xFF21, glyph_Amonospace },
    { 0xFF22, glyph_Bmonospace },
    { 0xFF23, glyph_Cmonospace },
    { 0xFF24, glyph_Dmonospace },
    { 0xFF25, glyph_Emonospace },
    { 0xFF26, glyph_Fmonospace },
    { 0xFF27, glyph_Gmonospace },
    { 0xFF28, glyph_Hmonospace },
    { 0xFF29, glyph_Imonospace },
    { 0xFF2A, glyph_Jmonospace },
    { 0xFF2B, glyph_Kmonospace },
    { 0xFF2C, glyph_Lmonospace },
    { 0xFF2D, glyph_Mmonospace },
    { 0xFF2E, glyph_Nmonospace },
    { 0xFF2F, glyph_Omonospace },
    { 0xFF30, glyph_Pmonospace },
    { 0xFF31, glyph_Qmonospace },
    { 0xFF32, glyph_Rmonospace },
    { 0xFF33, glyph_Smonospace },
    { 0xFF34, glyph_Tmonospace },
    { 0xFF35, glyph_Umonospace },
    { 0xFF36, glyph_Vmonospace },
    { 0xFF37, glyph_Wmonospace },
    { 0xFF38, glyph_Xmonospace },
    { 0xFF39, glyph_Ymonospace },
    { 0xFF3A, glyph_Zmonospace },
    { 0xFF3B, glyph_bracketleftmonospace },
    { 0xFF3C, glyph_backslashmonospace },
    { 0xFF3D, glyph_bracketrightmonospace },
    { 0xFF3E, glyph_asciicircummonospace },
    { 0xFF3F, glyph_underscoremonospace },
    { 0xFF40, glyph_gravemonospace },
    { 0xFF41, glyph_amonospace },
    { 0xFF42, glyph_bmonospace },
    { 0xFF43, glyph_cmonospace },
    { 0xFF44, glyph_dmonospace },
    { 0xFF45, glyph_emonospace },
    { 0xFF46, glyph_fmonospace },
    { 0xFF47, glyph_gmonospace },
    { 0xFF48, glyph_hmonospace },
    { 0xFF49, glyph_imonospace },
    { 0xFF4A, glyph_jmonospace },
    { 0xFF4B, glyph_kmonospace },
    { 0xFF4C, glyph_lmonospace },
    { 0xFF4D, glyph_mmonospace },
    { 0xFF4E, glyph_nmonospace },
    { 0xFF4F, glyph_omonospace },
    { 0xFF50, glyph_pmonospace },
    { 0xFF51, glyph_qmonospace },
    { 0xFF52, glyph_rmonospace },
    { 0xFF53, glyph_smonospace },
    { 0xFF54, glyph_tmonospace },
    { 0xFF55, glyph_umonospace },
    { 0xFF56, glyph_vmonospace },
    { 0xFF57, glyph_wmonospace },
    { 0xFF58, glyph_xmonospace },
    { 0xFF59, glyph_ymonospace },
    { 0xFF5A, glyph_zmonospace },
    { 0xFF5B, glyph_braceleftmonospace },
    { 0xFF5C, glyph_barmonospace },
    { 0xFF5D, glyph_bracerightmonospace },
    { 0xFF5E, glyph_asciitildemonospace },
    { 0xFF61, glyph_periodhalfwidth },
    { 0xFF62, glyph_cornerbracketlefthalfwidth },
    { 0xFF63, glyph_cornerbracketrighthalfwidth },
    { 0xFF64, glyph_ideographiccommaleft },
    { 0xFF65, glyph_middledotkatakanahalfwidth },
    { 0xFF66, glyph_wokatakanahalfwidth },
    { 0xFF67, glyph_asmallkatakanahalfwidth },
    { 0xFF68, glyph_ismallkatakanahalfwidth },
    { 0xFF69, glyph_usmallkatakanahalfwidth },
    { 0xFF6A, glyph_esmallkatakanahalfwidth },
    { 0xFF6B, glyph_osmallkatakanahalfwidth },
    { 0xFF6C, glyph_yasmallkatakanahalfwidth },
    { 0xFF6D, glyph_yusmallkatakanahalfwidth },
    { 0xFF6E, glyph_yosmallkatakanahalfwidth },
    { 0xFF6F, glyph_tusmallkatakanahalfwidth },
    { 0xFF70, glyph_katahiraprolongmarkhalfwidth },
    { 0xFF71, glyph_akatakanahalfwidth },
    { 0xFF72, glyph_ikatakanahalfwidth },
    { 0xFF73, glyph_ukatakanahalfwidth },
    { 0xFF74, glyph_ekatakanahalfwidth },
    { 0xFF75, glyph_okatakanahalfwidth },
    { 0xFF76, glyph_kakatakanahalfwidth },
    { 0xFF77, glyph_kikatakanahalfwidth },
    { 0xFF78, glyph_kukatakanahalfwidth },
    { 0xFF79, glyph_kekatakanahalfwidth },
    { 0xFF7A, glyph_kokatakanahalfwidth },
    { 0xFF7B, glyph_sakatakanahalfwidth },
    { 0xFF7C, glyph_sikatakanahalfwidth },
    { 0xFF7D, glyph_sukatakanahalfwidth },
    { 0xFF7E, glyph_sekatakanahalfwidth },
    { 0xFF7F, glyph_sokatakanahalfwidth },
    { 0xFF80, glyph_takatakanahalfwidth },
    { 0xFF81, glyph_tikatakanahalfwidth },
    { 0xFF82, glyph_tukatakanahalfwidth },
    { 0xFF83, glyph_tekatakanahalfwidth },
    { 0xFF84, glyph_tokatakanahalfwidth },
    { 0xFF85, glyph_nakatakanahalfwidth },
    { 0xFF86, glyph_nikatakanahalfwidth },
    { 0xFF87, glyph_nukatakanahalfwidth },
    { 0xFF88, glyph_nekatakanahalfwidth },
    { 0xFF89, glyph_nokatakanahalfwidth },
    { 0xFF8A, glyph_hakatakanahalfwidth },
    { 0xFF8B, glyph_hikatakanahalfwidth },
    { 0xFF8C, glyph_hukatakanahalfwidth },
    { 0xFF8D, glyph_hekatakanahalfwidth },
    { 0xFF8E, glyph_hokatakanahalfwidth },
    { 0xFF8F, glyph_makatakanahalfwidth },
    { 0xFF90, glyph_mikatakanahalfwidth },
    { 0xFF91, glyph_mukatakanahalfwidth },
    { 0xFF92, glyph_mekatakanahalfwidth },
    { 0xFF93, glyph_mokatakanahalfwidth },
    { 0xFF94, glyph_yakatakanahalfwidth },
    { 0xFF95, glyph_yukatakanahalfwidth },
    { 0xFF96, glyph_yokatakanahalfwidth },
    { 0xFF97, glyph_rakatakanahalfwidth },
    { 0xFF98, glyph_rikatakanahalfwidth },
    { 0xFF99, glyph_rukatakanahalfwidth },
    { 0xFF9A, glyph_rekatakanahalfwidth },
    { 0xFF9B, glyph_rokatakanahalfwidth },
    { 0xFF9C, glyph_wakatakanahalfwidth },
    { 0xFF9D, glyph_nkatakanahalfwidth },
    { 0xFF9E, glyph_voicedmarkkanahalfwidth },
    { 0xFF9F, glyph_semivoicedmarkkanahalfwidth },
    { 0xFFE0, glyph_centmonospace },
    { 0xFFE1, glyph_sterlingmonospace },
    { 0xFFE3, glyph_macronmonospace },
    { 0xFFE5, glyph_yenmonospace },
    { 0xFFE6, glyph_wonmonospace },
}; /* tab_uni2diffagl */

/*  List of all ambiguous AGL version 1.2 glyph names
 *  (see chapter 4.c. Double-mappings in
 *   http://partners.adobe.com/asn/tech/type/unicodegn-old.jsp)
 */

static const pdc_glyph_tab tab_double_mappping[] =
{
#ifndef PDFLIB_EBCDIC
    { 0x0394, glyph_Delta },            /* Deltagreek */
    { 0x03A9, glyph_Omega },            /* Omegagreek */
    { 0xF6C1, glyph_Scedilla },         /* (CUS) */
    { 0x0162, glyph_Tcommaaccent },     /* (wrong mapping) */
    { 0x2215, glyph_fraction },         /* divisionslash */
    { 0x00AD, glyph_hyphen },           /* sfthyphen */
    { 0x02C9, glyph_macron },           /* firsttonechinese */
    { 0x03BC, glyph_mu },               /* mugreek */
    { 0x2219, glyph_periodcentered },   /* bulletoperator */
    { 0xF6C2, glyph_scedilla },         /* (CUS) */
    { 0x00A0, glyph_space },            /* nbspace */
    { 0x0163, glyph_tcommaaccent },     /* (wrong mapping) */
#else
#endif
};


/*  This is the list of all character names of the Adobe
 *  standard Latin character set and the set of named characters
 *  in the Symbol font, documented in Appendix D of PDF Reference.
 */

static const char *pc_standard_latin_charset[] =
{
#ifndef PDFLIB_EBCDIC
    glyph_A,
    glyph_AE,
    glyph_Aacute,
    glyph_Acircumflex,
    glyph_Adieresis,
    glyph_Agrave,
    glyph_Alpha,
    glyph_Aring,
    glyph_Atilde,
    glyph_B,
    glyph_Beta,
    glyph_C,
    glyph_Ccedilla,
    glyph_Chi,
    glyph_D,
    glyph_Delta,
    glyph_E,
    glyph_Eacute,
    glyph_Ecircumflex,
    glyph_Edieresis,
    glyph_Egrave,
    glyph_Epsilon,
    glyph_Eta,
    glyph_Eth,
    glyph_Euro,
    glyph_F,
    glyph_G,
    glyph_Gamma,
    glyph_H,
    glyph_I,
    glyph_Iacute,
    glyph_Icircumflex,
    glyph_Idieresis,
    glyph_Ifraktur,
    glyph_Igrave,
    glyph_Iota,
    glyph_J,
    glyph_K,
    glyph_Kappa,
    glyph_L,
    glyph_Lambda,
    glyph_Lslash,
    glyph_M,
    glyph_Mu,
    glyph_N,
    glyph_Ntilde,
    glyph_Nu,
    glyph_O,
    glyph_OE,
    glyph_Oacute,
    glyph_Ocircumflex,
    glyph_Odieresis,
    glyph_Ograve,
    glyph_Omega,
    glyph_Omicron,
    glyph_Oslash,
    glyph_Otilde,
    glyph_P,
    glyph_Phi,
    glyph_Pi,
    glyph_Psi,
    glyph_Q,
    glyph_R,
    glyph_Rfraktur,
    glyph_Rho,
    glyph_S,
    glyph_Scaron,
    glyph_Sigma,
    glyph_T,
    glyph_Tau,
    glyph_Theta,
    glyph_Thorn,
    glyph_U,
    glyph_Uacute,
    glyph_Ucircumflex,
    glyph_Udieresis,
    glyph_Ugrave,
    glyph_Upsilon,
    glyph_Upsilon1,
    glyph_V,
    glyph_W,
    glyph_X,
    glyph_Xi,
    glyph_Y,
    glyph_Yacute,
    glyph_Ydieresis,
    glyph_Z,
    glyph_Zcaron,
    glyph_Zeta,
    glyph_a,
    glyph_aacute,
    glyph_acircumflex,
    glyph_acute,
    glyph_adieresis,
    glyph_ae,
    glyph_agrave,
    glyph_aleph,
    glyph_alpha,
    glyph_ampersand,
    glyph_angle,
    glyph_angleleft,
    glyph_angleright,
    glyph_approxequal,
    glyph_aring,
    glyph_arrowboth,
    glyph_arrowdblboth,
    glyph_arrowdbldown,
    glyph_arrowdblleft,
    glyph_arrowdblright,
    glyph_arrowdblup,
    glyph_arrowdown,
    glyph_arrowhorizex,
    glyph_arrowleft,
    glyph_arrowright,
    glyph_arrowup,
    glyph_arrowvertex,
    glyph_asciicircum,
    glyph_asciitilde,
    glyph_asterisk,
    glyph_asteriskmath,
    glyph_at,
    glyph_atilde,
    glyph_b,
    glyph_backslash,
    glyph_bar,
    glyph_beta,
    glyph_braceex,
    glyph_braceleft,
    glyph_braceleftbt,
    glyph_braceleftmid,
    glyph_bracelefttp,
    glyph_braceright,
    glyph_bracerightbt,
    glyph_bracerightmid,
    glyph_bracerighttp,
    glyph_bracketleft,
    glyph_bracketleftbt,
    glyph_bracketleftex,
    glyph_bracketlefttp,
    glyph_bracketright,
    glyph_bracketrightbt,
    glyph_bracketrightex,
    glyph_bracketrighttp,
    glyph_breve,
    glyph_brokenbar,
    glyph_bullet,
    glyph_c,
    glyph_caron,
    glyph_carriagereturn,
    glyph_ccedilla,
    glyph_cedilla,
    glyph_cent,
    glyph_chi,
    glyph_circlemultiply,
    glyph_circleplus,
    glyph_circumflex,
    glyph_club,
    glyph_colon,
    glyph_comma,
    glyph_congruent,
    glyph_copyright,
    glyph_copyrightsans,
    glyph_copyrightserif,
    glyph_currency,
    glyph_d,
    glyph_dagger,
    glyph_daggerdbl,
    glyph_degree,
    glyph_delta,
    glyph_diamond,
    glyph_dieresis,
    glyph_divide,
    glyph_dollar,
    glyph_dotaccent,
    glyph_dotlessi,
    glyph_dotmath,
    glyph_e,
    glyph_eacute,
    glyph_ecircumflex,
    glyph_edieresis,
    glyph_egrave,
    glyph_eight,
    glyph_element,
    glyph_ellipsis,
    glyph_emdash,
    glyph_emptyset,
    glyph_endash,
    glyph_epsilon,
    glyph_equal,
    glyph_equivalence,
    glyph_eta,
    glyph_eth,
    glyph_exclam,
    glyph_exclamdown,
    glyph_existential,
    glyph_f,
    glyph_fi,
    glyph_five,
    glyph_fl,
    glyph_florin,
    glyph_four,
    glyph_fraction,
    glyph_g,
    glyph_gamma,
    glyph_germandbls,
    glyph_gradient,
    glyph_grave,
    glyph_greater,
    glyph_greaterequal,
    glyph_guillemotleft,
    glyph_guillemotright,
    glyph_guilsinglleft,
    glyph_guilsinglright,
    glyph_h,
    glyph_heart,
    glyph_hungarumlaut,
    glyph_hyphen,
    glyph_i,
    glyph_iacute,
    glyph_icircumflex,
    glyph_idieresis,
    glyph_igrave,
    glyph_infinity,
    glyph_integral,
    glyph_integralbt,
    glyph_integralex,
    glyph_integraltp,
    glyph_intersection,
    glyph_iota,
    glyph_j,
    glyph_k,
    glyph_kappa,
    glyph_l,
    glyph_lambda,
    glyph_less,
    glyph_lessequal,
    glyph_logicaland,
    glyph_logicalnot,
    glyph_logicalor,
    glyph_lozenge,
    glyph_lslash,
    glyph_m,
    glyph_macron,
    glyph_minus,
    glyph_minute,
    glyph_mu,
    glyph_multiply,
    glyph_n,
    glyph_nine,
    glyph_notelement,
    glyph_notequal,
    glyph_notsubset,
    glyph_ntilde,
    glyph_nu,
    glyph_numbersign,
    glyph_o,
    glyph_oacute,
    glyph_ocircumflex,
    glyph_odieresis,
    glyph_oe,
    glyph_ogonek,
    glyph_ograve,
    glyph_omega,
    glyph_omega1,
    glyph_omicron,
    glyph_one,
    glyph_onehalf,
    glyph_onequarter,
    glyph_onesuperior,
    glyph_ordfeminine,
    glyph_ordmasculine,
    glyph_oslash,
    glyph_otilde,
    glyph_p,
    glyph_paragraph,
    glyph_parenleft,
    glyph_parenleftbt,
    glyph_parenleftex,
    glyph_parenlefttp,
    glyph_parenright,
    glyph_parenrightbt,
    glyph_parenrightex,
    glyph_parenrighttp,
    glyph_partialdiff,
    glyph_percent,
    glyph_period,
    glyph_periodcentered,
    glyph_perpendicular,
    glyph_perthousand,
    glyph_phi,
    glyph_phi1,
    glyph_pi,
    glyph_plus,
    glyph_plusminus,
    glyph_product,
    glyph_propersubset,
    glyph_propersuperset,
    glyph_proportional,
    glyph_psi,
    glyph_q,
    glyph_question,
    glyph_questiondown,
    glyph_quotedbl,
    glyph_quotedblbase,
    glyph_quotedblleft,
    glyph_quotedblright,
    glyph_quoteleft,
    glyph_quoteright,
    glyph_quotesinglbase,
    glyph_quotesingle,
    glyph_r,
    glyph_radical,
    glyph_radicalex,
    glyph_reflexsubset,
    glyph_reflexsuperset,
    glyph_registered,
    glyph_registersans,
    glyph_registerserif,
    glyph_rho,
    glyph_ring,
    glyph_s,
    glyph_scaron,
    glyph_second,
    glyph_section,
    glyph_semicolon,
    glyph_seven,
    glyph_sigma,
    glyph_sigma1,
    glyph_similar,
    glyph_six,
    glyph_slash,
    glyph_space,
    glyph_spade,
    glyph_sterling,
    glyph_suchthat,
    glyph_summation,
    glyph_t,
    glyph_tau,
    glyph_therefore,
    glyph_theta,
    glyph_theta1,
    glyph_thorn,
    glyph_three,
    glyph_threequarters,
    glyph_threesuperior,
    glyph_tilde,
    glyph_trademark,
    glyph_trademarksans,
    glyph_trademarkserif,
    glyph_two,
    glyph_twosuperior,
    glyph_u,
    glyph_uacute,
    glyph_ucircumflex,
    glyph_udieresis,
    glyph_ugrave,
    glyph_underscore,
    glyph_union,
    glyph_universal,
    glyph_upsilon,
    glyph_v,
    glyph_w,
    glyph_weierstrass,
    glyph_x,
    glyph_xi,
    glyph_y,
    glyph_yacute,
    glyph_ydieresis,
    glyph_yen,
    glyph_z,
    glyph_zcaron,
    glyph_zero,
    glyph_zeta,
#else
#endif
};


/* --------------------------------- TET tables ---------------------------- */


#endif /* PC_CHARTABS_H */
