#!/bin/sh
# Convert .scm file to C string for easier embedding.

program="gen-c-string.sh"

if [ "x$1" = "x" ]; then
	cat <<EOF
Usage: $program [scheme-source]
Generage C string from scheme source file. Output is written to stdout.
EOF
	exit 1
fi

# convert 'foo.ss' to 'foo_ss'
filestr=`echo $1 | sed 's/\./_/g'`

echo "/* Generated with $program. Do not edit this file, edit $1 */"
echo "static const char ${filestr}_content[] ="
cat $1 | sed -e '/^\s*$/d' \
			 -e '/^[ \t]*;/d' \
			 -e 's/"/\\"/g' \
			 -e 's/\(.*\)/    " \1 "/' \
			 -e 's/
//g'
echo ';'
