/****************************************************************************
**
** Jreen
**
** Copyright © 2011 Ruslan Nigmatullin <euroelessar@yandex.ru>
**
*****************************************************************************
**
** $JREEN_BEGIN_LICENSE$
** Jreen is free software: you can redistribute it and/or modify
** it under the terms of the GNU Lesser General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** Jreen is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public License
** along with Jreen.  If not, see <http://www.gnu.org/licenses/>.
** $JREEN_END_LICENSE$
**
****************************************************************************/

#include "pubsubevent.h"
#include "pubsubmanager_p.h"

namespace Jreen
{
namespace PubSub
{
class EventPrivate
{
public:
	QList<Payload::Ptr> items;
	QString node;
};

Event::Event(const QString &node) : d_ptr(new EventPrivate)
{
	Q_D(Event);
	d->node = node;
}

Event::Event(const Payload::Ptr &item) : d_ptr(new EventPrivate)
{
	Q_D(Event);
	d->items << item;
}

Event::Event(const QList<Payload::Ptr> &items) : d_ptr(new EventPrivate)
{
	Q_D(Event);
	d->items = items;
}

Event::~Event()
{
}

void Event::setNode(const QString &node)
{
	d_func()->node = node;
}

QString Event::node() const
{
	return d_func()->node;
}

void Event::addItem(Payload *item)
{
	d_func()->items << Payload::Ptr(item);
}

void Event::addItem(const Payload::Ptr &item)
{
	d_func()->items << item;
}

QList<Payload::Ptr> Event::items() const
{
	return d_func()->items;
}
}
}
