/* files */
#define CONFIG_BUILD "3.15.0a"
#ifndef CONFIG_BUILD
# define CONFIG_BUILD BUILD
#endif
#define TAG "" 

////////////////////////////   Configuration files   /////////////////////////////////
//

#define DEFAULT_DESKTOP_DIR	USER_DIR,_("Desktop")
#define USER_DIR 		g_get_home_dir()
#define USER_PIXMAPS		g_get_user_config_dir(), "pixmaps"
#define USER_RFM_DIR            g_get_user_config_dir(),"rfm"
#define USER_RFM_CACHE_DIR      g_get_user_cache_dir(),"rfm"
#define USER_DBH_DIR		USER_RFM_DIR,"dbh"
#define USER_DBH_CACHE_DIR	USER_RFM_CACHE_DIR,"dbh"
#define SYSTEM_MODULE_DIR	PACKAGE_DATA_DIR,"rfm","rmodules"
#define RFM_THUMBNAIL_DIR 	USER_RFM_CACHE_DIR,"thumbnails"

//
// Environment configuration file (shared via MIT-shm)
#define MCS_FILE_NAME		"rfm-"CONFIG_BUILD
#define MCS_SHM_PLUGIN_FILE 	USER_RFM_DIR,MCS_FILE_NAME

// Keybind customization file	
#define KEYBINDINGS_FILE 	USER_RFM_DIR,"keybind-6224.xml"
#define KEYBINDINGS_SCHEMA 	SYSTEM_MODULE_DIR,"keybind.xsd"

//############################################
//   dbh files and associated record structure
//############################################
/**************************************************************/
/////////////////////  history_dbh_t /////////////////////////
/**************************************************************/
// This structure could be optimized to a token separated string
// 
typedef struct history_dbh_t {
    gint64 hits;  // 32/64 issue: gint
    gint64 last_hit; // time_t last_hit;
    gchar path[256];
} history_dbh_t;
// Goto dialog history
#define GOTO_DBH_FILE 		USER_DBH_CACHE_DIR,"go_hash.dbh"
// Run dialog history
#define RUN_DBH_FILE 		USER_DBH_CACHE_DIR,"run_hash.dbh"
// Workdir dialog history
#define WORKDIR_DBH_FILE 	USER_DBH_CACHE_DIR,"workdir_hash.dbh"
// Fgr module history autocompletion
#define FIND_DBH_FILE 		USER_DBH_CACHE_DIR,"fgr_path_hash.dbh"
#define FIND_PATHS_DBH_FILE 	USER_DBH_CACHE_DIR,"fgr_filter_hash.dbh"
#define FIND_GREP_DBH_FILE 	USER_DBH_CACHE_DIR,"fgr_content_hash.dbh"
// ...
#define LS_DBH_FILE	 	USER_DBH_CACHE_DIR,"ls_path_hash.dbh"
// Callbacks mount point dialog files
#define MOUNT_DBH_FILE 		USER_DBH_CACHE_DIR,"mountdir_hash.dbh"


// dbh preferences (Not environment)
/**************************************************************/
/////////////////////  view_geometry_t /////////////////////////
/**************************************************************/
typedef struct view_geometry_t {
    gint64 scrollX;
    gint64 x;
    gint64 y;
    gint64 w;
    gint64 h;
} view_geometry_t;
#define GRID_GEOMETRY_FILE 	USER_DBH_DIR,"geometry64.dbh"
#define DESK_GEOMETRY_FILE 	USER_DBH_DIR,"deskview_geometry64.dbh"

/**************************************************************/
/////////////////////  view_preferences_t //////////////////////
/**************************************************************/
typedef struct view_preferences_t {
    gint64 preferences;
    gint64 sortcolumn;
    gint64 icon_size;
} view_preferences_t;
#define GRID_PREFERENCES_FILE 	USER_DBH_DIR,"preferences64.dbh"
#define DESK_PREFERENCES_FILE 	USER_DBH_DIR,"preferences-desk64.dbh"

/**************************************************************/
/////////////////////   //////////////////////
/**************************************************************/
// Run dialog flags
// gint64 flags[2]
#define RUN_FLAG_FILE 		USER_DBH_CACHE_DIR,"runflag64.dbh"

/**************************************************************/
/////////////////////   //////////////////////
/**************************************************************/
// User defined mount types (local or monitor) in fstab plugin
// gint64 type
#define MOUNT_TYPE_DBH_FILE	USER_DBH_CACHE_DIR,"mounttype64.dbh"

/**************************************************************/
/////////////////////  caches //////////////////////
/**************************************************************/
typedef struct  mime_winner_dbh_t {
    gint64 st_sum;
    gchar mimetype[80];
} mime_winner_dbh_t;
#define MIME_COUNT_DBH_FILE 	USER_DBH_CACHE_DIR,"mimecount64.dbh"
// string hash
#define ICON_ID_DBH_FILE 	USER_DBH_CACHE_DIR,"icon_id64.dbh"
#define ICON_ID_PLAIN_DBH_FILE 	USER_DBH_CACHE_DIR,"icon_id_plain64.dbh"


//
////////////////////////////   Cache files   /////////////////////////////////////////
// General cache directory
#define SETUP_FILE 		USER_RFM_DIR,"rodent-"BUILD
// DBH cache file for content emblems
//
////////////////////////////   Data files   /////////////////////////////////////////
//
// Dialogs...
// Lp terminal history cache
#define LP_TERMINAL_HISTORY 	USER_RFM_CACHE_DIR,"lp_terminal_history"
// Modules...
// Icon module xml files
#define ICON_MODULE_USER_XML	USER_RFM_DIR,"icons-2.mime.xml"
#define ICON_MODULE_XML		SYSTEM_MODULE_DIR, "icons.mime.xml"
#define RODENT_THEME		PACKAGE_DATA_DIR,"icons","Rodent"
// Mime module files
#define APPLICATION_MIME_FILE 	SYSTEM_MODULE_DIR,"mime-module.xml"
#define USER_APPLICATIONS 	USER_RFM_DIR,"user-applications.2"
#define MOUNT_HISTORY_FILE 	USER_RFM_DIR,"mountdir.txt"
// Plugins...
// Fuse plugin keyfile
#define FUSE_KEY_FILE		USER_RFM_DIR,"fuse.ini"
// Bookmarks file (default gtk site)
#define BOOKMARKS_FILE		USER_DIR,".gtk-bookmarks"


