//
//
/*
 * Copyright (C) 2006-11 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc..
 */

#ifndef MODULE_SKELETON_H
#define MODULE_SKELETON_H

#ifndef MODULE_NAME
#error "MODULE_NAME is not defined"
#endif

#ifndef MODULE_LABEL
#error "MODULE_LABEL is not defined"
#endif

#ifndef MODULE_ICON_ID
//#error "MODULE_ICON_ID is not defined"
#endif
////////////// Specific module initialization function 
	
#define BIND_TEXT_DOMAIN \
    bindtextdomain (GETTEXT_PACKAGE,PACKAGE_LOCALE_DIR);\
//    TRACE("BIND_TEXT_DOMAIN(): textdomain=%s locale_dir=%s\n", textdomain(NULL), bindtextdomain(textdomain(NULL), NULL));
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
#define BIND_TEXTDOMAIN_CODESET \
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#else 
#define BIND_TEXTDOMAIN_CODESET 
#endif
 
#ifdef ENABLE_NLS 
#define RFM_G_MODULE_CHECK_INIT const gchar * \
g_module_check_init(GModule *module){\
    BIND_TEXT_DOMAIN \
    BIND_TEXTDOMAIN_CODESET \
    return NULL;\
}
#else 
#define RFM_G_MODULE_CHECK_INIT const gchar * \
g_module_check_init(GModule *module){\
    return NULL;\
}
#endif




#define RFM_BLOCKING_LOAD(x) void * \
blocking_load (void) { \
    if (x) return GINT_TO_POINTER(1); \
    return GINT_TO_POINTER(-1); \
}

#define RFM_MONITOR_RELOAD(x) void * \
reload (void *p) { \
    return GINT_TO_POINTER(-1); \
}

#define RFM_MODULE_PAUSE(x) void * \
monitor_pause (void *p) { \
    return GINT_TO_POINTER(-1); \
}

# define RFM_MODULE_RELOAD(x) void *\
reload(void *p){\
    return GINT_TO_POINTER(x);\
}

# define RFM_MODULE_SKIPWAIT(x) void *\
skipwait(void *p){\
    return GINT_TO_POINTER(x);\
}


// gchar *
// Returns the module entry tip text. 
#ifdef MODULE_ENTRY_TIP
# define RFM_MODULE_ENTRY_TIP  void * \
module_entry_tip (void) {\
    return g_strdup(MODULE_ENTRY_TIP);\
}
#else
# define RFM_MODULE_ENTRY_TIP  void * \
module_entry_tip (void) {\
    return g_strdup("FIXME: macro \"MODULE_ENTRY_TIP\" is not defined.");\
}
#endif

//  gchar *  
// This function returns a newly allocated string with the module label.
// Rodent uses this to construct the name which appears under the icon
// at the rodent root level, and to set window title and icon name when 
// the module is loaded.
// Returned value should be freed when no longer used.
# define RFM_MODULE_LABEL void *\
module_label(void){\
    return g_strdup(MODULE_LABEL);\
}

// const gchar * 
// This function informs caller of the module's icon identifier.
// Identifier may be a mimetype or an absolute path.
# define RFM_MODULE_ICON_ID void *\
module_icon_id(void){\
    return MODULE_ICON_ID; \
}

 
// gboolean  
// This function informs caller if module is installed or not. 
#define RFM_MODULE_ACTIVE(x) void *\
module_active (void){\
    return GINT_TO_POINTER(x);\
}

// gboolean  
// This function determines whether or not rodent will spawn
// a monitor thread.
#define RFM_MODULE_MONITOR(x) void *\
module_monitor (void) {\
    return GINT_TO_POINTER (x);\
}

// const gchar *
// This returns a key to set a single preference for all module levels
#define RFM_MODULE_PREFERENCES_KEY(x) void *\
module_preferences_key (void) {\
    return x;\
}

// const gchar * 
// This function informs caller of the module parent plugin name.
// This is the name of the library. It should match whatever
// was choosen in the Makefile, without the "lib" prefix. For example,
// a plugin located at "libfoo.so.0.0.0" should return "foo".
#define RFM_MODULE_NAME void * \
module_name(void){ \
    return MODULE_NAME;\
}

// const gchar * 
// This function informs caller of the module parent plugin name.
// If the elements returned by the module correspond to
// other plugins, you should return the name of the plugin that
// should be used to load each element in turn. The name should 
// follow the rules of the module_name() function.
#ifdef SUBMODULE_NAME
# define RFM_SUBMODULE_NAME void *\
submodule_name(void){\
    return SUBMODULE_NAME;\
}
# else 
# define RFM_SUBMODULE_NAME void *\
submodule_name(void){\
    return MODULE_NAME;\
}
#endif

// gboolean  
// This function informs caller if module is a root module or not.
#define RFM_IS_ROOT_MODULE(x) void *\
is_root_module(void){\
    return GINT_TO_POINTER(x);\
}

//  gchar *  
// This function returns a newly allocated string with the general information
// of the module. Rodent uses this to construct the popup tip. Returned value
// should be freed when no longer used.
#define RFM_PLUGIN_INFO(x) void *\
plugin_info(void){\
    return g_strdup_printf("%s\n", x);\
}

// gboolean  
// This function informs Rodent if the entry (parameter p) is a 
// selectable icon or not.
#define RFM_IS_SELECTABLE(x) void *\
is_selectable(void *p){\
	return GINT_TO_POINTER(x);\
}

// gboolean  
// This function processes the double click action on the
// icon's label. If it returns FALSE, then the default
// Rodent action for label click is performed. The default
// Rodent action checks for file existance to do a rename
// entry (or symlink or duplicate).
// Parameter p is the item's entry pointer. 
#define RFM_LABEL_CLICK(x) void *\
label_click (void *p) {\
    return  GINT_TO_POINTER(x);\
}


// const gchar * 
// This function returns a const pointer to the entry's icon
// identifier. 
// Parameter p is the item's entry pointer. 
// Identifier may be returned as a mimetype or an absolute path.
#define RFM_ITEM_ICON_ID void *\
item_icon_id (void *p){\
    record_entry_t *en=(record_entry_t *)p;\
    if (!en) return "xffm/emblem_broken"; /* Error.*/ \
    if (strcmp(en->path, MODULE_LABEL)==0) {\
	return MODULE_ICON_ID;\
    }\
    return "xffm/emblem_broken"; /* Error.*/ \
}

#ifdef PARENT_MODULE_NAME
#define FLAG_KEY(x)  g_strdup_printf("FLAG_%d", x)

#endif


#endif

