#ifndef PRIMARY_MODULES_H
# define PRIMARY_MODULES_H

# include <gtk/gtk.h>


RfmProgramOptions *rfm_get_lite_module_options(void);
RfmProgramOptions *rfm_get_lite_plugin_options(void);


#define PLUGIN_DIR rfm_plugin_dir()
const gchar *rfm_set_plugin_dir(const gchar *libdir, const gchar *dir);
const gchar *rfm_plugin_dir(void);

// Deprecated: rfm_set_module_dir()
const gchar *rfm_set_module_dir(const gchar *libdir, const gchar *dir);

void 
rfm_destroy_module_hash(void);

const gchar *
rfm_get_module_popup_id(void);

void
  rfm_sanity_check (int argc, char **argv, int librfm_serial);

void *
  rfm_void (const gchar * librarydir, const gchar * module_name, 
	  const gchar * function_id);

/* integers */
void *
  rfm_natural (const gchar * librarydir, const gchar * module_name, 
	  void *p, const gchar * function_id);

/* rationals */
void *
  rfm_rational (const gchar * librarydir, const gchar * module_name, 
	  void *p, void *q, const gchar * function_id);

/* complex */
void *
  rfm_complex (const gchar * librarydir, const gchar * module_name, 
	  void *p, void *q, void *r, const gchar * function_id);

void *
rfm_vector_run(const gchar * librarydir, const gchar * module_name, 
	void *vector_size_p, const void **vector, const gchar *function_id);

GSList *
  rfm_find_plugins (void);

gchar * 
rfm_get_plugin_label(const gchar *module_name);

const gchar * 
rfm_get_plugin_icon(const gchar *module_name);

gboolean 
rfm_is_root_plugin(const gchar *module_name);

void
rfm_unload_module (const gchar * module_name);

#endif
