/////   popup callbacks... ///
//
// Migration to thread pools
//
//Step 1: Merge all callbacks with NULL data into a single callback with the callback id as the data.
//Step 2: Change all callbacks with defined data into separate callbacks with NULL data.
//Step 3: Merge new callbacks into the single callback
//Step 4: Use a thread pool to call the single callback and lose the later thread creation. RFM_CALLBACK_THREAD_POOL_MAX=3
//NOTES: Lose the population_readlock. Use view_p->selection_list, with a RW lock. Make a copy of the list and free on thread return.
//
// Rodent create popup by thread: should a shared threadpool as well, so that popup creation thread may be reused.
//
#ifndef RODENT_POPUP_CALLBACKS_H
#define RODENT_POPUP_CALLBACKS_H

#define DO_VALID_VIEW_ENTRY	0x01
#define DO_READ_LOCK		0x02
#define DO_SINGLE_SELECTION	0x04
#define DO_MULTIPLE_SELECTION	0x08

void 
rodent_menu_callback(GtkMenuItem * menuitem, gpointer user_data);

gboolean 
rodent_do_callback(guint keyval, guint state);

void
rodent_callback_by_id (GtkMenuItem * menuitem, gpointer user_data);


#endif
