/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "rodent.h"
#include "rfm_modules.h"

static gint initialized=0;
void rodent_init(void){
    initialized = 1;
    return;
}

static RodentButtonDefinition 
button_callbacks[]={
    {NEW_FILE_CALLBACK_BUTTON_ID, "NEW_FILE_CALLBACK_button", NEW_FILE_CALLBACK, NULL},
    {NEWDIR_CALLBACK_BUTTON_ID, "NEWDIR_CALLBACK_button", NEWDIR_CALLBACK, NULL},
    {NEW_TAB_CALLBACK_BUTTON_ID, "NEW_TAB_CALLBACK_button", NEW_TAB_CALLBACK, NULL},  
    {NEW_WINDOW_CALLBACK_BUTTON_ID, "NEW_WINDOW_CALLBACK_button", NEW_WINDOW_CALLBACK, NULL},
    {LS_CALLBACK_BUTTON_ID, "LS_CALLBACK_button", LS_CALLBACK, NULL},
    {ABOUT_CALLBACK_BUTTON_ID, "ABOUT_CALLBACK_button", ABOUT_CALLBACK, NULL},
    {JUMP_TO_CALLBACK_BUTTON_ID, "JUMP_TO_CALLBACK_button", JUMP_TO_CALLBACK, NULL},
    {GOTO_HOST_CALLBACK_BUTTON_ID, "GOTO_HOST_CALLBACK_button", GOTO_HOST_CALLBACK, NULL},
    {GOTO_HOME_CALLBACK_BUTTON_ID, "GOTO_HOME_CALLBACK_button", GOTO_HOME_CALLBACK, NULL},
    {GO_UP_CALLBACK_BUTTON_ID, "GO_UP_CALLBACK_button", GO_UP_CALLBACK, NULL},
    {GO_BACK_CALLBACK_BUTTON_ID, "GO_BACK_CALLBACK_button", GO_BACK_CALLBACK, NULL},
    {GO_FORWARD_CALLBACK_BUTTON_ID, "GO_FORWARD_CALLBACK_button", GO_FORWARD_CALLBACK, NULL},
    {CUT_CALLBACK_BUTTON_ID, "CUT_CALLBACK_button", CUT_CALLBACK, NULL},
    {COPY_CALLBACK_BUTTON_ID, "COPY_CALLBACK_button", COPY_CALLBACK, NULL},
    {PASTE_CALLBACK_BUTTON_ID, "PASTE_CALLBACK_button", PASTE_CALLBACK, NULL},
    {REMOVE_CALLBACK_BUTTON_ID, "REMOVE_CALLBACK_button", REMOVE_CALLBACK, NULL},
    {TOGGLE_BOOKMARK_CALLBACK_BUTTON_ID, "TOGGLE_BOOKMARK_CALLBACK_button", TOGGLE_BOOKMARK_CALLBACK, NULL},
    {HELP_CALLBACK_BUTTON_ID, "HELP_CALLBACK_button", HELP_CALLBACK, NULL},
    {SETTINGS_CALLBACK_BUTTON_ID, "SETTINGS_CALLBACK_button", SETTINGS_CALLBACK, NULL},
    {TERMINAL_CALLBACK_BUTTON_ID, "TERMINAL_CALLBACK_button", TERMINAL_CALLBACK, NULL},
    {REFRESH_CALLBACK_BUTTON_ID, "REFRESH_CALLBACK_button", REFRESH_CALLBACK, NULL},
    {RUN_CALLBACK_BUTTON_ID, "RUN_CALLBACK_button", RUN_CALLBACK, NULL},
    {FIND_CALLBACK_BUTTON_ID, "FIND_CALLBACK_button", FIND_CALLBACK, NULL},
    {DIFFERENCES_CALLBACK_BUTTON_ID, "DIFFERENCES_CALLBACK_button", DIFFERENCES_CALLBACK, NULL},
    {SORT_ASCENDING_CALLBACK_BUTTON_ID, "Ascending_button", SORT_ASCENDING_CALLBACK, NULL},
    {SORT_DESCENDING_CALLBACK_BUTTON_ID, "Descending_button", SORT_DESCENDING_CALLBACK, NULL},
    {KEYBINDINGS_CALLBACK_BUTTON_ID, "KEYBINDINGS_CALLBACK_button", KEYBINDINGS_CALLBACK, NULL},
    {SELECT_ALL_CALLBACK_BUTTON_ID, "SELECT_ALL_CALLBACK_button", SELECT_ALL_CALLBACK, NULL},
    {SELECT_INVERT_CALLBACK_BUTTON_ID, "SELECT_INVERT_CALLBACK_button", SELECT_INVERT_CALLBACK, NULL},
    {UNSELECT_ALL_CALLBACK_BUTTON_ID, "UNSELECT_ALL_CALLBACK_button", UNSELECT_ALL_CALLBACK, NULL},
    {SELECT_BYFILTER_CALLBACK_BUTTON_ID, "SELECT_BYFILTER_CALLBACK_button", SELECT_BYFILTER_CALLBACK, NULL},
    {UNSELECT_BYFILTER_CALLBACK_BUTTON_ID, "UNSELECT_BYFILTER_CALLBACK_button", UNSELECT_BYFILTER_CALLBACK, NULL},
    {TYPE_SORT_CALLBACK_BUTTON_ID, "Type_button", TYPE_SORT_CALLBACK,  N_("Type")},
    {NAME_SORT_CALLBACK_BUTTON_ID, "Name_button", NAME_SORT_CALLBACK, N_("Name")},
    {DATE_SORT_CALLBACK_BUTTON_ID, "Date_button", DATE_SORT_CALLBACK, N_("Date")},
    {SIZE_SORT_CALLBACK_BUTTON_ID, "Size_button", SIZE_SORT_CALLBACK, N_("Size")},
    {OWNER_SORT_CALLBACK_BUTTON_ID, "Owner_button", OWNER_SORT_CALLBACK, N_("Owner")},
    {GROUP_SORT_CALLBACK_BUTTON_ID, "Group_button", GROUP_SORT_CALLBACK, N_("Group")},
    {MODE_SORT_CALLBACK_BUTTON_ID, "Mode_button", MODE_SORT_CALLBACK, N_("Mode")},
    {CASE_SORT_CALLBACK_BUTTON_ID, "case_insensitive_button", CASE_SORT_CALLBACK, NULL},
    {DEFAULT_ICONSIZE_CALLBACK_BUTTON_ID, "DEFAULT_ICONSIZE_CALLBACK_button", DEFAULT_ICONSIZE_CALLBACK, NULL},
    {DEFAULT_ICONSIZE_ALL_CALLBACK_BUTTON_ID, "DEFAULT_ICONSIZE_ALL_CALLBACK_button", DEFAULT_ICONSIZE_ALL_CALLBACK, NULL},
    {COMPACT_ICONSIZE_CALLBACK_BUTTON_ID, "List_button", COMPACT_ICONSIZE_CALLBACK, N_("List")},
    {TINY_ICONSIZE_CALLBACK_BUTTON_ID, "Tiny_button", TINY_ICONSIZE_CALLBACK, N_("Tiny")},
    {NORMAL_ICONSIZE_CALLBACK_BUTTON_ID, "Normal_button", NORMAL_ICONSIZE_CALLBACK, N_("Normal")},
    {BIG_ICONSIZE_CALLBACK_BUTTON_ID, "Big_button", BIG_ICONSIZE_CALLBACK, N_("Big")},
    {HUGE_ICONSIZE_CALLBACK_BUTTON_ID, "Huge_button", HUGE_ICONSIZE_CALLBACK, N_("Huge")},
    {PLUS_ICONSIZE_CALLBACK_BUTTON_ID, "PLUS_ICONSIZE_CALLBACK_button", PLUS_ICONSIZE_CALLBACK, NULL},
    {MINUS_ICONSIZE_CALLBACK_BUTTON_ID, "MINUS_ICONSIZE_CALLBACK_button", MINUS_ICONSIZE_CALLBACK, NULL},
    {SHOW_HIDDEN_CALLBACK_BUTTON_ID, "show_hidden_button", SHOW_HIDDEN_CALLBACK, NULL},
    {SHOW_BACKUP_CALLBACK_BUTTON_ID, "show_backup_button", SHOW_BACKUP_CALLBACK, NULL},
    {PREVIEW_IMAGES_CALLBACK_BUTTON_ID, "show_previews_button", PREVIEW_IMAGES_CALLBACK, NULL},
    {NEW_TAB_CALLBACK_B_BUTTON_ID, "NEW_TAB_CALLBACK_B_button", NEW_TAB_CALLBACK_B, NULL}, // last one < 64 
    {-1, NULL, NULL_CALLBACK, NULL}
};


RodentButtonDefinition *
rodent_get_button_definitions(void){return button_callbacks;}
