#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "debug.h"

#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef HAVE_WINDOWS_H
#include <windows.h>
#endif

#ifdef HAVE_PROCESS_H
#include <process.h>
#endif

#ifdef HAVE_PROCESS_H
#include <process.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <glib.h>
#include "tubo.h"

// thread function
void
stdout_f (void *user_data, void *stream, int childFD) {
    char *which = user_data;
    char *line;
    line = (char *)stream;

    //if(line[0] == '\n') return;
    if (strchr(line, '\n')) *strchr(line, '\n')=0;
    gchar *g = g_strdup(line);
    int i;
    for (i=0; i<strlen(line); i++){
        g[strlen(line)-i-1] = line[i];
    }

    fprintf(stdout, "%s (0x%x) processing: %s -> %s\n", 
            which, getpid(), line, g); 

 //   DBG( "%s (0x%x:0x%lx) processing: %s -> %s\n", 
   //         which, getpid(), (long)(pthread_self()), line, g); 
    g_free(g);
    fflush(stdout);
    return;
}

static
void
run_fork_finished_function (void *user_data) {
    fprintf (stderr,"%s: at run_fork_finished_function() now...\n", (char *)user_data);
    DBG( "thread_id 0x%x: run_fork_finished_function!\n",getpid());
    fprintf(stdout, "command (exit to end):");fflush(stdout);

}
#ifdef HAVE_MMAP
#define MAX_COMMAND_ARGS 1024
static void
fork_function (void *data) {
    char **argv = (char **)data;
    
    DBG( "0x%x: thread executing: ",getpid());
    int i;
    for (i=0; argv[i]; i++){
	DBG( "%s ", argv[i]);
    }
    DBG( "\n");
    fflush(stderr);
    execvp (argv[0], (char * const *)argv);
    DBG( "CHILD could not execvp: this should not happen\n");
    DBG( "Do you have %s in your path?\n", argv[0]);
    _exit (123);
}


static void forkit(char **arg){
    DBG( "-- > Tubo_fork: Main process id = 0x%x\n",getpid());
    int flags = TUBO_REAP_CHILD|TUBO_VALID_ANSI;
    pid_t child = Tubo_fork (fork_function,
                                (void *)(arg),
                                NULL,
                                stdout_f,
                                NULL,
                                run_fork_finished_function,
                                "Tubo_fork",
                                flags);
    DBG( "Child process id= 0x%x\n", child);
    DBG( "Controller process id= 0x%x (Tubo_child)\n", Tubo_controller(child));
    DBG( "Tubo_id() = 0x%x \n", Tubo_id());


   /* if TUBO_REAP_CHILD is not set you must reap the child yourself: */
    if (flags & TUBO_REAP_CHILD);
    else {
        int status;
#ifdef HAVE_WAITPID
        waitpid(child, &status, 0);
#else
# ifdef HAVE__CWAIT
        _cwait(&status, child, _WAIT_CHILD);
# endif
#endif
    }
    DBG( "wait is done for 0x%x\n", child); fflush(stderr);

}
#endif

static int spawnit(char **argv){
    DBG( "-- > Tubo_exec: Main process id = 0x%x\n",getpid());
#ifdef DEBUG_TRACE
    gchar *command=g_strdup("");
    gchar **p = argv;
    for (;p && *p; p++){
	    gchar *f = g_strconcat(command, " ", *p, NULL);
	    g_free(command);
	    command = f;
    }
    DBG("Commandline: %s\n", command);
    g_free(command);

#endif
    int flags = TUBO_REAP_CHILD|TUBO_VALID_ANSI;
    //int flags = TUBO_VALID_ANSI;
    pid_t child = Tubo_exec ( argv,
                                NULL,
                                stdout_f,
                                NULL,
                                run_fork_finished_function,
                                "Tubo_exec",
                                flags);
    DBG( "Child process id= 0x%x\n", child);
    DBG( "Controller process id= 0x%x\n", Tubo_controller(child));
    DBG( "Tubo_id() = 0x%x \n", Tubo_id());

    if (!child){
            DBG( "*** Failed to spawn %s\n",argv[0]);
            return 0;
    }

   /* if TUBO_REAP_CHILD is not set you must reap the child yourself: */
    if (flags & TUBO_REAP_CHILD);
    else {
        int status;
#ifdef HAVE_WAITPID
        waitpid(child, &status, 0);
#else
# ifdef HAVE__CWAIT
        _cwait(&status, child, _WAIT_CHILD);
# endif
#endif
    }
    DBG( "wait is done for 0x%x\n", child); fflush(stderr);
    return 1;
}

int main(int argc, char **argv){
#ifdef HAVE_MMAP
   if (argc > 1) {
       forkit(argv+1);
       
   } else 
#endif
   {
       gchar **arg;
       char command[2048];
again:
       fprintf(stdout, "command (exit to end):");fflush(stdout);
       do {
	    if (!fgets(command, 2048, stdin)) continue;
            if (strncmp(command, "exit", strlen("exit"))==0) break;
            if (strncmp(command, "quit", strlen("quit"))==0) break;
            //if (strchr(command, '\r')) *strchr(command, '\r') = 0;
            if (strchr(command, '\n')) *strchr(command, '\n') = 0;
	    if (!strlen(command)) goto again;
	    if (strchr(command, ' ')) {
              arg = g_strsplit(command, " ", -1);
              char **a = arg;
              for (a=arg; a && *a; a++){
                printf("example: arg='%s'\n", *a);
              }
              fflush(stdout);
	    } else {
	      arg=(char **)malloc(2*sizeof(char *));
	      arg[0] = g_strdup(command);
	      arg[1]=NULL;
	    }
#ifndef HAVE_MMAP
            char *fullpath = g_find_program_in_path(arg[0]);

            if (!fullpath){
                    DBG( "Cannot find %s in path.\n",arg[0]);
                   fflush(stderr);
                    g_strfreev(argv);
                    goto again;
            } else {
                    DBG( "found: %s\n", fullpath);
                   fflush(stderr);
                    g_free(arg[0]);
# ifdef HAVE_WINDOWS_H
                    arg[0] = g_strdup_printf("\"%s\"", fullpath);
		    g_free(fullpath);
# else
                    arg[0] = g_strdup(fullpath);
# endif
            }	    
#else
            forkit(arg);
#endif
	    int result =  spawnit(arg);
            g_strfreev(arg);
	    if (!result) goto again;
       } while (1);
   }

    return 1;
}

