/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zookeeper.graph.Log4JEntry;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.MergedLogSource;
import org.apache.zookeeper.graph.TransactionEntry;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class JsonGenerator {
    private JSONObject root;
    private HashSet<Integer> servers = new HashSet();

    public JSONObject txnEntry(TransactionEntry e) {
        JSONObject event = new JSONObject();
        event.put((Object)"time", (Object)Long.toString(e.getTimestamp()));
        event.put((Object)"client", (Object)Long.toHexString(e.getClientId()));
        event.put((Object)"cxid", (Object)Long.toHexString(e.getCxid()));
        event.put((Object)"zxid", (Object)Long.toHexString(e.getZxid()));
        event.put((Object)"op", (Object)e.getOp());
        event.put((Object)"extra", (Object)e.getExtra());
        event.put((Object)"type", (Object)"transaction");
        return event;
    }

    public JsonGenerator(LogIterator iter) {
        Pattern stateChangeP = Pattern.compile("- (LOOKING|FOLLOWING|LEADING)");
        Pattern newElectionP = Pattern.compile("New election. My id =  (\\d+), Proposed zxid = (\\d+)");
        Pattern receivedProposalP = Pattern.compile("Notification: (\\d+) \\(n.leader\\), (\\d+) \\(n.zxid\\), (\\d+) \\(n.round\\), .+ \\(n.state\\), (\\d+) \\(n.sid\\), .+ \\(my state\\)");
        Pattern exceptionP = Pattern.compile("xception");
        this.root = new JSONObject();
        Matcher m = null;
        JSONArray events = new JSONArray();
        this.root.put((Object)"events", (Object)events);
        long starttime = Long.MAX_VALUE;
        long endtime = 0L;
        int leader = 0;
        long curEpoch = 0L;
        boolean newEpoch = false;
        while (iter.hasNext()) {
            LogEntry ent = (LogEntry)iter.next();
            if (ent.getTimestamp() < starttime) {
                starttime = ent.getTimestamp();
            }
            if (ent.getTimestamp() > endtime) {
                endtime = ent.getTimestamp();
            }
            if (ent.getType() == LogEntry.Type.TXN) {
                events.add((Object)this.txnEntry((TransactionEntry)ent));
            } else {
                Log4JEntry e = (Log4JEntry)ent;
                this.servers.add(e.getNode());
                m = stateChangeP.matcher(e.getEntry());
                if (m.find()) {
                    JSONObject stateChange = new JSONObject();
                    stateChange.put((Object)"type", (Object)"stateChange");
                    stateChange.put((Object)"time", (Object)e.getTimestamp());
                    stateChange.put((Object)"server", (Object)e.getNode());
                    stateChange.put((Object)"state", (Object)m.group(1));
                    events.add((Object)stateChange);
                    if (m.group(1).equals("LEADING")) {
                        leader = e.getNode();
                    }
                } else {
                    long zxid;
                    m = newElectionP.matcher(e.getEntry());
                    if (m.find()) {
                        Iterator<Integer> iterator = this.servers.iterator();
                        zxid = Long.valueOf(m.group(2));
                        int count = (int)zxid;
                        int epoch = (int)Long.rotateRight(zxid, 32);
                        if (leader != 0 && (long)epoch > curEpoch) {
                            JSONObject stateChange = new JSONObject();
                            stateChange.put((Object)"type", (Object)"stateChange");
                            stateChange.put((Object)"time", (Object)e.getTimestamp());
                            stateChange.put((Object)"server", (Object)leader);
                            stateChange.put((Object)"state", (Object)"INIT");
                            events.add((Object)stateChange);
                            leader = 0;
                        }
                        while (iterator.hasNext()) {
                            int dst = iterator.next();
                            if (dst == e.getNode()) continue;
                            JSONObject msg = new JSONObject();
                            msg.put((Object)"type", (Object)"postmessage");
                            msg.put((Object)"src", (Object)e.getNode());
                            msg.put((Object)"dst", (Object)dst);
                            msg.put((Object)"time", (Object)e.getTimestamp());
                            msg.put((Object)"zxid", (Object)m.group(2));
                            msg.put((Object)"count", (Object)count);
                            msg.put((Object)"epoch", (Object)epoch);
                            events.add((Object)msg);
                        }
                    } else {
                        m = receivedProposalP.matcher(e.getEntry());
                        if (m.find()) {
                            int src = Integer.valueOf(m.group(4));
                            zxid = Long.valueOf(m.group(2));
                            int dst = e.getNode();
                            long epoch2 = Long.valueOf(m.group(3));
                            int count = (int)zxid;
                            int epoch = (int)Long.rotateRight(zxid, 32);
                            if (leader != 0 && (long)epoch > curEpoch) {
                                JSONObject stateChange = new JSONObject();
                                stateChange.put((Object)"type", (Object)"stateChange");
                                stateChange.put((Object)"time", (Object)e.getTimestamp());
                                stateChange.put((Object)"server", (Object)leader);
                                stateChange.put((Object)"state", (Object)"INIT");
                                events.add((Object)stateChange);
                                leader = 0;
                            }
                            if (src != dst) {
                                JSONObject msg = new JSONObject();
                                msg.put((Object)"type", (Object)"delivermessage");
                                msg.put((Object)"src", (Object)src);
                                msg.put((Object)"dst", (Object)dst);
                                msg.put((Object)"time", (Object)e.getTimestamp());
                                msg.put((Object)"zxid", (Object)zxid);
                                msg.put((Object)"epoch", (Object)epoch);
                                msg.put((Object)"count", (Object)count);
                                msg.put((Object)"epoch2", (Object)epoch2);
                                events.add((Object)msg);
                            }
                        } else {
                            m = exceptionP.matcher(e.getEntry());
                            if (m.find()) {
                                JSONObject ex = new JSONObject();
                                ex.put((Object)"type", (Object)"exception");
                                ex.put((Object)"server", (Object)e.getNode());
                                ex.put((Object)"time", (Object)e.getTimestamp());
                                ex.put((Object)"text", (Object)e.getEntry());
                                events.add((Object)ex);
                            }
                        }
                    }
                }
            }
            JSONObject ex = new JSONObject();
            ex.put((Object)"type", (Object)"text");
            ex.put((Object)"time", (Object)ent.getTimestamp());
            String txt = ent.toString();
            ex.put((Object)"text", (Object)txt);
            events.add((Object)ex);
        }
        this.root.put((Object)"starttime", (Object)starttime);
        this.root.put((Object)"endtime", (Object)endtime);
        JSONArray serversarray = new JSONArray();
        this.root.put((Object)"servers", (Object)serversarray);
        Iterator<Integer> iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            serversarray.add((Object)iterator.next());
        }
    }

    public String toString() {
        return JSONValue.toJSONString((Object)this.root);
    }

    public static void main(String[] args) throws Exception {
        MergedLogSource src = new MergedLogSource(args);
        LogIterator iter = src.iterator();
        System.out.println(new JsonGenerator(iter));
    }

    private class Message {
        private int from;
        private int to;
        private long zxid;

        public Message(int from, int to, long zxid) {
            this.from = from;
            this.to = to;
            this.zxid = zxid;
        }

        public boolean equals(Message m) {
            return m.from == this.from && m.to == this.to && m.zxid == this.zxid;
        }
    }
}

