/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.jersey.resources;

import com.sun.jersey.api.json.JSONWithPadding;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.zookeeper.server.jersey.ZooKeeperService;
import org.apache.zookeeper.server.jersey.jaxb.ZError;
import org.apache.zookeeper.server.jersey.jaxb.ZSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="sessions/v1/{session: .*}")
public class SessionsResource {
    private static Logger LOG = LoggerFactory.getLogger(SessionsResource.class);
    private String contextPath;

    public SessionsResource(@Context HttpServletRequest request) {
        this.contextPath = request.getContextPath();
        if (this.contextPath.equals("")) {
            this.contextPath = "/";
        }
    }

    @PUT
    @Produces(value={"application/json", "application/javascript", "application/xml"})
    @Consumes(value={"application/octet-stream"})
    public Response keepAliveSession(@PathParam(value="session") String session, @Context UriInfo ui, byte[] data) {
        if (!ZooKeeperService.isConnected(this.contextPath, session)) {
            SessionsResource.throwNotFound(session, ui);
        }
        ZooKeeperService.resetTimer(this.contextPath, session);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Produces(value={"application/json", "application/javascript", "application/xml"})
    public Response createSession(@QueryParam(value="op") String op, @DefaultValue(value="5") @QueryParam(value="expire") String expire, @Context UriInfo ui) {
        int expireInSeconds;
        if (!op.equals("create")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ZError(ui.getRequestUri().toString(), "")).build());
        }
        try {
            expireInSeconds = Integer.parseInt(expire);
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
        }
        String uuid = UUID.randomUUID().toString();
        while (ZooKeeperService.isConnected(this.contextPath, uuid)) {
            uuid = UUID.randomUUID().toString();
        }
        try {
            ZooKeeperService.getClient(this.contextPath, uuid, expireInSeconds);
        }
        catch (IOException e) {
            LOG.error("Failed while trying to create a new session", (Throwable)e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
        }
        URI uri = ui.getAbsolutePathBuilder().path(uuid).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)new JSONWithPadding((Object)new ZSession(uuid, uri.toString()))).build();
    }

    @DELETE
    @Produces(value={"application/json", "application/javascript", "application/xml", "application/octet-stream"})
    public void deleteSession(@PathParam(value="session") String session, @Context UriInfo ui) {
        ZooKeeperService.close(this.contextPath, session);
    }

    private static void throwNotFound(String session, UriInfo ui) throws WebApplicationException {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ZError(ui.getRequestUri().toString(), session + " not found")).build());
    }
}

