/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTransactionTest
extends ClientBase {
    private static final Logger LOG = Logger.getLogger(MultiTransactionTest.class);
    private ZooKeeper zk;
    private ZooKeeper zk_chroot;

    @Before
    public void setUp() throws Exception {
        SyncRequestProcessor.setSnapCount((int)150);
        super.setUp();
        this.zk = this.createClient();
    }

    @Test(timeout=90000L)
    public void testInvalidPath() throws Exception {
        List<Op> opList = Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1/", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        try {
            this.zk.multi(opList);
            Assert.fail((String)"Shouldn't have validated in ZooKeeper client!");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        opList = Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"multi1/", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (int)CreateMode.EPHEMERAL_SEQUENTIAL.toFlag()), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        try {
            this.zk.multi(opList);
            Assert.fail((String)"Shouldn't have validated in ZooKeeper client!");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        opList = Arrays.asList(Op.check((String)"/multi0", (int)-1), Op.check((String)"/multi1/", (int)100), Op.check((String)"/multi2", (int)5));
        try {
            this.zk.multi(opList);
            Assert.fail((String)"Shouldn't have validated in ZooKeeper client!");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        opList = Arrays.asList(Op.delete((String)"/multi0", (int)-1), Op.delete((String)"/multi1/", (int)100), Op.delete((String)"/multi2", (int)5));
        try {
            this.zk.multi(opList);
            Assert.fail((String)"Shouldn't have validated in ZooKeeper client!");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        opList = Arrays.asList(Op.setData((String)"/multi0", (byte[])new byte[0], (int)-1), Op.setData((String)"/multi1/", (byte[])new byte[0], (int)-1), Op.setData((String)"/multi2", (byte[])new byte[0], (int)-1), Op.setData((String)"multi3", (byte[])new byte[0], (int)-1));
        try {
            this.zk.multi(opList);
            Assert.fail((String)"Shouldn't have validated in ZooKeeper client!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=90000L)
    public void testBlankPath() throws Exception {
        List<Op> opList = Arrays.asList(Op.delete((String)"/multi0", (int)-1), Op.delete(null, (int)100), Op.delete((String)"/multi2", (int)5), Op.delete((String)"", (int)-1));
        try {
            this.zk.multi(opList);
            Assert.fail((String)"Shouldn't have validated in ZooKeeper client!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(timeout=90000L)
    public void testInvalidCreateModeFlag() throws Exception {
        int createModeFlag = 6789;
        List<Op> opList = Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (int)createModeFlag), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        try {
            this.zk.multi(opList);
            Assert.fail((String)"Shouldn't have validated in ZooKeeper client!");
        }
        catch (KeeperException.BadArgumentsException badArgumentsException) {
            // empty catch block
        }
    }

    @Test
    public void testChRootCreateDelete() throws Exception {
        String chRoot = this.createNameSpace();
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        Op createChild = Op.create((String)"/myid", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        this.zk_chroot.multi(Arrays.asList(createChild));
        Assert.assertNotNull((String)("zNode is not created under chroot:" + chRoot), (Object)this.zk.exists(chRoot + "/myid", false));
        Assert.assertNotNull((String)("zNode is not created under chroot:" + chRoot), (Object)this.zk_chroot.exists("/myid", false));
        Assert.assertNull((String)"zNode is created directly under '/', ignored configured chroot", (Object)this.zk.exists("/myid", false));
        Op deleteChild = Op.delete((String)"/myid", (int)0);
        this.zk_chroot.multi(Arrays.asList(deleteChild));
        Assert.assertNull((String)("zNode exists under chroot:" + chRoot), (Object)this.zk.exists(chRoot + "/myid", false));
        Assert.assertNull((String)("zNode exists under chroot:" + chRoot), (Object)this.zk_chroot.exists("/myid", false));
    }

    @Test
    public void testChRootSetData() throws Exception {
        int i;
        String chRoot = this.createNameSpace();
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.create((String)names[i], (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            ops.add(Op.setData((String)names[i], (byte[])names[i].getBytes(), (int)0));
        }
        this.zk_chroot.multi(ops);
        for (i = 0; i < names.length; ++i) {
            Assert.assertArrayEquals((String)"zNode data not matching", (byte[])names[i].getBytes(), (byte[])this.zk_chroot.getData(names[i], false, null));
        }
    }

    @Test
    public void testChRootCheck() throws Exception {
        int i;
        String chRoot = this.createNameSpace();
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            this.zk.create(chRoot + names[i], new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.check((String)names[i], (int)0));
        }
        this.zk_chroot.multi(ops);
    }

    @Test
    public void testChRootTransaction() throws Exception {
        String chRoot = this.createNameSpace();
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String childPath = "/myid";
        Transaction transaction = this.zk_chroot.transaction();
        transaction.create(childPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        transaction.check(childPath, 0);
        transaction.setData(childPath, childPath.getBytes(), 0);
        transaction.commit();
        Assert.assertNotNull((String)("zNode is not created under chroot:" + chRoot), (Object)this.zk.exists(chRoot + childPath, false));
        Assert.assertNotNull((String)("zNode is not created under chroot:" + chRoot), (Object)this.zk_chroot.exists(childPath, false));
        Assert.assertNull((String)"zNode is created directly under '/', ignored configured chroot", (Object)this.zk.exists(childPath, false));
        Assert.assertArrayEquals((String)"zNode data not matching", (byte[])childPath.getBytes(), (byte[])this.zk_chroot.getData(childPath, false, null));
        transaction = this.zk_chroot.transaction();
        transaction.delete(childPath, 1);
        transaction.commit();
        Assert.assertNull((String)("chroot:" + chRoot + " exists after delete"), (Object)this.zk.exists(chRoot + "/myid", false));
        Assert.assertNull((String)("chroot:" + chRoot + " exists after delete"), (Object)this.zk_chroot.exists("/myid", false));
    }

    private String createNameSpace() throws InterruptedException, KeeperException {
        String chRoot = "/appsX";
        Op createChRoot = Op.create((String)chRoot, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        this.zk.multi(Arrays.asList(createChRoot));
        return chRoot;
    }

    @Test
    public void testCreate() throws Exception {
        this.zk.multi(Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
        this.zk.getData("/multi0", false, null);
        this.zk.getData("/multi1", false, null);
        this.zk.getData("/multi2", false, null);
    }

    @Test
    public void testCreateDelete() throws Exception {
        this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0)));
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    @Test
    public void testInvalidVersion() throws Exception {
        try {
            this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)1)));
            Assert.fail((String)"delete /multi should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
    }

    @Test
    public void testNestedCreate() throws Exception {
        this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi/a", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi/a/1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi/a/1", (int)0), Op.delete((String)"/multi/a", (int)0), Op.delete((String)"/multi", (int)0)));
        Assert.assertNull((Object)this.zk.exists("/multi/a/1", null));
        Assert.assertNull((Object)this.zk.exists("/multi/a", null));
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    @Test
    public void testSetData() throws Exception {
        int i;
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.create((String)names[i], (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            ops.add(Op.setData((String)names[i], (byte[])names[i].getBytes(), (int)0));
        }
        this.zk.multi(ops);
        for (i = 0; i < names.length; ++i) {
            Assert.assertArrayEquals((byte[])names[i].getBytes(), (byte[])this.zk.getData(names[i], false, null));
        }
    }

    @Test
    public void testUpdateConflict() throws Exception {
        Assert.assertNull((Object)this.zk.exists("/multi", null));
        try {
            this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/multi", (byte[])"X".getBytes(), (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0)));
            Assert.fail((String)"Should have thrown a KeeperException for invalid version");
        }
        catch (KeeperException e) {
            LOG.error((Object)("STACKTRACE: " + (Object)((Object)e)));
        }
        Assert.assertNull((Object)this.zk.exists("/multi", null));
        this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/multi", (byte[])"X".getBytes(), (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)1)));
        Assert.assertArrayEquals((byte[])this.zk.getData("/multi", false, null), (byte[])"Y".getBytes());
    }

    @Test
    public void TestDeleteUpdateConflict() throws Exception {
        try {
            this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0)));
            Assert.fail((String)"/multi should have been deleted so setData should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.zk.exists("/multi", null));
    }

    @Test
    public void TestGetResults() throws Exception {
        try {
            this.zk.multi(Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0), Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)));
            Assert.fail((String)"/multi should have been deleted so setData should have failed");
        }
        catch (KeeperException e) {
            Assert.assertNull((Object)this.zk.exists("/multi", null));
            for (OpResult r : e.getResults()) {
                LOG.info((Object)("RESULT==> " + r));
                if (!(r instanceof OpResult.ErrorResult)) continue;
                OpResult.ErrorResult er = (OpResult.ErrorResult)r;
                LOG.info((Object)("ERROR RESULT: " + er + " ERR=>" + KeeperException.Code.get((int)er.getErr())));
            }
        }
    }

    @Test
    public void testOpResultEquals() {
        this.opEquals((OpResult)new OpResult.CreateResult("/foo"), (OpResult)new OpResult.CreateResult("/foo"), (OpResult)new OpResult.CreateResult("nope"));
        this.opEquals((OpResult)new OpResult.CheckResult(), (OpResult)new OpResult.CheckResult(), null);
        this.opEquals((OpResult)new OpResult.SetDataResult(new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), (OpResult)new OpResult.SetDataResult(new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), (OpResult)new OpResult.SetDataResult(new Stat(11L, 12L, 13L, 14L, 15, 16, 17, 18L, 19, 110, 111L)));
        this.opEquals((OpResult)new OpResult.ErrorResult(1), (OpResult)new OpResult.ErrorResult(1), (OpResult)new OpResult.ErrorResult(2));
        this.opEquals((OpResult)new OpResult.DeleteResult(), (OpResult)new OpResult.DeleteResult(), null);
        this.opEquals((OpResult)new OpResult.ErrorResult(1), (OpResult)new OpResult.ErrorResult(1), (OpResult)new OpResult.ErrorResult(2));
    }

    private void opEquals(OpResult expected, OpResult value, OpResult near) {
        Assert.assertEquals((Object)value, (Object)value);
        Assert.assertFalse((boolean)value.equals(new Object()));
        Assert.assertFalse((boolean)value.equals(near));
        Assert.assertFalse((boolean)value.equals(value instanceof OpResult.CreateResult ? new OpResult.ErrorResult(1) : new OpResult.CreateResult("nope2")));
        Assert.assertTrue((boolean)value.equals(expected));
    }

    @Test
    public void testWatchesTriggered() throws KeeperException, InterruptedException {
        HasTriggeredWatcher watcher = new HasTriggeredWatcher();
        this.zk.getChildren("/", (Watcher)watcher);
        this.zk.multi(Arrays.asList(Op.create((String)"/t", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/t", (int)-1)));
        Assert.assertTrue((boolean)watcher.triggered.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testNoWatchesTriggeredForFailedMultiRequest() throws InterruptedException, KeeperException {
        HasTriggeredWatcher watcher = new HasTriggeredWatcher();
        this.zk.getChildren("/", (Watcher)watcher);
        try {
            this.zk.multi(Arrays.asList(Op.create((String)"/t", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/nonexisting", (int)-1)));
            Assert.fail((String)"expected previous multi op to fail!");
        }
        catch (KeeperException.NoNodeException e) {
            // empty catch block
        }
        SyncCallback cb = new SyncCallback();
        this.zk.sync("/", (AsyncCallback.VoidCallback)cb, null);
        cb.done.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)watcher.triggered.getCount());
    }

    @Test
    public void testTransactionBuilder() throws Exception {
        OpResult.CreateResult c;
        List results = this.zk.transaction().create("/t1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT).create("/t1/child", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT).create("/t2", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL).commit();
        Assert.assertEquals((long)3L, (long)results.size());
        for (OpResult r : results) {
            c = (OpResult.CreateResult)r;
            Assert.assertTrue((boolean)c.getPath().startsWith("/t"));
            Assert.assertNotNull((Object)c.toString());
        }
        Assert.assertNotNull((Object)this.zk.exists("/t1", false));
        Assert.assertNotNull((Object)this.zk.exists("/t1/child", false));
        Assert.assertNotNull((Object)this.zk.exists("/t2", false));
        results = this.zk.transaction().check("/t1", 0).check("/t1/child", 0).check("/t2", 0).commit();
        Assert.assertEquals((long)3L, (long)results.size());
        for (OpResult r : results) {
            c = (OpResult.CheckResult)r;
            Assert.assertNotNull((Object)c.toString());
        }
        try {
            results = this.zk.transaction().check("/t1", 0).check("/t1/child", 0).check("/t2", 1).commit();
            Assert.fail();
        }
        catch (KeeperException.BadVersionException e) {
            // empty catch block
        }
        results = this.zk.transaction().check("/t1", 0).setData("/t1", new byte[0], 0).commit();
        Assert.assertEquals((long)2L, (long)results.size());
        for (OpResult r : results) {
            Assert.assertNotNull((Object)r.toString());
        }
        try {
            results = this.zk.transaction().check("/t1", 1).setData("/t1", new byte[0], 2).commit();
            Assert.fail();
        }
        catch (KeeperException.BadVersionException e) {
            // empty catch block
        }
        results = this.zk.transaction().check("/t1", 1).check("/t1/child", 0).check("/t2", 0).commit();
        Assert.assertEquals((long)3L, (long)results.size());
        results = this.zk.transaction().delete("/t2", -1).delete("/t1/child", -1).commit();
        Assert.assertEquals((long)2L, (long)results.size());
        for (OpResult r : results) {
            OpResult.DeleteResult d = (OpResult.DeleteResult)r;
            Assert.assertNotNull((Object)d.toString());
        }
        Assert.assertNotNull((Object)this.zk.exists("/t1", false));
        Assert.assertNull((Object)this.zk.exists("/t1/child", false));
        Assert.assertNull((Object)this.zk.exists("/t2", false));
    }

    private static class SyncCallback
    implements AsyncCallback.VoidCallback {
        private final CountDownLatch done = new CountDownLatch(1);

        private SyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx) {
            this.done.countDown();
        }
    }

    private static class HasTriggeredWatcher
    implements Watcher {
        private final CountDownLatch triggered = new CountDownLatch(1);

        private HasTriggeredWatcher() {
        }

        public void process(WatchedEvent event) {
            this.triggered.countDown();
        }
    }
}

