/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  PROGRESSBAR_H
#define  PROGRESSBAR_H
#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>
class VDKForm;
/*!
  \class VDKProgressBar
  \brief Provides a progress bar widget
  \par EXAMPLES
  Into ./testvdk/progresswin.cc
 */
class VDKProgressBar: public VDKObject
{
 
protected:
  double min,max;
public:
  /*!
    Sets/gets progress bar position (defaults to min value)
   */
  VDKReadWriteValueProp<VDKProgressBar, double>  Value;
    /*!
    Sets/gets progress bar block count (defaults to 0)
   */
  VDKReadWriteValueProp<VDKProgressBar, int>  BlockCount;
  /*!
    Sets/gets progress bar style (defaults to GTK_PROGRESS_CONTINUOUS)

    Can be:
    \arg GTK_PROGRESS_CONTINUOUS
    \arg GTK_PROGRESS_DISCRETE
   */
  VDKReadWriteValueProp<VDKProgressBar, int>  BarStyle;
  /*!
    Sets/gets progress bar orientation (defaults to GTK_PROGRESS_LEFT_TO_RIGHT)

    Can be:
    \arg GTK_PROGRESS_LEFT_TO_RIGHT
    \arg GTK_PROGRESS_RIGHT_TO_LEFT
    \arg GTK_PROGRESS_BOTTOM_TO_TOP
    \arg GTK_PROGRESS_TOP_TO_BOTTOM

   */
  VDKReadWriteValueProp<VDKProgressBar, int>  BarOrientation;
  /*!
    Sets/gets progress bar "activity" mode (defaults to false)
   */
  VDKReadWriteValueProp<VDKProgressBar, bool> ActivityMode;
  /*!
    Sets/gets progress bar min value
   */
  VDKReadWriteValueProp<VDKProgressBar, double>  MinValue;
   /*!
    Sets/gets progress bar min value
   */
  VDKReadWriteValueProp<VDKProgressBar, double>  MaxValue;
public:
  /*!
    Constructor
    \param owner
    \param min min value
    \param max max value
   */
  VDKProgressBar(VDKForm* owner,
		 double min = 0.0, double max = 1.0);
  /*!
    Destructor
  */
  virtual ~VDKProgressBar();
  /*!
    Updates bar value
   */
  void Update(double val);
  /*!
    Returns bar position
   */
  double Position();
  void SetBlockCount(int bc)
    { 
      gtk_progress_bar_set_discrete_blocks (GTK_PROGRESS_BAR (widget),
					    bc);
    }
  /*
    GTK_PROGRESS_CONTINUOUS,
    GTK_PROGRESS_DISCRETE
  */
  void SetBarStyle(int style)
    {
      gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (widget),
				  (GtkProgressBarStyle) style);
    }
  /*
    GTK_PROGRESS_LEFT_TO_RIGHT,
    GTK_PROGRESS_RIGHT_TO_LEFT,
    GTK_PROGRESS_BOTTOM_TO_TOP,
    GTK_PROGRESS_TOP_TO_BOTTOM
   */
  void SetBarOrientation(int orientation)
    {
      gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR (widget),
			    (GtkProgressBarOrientation) orientation);
    }
  /*
   */
  void SetActivityMode(bool flag)
    {
      gtk_progress_set_activity_mode (GTK_PROGRESS (widget),
				  flag);
    }
  /*
  */
  void setminvalue(double val) { min = val; }
  void setmaxvalue(double val) { max = val; }
  
};
#endif
