/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef SIGLISTHANDLE_H
#define SIGLISTHANDLE_H
#include <string.h>
#include <vdk/vdkobj.h>
// #include <vdk/vdkustring.h>
#include <vdk/value_sem_list.h>
#include <gdk/gdktypes.h>
#include <cstring>
#define VDK_SIGNAL_NAME_LENGHT 63
/*
==============================================
         SIGNAL LIST ROUTINES
==============================================
*/
/*
A signal unit is a single signal package
generated by SignalConnect and added to
object callback list. As a signal is emitted
by a gtk+ widget this list is searched to
find informations to compute response method
address and call it with sender object as
argument
 */
template <class T>
class _VDK_Signal_Unit {
  
  public:
  typedef bool (T::*PMF)(VDKObject* sender);
  VDKObject* Pm;
  // *** VDKUString signal; /* signal name ala Gtk+ */
  char signal[VDK_SIGNAL_NAME_LENGHT+1];
  PMF    Pmf;  /* <class T> member function offset */
  gulong slot;  /* gtk+ slot returned by gtk_signal_connect() */
  bool connected;
  GtkObject* gtkobj; /* gtk object */
  _VDK_Signal_Unit(VDKObject* Pm, char* sign,
		   PMF Pmf):
    //***    Pm(Pm),signal(sign),Pmf(Pmf), slot(-1),connected(true) {}
    Pm(Pm),Pmf(Pmf), slot(-1),connected(true) 
    {
      std::strncpy(signal,sign,VDK_SIGNAL_NAME_LENGHT);
      // for safe
      signal[VDK_SIGNAL_NAME_LENGHT] = '\0';
    }
  bool operator ==(_VDK_Signal_Unit& su)
    //***    { return (signal == su.signal) && (Pm == su.Pm); }
    { return ((!std::strcmp(signal,su.signal)) && (Pm == su.Pm)); }
};



#define DECLARE_SIGNAL_LIST(_owner_class) \
\
private:\
typedef _VDK_Signal_Unit<_owner_class> _SignalUnit;\
typedef VDKValueList< _SignalUnit >  _CallbackList;\
typedef VDKValueListIterator< _SignalUnit >  _CallbackListIterator;\
_CallbackList _cbList;\
public:\
/*virtual bool FindSignalAtClassLevel(VDKObject* Pm, VDKUString& signal);*/\
/*virtual bool FindSignalAtParentLevel(VDKObject* Pm, VDKUString& signal);*/\
virtual bool FindSignalAtClassLevel(VDKObject* Pm, char* signal);\
virtual bool FindSignalAtParentLevel(VDKObject* Pm, char* signal);\
virtual int VDKSignalUnitResponse(GtkWidget* , char* , void*);\
\
\
\
gulong SignalConnect(VDKObject* object, char* signal,\
  bool (_owner_class::*Pmf)(VDKObject* sender), bool gtk = true, bool after = false);\
int SignalConnect(char* signal,\
  bool (_owner_class::*Pmf)(VDKObject* sender), bool gtk = true, bool after = false)\
{\
return SignalConnect(this, signal, Pmf,gtk, after);\
}\
\
virtual int  VDKSignalResponseListSize() { return _cbList.size(); }\
\
bool SignalDisconnect(gulong slot);

/*
Routines logic: (valid also for events)

1. Signal connecting: SignalConnect()

    A signal unit is generated and a recursive visiting
    algorithm are called: FindSignalAtClassLevel() and
    FindSignalAtParentLevel(). If the signal is not found
    into ancestor or parent classes callback lists a "real" 
    Gtk+ connecting  is called (in this case slot number 
    will be positive), otherwise no "real" Gtk+ is used 
    (slot number < 0). Signal unit is added to object callback list.

2.Signal emitted: VDKSignalUnitResponse()

    This routine receives signal name and sender address.
    Search into callback list to find a match. If found
    computes response method address and call it with
    sender as argument. If response method answers true
    flag the signal as treated and return. Otherwise
    recursively call himself into ancestor class.

3. Signal disconnecting: SignalDisconnect()

   Callback list is searched to find a match with slot.
   If found and slot number is > 0 a "real" Gtk+ disconnecting
   is called too.
   Signal unit is removed from callback list.
 */

#define DEFINE_SIGNAL_LIST(_owner_class, _ancestor_class)\
\
\
/*bool _owner_class::FindSignalAtClassLevel(VDKObject* Pm, VDKUString& signal)*/\
bool _owner_class::FindSignalAtClassLevel(VDKObject* Pm, char* signal)\
{\
_SignalUnit su(Pm,signal, (bool (_owner_class::*)(VDKObject*)) NULL);\
if(_cbList.find(su))\
 return true;\
else\
  return _ancestor_class::FindSignalAtClassLevel(Pm,signal);\
}\
\
\
/*bool _owner_class::FindSignalAtParentLevel(VDKObject* Pm, VDKUString& signal)*/\
bool _owner_class::FindSignalAtParentLevel(VDKObject* Pm, char* signal)\
{\
VDKObject* parent;\
for(parent = Parent(); parent; parent = parent->Parent())\
    if(parent->FindSignalAtClassLevel(Pm,signal))\
      return true;\
return false;\
}\
\
\
\
gulong _owner_class::SignalConnect(VDKObject* obj,char* signal,\
  bool (_owner_class::*Pmf)(VDKObject* sender), bool gtk, bool after)\
{\
bool found = false;\
VDKObjectSignalUnit* su = new VDKObjectSignalUnit(this,obj,signal);\
suList.add(su);\
_SignalUnit sigUnit(obj,signal,Pmf);\
found = obj->FindSignalAtClassLevel(sigUnit.Pm,sigUnit.signal) || \
      obj->FindSignalAtParentLevel(sigUnit.Pm,sigUnit.signal);\
if(!found && gtk)\
sigUnit.slot = after ? gtk_signal_connect_after(GTK_OBJECT(obj->ConnectingWidget()),signal,\
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalUnitPipe),\
		     reinterpret_cast<gpointer>(su) ):\
		     gtk_signal_connect(GTK_OBJECT(obj->ConnectingWidget()),signal,\
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalUnitPipe),\
		     reinterpret_cast<gpointer>(su) );\
else\
 sigUnit.slot = (_cbList.size()+1)*-1;\
sigUnit.gtkobj = obj->ConnectingWidget() != NULL ? \
    GTK_OBJECT(obj->ConnectingWidget()) : NULL;\
_cbList.add(sigUnit);\
return sigUnit.slot;\
}\
\
\
\
bool _owner_class::SignalDisconnect(gulong slot)\
{\
int t = 0;\
_CallbackListIterator li(_cbList);\
for(;li;li++,t++)\
{\
_SignalUnit su = li.current();\
if(su.slot == slot)\
  {\
  if(su.slot > 0)\
    gtk_signal_disconnect(su.gtkobj,su.slot);\
  _cbList.unlink(t);\
  return true;\
  }\
}\
return false;\
}\
\
\
int _owner_class::VDKSignalUnitResponse(GtkWidget* mobj,\
					char* signal, void* obj)\
{\
bool treated = false;\
VDKObject* vdkobj = reinterpret_cast<VDKObject*>(obj);\
_CallbackListIterator li(_cbList);\
for(;li;li++)\
{\
_SignalUnit su = li.current();\
if ( (su.Pm == vdkobj) &&\
     (!std::strcmp(su.signal,signal) && su.connected))\
   {\
	bool(_owner_class::*response)(VDKObject* sender)= \
                              su.Pmf;\
	if(((*this).*response)(vdkobj) == true)\
            treated = true;\
   }\
}\
if(treated)\
   return 1;\
else\
   return _ancestor_class::VDKSignalUnitResponse(mobj,signal,obj);\
}

#endif
/*
if(!found && gtk)\
  sigUnit.slot = after ? gtk_signal_connect_after(GTK_OBJECT(obj->ConnectingWidget()),signal,\
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalUnitPipe),\
		     reinterpret_cast<gpointer>(su) ):\
		     gtk_signal_connect(GTK_OBJECT(obj->ConnectingWidget()),signal,\
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalUnitPipe),\
		     reinterpret_cast<gpointer>(su) );\
*/




