/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.4
 * March 2004
 * ===========================
 *
 * Copyright (C) 1998 - 2004  Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _vdkcomboentry_h_
#define _vdkcomboentry_h_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vdk/vdkobj.h>
#include <vdk/value_sem_list.h>

typedef VDKValueList<VDKUString> StringList;
typedef VDKValueListIterator<VDKUString> StringListIterator;

/*!
  \class VDKComboEntry
  \brief Provides a simplified wrapper for gtkcombo_entry
  \author Mario Motta
  \par Signals
  \arg \b activate_signal received when the Enter key is pressed in the Entry.
  \arg \b changed_signal received when text in Entry is changed.
  This happens when an item has been selected or unselected. 
  \arg \b focus_in_signal received when Entry gets focus.
  \arg \b focus_out_signal received when Entry loses focus.
 */
class VDKComboEntry: public VDKObject
{
 protected:
  static int FocusOutEvent(GtkWidget *,  GdkEventFocus*, gpointer wid);
  static int FocusInEvent(GtkWidget *, GdkEventFocus*, gpointer wid);
  VDKObjectSignal s_activated, s_changed, s_selected;
 public:
  /*!
    Constructor
    \param owner owner form
    \param selections a NULL terminating string array
  */
  VDKComboEntry(VDKForm* owner, char** selections = NULL);
  virtual ~VDKComboEntry();  

  /*!
    Same as Editable property in VDKEntry.
    Setting it to false allows you to provide a read-only list to select 
    from, without the user being able to enter text.
   */
  VDKReadWriteValueProp<VDKComboEntry,bool>  Editable;
  void SetEditable(bool flag)
    { gtk_entry_set_editable(GTK_ENTRY(GTK_BIN (widget)->child),flag); }
 /*!
    Sets/gets the index of the currently selected item in the dropdown 
    list or -1 if no item is selected.
   */
  VDKReadWriteValueProp<VDKComboEntry,int> Selected;
  int GetSelected()
    { return gtk_combo_box_get_active  (GTK_COMBO_BOX(widget)); }
  void SetSelected(int index)
    { gtk_combo_box_set_active  (GTK_COMBO_BOX(widget),index); }
  /*!
    Set/Get the text in the Entry
    \arg returned char* should be deleted by user
   */
  VDKReadWriteValueProp<VDKComboEntry,char*> Text;
  void SetText(char* text);
  char* GetText();
  // properties
  /*!
    Sets/gets widget dropdown list.
    \arg setting a new string list overwrites if any
    \arg returned StringList should be deleted by user
   */
  VDKReadWriteValueProp<VDKComboEntry,StringList*>  Selections;
  StringList* GetSelections(void);
  void SetSelections(StringList* selections);
  /*!
    gets underlying GtkListStore model that can be accessed in order to
    manipulate widget dropdown list if needed.
  */
  VDKReadWriteValueProp<VDKComboEntry,GtkListStore*> StoreModel;
  void SetStoreModel(GtkListStore* store_model);
  /*!
    Sets underlying GtkListStore model as sortable.
    Once the model has been sorted, it can't go back to the default state.
    A possible work around to this problem is here:
    \code
bool 
SomeForm::ToggleSorting(VDKObject* sender)
{
  static StringList *unsorted = NULL;
  GtkListStore* store = comboboxentry->StoreModel;
  // store unsorted dropdown list for later use
  if(!unsorted)
    unsorted = comboboxentry->Selections;
  if(chbox->Checked)
      comboboxentry->Sorted = true;
  else
  // since once sorted cannot revert to previous state
  // we substitute store model with a new unsorted one
    {
      comboboxentry->Sorted = false;
      GtkListStore* store = gtk_list_store_new (1, G_TYPE_STRING);
      comboboxentry->StoreModel = store;
      comboboxentry->Selections = unsorted;
    }
  comboboxentry->Selected = 0;
  return true;
}
    \endcode
  */
  VDKReadWriteValueProp<VDKComboEntry,bool> Sorted;
  void SetSorted(bool flag);
  /*!
    Sets/gets sorting order. Applicable only if Sorted property is true.
    can be either GTK_SORT_ASCENDING (default) or GTK_SORT_DESCENDING
  */
  VDKReadWriteValueProp<VDKComboEntry,GtkSortType> SortingOrder;
  // overriden 
  virtual void SetBackground(VDKRgb rgb, GtkStateType state);
  virtual void SetForeground(VDKRgb rgb, GtkStateType state);
  virtual void SetFont(VDKFont* font);
};

#endif
