/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.4
 * March 2004
 * ===========================
 *
 * Copyright (C) 1998 - 2004  Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _vdkfc_form_h_
#define _vdkfc_form_h_
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <vdk/vdk.h>

typedef VDKArray<VDKUString> FileStringArray;
/*!
  \class VDKFileChooser
  \brief Provides a wrap for GtkFileChooser widget
  \par Usage
  \code
  #include <vdk/vdkfilechooser.h>
  FileStringArray selections;
  VDKFileChooser* fc = new VDKFileChooser(this, &selections,"File chooser");
  // fc->MultiSelection = true; // comment out for multi selection mode
  fc->AddFilterPattern("All files","*");
  fc->AddFilterPattern("C sources","*.c");
  fc->AddFilterPattern("CC sources","*.cc");
  fc->AddFilterPattern("C/CC headers","*.h");
  fc->SetDefaultFilter("All files");
  fc->ShowModal();
  // returns selections array filled with 1 or more filenames pending
  // on selection mode (set with MultiSelection property)
  if(selections.size() == 1)
    {
    printf("\nSelected:%s",(char*) selections[0]);
    fflush(stdout);
    }
  else if(selections.size() > 1)
    {
      for(int t = 0; t < selections.size(); t++)
	    printf("\nSelected:%s",(char*) selections[t]);
      fflush(stdout);
    }
  \endcode
  On return selections will be an empty array if user presses "cancel" button.
 */
class VDKFileChooser: public VDKForm
{
// gui object declarations
private:

  VDKObject* filechooser;
  static void file_activated (GtkFileChooser *filechooser,
                           gpointer user_data);
  FileStringArray* selections;
public:
    /*! 
   * Constructor
   * \param owner 
   * \param selections a FileStringArray pointer
   * \param title window title
   */
  VDKFileChooser(VDKForm* owner, FileStringArray* selections, char* title);
  virtual ~VDKFileChooser();
  /* !
     \internal
     called internally by constructor
  */
 private:  void Setup(void);

 protected: VDKBox* mainbox;
 protected: VDKBox* fcbox;
 protected: VDKSeparator* separator0;
 protected: VDKBox* buttonbox;
 protected: VDKCustomButton* okButton;
 protected: VDKCustomButton* cancelButton;
 bool OnokButtonClick(VDKObject* sender);
 bool OncancelButtonClick(VDKObject* sender); 

 public:
  DECLARE_SIGNAL_MAP(VDKFileChooser);
  /*
    declaring signal and events
    dynamics tables
  */
  DECLARE_SIGNAL_LIST(VDKFileChooser);
  DECLARE_EVENT_LIST(VDKFileChooser);
  // declares two static used to initialize
  // form display type and initial position
  //plm
  static GtkWindowType /*VDKFileChooser::*/DisplayType;
  static GtkWindowPosition /*VDKFileChooser::*/InitialPosition;
  //
    /*! 
   * Add a filter based on a pattern
   * \param name a human readable name 
   * \param pattern a filter pattern (ie: *.cc")
   */
  void AddFilterPattern(char* name, char* pattern);
   /*! 
   * set <name> filter as default
   * \param name a human readable name 
   */
  void SetDefaultFilter(char* name);
  void AddMimeType(char* name, char* mime);
   /*! 
   * remove <name> filter from filter's list
   * \param name a human readable name 
   */
  void RemoveFilter(char* name);
  // properties
  /*!
    setting this property to true allow selecting more than one file
    (false by default)
   */
  VDKReadWriteValueProp<VDKFileChooser,bool> MultiSelection;
  /*!
    sets file chooser mode, can be one of following:
    - GTK_FILE_CHOOSER_ACTION_OPEN	Indicates open mode. The file chooser will only let the user pick an existing file. (this is the default mode)
    - GTK_FILE_CHOOSER_ACTION_SAVE	Indicates save mode. The file chooser will let the user pick an existing file, or type in a new filename.
    - GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER	Indicates an Open mode for selecting folders. The file chooser will let the user pick an existing folder.
    - GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER	Indicates a mode for creating a new folder. The file chooser will let the user name an existing or new folder. 
   */
  VDKReadWriteValueProp<VDKFileChooser,GtkFileChooserAction> Action;
  // properties functors
  bool GetMultiSelection() { return gtk_file_chooser_get_select_multiple (GTK_FILE_CHOOSER(sigwid)); }
  void SetMultiSelection(bool ms) {   gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(sigwid),ms); }
  GtkFileChooserAction GetAction() { return gtk_file_chooser_get_action(GTK_FILE_CHOOSER(sigwid)); }
  void SetAction(GtkFileChooserAction a) { gtk_file_chooser_set_action (GTK_FILE_CHOOSER(sigwid),a); }
};
#endif
// end of file:vdkfc.h
