/* -*- c++ -*- */
/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

#ifndef VDKOBJ_H
#define VDKOBJ_H
#include <gtk/gtk.h>
#include <vdk/vdktypes.h>
#include <vdk/dlist.h>
#include <vdk/vdkutils.h>
#include <vdk/rawobj.h>
#include <vdk/vdkprops.h>
#include <vdk/vdkustring.h>

#ifdef USE_SIGCPLUSPLUS
#     include <vdk/sigc_addon.h>
#     include <vdk/sigc_events.h>
#     include <vdk/sigc_eventsignals.h>
#endif /* USE_SIGCPLUSPLUS */

class VDKForm;
class VDKTooltip;
class VDKFont;
class VDKObject;
/*!
  partially filled enum for isA() response
*/
enum { object_class, form_class , container_class};

/*
 */
typedef VDKList<VDKObject> ItemList;
typedef VDKListiterator<VDKObject> ItemListIterator;

/*!
  This struct maps an object with a signal,
  used for static tables
 */
struct VDKObjectSignal {
    void* obj;
    int signal;
};

/*!
  This struct maps an object with a signal
  used for dynamics tables
 */
class VDKObjectSignalUnit
{
public:
    void* owner;
    void* obj;
    VDKUString signal;
    VDKObjectSignalUnit(void* owner,void *obj, char* signal);
    ~VDKObjectSignalUnit();
};
/*!
  Object connected signal list
 */
typedef VDKList<VDKObjectSignalUnit> SignalUnitList;
typedef VDKListiterator<VDKObjectSignalUnit> SignalUnitListIterator;

/*!
  This struct maps an object with an event
  used for dynamics tables
 */
class VDKObjectEventUnit
{
public:
    void* owner;
    void* obj;
    VDKUString signal;
    VDKObjectEventUnit(void* owner,void *obj, char* signal);
    ~VDKObjectEventUnit();
};
/*!
  Object connected event list
 */
typedef VDKList<VDKObjectEventUnit> EventUnitList;
typedef VDKListiterator<VDKObjectEventUnit> EventUnitListIterator;

/*
=============
SIZE PROPERTY
=============
*/
typedef VDKReadWriteValueProp<VDKObject,VDKPoint> SizeOProp;

class SizeObjectProp: public SizeOProp
{
public:
    SizeObjectProp();
    SizeObjectProp(char* name, VDKObject* object,
                   void (VDKObject::*write)(VDKPoint) =  NULL,
                   VDKPoint (VDKObject::*read)(void) = NULL);
    ~SizeObjectProp();
    void operator = (VDKPoint);
    operator VDKPoint();
};

/*
  ===============
  VDKOBJECT CLASS
  ===============
*/
typedef VDKList<VDKRawObject> RawList;
typedef VDKListiterator<VDKRawObject> RawListIterator;

/*! \class VDKObject
  This class is the base class of a wide hierarchy, provides common functionalities to all derived classe
 */
#ifndef USE_SIGCPLUSPLUS
class VDKObject : public VDKNotCopyAble
#else
class VDKObject : public SigC::Object, public VDKNotCopyAble
#endif
{

 public:
  /*
    properties
  */
  /*!
    Setting one of these this properties will set/get object background color. 
    Naming convention follows Gtk+ one.
    Example: form->NormalBackground = VDKRgb(255,0,0);
    (Tip: VDKRgb is a structure defined in vdkutils.h. 
    Remember that some objects are transparent, so if you want to set 
    the background  color, you actually have to set the background 
    color of the parent, VDKLabel is an example.
   */
  VDKReadWriteValueProp<VDKObject,VDKRgb> NormalBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> PrelightBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> InsensitiveBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> ActiveBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> SelectedBackground;
  VDKReadWriteValueProp<VDKObject,VDKRgb> Foreground;
  //VDKReadWriteValueProp<VDKObject,VDKRgb> BaseColor;
  /*!
    Setting this property will set the object font.

    i.e.: obj->Font = 
    new VDKFont(obj,"X-font-string-chock-full-o-dashes-goes-in-here");
   */
  VDKReadWriteValueProp<VDKObject,VDKFont*> Font;
  /*!
    Setting this property will set/get object minimum size. 
   */
  SizeObjectProp Usize;
  /*!
    Setting this property will set/get object sensitivity. 
   */
  VDKReadWriteValueProp<VDKObject,bool> Enabled;
  /*!
    Setting this property will get object focus.
   */
  VDKReadOnlyValueProp<VDKObject,bool> HasFocus;
  /*!
    Setting this property will set/get object cursor type.
    VDKCursorType and its GdkCursorType value (updated 2005/11/08) :\n
	curDefault = Default cursor\n
	curXCursor = GDK_X_CURSOR\n
	curArrow = GDK_ARROW\n
	curArrowDown = GDK_BASED_ARROW_DOWN\n
	curArrowUp = GDK_BASED_ARROW_UP\n
	curBoat = GDK_BOAT\n
	curBogosity = GDK_BOGOSITY\n
	curBottomLeftCorner = GDK_BOTTOM_LEFT_CORNER\n
	curBottomRightCorner = GDK_BOTTOM_RIGHT_CORNER\n
	curBottomSide = GDK_BOTTOM_SIDE\n
	curBottomTee = GDK_BOTTOM_TEE\n
	curBoxSpiral = GDK_BOX_SPIRAL\n
	curCenterPtr = GDK_CENTER_PTR\n
	curCircle = GDK_CIRCLE\n
	curClock = GDK_CLOCK\n
	curCoffeeMug = GDK_COFFEE_MUG\n
	curCross = GDK_CROSS\n
	curCrossReverse = GDK_CROSS_REVERSE\n
	curCrossHair = GDK_CROSSHAIR\n
	curDiamondCross = GDK_DIAMOND_CROSS\n
	curDot = GDK_DOT\n
	curDotBox = GDK_DOTBOX\n
	curDoubleArrow = GDK_DOUBLE_ARROW\n
	curDraftLarge = GDK_DRAFT_LARGE\n
	curDraftSmall = GDK_DRAFT_SMALL\n
	curDrapedBox = GDK_DRAPED_BOX\n
	curExchange = GDK_EXCHANGE
	curFleur = GDK_FLEUR,\n
	curGobbler = GDK_GOBBLER\n
	curGumby = GDK_GUMBY\n
	curHand1 = GDK_HAND1\n
	curHandPtr = GDK_HAND2\n
	curHeart = GDK_HEART\n
	curIcon = GDK_ICON\n
	curIronCross = GDK_IRON_CROSS\n
	curLeftPtr = GDK_LEFT_PTR\n
	curLeftSide = GDK_LEFT_SIDE\n
	curLeftTee = GDK_LEFT_TEE\n
	curLeftButton = GDK_LEFTBUTTON\n
	curLLAngle = GDK_LL_ANGLE\n
	curLRAngle = GDK_LR_ANGLE\n
	curMan = GDK_MAN\n
	curMiddleButton = GDK_MIDDLEBUTTON\n
	curMouse = GDK_MOUSE\n
	curPencil = GDK_PENCIL\n
	curPirate = GDK_PIRATE\n
	curPlus = GDK_PLUS\n
	curQuestionArrow = GDK_QUESTION_ARROW\n
	curRightPtr = GDK_RIGHT_PTR\n
	curRightSide = GDK_RIGHT_SIDE\n
	curRightTee = GDK_RIGHT_TEE\n
	curRightButton = GDK_RIGHTBUTTON\n
	curRTLLogo = GDK_RTL_LOGO\n
	curSailBoat = GDK_SAILBOAT\n
	curSBDownArrow = GDK_SB_DOWN_ARROW\n
	curSBHDoubleArrow = GDK_SB_H_DOUBLE_ARROW\n
	curSBLeftArrow = GDK_SB_LEFT_ARROW\n
	curSBRightArrow = GDK_SB_RIGHT_ARROW\n
	curSBUpArrow = GDK_SB_UP_ARROW\n
	curSBVDoubleArrow = GDK_SB_V_DOUBLE_ARRO\n,
	curShuttle = GDK_SHUTTLE\n
	curSizing = GDK_SIZING\n
	curSpider = GDK_SPIDER\n
	curSprayCan = GDK_SPRAYCAN\n
	curStar = GDK_STAR\n
	curTarget = GDK_TARGET\n
	curTCross = GDK_TCROSS\n
	curTopLeftArrow = GDK_TOP_LEFT_ARROW\n
	curTopLeftCorner = GDK_TOP_LEFT_CORNER\n
	curTopRightCorner = GDK_TOP_RIGHT_CORNER\n
	curTopSide = GDK_TOP_SIDE\n
	curTopTee = GDK_TOP_TEE\n
	curTrek = GDK_TREK\n
	curULAngle = GDK_UL_ANGLE\n
	curUmbrella = GDK_UMBRELLA\n
	curURAngle = GDK_UR_ANGLE\n
	curWatch = GDK_WATCH\n
	curXTerm = GDK_XTERM\n
	curLastCursor = GDK_LAST_CURSOR\n
	curIsPixmap = GDK_CURSOR_IS_PIXMAP\n
	See GDK API documentation for details on cursors image
   */
  VDKReadWriteValueProp<VDKObject,VDKCursorType> Cursor;
  /*!
    Setting this property will show/hide or get object visibility
  */
  VDKReadWriteValueProp<VDKObject,bool> Visible;
  int Tag;

// GTK_STATE_NORMAL = 0, GTK_STATE_ACTIVE, GTK_STATE_PRELIGHT,
  // GTK_STATE_SELECTED,GTK_STATE_INSENSITIVE
  void SetNormalBackground(VDKRgb c);
  void SetPrelightBackground(VDKRgb c);
  void SetInsensitiveBackground(VDKRgb c);
  void SetActiveBackground(VDKRgb c);
  void SetSelectedBackground(VDKRgb c);
  /*!
    Gets object background color
   */
  VDKRgb GetBackground(GtkStateType state = GTK_STATE_NORMAL);
  /*!
    Gets object foreground color
   */
  VDKRgb GetForeground(GtkStateType state = GTK_STATE_NORMAL);

private:
  /*
    copy and assignement prohibited
    */
    friend class VDKRawObject;
//     VDKObject(VDKObject& ) {}
//     VDKObject& operator=(VDKObject& ) {
//         return *this;
//     }
    VDKTooltip* tip;
protected:
    ItemList items;
    ItemList garbages;
    RawList  raws;
    SignalUnitList suList;
    EventUnitList euList;
    /*!
      stock connected signal
     */
    VDKObjectSignal s_clicked,s_pressed,s_released,s_enter,s_leave,
        s_list_select,s_list_unselect,s_list_click_column,s_realize,
            s_toggled,s_value_changed,s_child_attached,s_child_detached;
    VDKForm* owner;
    /*!
      underlaying gtk+ widget
    */
    GtkWidget* widget;
    /*!
      underlaying gtk+ widget
      widget and sigwid could be different,
      e.g into composite widget made of a container
      with some inner widget.
      See Widget() and WrappedWidget()
    */      
    GtkWidget* sigwid;
    /*!
      Object parent, where the signal flows if not stopped
    */
    VDKObject* parent;
    /*! \internal
     */
    static int VDKEventPipe(GtkWidget* w, GdkEvent* event, void* obj);
    /*! \internal
     */
    void _setBackground_(GtkWidget* wid,
                         int red,int green, int blue,
                         GtkStateType state);
    /*! \internal
     */
    void _setForeground_(GtkWidget* wid,
                         int red,int green, int blue,
                         GtkStateType state);
    /*! \internal
     */
    void _setFont_(GtkWidget* wid, VDKFont* f);
    /*! \internal
     */
    void ConnectDefaultEvents();
    /*! \internal
     */
    void ConnectDefaultSignals();
    /*! \internal
     */
    void SignalEmit(int signal, int level);
    /*!
      \internal
    */
    virtual void ShowWidget(bool visible);

public:
    /*!
      Constructor, make an object that belongs to <owner> form.
     */
    VDKObject(VDKForm* owner = NULL);
    /*!
      Contructor, makes an object instance from an already gtk+ created object.
     */
    VDKObject(VDKForm* owner, GtkWidget* widget);
    /*!
      Destructor
    */
    virtual ~VDKObject();
    /*!
      Explicitely destroy an object freeing associated memory.
      
      Tip: never use delete operator otherwise garbage collection 
      will fail and program probably will crash. 
     */
    bool Destroy();
    /*!
      returns an enum id (incomplete and not so useful)
    */
    virtual int isA();
    /*!
      Returns object owner form.
     */
    VDKForm* Owner();
    /*!
      Returns underlying GTK+ widget.
     */
    virtual GtkWidget* Widget();
    /*!
      Same as WrappedWidget().
     */
    GtkWidget* ConnectingWidget();
    /*!
      Returns underlying wrapped Gtk+ widget, useful in those 
      cases when VDKObject is a composite one.
      Happens in many composite widgets, i.e a container with some
      inner widgets, that underlaying widget isn't which answers to signals.
      In this case the container is the <widget> and one of the 
      inner widgets is the <sigwid>, wich is responsible to answers 
      signal/event.You have to connect with the last one.
      An example is VDKText where Widget() return packing box not text itself. 
      Tip: In doubt use always WrappedWidget() instead of Widget(), 
      is always safer.
     */
    GtkWidget* WrappedWidget();
    /*!
      Sets object font
    */
    virtual void SetFont(VDKFont* f);
    /*!
      Gets object font
    */
    VDKFont* GetFont();
    /*!
      Set object visibility
      \param visible either true or false
    */
    void SetVisible(bool visible);
    /*!
      Returns object visibility
    */
    bool GetVisible();
    /*!
      Sets object assigned cursor
    */
    void SetCursor(VDKCursorType);
    /*!
      Gets object assigned cursor
    */
    VDKCursorType GetCursor();
    /*!
      Sets object foreground
      \param   color a VDKRgb object
      \param   state can be one of the gtk+ widget states
     */
    virtual void SetForeground(VDKRgb color,
                               GtkStateType state = GTK_STATE_NORMAL);

    void SetNormalForeground(VDKRgb color);
    /*!
      Sets object background
      \param   color a VDKRgb object
      \param   state can be one of the gtk+ widget states
     */
    virtual void SetBackground(VDKRgb color,
                               GtkStateType state = GTK_STATE_NORMAL);
    /*!
      Sets object minimum size
      \param   w width
      \param   h height
     */
    void SetSize(int w, int h);
    /*!
      Sets object minimum size
      \param   s, a VDKPoint object
     */
      
    void SetUsize(VDKPoint s);
    /*
      Sets/unsets object sensitivity
      \param   flag, either true or false
      Tip: with flag=false object does not answer to signal/events
    */
    virtual void Enable(bool flag = true);
    /*
      Returns if the object is enable or not
    */
    bool GetEnabled();
    /*!
      Sets object tip.
     */
    virtual void SetTip(const char* );
    /*!
      Add on object to the object.
      \param obj the object to be added
      \param justify where the object wil be added, can be:
      - l_justify packed to end (appended)
      - r_justify packed to start (prepended)
      \param expand if true object will expand
      \param fill if true object will fill all available space
      \param padding how many pixels are left around object
    */
    virtual void Add(VDKObject* obj, int justify = l_justify,
                     int expand = true, int fill = true,
                     int padding = 0);
    /*!
      Return contained objects list
     */
    ItemList& Items();
    /*!
      \internal
    */
    ItemList& Garbages();
    /*!
      \internal
    */
    RawList& Raws();
    /*!
      Draw an object
    */
    void Draw(GdkRectangle* area = NULL);
    /*!
      placeholder for subclasses.
      This method is called whenever an object is added to
      a container.
    */
    virtual void Setup() {}
    /*!
      Emit a signal (static tables)
      \param signal
    */
    void SignalEmit(int signal);
    /*!
      Emit a signal (dynamic tables)
      \param signal
    */
    void SignalEmit(char* sig);
    /*!
      Emit a signal directly to parent (static tables)
      \param signal
    */
    void SignalEmitParent(int signal);
    /*!
      Emit a signal directly to parent (dynamic tables)
      \param signal
    */
    void SignalEmitParent(char* sig);
    /*!
      Grab the focus to itself
     */
    virtual void GrabFocus();
    /*!
      Grab the focus to itself
     */
    virtual bool isFocused();
    /*!
      \internal
    */    
    void AddItem(VDKObject* item);
    /*!
      \internal
    */
    void RemoveItem(VDKObject* item);
    /*!
      \internal
    */
    void RemoveItems();
  /*
==================== signal/event management  ======================
  */
    /*!
      Sets object parenthood
    */
    VDKObject* Parent(VDKObject* p = NULL);
    // signal and events default dispatchers for class level
    /*!
      \internal
    */
    static void VDKSignalPipe(GtkWidget* w, void* obj);
    /*!
      \internal
    */
    virtual int VDKObjectSignalResponse(GtkWidget* , int , void*, bool);
    /*!
      \internal
    */
    virtual int VDKObjectEventResponse(GtkWidget* , GdkEvent*, void*, bool);

    virtual int ObjectSignalDetach(int , int );
    virtual bool ObjectSignalAttach(int );
    virtual int ObjectEventDetach(VDKEvent );
    virtual bool ObjectEventAttach(int );
 protected:
     virtual int VDKObjectSignalResponseTableSize();
     virtual int VDKObjectEventResponseTableSize();
  /*
   */
  // signal and events default dispatchers for parent level
public:
    /*!
      \internal
    */
    virtual int VDKSignalResponse(GtkWidget* , int , void*, void *, bool);
    /*!
      \internal
    */
    virtual int VDKEventResponse(GtkWidget* , GdkEvent* , void*, void*, bool );
    virtual int SignalDetach(VDKObject* , int );
    virtual bool SignalAttach(int );
    virtual int EventDetach(VDKObject* ,VDKEvent );
    virtual bool EventAttach(int );
protected:
    /*!
      \internal
    */
    virtual int VDKSignalResponseTableSize();
    /*!
      \internal
    */
    virtual int VDKEventResponseTableSize();
  /*
==================== signal management ala Gtk+ ======================
  */
public:
    /*!
      Placeholder for subclasses, at this level does nothing.
      Connects an object-signal to a <this> method
      \param obj connected object
      \param signal signal to be connected
      \param method class method that answers to signal
      \param gtk (default is true) if you set this arg to false no 
      real connection is made with gtk+ signal system and signal 
      is handled internally by vdk. This allow to define and use your 
      own signals without register them to gtk+
      \param after (default is false) if set to true connect signal in
      the "after" slot, meaninigfull only if previous <gtk> arg is set
      to true.
    */
    int SignalConnect(VDKObject* obj, 
		      char* signal,
		      bool (VDKObject::*method)(VDKObject*), 
		      bool gtk = true,
		      bool after = false);
    /*!
      Placeholder for subclasses, at this level does nothing.
      Connects <this>-signal to a <this> method
      \param signal signal to be connected
      \param method class method that answers to signal
      \param gtk (default is true) if you set this arg to false no 
      real connection is made with gtk+ signal system and signal 
      is handled internally by vdk. This allow to define and use your 
      own signals without register them to gtk+
      \param after (default is false) if set to true connect signal in
      the "after" slot, meaninigfull only if previous <gtk> arg is set
      to true.
    */
    int SignalConnect(char* signal ,
		      bool (VDKObject::*method)(VDKObject*), 
		      bool gtk = true,
		      bool after = false);
   // general signal unit response (at this level simply answer false)
    virtual int VDKSignalUnitResponse(GtkWidget* , char* , void*);
    /*! disconnect this from connection
      \param   connection must be achieved with a previous
      SignalConnect() call
      */
    bool SignalDisconnect(int connection);
  // find signal at class level
    /*!
      \internal
    */
    virtual bool FindSignalAtClassLevel(VDKObject* , char* );
  // find signal at parent level
    /*!
      \internal
    */
  //   virtual bool FindSignalAtParentLevel(VDKObject* , VDKUString& ) 
    virtual bool FindSignalAtParentLevel(VDKObject* , char* );
protected:
    // unique Gtk+ callback that redirects to
    // above VDKSignalUnitResponse()
    /*!
      \internal
    */
    static void VDKSignalUnitPipe(GtkWidget* , void* );
  /*
==================== event management ala Gtk+ ======================
  */
public:
    /*!
      \internal
    */
  //  virtual bool FindEventAtClassLevel(VDKObject* , VDKUString& ) 
  virtual bool FindEventAtClassLevel(VDKObject* , char* );
    /*!
      \internal
    */
  //  virtual bool FindEventAtParentLevel(VDKObject* , VDKUString& ) 
  virtual bool FindEventAtParentLevel(VDKObject* , char* );
    /*!
      \internal
    */
      virtual int  VDKEventUnitResponse(GtkWidget* , char* , GdkEvent* , void*);
    /*!
      Placeholder for subclasses, at this level does nothing.
      connects an object-event to a <this> method 
      \param   obj connected object
      \param event event to be connected
      \param method class method that answers to signal
      \param after (default is false) if set to true connect signal in
      the "after" slot.
    */
      int EventConnect(VDKObject* obj, 
		       char* event, 
		       bool (VDKObject::*method) (VDKObject* , GdkEvent*), 
		       bool after = false);
      /*!
	Placeholder for subclasses, at this level does nothing.
	connects an <this>-event to a <this> method
	\param event event to be connected
	\param method class method that answers to signal
	\param after (default is false) if set to true connect signal in
	the "after" slot.
      */
      int EventConnect(char* , bool (VDKObject::*) (VDKObject* , GdkEvent*), 
		       bool after = false);
      /*! disconnect this from connection
	\param   connection must be achieved with a previous
	EventConnect() call
      */
      bool EventDisconnect(int connection);
      virtual int  VDKSignalResponseListSize();
      
protected:
    // unique Gtk+ callback that redirects to
    // above VDKEventUnitResponse()
    /*!
      \internal
    */
    static int VDKEventUnitPipe(GtkWidget* , GdkEvent*, void* );

#ifdef USE_SIGCPLUSPLUS
 public:
   /** The signal for raw GdkEvents* */
    VDKRawEventSignal     OnRawEvent;
   /** The signal responsible for button events */
    VDKButtonSignal       OnButtonEvent;
   /** The signal responsible for keystroke events */ 
    VDKKeySignal          OnKeyEvent;
   /** The signal responsible for changes in key focus */
    VDKKeyFocusSignal     OnKeyFocusEvent;
   /** The signal responsible for changes in pointer focus */
    VDKPointerFocusSignal OnPointerFocusEvent;
   /** The signal responsible for pointer (mouse) events */
    VDKPointerSignal      OnPointerEvent;
   /** The signal responsible for map events */
     VDKMapSignal         OnMapEvent;
   /** The signal responsible for geometry events */
     VDKGeometrySignal    OnGeometryEvent;
   /** The signal responsible for paint events */
     VDKPaintSignal       OnPaintEvent;
#endif // USE_SIGCPLUSPLUS
};
#endif








