/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 * This is a wrapper for GtkCombo.
   Author: Eric T. Wienke <eric@liquidsilver.com>
*/

#include "vdk/combo.h"
#include "vdk/vdkobj.h"
#include "vdk/dlist.h"
#include "vdk/forms.h"
#include "vdk/entry.h"
#include "vdk/colors.h"
#include <cstring>
// Modified to make gcc 2.95 happy
// ionutz
static gint sortfunc(gconstpointer a, gconstpointer b)
{
  return std::strcmp((const char*) a, (const char*) b);

}

int VDKCombo::FocusOutEvent(GtkWidget *,
			    GdkEventFocus*,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  VDKEntry* obj = reinterpret_cast<VDKEntry*>(wid);
  obj->SignalEmit(focus_out_signal);
  return FALSE; //TRUE;
}
/*
 */
int VDKCombo::FocusInEvent(GtkWidget *,
			    GdkEventFocus *,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL, FALSE);
  VDKEntry* obj = reinterpret_cast<VDKEntry*>(wid);
  obj->SignalEmit(focus_in_signal);
  return FALSE; //TRUE; 
}
/*
 */
VDKCombo::VDKCombo(VDKForm* owner, char* def,GtkWidget* combo):
  VDKObject(owner),
  Text("Text", this, NULL, &VDKCombo::SetText, &VDKCombo::GetText),
  Editable("Editable", this, true, &VDKCombo::SetEditable),
  Sorted("Sorted", this, false, &VDKCombo::SetSorted),
  Hidden("Hidden", this, false, &VDKCombo::SetHidden),
  CaseSensitive("CaseSensitive", this, true,
                &VDKCombo::SetCaseSensitive, &VDKCombo::GetCaseSensitive),
  PopdownStrings("PopdownStrings",this, StringList(),
                &VDKCombo::SetPopdownStrings, &VDKCombo::GetPopdownStrings),
  Selected("Selected",this, -1, &VDKCombo::GetSelected)
{
    if(combo)
	widget = combo;
    else
	widget = gtk_combo_new();
    popdownlist = NULL;
    if(def)
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(widget)->entry),def);
    s_activated.obj = this;
    s_activated.signal = activate_signal;
    s_changed.obj = this;
    s_changed.signal = changed_signal;
    s_selected.obj = this;
    s_selected.signal = selection_changed_signal;

    gtk_signal_connect(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(widget)->entry)),
		       "activate",
		       GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		       (gpointer) &s_activated);
    changeConnect = gtk_signal_connect(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(widget)->entry)),"changed",
				       GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
				       (gpointer) &s_changed);
    gtk_signal_connect(GTK_OBJECT(GTK_COMBO(widget)->entry),
		       "focus_out_event",
		       GTK_SIGNAL_FUNC(VDKCombo::FocusOutEvent),
		       (gpointer) this);
    gtk_signal_connect(GTK_OBJECT(GTK_COMBO(widget)->entry),
		       "focus_in_event",
		       GTK_SIGNAL_FUNC(VDKCombo::FocusInEvent),
		       (gpointer) this);
    gtk_signal_connect(GTK_OBJECT(GTK_LIST(GTK_COMBO(widget)->list)),"selection_changed",
               GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
               (gpointer) &s_selected);

    ConnectDefaultSignals();
#ifdef USE_SIGCPLUSPLUS
     make_gtksigc_connection(this);
#endif
}
/*
 */
VDKCombo::~VDKCombo()
{
     if (popdownlist)
	  g_list_free(popdownlist);
}
/*
 */
void VDKCombo::SetText(char* s)
{
gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(widget)->entry),s);
}
/*
 */
char* VDKCombo::GetText()
{
  //return (char*) gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(widget)->entry));
  char* p = gtk_editable_get_chars (GTK_EDITABLE(GTK_COMBO(widget)->entry), 0,-1);
  if(p)
    {
    buffer = p;
    g_free(p);
    }
  return (char*) buffer;
}

/*
 */
void VDKCombo::ClearList()
{
    gtk_list_clear_items(GTK_LIST(GTK_COMBO(widget)->list),0,
          g_list_length(GTK_LIST(GTK_COMBO(widget)->list)->children));
}

/*
 */
void VDKCombo::SetBackground(VDKRgb rgb,
			     GtkStateType state)
{
  VDKColor *color = new VDKColor(Owner(),rgb.red,rgb.green,rgb.blue);
  GtkStyle* style =
    gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(GTK_COMBO(widget)->entry))) ;
  gtk_style_ref(style);
  style->base[state] = *(color->Color());
  gtk_widget_set_style(GTK_WIDGET(GTK_COMBO(widget)->entry),style);
  /* Style of List is not changed as it would require changing each associated
     GtkListItem. That would probably be undesirable at times and unflexible. */
}

/*
 */
void VDKCombo::SetPopdownStrings(StringList str)
{
	GList* tmp;
	
    if (popdownlist) {
        g_list_free(popdownlist);
    }
    popdownlist = g_list_alloc();
    popdownlist->next=NULL;
    popdownlist->prev=NULL;
    popdownlist->data=(gchar*)str[0];
    for (int i=1; i<str.size(); i++) {
        if (Sorted) {
          tmp = g_list_insert_sorted(popdownlist,(gchar*)str[i],sortfunc);
        }
        else {
		  tmp = g_list_append(popdownlist,(gchar*)str[i]);
        }
    }
    gtk_combo_set_popdown_strings(GTK_COMBO(widget),popdownlist);
}

/*
 */
StringList VDKCombo::GetPopdownStrings()
{
    GList *list = GTK_LIST(GTK_COMBO(widget)->list)->children;
    popdownstr.flush();
    while (list) {
        GList *cc = gtk_container_children(GTK_CONTAINER(list->data));
        assert(GTK_IS_LABEL(cc->data));
        gchar *text = GTK_LABEL(cc->data)->label;
        VDKUString s(text);
        popdownstr.add(s);
        list = list->next;
    }
    return popdownstr;
}

int VDKCombo::GetSelected()
{
    GList *selected = GTK_LIST(GTK_COMBO(widget)->list)->selection;
    if (!selected) {
        return -1;
    }
    /* assume that selection is always in mode GTK_SELECTION_SINGLE,
       so we only have to check the first item in the returned list. */
    GtkWidget *child = GTK_WIDGET(selected->data);
    return gtk_list_child_position(GTK_LIST(GTK_COMBO(widget)->list), child);
}

void
VDKCombo::SortList()
{
  StringList temp = GetPopdownStrings();
  SetPopdownStrings(temp);
}

void
VDKCombo::GrabFocus()
{
  if(widget) gtk_widget_grab_focus(GTK_COMBO(widget)->entry);
}

#ifdef USE_SIGCPLUSPLUS
void
VDKCombo::make_gtksigc_connection(VDKCombo* obj)
{
     gtk_signal_connect(GTK_OBJECT(GTK_LIST(GTK_COMBO(obj->widget)->list)),
			"select_child",
			GTK_SIGNAL_FUNC(&VDKCombo::_handle_item_select),
			(gpointer) obj);

     gtk_signal_connect(GTK_OBJECT(GTK_LIST(GTK_COMBO(obj->widget)->list)),
			"unselect_child",
			GTK_SIGNAL_FUNC(&VDKCombo::_handle_item_unselect),
			(gpointer) obj);

     gtk_signal_connect(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(obj->widget)->entry)),
			"activate",
			GTK_SIGNAL_FUNC(&VDKCombo::_handle_item_activate),
			(gpointer) obj);

     gtk_signal_connect(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(obj->widget)->entry)),
			"changed",
			GTK_SIGNAL_FUNC(&VDKCombo::_handle_item_text_changed),
			(gpointer) obj);
}

void
VDKCombo::_handle_item_select(GtkWidget* wid, GtkWidget* item,
			      gpointer gp)
{
     VDKCombo* obj=reinterpret_cast<VDKCombo*>(gp);
     int item_id=gtk_list_child_position(GTK_LIST(wid), item);
     if(item_id!=-1) // To handle mysteriuos emission at destruction
	  obj->OnItemSelect(obj, item_id);
}

void
VDKCombo::_handle_item_unselect(GtkWidget* wid, GtkWidget* item,
				gpointer gp)
{
     VDKCombo* obj=reinterpret_cast<VDKCombo*>(gp);
     int item_id= gtk_list_child_position(GTK_LIST(wid), item);
     if(item_id!=-1)
	  obj->OnItemUnselect(obj, item_id);
}

void
VDKCombo::_handle_item_activate(GtkWidget* wid, gpointer gp)
{
     VDKCombo* obj=reinterpret_cast<VDKCombo*>(gp);
     obj->OnItemActivate(obj, obj->Selected);
}

void
VDKCombo::_handle_item_text_changed(GtkWidget* wid,
				    gpointer gp)
{
     VDKCombo* obj=reinterpret_cast<VDKCombo*>(gp);
     obj->OnItemTextChanged(obj, obj->GetSelected(),
			    obj->GetText());
     // gtk_entry_get_text(GTK_ENTRY(wid)));
}

#endif /* USE_SIGCPLUSPLUS */


