/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0
 * December 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/application.h>
#include <vdk/forms.h>

static int answer = 0;
static int mtype = 0;
static int timerId = 0;

static int
OnDialogDestroy(GtkWidget* dialog, gpointer gp)
{
	if (timerId) {
		gtk_timeout_remove(timerId);
		timerId = 0;
	}
	gtk_widget_destroy(dialog);
	return 0;
}

static void
OnDialogResponse(GtkWidget *dialog, gint response_id, gpointer gp)
{
	switch (response_id) {
		case GTK_RESPONSE_OK:
			answer = VDK_IDOK;
			break;
		case GTK_RESPONSE_CANCEL:
			answer = VDK_IDCANCEL;
			break;
		case GTK_RESPONSE_YES:
			answer = VDK_IDYES;
			break;
		case GTK_RESPONSE_NO:
			answer = VDK_IDNO;
			break;
		default:
			switch(mtype & VDK_TYPEMASK) {
				case VDK_YESNO:
					answer = VDK_IDNO;
					break;
				default: answer = VDK_IDCANCEL;
			}
	}
	OnDialogDestroy(dialog, NULL);
}

static int HandleTimeOut(gpointer gp)
{
	if (timerId) {
		gtk_timeout_remove(timerId);
		timerId = 0;
	}
	GtkWidget* dialog = reinterpret_cast <GtkWidget*>(gp);
	OnDialogResponse(dialog, GTK_RESPONSE_DELETE_EVENT, NULL);
	return -1;
}

static GtkWidget*
MakeDialog(GtkMessageType type, GtkButtonsType buttons,
			const char* caption, const char* prompt,
			GtkWindow* parent, unsigned int wait)
{
	answer = 0;
	GtkWidget *dialog = gtk_message_dialog_new(
						parent,
						GtkDialogFlags(GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT),
						type,
						buttons,
						(char*)prompt);
	if (!dialog) return NULL;
	if (caption) gtk_window_set_title(GTK_WINDOW(dialog), caption);
	gtk_window_position(GTK_WINDOW(dialog), parent ? GTK_WIN_POS_CENTER_ON_PARENT : GTK_WIN_POS_CENTER);
	// Added by plm - V 2.5.0
	if ((mtype & VDK_TYPEMASK) == VDK_YESNOCANCEL) {
		// Add a cancel button
		gtk_dialog_add_button(GTK_DIALOG (dialog), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);
		// Makes it the default answer
		gtk_dialog_set_default_response(GTK_DIALOG (dialog), GTK_RESPONSE_CANCEL);
	}
	if (wait) timerId = gtk_timeout_add(wait, ::HandleTimeOut, dialog);
	return dialog;
}

gint
VDKApplication::VDKMessageBox(VDKUString caption, VDKUString text,
	int mode, unsigned int wait, VDKForm *msgowner)
{
	return VDKMessageBox(caption.c_str(), text.c_str(),
						mode, wait, msgowner);
}

gint
VDKApplication::VDKMessageBox(VDKString caption, VDKString text,
	int mode, unsigned int wait, VDKForm *msgowner)
{
	return VDKMessageBox(caption.c_str(), text.c_str(),
						mode, wait, msgowner);
}

gint
VDKApplication::VDKMessageBox(const char* caption, const char* text,
	int mode, unsigned int wait, VDKForm *msgowner)
{
	GtkMessageType type;
	GtkButtonsType buttons;
	mtype = mode;
	gint result = GTK_RESPONSE_DELETE_EVENT;

	/* masks icon */
	switch (mode & VDK_ICONMASK) {
		case VDK_ICONQUESTION:
			type = GTK_MESSAGE_QUESTION;
			break;
		case VDK_ICONINFORMATION:
			type = GTK_MESSAGE_INFO;
			break;
		case VDK_ICONERROR:
			type = GTK_MESSAGE_ERROR;
			break;
		case VDK_ICONSTOP:
			type = GTK_MESSAGE_WARNING;
			break;
		default: type = GTK_MESSAGE_INFO;
	}
	/* masks buttons */
	switch (mode & VDK_TYPEMASK) {
		case VDK_OKCANCEL:
			buttons = GTK_BUTTONS_OK_CANCEL;
			break;
		case VDK_YESNO:
			buttons = GTK_BUTTONS_YES_NO;
			break;
		case VDK_YESNOCANCEL:
			buttons = GTK_BUTTONS_YES_NO;
			break;
		case VDK_OK:
			buttons = GTK_BUTTONS_OK;
			break;
		default: buttons = GTK_BUTTONS_OK;
	}
	GtkWidget *dialog = MakeDialog(type, buttons, caption, text,
			msgowner ? GTK_WINDOW(msgowner->Window()) : GTK_WINDOW(MainForm->Window()),
			wait);
	if (dialog) {
		result = gtk_dialog_run(GTK_DIALOG(dialog));
		//printf("result = %d\n", result);
		OnDialogResponse(dialog, result, NULL);
		gtk_widget_destroy(dialog);
	}
	//printf("user choice = %d\n", answer);
	return answer;
}


