/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/spins.h"
#include "vdk/forms.h"
#include "vdk/colors.h"
/*
 */
void 
VDKSpinButton::OnValueChanged(GtkWidget *wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);
  VDKSpinButton* obj = reinterpret_cast<VDKSpinButton*>(gp);
  obj->SignalEmit("value_changed");
#ifdef USE_SIGCPLUSPLUS
  obj->OnSpinValueChanged(obj, obj->GetValueAsFloat());
#endif
}
/*
 */
VDKSpinButton::VDKSpinButton(VDKForm* owner,
		     float defValue,
		     float lower,
		     float upper,
		     float step,
		     float climb):
  VDKObject(owner),
  ValueAsFloat("ValueAsFloat",this,defValue,
	       &VDKSpinButton::SetValueAsFloat,
	       &VDKSpinButton::GetValueAsFloat),
  ValueAsInt("ValueAsInt",this,int(defValue),
         &VDKSpinButton::SetValueAsInt,
	     &VDKSpinButton::GetValueAsInt),
  Digits("Digits",this,1,
	 &VDKSpinButton::SetDigits),
  LowerBound("LowerBound",this,0.0,
	     &VDKSpinButton::SetLowerBound,
	     &VDKSpinButton::GetLowerBound),
  UpperBound("UpperBound",this,1.0,
	     &VDKSpinButton::SetUpperBound,
	     &VDKSpinButton::GetUpperBound)
{
 adj = gtk_adjustment_new (defValue, lower, upper, step, step, step);
 widget = gtk_spin_button_new (GTK_ADJUSTMENT (adj), climb, 1); 
 gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (widget), TRUE);
 s_value_changed.obj = this;
 s_value_changed.signal = value_changed_signal;
 gtk_signal_connect(adj,"value_changed",
		    GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		    (gpointer) &s_value_changed);
 gtk_signal_connect(adj,"value_changed",
		    GTK_SIGNAL_FUNC(VDKSpinButton::OnValueChanged),
		    (gpointer) this);
 ConnectDefaultSignals();
 LowerBound(lower);
 UpperBound(upper);
}
 

VDKSpinButton::~VDKSpinButton()
{
} 

void 
VDKSpinButton::SetDigits(int digits) 
{ 
gtk_spin_button_set_digits(GTK_SPIN_BUTTON(widget), digits); 
}

int 
VDKSpinButton::GetValueAsInt() 
{ 
return gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));
}

void
VDKSpinButton::SetValueAsInt(int i)
{ 
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),i); 
}

void 
VDKSpinButton::SetValueAsFloat(float f)
{ 
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),f); 
}

float 
VDKSpinButton::GetValueAsFloat() 
{ 
  return (float)gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(widget));
}

void 
VDKSpinButton::SetLowerBound(float f) 
{ 
  GtkAdjustment* adjustment = GTK_SPIN_BUTTON(widget)->adjustment;
  if(adjustment) adjustment->lower = f; 
}

float 
VDKSpinButton::GetLowerBound()
{ 
  GtkAdjustment* adjustment = GTK_SPIN_BUTTON(widget)->adjustment;
  return (float)(adjustment ? adjustment->lower : 0.0); 
}

void 
VDKSpinButton::SetUpperBound(float f)
{ 
  GtkAdjustment* adjustment = GTK_SPIN_BUTTON(widget)->adjustment;
  if(adjustment) adjustment->upper = f;
}

float
VDKSpinButton::GetUpperBound()
{
  GtkAdjustment* adjustment = GTK_SPIN_BUTTON(widget)->adjustment;
  return (float)(adjustment ? adjustment->upper : 0.0); 
}

void 
VDKSpinButton::SetForeground(VDKRgb color, GtkStateType state)
{
  VDKColor *vdkcolor = NULL;

  if(!GTK_IS_WIDGET(widget))
    return;
  else
    {
      GtkSpinButton *spin = GTK_SPIN_BUTTON(widget);
      GtkEntry * entry = &(spin->entry);
      //      vdkcolor = new VDKColor(/*Owner() ? Owner() : */this ,color);
      vdkcolor = new VDKColor(Owner() ? static_cast<VDKObject*>(Owner()) 
			      : static_cast<VDKObject*>(this)
			      ,color);
      gtk_widget_modify_text (GTK_WIDGET(entry), 
			      state, vdkcolor->Color());
    }
}

void 
VDKSpinButton::SetBackground(VDKRgb color, GtkStateType state)
{
  VDKColor *vdkcolor = NULL;
  if(!GTK_IS_WIDGET(widget))
    return;
  else
    {
      GtkSpinButton *spin = GTK_SPIN_BUTTON(widget);
      GtkEntry * entry = &(spin->entry);
      //      vdkcolor = new VDKColor(/*Owner() ? Owner() : */this ,color);
      vdkcolor = new VDKColor(Owner() ? static_cast<VDKObject*>(Owner()) 
			      : static_cast<VDKObject*>(this)
			      ,color);
      gtk_widget_modify_base (GTK_WIDGET(entry), 
			      state, vdkcolor->Color());
    }
}


