/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * revision to 0.5.0
 * October,November 1998
 * ===========================
 * 
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include "vdk/toolbar.h"
#include "vdk/forms.h"
#include "vdk/vdkobj.h"
#include "vdk/colors.h"
#define DEFAULT_SPACE_SIZE  5
#define DEFAULT_SPACE_STYLE GTK_TOOLBAR_SPACE_EMPTY
/*
 */
static GtkWidget* new_pixmap_data (char **pixdata, GdkWindow *window, GdkColor  *background);
static GtkWidget* new_pixmap_file (char *pixfile, GdkWindow *window, GdkColor  *background);

/*
 */
VDKToolbar::~VDKToolbar()
{
}
/*
*/
void
VDKToolbar::Add(VDKObject* obj, int , int , int , int)
{
	AddWidget(obj);
}
/*
*/
void
VDKToolbar::AddSpace()
{
	gtk_toolbar_append_space(GTK_TOOLBAR(widget));
}
/*
*/
void
VDKToolbar::SetOrientation(GtkOrientation orientation)
{
	gtk_toolbar_set_orientation(GTK_TOOLBAR(widget),orientation);
}
/*
*/
void
VDKToolbar::SetStyle(GtkToolbarStyle style)
{
	gtk_toolbar_set_style(GTK_TOOLBAR(widget),style);
}
/*
*/
void
VDKToolbar::SetBorderless(bool flag)
{
	if (!flag) {
		//gtk_toolbar_set_button_relief (GTK_TOOLBAR (widget), GTK_RELIEF_NORMAL);
		SetRelief(GTK_RELIEF_NORMAL);
	}
	else {
		//gtk_toolbar_set_button_relief (GTK_TOOLBAR (widget), GTK_RELIEF_NONE);
		SetRelief(GTK_RELIEF_NONE);
	}
}
/*
*/
void
VDKToolbar::SetSpacing(int s)
{
	//gtk_toolbar_set_space_size(GTK_TOOLBAR(widget),s);
	// gtk_object_set(GTK_OBJECT(widget), "space_size", s, NULL);
}
/*
*/
void
VDKToolbar::SetSpaceStyle(GtkToolbarSpaceStyle style)
{
	//gtk_toolbar_set_space_style (GTK_TOOLBAR (widget), style);
	//gtk_object_set(GTK_OBJECT(widget), "space_style", style, NULL);
}
/*
*/
GtkToolbarSpaceStyle
VDKToolbar::GetSpaceStyle()
{
	return (GtkToolbarSpaceStyle) 0; // return GTK_TOOLBAR(widget)->space_style;
}
/*
*/
VDKObject*
VDKToolbar::operator[](int ndx)
{
	if ((ndx >= 0) && (ndx < tool_buttons.size())) return tool_buttons[ndx];
	else return NULL;
}
/*
 */
void VDKToolbar::ButtonSignal(GtkWidget *wid, gpointer gp) {
    int t = 0;
    g_return_if_fail(wid != NULL);
    g_return_if_fail(gp != NULL);
    VDKToolbar* toolbar = reinterpret_cast<VDKToolbar*> (gp);
    GtkWidgetListIterator li(toolbar->widgets);
    for(;li;li++,t++)
        if(wid == li.current())
            break;
    if(t < toolbar->widgets.size()) {
        toolbar->ButtonPressed(t);
        toolbar->SignalEmit(clicked_signal);
    }
  
}
/*
 */
VDKToolbar::VDKToolbar(VDKForm* owner, GtkOrientation orientation):
  VDKObjectContainer(owner),
  WidgetList("WidgetList",this,NULL),
  ButtonList("ButtonList",this,NULL),
  ButtonPressed("ButtonPressed",this,-1),
  Orientation("Orientation", this, GTK_ORIENTATION_HORIZONTAL, 
	      &VDKToolbar::SetOrientation),
  Style("Style",this,GTK_TOOLBAR_ICONS,&VDKToolbar::SetStyle),
  SpaceStyle("SpaceStyle", this, DEFAULT_SPACE_STYLE, 
	     &VDKToolbar::SetSpaceStyle, &VDKToolbar::GetSpaceStyle),
  Borderless("Borderless",this,true,&VDKToolbar::SetBorderless),
  Relief ("Relief", this, GTK_RELIEF_NONE, &VDKToolbar::SetRelief),
  Spacing("Spacing",this,DEFAULT_SPACE_SIZE,&VDKToolbar::SetSpacing) 
{
  widget = gtk_toolbar_new(/*orientation,GTK_TOOLBAR_ICONS*/);
  WidgetList(&toolWidgets);
  ButtonList(&widgets);
}

void VDKToolbar::AddWidget(VDKObject* obj,char* tip) 
{
  gtk_toolbar_append_widget(GTK_TOOLBAR(widget),
			    obj->Widget(),
			    tip,NULL);
  //gtk_widget_show(obj->Widget());
  // items.add(obj);
  toolWidgets.add(obj);
  //obj->Parent(this);
  // obj->Setup();
  VDKObjectContainer::Add(obj,l_justify,0,0,0); 
} 

/*
*/ 
void VDKToolbar::AddButton(char** pixdata,
			   char* tip,
                           char* text) {
    GtkWidget *button;
    GtkWidget *pixmap = pixdata ?
        new_pixmap_data (pixdata, Owner()->Window()->window, &widget->style->bg[GTK_STATE_NORMAL]) :
        NULL ;

    button = gtk_toolbar_append_item (GTK_TOOLBAR (widget), text, NULL,
                                      NULL, pixmap, GTK_SIGNAL_FUNC(VDKToolbar::ButtonSignal),
                                      (gpointer) this);
    VDKObject* tbutton = new VDKObject(Owner(),button);
    Owner()->Items().add(tbutton);
    tool_buttons.add(tbutton);
    if(tip)
        tbutton->SetTip(tip);
    widgets.add(button);
    return ;
} 
 
void VDKToolbar::AddButton(char* pixfile,
			   char* tip,
                           char* text) {
    GtkWidget *button;
    GtkWidget *pixmap = pixfile ?
        new_pixmap_file (pixfile, Owner()->Window()->window, &widget->style->bg[GTK_STATE_NORMAL]) :
        NULL ;

    button = gtk_toolbar_append_item (GTK_TOOLBAR (widget), text, NULL,
                                      NULL, pixmap, GTK_SIGNAL_FUNC(VDKToolbar::ButtonSignal),
                                      (gpointer) this);
    VDKObject* tbutton = new VDKObject(Owner(),button);
    Owner()->Items().add(tbutton);

    tool_buttons.add(tbutton);
    if(tip)
        tbutton->SetTip(tip);
    widgets.add(button);
    return ;
} 

void 
VDKToolbar::SetRelief(GtkReliefStyle style)
{
  
  GList *children;
  GtkToolbarChild *child;
  GtkToolbar* tbar = GTK_TOOLBAR(WrappedWidget());
  for (children = tbar->children; children; children = children->next)
    {
      child = (GtkToolbarChild *) children->data;
      if (child->type == GTK_TOOLBAR_CHILD_BUTTON ||
	  child->type == GTK_TOOLBAR_CHILD_RADIOBUTTON ||
	  child->type == GTK_TOOLBAR_CHILD_TOGGLEBUTTON)
	gtk_button_set_relief (GTK_BUTTON (child->widget), GTK_RELIEF_NONE);
    }
  gtk_widget_queue_resize (GTK_WIDGET (tbar));     
  
}

GtkWidget* new_pixmap_data (char **pixdata, GdkWindow *window, GdkColor  *background) {

    GtkWidget *wpixmap;
    GdkPixmap *pixmap;
    GdkBitmap *mask;

    pixmap = gdk_pixmap_create_from_xpm_d (window, &mask, background, pixdata);
    wpixmap = gtk_pixmap_new (pixmap, mask);
    return wpixmap;
}
 
GtkWidget* new_pixmap_file (char *pixfile, GdkWindow *window, GdkColor  *background) {

    GtkWidget *wpixmap;
    GdkPixmap *pixmap;
    GdkBitmap *mask;

    pixmap = gdk_pixmap_create_from_xpm (window, &mask, background, pixfile);
    wpixmap = gtk_pixmap_new (pixmap, mask);
    return wpixmap;
}



