/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.4
 * March 2004
 * ===========================
 *
 * Copyright (C) 1998 - 2004  Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/vdkcomboentry.h>
#include <vdk/forms.h>
#include <string.h>
#include <vdk/colors.h>
int VDKComboEntry::FocusOutEvent(GtkWidget *,
			    GdkEventFocus*,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  VDKComboEntry* obj = reinterpret_cast<VDKComboEntry*>(wid);
  obj->SignalEmit(focus_out_signal);
  return FALSE;
}
/*
 */
int VDKComboEntry::FocusInEvent(GtkWidget *,
			    GdkEventFocus *,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL, FALSE);
  VDKComboEntry* obj = reinterpret_cast<VDKComboEntry*>(wid);
  obj->SignalEmit(focus_in_signal);
  return FALSE; 
}

/*
 */
VDKComboEntry::VDKComboEntry(VDKForm* owner, char** selections):
  VDKObject(owner),
  Editable("Editable", this, true, &VDKComboEntry::SetEditable),
  Selected("Selected",this, -1, &VDKComboEntry::SetSelected,&VDKComboEntry::GetSelected),
  Text("Text", this, NULL, &VDKComboEntry::SetText, &VDKComboEntry::GetText),
  Selections("Selections", this, NULL, &VDKComboEntry::SetSelections, &VDKComboEntry::GetSelections),
  StoreModel("StoreModel",this,NULL,&VDKComboEntry::SetStoreModel),
  Sorted("Sorted",this,false,&VDKComboEntry::SetSorted),
  SortingOrder("SortingOrder",this,GTK_SORT_ASCENDING)
{
  GtkListStore* store = gtk_list_store_new (1, G_TYPE_STRING);
  StoreModel(store);
  widget =  gtk_combo_box_entry_new_with_model (GTK_TREE_MODEL (store), 0);
  // answering vdk signals is embedded entry widget
  sigwid = GTK_WIDGET(GTK_ENTRY (GTK_BIN (widget)->child));
  s_activated.obj = this;
  s_activated.signal = activate_signal;
  s_changed.obj = this;
  s_changed.signal = changed_signal;
  if(selections)
    {
      GtkTreeIter iter;
      for(int t = 0; selections[t];t++)
	{
	  gtk_list_store_append (store, &iter);
	  gtk_list_store_set (store, &iter, 0, selections[t], -1);
	}
    }

  g_signal_connect_data (GTK_ENTRY (GTK_BIN (widget)->child), "activate", 
			 G_CALLBACK (VDKObject::VDKSignalPipe), (gpointer) &s_activated, 
			 NULL,(GConnectFlags) 0);
  g_signal_connect_data (widget, "changed", 
			 G_CALLBACK (VDKObject::VDKSignalPipe), (gpointer) &s_changed, 
			 NULL,(GConnectFlags) 0);
  gtk_signal_connect(GTK_OBJECT(GTK_ENTRY (GTK_BIN (widget)->child)),
		     "focus_out_event",
		     GTK_SIGNAL_FUNC(VDKComboEntry::FocusOutEvent),
		     (gpointer) this);
  gtk_signal_connect(GTK_OBJECT(GTK_ENTRY (GTK_BIN (widget)->child)),
		     "focus_in_event",
		     GTK_SIGNAL_FUNC(VDKComboEntry::FocusInEvent),
		     (gpointer) this);
  ConnectDefaultSignals();  
}

/*
 */
VDKComboEntry::~VDKComboEntry()
{
  
}

/*
 */
void VDKComboEntry::SetSelections(StringList* selections)
{
  // clear the StoreModel
  GtkTreeIter iter;
  gtk_list_store_clear(StoreModel);
  if(selections)
    {
      gtk_list_store_clear(StoreModel);
      StringListIterator li(*selections);
      for(;li;li++)
	{
	  char* local = (char*) li.current();
	  gtk_list_store_append (StoreModel, &iter);
	  gtk_list_store_set (StoreModel, &iter, 0, local, -1);
	}
    }
}

StringList*
VDKComboEntry::GetSelections(void)
{
  StringList* list = new StringList;
  GtkTreeIter iter;
  gchar *item = NULL;  
  GtkListStore* store = StoreModel;
  for(bool flag = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(store),&iter);
      flag; flag = gtk_tree_model_iter_next(GTK_TREE_MODEL(store),&iter))
    {
      gtk_tree_model_get (GTK_TREE_MODEL(store), &iter, 0, &item, -1);
      list->add(VDKUString(item));  
    }
  return list;
}
/*
 */
void VDKComboEntry::SetText(char* s)
{
  gtk_entry_set_text(GTK_ENTRY(GTK_BIN (widget)->child),s);
}
/*
  returned char* should be deleted by caller;
 */
char* 
VDKComboEntry::GetText()
{
  const char* local = gtk_entry_get_text (GTK_ENTRY (GTK_BIN (widget)->child));
  char* buffer = NULL;
  if(local)
    {
      buffer = new char[strlen(local)+1];
      strcpy(buffer,local);
    }
  return buffer;
}

void 
VDKComboEntry::SetStoreModel(GtkListStore* store_model)
{
  GtkListStore* store = StoreModel;
  g_object_unref (store);
  gtk_combo_box_set_model (GTK_COMBO_BOX(widget),GTK_TREE_MODEL(store_model));
  return;
}

void 
VDKComboEntry::SetSorted(bool flag)
{ 
  GtkListStore* store = StoreModel;
  GtkSortType stype = SortingOrder;  
  if(!Sorted && store && flag) 
    gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE(store),0,stype);
}

/*
 */
void VDKComboEntry::SetBackground(VDKRgb rgb, GtkStateType state)
{
  VDKColor *color = new VDKColor(Owner(),rgb.red,rgb.green,rgb.blue);
  gtk_widget_modify_base (GTK_WIDGET(GTK_ENTRY(GTK_BIN (widget)->child)), state, color->Color());
}
/*
 */
void VDKComboEntry::SetForeground(VDKRgb rgb, GtkStateType state)
{
  VDKColor *color = new VDKColor(Owner(),rgb.red,rgb.green,rgb.blue);
  gtk_widget_modify_text (GTK_WIDGET(GTK_ENTRY(GTK_BIN (widget)->child)), state, color->Color());
}

void
VDKComboEntry::SetFont(VDKFont* font)
{
  if(!GTK_WIDGET_REALIZED(GTK_WIDGET(widget)))
    gtk_widget_realize(widget);
  GtkRcStyle *rc_style;
  rc_style = gtk_rc_style_new ();
  rc_style->font_desc = 
    pango_font_description_copy (font->AsPangoFontDescription());
  gtk_widget_modify_style (GTK_WIDGET(GTK_ENTRY(GTK_BIN (widget)->child)), rc_style);
  gtk_rc_style_unref (rc_style);
  gtk_widget_size_request (GTK_WIDGET(GTK_ENTRY(GTK_BIN (widget)->child)), NULL);
}
