/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.4
 * March 2004
 * ===========================
 *
 * Copyright (C) 1998 - 2004  Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <vdk/vdkfilechooser.h>
static char * stock_open_16_xpm[] = {
"16 16 64 1",
" 	c None",
".	c #000000",
"+	c #E4E5DF",
"@	c #D5D6CB",
"#	c #D6D7CA",
"$	c #A3A39D",
"%	c #F5F6F0",
"&	c #8D907B",
"*	c #92957E",
"=	c #90937D",
"-	c #979B84",
";	c #6D705F",
">	c #EAECDB",
",	c #8A8C7D",
"'	c #8E917B",
")	c #91947F",
"!	c #8B8E7A",
"~	c #999B87",
"{	c #919480",
"]	c #989B86",
"^	c #B1B4A2",
"/	c #A2A394",
"(	c #F7F7F7",
"_	c #878A75",
":	c #666858",
"<	c #4B4D3F",
"[	c #4D4F40",
"}	c #404135",
"|	c #424337",
"1	c #434437",
"2	c #404236",
"3	c #3C3D32",
"4	c #48493C",
"5	c #1A1A16",
"6	c #C6C6BE",
"7	c #848672",
"8	c #25261F",
"9	c #F1F2E9",
"0	c #DDE0C7",
"a	c #D6DABB",
"b	c #CDD2AC",
"c	c #C7CCA7",
"d	c #989C80",
"e	c #C6C7BE",
"f	c #5F6152",
"g	c #888980",
"h	c #A7AB8C",
"i	c #878A70",
"j	c #9FA19A",
"k	c #EFF0E5",
"l	c #9EA284",
"m	c #80817B",
"n	c #96968D",
"o	c #E3E5D1",
"p	c #83866D",
"q	c #97998D",
"r	c #EDEFE2",
"s	c #A2A688",
"t	c #767671",
"u	c #E7E9DA",
"v	c #D1D3BD",
"w	c #BBBF9D",
"x	c #989B80",
"y	c #6E715C",
"                ",
"                ",
"   ....         ",
"  .+@#$.        ",
" .%&*=-;.....   ",
" .>,')!~{]{^/.  ",
" .(_:<[}||12345 ",
" .67890abbbbbcd.",
" .efg0bbbbbbbhi.",
" .j8kabbbbbbbl. ",
" .mnobbbbbbbbp. ",
" .qrbbbbbbbbs.  ",
" .tuvwwwwwwxy.  ",
"  ...........   ",
"                ",
"                "};

static char * stock_cancel_20_xpm[] = {
"20 20 8 1",
" 	c None",
".	c #000000",
"+	c #C46D74",
"@	c #9F3C44",
"#	c #B5444E",
"$	c #BD5A62",
"%	c #7B2D34",
"&	c #8C343C",
"                    ",
"                    ",
"                    ",
"      ..      .     ",
"     .+@.    .#.    ",
"     .##.   .$#.    ",
"      .#@. .$#%.    ",
"      .##..$#&.     ",
"       .####@.      ",
"       .####.       ",
"      .$###.        ",
"     .$####.        ",
"    .$#&..#&.       ",
"   .+#&. .@#.       ",
"   .#&.   .#@.      ",
"    ..    .@#.      ",
"           ..       ",
"                    ",
"                    ",
"                    "};

GtkWindowType VDKFileChooser::DisplayType = GTK_WINDOW_TOPLEVEL;
GtkWindowPosition VDKFileChooser::InitialPosition = GTK_WIN_POS_NONE;
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(VDKFileChooser,VDKForm);
DEFINE_EVENT_LIST(VDKFileChooser,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(VDKFileChooser,VDKForm)
  ON_SIGNAL(okButton,clicked_signal,OnokButtonClick),
  ON_SIGNAL(cancelButton,clicked_signal,OncancelButtonClick)
END_SIGNAL_MAP

// Vdkfc FORM  CLASS
/*
form constructor
*/
VDKFileChooser::VDKFileChooser(VDKForm* owner, FileStringArray* selections, char* title):
  VDKForm(owner,title,v_box,DisplayType),selections(selections),
  MultiSelection("MultiSelection",this,false,&VDKFileChooser::SetMultiSelection,&VDKFileChooser::GetMultiSelection),
  Action("Action",this,GTK_FILE_CHOOSER_ACTION_OPEN,&VDKFileChooser::SetAction,&VDKFileChooser::GetAction)
{
  VDKFileChooser::Setup();
}

/*
form destructor
*/
VDKFileChooser::~VDKFileChooser()
{
}

/*
form setup
*/
void
VDKFileChooser::Setup(void)
{
  SetSize(438,326);
  mainbox = new VDKBox(this,v_box);
  Add(mainbox,0,1,1,0);
  fcbox = new VDKBox(this,v_box);
  mainbox->Add(fcbox,0,1,1,0);
  fcbox->BorderWidth(0);
  separator0 = new VDKSeparator(this,h_separator);
  gtk_widget_set_name (GTK_WIDGET(separator0->WrappedWidget()), "separator0");
  mainbox->Add(separator0,0,0,0,5);
  buttonbox = new VDKBox(this,h_box);
  mainbox->Add(buttonbox,0,0,0,2);
  buttonbox->BorderWidth(0);
  okButton = new VDKCustomButton(this,(const char**) stock_open_16_xpm," OK",16,(GtkPositionType) 1);
  gtk_widget_set_name (GTK_WIDGET(okButton->WrappedWidget()), "okButton");
  buttonbox->Add(okButton,0,1,0,0);
  cancelButton = new VDKCustomButton(this,(const char**) stock_cancel_20_xpm," Cancel",16,(GtkPositionType) 1);
  gtk_widget_set_name (GTK_WIDGET(cancelButton->WrappedWidget()), "cancelButton");
  buttonbox->Add(cancelButton,0,1,0,0);
  // makes GtkFileChooser
  sigwid = gtk_file_chooser_widget_new (GTK_FILE_CHOOSER_ACTION_OPEN);
  // makes dummy
  filechooser = new VDKObject(this,sigwid);
  fcbox->Add(filechooser,l_justify,true,true,0);
  g_signal_connect_data (sigwid, "file-activated", 
			 G_CALLBACK (VDKFileChooser::file_activated), this, 
			 NULL,(GConnectFlags) 0);
}

//signal response method
bool 
VDKFileChooser::OncancelButtonClick(VDKObject* sender) 
{
  Close();
  return true;
}
//signal response method
bool 
VDKFileChooser::OnokButtonClick(VDKObject* sender) 
{
  if(MultiSelection)
    {
      int t = 0;
      GSList* listhead = gtk_file_chooser_get_filenames(GTK_FILE_CHOOSER(sigwid));
      GSList* list = listhead;
      selections->resize(g_slist_length(list ? list : 0));
      while(list)
	{
	  VDKUString s((char*)list->data);
	  (*selections)[t] = s;
	  g_free(list->data);
	  t++;
	  list = list->next;
	}
      if(listhead)
	g_slist_free(listhead);
    }
  else
    {
      char* sel;
      sel = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(sigwid));
      if(sel)
	{
	  selections->resize(1);
	  VDKUString s(sel);
	  (*selections)[0] = s;
	  g_free(sel);
	}
      
    }
 Close();
 return true;
 }
//
void
VDKFileChooser::file_activated (GtkFileChooser *filechooser,
                           gpointer user_data)
{
VDKFileChooser* fc = reinterpret_cast<VDKFileChooser*>(user_data);
fc->OnokButtonClick(NULL);
}

//
void 
VDKFileChooser::AddFilterPattern(char* name, char* pattern)
{
  GtkFileFilter *filter = gtk_file_filter_new ();
  gtk_file_filter_set_name (filter, name);
  gtk_file_filter_add_pattern (filter, pattern);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (sigwid), filter);
}
//
void 
VDKFileChooser::AddMimeType(char* name, char* mime)
{
  GtkFileFilter *filter = gtk_file_filter_new ();
  gtk_file_filter_set_name (filter, name);
  gtk_file_filter_add_mime_type (filter, mime);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (sigwid), filter);
}
//
void VDKFileChooser::SetDefaultFilter(char* name)
{
  GSList* listhead = gtk_file_chooser_list_filters (GTK_FILE_CHOOSER (sigwid));
  GSList* list = listhead;
  while(list)
    {
      const gchar* fname = gtk_file_filter_get_name ((GtkFileFilter*) list->data);
      if(!strcmp(fname,name))
	{
	  gtk_file_chooser_set_filter (GTK_FILE_CHOOSER (sigwid),(GtkFileFilter*) list->data);
	  break;
	}
      list = list->next;
    }
  if(listhead)
    g_slist_free(listhead); 
}
//
void VDKFileChooser::RemoveFilter(char* name)
{
  GSList* listhead = gtk_file_chooser_list_filters (GTK_FILE_CHOOSER (sigwid));
  GSList* list = listhead;
  while(list)
    {
      const gchar* fname = gtk_file_filter_get_name ((GtkFileFilter*) list->data);
      if(!strcmp(fname,name))
	{
	  gtk_file_chooser_remove_filter (GTK_FILE_CHOOSER (sigwid),(GtkFileFilter*) list->data);
	  break;
	}
      list = list->next;
    }
  if(listhead)
    g_slist_free(listhead); 
}


// end of file:vdkfc.cc
