
#include <stdio.h>		// for printf()
#include <iostream>
#include <vdk/vdkustring.h>
#include <vector>

using std::vector;
using std::cout;
using std::endl;

VDKUString Funt(const VDKUString& s)
{
	VDKUString local(s);
	return local;
}

void test1()
{
	// cout seems to dislike NULL pointers...
	//VDKUString A;
	VDKUString A("");
	cout << "Default Constructor: VDKUString A = " << A << endl;

	VDKUString copyofA = A;
	cout << "Copying a null string : copyofA = A = " << copyofA << endl;

	VDKUString B("world");
	cout << "const char* constructor: (VDKUString B(world)) = " << B << endl;

	A = "hello";
	cout << "Assignment from const char*: (A = hello) = " << A << endl;

	VDKUString C = A;
	cout << "Assignment from const VDKUString: (VDKUString C = A) = " << C << endl;
	C += " test";
	cout << "Appending from const char* : (C += test) = " << C << endl;
	C = C + " ntest";
	cout << "Assignment from appending from const char* : (C = C + ntest) = " << C << endl;
	char c = 'x';
	C = C + VDKUString(c);
	cout << "char c = 'x' ;  C = "<< C << endl;
	cout << "Appending a char: C = C + VDKUString(c) = " << C << endl;
	C = VDKUString(c) + C;
	cout << "Prepending a char: C = VDKUString(c) + C = " << C << endl;
	VDKUString ncopyofA;
	cout << "Appending a char to null string : A = ncopyofA + c = " ;
	cout.flush();
	A = ncopyofA + VDKUString(c);
	cout << A << endl;

	cout << "Prepending a char to null string : A = c + ncopyofA =";
	cout.flush();
	A = VDKUString(c) + ncopyofA;
	cout << A << endl;

	cout << "Test of [] operator: B = " << B << endl;
	cout << " B[0] = " << B[(unsigned int)0] << endl;
	cout << " B[1] = " << B[(unsigned int)1] << endl;
	cout << " B[2] = " << B[(unsigned int)2] << endl;
	cout << " B[20] = " << B[(unsigned int)20] << endl;

	cout << "B.c_str() = " ;
	cout.flush();
	cout << B.c_str() << endl;

	cout << " VDKUString + const char* : C = B + 'goozy' = ";
	cout.flush();
	C = B + "goozy";
	cout << C << endl;

	cout << " const char* + VDKUString  : A = 'goozy' + B = ";
	cout.flush();
	A = "goozy" + B ;
	cout << A << endl;

	cout << " VDKUString(NULL) + const char* : C = ncopyofA + 'goozy' = ";
	cout.flush();
	C = ncopyofA + "goozy";
	cout << C << endl;

	cout << " const char* + VDKUString(NULL)  : A = 'goozy' + ncopyofA = ";
	cout.flush();
	A = "goozy" + ncopyofA;
	cout << A << endl;

	cout << "Instantiate a VDKUString from a single character : ";

	VDKUString E('a');
	cout << "E('a') = " << E << endl;
/*
	cout << "Instantiate a VDKUString from a null character : ";
	VDKUString F('\0');
	cout << "F(NULL) = " << F << endl;
*/
	cout << "Assignment of a single character : ";
	VDKUString F = 'b';
	cout << "F = 'b' = " << F << endl;

	cout << "A = " << A << endl;
	cout << "B = " << B << endl;
	cout << "F = " << F << endl;
	cout << "E = " << E << endl;

	cout << "expression test 1: A + B + F + E  = " << A + B + F + E << endl;
	cout << "expression test 2: A + B + \"FreakOut\" + E  = " << A + B + "FreakOut" + E << endl;
	cout << "expression test 3: A + VDKUString('%') + \"FreakOut\" + E  = " << A + VDKUString('%') + "FreakOut" + E << endl;
	
	A = "Hello great world";
	cout << "A = '" << A << "'" << endl;
	// Cut test
	cout << "A.Cut(5) = " << A.Cut(5) << endl;
	// DelSelection test
	cout << "A.DelSelection(3, 3) => A = '" << A.DelSelection(3, 3) << "'" << endl;
	A = "           Hello great world             ";
	// Trim test
	cout << "A.RTrim() => A = '" << A.RTrim() << "'" << endl;
	cout << "A.LTrim() => A = '" << A.LTrim() << "'" << endl;
	// CharCount test
	cout << "A.CharCount(\"o\") = " << A.CharCount("o") << endl;
	cout << "A.CharCount(\"l\") = " << A.CharCount("l") << endl;
	// UpperCase test
	cout << "A.UpperCase() => A = " << A.UpperCase() << endl;
	// LowerCase test
	cout << "A.LowerCase() => A = " << A.LowerCase() << endl;
	// Sorry for this french sentence, but i have to test UTF-8 chars
	A = "Espèce d'été français à Noël";
	cout << "A.size() => A = " << A.size() << endl;
	cout << "A.Len() => A = " << A.Len() << endl;
	cout << "A.UpperCase() => A = " << A.UpperCase() << endl;
	// LowerCase test
	cout << "A.LowerCase() => A = " << A.LowerCase() << endl;
	// isEmpty test
	A = "";
	cout << "A = '', A.isEmpty() = " << A.isEmpty() << endl;
	A = "Hello world";
	cout << "A = 'Hello world', A.isEmpty() = " << A.isEmpty() << endl;
	// Sprintf test
	cout << "A = 'Hello world', A.Sprintf('%d char is left from %s', 0, 'previous string') => A = "
		<< A.Sprintf("%d char is left from %s", 0, "previous string") << endl;
	// Concatf test
	A = "Hello";
	cout << "A = 'Hello', A.Concatf(' %dth %s', 5, 'world') => A = " << A.Concatf(" %dth %s", 5, "world") << endl;
	// SubStr test
	A = "J'ai payé 125 € ce paquet français";
	cout << "A = 'J'ai payé 125 € ce paquet français', A.SubStr(5, 20) = " << A.SubStr(5, 20) << endl;
	A = "9600,8,n,1";
	cout << "A = 9600,8,n,1 A.SubStr(0, 4) = " << A.SubStr(0, 4) << endl;
	A = "9600,8,n,1";
	cout << "A = 9600,8,n,1 A.SubStr(5, 1) = " << A.SubStr(5, 1) << endl;
	A = "9600,8,n,1";
	cout << "A = 9600,8,n,1 A.SubStr(20, 4) = " << A.SubStr(20, 4) << endl;
	A = "9600,8,n,1";
	cout << "A = 9600,8,n,1 A.SubStr(5, 50) = " << A.SubStr(5, 50) << endl;
	// GetPart test
	A = "CustPartNumber#Réf. client";
	//cout << "A = 'CustPartNumber#Réf. client, A.GetPart(2, '#') = " << A.GetPart(2, '#') << endl;
	VDKUString Message = A;
	Message.GetPart(1, '#').Trim().UpperCase();
	cout << "Message = 'CustPartNumber#Réf. client, Message.GetPart(1, '#').Trim().UpperCase() = " << Message << endl;
	VDKUString Traduc = A;
	cout << "Traduc = A, Traduc = " << Traduc << endl;
	Traduc.GetPart(2, '#');
	cout << "Traduc.GetPart(2, '#') = " << Traduc << endl;
	Traduc.Trim();
	cout << "Traduc.Trim() = " << Traduc << endl;
	
	A = "9600,8,n,1";
	cout << "A = 9600,8,n,1 A.CharCount(',') = " << A.CharCount(',') << endl;
	cout << "A = '9600,8,n,1', A.GetPart(1, ',') = " << A.GetPart(1, ',') << endl;
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetPart(2, ',') = " << A.GetPart(2, ',') << endl;
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetPart(4, ',') = " << A.GetPart(4, ',') << endl;
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetPart(1, ':') = " << A.GetPart(1, ':') << endl;
	//cout << "A = '9600,8,n,1', A.GetPart(6, ',') = " << A.GetPart(6, ',') << endl;
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.ReplaceChar(',', ';') = " << A.ReplaceChar(',', ';') << endl;
	cout << "A.DoubleChar(';') = " << A.DoubleChar(';') << endl;
	cout << "A.StripChar(';') = " << A.StripChar(';') << endl;
	A = "9600#!#8#!#n#!#1";
	cout << "A = '9600#!#8#!#n#!#1', A.ReplaceChar(#!#, €) = " << A.ReplaceChar("#!#", "€") << endl;
	cout << "A.DoubleChar(€) = " << A.DoubleChar("€") << endl;
	cout << "A.StripChar(€) = " << A.StripChar("€") << endl;
	// GetPart test
	// New CharCountStr test
	cout << "A = 9600#!#8#!#n#!#1 A.CharCount(\"#!#\") = " << A.CharCount("#!#") << endl;
	cout << "A = '9600#!#8#!#n#!#1', A.GetPart(1, \"#!#\") = " << A.GetPart(1, "#!#") << endl;
	A = "9600#!#8#!#n#!#1";
	cout << "A = '9600#!#8#!#n#!#1', A.GetPart(3, \"#!#\") = " << A.GetPart(3, "#!#") << endl;
	A = "9600#!#8#!#n#!#1";
	cout << "A = '9600#!#8#!#n#!#1', A.GetPart(4, \"#!#\") = " << A.GetPart(4, "#!#") << endl;
	A = "9600#!#8#!#n#!#1";
	cout << "A = '9600#!#8#!#n#!#1', A.GetPart(1, \"##\") = " << A.GetPart(1, "##") << endl;
	A = "9600#!#8#!#n#!#1";
	// GetPart test
	// New CharCount test
	B = "9600€8€n€1";
	A = B;
	cout << "A = 9600€8€n€1 A.CharCount(\"€\") = " << A.CharCount("€") << endl;
	cout << "A = '9600€8€n€1', A.GetPart(1, \"€\") = " << A.GetPart(1, "€") << endl;
	cout << "B = " << B << endl;
	A = "9600€8€n€1";
	cout << "A = '9600€8€n€1', A.GetPart(3, \"€\") = " << A.GetPart(3, "€") << endl;
	A = "9600€8€n€1";
	cout << "A = '9600€8€n€1', A.GetPart(4, \"€\") = " << A.GetPart(4, "€") << endl;
	A = "9600€8€n€1";
	//cout << "A = '9600€8€n€1', A.GetPart(6, \"€\") = " << A.GetPart(6, "€") << endl;
	cout << "A = '9600€8€n€1', A.GetPart(1, \"à\") = " << A.GetPart(1, "à") << endl;
	A = "9600€8€n€1";
	cout << "A = '9600€8€n€1', A.ReplaceChar(€, é) = " << A.ReplaceChar("€", "é") << endl;
	cout << "A.DoubleChar(é) = " << A.DoubleChar("é") << endl;
	cout << "A.StripChar(é) = " << A.StripChar("é") << endl;
	A = "/opt1/tests/inputbox/inputbox.prj";
	cout << "A = '/opt1/tests/inputbox/inputbox.prj', A.GetPart(1, \".prj\") = " << A.GetPart(1, ".prj") << endl;
	// GetFCharPos test
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetFCharPos(\",\") = " << A.GetFCharPos(",") << endl;
	// GetLCharPos test
	A = "9600,8,n,1";
	cout << "A = '9600,8,n,1', A.GetLCharPos(\",\") = " << A.GetLCharPos(",") << endl;
	A = "9600€8€n€1";
	cout << "A = '9600€8€n€1', A.GetFCharPos(\"€\") = " << A.GetFCharPos("€") << endl;
	//A = "9600€8€n€1";
	cout << "A = '9600€8€n€1', A.GetLCharPos(\"€\") = " << A.GetLCharPos("€") << endl;
	A = "9600#!#8#!#n#!#1";
	cout << "A = '9600#!#8#!#n#!#1', A.GetFCharPos(\"#!#\") = " << A.GetFCharPos("#!#") << endl;
	//A = "9600#!#8#!#n#!#1";
	cout << "A = '9600#!#8#!#n#!#1', A.GetLCharPos(\"#!#\") = " << A.GetLCharPos("#!#") << endl;
	// StrtoDouble test
	A = "375265.653";
	// commented because cout round this to an integer
	//cout << "A = '375265.653', A.StrtoDouble() = " << A.StrtoDouble() << endl;
	printf("A = '375265.653', A.StrtoDouble() = %f\n", A.StrtoDouble());
	// StrtoInt test
	A = "375";
	cout << "A = '375', A.StrtoInt() = " << A.StrtoInt() << endl;
	// SubStr test
	A = "Hello great world";
	cout << "A = 'Hello great world', A.SubStr(6, 5) = '" << A.SubStr(6, 5) << "'" << endl;
	// LPad test
	cout << "A.LPad(8, 'o') = " << A.LPad(8, 'o') << endl;
	// RPad test
	cout << "A.RPad(13, 'o') = " << A.RPad(13, 'o') << endl;
	// Cut test
	cout << "A.Cut(13) = " << A.Cut(13) << endl;
	// DoubleChar test
	A = "Don't do that";
	cout << "A.DoubleChar() => A = " << A.DoubleChar() << endl;
	// FormatDate test
	A = "12/25/2000";
	cout << "A = '12/25/2000'" << endl;
	cout << "A.FormatDate(0, ENG_DATE, INT_DATE) => A = " << A.FormatDate(0, ENG_DATE, INT_DATE) << endl;
	cout << "A.FormatDate('/', INT_DATE, EUR_DATE) => A = " << A.FormatDate('/', INT_DATE, EUR_DATE) << endl;
	cout << "A.FormatDate(0, EUR_DATE, ENG_DATE) => A = " << A.FormatDate(0, EUR_DATE, ENG_DATE) << endl;
	cout << "A.FormatDate('/', ENG_DATE, ENG_DATE) => A = " << A.FormatDate('/', ENG_DATE, ENG_DATE) << endl;
	A = "           Hello great € world             ";
	cout << "A = '" << A << "'" << endl;
	A = A.GetPart(1, "€").Trim();
	cout << "A = A.GetPart(1, €).Trim() => A = '" << A << "'" << endl;
	A.Sprintf("%s\n%s", "Hello", "world");
	cout << "A = '" << A << "'" << endl;
	B = A.GetPart(1, '\n');
	cout << "B = A.GetPart(1, '\\n') => B = '" << B << "'" << endl;
	cout << "A = '" << A << "'" << endl;
	A = "6125.385";
	cout << "A = '" << A << "'" << endl;
	//cout << "A.FloattoUserFormat() = '" << A.FloattoUserFormat() << "'" << endl;
}

vector<VDKUString> vectortest()
{

	cout << endl;
	cout << "STL Test... endl;" << endl;
	cout << "Making a vector of strings..." << endl;

	vector<VDKUString> strings;

	strings.push_back(VDKUString("AstringA"));
	strings.push_back(VDKUString("BstringB"));
	strings.push_back(VDKUString("CstringC"));
	strings.push_back(VDKUString("DstringD"));
	strings.push_back(VDKUString("EstringE"));
	strings.push_back(VDKUString("FstringF"));
	strings.push_back(VDKUString("GstringG"));

	cout << "Reading the vector using an iterator..." << endl;
	for(vector<VDKUString>::iterator i= strings.begin(); i != strings.end(); i++)
	{
		cout << "*i = " << *i << endl;
	}
	cout << "Reading the vector using [] operator" << endl;
	for(unsigned int j = 0; j < strings.size(); j++)
	{
		//VDKUString s = strings[j];
		VDKUString s(strings[j]);
		cout << "strings[ " << j << " ]  = " << s << endl;
	}

	return strings;
}


void DumpVDKUStringVector(const vector<VDKUString>& A)
{

	cout << "Reading the returned vector using an const iterator..." << endl;
	for(vector<VDKUString>::const_iterator i= A.begin(); i != A.end(); i++)
	{
		cout << "i->c_str() = " << i->c_str() << endl;
	}
	cout << "Reading the returned vector using [] operator" << endl;
	for(unsigned int j = 0; j < A.size(); j++)
	{
		VDKUString s = A[j];
		cout << "strings[ " << j << " ]  = " << s << endl;
	}
}

void stltest()
{
	vector<VDKUString> A = vectortest();
	DumpVDKUStringVector(A);

}

int main()
{
	test1();
	stltest();
}
/*

	cout << "C = " << C << endl;
	VDKUString D = Funt(C);
	cout << "D = Funt(C) = " << D << endl;

	vector<VDKUString> pile;
	pile.push_back(A);
	pile.push_back(B);
	pile.push_back(C);
	pile.push_back(D);
	pile.push_back(A);

	vector<VDKUString> stack = pile;

	for(vector<VDKUString>::iterator i = stack.begin(); i!= stack.end(); i++)
	cout << "*i = " << *i << endl;
}

*/	
