/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.24
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"

        #include <wx/config.h>

        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        static PyObject* _Config_EnumerationHelper(bool flag, wxString& str, long index) {
        wxPyThreadBlocker blocker;
            PyObject* ret = PyTuple_New(3);
            if (ret) {
                PyTuple_SET_ITEM(ret, 0, PyBool_FromLong(flag));
                PyTuple_SET_ITEM(ret, 1, wx2PyString(str));
                PyTuple_SET_ITEM(ret, 2, wxPyInt_FromLong(index));
            }
            return ret;
        }
    PyObject* _wxConfigBase_GetFirstEntry(wxConfigBase* self)
    {
        bool     more;
        long     index = 0;
        wxString value;
        more = self->GetFirstEntry(value, index);
        return _Config_EnumerationHelper(more, value, index);
    }
    PyObject* _wxConfigBase_GetFirstGroup(wxConfigBase* self)
    {
        bool     more;
        long     index = 0;
        wxString value;
        more = self->GetFirstGroup(value, index);
        return _Config_EnumerationHelper(more, value, index);
    }
    PyObject* _wxConfigBase_GetNextEntry(wxConfigBase* self, long index)
    {
        bool     more;
        wxString value;
        more = self->GetNextEntry(value, index);
        return _Config_EnumerationHelper(more, value, index);
    }
    PyObject* _wxConfigBase_GetNextGroup(wxConfigBase* self, long index)
    {
        bool more;
        wxString value;
        more = self->GetNextGroup(value, index);
        return _Config_EnumerationHelper(more, value, index);
    }
    bool _wxConfigBase_ReadBool(wxConfigBase* self, const wxString* key, bool defaultVal)
    {
        bool rv;
        self->Read(*key, &rv, defaultVal);
        return rv;
    }
    long _wxConfigBase__cpp_ReadInt(wxConfigBase* self, const wxString* key, long defaultVal)
    {
        long rv;
        self->Read(*key, &rv, defaultVal);
        return rv;
    }
    double _wxConfigBase_ReadFloat(wxConfigBase* self, const wxString* key, double defaultVal)
    {
        double rv;
        self->Read(*key, &rv, defaultVal);
        return rv;
    }
    bool _wxConfigBase_WriteInt(wxConfigBase* self, const wxString* key, long value)
    {
        return self->Write(*key, value);
    }
    bool _wxConfigBase_WriteFloat(wxConfigBase* self, const wxString* key, double value)
    {
        return self->Write(*key, value);
    }
    bool _wxConfigBase_WriteBool(wxConfigBase* self, const wxString* key, bool value)
    {
        return self->Write(*key, value);
    }


PyDoc_STRVAR(doc_wxConfigBase_GetPath, "GetPath() -> String\n"
"\n"
"Retrieve the current path (always as absolute path).");

extern "C" {static PyObject *meth_wxConfigBase_GetPath(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetPath(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxConfigBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxConfigBase, &sipCpp))
        {
             ::wxString*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_GetPath);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPath());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetPath, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_SetPath, "SetPath(strPath)\n"
"\n"
"Set current path: if the first character is '/', it is the absolute\n"
"path, otherwise it is a relative path.");

extern "C" {static PyObject *meth_wxConfigBase_SetPath(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_SetPath(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* strPath;
        int strPathState = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strPath,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&strPath, &strPathState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_SetPath);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPath(*strPath);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(strPath),sipType_wxString,strPathState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_SetPath, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetFirstEntry, "GetFirstEntry() -> PyObject\n"
"\n"
"GetFirstEntry() -> (more, value, index)\n"
"\n"
"Allows enumerating the entries in the current group in a config\n"
"object.  Returns a tuple containing a flag indicating if there are\n"
"more\n"
"items, the name of the current item, and an index to pass to\n"
"GetNextEntry to fetch the next item.");

extern "C" {static PyObject *meth_wxConfigBase_GetFirstEntry(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetFirstEntry(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxConfigBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxConfigBase, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_GetFirstEntry(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetFirstEntry, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetFirstGroup, "GetFirstGroup() -> PyObject\n"
"\n"
"GetFirstGroup() -> (more, value, index)\n"
"\n"
"Allows enumerating the subgroups in a config object.  Returns a tuple\n"
"containing a flag indicating if there are more items, the name of the\n"
"current item, and an index to pass to GetNextGroup to fetch the next\n"
"item.");

extern "C" {static PyObject *meth_wxConfigBase_GetFirstGroup(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetFirstGroup(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxConfigBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxConfigBase, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_GetFirstGroup(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetFirstGroup, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetNextEntry, "GetNextEntry(index) -> PyObject\n"
"\n"
"GetNextEntry() -> (more, value, index)\n"
"\n"
"Allows enumerating the entries in the current group in a config\n"
"object.  Returns a tuple containing a flag indicating if there are\n"
"more\n"
"items, the name of the current item, and an index to pass to\n"
"GetNextEntry to fetch the next item.");

extern "C" {static PyObject *meth_wxConfigBase_GetNextEntry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetNextEntry(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long index;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxConfigBase, &sipCpp, &index))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_GetNextEntry(sipCpp, index);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetNextEntry, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetNextGroup, "GetNextGroup(index) -> PyObject\n"
"\n"
"GetNextGroup(long index) -> (more, value, index)\n"
"\n"
"Allows enumerating the subgroups in a config object.  Returns a tuple\n"
"containing a flag indicating if there are more items, the name of the\n"
"current item, and an index to pass to GetNextGroup to fetch the next\n"
"item.");

extern "C" {static PyObject *meth_wxConfigBase_GetNextGroup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetNextGroup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long index;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_index,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxConfigBase, &sipCpp, &index))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_GetNextGroup(sipCpp, index);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetNextGroup, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetNumberOfEntries, "GetNumberOfEntries(bRecursive=False) -> size_t\n"
"\n"
"Get number of entries in the current group.");

extern "C" {static PyObject *meth_wxConfigBase_GetNumberOfEntries(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetNumberOfEntries(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        bool bRecursive = 0;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bRecursive,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxConfigBase, &sipCpp, &bRecursive))
        {
            size_t sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_GetNumberOfEntries);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNumberOfEntries(bRecursive);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetNumberOfEntries, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetNumberOfGroups, "GetNumberOfGroups(bRecursive=False) -> size_t\n"
"\n"
"Get number of entries/subgroups in the current group, with or without\n"
"its subgroups.");

extern "C" {static PyObject *meth_wxConfigBase_GetNumberOfGroups(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetNumberOfGroups(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        bool bRecursive = 0;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bRecursive,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxConfigBase, &sipCpp, &bRecursive))
        {
            size_t sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_GetNumberOfGroups);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetNumberOfGroups(bRecursive);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetNumberOfGroups, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_Exists, "Exists(strName) -> bool");

extern "C" {static PyObject *meth_wxConfigBase_Exists(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_Exists(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* strName;
        int strNameState = 0;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&strName, &strNameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Exists(*strName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(strName),sipType_wxString,strNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_Exists, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetEntryType, "GetEntryType(name) -> ConfigBase.EntryType\n"
"\n"
"Returns the type of the given entry or Unknown if the entry doesn't\n"
"exist.");

extern "C" {static PyObject *meth_wxConfigBase_GetEntryType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetEntryType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&name, &nameState))
        {
             ::wxConfigBase::EntryType sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxConfigBase::GetEntryType(*name) : sipCpp->GetEntryType(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name),sipType_wxString,nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxConfigBase_EntryType);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetEntryType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_HasEntry, "HasEntry(strName) -> bool");

extern "C" {static PyObject *meth_wxConfigBase_HasEntry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_HasEntry(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* strName;
        int strNameState = 0;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&strName, &strNameState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_HasEntry);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasEntry(*strName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(strName),sipType_wxString,strNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_HasEntry, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_HasGroup, "HasGroup(strName) -> bool");

extern "C" {static PyObject *meth_wxConfigBase_HasGroup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_HasGroup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* strName;
        int strNameState = 0;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_strName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&strName, &strNameState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_HasGroup);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasGroup(*strName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(strName),sipType_wxString,strNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_HasGroup, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetAppName, "GetAppName() -> String\n"
"\n"
"Returns the application name.");

extern "C" {static PyObject *meth_wxConfigBase_GetAppName(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetAppName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxConfigBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxConfigBase, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetAppName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetAppName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_GetVendorName, "GetVendorName() -> String\n"
"\n"
"Returns the vendor name.");

extern "C" {static PyObject *meth_wxConfigBase_GetVendorName(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_GetVendorName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxConfigBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxConfigBase, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetVendorName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_GetVendorName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_Flush, "Flush(bCurrentOnly=False) -> bool\n"
"\n"
"Permanently writes all changes (otherwise, they're only written from\n"
"object's destructor).");

extern "C" {static PyObject *meth_wxConfigBase_Flush(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_Flush(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        bool bCurrentOnly = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bCurrentOnly,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxConfigBase, &sipCpp, &bCurrentOnly))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_Flush);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Flush(bCurrentOnly);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_Flush, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_Read, "Read(key, defaultVal=EmptyString) -> String\n"
"\n"
"Another version of Read(), returning the string value directly.");

extern "C" {static PyObject *meth_wxConfigBase_Read(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_Read(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        const  ::wxString& defaultValdef = wxEmptyString;
        const  ::wxString* defaultVal = &defaultValdef;
        int defaultValState = 0;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_defaultVal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, sipType_wxString,&defaultVal, &defaultValState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->Read(*key,*defaultVal));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);
            sipReleaseType(const_cast< ::wxString *>(defaultVal),sipType_wxString,defaultValState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_Read, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_ReadBool, "ReadBool(key, defaultVal=False) -> bool");

extern "C" {static PyObject *meth_wxConfigBase_ReadBool(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_ReadBool(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        bool defaultVal = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_defaultVal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|b", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &defaultVal))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_ReadBool(sipCpp, key, defaultVal);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_ReadBool, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_ReadDouble, "ReadDouble(key, defaultVal) -> double\n"
"\n"
"Reads a double value from the key and returns it.");

extern "C" {static PyObject *meth_wxConfigBase_ReadDouble(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_ReadDouble(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        double defaultVal;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_defaultVal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1d", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &defaultVal))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ReadDouble(*key,defaultVal);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_ReadDouble, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_ReadLong, "ReadLong(key, defaultVal) -> long\n"
"\n"
"Reads a long value from the key and returns it.");

extern "C" {static PyObject *meth_wxConfigBase_ReadLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_ReadLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        long defaultVal;
        const  ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_defaultVal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1l", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &defaultVal))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ReadLong(*key,defaultVal);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_ReadLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_Write, "Write(key, value) -> bool\n"
"\n"
"Writes the wxString value to the config file and returns true on\n"
"success.");

extern "C" {static PyObject *meth_wxConfigBase_Write(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_Write(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        const  ::wxString* value;
        int valueState = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, sipType_wxString,&value, &valueState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Write(*key,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);
            sipReleaseType(const_cast< ::wxString *>(value),sipType_wxString,valueState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_Write, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_RenameEntry, "RenameEntry(oldName, newName) -> bool\n"
"\n"
"Renames an entry in the current group.");

extern "C" {static PyObject *meth_wxConfigBase_RenameEntry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_RenameEntry(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* oldName;
        int oldNameState = 0;
        const  ::wxString* newName;
        int newNameState = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_oldName,
            sipName_newName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&oldName, &oldNameState, sipType_wxString,&newName, &newNameState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_RenameEntry);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RenameEntry(*oldName,*newName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(oldName),sipType_wxString,oldNameState);
            sipReleaseType(const_cast< ::wxString *>(newName),sipType_wxString,newNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_RenameEntry, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_RenameGroup, "RenameGroup(oldName, newName) -> bool\n"
"\n"
"Renames a subgroup of the current group.");

extern "C" {static PyObject *meth_wxConfigBase_RenameGroup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_RenameGroup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* oldName;
        int oldNameState = 0;
        const  ::wxString* newName;
        int newNameState = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_oldName,
            sipName_newName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&oldName, &oldNameState, sipType_wxString,&newName, &newNameState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_RenameGroup);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RenameGroup(*oldName,*newName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(oldName),sipType_wxString,oldNameState);
            sipReleaseType(const_cast< ::wxString *>(newName),sipType_wxString,newNameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_RenameGroup, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_DeleteAll, "DeleteAll() -> bool\n"
"\n"
"Delete the whole underlying object (disk file, registry key, ...).");

extern "C" {static PyObject *meth_wxConfigBase_DeleteAll(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_DeleteAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxConfigBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxConfigBase, &sipCpp))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_DeleteAll);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeleteAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_DeleteAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_DeleteEntry, "DeleteEntry(key, bDeleteGroupIfEmpty=True) -> bool\n"
"\n"
"Deletes the specified entry and the group it belongs to if it was the\n"
"last key in it and the second parameter is true.");

extern "C" {static PyObject *meth_wxConfigBase_DeleteEntry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_DeleteEntry(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* key;
        int keyState = 0;
        bool bDeleteGroupIfEmpty = 1;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_bDeleteGroupIfEmpty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|b", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &bDeleteGroupIfEmpty))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_DeleteEntry);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeleteEntry(*key,bDeleteGroupIfEmpty);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_DeleteEntry, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_DeleteGroup, "DeleteGroup(key) -> bool\n"
"\n"
"Delete the group (with all subgroups).");

extern "C" {static PyObject *meth_wxConfigBase_DeleteGroup(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_DeleteGroup(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* key;
        int keyState = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_ConfigBase, sipName_DeleteGroup);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DeleteGroup(*key);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_DeleteGroup, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_IsExpandingEnvVars, "IsExpandingEnvVars() -> bool\n"
"\n"
"Returns true if we are expanding environment variables in key values.");

extern "C" {static PyObject *meth_wxConfigBase_IsExpandingEnvVars(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_IsExpandingEnvVars(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxConfigBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxConfigBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsExpandingEnvVars();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_IsExpandingEnvVars, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_IsRecordingDefaults, "IsRecordingDefaults() -> bool\n"
"\n"
"Returns true if we are writing defaults back to the config file.");

extern "C" {static PyObject *meth_wxConfigBase_IsRecordingDefaults(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_IsRecordingDefaults(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxConfigBase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxConfigBase, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsRecordingDefaults();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_IsRecordingDefaults, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_SetExpandEnvVars, "SetExpandEnvVars(bDoIt=True)\n"
"\n"
"Determine whether we wish to expand environment variables in key\n"
"values.");

extern "C" {static PyObject *meth_wxConfigBase_SetExpandEnvVars(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_SetExpandEnvVars(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool bDoIt = 1;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bDoIt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxConfigBase, &sipCpp, &bDoIt))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetExpandEnvVars(bDoIt);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_SetExpandEnvVars, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_SetRecordDefaults, "SetRecordDefaults(bDoIt=True)\n"
"\n"
"Sets whether defaults are recorded to the config file whenever an\n"
"attempt to read the value which is not present in it is done.");

extern "C" {static PyObject *meth_wxConfigBase_SetRecordDefaults(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_SetRecordDefaults(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool bDoIt = 1;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bDoIt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxConfigBase, &sipCpp, &bDoIt))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRecordDefaults(bDoIt);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_SetRecordDefaults, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_Create, "Create() -> ConfigBase\n"
"\n"
"Create a new config object and sets it as the current one.");

extern "C" {static PyObject *meth_wxConfigBase_Create(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_Create(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxConfigBase*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxConfigBase::Create();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxConfigBase,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_Create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_DontCreateOnDemand, "DontCreateOnDemand()\n"
"\n"
"Calling this function will prevent Get() from automatically creating a\n"
"new config object if the current one is NULL.");

extern "C" {static PyObject *meth_wxConfigBase_DontCreateOnDemand(PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_DontCreateOnDemand(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxConfigBase::DontCreateOnDemand();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_DontCreateOnDemand, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_Get, "Get(CreateOnDemand=True) -> ConfigBase\n"
"\n"
"Get the current config object.");

extern "C" {static PyObject *meth_wxConfigBase_Get(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_Get(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool CreateOnDemand = 1;

        static const char *sipKwdList[] = {
            sipName_CreateOnDemand,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "|b", &CreateOnDemand))
        {
             ::wxConfigBase*sipRes;

        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxConfigBase::Get(CreateOnDemand);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxConfigBase,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_Set, "Set(pConfig) -> ConfigBase\n"
"\n"
"Sets the config object as the current one, returns the pointer to the\n"
"previous current object (both the parameter and returned value may be\n"
"NULL).");

extern "C" {static PyObject *meth_wxConfigBase_Set(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_Set(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxConfigBase* pConfig;

        static const char *sipKwdList[] = {
            sipName_pConfig,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J:", sipType_wxConfigBase, &pConfig))
        {
             ::wxConfigBase*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxConfigBase::Set(pConfig);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxConfigBase,Py_None);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_Set, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase__cpp_ReadInt, "_cpp_ReadInt(key, defaultVal=0) -> long");

extern "C" {static PyObject *meth_wxConfigBase__cpp_ReadInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase__cpp_ReadInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        long defaultVal = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_defaultVal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|l", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &defaultVal))
        {
            long sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase__cpp_ReadInt(sipCpp, key, defaultVal);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (sipIsErr)
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName__cpp_ReadInt, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_ReadFloat, "ReadFloat(key, defaultVal=0.0) -> double");

extern "C" {static PyObject *meth_wxConfigBase_ReadFloat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_ReadFloat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        double defaultVal = 0;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_defaultVal,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|d", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &defaultVal))
        {
            double sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_ReadFloat(sipCpp, key, defaultVal);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (sipIsErr)
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_ReadFloat, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_WriteInt, "WriteInt(key, value) -> bool");

extern "C" {static PyObject *meth_wxConfigBase_WriteInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_WriteInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        long value;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1l", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &value))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_WriteInt(sipCpp, key, value);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_WriteInt, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_WriteFloat, "WriteFloat(key, value) -> bool");

extern "C" {static PyObject *meth_wxConfigBase_WriteFloat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_WriteFloat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        double value;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1d", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &value))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_WriteFloat(sipCpp, key, value);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_WriteFloat, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxConfigBase_WriteBool, "WriteBool(key, value) -> bool");

extern "C" {static PyObject *meth_wxConfigBase_WriteBool(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxConfigBase_WriteBool(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* key;
        int keyState = 0;
        bool value;
         ::wxConfigBase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1b", &sipSelf, sipType_wxConfigBase, &sipCpp, sipType_wxString,&key, &keyState, &value))
        {
            bool sipRes = 0;
            int sipIsErr = 0;

        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxConfigBase_WriteBool(sipCpp, key, value);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;
            sipReleaseType(const_cast< ::wxString *>(key),sipType_wxString,keyState);

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ConfigBase, sipName_WriteBool, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxConfigBase(void *, const sipTypeDef *);}
static void *cast_wxConfigBase(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxConfigBase *sipCpp = reinterpret_cast< ::wxConfigBase *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxConfigBase(void *, int);}
static void release_wxConfigBase(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxConfigBase *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxConfigBase(sipSimpleWrapper *);}
static void dealloc_wxConfigBase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxConfigBase(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxConfigBase[] = {{371, 255, 1}};


static PyMethodDef methods_wxConfigBase[] = {
    {SIP_MLNAME_CAST(sipName_Create), meth_wxConfigBase_Create, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_Create)},
    {SIP_MLNAME_CAST(sipName_DeleteAll), meth_wxConfigBase_DeleteAll, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_DeleteAll)},
    {SIP_MLNAME_CAST(sipName_DeleteEntry), SIP_MLMETH_CAST(meth_wxConfigBase_DeleteEntry), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_DeleteEntry)},
    {SIP_MLNAME_CAST(sipName_DeleteGroup), SIP_MLMETH_CAST(meth_wxConfigBase_DeleteGroup), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_DeleteGroup)},
    {SIP_MLNAME_CAST(sipName_DontCreateOnDemand), meth_wxConfigBase_DontCreateOnDemand, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_DontCreateOnDemand)},
    {SIP_MLNAME_CAST(sipName_Exists), SIP_MLMETH_CAST(meth_wxConfigBase_Exists), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_Exists)},
    {SIP_MLNAME_CAST(sipName_Flush), SIP_MLMETH_CAST(meth_wxConfigBase_Flush), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_Flush)},
    {SIP_MLNAME_CAST(sipName_Get), SIP_MLMETH_CAST(meth_wxConfigBase_Get), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_Get)},
    {SIP_MLNAME_CAST(sipName_GetAppName), meth_wxConfigBase_GetAppName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_GetAppName)},
    {SIP_MLNAME_CAST(sipName_GetEntryType), SIP_MLMETH_CAST(meth_wxConfigBase_GetEntryType), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_GetEntryType)},
    {SIP_MLNAME_CAST(sipName_GetFirstEntry), meth_wxConfigBase_GetFirstEntry, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_GetFirstEntry)},
    {SIP_MLNAME_CAST(sipName_GetFirstGroup), meth_wxConfigBase_GetFirstGroup, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_GetFirstGroup)},
    {SIP_MLNAME_CAST(sipName_GetNextEntry), SIP_MLMETH_CAST(meth_wxConfigBase_GetNextEntry), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_GetNextEntry)},
    {SIP_MLNAME_CAST(sipName_GetNextGroup), SIP_MLMETH_CAST(meth_wxConfigBase_GetNextGroup), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_GetNextGroup)},
    {SIP_MLNAME_CAST(sipName_GetNumberOfEntries), SIP_MLMETH_CAST(meth_wxConfigBase_GetNumberOfEntries), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_GetNumberOfEntries)},
    {SIP_MLNAME_CAST(sipName_GetNumberOfGroups), SIP_MLMETH_CAST(meth_wxConfigBase_GetNumberOfGroups), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_GetNumberOfGroups)},
    {SIP_MLNAME_CAST(sipName_GetPath), meth_wxConfigBase_GetPath, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_GetPath)},
    {SIP_MLNAME_CAST(sipName_GetVendorName), meth_wxConfigBase_GetVendorName, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_GetVendorName)},
    {SIP_MLNAME_CAST(sipName_HasEntry), SIP_MLMETH_CAST(meth_wxConfigBase_HasEntry), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_HasEntry)},
    {SIP_MLNAME_CAST(sipName_HasGroup), SIP_MLMETH_CAST(meth_wxConfigBase_HasGroup), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_HasGroup)},
    {SIP_MLNAME_CAST(sipName_IsExpandingEnvVars), meth_wxConfigBase_IsExpandingEnvVars, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_IsExpandingEnvVars)},
    {SIP_MLNAME_CAST(sipName_IsRecordingDefaults), meth_wxConfigBase_IsRecordingDefaults, METH_VARARGS, SIP_MLDOC_CAST(doc_wxConfigBase_IsRecordingDefaults)},
    {SIP_MLNAME_CAST(sipName_Read), SIP_MLMETH_CAST(meth_wxConfigBase_Read), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_Read)},
    {SIP_MLNAME_CAST(sipName_ReadBool), SIP_MLMETH_CAST(meth_wxConfigBase_ReadBool), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_ReadBool)},
    {SIP_MLNAME_CAST(sipName_ReadDouble), SIP_MLMETH_CAST(meth_wxConfigBase_ReadDouble), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_ReadDouble)},
    {SIP_MLNAME_CAST(sipName_ReadFloat), SIP_MLMETH_CAST(meth_wxConfigBase_ReadFloat), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_ReadFloat)},
    {SIP_MLNAME_CAST(sipName_ReadLong), SIP_MLMETH_CAST(meth_wxConfigBase_ReadLong), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_ReadLong)},
    {SIP_MLNAME_CAST(sipName_RenameEntry), SIP_MLMETH_CAST(meth_wxConfigBase_RenameEntry), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_RenameEntry)},
    {SIP_MLNAME_CAST(sipName_RenameGroup), SIP_MLMETH_CAST(meth_wxConfigBase_RenameGroup), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_RenameGroup)},
    {SIP_MLNAME_CAST(sipName_Set), SIP_MLMETH_CAST(meth_wxConfigBase_Set), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_Set)},
    {SIP_MLNAME_CAST(sipName_SetExpandEnvVars), SIP_MLMETH_CAST(meth_wxConfigBase_SetExpandEnvVars), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_SetExpandEnvVars)},
    {SIP_MLNAME_CAST(sipName_SetPath), SIP_MLMETH_CAST(meth_wxConfigBase_SetPath), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_SetPath)},
    {SIP_MLNAME_CAST(sipName_SetRecordDefaults), SIP_MLMETH_CAST(meth_wxConfigBase_SetRecordDefaults), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_SetRecordDefaults)},
    {SIP_MLNAME_CAST(sipName_Write), SIP_MLMETH_CAST(meth_wxConfigBase_Write), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_Write)},
    {SIP_MLNAME_CAST(sipName_WriteBool), SIP_MLMETH_CAST(meth_wxConfigBase_WriteBool), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_WriteBool)},
    {SIP_MLNAME_CAST(sipName_WriteFloat), SIP_MLMETH_CAST(meth_wxConfigBase_WriteFloat), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_WriteFloat)},
    {SIP_MLNAME_CAST(sipName_WriteInt), SIP_MLMETH_CAST(meth_wxConfigBase_WriteInt), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase_WriteInt)},
    {SIP_MLNAME_CAST(sipName__cpp_ReadInt), SIP_MLMETH_CAST(meth_wxConfigBase__cpp_ReadInt), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxConfigBase__cpp_ReadInt)}
};

static sipEnumMemberDef enummembers_wxConfigBase[] = {
    {sipName_Type_Boolean, static_cast<int>( ::wxConfigBase::Type_Boolean), 88},
    {sipName_Type_Float, static_cast<int>( ::wxConfigBase::Type_Float), 88},
    {sipName_Type_Integer, static_cast<int>( ::wxConfigBase::Type_Integer), 88},
    {sipName_Type_String, static_cast<int>( ::wxConfigBase::Type_String), 88},
    {sipName_Type_Unknown, static_cast<int>( ::wxConfigBase::Type_Unknown), 88},
};

sipVariableDef variables_wxConfigBase[] = {
    {PropertyVariable, sipName_VendorName, &methods_wxConfigBase[17], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Path, &methods_wxConfigBase[16], &methods_wxConfigBase[31], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NumberOfGroups, &methods_wxConfigBase[15], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NumberOfEntries, &methods_wxConfigBase[14], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NextGroup, &methods_wxConfigBase[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_NextEntry, &methods_wxConfigBase[12], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FirstGroup, &methods_wxConfigBase[11], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FirstEntry, &methods_wxConfigBase[10], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_AppName, &methods_wxConfigBase[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxConfigBase, "ConfigBase(appName=EmptyString, vendorName=EmptyString, localFilename=EmptyString, globalFilename=EmptyString, style=0)\n"
"\n"
"wxConfigBase defines the basic interface of all config classes.");


sipClassTypeDef sipTypeDef__core_wxConfigBase = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxConfigBase,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_ConfigBase,
        {0, 0, 1},
        38, methods_wxConfigBase,
        5, enummembers_wxConfigBase,
        9, variables_wxConfigBase,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxConfigBase,
    -1,
    -1,
    supers_wxConfigBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxConfigBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxConfigBase,
    cast_wxConfigBase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
